/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.meta;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.anotheria.asg.generator.GenerationOptions;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.IGenerateable;
import net.anotheria.asg.generator.meta.MetaDocument;
import net.anotheria.asg.generator.meta.ModuleParameter;
import net.anotheria.asg.generator.meta.StorageType;

public class MetaModule
implements IGenerateable {
    public static final MetaModule SHARED = new MetaModule("Shared");
    public static final MetaModule USER_SETTINGS = new MetaModule("UserSettings");
    private String name;
    private List<MetaDocument> documents;
    private List<String> listeners;
    private StorageType storageType;
    private String storageKey;
    private Map<String, ModuleParameter> parameters;
    private GenerationOptions moduleOptions;

    public MetaModule() {
        this(null);
    }

    public MetaModule(String name) {
        this.name = name;
        this.documents = new ArrayList<MetaDocument>();
        this.listeners = new ArrayList<String>();
        this.storageType = StorageType.CMS;
        this.parameters = new HashMap<String, ModuleParameter>();
    }

    public void addDocument(MetaDocument aDocument) {
        this.documents.add(aDocument);
        aDocument.setParentModule(this);
    }

    public boolean isEnabledByOptions(String key) {
        if (this.moduleOptions != null && this.moduleOptions.isEnabled(key)) {
            return true;
        }
        return GeneratorDataRegistry.getInstance().getOptions().isEnabled(key);
    }

    public String toString() {
        return "module " + this.name + " storage: " + this.storageType + " documents: " + this.documents;
    }

    public List<MetaDocument> getDocuments() {
        return this.documents;
    }

    public String getName() {
        return this.name;
    }

    public String getModuleClassName() {
        return "Module" + this.getName();
    }

    public String getFactoryClassName() {
        return this.getModuleClassName() + "Factory";
    }

    public void setDocuments(List<MetaDocument> list) {
        this.documents = list;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getId() {
        return this.getName().toLowerCase();
    }

    public MetaDocument getDocumentByName(String aName) {
        for (int i = 0; i < this.documents.size(); ++i) {
            MetaDocument d = this.documents.get(i);
            if (!d.getName().equals(aName)) continue;
            return d;
        }
        throw new RuntimeException("No such document: " + aName + " in module " + this.getName());
    }

    public boolean equals(Object o) {
        return o instanceof MetaModule ? ((MetaModule)o).name.equals(this.name) : false;
    }

    public int hashCode() {
        return this.name == null ? 42 : this.name.hashCode();
    }

    public List<String> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<String> listeners) {
        this.listeners = listeners;
    }

    public void addListener(String listenerClass) {
        this.listeners.add(listenerClass);
    }

    public void removeListener(String listenerClass) {
        this.listeners.remove(listenerClass);
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public void setStorageType(StorageType aStorageType) {
        this.storageType = aStorageType;
    }

    public String getStorageKey() {
        return this.storageKey;
    }

    public void setStorageKey(String aStorageKey) {
        this.storageKey = aStorageKey;
    }

    public void addModuleParameter(ModuleParameter p) {
        this.parameters.put(p.getName(), p);
    }

    public ModuleParameter getModuleParameter(String aName) {
        return this.parameters.get(aName);
    }

    public boolean isParameterEqual(String aName, String aValue) {
        ModuleParameter p = this.getModuleParameter(aName);
        return p == null ? false : p.getValue().equals(aValue);
    }

    public GenerationOptions getModuleOptions() {
        return this.moduleOptions;
    }

    public void setModuleOptions(GenerationOptions someModuleOptions) {
        this.moduleOptions = someModuleOptions;
    }

    public boolean isContainsAnyMultilingualDocs() {
        for (MetaDocument doc : this.documents) {
            if (!GeneratorDataRegistry.hasLanguageCopyMethods(doc)) continue;
            return true;
        }
        return false;
    }
}

