/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.meta;

import net.anotheria.asg.generator.meta.IMetaType;
import net.anotheria.asg.generator.meta.TypeFactory;
import net.anotheria.util.StringUtils;

public class MetaProperty
implements Cloneable {
    private Type type;
    private String name;
    private IMetaType metaType;
    private boolean multilingual;
    private boolean readonly;

    public MetaProperty(String aName, Type aType) {
        this(aName, aType, false);
    }

    public MetaProperty(String aName, Type aType, boolean aMultilingual) {
        this.name = aName;
        this.type = aType;
        this.metaType = TypeFactory.createType(aType);
        this.multilingual = aMultilingual;
        if (this.name == null) {
            throw new IllegalArgumentException("name is null");
        }
    }

    public MetaProperty(String aName, IMetaType aType) {
        this.name = aName;
        this.metaType = aType;
        this.multilingual = false;
        if (this.name == null) {
            throw new IllegalArgumentException("name is null");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getName(String language) {
        return language == null || !this.isMultilingual() ? this.getName() : this.name + StringUtils.capitalize((String)language);
    }

    public String getName(String addOn, String language) {
        return language == null ? this.getName() + addOn : this.name + addOn + StringUtils.capitalize((String)language);
    }

    public Type getType() {
        return this.type;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toNameConstant() {
        return "PROP_" + this.getNameConstantBase();
    }

    public String toNameConstant(String language) {
        return "PROP_" + this.getNameConstantBase() + "_" + language.toUpperCase();
    }

    private String getNameConstantBase() {
        Object ret = "";
        for (int i = 0; i < this.name.length(); ++i) {
            char c = this.name.charAt(i);
            if (Character.isLowerCase(c)) {
                ret = (String)ret + Character.toUpperCase(c);
            }
            if (Character.isUpperCase(c)) {
                ret = (String)ret + "_" + c;
            }
            if (Character.isLetter(c)) continue;
            ret = (String)ret + c;
        }
        return ret;
    }

    public String getAccesserName() {
        return Character.toUpperCase(this.name.charAt(0)) + this.name.substring(1);
    }

    public String getAccesserName(String language) {
        return language == null ? this.getAccesserName() : Character.toUpperCase(this.name.charAt(0)) + this.name.substring(1) + Character.toUpperCase(language.charAt(0)) + language.substring(1);
    }

    public String toJavaType() {
        return this.metaType.toJava();
    }

    public String toJavaErasedType() {
        return this.metaType.toJava();
    }

    public String toJavaObjectType() {
        return this.metaType.toJavaObject();
    }

    public String toPropertyGetter() {
        return this.metaType.toPropertyGetter();
    }

    public String toPropertySetter() {
        return this.metaType.toPropertySetter();
    }

    public String toBeanGetter() {
        return this.metaType.toBeanGetter(this.name);
    }

    public String toBeanGetter(String language) {
        return language == null ? this.toBeanGetter() : this.metaType.toBeanGetter(this.name) + StringUtils.capitalize((String)language);
    }

    public String toBeanSetter() {
        return this.metaType.toBeanSetter(this.name);
    }

    public String toBeanSetter(String language) {
        return language == null ? this.toBeanSetter() : this.metaType.toBeanSetter(this.name) + StringUtils.capitalize((String)language);
    }

    public String toString() {
        return this.type + " " + this.name;
    }

    public boolean isLinked() {
        return false;
    }

    public String toSetter(String language) {
        return "set" + this.getAccesserName(language);
    }

    public String toSetter() {
        return "set" + this.getAccesserName();
    }

    public String toGetter() {
        return "get" + this.getAccesserName();
    }

    public String toGetter(String language) {
        return "get" + this.getAccesserName(language);
    }

    public IMetaType getMetaType() {
        return this.metaType;
    }

    public boolean isMultilingual() {
        return this.multilingual;
    }

    public void setMultilingual(boolean multilingual) {
        this.multilingual = multilingual;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)"Can't happen");
        }
    }

    public static enum Type {
        STRING("string"),
        PASSWORD("password"),
        TEXT("text"),
        BOOLEAN("boolean"),
        INT("int"),
        LONG("long"),
        DOUBLE("double"),
        FLOAT("float"),
        LIST("list"),
        IMAGE("image");

        String name;

        private Type(String aName) {
            this.name = aName;
        }

        public String getName() {
            return this.name;
        }

        public static Type findTypeByName(String name) {
            for (Type t : Type.values()) {
                if (!t.getName().equals(name)) continue;
                return t;
            }
            return null;
        }

        public String toString() {
            return "Type{name='" + this.name + "'}";
        }
    }
}

