/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.meta;

import net.anotheria.asg.generator.meta.BooleanType;
import net.anotheria.asg.generator.meta.DoubleType;
import net.anotheria.asg.generator.meta.FloatType;
import net.anotheria.asg.generator.meta.IMetaType;
import net.anotheria.asg.generator.meta.ImageType;
import net.anotheria.asg.generator.meta.IntType;
import net.anotheria.asg.generator.meta.ListType;
import net.anotheria.asg.generator.meta.LongType;
import net.anotheria.asg.generator.meta.MetaProperty;
import net.anotheria.asg.generator.meta.PasswordType;
import net.anotheria.asg.generator.meta.StringType;

public class TypeFactory {
    private TypeFactory() {
    }

    public static final IMetaType createType(MetaProperty.Type type) {
        switch (type) {
            case STRING: {
                return new StringType();
            }
            case PASSWORD: {
                return new PasswordType();
            }
            case INT: {
                return new IntType();
            }
            case LONG: {
                return new LongType();
            }
            case LIST: {
                return new ListType();
            }
            case TEXT: {
                return new StringType();
            }
            case BOOLEAN: {
                return new BooleanType();
            }
            case DOUBLE: {
                return new DoubleType();
            }
            case FLOAT: {
                return new FloatType();
            }
            case IMAGE: {
                return new ImageType();
            }
        }
        throw new RuntimeException("Unsupported type: " + type);
    }
}

