/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.model;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.asg.generator.AbstractGenerator;
import net.anotheria.asg.generator.Context;
import net.anotheria.asg.generator.GeneratedClass;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.meta.MetaContainerProperty;
import net.anotheria.asg.generator.meta.MetaDocument;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.asg.generator.meta.MetaProperty;
import net.anotheria.asg.generator.model.DataFacadeGenerator;
import net.anotheria.util.StringUtils;

public abstract class AbstractDataObjectGenerator
extends AbstractGenerator {
    protected abstract String getDataObjectImplName(MetaDocument var1);

    protected String getPackageName(MetaDocument doc) {
        return GeneratorDataRegistry.getInstance().getContext().getDataPackageName(doc);
    }

    public static String getPackageName(MetaModule module) {
        return GeneratorDataRegistry.getInstance().getContext().getPackageName(module);
    }

    protected void generateGetFootprintMethod(MetaDocument doc) {
        this.appendString("public String getFootprint(){");
        this.increaseIdent();
        this.appendStatement("StringBuilder footprint = new StringBuilder()");
        this.generatePropertyListFootprint(doc.getProperties());
        this.generatePropertyListFootprint(doc.getLinks());
        this.appendStatement("return MD5Util.getMD5Hash(footprint)");
        this.append(this.closeBlock());
    }

    protected void generatePropertyListFootprint(List<MetaProperty> properties) {
        Context c = GeneratorDataRegistry.getInstance().getContext();
        for (MetaProperty p : properties) {
            if (c.areLanguagesSupported() && p.isMultilingual()) {
                for (String l : c.getLanguages()) {
                    this.appendStatement("footprint.append(get" + p.getAccesserName(l) + "())");
                }
                continue;
            }
            this.appendStatement("footprint.append(get" + p.getAccesserName() + "())");
        }
    }

    protected void generateCompareMethod(MetaDocument doc) {
        this.appendString("public int compareTo(" + doc.getName() + " comparable){");
        this.appendIncreasedStatement("return compareTo(comparable, " + AbstractDataObjectGenerator.getSortTypeName(doc) + ".SORT_BY_DEFAULT)");
        this.appendString("}");
        AbstractDataObjectGenerator.emptyline();
        this.appendString("public int compareTo(IComparable anotherComparable, int method){");
        this.increaseIdent();
        this.appendStatement(this.getDataObjectImplName(doc) + " anotherDoc = (" + this.getDataObjectImplName(doc) + ") anotherComparable");
        this.appendString("switch(method){");
        this.increaseIdent();
        List<MetaProperty> properties = this.extractSortableProperties(doc);
        for (int i = 0; i < properties.size(); ++i) {
            MetaProperty p = properties.get(i);
            String caseDecl = AbstractDataObjectGenerator.getSortTypeName(doc) + ".SORT_BY_" + p.getName().toUpperCase();
            this.appendString("case " + caseDecl + ":");
            String type2compare = null;
            type2compare = StringUtils.capitalize((String)p.toJavaType());
            String retDecl = "return BasicComparable.compare" + type2compare;
            retDecl = retDecl + "(get" + p.getAccesserName() + "(), anotherDoc.get" + p.getAccesserName() + "())";
            this.appendIncreasedStatement(retDecl);
        }
        this.appendString("default:");
        this.appendIncreasedStatement("throw new RuntimeException(\"Sort method \"+method+\" is not supported.\")");
        this.append(this.closeBlock());
        this.append(this.closeBlock());
    }

    protected List<MetaProperty> extractSortableProperties(MetaDocument doc) {
        ArrayList<MetaProperty> properties = new ArrayList<MetaProperty>();
        properties.add(new MetaProperty("id", MetaProperty.Type.STRING));
        properties.addAll(doc.getProperties());
        properties.addAll(doc.getLinks());
        for (int i = 0; i < properties.size(); ++i) {
            MetaProperty p = (MetaProperty)properties.get(i);
            if (!(p instanceof MetaContainerProperty)) continue;
            properties.remove(p);
            --i;
        }
        return properties;
    }

    public static String getSortTypeName(MetaDocument doc) {
        return doc.getName() + "SortType";
    }

    public static String getSortTypeImport(MetaDocument doc) {
        return GeneratorDataRegistry.getInstance().getContext().getDataPackageName(doc) + "." + AbstractDataObjectGenerator.getSortTypeName(doc);
    }

    protected final void generateDefNameMethod(MetaDocument doc) {
        this.appendString("public String getDefinedName(){");
        this.increaseIdent();
        this.appendStatement("return " + this.quote(doc.getName()));
        this.append(this.closeBlock());
    }

    protected final void generateDefParentNameMethod(MetaDocument doc) {
        this.appendString("public String getDefinedParentName(){");
        this.increaseIdent();
        this.appendStatement("return " + this.quote(doc.getParentModule().getName()));
        this.append(this.closeBlock());
    }

    public String getDocumentBuilderName(MetaDocument doc) {
        return doc.getName() + "Builder";
    }

    protected GeneratedClass generateDocumentFactory(MetaDocument doc) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        clazz.setPackageName(this.getPackageName(doc));
        clazz.setName(this.getDocumentFactoryName(doc));
        this.startClassBody();
        this.appendString("public static " + doc.getName() + " create" + doc.getName() + "(" + doc.getName() + " template){");
        this.increaseIdent();
        this.appendStatement("return new " + this.getDataObjectImplName(doc) + "((" + this.getDataObjectImplName(doc) + ")template)");
        this.append(this.closeBlock());
        AbstractDataObjectGenerator.emptyline();
        this.appendString("public static " + doc.getName() + " create" + doc.getName() + "(){");
        this.increaseIdent();
        this.appendStatement("return new " + this.getDataObjectImplName(doc) + "(\"\")");
        this.append(this.closeBlock());
        AbstractDataObjectGenerator.emptyline();
        this.appendString("static " + doc.getName() + " create" + doc.getName() + "(" + this.getDocumentBuilderName(doc) + " builder){");
        this.increaseIdent();
        this.appendStatement("return new " + this.getDataObjectImplName(doc) + "(builder)");
        this.append(this.closeBlock());
        AbstractDataObjectGenerator.emptyline();
        this.appendString("public static " + doc.getName() + " create" + doc.getName() + "ForImport(String anId){");
        this.increaseIdent();
        this.appendStatement("return new " + this.getDataObjectImplName(doc) + "(anId)");
        this.append(this.closeBlock());
        AbstractDataObjectGenerator.emptyline();
        this.appendComment("For internal use only!");
        this.appendString("public static " + doc.getName() + " create" + doc.getName() + "(String anId){");
        this.increaseIdent();
        this.appendStatement("return new " + this.getDataObjectImplName(doc) + "(anId)");
        this.append(this.closeBlock());
        return clazz;
    }

    private String getDocumentFactoryName(MetaDocument doc) {
        return DataFacadeGenerator.getDocumentFactoryName(doc);
    }

    protected void generateEqualsMethod(MetaDocument doc) {
        this.appendString("public boolean equals(Object o){");
        this.increaseIdent();
        this.appendStatement("return o == this || ((o instanceof " + this.getDataObjectImplName(doc) + ") && ((" + this.getDataObjectImplName(doc) + ")o).getId().equals(getId()))");
        this.append(this.closeBlock());
    }
}

