/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.model;

import net.anotheria.anoprise.metafactory.ServiceFactory;
import net.anotheria.asg.generator.AbstractGenerator;
import net.anotheria.asg.generator.CommentGenerator;
import net.anotheria.asg.generator.GeneratedClass;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.asg.generator.model.ServiceGenerator;
import net.anotheria.moskito.core.dynamic.MoskitoInvokationProxy;
import net.anotheria.moskito.core.predefined.ServiceStatsCallHandler;
import net.anotheria.moskito.core.predefined.ServiceStatsFactory;

public class AbstractServiceGenerator
extends AbstractGenerator {
    public static String getInterfaceName(MetaModule m) {
        return "I" + AbstractServiceGenerator.getServiceName(m);
    }

    public static final String getServiceName(MetaModule m) {
        return m.getName() + "Service";
    }

    public String getFactoryName(MetaModule m) {
        return AbstractServiceGenerator.getServiceName(m) + "Factory";
    }

    public String getImplementationName(MetaModule m) {
        return AbstractServiceGenerator.getServiceName(m) + "Impl";
    }

    protected String getPackageName(MetaModule module) {
        return GeneratorDataRegistry.getInstance().getContext().getServicePackageName(module);
    }

    protected void addAdditionalFactoryImports(GeneratedClass clazz, MetaModule module) {
    }

    protected GeneratedClass generateFactory(MetaModule module) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        clazz.setTypeComment(CommentGenerator.generateJavaTypeComment(this.getFactoryName(module), "The factory for the " + AbstractServiceGenerator.getInterfaceName(module) + " implementation."));
        clazz.setPackageName(this.getPackageName(module));
        clazz.addImport("java.util.concurrent.atomic.AtomicInteger");
        clazz.addImport(MoskitoInvokationProxy.class);
        clazz.addImport(ServiceStatsCallHandler.class);
        clazz.addImport(ServiceStatsFactory.class);
        clazz.addImport("net.anotheria.asg.service.ASGService");
        this.addAdditionalFactoryImports(clazz, module);
        clazz.setName(this.getFactoryName(module));
        clazz.addImport(ServiceFactory.class);
        clazz.addInterface("ServiceFactory<" + ServiceGenerator.getInterfaceName(module) + ">");
        this.startClassBody();
        this.appendStatement("private static AtomicInteger instanceCounter = new AtomicInteger(0)");
        this.appendStatement("private static " + AbstractServiceGenerator.getInterfaceName(module) + " defaultInstance = create" + AbstractServiceGenerator.getServiceName(module) + "()");
        AbstractServiceGenerator.emptyline();
        this.appendString("public " + AbstractServiceGenerator.getInterfaceName(module) + " create(){");
        this.increaseIdent();
        this.appendStatement("return create" + AbstractServiceGenerator.getServiceName(module) + "()");
        this.closeBlockNEW();
        AbstractServiceGenerator.emptyline();
        this.appendString("public static " + AbstractServiceGenerator.getInterfaceName(module) + " create" + AbstractServiceGenerator.getServiceName(module) + "(){");
        this.increaseIdent();
        this.appendString("MoskitoInvokationProxy proxy = new MoskitoInvokationProxy(");
        this.increaseIdent();
        this.appendString("createInstance(),");
        this.appendString("new ServiceStatsCallHandler(),");
        this.appendString("new ServiceStatsFactory(),");
        this.appendString("\"" + AbstractServiceGenerator.getInterfaceName(module) + "-\"+instanceCounter.incrementAndGet(),");
        this.appendString(this.quote("service"), ",");
        this.appendString(this.quote(this.getMoskitoSubsystem()), ",");
        this.appendString(this.getSupportedInterfacesList(module));
        this.decreaseIdent();
        this.appendString(");");
        this.appendStatement("return (" + AbstractServiceGenerator.getInterfaceName(module) + ") proxy.createProxy()");
        this.closeBlockNEW();
        AbstractServiceGenerator.emptyline();
        this.appendString("private static " + AbstractServiceGenerator.getInterfaceName(module) + " createInstance(){");
        this.increaseIdent();
        this.appendString("return " + this.getImplementationName(module) + ".getInstance();");
        this.append(this.closeBlock());
        AbstractServiceGenerator.emptyline();
        this.appendString("static " + AbstractServiceGenerator.getInterfaceName(module) + " getDefaultInstance(){");
        this.increaseIdent();
        this.appendString("return defaultInstance;");
        this.closeBlockNEW();
        return clazz;
    }

    protected String getSupportedInterfacesList(MetaModule module) {
        return AbstractServiceGenerator.getInterfaceName(module) + ".class, ASGService.class";
    }

    protected String getExceptionName(MetaModule module) {
        return ServiceGenerator.getExceptionName(module);
    }

    protected String getMoskitoSubsystem() {
        return "asg";
    }
}

