/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.model;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.asg.data.Builder;
import net.anotheria.asg.generator.Context;
import net.anotheria.asg.generator.FileEntry;
import net.anotheria.asg.generator.GeneratedClass;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.IGenerateable;
import net.anotheria.asg.generator.IGenerator;
import net.anotheria.asg.generator.TypeOfClass;
import net.anotheria.asg.generator.meta.MetaContainerProperty;
import net.anotheria.asg.generator.meta.MetaDocument;
import net.anotheria.asg.generator.meta.MetaGenericProperty;
import net.anotheria.asg.generator.meta.MetaListProperty;
import net.anotheria.asg.generator.meta.MetaProperty;
import net.anotheria.asg.generator.meta.MetaTableProperty;
import net.anotheria.asg.generator.model.AbstractDataObjectGenerator;
import net.anotheria.util.StringUtils;

public class DataFacadeGenerator
extends AbstractDataObjectGenerator
implements IGenerator {
    public static final String PROPERTY_DECLARATION = "String ";
    private final MetaProperty id = new MetaProperty("id", MetaProperty.Type.STRING);

    @Override
    public List<FileEntry> generate(IGenerateable gdoc) {
        MetaDocument doc = (MetaDocument)gdoc;
        ArrayList<FileEntry> ret = new ArrayList<FileEntry>();
        ret.add(new FileEntry(this.generateDocument(doc)));
        ret.add(new FileEntry(this.generateSortType(doc)));
        ret.add(new FileEntry(this.generateXMLHelper(doc)));
        ret.add(new FileEntry(this.generateBuilder(doc)));
        return ret;
    }

    public String getDocumentName(MetaDocument doc) {
        return doc.getName();
    }

    public static String getSortTypeName(MetaDocument doc) {
        return doc.getName() + "SortType";
    }

    public static String getXMLHelperName(MetaDocument doc) {
        return doc.getName() + "XMLHelper";
    }

    private GeneratedClass generateBuilder(MetaDocument doc) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        clazz.setPackageName(this.getPackageName(doc));
        clazz.setName(this.getDocumentBuilderName(doc));
        clazz.addInterface("Builder<" + doc.getName() + ">");
        clazz.addImport(Builder.class);
        this.startClassBody();
        for (int i = 0; i < doc.getProperties().size(); ++i) {
            if (!(doc.getProperties().get(i) instanceof MetaContainerProperty)) continue;
            clazz.addImport("java.util.List");
            break;
        }
        for (MetaProperty p : doc.getProperties()) {
            this.appendStatement("protected " + p.toJavaType() + " " + p.getName());
        }
        for (MetaProperty p : doc.getLinks()) {
            this.appendStatement("protected " + p.toJavaType() + " " + p.getName());
        }
        DataFacadeGenerator.emptyline();
        this.generateBuilderPropertyAccessMethods(doc);
        DataFacadeGenerator.emptyline();
        this.appendString("public " + doc.getName() + " build(){");
        this.increaseIdent();
        this.appendStatement("return " + doc.getName() + "Factory.create" + doc.getName() + "(this)");
        this.closeBlockNEW();
        return clazz;
    }

    private GeneratedClass generateSortType(MetaDocument doc) {
        MetaProperty p;
        int i;
        List<MetaProperty> properties = this.extractSortableProperties(doc);
        if (properties.size() == 0) {
            return null;
        }
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        clazz.setPackageName(this.getPackageName(doc));
        clazz.addImport("net.anotheria.util.sorter.SortType");
        clazz.setName(DataFacadeGenerator.getSortTypeName(doc));
        clazz.setParent("SortType");
        this.startClassBody();
        int lastIndex = 1;
        for (i = 0; i < properties.size(); ++i) {
            p = properties.get(i);
            this.appendStatement("public static final int SORT_BY_" + p.getName().toUpperCase() + " = " + lastIndex++);
        }
        this.appendStatement("public static final int SORT_BY_DEFAULT = SORT_BY_ID");
        DataFacadeGenerator.emptyline();
        this.appendString("public " + DataFacadeGenerator.getSortTypeName(doc) + "(){");
        this.increaseIdent();
        this.appendString("super(SORT_BY_DEFAULT);");
        this.closeBlockNEW();
        DataFacadeGenerator.emptyline();
        this.appendString("public " + DataFacadeGenerator.getSortTypeName(doc) + "(int method){");
        this.increaseIdent();
        this.appendString("super(method);");
        this.closeBlockNEW();
        DataFacadeGenerator.emptyline();
        this.appendString("public " + DataFacadeGenerator.getSortTypeName(doc) + "(int method, boolean order){");
        this.increaseIdent();
        this.appendString("super(method, order);");
        this.closeBlockNEW();
        DataFacadeGenerator.emptyline();
        this.appendString("public static int name2method(String name){");
        this.increaseIdent();
        for (i = 0; i < properties.size(); ++i) {
            p = properties.get(i);
            this.appendString("if (" + this.quote(p.getName()) + ".equals(name))");
            this.appendIncreasedStatement("return SORT_BY_" + p.getName().toUpperCase());
        }
        this.appendStatement("throw new RuntimeException(" + this.quote("Unknown sort type name: ") + "+name)");
        this.closeBlockNEW();
        return clazz;
    }

    private GeneratedClass generateXMLHelper(MetaDocument doc) {
        int i;
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        clazz.setPackageName(this.getPackageName(doc));
        clazz.addImport("net.anotheria.util.xml.XMLNode");
        clazz.addImport("net.anotheria.util.xml.XMLAttribute");
        clazz.addImport("net.anotheria.asg.data.XMLHelper");
        clazz.addImport("net.anotheria.asg.data.MultilingualObject");
        for (i = 0; i < doc.getProperties().size(); ++i) {
            if (!(doc.getProperties().get(i) instanceof MetaContainerProperty)) continue;
            clazz.addImport("java.util.List");
            break;
        }
        for (i = 0; i < doc.getProperties().size(); ++i) {
            if (!(doc.getProperties().get(i) instanceof MetaTableProperty)) continue;
            clazz.addImport("java.util.List");
            break;
        }
        clazz.setName(DataFacadeGenerator.getXMLHelperName(doc));
        this.startClassBody();
        this.increaseIdent();
        if (GeneratorDataRegistry.getInstance().getContext().areLanguagesSupported()) {
            StringBuilder langArray = new StringBuilder();
            for (String l : GeneratorDataRegistry.getInstance().getContext().getLanguages()) {
                if (langArray.length() > 0) {
                    langArray.append(",");
                }
                langArray.append(this.quote(l));
            }
            this.appendStatement("public static final String[] LANGUAGES = new String[]{", langArray.toString(), "}");
        }
        if (GeneratorDataRegistry.getInstance().getContext().areLanguagesSupported()) {
            this.appendString("private static XMLNode _toXML(" + doc.getName() + " object, String[] languages){");
        } else {
            this.appendString("private static XMLNode _toXML(" + doc.getName() + " object){");
        }
        this.increaseIdent();
        this.appendStatement("XMLNode ret = new XMLNode(" + this.quote(doc.getName()) + ")");
        this.appendStatement("ret.addAttribute(new XMLAttribute(" + this.quote("id") + ", object.getId()))");
        DataFacadeGenerator.emptyline();
        for (MetaProperty p : doc.getProperties()) {
            this.generatePropertyToXMLMethod(p);
        }
        DataFacadeGenerator.emptyline();
        for (MetaProperty p : doc.getLinks()) {
            this.generatePropertyToXMLMethod(p);
        }
        DataFacadeGenerator.emptyline();
        if (GeneratorDataRegistry.getInstance().getContext().areLanguagesSupported()) {
            this.appendString("if(object instanceof MultilingualObject){");
            this.increaseIdent();
            this.appendStatement("MultilingualObject multilangDoc = (MultilingualObject) object");
            this.appendStatement("ret.addChildNode(XMLHelper.createXMLNodeForBooleanValue(" + this.quote("multilingualDisabled") + ", null, multilangDoc.isMultilingualDisabledInstance()))");
            this.closeBlockNEW();
        }
        this.appendStatement("return ret");
        this.closeBlockNEW();
        DataFacadeGenerator.emptyline();
        this.appendString("public static XMLNode toXML(" + doc.getName() + " object){");
        this.increaseIdent();
        if (GeneratorDataRegistry.getInstance().getContext().areLanguagesSupported()) {
            this.appendStatement("return _toXML(object, LANGUAGES)");
        } else {
            this.appendStatement("return _toXML(object)");
        }
        this.closeBlockNEW();
        DataFacadeGenerator.emptyline();
        if (GeneratorDataRegistry.getInstance().getContext().areLanguagesSupported()) {
            this.appendString("public static XMLNode toXML(" + doc.getName() + " object, String... languages){");
            this.increaseIdent();
            this.appendString("if (languages==null || languages.length==0)");
            this.appendIncreasedStatement("return toXML(object)");
            this.appendStatement("return _toXML(object, languages)");
            this.closeBlockNEW();
            DataFacadeGenerator.emptyline();
        }
        this.appendString("public static " + doc.getName() + " fromXML(XMLNode node){");
        this.increaseIdent();
        this.appendStatement("return null");
        this.closeBlockNEW();
        DataFacadeGenerator.emptyline();
        return clazz;
    }

    private void generatePropertyToXMLMethod(MetaProperty p) {
        if (p instanceof MetaTableProperty) {
            this.generateTablePropertyGetterMethods((MetaTableProperty)p);
            return;
        }
        if (p instanceof MetaListProperty) {
            this.generateListPropertyToXMLMethods((MetaListProperty)p);
            return;
        }
        if (GeneratorDataRegistry.getInstance().getContext().areLanguagesSupported() && p.isMultilingual()) {
            this.generatePropertyToXMLMethodMultilingual(p);
            return;
        }
        this.appendStatement("ret.addChildNode(XMLHelper.createXMLNodeFor" + StringUtils.capitalize((String)p.getType().getName()) + "Value(" + this.quote(p.getName()) + ", null, object.get" + p.getAccesserName() + "()\t))");
    }

    private void generatePropertyToXMLMethodMultilingual(MetaProperty p) {
        Object callArr = "";
        for (String l : GeneratorDataRegistry.getInstance().getContext().getLanguages()) {
            if (((String)callArr).length() > 0) {
                callArr = (String)callArr + ", ";
            }
            callArr = (String)callArr + "object.get" + p.getAccesserName(l) + "()";
        }
        this.appendStatement("ret.addChildNode(XMLHelper.createXMLNodeFor" + StringUtils.capitalize((String)p.getType().getName()) + "Value(" + this.quote(p.getName()) + ", languages , " + (String)callArr + "\t))");
    }

    private void generateListPropertyToXMLMethods(MetaListProperty p) {
        this.appendStatement("ret.addChildNode(XMLHelper.createXMLNodeForListValue(" + this.quote(p.getName()) + ", " + this.quote(p.getContainedProperty().getType().getName()) + ", object.get" + p.getAccesserName() + "()))");
    }

    private GeneratedClass generateDocument(MetaDocument doc) {
        int i;
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        clazz.setPackageName(this.getPackageName(doc));
        clazz.addImport("net.anotheria.asg.data.DataObject");
        for (i = 0; i < doc.getProperties().size(); ++i) {
            if (!(doc.getProperties().get(i) instanceof MetaContainerProperty)) continue;
            clazz.addImport("java.util.List");
            break;
        }
        for (i = 0; i < doc.getProperties().size(); ++i) {
            if (!(doc.getProperties().get(i) instanceof MetaTableProperty)) continue;
            clazz.addImport("java.util.List");
            break;
        }
        clazz.setType(TypeOfClass.INTERFACE);
        clazz.setName(doc.getName());
        clazz.setParent("DataObject");
        if (doc.isComparable()) {
            clazz.addImport("net.anotheria.util.sorter.IComparable");
            clazz.setParent(clazz.getParent() + ", IComparable ");
        }
        this.startClassBody();
        this.generatePropertyConstants(doc);
        DataFacadeGenerator.emptyline();
        this.generatePropertyAccessMethods(doc);
        DataFacadeGenerator.emptyline();
        this.generateAdditionalMethods(doc);
        DataFacadeGenerator.emptyline();
        if (DataFacadeGenerator.hasLanguageCopyMethods(doc)) {
            this.generateLanguageCopyMethods(doc);
            DataFacadeGenerator.emptyline();
        }
        return clazz;
    }

    public static final boolean hasLanguageCopyMethods(MetaDocument doc) {
        return GeneratorDataRegistry.hasLanguageCopyMethods(doc);
    }

    public static final String getCopyMethodName() {
        return DataFacadeGenerator.getCopyMethodName("LANG", "LANG");
    }

    public static final String getCopyMethodName(String sourceLange, String targetLang) {
        return "copy" + sourceLange.toUpperCase() + "2" + targetLang.toUpperCase();
    }

    private void generateLanguageCopyMethods(MetaDocument doc) {
        this.appendComment("Copies all multilingual properties from source language to destination language ");
        this.appendString("void " + DataFacadeGenerator.getCopyMethodName() + "(String sourceLanguge, String destLanguage);");
        DataFacadeGenerator.emptyline();
        for (String srclang : GeneratorDataRegistry.getInstance().getContext().getLanguages()) {
            for (String targetlang : GeneratorDataRegistry.getInstance().getContext().getLanguages()) {
                if (srclang.equals(targetlang)) continue;
                this.appendComment("Copies all multilingual properties from language " + srclang + " to language " + targetlang);
                this.appendString("void " + DataFacadeGenerator.getCopyMethodName(srclang, targetlang) + "();");
                DataFacadeGenerator.emptyline();
            }
        }
    }

    private void generatePropertyConstants(MetaDocument doc) {
        this.generatePropertyConstant(this.id);
        this.generatePropertyConstants(doc.getProperties());
        this.generatePropertyConstants(doc.getLinks());
    }

    private void generatePropertyConstants(List<MetaProperty> propertyList) {
        for (int i = 0; i < propertyList.size(); ++i) {
            MetaProperty p = propertyList.get(i);
            if (p instanceof MetaTableProperty) {
                List<MetaProperty> columns = ((MetaTableProperty)p).getColumns();
                for (int t = 0; t < columns.size(); ++t) {
                    this.generatePropertyConstant(columns.get(t));
                }
                continue;
            }
            this.generatePropertyConstant(p);
        }
    }

    private void generatePropertyConstant(MetaProperty p) {
        if (GeneratorDataRegistry.getInstance().getContext().areLanguagesSupported() && p.isMultilingual()) {
            for (String l : GeneratorDataRegistry.getInstance().getContext().getLanguages()) {
                Object decl = PROPERTY_DECLARATION;
                decl = (String)decl + p.toNameConstant(l);
                decl = (String)decl + "\t= \"" + p.getName() + "_" + l + "\"";
                this.appendComment("Constant property name for \"" + p.getName() + "\" and domain \"" + l + "\" for internal storage and queries.");
                this.appendStatement(new String[]{decl});
            }
        } else {
            Object r = PROPERTY_DECLARATION;
            r = (String)r + p.toNameConstant();
            r = (String)r + "\t= \"" + p.getName() + "\"";
            this.appendComment("Constant property name for \"" + p.getName() + "\" for internal storage and queries.");
            this.appendStatement(new String[]{r});
        }
    }

    private void generatePropertyAccessMethods(MetaDocument doc) {
        this.generatePropertyAccessMethods(doc.getProperties());
        this.generatePropertyAccessMethods(doc.getLinks());
    }

    private void generatePropertyAccessMethods(List<MetaProperty> properties) {
        for (int i = 0; i < properties.size(); ++i) {
            MetaProperty p = properties.get(i);
            this.generatePropertyGetterMethod(p);
            DataFacadeGenerator.emptyline();
            if (p.isReadonly()) continue;
            this.generatePropertySetterMethod(p);
            DataFacadeGenerator.emptyline();
        }
    }

    private void generateBuilderPropertyAccessMethods(MetaDocument doc) {
        this.generateBuilderPropertyAccessMethods(doc, doc.getProperties());
        this.generateBuilderPropertyAccessMethods(doc, doc.getLinks());
    }

    private void generateBuilderPropertyAccessMethods(MetaDocument doc, List<MetaProperty> properties) {
        for (int i = 0; i < properties.size(); ++i) {
            MetaProperty p = properties.get(i);
            if (p.isReadonly()) continue;
            this.generateBuilderPropertySetterMethod(doc, p);
            DataFacadeGenerator.emptyline();
        }
    }

    private void generatePropertyGetterMethod(MetaProperty p) {
        if (p instanceof MetaTableProperty) {
            this.generateTablePropertyGetterMethods((MetaTableProperty)p);
            return;
        }
        if (p instanceof MetaListProperty) {
            this.generateListPropertyGetterMethods((MetaListProperty)p);
            return;
        }
        if (GeneratorDataRegistry.getInstance().getContext().areLanguagesSupported() && p.isMultilingual()) {
            this.generatePropertyGetterMethodMultilingual(p);
            return;
        }
        this.appendComment("Returns the value of the " + p.getName() + " attribute.");
        this.appendString(p.toJavaType() + " get" + p.getAccesserName() + "();");
    }

    private void generateBuilderPropertyGetterMethod(MetaProperty p) {
        if (p instanceof MetaTableProperty) {
            this.generateBuilderTablePropertyGetterMethods((MetaTableProperty)p);
            return;
        }
        if (p instanceof MetaListProperty) {
            this.generateBuilderListPropertyGetterMethods((MetaListProperty)p);
            return;
        }
        this.appendComment("Returns the value of the " + p.getName() + " attribute.");
        this.appendString(p.toJavaType() + " get" + p.getAccesserName() + "(){");
        this.appendIncreasedStatement("return " + p.getName());
        this.appendString("}");
    }

    private void generatePropertyGetterMethodMultilingual(MetaProperty p) {
        for (String l : GeneratorDataRegistry.getInstance().getContext().getLanguages()) {
            this.appendComment("Returns the value of the " + p.getName() + " attribute in the \"" + l + "\" domain.");
            this.appendString(p.toJavaType() + " get" + p.getAccesserName(l) + "();");
            DataFacadeGenerator.emptyline();
        }
        this.appendComment("Returns the current value of the " + p.getName() + " attribute.\nCurrent means in the currently selected domain.");
        this.appendString(p.toJavaType() + " get" + p.getAccesserName() + "();");
        DataFacadeGenerator.emptyline();
    }

    private void generateBuilderListPropertyGetterMethods(MetaListProperty p) {
        MetaGenericProperty tmp = new MetaGenericProperty(p.getName(), MetaProperty.Type.LIST, p.getContainedProperty());
        this.generateBuilderPropertyGetterMethod(tmp);
    }

    private void generateListPropertyGetterMethods(MetaListProperty p) {
        MetaGenericProperty tmp = new MetaGenericProperty(p.getName(), MetaProperty.Type.LIST, p.getContainedProperty());
        if (p.isMultilingual()) {
            tmp.setMultilingual(true);
        }
        this.generatePropertyGetterMethod(tmp);
    }

    private void generateBuilderTablePropertyGetterMethods(MetaTableProperty p) {
        List<MetaProperty> columns = p.getColumns();
        for (int t = 0; t < columns.size(); ++t) {
            this.generateBuilderPropertyGetterMethod(columns.get(t));
        }
    }

    private void generateTablePropertyGetterMethods(MetaTableProperty p) {
        List<MetaProperty> columns = p.getColumns();
        for (int t = 0; t < columns.size(); ++t) {
            this.generatePropertyGetterMethod(columns.get(t));
        }
    }

    private void generatePropertySetterMethod(MetaProperty p) {
        if (p instanceof MetaTableProperty) {
            this.generateTablePropertySetterMethods((MetaTableProperty)p);
            return;
        }
        if (p instanceof MetaListProperty) {
            this.generateListPropertySetterMethods((MetaListProperty)p);
            return;
        }
        if (GeneratorDataRegistry.getInstance().getContext().areLanguagesSupported() && p.isMultilingual()) {
            this.generatePropertySetterMethodMultilingual(p);
            return;
        }
        this.appendComment("Sets the value of the " + p.getName() + " attribute.");
        this.appendString("void set" + p.getAccesserName() + "(" + p.toJavaType() + " value);");
    }

    private void generateBuilderPropertySetterMethod(MetaDocument doc, MetaProperty p) {
        if (p instanceof MetaTableProperty) {
            this.generateBuilderTablePropertySetterMethods(doc, (MetaTableProperty)p);
            return;
        }
        if (p instanceof MetaListProperty) {
            this.generateBuilderListPropertySetterMethods(doc, (MetaListProperty)p);
            return;
        }
        this.appendComment("Sets the value of the " + p.getName() + " attribute.");
        this.appendString("public " + this.getDocumentBuilderName(doc) + " " + p.getName() + "(" + p.toJavaType() + " aValue){");
        this.increaseIdent();
        this.appendStatement(p.getName(), " = ", "aValue");
        this.appendStatement("return this");
        this.closeBlockNEW();
    }

    private void generatePropertySetterMethodMultilingual(MetaProperty p) {
        for (String l : GeneratorDataRegistry.getInstance().getContext().getLanguages()) {
            this.appendComment("Sets the value of the " + p.getName() + " attribute in the domain \"" + l + "\"");
            this.appendString("void set" + p.getAccesserName(l) + "(" + p.toJavaType() + " value);");
            DataFacadeGenerator.emptyline();
        }
        this.appendComment("Sets the value of the " + p.getName() + " attribute in the current domain. Current means in the currently selected domain.");
        this.appendString("void set" + p.getAccesserName() + "(" + p.toJavaType() + " value);");
    }

    private void generateListPropertySetterMethods(MetaListProperty p) {
        MetaGenericProperty tmp = new MetaGenericProperty(p.getName(), MetaProperty.Type.LIST, p.getContainedProperty());
        if (p.isMultilingual()) {
            tmp.setMultilingual(true);
        }
        this.generatePropertySetterMethod(tmp);
    }

    private void generateBuilderListPropertySetterMethods(MetaDocument doc, MetaListProperty p) {
        MetaGenericProperty tmp = new MetaGenericProperty(p.getName(), MetaProperty.Type.LIST, p.getContainedProperty());
        this.generateBuilderPropertySetterMethod(doc, tmp);
    }

    private void generateTablePropertySetterMethods(MetaTableProperty p) {
        List<MetaProperty> columns = p.getColumns();
        for (int t = 0; t < columns.size(); ++t) {
            this.generatePropertySetterMethod(columns.get(t));
        }
    }

    private void generateBuilderTablePropertySetterMethods(MetaDocument doc, MetaTableProperty p) {
        List<MetaProperty> columns = p.getColumns();
        for (int t = 0; t < columns.size(); ++t) {
            this.generateBuilderPropertySetterMethod(doc, columns.get(t));
        }
    }

    public static final String getDocumentImport(MetaDocument doc) {
        return GeneratorDataRegistry.getInstance().getContext().getDataPackageName(doc) + "." + doc.getName();
    }

    public static final String getXMLHelperImport(Context context, MetaDocument doc) {
        return context.getDataPackageName(doc) + "." + DataFacadeGenerator.getXMLHelperName(doc);
    }

    private void generateAdditionalMethods(MetaDocument doc) {
        List<MetaProperty> properties = doc.getProperties();
        for (MetaProperty p : properties) {
            if (p instanceof MetaContainerProperty) {
                this.generateContainerMethods((MetaContainerProperty)p);
            }
            if (p instanceof MetaTableProperty) {
                this.generateTableMethods((MetaTableProperty)p);
            }
            if (!(p instanceof MetaListProperty)) continue;
            this.generateListMethods((MetaListProperty)p);
        }
    }

    private void generateContainerMethods(MetaContainerProperty container) {
        if (container.isMultilingual()) {
            this.generateContainerMethodsMultilingual(container);
        }
        this.appendComment("Returns the number of elements in the \"" + container.getName() + "\" container");
        this.appendString("int " + DataFacadeGenerator.getContainerSizeGetterName(container) + "();");
        DataFacadeGenerator.emptyline();
    }

    private void generateContainerMethodsMultilingual(MetaContainerProperty container) {
        for (String l : GeneratorDataRegistry.getInstance().getContext().getLanguages()) {
            this.appendComment("Returns the number of elements in the \"" + container.getName() + "\" container");
            this.appendString("int " + DataFacadeGenerator.getContainerSizeGetterName(container, l) + "();");
            DataFacadeGenerator.emptyline();
        }
    }

    private void generateListMethods(MetaListProperty list) {
        if (list.isMultilingual()) {
            this.generateListMethodsMultilingual(list);
        }
        MetaProperty c = list.getContainedProperty();
        this.appendComment("Adds a new element to the list.");
        String decl = "void " + DataFacadeGenerator.getContainerEntryAdderName(list) + "(";
        decl = decl + c.toJavaType() + " " + c.getName();
        decl = decl + ");";
        this.appendString(decl);
        DataFacadeGenerator.emptyline();
        this.appendComment("Removes the element at position index from the list.");
        this.appendString("void " + DataFacadeGenerator.getContainerEntryDeleterName(list) + "(int index);");
        DataFacadeGenerator.emptyline();
        this.appendComment("Swaps elements at positions index1 and index2 in the list.");
        this.appendString("void " + DataFacadeGenerator.getContainerEntrySwapperName(list) + "(int index1, int index2);");
        DataFacadeGenerator.emptyline();
        this.appendComment("Returns the element at the position index in the list.");
        this.appendString(c.toJavaType() + " " + DataFacadeGenerator.getListElementGetterName(list) + "(int index);");
        DataFacadeGenerator.emptyline();
    }

    private void generateListMethodsMultilingual(MetaListProperty list) {
        for (String l : GeneratorDataRegistry.getInstance().getContext().getLanguages()) {
            MetaProperty c = list.getContainedProperty();
            this.appendComment("Adds a new element to the list.");
            String decl = "void " + DataFacadeGenerator.getContainerEntryAdderName(list, l) + "(";
            decl = decl + c.toJavaType() + " " + c.getName();
            decl = decl + ");";
            this.appendString(decl);
            DataFacadeGenerator.emptyline();
            this.appendComment("Removes the element at position index from the list.");
            this.appendString("void " + DataFacadeGenerator.getContainerEntryDeleterName(list, l) + "(int index);");
            DataFacadeGenerator.emptyline();
            this.appendComment("Swaps elements at positions index1 and index2 in the list.");
            this.appendString("void " + DataFacadeGenerator.getContainerEntrySwapperName(list, l) + "(int index1, int index2);");
            DataFacadeGenerator.emptyline();
            this.appendComment("Returns the element at the position index in the list.");
            this.appendString(c.toJavaType() + " " + DataFacadeGenerator.getListElementGetterName(list, l) + "(int index);");
            DataFacadeGenerator.emptyline();
        }
    }

    private void generateTableMethods(MetaTableProperty table) {
        List<MetaProperty> columns = table.getColumns();
        String decl = "void " + DataFacadeGenerator.getContainerEntryAdderName(table) + "(";
        for (int i = 0; i < columns.size(); ++i) {
            MetaProperty p = columns.get(i);
            decl = decl + PROPERTY_DECLARATION + table.extractSubName(p);
            if (i >= columns.size() - 1) continue;
            decl = decl + ", ";
        }
        decl = decl + ");";
        this.appendString(decl);
        DataFacadeGenerator.emptyline();
        this.appendString("void " + DataFacadeGenerator.getContainerEntryDeleterName(table) + "(int index);");
        DataFacadeGenerator.emptyline();
        this.appendString("List<String> get" + StringUtils.capitalize((String)table.getName()) + "Row(int index);");
        DataFacadeGenerator.emptyline();
        this.appendString(" List<List<String>> " + DataFacadeGenerator.getTableGetterName(table) + "();");
        DataFacadeGenerator.emptyline();
    }

    public static String getContainerSizeGetterName(MetaContainerProperty p) {
        return "get" + StringUtils.capitalize((String)p.getName()) + "Size";
    }

    public static String getContainerSizeGetterName(MetaContainerProperty p, String language) {
        return "get" + StringUtils.capitalize((String)p.getName(language)) + "Size";
    }

    public static String getTableGetterName(MetaTableProperty p) {
        return "get" + StringUtils.capitalize((String)p.getName()) + "Table";
    }

    public static String getContainerEntryAdderName(MetaContainerProperty p) {
        return "add" + StringUtils.capitalize((String)p.getName()) + p.getContainerEntryName();
    }

    public static String getContainerEntryAdderName(MetaContainerProperty p, String language) {
        return "add" + StringUtils.capitalize((String)p.getName(language)) + p.getContainerEntryName();
    }

    public static String getContainerEntryDeleterName(MetaContainerProperty p) {
        return "remove" + StringUtils.capitalize((String)p.getName()) + p.getContainerEntryName();
    }

    public static String getContainerEntryDeleterName(MetaContainerProperty p, String language) {
        return "remove" + StringUtils.capitalize((String)p.getName(language)) + p.getContainerEntryName();
    }

    public static String getContainerEntrySwapperName(MetaContainerProperty p) {
        return "swap" + StringUtils.capitalize((String)p.getName()) + p.getContainerEntryName();
    }

    public static String getContainerEntrySwapperName(MetaContainerProperty p, String language) {
        return "swap" + StringUtils.capitalize((String)p.getName(language)) + p.getContainerEntryName();
    }

    public static String getListElementGetterName(MetaListProperty list) {
        return "get" + StringUtils.capitalize((String)list.getName()) + list.getContainerEntryName();
    }

    public static String getListElementGetterName(MetaListProperty list, String language) {
        return "get" + StringUtils.capitalize((String)list.getName(language)) + list.getContainerEntryName();
    }

    public static String getDocumentFactoryName(MetaDocument doc) {
        return doc.getName() + "Factory";
    }

    public static final String getDocumentFactoryImport(Context context, MetaDocument doc) {
        return context.getDataPackageName(doc) + "." + DataFacadeGenerator.getDocumentFactoryName(doc);
    }

    @Override
    public String getDataObjectImplName(MetaDocument doc) {
        throw new AssertionError((Object)"Shouln't be called, since the facade has no impl");
    }
}

