/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.model;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.asg.generator.AbstractGenerator;
import net.anotheria.asg.generator.FileEntry;
import net.anotheria.asg.generator.GeneratedClass;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.IGenerateable;
import net.anotheria.asg.generator.IGenerator;
import net.anotheria.asg.generator.meta.MetaDocument;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.asg.generator.meta.StorageType;
import net.anotheria.asg.generator.model.AbstractDataObjectGenerator;
import net.anotheria.asg.generator.model.DataFacadeGenerator;
import net.anotheria.asg.generator.model.db.VOGenerator;
import net.anotheria.asg.generator.model.docs.DocumentGenerator;
import net.anotheria.asg.generator.model.federation.FederationVOGenerator;

public class ModuleGenerator
extends AbstractGenerator
implements IGenerator {
    @Override
    public List<FileEntry> generate(IGenerateable gmodule) {
        MetaModule mod = (MetaModule)gmodule;
        ArrayList<FileEntry> ret = new ArrayList<FileEntry>();
        if (mod.getStorageType() == StorageType.CMS) {
            ret.add(new FileEntry(this.generateModule(mod)));
        }
        for (int i = 0; i < mod.getDocuments().size(); ++i) {
            AbstractDataObjectGenerator vog;
            DataFacadeGenerator facadeGen = new DataFacadeGenerator();
            ret.addAll(facadeGen.generate(mod.getDocuments().get(i)));
            if (mod.getStorageType() == StorageType.CMS) {
                DocumentGenerator dg = new DocumentGenerator();
                ret.addAll(dg.generate(mod.getDocuments().get(i)));
            }
            if (mod.getStorageType() == StorageType.DB) {
                vog = new VOGenerator();
                ret.addAll(((VOGenerator)vog).generate(mod.getDocuments().get(i)));
            }
            if (mod.getStorageType() != StorageType.FEDERATION) continue;
            vog = new FederationVOGenerator();
            ret.addAll(((FederationVOGenerator)vog).generate(mod.getDocuments().get(i)));
        }
        return ret;
    }

    private GeneratedClass generateModule(MetaModule module) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        clazz.setPackageName(GeneratorDataRegistry.getInstance().getContext().getPackageName(module) + ".data");
        clazz.addImport("net.anotheria.anodoc.data.Module");
        clazz.addImport("net.anotheria.anodoc.data.DocumentList");
        clazz.addImport("net.anotheria.anodoc.data.IDHolder");
        clazz.addImport("net.anotheria.anodoc.data.NoSuchDocumentListException");
        clazz.addImport("java.util.List");
        ModuleGenerator.emptyline();
        clazz.setName("Module" + module.getName());
        clazz.setParent("Module");
        this.startClassBody();
        this.generateConstants(module);
        ModuleGenerator.emptyline();
        this.generateConstructor(module);
        ModuleGenerator.emptyline();
        List<MetaDocument> documents = module.getDocuments();
        for (int i = 0; i < documents.size(); ++i) {
            MetaDocument doc = documents.get(i);
            this.generateDocumentRelatedCode(doc);
            ModuleGenerator.emptyline();
        }
        return clazz;
    }

    private void generateConstructor(MetaModule module) {
        this.appendString("public " + module.getModuleClassName() + "(){");
        this.increaseIdent();
        this.appendString("super(MODULE_ID);");
        this.append(this.closeBlock());
    }

    private String generateConstants(MetaModule module) {
        String ret = "";
        this.appendStatement("public static final String MODULE_ID = " + this.quote(module.getId()));
        ModuleGenerator.emptyline();
        List<MetaDocument> documents = module.getDocuments();
        for (int i = 0; i < documents.size(); ++i) {
            MetaDocument d = documents.get(i);
            Object listName = "public static final String ";
            listName = (String)listName + d.getListName();
            listName = (String)listName + " = " + this.quote(d.getListConstantValue());
            this.appendStatement(new String[]{listName});
            Object idHolderName = "public static final String ";
            idHolderName = (String)idHolderName + d.getIdHolderName();
            idHolderName = (String)idHolderName + " = IDHolder.DOC_ID_HOLDER_PRE+" + this.quote(d.getName().toLowerCase());
            this.appendStatement(new String[]{idHolderName});
        }
        return ret;
    }

    private void generateDocumentRelatedCode(MetaDocument doc) {
        this.appendString("@SuppressWarnings(\"unchecked\")");
        this.appendString("private DocumentList<" + DocumentGenerator.getDocumentName(doc) + "> _get" + doc.getMultiple() + "(){");
        this.increaseIdent();
        this.appendString("try{");
        this.increaseIdent();
        this.appendStatement("return getList(" + doc.getListName() + ")");
        this.decreaseIdent();
        this.appendString("}catch(NoSuchDocumentListException e){");
        this.increaseIdent();
        this.appendStatement("return new DocumentList<" + DocumentGenerator.getDocumentName(doc) + ">(" + doc.getListName() + ")");
        this.append(this.closeBlock());
        this.append(this.closeBlock());
        ModuleGenerator.emptyline();
        this.appendString("private void _update" + doc.getMultiple() + "(DocumentList<" + DocumentGenerator.getDocumentName(doc) + "> list){");
        this.increaseIdent();
        this.appendString("putList(list);");
        this.append(this.closeBlock());
        ModuleGenerator.emptyline();
        this.appendString("public List<" + DocumentGenerator.getDocumentName(doc) + "> get" + doc.getMultiple() + "(){");
        this.increaseIdent();
        this.appendString("return _get" + doc.getMultiple() + "().getList();");
        this.append(this.closeBlock());
        ModuleGenerator.emptyline();
        this.appendString("public " + DocumentGenerator.getDocumentName(doc) + " get" + doc.getName() + "(String id){");
        this.increaseIdent();
        this.appendStatement("return _get" + doc.getMultiple() + "().getDocumentById(id)");
        this.append(this.closeBlock());
        ModuleGenerator.emptyline();
        this.appendString("public void update" + doc.getName() + "(" + DocumentGenerator.getDocumentName(doc) + " " + doc.getVariableName() + "){");
        this.increaseIdent();
        this.appendString("DocumentList<" + DocumentGenerator.getDocumentName(doc) + "> " + doc.getMultiple().toLowerCase() + " = _get" + doc.getMultiple() + "();");
        this.appendString(doc.getMultiple().toLowerCase() + ".removeDocumentById(" + doc.getVariableName() + ".getId());");
        this.appendStatement(doc.getVariableName() + ".setLastUpdateNow()");
        this.appendStatement(doc.getVariableName() + ".setCallContextAuthor()");
        this.appendString(doc.getMultiple().toLowerCase() + ".addDocument(" + doc.getVariableName() + ");");
        this.appendString("_update" + doc.getMultiple() + "(" + doc.getMultiple().toLowerCase() + ");");
        this.append(this.closeBlock());
        ModuleGenerator.emptyline();
        this.appendString("public void delete" + doc.getName() + "(String id){");
        this.increaseIdent();
        this.appendStatement("DocumentList<" + DocumentGenerator.getDocumentName(doc) + "> entries = _get" + doc.getMultiple() + "()");
        this.appendStatement("entries.removeDocumentById(id)");
        this.appendStatement("_update" + doc.getMultiple() + "(entries)");
        this.append(this.closeBlock());
        ModuleGenerator.emptyline();
        this.appendString("public " + DocumentGenerator.getDocumentName(doc) + " create" + doc.getName() + "(" + DocumentGenerator.getDocumentName(doc) + " " + doc.getVariableName() + " ){");
        this.increaseIdent();
        this.appendStatement("IDHolder idh = _getIdHolder(" + doc.getIdHolderName() + ")");
        this.appendStatement("int id = idh.getNextIdInt()");
        this.appendStatement(doc.getVariableName() + ".renameTo(\"\"+id)");
        this.appendStatement("putDocument(idh)");
        ModuleGenerator.emptyline();
        this.appendStatement("DocumentList<" + DocumentGenerator.getDocumentName(doc) + "> entries = _get" + doc.getMultiple() + "()");
        this.appendStatement(doc.getVariableName() + ".setLastUpdateNow()");
        this.appendStatement(doc.getVariableName() + ".setCallContextAuthor()");
        this.appendStatement("entries.addDocument(" + doc.getVariableName() + ")");
        this.appendStatement("_update" + doc.getMultiple() + "(entries)");
        this.appendStatement("return " + doc.getVariableName());
        this.append(this.closeBlock());
        ModuleGenerator.emptyline();
        this.appendString("public " + DocumentGenerator.getDocumentName(doc) + " import" + doc.getName() + "(" + DocumentGenerator.getDocumentName(doc) + " " + doc.getVariableName() + " ){");
        this.increaseIdent();
        this.appendStatement("IDHolder idh = _getIdHolder(" + doc.getIdHolderName() + ")");
        this.appendStatement("idh.adjustTill(" + doc.getVariableName() + ".getId())");
        this.appendStatement("putDocument(idh)");
        ModuleGenerator.emptyline();
        this.appendStatement("DocumentList<" + DocumentGenerator.getDocumentName(doc) + "> entries = _get" + doc.getMultiple() + "()");
        this.appendStatement(doc.getVariableName() + ".setLastUpdateNow()");
        this.appendStatement(doc.getVariableName() + ".setCallContextAuthor()");
        this.appendStatement("entries.addDocument(" + doc.getVariableName() + ")");
        this.appendStatement("_update" + doc.getMultiple() + "(entries)");
        this.appendStatement("return " + doc.getVariableName());
        this.append(this.closeBlock());
        ModuleGenerator.emptyline();
    }
}

