/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.model;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.anodoc.query2.DocumentQuery;
import net.anotheria.anodoc.query2.QueryProperty;
import net.anotheria.anodoc.query2.QueryResult;
import net.anotheria.asg.exception.ASGRuntimeException;
import net.anotheria.asg.generator.AbstractGenerator;
import net.anotheria.asg.generator.CommentGenerator;
import net.anotheria.asg.generator.Context;
import net.anotheria.asg.generator.FileEntry;
import net.anotheria.asg.generator.GeneratedClass;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.IGenerateable;
import net.anotheria.asg.generator.IGenerator;
import net.anotheria.asg.generator.TypeOfClass;
import net.anotheria.asg.generator.meta.MetaDocument;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.asg.generator.meta.StorageType;
import net.anotheria.asg.generator.model.AbstractServiceGenerator;
import net.anotheria.asg.generator.model.DataFacadeGenerator;
import net.anotheria.asg.generator.model.db.JDBCBasedServiceGenerator;
import net.anotheria.asg.generator.model.db.JDBCPersistenceServiceGenerator;
import net.anotheria.asg.generator.model.db.PersistenceServiceDAOGenerator;
import net.anotheria.asg.generator.model.docs.CMSBasedServiceGenerator;
import net.anotheria.asg.generator.model.federation.FederationServiceGenerator;
import net.anotheria.asg.generator.model.fixture.FixtureServiceGenerator;
import net.anotheria.asg.generator.model.inmemory.InMemoryServiceGenerator;
import net.anotheria.asg.generator.model.rmi.RMIServiceGenerator;
import net.anotheria.asg.service.ASGService;
import net.anotheria.util.ExecutionTimer;
import net.anotheria.util.slicer.Segment;
import net.anotheria.util.sorter.SortType;
import net.anotheria.util.xml.XMLNode;

public class ServiceGenerator
extends AbstractGenerator
implements IGenerator {
    @Override
    public List<FileEntry> generate(IGenerateable gmodule) {
        AbstractServiceGenerator cmsGen;
        MetaModule mod = (MetaModule)gmodule;
        ArrayList<FileEntry> ret = new ArrayList<FileEntry>();
        ExecutionTimer timer = new ExecutionTimer("ServiceGenerator");
        ret.add(new FileEntry(this.generateInterface(mod)));
        ret.add(new FileEntry(this.generateException(mod)));
        List<GeneratedClass> itemNotFoundExceptions = this.generateItemNotFoundExceptions(mod);
        for (GeneratedClass c : itemNotFoundExceptions) {
            ret.add(new FileEntry(c));
        }
        timer.startExecution(mod.getName() + "-InMem");
        InMemoryServiceGenerator inMemGen = new InMemoryServiceGenerator();
        ret.addAll(inMemGen.generate(gmodule));
        timer.stopExecution(mod.getName() + "-InMem");
        timer.startExecution(mod.getName() + "-Fixture");
        FixtureServiceGenerator fixtureGen = new FixtureServiceGenerator();
        ret.addAll(fixtureGen.generate(gmodule));
        timer.stopExecution(mod.getName() + "-Fixture");
        timer.startExecution(mod.getName() + "-RMI");
        RMIServiceGenerator rmiGen = new RMIServiceGenerator();
        ret.addAll(rmiGen.generate(gmodule));
        timer.stopExecution(mod.getName() + "-RMI");
        if (mod.getStorageType() == StorageType.CMS) {
            timer.startExecution(mod.getName() + "-CMS");
            cmsGen = new CMSBasedServiceGenerator();
            ret.addAll(((CMSBasedServiceGenerator)cmsGen).generate(gmodule));
            timer.stopExecution(mod.getName() + "-CMS");
        }
        if (mod.getStorageType() == StorageType.DB) {
            timer.startExecution(mod.getName() + "-DB");
            timer.startExecution(mod.getName() + "-JDBC");
            JDBCPersistenceServiceGenerator jdbcGen = new JDBCPersistenceServiceGenerator();
            ret.addAll(jdbcGen.generate(gmodule));
            timer.stopExecution(mod.getName() + "-JDBC");
            timer.startExecution(mod.getName() + "-DAO");
            PersistenceServiceDAOGenerator daoGen = new PersistenceServiceDAOGenerator();
            ret.addAll(daoGen.generate(gmodule));
            timer.stopExecution(mod.getName() + "-DAO");
            timer.startExecution(mod.getName() + "-JDBC-Serv");
            JDBCBasedServiceGenerator servGen = new JDBCBasedServiceGenerator();
            ret.addAll(servGen.generate(gmodule));
            timer.stopExecution(mod.getName() + "-JDBC-Serv");
            timer.stopExecution(mod.getName() + "-DB");
        }
        if (mod.getStorageType() == StorageType.FEDERATION) {
            timer.startExecution(mod.getName() + "-Fed");
            cmsGen = new FederationServiceGenerator();
            ret.addAll(((FederationServiceGenerator)cmsGen).generate(gmodule));
            timer.stopExecution(mod.getName() + "-Fed");
        }
        return ret;
    }

    private String getPackageName(MetaModule module) {
        return GeneratorDataRegistry.getInstance().getContext().getPackageName(module) + ".service";
    }

    private List<GeneratedClass> generateItemNotFoundExceptions(MetaModule module) {
        ArrayList<GeneratedClass> ret = new ArrayList<GeneratedClass>();
        for (MetaDocument doc : module.getDocuments()) {
            GeneratedClass clazz = new GeneratedClass();
            this.startNewJob(clazz);
            clazz.setTypeComment(CommentGenerator.generateJavaTypeComment(ServiceGenerator.getItemNotFoundExceptionName(doc, module), this));
            clazz.setPackageName(this.getPackageName(module));
            clazz.setClazzComment("Exception for gets over non existing id in " + ServiceGenerator.getInterfaceName(module) + ", document: " + doc.getName());
            clazz.setName(ServiceGenerator.getItemNotFoundExceptionName(doc, module));
            clazz.setParent(ServiceGenerator.getExceptionName(module));
            this.startClassBody();
            this.appendString("public " + ServiceGenerator.getItemNotFoundExceptionName(doc, module) + " (String id){");
            this.appendIncreasedStatement("super(" + this.quote("No " + doc.getName() + " found with id: ") + "+id)");
            this.appendString("}");
            ret.add(clazz);
        }
        return ret;
    }

    private GeneratedClass generateException(MetaModule module) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        clazz.setTypeComment(CommentGenerator.generateJavaTypeComment(ServiceGenerator.getExceptionName(module), this));
        clazz.setPackageName(this.getPackageName(module));
        clazz.addImport(ASGRuntimeException.class);
        clazz.setClazzComment("Base class for all exceptions thrown by implementations of " + ServiceGenerator.getInterfaceName(module));
        clazz.setName(ServiceGenerator.getExceptionName(module));
        clazz.setParent(ASGRuntimeException.class);
        this.startClassBody();
        this.appendString("public " + ServiceGenerator.getExceptionName(module) + " (String message){");
        this.appendIncreasedStatement("super(message)");
        this.appendString("}");
        ServiceGenerator.emptyline();
        this.appendString("public " + ServiceGenerator.getExceptionName(module) + " (Throwable cause){");
        this.appendIncreasedStatement("super(cause)");
        this.appendString("}");
        ServiceGenerator.emptyline();
        this.appendString("public " + ServiceGenerator.getExceptionName(module) + " (String message, Throwable cause){");
        this.appendIncreasedStatement("super(message, cause)");
        this.appendString("}");
        return clazz;
    }

    private GeneratedClass generateInterface(MetaModule module) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        this.appendGenerationPoint("generateInterface");
        clazz.setTypeComment(CommentGenerator.generateJavaTypeComment(ServiceGenerator.getInterfaceName(module), this));
        clazz.setPackageName(this.getPackageName(module));
        clazz.addImport(List.class);
        clazz.addImport(SortType.class);
        List<MetaDocument> docs = module.getDocuments();
        for (int i = 0; i < docs.size(); ++i) {
            MetaDocument doc = docs.get(i);
            clazz.addImport(DataFacadeGenerator.getDocumentImport(doc));
        }
        clazz.addImport("java.util.Set");
        clazz.addImport("org.codehaus.jettison.json.JSONObject");
        clazz.addImport("org.codehaus.jettison.json.JSONArray");
        clazz.addImport("net.anotheria.anosite.gen.shared.util.DocumentName");
        clazz.addImport(XMLNode.class);
        clazz.addImport(Segment.class);
        clazz.addImport(DocumentQuery.class);
        clazz.addImport(QueryResult.class);
        clazz.addImport(QueryProperty.class);
        clazz.addImport(ASGService.class);
        clazz.setType(TypeOfClass.INTERFACE);
        clazz.setName(ServiceGenerator.getInterfaceName(module));
        clazz.setParent("ASGService");
        boolean containsAnyMultilingualDocs = false;
        String throwsClause = " throws " + ServiceGenerator.getExceptionName(module);
        this.startClassBody();
        for (int i = 0; i < docs.size(); ++i) {
            MetaDocument doc = docs.get(i);
            String listDecl = "List<" + doc.getName() + ">";
            this.appendComment("Returns all " + doc.getMultiple() + " objects stored.");
            this.appendStatement(listDecl + " get" + doc.getMultiple() + "()" + throwsClause);
            ServiceGenerator.emptyline();
            this.appendComment("Returns all " + doc.getMultiple() + " objects sorted by given sortType.");
            this.appendStatement(listDecl + " get" + doc.getMultiple() + "(SortType sortType)" + throwsClause);
            ServiceGenerator.emptyline();
            this.appendComment("Deletes a " + doc.getName() + " object by id.");
            this.appendStatement("void delete" + doc.getName() + "(String id)" + throwsClause);
            ServiceGenerator.emptyline();
            this.appendComment("Deletes a " + doc.getName() + " object.");
            this.appendStatement("void delete" + doc.getName() + "(" + doc.getName() + " " + doc.getVariableName() + ")" + throwsClause);
            ServiceGenerator.emptyline();
            this.appendComment("Deletes multiple " + doc.getName() + " object.");
            this.appendStatement("void delete" + doc.getMultiple() + "(" + listDecl + " list)" + throwsClause);
            ServiceGenerator.emptyline();
            this.appendComment("Returns the " + doc.getName() + " object with the specified id.");
            this.appendStatement(doc.getName() + " get" + doc.getName() + "(String id)" + throwsClause);
            ServiceGenerator.emptyline();
            this.appendComment("Imports a new " + doc.getName() + " object.\nReturns the created version.");
            this.appendStatement(doc.getName() + " import" + doc.getName() + "(" + doc.getName() + " " + doc.getVariableName() + ")" + throwsClause);
            ServiceGenerator.emptyline();
            this.appendComment("Imports multiple new  " + doc.getName() + " object.\nReturns the created versions.");
            this.appendStatement(listDecl + " import" + doc.getMultiple() + "(" + listDecl + " list)" + throwsClause);
            ServiceGenerator.emptyline();
            this.appendComment("Creates a new " + doc.getName() + " object.\nReturns the created version.");
            this.appendStatement(doc.getName() + " create" + doc.getName() + "(" + doc.getName() + " " + doc.getVariableName() + ")" + throwsClause);
            ServiceGenerator.emptyline();
            this.appendComment("Creates multiple new " + doc.getName() + " objects.\nReturns the created versions.");
            this.appendStatement(listDecl + " create" + doc.getMultiple() + "(" + listDecl + " list)" + throwsClause);
            ServiceGenerator.emptyline();
            this.appendComment("Updates a " + doc.getName() + " object.\nReturns the updated version.");
            this.appendStatement(doc.getName() + " update" + doc.getName() + "(" + doc.getName() + " " + doc.getVariableName() + ")" + throwsClause);
            ServiceGenerator.emptyline();
            this.appendComment("Updates multiple " + doc.getName() + " objects.\nReturns the updated versions.");
            this.appendStatement(listDecl + " update" + doc.getMultiple() + "(" + listDecl + " list)" + throwsClause);
            ServiceGenerator.emptyline();
            this.appendComment("Returns all " + doc.getName() + " objects, where property with given name equals object.");
            this.appendStatement(listDecl + " get" + doc.getMultiple() + "ByProperty(String propertyName, Object value)" + throwsClause);
            ServiceGenerator.emptyline();
            this.appendComment("Returns all " + doc.getName() + " objects, where property with given name equals object, sorted.");
            this.appendStatement(listDecl + " get" + doc.getMultiple() + "ByProperty(String propertyName, Object value, SortType sortType)" + throwsClause);
            ServiceGenerator.emptyline();
            this.appendComment("Executes a query.");
            this.appendStatement("QueryResult executeQueryOn" + doc.getMultiple() + "(DocumentQuery query)" + throwsClause);
            ServiceGenerator.emptyline();
            this.appendComment("Returns all " + doc.getName() + " objects, where property matches.");
            this.appendStatement(listDecl + " get" + doc.getMultiple() + "ByProperty(QueryProperty... property)" + throwsClause);
            ServiceGenerator.emptyline();
            this.appendComment("Returns all " + doc.getName() + " objects, where property matches, sorted.");
            this.appendStatement(listDecl + " get" + doc.getMultiple() + "ByProperty(SortType sortType, QueryProperty... property)" + throwsClause);
            ServiceGenerator.emptyline();
            this.appendComment("Returns all " + doc.getMultiple() + " count.");
            this.appendStatement("int get" + doc.getMultiple() + "Count()" + throwsClause);
            ServiceGenerator.emptyline();
            this.appendComment("Returns " + doc.getMultiple() + " objects segment.");
            this.appendStatement(listDecl + " get" + doc.getMultiple() + "(Segment aSegment)" + throwsClause);
            ServiceGenerator.emptyline();
            this.appendComment("Returns " + doc.getName() + " objects segment, where property matches.");
            this.appendStatement(listDecl + " get" + doc.getMultiple() + "ByProperty(Segment aSegment, QueryProperty... aProperty)" + throwsClause);
            ServiceGenerator.emptyline();
            this.appendComment("Returns " + doc.getName() + " objects segment, where property matches, sorted.");
            this.appendStatement(listDecl + " get" + doc.getMultiple() + "ByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty)" + throwsClause);
            ServiceGenerator.emptyline();
            if (GeneratorDataRegistry.hasLanguageCopyMethods(doc)) {
                this.appendComment("In all documents of type " + doc.getName() + " copies all multilingual fields from sourceLanguage to targetLanguage.");
                this.appendStatement("void copyMultilingualAttributesInAll" + doc.getMultiple() + "(String sourceLanguage, String targetLanguage)" + throwsClause);
                ServiceGenerator.emptyline();
                containsAnyMultilingualDocs = true;
            }
            this.appendComment("Creates an xml element with selected contained data.");
            this.appendStatement("XMLNode export" + doc.getMultiple() + "ToXML(List<" + doc.getName() + "> list" + doc.getMultiple() + ") " + throwsClause);
            if (containsAnyMultilingualDocs && GeneratorDataRegistry.getInstance().getContext().areLanguagesSupported()) {
                this.appendComment("creates an xml element with selected contained data but only selected languages in multilingual attributes");
                this.appendStatement("XMLNode export" + doc.getMultiple() + "ToXML(String[] languages,List<" + doc.getName() + "> list" + doc.getMultiple() + ")" + throwsClause);
            }
            ServiceGenerator.emptyline();
            this.appendComment("Create json object list dependencies for this " + doc.getName() + " document.");
            this.appendStatement("void fetch" + doc.getName() + "(String id, Set<String> addedDocuments, JSONArray data)" + throwsClause);
            ServiceGenerator.emptyline();
        }
        this.appendComment("Save transferred document by its own type.");
        this.appendStatement("void executeParsingForDocument (final DocumentName documentName, final JSONObject data)" + throwsClause);
        if (containsAnyMultilingualDocs) {
            this.appendComment("Copies all multilingual fields from sourceLanguage to targetLanguage in all data objects (documents, vo) which are part of this module and managed by this service.");
            this.appendStatement(" void copyMultilingualAttributesInAllObjects(String sourceLanguage, String targetLanguage)" + throwsClause);
            ServiceGenerator.emptyline();
        }
        this.appendComment("Executes a query on all data objects (documents, vo) which are part of this module and managed by this service.");
        this.appendStatement("QueryResult executeQueryOnAllObjects(DocumentQuery query)" + throwsClause);
        this.appendComment("creates an xml element with all contained data.");
        this.appendStatement("XMLNode exportToXML()" + throwsClause);
        ServiceGenerator.emptyline();
        if (containsAnyMultilingualDocs && GeneratorDataRegistry.getInstance().getContext().areLanguagesSupported()) {
            this.appendComment("creates an xml element with all contained data but only selected languages in multilingual attributes.");
            this.appendStatement("XMLNode exportToXML(String[] languages)" + throwsClause);
        }
        return clazz;
    }

    public static String getExceptionName(MetaModule m) {
        return ServiceGenerator.getServiceName(m) + "Exception";
    }

    public static String getItemNotFoundExceptionName(MetaDocument doc, MetaModule m) {
        return doc.getName() + "NotFoundIn" + ServiceGenerator.getExceptionName(m);
    }

    public static String getInterfaceName(MetaModule module) {
        return "I" + ServiceGenerator.getServiceName(module);
    }

    public static String getInterfaceImport(MetaModule m) {
        return ServiceGenerator.getPackageName(GeneratorDataRegistry.getInstance().getContext(), m) + "." + ServiceGenerator.getInterfaceName(m);
    }

    public static String getExceptionImport(MetaModule m) {
        return ServiceGenerator.getPackageName(GeneratorDataRegistry.getInstance().getContext(), m) + "." + ServiceGenerator.getExceptionName(m);
    }

    public static String getItemNotFoundExceptionImport(MetaDocument doc, MetaModule m) {
        return ServiceGenerator.getPackageName(GeneratorDataRegistry.getInstance().getContext(), m) + "." + ServiceGenerator.getItemNotFoundExceptionName(doc, m);
    }

    public static String getServiceName(MetaModule m) {
        return m.getName() + "Service";
    }

    public static String getFactoryName(MetaModule m) {
        return ServiceGenerator.getServiceName(m) + "Factory";
    }

    public static String getFactoryImport(MetaModule m) {
        return ServiceGenerator.getPackageName(GeneratorDataRegistry.getInstance().getContext(), m) + "." + ServiceGenerator.getFactoryName(m);
    }

    public static String getImplementationName(MetaModule m) {
        return ServiceGenerator.getServiceName(m) + "Impl";
    }

    public static String getPackageName(Context context, MetaModule module) {
        return context.getServicePackageName(module);
    }
}

