/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.model.db;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.asg.generator.CommentGenerator;
import net.anotheria.asg.generator.Context;
import net.anotheria.asg.generator.FileEntry;
import net.anotheria.asg.generator.GeneratedClass;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.IGenerateable;
import net.anotheria.asg.generator.IGenerator;
import net.anotheria.asg.generator.meta.MetaDocument;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.asg.generator.model.AbstractServiceGenerator;
import net.anotheria.asg.generator.model.DataFacadeGenerator;
import net.anotheria.asg.generator.model.ServiceGenerator;
import net.anotheria.asg.generator.model.db.JDBCPersistenceServiceGenerator;

public class JDBCBasedServiceGenerator
extends AbstractServiceGenerator
implements IGenerator {
    @Override
    public List<FileEntry> generate(IGenerateable gmodule) {
        MetaModule mod = (MetaModule)gmodule;
        ArrayList<FileEntry> ret = new ArrayList<FileEntry>();
        ret.add(new FileEntry(this.generateFactory(mod)));
        ret.add(new FileEntry(this.generateImplementation(mod)));
        return ret;
    }

    private GeneratedClass generateImplementation(MetaModule module) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        this.appendGenerationPoint("generateImplementation");
        Context context = GeneratorDataRegistry.getInstance().getContext();
        clazz.setTypeComment(CommentGenerator.generateJavaTypeComment(this.getImplementationName(module), "The implementation of the " + JDBCBasedServiceGenerator.getInterfaceName(module) + "."));
        clazz.setPackageName(this.getPackageName(module));
        clazz.addImport("java.util.List");
        clazz.addImport("net.anotheria.util.sorter.SortType");
        clazz.addImport("net.anotheria.util.sorter.StaticQuickSorter");
        clazz.addImport(context.getServicePackageName(MetaModule.SHARED) + ".BasicService");
        clazz.addImport(JDBCPersistenceServiceGenerator.getInterfaceImport(context, module));
        clazz.addImport(JDBCPersistenceServiceGenerator.getFactoryImport(context, module));
        clazz.addImport(JDBCPersistenceServiceGenerator.getExceptionImport(context, module));
        clazz.addImport("net.anotheria.anodoc.query2.DocumentQuery");
        clazz.addImport("net.anotheria.anodoc.query2.QueryResult");
        clazz.addImport("net.anotheria.anodoc.query2.QueryResultEntry");
        clazz.addImport("net.anotheria.anodoc.query2.QueryProperty");
        clazz.addImport("net.anotheria.util.xml.XMLNode");
        clazz.addImport("net.anotheria.util.xml.XMLAttribute");
        clazz.addImport("net.anotheria.util.slicer.Segment");
        clazz.setName(this.getImplementationName(module));
        clazz.setParent("BasicService");
        clazz.addInterface(JDBCBasedServiceGenerator.getInterfaceName(module));
        this.startClassBody();
        this.appendStatement("private static " + this.getImplementationName(module) + " instance");
        JDBCBasedServiceGenerator.emptyline();
        this.appendStatement("private " + JDBCPersistenceServiceGenerator.getInterfaceName(module) + " pService");
        this.appendString("private " + this.getImplementationName(module) + "(){");
        this.increaseIdent();
        this.appendStatement("pService = " + JDBCPersistenceServiceGenerator.getFactoryName(module) + ".create" + JDBCPersistenceServiceGenerator.getServiceName(module) + "()");
        if (module.getListeners().size() > 0) {
            for (int i = 0; i < module.getListeners().size(); ++i) {
                String listClassName = module.getListeners().get(i);
                this.appendStatement("addServiceListener(new " + listClassName + "())");
            }
        }
        this.closeBlockNEW();
        JDBCBasedServiceGenerator.emptyline();
        this.appendString("static final " + this.getImplementationName(module) + " getInstance(){");
        this.increaseIdent();
        this.appendString("if (instance==null){");
        this.increaseIdent();
        this.appendStatement("instance = new " + this.getImplementationName(module) + "()");
        this.closeBlockNEW();
        this.appendStatement("return instance");
        this.closeBlockNEW();
        JDBCBasedServiceGenerator.emptyline();
        String throwsClause = " throws " + this.getExceptionName(module) + " ";
        List<MetaDocument> docs = module.getDocuments();
        for (int i = 0; i < docs.size(); ++i) {
            MetaDocument doc = docs.get(i);
            String listDecl = "List<" + doc.getName() + ">";
            clazz.addImport(DataFacadeGenerator.getDocumentImport(doc));
            clazz.addImport(DataFacadeGenerator.getXMLHelperImport(context, doc));
            this.appendString("public " + listDecl + " get" + doc.getMultiple() + "()" + throwsClause + "{");
            this.increaseIdent();
            this.openTry();
            this.appendStatement("return pService.get" + doc.getMultiple() + "()");
            this.decreaseIdent();
            this.appendString("}catch(" + JDBCPersistenceServiceGenerator.getExceptionName(module) + " e){");
            this.appendIncreasedStatement("throw new " + this.getExceptionName(module) + "(\"Persistence failed: \"+e.getMessage())");
            this.appendString("}");
            this.closeBlockNEW();
            JDBCBasedServiceGenerator.emptyline();
            this.appendString("public " + listDecl + " get" + doc.getMultiple() + "(SortType sortType)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("return StaticQuickSorter.sort(get" + doc.getMultiple() + "(), sortType)");
            this.closeBlockNEW();
            JDBCBasedServiceGenerator.emptyline();
            this.appendString("public void delete" + doc.getName() + "(" + doc.getName() + " " + doc.getVariableName() + ")" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("delete" + doc.getName() + "(" + doc.getVariableName() + ".getId())");
            this.appendString("if(hasServiceListeners()){");
            this.increaseIdent();
            this.appendStatement("fireObjectDeletedEvent(" + doc.getVariableName() + ")");
            this.closeBlockNEW();
            this.closeBlockNEW();
            JDBCBasedServiceGenerator.emptyline();
            this.appendString("public void delete" + doc.getName() + "(String id)" + throwsClause + "{");
            this.increaseIdent();
            this.openTry();
            this.appendStatement(doc.getName() + " varValue = hasServiceListeners()?pService.get" + doc.getName() + "(id):null");
            this.appendStatement("pService.delete" + doc.getName() + "(id)");
            this.appendString("if(varValue!=null){");
            this.increaseIdent();
            this.appendStatement("fireObjectDeletedEvent(varValue)");
            this.closeBlockNEW();
            this.decreaseIdent();
            this.appendString("}catch(" + JDBCPersistenceServiceGenerator.getExceptionName(module) + " e){");
            this.appendIncreasedStatement("throw new " + this.getExceptionName(module) + "(\"Persistence failed: \"+e.getMessage())");
            this.appendString("}");
            this.closeBlockNEW();
            JDBCBasedServiceGenerator.emptyline();
            this.appendComment("Deletes multiple " + doc.getName() + " objects.");
            this.appendString("public void delete" + doc.getMultiple() + "(" + listDecl + " list)" + throwsClause + "{");
            this.increaseIdent();
            this.openTry();
            this.appendStatement("pService.delete" + doc.getMultiple() + "(list)");
            this.decreaseIdent();
            this.appendString("}catch(" + JDBCPersistenceServiceGenerator.getExceptionName(module) + " e){");
            this.appendIncreasedStatement("throw new " + this.getExceptionName(module) + "(\"Persistence failed: \"+e.getMessage())");
            this.appendString("}");
            this.appendString("if (hasServiceListeners()){");
            this.increaseIdent();
            this.appendString("for (int t = 0; t<list.size(); t++)");
            this.appendIncreasedStatement("fireObjectDeletedEvent(list.get(t))");
            this.closeBlockNEW();
            this.closeBlockNEW();
            JDBCBasedServiceGenerator.emptyline();
            this.appendString("public " + doc.getName() + " get" + doc.getName() + "(String id)" + throwsClause + "{");
            this.increaseIdent();
            this.openTry();
            this.appendStatement("return pService.get" + doc.getName() + "(id)");
            this.decreaseIdent();
            clazz.addImport(JDBCPersistenceServiceGenerator.getItemNotFoundExceptionImport(context, doc, module));
            this.appendString("}catch(" + JDBCPersistenceServiceGenerator.getItemNotFoundExceptionName(doc, module) + " e){");
            this.appendIncreasedStatement("throw new " + ServiceGenerator.getItemNotFoundExceptionName(doc, module) + "(id)");
            this.appendString("}catch(" + JDBCPersistenceServiceGenerator.getExceptionName(module) + " e){");
            this.appendIncreasedStatement("throw new " + this.getExceptionName(module) + "(\"Persistence failed: \"+e.getMessage())");
            this.appendString("}");
            this.closeBlockNEW();
            JDBCBasedServiceGenerator.emptyline();
            this.appendString("public " + doc.getName() + " import" + doc.getName() + "(" + doc.getName() + " " + doc.getVariableName() + ")" + throwsClause + "{");
            this.increaseIdent();
            this.openTry();
            this.appendStatement(doc.getVariableName() + " = pService.import" + doc.getName() + "(" + doc.getVariableName() + ")");
            this.appendString("if(hasServiceListeners()){");
            this.increaseIdent();
            this.appendStatement("fireObjectImportedEvent(" + doc.getVariableName() + ")");
            this.closeBlockNEW();
            this.decreaseIdent();
            this.appendString("}catch(" + JDBCPersistenceServiceGenerator.getExceptionName(module) + " e){");
            this.appendIncreasedStatement("throw new " + this.getExceptionName(module) + "(\"Persistence failed: \"+e.getMessage())");
            this.appendString("}");
            this.appendStatement("return " + doc.getVariableName());
            this.closeBlockNEW();
            JDBCBasedServiceGenerator.emptyline();
            this.appendString("public " + listDecl + " import" + doc.getMultiple() + "(" + listDecl + " list)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement(listDecl + " ret = null");
            this.openTry();
            this.appendStatement("ret = pService.import" + doc.getMultiple() + "(list)");
            this.appendString("if(hasServiceListeners()){");
            this.increaseIdent();
            this.appendString("for (" + doc.getName() + " " + doc.getVariableName() + " : ret)");
            this.increaseIdent();
            this.appendStatement("fireObjectImportedEvent(" + doc.getVariableName() + ")");
            this.decreaseIdent();
            this.closeBlockNEW();
            this.decreaseIdent();
            this.appendString("}catch(" + JDBCPersistenceServiceGenerator.getExceptionName(module) + " e){");
            this.appendIncreasedStatement("throw new " + this.getExceptionName(module) + "(\"Persistence failed: \"+e.getMessage())");
            this.appendString("}");
            this.appendStatement("return ret");
            this.closeBlockNEW();
            JDBCBasedServiceGenerator.emptyline();
            this.appendString("public " + doc.getName() + " create" + doc.getName() + "(" + doc.getName() + " " + doc.getVariableName() + ")" + throwsClause + "{");
            this.increaseIdent();
            this.openTry();
            this.appendStatement(doc.getVariableName() + " = pService.create" + doc.getName() + "(" + doc.getVariableName() + ")");
            this.decreaseIdent();
            this.appendString("}catch(" + JDBCPersistenceServiceGenerator.getExceptionName(module) + " e){");
            this.appendIncreasedStatement("throw new " + this.getExceptionName(module) + "(\"Persistence failed: \"+e.getMessage())");
            this.appendString("}");
            this.appendStatement("fireObjectCreatedEvent(" + doc.getVariableName() + ")");
            this.appendStatement("return " + doc.getVariableName());
            this.closeBlockNEW();
            JDBCBasedServiceGenerator.emptyline();
            this.appendComment("Creates multiple new " + doc.getName() + " objects.\nReturns the created versions.");
            this.appendString("public " + listDecl + " create" + doc.getMultiple() + "(" + listDecl + " list)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement(listDecl + " ret = null");
            this.openTry();
            this.appendStatement("ret = pService.create" + doc.getMultiple() + "(list)");
            this.decreaseIdent();
            this.appendString("}catch(" + JDBCPersistenceServiceGenerator.getExceptionName(module) + " e){");
            this.appendIncreasedStatement("throw new " + this.getExceptionName(module) + "(\"Persistence failed: \"+e.getMessage())");
            this.appendString("}");
            this.appendString("if (hasServiceListeners()){");
            this.increaseIdent();
            this.appendString("for (" + doc.getName() + " " + doc.getVariableName() + " : ret)");
            this.appendIncreasedStatement("fireObjectCreatedEvent(" + doc.getVariableName() + ")");
            this.closeBlockNEW();
            this.appendStatement("return ret");
            this.closeBlockNEW();
            JDBCBasedServiceGenerator.emptyline();
            this.appendComment("Updates multiple " + doc.getName() + " objects.\nReturns the updated versions.");
            this.appendString("public " + listDecl + " update" + doc.getMultiple() + "(" + listDecl + " list)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement(listDecl + " ret = null");
            this.openTry();
            this.appendStatement("ret = pService.update" + doc.getMultiple() + "(list)");
            this.decreaseIdent();
            this.appendString("}catch(" + JDBCPersistenceServiceGenerator.getExceptionName(module) + " e){");
            this.appendIncreasedStatement("throw new " + this.getExceptionName(module) + "(\"Persistence failed: \"+e.getMessage())");
            this.appendString("}");
            this.appendString("if (hasServiceListeners()){");
            this.increaseIdent();
            this.appendString("for (int t = 0; t<ret.size(); t++)");
            this.appendIncreasedStatement("fireObjectUpdatedEvent(list.get(t), ret.get(t))");
            this.closeBlockNEW();
            this.appendStatement("return ret");
            this.closeBlockNEW();
            JDBCBasedServiceGenerator.emptyline();
            this.appendString("public " + doc.getName() + " update" + doc.getName() + "(" + doc.getName() + " " + doc.getVariableName() + ")" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement(doc.getName() + " oldVersion = null");
            this.openTry();
            this.appendString("if (hasServiceListeners())");
            this.appendIncreasedStatement("oldVersion = pService.get" + doc.getName() + "(" + doc.getVariableName() + ".getId())");
            this.appendStatement(doc.getVariableName() + " = pService.update" + doc.getName() + "(" + doc.getVariableName() + ")");
            this.decreaseIdent();
            this.appendString("}catch(" + JDBCPersistenceServiceGenerator.getExceptionName(module) + " e){");
            this.appendIncreasedStatement("throw new " + this.getExceptionName(module) + "(\"Persistence failed: \"+e.getMessage())");
            this.appendString("}");
            this.appendString("if (oldVersion!=null)");
            this.appendIncreasedStatement("fireObjectUpdatedEvent(oldVersion, " + doc.getVariableName() + ")");
            this.appendStatement("return " + doc.getVariableName());
            this.closeBlockNEW();
            JDBCBasedServiceGenerator.emptyline();
            this.appendString("public " + listDecl + " get" + doc.getMultiple() + "ByProperty(String propertyName, Object value)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("QueryProperty p = new QueryProperty(propertyName, value)");
            this.appendString("try{");
            this.appendIncreasedStatement("return pService.get" + doc.getMultiple() + "ByProperty(p)");
            this.appendString("}catch(" + JDBCPersistenceServiceGenerator.getExceptionName(module) + " e){");
            this.appendIncreasedStatement("throw new " + this.getExceptionName(module) + "(\"Persistence failed: \"+e.getMessage())");
            this.appendString("}");
            this.closeBlockNEW();
            JDBCBasedServiceGenerator.emptyline();
            this.appendString("public " + listDecl + " get" + doc.getMultiple() + "ByProperty(String propertyName, Object value, SortType sortType)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("return StaticQuickSorter.sort(get" + doc.getMultiple() + "ByProperty(propertyName, value), sortType)");
            this.closeBlockNEW();
            this.appendComment("Executes a query on " + doc.getMultiple());
            this.appendString("public QueryResult executeQueryOn" + doc.getMultiple() + "(DocumentQuery query)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement(listDecl + " all" + doc.getMultiple() + " = get" + doc.getMultiple() + "()");
            this.appendStatement("QueryResult result = new QueryResult()");
            this.appendString("for (int i=0; i<all" + doc.getMultiple() + ".size(); i++){");
            this.increaseIdent();
            this.appendStatement("List<QueryResultEntry> partialResult = query.match(all" + doc.getMultiple() + ".get(i))");
            this.appendStatement("result.add(partialResult)");
            this.closeBlockNEW();
            this.appendStatement("return result");
            this.closeBlockNEW();
            JDBCBasedServiceGenerator.emptyline();
            this.appendComment("Returns all " + doc.getName() + " objects, where property matches.");
            this.appendStatement("public " + listDecl + " get" + doc.getMultiple() + "ByProperty(QueryProperty... property)" + throwsClause + "{");
            this.increaseIdent();
            this.appendString("try{");
            this.appendIncreasedStatement("return pService.get" + doc.getMultiple() + "ByProperty(property)");
            this.appendString("}catch(" + JDBCPersistenceServiceGenerator.getExceptionName(module) + " e){");
            this.appendIncreasedStatement("throw new " + this.getExceptionName(module) + "(\"Persistence failed: \"+e.getMessage())");
            this.appendString("}");
            this.closeBlockNEW();
            JDBCBasedServiceGenerator.emptyline();
            this.appendComment("Returns all " + doc.getName() + " objects, where property matches, sorted");
            this.appendStatement("public " + listDecl + " get" + doc.getMultiple() + "ByProperty(SortType sortType, QueryProperty... property)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("return StaticQuickSorter.sort(get" + doc.getMultiple() + "ByProperty(property), sortType)");
            this.closeBlockNEW();
            JDBCBasedServiceGenerator.emptyline();
            this.appendComment("Returns " + doc.getName() + " objects count.");
            this.appendString("public int get" + doc.getMultiple() + "Count()" + throwsClause + "{");
            this.increaseIdent();
            this.openTry();
            this.appendStatement("return pService.get" + doc.getMultiple() + "Count()");
            this.decreaseIdent();
            this.appendString("} catch (" + JDBCPersistenceServiceGenerator.getExceptionName(module) + " e) {");
            this.appendIncreasedStatement("throw new " + this.getExceptionName(module) + "(\"Persistence failed: \"+e.getMessage())");
            this.appendString("}");
            this.closeBlockNEW();
            JDBCBasedServiceGenerator.emptyline();
            this.appendComment("Returns " + doc.getName() + " objects segment.");
            this.appendString("public " + listDecl + " get" + doc.getMultiple() + "(Segment aSegment)" + throwsClause + "{");
            this.increaseIdent();
            this.openTry();
            this.appendStatement("return pService.get" + doc.getMultiple() + "(aSegment)");
            this.decreaseIdent();
            this.appendString("} catch (" + JDBCPersistenceServiceGenerator.getExceptionName(module) + " e) {");
            this.appendIncreasedStatement("throw new " + this.getExceptionName(module) + "(\"Persistence failed: \"+e.getMessage())");
            this.appendString("}");
            this.closeBlockNEW();
            JDBCBasedServiceGenerator.emptyline();
            this.appendComment("Returns " + doc.getName() + " objects segment, where property matches.");
            this.appendStatement("public " + listDecl + " get" + doc.getMultiple() + "ByProperty(Segment aSegment, QueryProperty... aProperty)" + throwsClause + "{");
            this.increaseIdent();
            this.appendString("try {");
            this.appendIncreasedStatement("return pService.get" + doc.getMultiple() + "ByProperty(aSegment, aProperty)");
            this.appendString("} catch (" + JDBCPersistenceServiceGenerator.getExceptionName(module) + " e) {");
            this.appendIncreasedStatement("throw new " + this.getExceptionName(module) + "(\"Persistence failed: \"+e.getMessage())");
            this.appendString("}");
            this.closeBlockNEW();
            JDBCBasedServiceGenerator.emptyline();
            this.appendComment("Returns " + doc.getName() + " objects segment, where property matches, sorted");
            this.appendStatement("public " + listDecl + " get" + doc.getMultiple() + "ByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("return StaticQuickSorter.sort(get" + doc.getMultiple() + "ByProperty(aSegment, aProperty), aSortType)");
            this.closeBlockNEW();
            JDBCBasedServiceGenerator.emptyline();
        }
        JDBCBasedServiceGenerator.emptyline();
        for (MetaDocument d : docs) {
            this.appendString("public XMLNode export" + d.getMultiple() + "ToXML(){");
            this.increaseIdent();
            this.appendStatement("XMLNode ret = new XMLNode(" + this.quote(d.getMultiple()) + ")");
            this.appendString("try{");
            this.increaseIdent();
            this.appendStatement("List<" + d.getName() + "> list = get" + d.getMultiple() + "()");
            this.appendStatement("ret.addAttribute(new XMLAttribute(" + this.quote("count") + ", list.size()))");
            this.appendString("for (" + d.getName() + " object : list)");
            this.appendIncreasedStatement("ret.addChildNode(" + DataFacadeGenerator.getXMLHelperName(d) + ".toXML(object))");
            this.appendStatement("return ret");
            this.closeBlockNEW();
            this.appendStatement("catch(" + this.getExceptionName(module) + " e){");
            this.increaseIdent();
            this.appendStatement("throw new RuntimeException(" + this.quote("export" + d.getMultiple() + "ToXML() failure: ") + " + e.getStackTrace())");
            this.closeBlockNEW();
            this.closeBlockNEW();
            JDBCBasedServiceGenerator.emptyline();
            this.appendString("public XMLNode export" + d.getMultiple() + "ToXML(List<" + d.getName() + "> list){");
            this.increaseIdent();
            this.appendStatement("XMLNode ret = new XMLNode(" + this.quote(d.getMultiple()) + ")");
            this.appendStatement("ret.addAttribute(new XMLAttribute(" + this.quote("count") + ", list.size()))");
            this.appendString("for (" + d.getName() + " object : list)");
            this.appendIncreasedStatement("ret.addChildNode(" + DataFacadeGenerator.getXMLHelperName(d) + ".toXML(object))");
            this.appendStatement("return ret");
            this.closeBlockNEW();
            JDBCBasedServiceGenerator.emptyline();
            this.appendString("public XMLNode export" + d.getMultiple() + "ToXML(String languages[]){");
            this.increaseIdent();
            this.appendStatement("XMLNode ret = new XMLNode(" + this.quote(d.getMultiple()) + ")");
            this.appendString("try{");
            this.increaseIdent();
            this.appendStatement("List<" + d.getName() + "> list = get" + d.getMultiple() + "()");
            this.appendStatement("ret.addAttribute(new XMLAttribute(" + this.quote("count") + ", list.size()))");
            this.appendString("for (" + d.getName() + " object : list)");
            this.appendIncreasedStatement("ret.addChildNode(" + DataFacadeGenerator.getXMLHelperName(d) + ".toXML(object, languages))");
            this.appendStatement("return ret");
            this.closeBlockNEW();
            this.appendStatement("catch(" + this.getExceptionName(module) + " e){");
            this.increaseIdent();
            this.appendStatement("throw new RuntimeException(" + this.quote("export" + d.getMultiple() + "ToXML() failure: ") + " + e.getStackTrace())");
            this.closeBlockNEW();
            this.closeBlockNEW();
            JDBCBasedServiceGenerator.emptyline();
            this.appendString("public XMLNode export" + d.getMultiple() + "ToXML(String languages[], List<" + d.getName() + "> list){");
            this.increaseIdent();
            this.appendStatement("XMLNode ret = new XMLNode(" + this.quote(d.getMultiple()) + ")");
            this.appendStatement("ret.addAttribute(new XMLAttribute(" + this.quote("count") + ", list.size()))");
            this.appendString("for (" + d.getName() + " object : list)");
            this.appendIncreasedStatement("ret.addChildNode(" + DataFacadeGenerator.getXMLHelperName(d) + ".toXML(object, languages))");
            this.appendStatement("return ret");
            this.closeBlockNEW();
            JDBCBasedServiceGenerator.emptyline();
        }
        this.appendComment("Executes a query on all data objects (documents, vo) which are part of this module and managed by this service");
        this.appendString("public QueryResult executeQueryOnAllObjects(DocumentQuery query)" + throwsClause + "{");
        this.increaseIdent();
        this.appendStatement("QueryResult ret = new QueryResult()");
        for (MetaDocument doc : docs) {
            this.appendStatement("ret.add(executeQueryOn" + doc.getMultiple() + "(query).getEntries())");
        }
        this.appendStatement("return ret");
        this.closeBlock("executeQueryOnAllObjects");
        JDBCBasedServiceGenerator.emptyline();
        this.appendString("public XMLNode exportToXML(){");
        this.increaseIdent();
        this.appendStatement("XMLNode ret = new XMLNode(" + this.quote(module.getName()) + ")");
        JDBCBasedServiceGenerator.emptyline();
        for (MetaDocument d : docs) {
            this.appendStatement("ret.addChildNode(export" + d.getMultiple() + "ToXML())");
        }
        JDBCBasedServiceGenerator.emptyline();
        this.appendStatement("return ret");
        this.closeBlockNEW();
        JDBCBasedServiceGenerator.emptyline();
        this.appendString("public XMLNode exportToXML(String[] languages){");
        this.increaseIdent();
        this.appendStatement("XMLNode ret = new XMLNode(" + this.quote(module.getName()) + ")");
        JDBCBasedServiceGenerator.emptyline();
        for (MetaDocument d : docs) {
            this.appendStatement("ret.addChildNode(export" + d.getMultiple() + "ToXML(languages))");
        }
        JDBCBasedServiceGenerator.emptyline();
        this.appendStatement("return ret");
        this.closeBlockNEW();
        return clazz;
    }

    public List<String> getAll() {
        return this.getAllByLimit(Integer.MIN_VALUE);
    }

    public List<String> getAllByLimit(int aLimit) {
        return this.getAllByLimitAndOffset(aLimit, Integer.MIN_VALUE);
    }

    public List<String> getAllByLimitAndOffset(int aLimit, long aOffcet) {
        ArrayList<String> result = new ArrayList<String>();
        Object sqlQuery = "SELECT * FROM table";
        Object sqlQueryLimit = "";
        Object sqlQueryOffcet = "";
        if (aLimit != Integer.MIN_VALUE) {
            sqlQueryLimit = " LIMIT " + aLimit;
        }
        if (aOffcet == Integer.MIN_VALUE) {
            sqlQueryOffcet = " OFFSET " + aLimit;
        }
        sqlQuery = (String)sqlQuery + (String)sqlQueryLimit + (String)sqlQueryOffcet;
        return result;
    }

    @Override
    protected String getMoskitoSubsystem() {
        return super.getMoskitoSubsystem() + "-jdbc";
    }
}

