/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.model.db;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.asg.generator.AbstractGenerator;
import net.anotheria.asg.generator.CommentGenerator;
import net.anotheria.asg.generator.Context;
import net.anotheria.asg.generator.FileEntry;
import net.anotheria.asg.generator.GeneratedClass;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.IGenerateable;
import net.anotheria.asg.generator.IGenerator;
import net.anotheria.asg.generator.TypeOfClass;
import net.anotheria.asg.generator.meta.MetaDocument;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.asg.generator.model.DataFacadeGenerator;
import net.anotheria.asg.generator.model.db.PersistenceServiceDAOGenerator;

public class JDBCPersistenceServiceGenerator
extends AbstractGenerator
implements IGenerator {
    @Override
    public List<FileEntry> generate(IGenerateable gmodule) {
        MetaModule mod = (MetaModule)gmodule;
        ArrayList<FileEntry> ret = new ArrayList<FileEntry>();
        List<GeneratedClass> itemNotFoundExceptions = this.generateItemNotFoundExceptions(mod);
        for (GeneratedClass anExceptionClass : itemNotFoundExceptions) {
            ret.add(new FileEntry(anExceptionClass));
        }
        ret.add(new FileEntry(this.generateException(mod)));
        ret.add(new FileEntry(this.generateInterface(mod)));
        ret.add(new FileEntry(this.generateFactory(mod)));
        ret.add(new FileEntry(this.generateImplementation(mod)));
        return ret;
    }

    private String getPackageName(MetaModule m) {
        return JDBCPersistenceServiceGenerator.getPackageName(GeneratorDataRegistry.getInstance().getContext(), m);
    }

    private GeneratedClass generateException(MetaModule module) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        clazz.setTypeComment(CommentGenerator.generateJavaTypeComment(JDBCPersistenceServiceGenerator.getInterfaceName(module), this));
        clazz.setPackageName(this.getPackageName(module));
        clazz.addImport("java.sql.SQLException");
        clazz.addImport("net.anotheria.db.dao.DAOException");
        clazz.setName(JDBCPersistenceServiceGenerator.getExceptionName(module));
        clazz.setParent("Exception");
        this.startClassBody();
        this.appendString("public " + JDBCPersistenceServiceGenerator.getExceptionName(module) + "(String message){");
        this.appendIncreasedStatement("super(message)");
        this.appendString("}");
        this.appendString("public " + JDBCPersistenceServiceGenerator.getExceptionName(module) + "(SQLException e){");
        this.appendIncreasedStatement("super(" + this.quote("Undelying DB Error: ") + "+e.getMessage())");
        this.appendString("}");
        this.appendString("public " + JDBCPersistenceServiceGenerator.getExceptionName(module) + "(DAOException e){");
        this.appendIncreasedStatement("super(" + this.quote("Undelying DAO Error: ") + "+e.getMessage())");
        this.appendString("}");
        return clazz;
    }

    public static final String getItemNotFoundExceptionImport(Context c, MetaDocument doc, MetaModule m) {
        return JDBCPersistenceServiceGenerator.getPackageName(c, m) + "." + JDBCPersistenceServiceGenerator.getItemNotFoundExceptionName(doc, m);
    }

    public static final String getItemNotFoundExceptionName(MetaDocument doc, MetaModule module) {
        return doc.getName() + "NotFoundIn" + JDBCPersistenceServiceGenerator.getExceptionName(module);
    }

    private List<GeneratedClass> generateItemNotFoundExceptions(MetaModule module) {
        ArrayList<GeneratedClass> ret = new ArrayList<GeneratedClass>();
        for (MetaDocument doc : module.getDocuments()) {
            GeneratedClass clazz = new GeneratedClass();
            this.startNewJob(clazz);
            clazz.setTypeComment(CommentGenerator.generateJavaTypeComment(JDBCPersistenceServiceGenerator.getInterfaceName(module), this));
            clazz.setPackageName(this.getPackageName(module));
            clazz.setName(JDBCPersistenceServiceGenerator.getItemNotFoundExceptionName(doc, module));
            clazz.setParent(JDBCPersistenceServiceGenerator.getExceptionName(module));
            this.startClassBody();
            this.appendString("public " + JDBCPersistenceServiceGenerator.getItemNotFoundExceptionName(doc, module) + "(String id){");
            this.appendIncreasedStatement("super(" + this.quote("No item with id ") + "+id+" + this.quote(" found.") + ")");
            this.appendString("}");
            ret.add(clazz);
        }
        return ret;
    }

    private GeneratedClass generateInterface(MetaModule module) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        this.appendGenerationPoint("generateInterface");
        clazz.setTypeComment(CommentGenerator.generateJavaTypeComment(JDBCPersistenceServiceGenerator.getInterfaceName(module), this));
        clazz.setPackageName(this.getPackageName(module));
        clazz.addImport("java.util.List");
        clazz.addImport("net.anotheria.anodoc.query2.QueryProperty");
        clazz.addImport("net.anotheria.util.slicer.Segment");
        List<MetaDocument> docs = module.getDocuments();
        for (int i = 0; i < docs.size(); ++i) {
            MetaDocument doc = docs.get(i);
            clazz.addImport(DataFacadeGenerator.getDocumentImport(doc));
        }
        clazz.setName(JDBCPersistenceServiceGenerator.getInterfaceName(module));
        clazz.setType(TypeOfClass.INTERFACE);
        this.startClassBody();
        String throwsClause = " throws " + JDBCPersistenceServiceGenerator.getExceptionName(module);
        for (int i = 0; i < docs.size(); ++i) {
            MetaDocument doc = docs.get(i);
            String listDecl = "List<" + doc.getName() + ">";
            this.appendComment("Returns all " + doc.getMultiple() + " objects stored.");
            this.appendStatement("public " + listDecl + " get" + doc.getMultiple() + "()" + throwsClause);
            JDBCPersistenceServiceGenerator.emptyline();
            this.appendComment("Deletes a " + doc.getName() + " object by id.");
            this.appendStatement("public void delete" + doc.getName() + "(String id)" + throwsClause);
            JDBCPersistenceServiceGenerator.emptyline();
            this.appendComment("Deletes multiple " + doc.getName() + " object.");
            this.appendStatement("public void delete" + doc.getMultiple() + "(" + listDecl + " list)" + throwsClause);
            JDBCPersistenceServiceGenerator.emptyline();
            this.appendComment("Returns the " + doc.getName() + " object with the specified id.");
            this.appendStatement("public " + doc.getName() + " get" + doc.getName() + "(String id)" + throwsClause + ", " + JDBCPersistenceServiceGenerator.getItemNotFoundExceptionName(doc, module));
            JDBCPersistenceServiceGenerator.emptyline();
            this.appendComment("Imports a new " + doc.getName() + " object.\nReturns the imported version.");
            this.appendStatement("public " + doc.getName() + " import" + doc.getName() + "(" + doc.getName() + " " + doc.getVariableName() + ")" + throwsClause);
            JDBCPersistenceServiceGenerator.emptyline();
            this.appendComment("Imports multiple new " + doc.getName() + " objects.\nReturns the imported versions.");
            this.appendStatement("public " + listDecl + " import" + doc.getMultiple() + "(" + listDecl + " list)" + throwsClause);
            JDBCPersistenceServiceGenerator.emptyline();
            this.appendComment("Creates a new " + doc.getName() + " object.\nReturns the created version.");
            this.appendStatement("public " + doc.getName() + " create" + doc.getName() + "(" + doc.getName() + " " + doc.getVariableName() + ")" + throwsClause);
            JDBCPersistenceServiceGenerator.emptyline();
            this.appendComment("Creates multiple new " + doc.getName() + " objects.\nReturns the created versions.");
            this.appendStatement("public " + listDecl + " create" + doc.getMultiple() + "(" + listDecl + " list)" + throwsClause);
            JDBCPersistenceServiceGenerator.emptyline();
            this.appendComment("Updates a " + doc.getName() + " object.\nReturns the updated version.");
            this.appendStatement("public " + doc.getName() + " update" + doc.getName() + "(" + doc.getName() + " " + doc.getVariableName() + ")" + throwsClause);
            JDBCPersistenceServiceGenerator.emptyline();
            this.appendComment("Updates multiple " + doc.getName() + " object.\nReturns the updated versions.");
            this.appendStatement("public " + listDecl + " update" + doc.getMultiple() + "(" + listDecl + " list)" + throwsClause);
            JDBCPersistenceServiceGenerator.emptyline();
            this.appendComment("Returns all " + doc.getName() + " objects which match the given property or properties.");
            this.appendStatement("public " + listDecl + " get" + doc.getMultiple() + "ByProperty(QueryProperty... properties)" + throwsClause);
            JDBCPersistenceServiceGenerator.emptyline();
            this.appendComment("Returns all " + doc.getMultiple() + " count.");
            this.appendStatement("public int get" + doc.getMultiple() + "Count()" + throwsClause);
            JDBCPersistenceServiceGenerator.emptyline();
            this.appendComment("Returns " + doc.getMultiple() + " objects segment.");
            this.appendStatement("public " + listDecl + " get" + doc.getMultiple() + "(Segment aSegment)" + throwsClause);
            JDBCPersistenceServiceGenerator.emptyline();
            this.appendComment("Returns " + doc.getName() + " objects segment which match the given property or properties.");
            this.appendStatement("public " + listDecl + " get" + doc.getMultiple() + "ByProperty(Segment aSegment, QueryProperty... properties)" + throwsClause);
            JDBCPersistenceServiceGenerator.emptyline();
        }
        return clazz;
    }

    private String getDAOVariableName(MetaDocument doc) {
        return doc.getVariableName() + "DAO";
    }

    private GeneratedClass generateImplementation(MetaModule module) {
        MetaDocument doc;
        int i;
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        this.appendGenerationPoint("generateImplementation");
        clazz.setTypeComment(CommentGenerator.generateJavaTypeComment(JDBCPersistenceServiceGenerator.getImplementationName(module), "The implementation of the " + JDBCPersistenceServiceGenerator.getInterfaceName(module) + "."));
        clazz.setPackageName(this.getPackageName(module));
        clazz.addImport("java.util.List");
        clazz.addImport("java.util.ArrayList");
        clazz.addImport("java.util.Arrays");
        clazz.addImport("net.anotheria.util.sorter.SortType");
        clazz.addImport("net.anotheria.util.Date");
        clazz.addImport("net.anotheria.util.slicer.Segment");
        clazz.addImport("net.anotheria.anodoc.query2.QueryProperty");
        clazz.addImport("org.slf4j.MarkerFactory");
        List<MetaDocument> docs = module.getDocuments();
        for (MetaDocument doc2 : docs) {
            clazz.addImport(DataFacadeGenerator.getDocumentImport(doc2));
        }
        clazz.addImport("net.anotheria.db.service.BasePersistenceServiceJDBCImpl");
        clazz.addImport("net.anotheria.db.dao.DAOException");
        clazz.addImport("java.sql.Connection");
        clazz.addImport("java.sql.SQLException");
        JDBCPersistenceServiceGenerator.emptyline();
        clazz.setName(JDBCPersistenceServiceGenerator.getImplementationName(module));
        clazz.setParent("BasePersistenceServiceJDBCImpl");
        clazz.addInterface(JDBCPersistenceServiceGenerator.getInterfaceName(module));
        this.startClassBody();
        this.appendStatement("private static " + JDBCPersistenceServiceGenerator.getImplementationName(module) + " instance");
        JDBCPersistenceServiceGenerator.emptyline();
        this.appendCommentLine("DAO Objects for data access.");
        for (int i2 = 0; i2 < docs.size(); ++i2) {
            MetaDocument doc2;
            doc2 = docs.get(i2);
            this.appendStatement("private " + PersistenceServiceDAOGenerator.getDAOName(doc2) + " " + this.getDAOVariableName(doc2));
        }
        JDBCPersistenceServiceGenerator.emptyline();
        Object jdbcConfigName = "";
        if (module.getModuleOptions() != null && module.getModuleOptions().get("jdbcConfig") != null) {
            jdbcConfigName = module.getModuleOptions().get("jdbcConfig").getValue();
        }
        if (((String)jdbcConfigName).length() > 0) {
            jdbcConfigName = "\"" + (String)jdbcConfigName + "\"";
        }
        this.appendString("private " + JDBCPersistenceServiceGenerator.getImplementationName(module) + "(){");
        this.increaseIdent();
        this.appendStatement("super(" + (String)jdbcConfigName + ")");
        this.closeBlockNEW();
        JDBCPersistenceServiceGenerator.emptyline();
        this.appendString("static final " + JDBCPersistenceServiceGenerator.getImplementationName(module) + " getInstance(){");
        this.increaseIdent();
        this.appendString("if (instance==null){");
        this.increaseIdent();
        this.appendStatement("instance = new " + JDBCPersistenceServiceGenerator.getImplementationName(module) + "()");
        this.closeBlockNEW();
        this.appendStatement("return instance");
        this.closeBlockNEW();
        JDBCPersistenceServiceGenerator.emptyline();
        this.appendString("public void init(){");
        this.increaseIdent();
        this.appendStatement("super.init()");
        for (i = 0; i < docs.size(); ++i) {
            doc = docs.get(i);
            this.appendStatement(this.getDAOVariableName(doc) + " = new " + PersistenceServiceDAOGenerator.getDAOName(doc) + "(" + (String)jdbcConfigName + ")");
        }
        this.appendStatement("String currentDAO = null");
        this.openTry();
        this.appendStatement("Connection c = getConnection()");
        for (i = 0; i < docs.size(); ++i) {
            doc = docs.get(i);
            this.appendStatement("log.info(\"Initializing DAO for " + doc.getName() + "\" )");
            this.appendStatement("currentDAO = " + this.quote(doc.getName()));
            this.appendStatement(this.getDAOVariableName(doc) + ".init(c)");
        }
        this.decreaseIdent();
        this.appendString("}catch(DAOException e){");
        this.appendIncreasedStatement("log.error(MarkerFactory.getMarker(\"FATAL\"), \"init failed (dao:\"+currentDAO+\") \",e )");
        this.appendString("}catch(SQLException e){");
        this.appendIncreasedStatement("log.error(MarkerFactory.getMarker(\"FATAL\"), \"init failed (sql) \",e )");
        this.appendString("}catch(Exception e){");
        this.appendIncreasedStatement("System.out.println(e.getMessage()+\" \"+e.getClass())");
        this.appendIncreasedStatement("log.error(MarkerFactory.getMarker(\"FATAL\"), \"init failed (e) \",e )");
        this.appendString("}");
        this.closeBlockNEW();
        JDBCPersistenceServiceGenerator.emptyline();
        String throwsClause = " throws " + JDBCPersistenceServiceGenerator.getExceptionName(module);
        String callLog = null;
        for (int i3 = 0; i3 < docs.size(); ++i3) {
            MetaDocument doc3 = docs.get(i3);
            String listDecl = "List<" + doc3.getName() + ">";
            callLog = "\"Call get" + doc3.getMultiple() + "() \"";
            this.appendComment("Returns all " + doc3.getMultiple() + " objects stored.");
            this.openFun("public " + listDecl + " get" + doc3.getMultiple() + "()" + throwsClause);
            this.generateMethodStart(callLog);
            this.appendStatement("return " + this.getDAOVariableName(doc3) + ".get" + doc3.getMultiple() + "(c)");
            this.generateMethodEnd(module, callLog);
            this.closeBlockNEW();
            JDBCPersistenceServiceGenerator.emptyline();
            callLog = "\"Call delete" + doc3.getName() + "(\"+id+\") \"";
            this.appendComment("Deletes a " + doc3.getName() + " object by id.");
            this.openFun("public void delete" + doc3.getName() + "(String id)" + throwsClause);
            this.generateMethodStart(callLog);
            this.appendStatement(this.getDAOVariableName(doc3) + ".delete" + doc3.getName() + "(c, id)");
            this.generateMethodEnd(module, callLog);
            this.closeBlockNEW();
            JDBCPersistenceServiceGenerator.emptyline();
            callLog = "\"Call delete" + doc3.getMultiple() + "(\"+list+\") \"";
            this.appendComment("Deletes multiple  " + doc3.getName() + " objects.");
            this.openFun("public void delete" + doc3.getMultiple() + "(" + listDecl + " list)" + throwsClause);
            this.generateMethodStart(callLog);
            this.appendStatement(this.getDAOVariableName(doc3) + ".delete" + doc3.getMultiple() + "(c, list)");
            this.appendStatement("return");
            this.generateMethodEnd(module, callLog);
            this.closeBlockNEW();
            JDBCPersistenceServiceGenerator.emptyline();
            callLog = "\"Call get" + doc3.getName() + "(\"+id+\") \"";
            this.appendComment("Returns the " + doc3.getName() + " object with the specified id.");
            this.openFun("public " + doc3.getName() + " get" + doc3.getName() + "(String id)" + throwsClause);
            this.generateMethodStart(callLog);
            this.appendStatement("return " + this.getDAOVariableName(doc3) + ".get" + doc3.getName() + "(c, id)");
            this.decreaseIdent();
            this.appendString("}catch(" + PersistenceServiceDAOGenerator.getNoItemExceptionName(doc3) + " e){");
            this.appendIncreasedStatement("throw new " + JDBCPersistenceServiceGenerator.getItemNotFoundExceptionName(doc3, module) + "(id)");
            this.increaseIdent();
            this.generateMethodEnd(module, callLog);
            this.closeBlockNEW();
            JDBCPersistenceServiceGenerator.emptyline();
            callLog = "\"Call import" + doc3.getName() + "(\"+" + doc3.getVariableName() + "+\") \"";
            this.appendComment("Imports a new " + doc3.getName() + " object.\nReturns the imported version.");
            this.openFun("public " + doc3.getName() + " import" + doc3.getName() + "(" + doc3.getName() + " " + doc3.getVariableName() + ")" + throwsClause);
            this.generateMethodStart(callLog);
            this.appendStatement("return " + this.getDAOVariableName(doc3) + ".import" + doc3.getName() + "(c, " + doc3.getVariableName() + ")");
            this.generateMethodEnd(module, callLog);
            this.closeBlockNEW();
            JDBCPersistenceServiceGenerator.emptyline();
            callLog = "\"Call import" + doc3.getMultiple() + "(\"+list+\") \"";
            this.appendComment("Imports multiple new " + doc3.getName() + " objects.\nReturns the imported versions.");
            this.openFun("public " + listDecl + " import" + doc3.getMultiple() + "(" + listDecl + " list)" + throwsClause);
            this.generateMethodStart(callLog);
            this.appendStatement("return " + this.getDAOVariableName(doc3) + ".import" + doc3.getMultiple() + "(c, list)");
            this.generateMethodEnd(module, callLog);
            this.closeBlockNEW();
            JDBCPersistenceServiceGenerator.emptyline();
            callLog = "\"Call create" + doc3.getName() + "(\"+" + doc3.getVariableName() + "+\") \"";
            this.appendComment("Creates a new " + doc3.getName() + " object.\nReturns the created version.");
            this.openFun("public " + doc3.getName() + " create" + doc3.getName() + "(" + doc3.getName() + " " + doc3.getVariableName() + ")" + throwsClause);
            this.generateMethodStart(callLog);
            this.appendStatement("return " + this.getDAOVariableName(doc3) + ".create" + doc3.getName() + "(c, " + doc3.getVariableName() + ")");
            this.generateMethodEnd(module, callLog);
            this.closeBlockNEW();
            JDBCPersistenceServiceGenerator.emptyline();
            callLog = "\"Call create" + doc3.getMultiple() + "(\"+list+\") \"";
            this.appendComment("Creates multiple new " + doc3.getName() + " objects.\nReturns the created versions.");
            this.openFun("public " + listDecl + " create" + doc3.getMultiple() + "(" + listDecl + " list)" + throwsClause);
            this.generateMethodStart(callLog);
            this.appendStatement("return " + this.getDAOVariableName(doc3) + ".create" + doc3.getMultiple() + "(c, list)");
            this.generateMethodEnd(module, callLog);
            this.closeBlockNEW();
            JDBCPersistenceServiceGenerator.emptyline();
            callLog = "\"Call update" + doc3.getName() + "(\"+" + doc3.getVariableName() + "+\") \"";
            this.appendComment("Updates a " + doc3.getName() + " object.\nReturns the updated version.");
            this.openFun("public " + doc3.getName() + " update" + doc3.getName() + "(" + doc3.getName() + " " + doc3.getVariableName() + ")" + throwsClause);
            this.generateMethodStart(callLog);
            this.appendStatement("return " + this.getDAOVariableName(doc3) + ".update" + doc3.getName() + "(c, " + doc3.getVariableName() + ")");
            this.generateMethodEnd(module, callLog);
            this.closeBlockNEW();
            JDBCPersistenceServiceGenerator.emptyline();
            callLog = "\"Call update" + doc3.getMultiple() + "(\"+list+\") \"";
            this.appendComment("Updates multiple  " + doc3.getName() + " objects.\nReturns the updated versions.");
            this.openFun("public " + listDecl + " update" + doc3.getMultiple() + "(" + listDecl + " list)" + throwsClause);
            this.generateMethodStart(callLog);
            this.appendStatement("return " + this.getDAOVariableName(doc3) + ".update" + doc3.getMultiple() + "(c, list)");
            this.generateMethodEnd(module, callLog);
            this.closeBlockNEW();
            JDBCPersistenceServiceGenerator.emptyline();
            callLog = "\"Call get" + doc3.getMultiple() + "ByProperty(\"+properties+\") \"";
            this.appendComment("Returns all " + doc3.getName() + " objects which match the given property.");
            this.openFun("public " + listDecl + " get" + doc3.getMultiple() + "ByProperty(QueryProperty... properties)" + throwsClause);
            this.generateMethodStart(callLog);
            this.appendStatement("return " + this.getDAOVariableName(doc3) + ".get" + doc3.getMultiple() + "ByProperty(c, Arrays.asList(properties))");
            this.generateMethodEnd(module, callLog);
            this.closeBlockNEW();
            JDBCPersistenceServiceGenerator.emptyline();
            callLog = "\"Call get" + doc3.getMultiple() + "Count() \"";
            this.appendComment("Returns " + doc3.getMultiple() + " objects count.");
            this.openFun("public int get" + doc3.getMultiple() + "Count()" + throwsClause);
            this.generateMethodStart(callLog);
            this.appendStatement("return " + this.getDAOVariableName(doc3) + ".get" + doc3.getMultiple() + "Count(c)");
            this.generateMethodEnd(module, callLog);
            this.closeBlockNEW();
            JDBCPersistenceServiceGenerator.emptyline();
            callLog = "\"Call get" + doc3.getMultiple() + "(\" + aSegment + \") \"";
            this.appendComment("Returns " + doc3.getMultiple() + " objects segment.");
            this.openFun("public " + listDecl + " get" + doc3.getMultiple() + "(Segment aSegment)" + throwsClause);
            this.generateMethodStart(callLog);
            this.appendStatement("return " + this.getDAOVariableName(doc3) + ".get" + doc3.getMultiple() + "(c, aSegment)");
            this.generateMethodEnd(module, callLog);
            this.closeBlockNEW();
            JDBCPersistenceServiceGenerator.emptyline();
            callLog = "\"Call get" + doc3.getMultiple() + "ByProperty(\" + aSegment + \",\" + aProperties + \") \"";
            this.appendComment("Returns " + doc3.getName() + " objects segment which match the given property.");
            this.openFun("public " + listDecl + " get" + doc3.getMultiple() + "ByProperty(Segment aSegment, QueryProperty... aProperties)" + throwsClause);
            this.generateMethodStart(callLog);
            this.appendStatement("return " + this.getDAOVariableName(doc3) + ".get" + doc3.getMultiple() + "ByProperty(c, aSegment, Arrays.asList(aProperties))");
            this.generateMethodEnd(module, callLog);
            this.closeBlockNEW();
            JDBCPersistenceServiceGenerator.emptyline();
        }
        return clazz;
    }

    private void generateMethodStart(String callLog) {
        this.appendStatement("log.debug(" + callLog + ")");
        this.appendStatement("Connection c = null");
        this.openTry();
        this.appendStatement("c = getConnection()");
    }

    private void generateMethodEnd(MetaModule mod, String callLog) {
        this.decreaseIdent();
        this.appendString("}catch(SQLException e){");
        this.appendIncreasedStatement("log.error(\"" + callLog.substring(callLog.indexOf(32) + 1) + ",e)");
        this.appendIncreasedStatement("throw new " + JDBCPersistenceServiceGenerator.getExceptionName(mod) + "(e)");
        this.appendString("}catch(DAOException e){");
        this.appendIncreasedStatement("throw new " + JDBCPersistenceServiceGenerator.getExceptionName(mod) + "(e)");
        this.appendString("}finally{");
        this.appendIncreasedStatement("release(c)");
        this.appendString("}");
    }

    private GeneratedClass generateFactory(MetaModule module) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        this.appendGenerationPoint("generateFactory");
        clazz.setTypeComment(CommentGenerator.generateJavaTypeComment(JDBCPersistenceServiceGenerator.getFactoryName(module), "The factory for the " + JDBCPersistenceServiceGenerator.getInterfaceName(module) + " implementation."));
        clazz.setPackageName(this.getPackageName(module));
        clazz.setName(JDBCPersistenceServiceGenerator.getFactoryName(module));
        this.startClassBody();
        this.appendString("public static " + JDBCPersistenceServiceGenerator.getInterfaceName(module) + " create" + JDBCPersistenceServiceGenerator.getServiceName(module) + "(){");
        this.increaseIdent();
        this.appendString("return " + JDBCPersistenceServiceGenerator.getImplementationName(module) + ".getInstance();");
        this.closeBlockNEW();
        return clazz;
    }

    public static final String getExceptionName(MetaModule m) {
        return JDBCPersistenceServiceGenerator.getServiceName(m) + "Exception";
    }

    public static String getInterfaceName(MetaModule m) {
        return "I" + JDBCPersistenceServiceGenerator.getServiceName(m);
    }

    public static String getServiceName(MetaModule m) {
        return m.getName() + "PersistenceService";
    }

    public static String getFactoryName(MetaModule m) {
        return JDBCPersistenceServiceGenerator.getServiceName(m) + "Factory";
    }

    public static String getImplementationName(MetaModule m) {
        return JDBCPersistenceServiceGenerator.getServiceName(m) + "Impl";
    }

    public static String getPackageName(Context context, MetaModule module) {
        return context.getPackageName(module) + ".service.persistence";
    }

    public static final String getExceptionImport(Context c, MetaModule m) {
        return JDBCPersistenceServiceGenerator.getPackageName(c, m) + "." + JDBCPersistenceServiceGenerator.getExceptionName(m);
    }

    public static final String getFactoryImport(Context c, MetaModule m) {
        return JDBCPersistenceServiceGenerator.getPackageName(c, m) + "." + JDBCPersistenceServiceGenerator.getFactoryName(m);
    }

    public static final String getInterfaceImport(Context c, MetaModule m) {
        return JDBCPersistenceServiceGenerator.getPackageName(c, m) + "." + JDBCPersistenceServiceGenerator.getInterfaceName(m);
    }
}

