/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.model.db;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.asg.generator.AbstractGenerator;
import net.anotheria.asg.generator.CommentGenerator;
import net.anotheria.asg.generator.Context;
import net.anotheria.asg.generator.FileEntry;
import net.anotheria.asg.generator.GeneratedClass;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.IGenerateable;
import net.anotheria.asg.generator.IGenerator;
import net.anotheria.asg.generator.meta.MetaDocument;
import net.anotheria.asg.generator.meta.MetaListProperty;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.asg.generator.meta.MetaProperty;
import net.anotheria.asg.generator.model.DataFacadeGenerator;
import net.anotheria.asg.generator.model.db.VOGenerator;
import net.anotheria.util.ExecutionTimer;
import net.anotheria.util.StringUtils;

public class PersistenceServiceDAOGenerator
extends AbstractGenerator
implements IGenerator {
    @Override
    public List<FileEntry> generate(IGenerateable gmodule) {
        MetaModule mod = (MetaModule)gmodule;
        ArrayList<FileEntry> ret = new ArrayList<FileEntry>();
        ExecutionTimer timer = new ExecutionTimer(mod.getName() + "-DaoGen");
        List<MetaDocument> documents = mod.getDocuments();
        for (MetaDocument d : documents) {
            timer.startExecution(d.getName());
            timer.startExecution(d.getName() + "Exc");
            ret.add(new FileEntry(this.generateException(d)));
            timer.stopExecution(d.getName() + "Exc");
            timer.startExecution(d.getName() + "NoItemE");
            ret.add(new FileEntry(this.generateNoItemException(d)));
            timer.stopExecution(d.getName() + "NoItemE");
            timer.startExecution(d.getName() + "DAO");
            ret.add(new FileEntry(this.generateDAO(d)));
            timer.stopExecution(d.getName() + "DAO");
            timer.startExecution(d.getName() + "RowMapper");
            ret.add(new FileEntry(this.generateRowMapper(d)));
            timer.stopExecution(d.getName() + "RowMapper");
            timer.stopExecution(d.getName());
        }
        return ret;
    }

    private String getPackageName(MetaModule module) {
        return GeneratorDataRegistry.getInstance().getContext().getPackageName(module) + ".service.persistence";
    }

    private GeneratedClass generateException(MetaDocument doc) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        clazz.setTypeComment(CommentGenerator.generateJavaTypeComment(PersistenceServiceDAOGenerator.getExceptionName(doc), this));
        clazz.setPackageName(this.getPackageName(doc.getParentModule()));
        clazz.addImport("net.anotheria.db.dao.DAOException");
        clazz.setName(PersistenceServiceDAOGenerator.getExceptionName(doc));
        clazz.setParent("DAOException");
        this.startClassBody();
        this.appendString("public " + PersistenceServiceDAOGenerator.getExceptionName(doc) + "(String message){");
        this.appendIncreasedStatement("super(message)");
        this.appendString("}");
        PersistenceServiceDAOGenerator.emptyline();
        this.appendString("public " + PersistenceServiceDAOGenerator.getExceptionName(doc) + "(){");
        this.appendIncreasedStatement("super()");
        this.appendString("}");
        return clazz;
    }

    private GeneratedClass generateNoItemException(MetaDocument doc) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        clazz.setTypeComment(CommentGenerator.generateJavaTypeComment(PersistenceServiceDAOGenerator.getNoItemExceptionName(doc), this));
        clazz.setPackageName(this.getPackageName(doc.getParentModule()));
        clazz.setName(PersistenceServiceDAOGenerator.getNoItemExceptionName(doc));
        clazz.setParent(PersistenceServiceDAOGenerator.getExceptionName(doc));
        this.startClassBody();
        this.appendString("public " + PersistenceServiceDAOGenerator.getNoItemExceptionName(doc) + "(String id){");
        this.appendIncreasedStatement("super(" + this.quote("No item found for id: ") + "+id)");
        this.appendString("}");
        this.appendString("public " + PersistenceServiceDAOGenerator.getNoItemExceptionName(doc) + "(long id){");
        this.appendIncreasedStatement("this(" + this.quote("") + "+id)");
        this.appendString("}");
        return clazz;
    }

    private String getAttributeConst(MetaProperty p) {
        return "ATT_NAME_" + p.getName().toUpperCase();
    }

    private String getAttributeName(MetaProperty p) {
        return p.getName().toLowerCase();
    }

    private GeneratedClass generateRowMapper(MetaDocument doc) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        Context context = GeneratorDataRegistry.getInstance().getContext();
        clazz.setTypeComment(CommentGenerator.generateJavaTypeComment(PersistenceServiceDAOGenerator.getRowMapperName(doc), this));
        clazz.setPackageName(this.getPackageName(doc.getParentModule()));
        clazz.addImport("java.sql.ResultSet");
        clazz.addImport("java.sql.SQLException");
        clazz.addImport("net.anotheria.db.dao.RowMapper");
        clazz.addImport("net.anotheria.db.dao.RowMapperException");
        clazz.addImport(DataFacadeGenerator.getDocumentImport(doc));
        clazz.addImport(VOGenerator.getDocumentImport(context, doc));
        clazz.setName(PersistenceServiceDAOGenerator.getRowMapperName(doc));
        clazz.setParent("RowMapper<" + doc.getName() + ">");
        clazz.setGenerateLogger(true);
        this.startClassBody();
        this.openFun("public " + doc.getName() + " map(ResultSet row) throws RowMapperException");
        this.openTry();
        this.appendStatement("long id = row.getLong(1)");
        this.appendStatement(doc.getName() + " ret = new " + VOGenerator.getDocumentImplName(doc) + "(\"\"+id)");
        for (int i = 0; i < doc.getProperties().size(); ++i) {
            this.generateProperty2DBMapping(doc.getProperties().get(i), i + 2);
        }
        int ioffset = doc.getProperties().size();
        for (int i = 0; i < doc.getLinks().size(); ++i) {
            this.generateProperty2DBMapping(doc.getLinks().get(i), i + ioffset + 2);
        }
        ioffset = doc.getProperties().size() + doc.getLinks().size();
        this.generateProperty2DBMappingPrivate(doc, new MetaProperty("daoCreated", MetaProperty.Type.LONG), ioffset + 2);
        this.generateProperty2DBMappingPrivate(doc, new MetaProperty("daoUpdated", MetaProperty.Type.LONG), ioffset + 3);
        this.appendStatement("return ret");
        this.decreaseIdent();
        this.appendString("}catch(SQLException e){");
        this.appendIncreasedStatement("log.error(\"map\", e)");
        this.appendIncreasedStatement("throw new RowMapperException(e)");
        this.appendString("}");
        this.closeBlockNEW();
        return clazz;
    }

    private void generateProperty2DBMapping(MetaProperty p, int position) {
        if (p instanceof MetaListProperty) {
            this._generateArrayProperty2DBMapping((MetaListProperty)p, position);
        } else {
            this._generateProperty2DBMapping(p, position);
        }
    }

    private void _generateProperty2DBMapping(MetaProperty p, int position) {
        Object call = "";
        call = (String)call + "ret.set";
        call = (String)call + p.getAccesserName();
        call = (String)call + "(";
        call = (String)call + "row.";
        call = (String)call + p.toPropertyGetter();
        call = (String)call + "(" + position + "))";
        this.appendStatement(new String[]{call});
    }

    private void _generateArrayProperty2DBMapping(MetaListProperty p, int position) {
        Object call = "";
        call = (String)call + "ret.set";
        call = (String)call + p.getAccesserName();
        call = (String)call + "(";
        call = (String)call + "convertToList(";
        call = (String)call + "(" + p.getContainedProperty().toJavaType() + "[])";
        call = (String)call + "row.getArray";
        call = (String)call + "(" + position + ")";
        call = (String)call + ".getArray";
        call = (String)call + "()))";
        this.appendStatement(new String[]{call});
    }

    private void generateProperty2DBMappingPrivate(MetaDocument doc, MetaProperty p, int position) {
        Object call = "";
        call = (String)call + "((" + VOGenerator.getDocumentImplName(doc) + ")ret).set";
        call = (String)call + p.getAccesserName();
        call = (String)call + "(";
        call = (String)call + "row.";
        call = (String)call + p.toPropertyGetter();
        call = (String)call + "(" + position + "))";
        this.appendStatement(new String[]{call});
    }

    private void generateDB2PropertyMapping(String variableName, MetaProperty p, int position) {
        if (p instanceof MetaListProperty) {
            this._generateDB2ArrayPropertyMapping(variableName, (MetaListProperty)p, position);
        } else {
            this._generateDB2PropertyMapping(variableName, p, position);
        }
    }

    private void _generateDB2PropertyMapping(String variableName, MetaProperty p, int position) {
        Object call = "";
        call = (String)call + "ps.";
        call = (String)call + p.toPropertySetter();
        call = (String)call + "(" + position + ", ";
        call = (String)call + variableName + ".";
        call = (String)call + p.toGetter();
        call = (String)call + "())";
        this.appendStatement(new String[]{call});
    }

    private void _generateDB2ArrayPropertyMapping(String variableName, MetaListProperty p, int position) {
        Object call = "";
        call = (String)call + "ps.setArray";
        call = (String)call + "(" + position + ", ";
        call = (String)call + "new " + p.getContainedProperty().toJavaObjectType() + "Array(";
        call = (String)call + variableName + ".";
        call = (String)call + p.toGetter();
        call = (String)call + "()))";
        this.appendStatement(new String[]{call});
    }

    private String getDB2PropertyCallMapping(String variableName, MetaProperty p, String position) {
        if (p instanceof MetaListProperty) {
            return this._getDB2ArrayPropertyCallMapping(variableName, (MetaListProperty)p, position);
        }
        return this._getDB2PropertyCallMapping(variableName, p, position);
    }

    private String _getDB2PropertyCallMapping(String variableName, MetaProperty p, String position) {
        Object call = "";
        call = (String)call + "ps.";
        call = (String)call + p.toPropertySetter();
        call = (String)call + "(" + position + ", ";
        call = (String)call + "(" + p.toJavaObjectType() + ")" + variableName;
        call = (String)call + ")";
        return call;
    }

    private String _getDB2ArrayPropertyCallMapping(String variableName, MetaListProperty p, String position) {
        String call = "//Not implemented";
        return call;
    }

    private GeneratedClass generateDAO(MetaDocument doc) {
        int i;
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        ArrayList<MetaProperty> properties = new ArrayList<MetaProperty>();
        properties.addAll(doc.getProperties());
        properties.addAll(doc.getLinks());
        clazz.setTypeComment(CommentGenerator.generateJavaTypeComment(PersistenceServiceDAOGenerator.getDAOName(doc), this));
        clazz.setPackageName(this.getPackageName(doc.getParentModule()));
        boolean moduleDbContextSensitive = doc.getParentModule().isParameterEqual("db_context_sensitive", "true");
        clazz.addImport("java.util.List");
        clazz.addImport("java.util.ArrayList");
        clazz.addImport("java.util.concurrent.atomic.AtomicLong");
        if (moduleDbContextSensitive) {
            clazz.addImport("java.util.Map");
            clazz.addImport("java.util.HashMap");
        }
        clazz.addImport(DataFacadeGenerator.getDocumentImport(doc));
        clazz.addImport(VOGenerator.getDocumentImport(GeneratorDataRegistry.getInstance().getContext(), doc));
        clazz.addImport("net.anotheria.db.dao.DAO");
        clazz.addImport("net.anotheria.db.dao.DAOException");
        clazz.addImport("net.anotheria.db.dao.DAOSQLException");
        clazz.addImport("net.anotheria.db.dao.RowMapper");
        clazz.addImport("net.anotheria.anodoc.query2.QueryProperty");
        clazz.addImport("net.anotheria.anodoc.util.context.DBContext");
        clazz.addImport("net.anotheria.anodoc.util.context.ContextManager");
        clazz.addImport("net.anotheria.util.slicer.Segment");
        clazz.addImport("java.sql.Connection");
        clazz.addImport("java.sql.PreparedStatement");
        clazz.addImport("java.sql.ResultSet");
        clazz.addImport("java.sql.SQLException");
        clazz.addImport("java.sql.Statement");
        clazz.addImport("org.slf4j.Logger");
        clazz.addImport("org.slf4j.LoggerFactory");
        clazz.addImport("net.anotheria.db.config.JDBCConfigFactory");
        clazz.addImport("net.anotheria.db.config.JDBCConfig");
        for (MetaProperty p : properties) {
            if (!(p instanceof MetaListProperty)) continue;
            clazz.addImport("net.anotheria.db.array." + ((MetaListProperty)p).getContainedProperty().toJavaObjectType() + "Array");
        }
        clazz.setName(PersistenceServiceDAOGenerator.getDAOName(doc));
        clazz.addInterface("DAO");
        this.startClassBody();
        this.appendStatement("private static Logger log = LoggerFactory.getLogger(" + PersistenceServiceDAOGenerator.getDAOName(doc) + ".class)");
        String constDecl = "public static final String ";
        this.appendStatement(constDecl + "TABNAME = " + this.quote(this.getSQLTableName(doc)));
        PersistenceServiceDAOGenerator.emptyline();
        MetaProperty id = new MetaProperty("id", MetaProperty.Type.STRING);
        MetaProperty dao_created = new MetaProperty("dao_created", MetaProperty.Type.LONG);
        MetaProperty dao_updated = new MetaProperty("dao_updated", MetaProperty.Type.LONG);
        this.appendStatement(constDecl + this.getAttributeConst(id) + " = " + this.quote(this.getAttributeName(id)));
        for (MetaProperty p : properties) {
            this.appendStatement(constDecl + this.getAttributeConst(p) + " \t = " + this.quote(this.getAttributeName(p)));
        }
        PersistenceServiceDAOGenerator.emptyline();
        String sqlCreate1 = this.quote("INSERT INTO ");
        StringBuilder sqlCreate2 = new StringBuilder(this.quote(" ("));
        sqlCreate2.append("+" + this.getAttributeConst(id));
        for (MetaProperty p : properties) {
            sqlCreate2.append("+" + this.quote(", ") + "+" + this.getAttributeConst(p));
        }
        sqlCreate2.append("+" + this.quote(", ") + "+" + this.getAttributeConst(dao_created));
        StringBuilder sqlCreateEnd = new StringBuilder(") VALUES (");
        for (int i2 = 0; i2 < properties.size() + 2; ++i2) {
            sqlCreateEnd.append("?");
            if (i2 >= properties.size() + 1) continue;
            sqlCreateEnd.append(",");
        }
        sqlCreateEnd.append(")");
        sqlCreate2.append("+").append(this.quote(sqlCreateEnd));
        this.appendStatement(constDecl + " SQL_CREATE_1 \t= " + sqlCreate1);
        this.appendStatement(constDecl + " SQL_CREATE_2 \t= " + sqlCreate2);
        String sqlUpdate1 = this.quote("UPDATE ");
        StringBuilder sqlUpdate2 = new StringBuilder(this.quote(" SET "));
        for (MetaProperty p : properties) {
            sqlUpdate2.append(" + ").append(this.getAttributeConst(p)).append(" + ").append(this.quote(" = ?, "));
        }
        sqlUpdate2.append(" + ").append(this.getAttributeConst(dao_updated)).append(" + ").append(this.quote(" = ?"));
        sqlUpdate2.append(" + ").append(this.quote(" WHERE ")).append(" + ").append(this.getAttributeConst(id)).append(" + ").append(this.quote(" = ?"));
        this.appendStatement(constDecl + " SQL_UPDATE_1 \t= " + sqlUpdate1);
        this.appendStatement(constDecl + " SQL_UPDATE_2 \t= " + sqlUpdate2.toString());
        String sqlDelete1 = this.quote("DELETE FROM ");
        String sqlDelete2 = this.quote(" WHERE ") + " + TABNAME +" + this.quote(".") + " + " + this.getAttributeConst(id) + " + " + this.quote(" = ?");
        this.appendStatement(constDecl + " SQL_DELETE_1 \t= " + sqlDelete1);
        this.appendStatement(constDecl + " SQL_DELETE_2 \t= " + sqlDelete2);
        StringBuilder allAttrbutes = new StringBuilder("\"");
        allAttrbutes.append("+").append(this.getAttributeConst(id));
        for (MetaProperty p : properties) {
            allAttrbutes.append("+").append(this.quote(", ")).append("+").append(this.getAttributeConst(p));
        }
        allAttrbutes.append("+" + this.quote(", ") + "+" + this.getAttributeConst(dao_created));
        allAttrbutes.append("+" + this.quote(", ") + "+" + this.getAttributeConst(dao_updated));
        allAttrbutes.append("+\"");
        String sqlReadOne1 = this.quote("SELECT " + allAttrbutes + " FROM ");
        String sqlReadOne2 = this.quote(" WHERE ") + " + TABNAME +" + this.quote(".") + " + " + this.getAttributeConst(id) + " + " + this.quote(" = ?");
        this.appendStatement(constDecl + " SQL_READ_ONE_1 \t= " + sqlReadOne1);
        this.appendStatement(constDecl + " SQL_READ_ONE_2 \t= " + sqlReadOne2);
        String sqlReadAll1 = this.quote("SELECT " + allAttrbutes + " FROM ");
        String sqlReadAll2 = this.quote(" ORDER BY id");
        this.appendStatement(constDecl + " SQL_READ_ALL_1 \t= " + sqlReadAll1);
        this.appendStatement(constDecl + " SQL_READ_ALL_2 \t= " + sqlReadAll2);
        String sqlReadAllByProperty1 = this.quote("SELECT " + allAttrbutes + " FROM ");
        String sqlReadAllByProperty2 = this.quote(" WHERE ");
        this.appendStatement(constDecl + " SQL_READ_ALL_BY_PROPERTY_1 \t= " + sqlReadAllByProperty1);
        this.appendStatement(constDecl + " SQL_READ_ALL_BY_PROPERTY_2 \t= " + sqlReadAllByProperty2);
        String sqlReadCount1 = this.quote("SELECT COUNT(id) FROM ");
        this.appendStatement(constDecl + " SQL_COUNT_1 \t= " + sqlReadCount1);
        String sqlReadLimit1 = this.quote(" LIMIT ?");
        String sqlReadOffcet1 = this.quote(" OFFSET ?");
        this.appendStatement(constDecl + " SQL_LIMIT_1 \t= " + sqlReadLimit1);
        this.appendStatement(constDecl + " SQL_OFFSET_1 \t= " + sqlReadOffcet1);
        PersistenceServiceDAOGenerator.emptyline();
        this.appendStatement("private RowMapper<" + doc.getName() + "> rowMapper = new " + doc.getName() + "RowMapper()");
        PersistenceServiceDAOGenerator.emptyline();
        if (moduleDbContextSensitive) {
            this.appendStatement("private Map<String,AtomicLong> lastIds = new HashMap<String,AtomicLong>()");
        } else {
            this.appendStatement("private AtomicLong lastId = new AtomicLong()");
        }
        PersistenceServiceDAOGenerator.emptyline();
        this.appendStatement("private final JDBCConfig dbConfig");
        PersistenceServiceDAOGenerator.emptyline();
        this.appendString("public " + PersistenceServiceDAOGenerator.getDAOName(doc) + "() {");
        this.increaseIdent();
        this.appendStatement("dbConfig = JDBCConfigFactory.getJDBCConfig()");
        this.closeBlockNEW();
        PersistenceServiceDAOGenerator.emptyline();
        this.appendString("public " + PersistenceServiceDAOGenerator.getDAOName(doc) + "(String jdbcConfig) {");
        this.increaseIdent();
        this.appendStatement("dbConfig = JDBCConfigFactory.getNamedJDBCConfig(jdbcConfig)");
        this.closeBlockNEW();
        PersistenceServiceDAOGenerator.emptyline();
        this.appendString("private AtomicLong getLastId(Connection con) throws DAOException {");
        this.increaseIdent();
        if (moduleDbContextSensitive) {
            this.appendStatement("DBContext context = ContextManager.getCallContext().getDbContext()");
            this.appendStatement("String tableName = context.getTableNameInContext(TABNAME)");
            this.appendStatement("AtomicLong lastId = lastIds.get(tableName)");
            this.appendString("if (lastId==null){");
            this.increaseIdent();
            this.appendCommentLine("double-checked-locking");
            this.appendString("synchronized(lastIds){");
            this.increaseIdent();
            this.appendStatement("lastId = lastIds.get(tableName)");
            this.appendString("if (lastId==null){");
            this.increaseIdent();
            this.appendStatement("long maxId = getMaxId(con, tableName)");
            this.appendStatement("maxId = maxId >= dbConfig.getStartId() ? maxId : dbConfig.getStartId()");
            this.appendStatement("lastId = new AtomicLong(maxId)");
            this.appendStatement("lastIds.put(tableName, lastId)");
            this.closeBlockNEW();
            this.closeBlockNEW();
            this.closeBlockNEW();
            this.appendStatement("return lastId");
        } else {
            this.appendStatement("return lastId");
        }
        this.closeBlockNEW();
        PersistenceServiceDAOGenerator.emptyline();
        this.appendString("private void adjustLastId(Connection con, long lastIdValue) throws DAOException {");
        this.increaseIdent();
        if (moduleDbContextSensitive) {
            this.appendStatement("throw new RuntimeException(\"Not yet implemented\")");
        } else {
            this.appendString("if (lastId.get()<lastIdValue)");
            this.appendIncreasedStatement("lastId.set(lastIdValue)");
        }
        this.closeBlockNEW();
        PersistenceServiceDAOGenerator.emptyline();
        this.appendString("private String createSQL(String sql1, String sql2){");
        this.increaseIdent();
        if (moduleDbContextSensitive) {
            this.appendStatement("DBContext context = ContextManager.getCallContext().getDbContext()");
            this.appendStatement("StringBuilder sql = new StringBuilder()");
            this.appendStatement("sql.append(sql1).append(context.getTableNameInContext(TABNAME)).append(sql2)");
            this.appendStatement("return sql.toString()");
        } else {
            this.appendStatement("StringBuilder sql = new StringBuilder()");
            this.appendStatement("sql.append(sql1).append(TABNAME).append(sql2)");
            this.appendStatement("return sql.toString()");
        }
        this.closeBlockNEW();
        PersistenceServiceDAOGenerator.emptyline();
        String throwsClause = " throws DAOException";
        Object callLog = "";
        callLog = this.quote("get" + doc.getMultiple() + "(") + "+con+" + this.quote(")");
        this.appendComment("Returns all " + doc.getMultiple() + " objects stored.");
        this.openFun("public List<" + doc.getName() + "> get" + doc.getMultiple() + "(Connection con)" + throwsClause);
        this.generateFunctionStart("SQL_READ_ALL", (String)callLog, true, true);
        this.appendStatement("result = ps.executeQuery()");
        this.appendStatement("ArrayList<" + doc.getName() + "> ret = new ArrayList<" + doc.getName() + ">()");
        this.appendString("while(result.next())");
        this.appendIncreasedStatement("ret.add(rowMapper.map(result))");
        this.appendStatement("return  ret");
        this.generateFunctionEnd((String)callLog, true, true);
        this.closeBlockNEW();
        PersistenceServiceDAOGenerator.emptyline();
        this.appendComment("Deletes a " + doc.getName() + " object by id.");
        callLog = this.quote("delete" + doc.getName() + "(") + "+con+" + this.quote(", ") + "+id+" + this.quote(")");
        this.openFun("public void delete" + doc.getName() + "(Connection con, String id)" + throwsClause);
        this.generateFunctionStart("SQL_DELETE", (String)callLog, true, false);
        this.appendStatement("ps.setLong(1, Long.parseLong(id))");
        this.appendStatement("int rows = ps.executeUpdate()");
        this.appendString("if (rows!=1 && rows!=0){");
        this.increaseIdent();
        this.appendStatement("log.warn(\"Deleted more than one row of " + doc.getName() + ": \"+id)");
        this.closeBlockNEW();
        this.generateFunctionEnd((String)callLog, true, false);
        this.closeBlockNEW();
        PersistenceServiceDAOGenerator.emptyline();
        String listDecl = "List<" + doc.getName() + ">";
        this.appendComment("Deletes multiple " + doc.getName() + " objects.");
        callLog = this.quote("delete" + doc.getMultiple() + "(") + "+con+" + this.quote(", ") + "+list+" + this.quote(")");
        this.openFun("public void delete" + doc.getMultiple() + "(Connection con, " + listDecl + " list)" + throwsClause);
        this.appendStatement("PreparedStatement ps = null");
        this.appendString("try{");
        this.increaseIdent();
        this.appendStatement("con.setAutoCommit(false)");
        this.appendStatement("ps = con.prepareStatement(createSQL(SQL_DELETE_1, SQL_DELETE_2))");
        this.appendString("for (" + doc.getName() + " " + doc.getVariableName() + " : list){");
        this.increaseIdent();
        this.appendStatement("ps.setLong(1, Long.parseLong(" + doc.getVariableName() + ".getId()))");
        this.appendStatement("int rows = ps.executeUpdate()");
        this.appendString("if (rows!=1 && rows!=0){");
        this.increaseIdent();
        this.appendStatement("log.warn(\"Deleted more than one row of " + doc.getName() + ": \"+" + doc.getVariableName() + ".getId())");
        this.closeBlockNEW();
        this.closeBlockNEW();
        this.appendStatement("con.commit()");
        this.generateFunctionEnd((String)callLog, true, false);
        this.closeBlockNEW();
        PersistenceServiceDAOGenerator.emptyline();
        callLog = this.quote("get" + doc.getName() + "(") + "+con+" + this.quote(", ") + "+id+" + this.quote(")");
        this.appendComment("Returns the " + doc.getName() + " object with the specified id.");
        this.openFun("public " + doc.getName() + " get" + doc.getName() + "(Connection con, String id)" + throwsClause);
        this.appendNullCheck("con", "Null arg: con");
        this.appendNullCheck("id", "Null arg: id");
        this.generateFunctionStart("SQL_READ_ONE", (String)callLog, true, true);
        this.appendStatement("ps.setLong(1, Long.parseLong(id))");
        this.appendStatement("result = ps.executeQuery()");
        this.appendString("if (!result.next())");
        this.appendIncreasedStatement("throw new " + PersistenceServiceDAOGenerator.getNoItemExceptionName(doc) + "(id)");
        this.appendStatement("return rowMapper.map(result)");
        this.generateFunctionEnd((String)callLog, true, true);
        this.closeBlockNEW();
        PersistenceServiceDAOGenerator.emptyline();
        int ii = 0;
        callLog = this.quote("import" + doc.getName() + "(") + "+con+" + this.quote(", ") + "+" + doc.getVariableName() + "+" + this.quote(")");
        this.appendComment("Imports a new " + doc.getName() + " object.\nReturns the imported version.");
        this.openFun("public " + doc.getName() + " import" + doc.getName() + "(Connection con, " + doc.getName() + " " + doc.getVariableName() + ")" + throwsClause);
        this.generateFunctionStart("SQL_CREATE", (String)callLog, true, false);
        this.appendStatement("ps.setLong(1, Long.parseLong(" + doc.getVariableName() + ".getId()))");
        for (int i3 = 0; i3 < properties.size(); ++i3) {
            this.generateDB2PropertyMapping(doc.getVariableName(), (MetaProperty)properties.get(i3), i3 + 2);
            ii = i3 + 2;
        }
        this.appendCommentLine("set create timestamp");
        this.appendStatement("ps.setLong(" + (ii + 1) + ", System.currentTimeMillis())");
        this.appendStatement("int rows = ps.executeUpdate()");
        this.appendString("if (rows!=1)");
        this.appendIncreasedStatement("throw new DAOException(\"Create failed, updated rows: \"+rows)");
        String copyResVarName = "new" + StringUtils.capitalize((String)doc.getVariableName());
        String createCopyCall = VOGenerator.getDocumentImplName(doc) + " " + copyResVarName + " = new " + VOGenerator.getDocumentImplName(doc);
        createCopyCall = createCopyCall + "(" + doc.getVariableName() + ".getId())";
        this.appendStatement(createCopyCall);
        this.appendStatement(copyResVarName + ".copyAttributesFrom(" + doc.getVariableName() + ")");
        this.appendStatement("adjustLastId(con, Long.parseLong(" + doc.getVariableName() + ".getId()))");
        this.appendStatement("return " + copyResVarName);
        this.generateFunctionEnd((String)callLog, true, false);
        this.closeBlockNEW();
        PersistenceServiceDAOGenerator.emptyline();
        ii = 0;
        callLog = this.quote("import " + doc.getMultiple() + "(") + "+con+" + this.quote(", ") + "+list+" + this.quote(")");
        this.appendComment("Imports multiple new " + doc.getName() + " objects.\nReturns the imported versions.");
        this.openFun("public " + listDecl + " import" + doc.getMultiple() + "(Connection con," + listDecl + " list)" + throwsClause);
        this.appendStatement("PreparedStatement ps = null");
        this.appendString("try{");
        this.increaseIdent();
        this.appendStatement("con.setAutoCommit(false)");
        this.appendStatement("ps = con.prepareStatement(createSQL(SQL_CREATE_1, SQL_CREATE_2))");
        this.appendStatement(listDecl + " ret = new ArrayList<" + doc.getName() + ">()");
        this.appendString("for (" + doc.getName() + " " + doc.getVariableName() + " : list){");
        this.increaseIdent();
        this.appendStatement("ps.setLong(1, Long.parseLong(" + doc.getVariableName() + ".getId()))");
        for (i = 0; i < properties.size(); ++i) {
            this.generateDB2PropertyMapping(doc.getVariableName(), (MetaProperty)properties.get(i), i + 2);
            ii = i + 2;
        }
        this.appendCommentLine("set create timestamp");
        this.appendStatement("ps.setLong(" + (ii + 1) + ", System.currentTimeMillis())");
        this.appendStatement("int rows = ps.executeUpdate()");
        this.appendString("if (rows!=1)");
        this.appendIncreasedStatement("throw new DAOException(\"Create failed, updated rows: \"+rows)");
        copyResVarName = "new" + StringUtils.capitalize((String)doc.getVariableName());
        createCopyCall = VOGenerator.getDocumentImplName(doc) + " " + copyResVarName + " = new " + VOGenerator.getDocumentImplName(doc);
        createCopyCall = createCopyCall + "(" + doc.getVariableName() + ".getId())";
        this.appendStatement(createCopyCall);
        this.appendStatement(copyResVarName + ".copyAttributesFrom(" + doc.getVariableName() + ")");
        this.appendStatement("adjustLastId(con, Long.parseLong(" + doc.getVariableName() + ".getId()))");
        this.appendStatement("ret.add(" + copyResVarName + ")");
        this.closeBlockNEW();
        this.appendStatement("con.commit()");
        this.appendStatement("return ret");
        this.generateFunctionEnd((String)callLog, true, false);
        this.closeBlockNEW();
        PersistenceServiceDAOGenerator.emptyline();
        ii = 0;
        callLog = this.quote("create" + doc.getName() + "(") + "+con+" + this.quote(", ") + "+" + doc.getVariableName() + "+" + this.quote(")");
        this.appendComment("Creates a new " + doc.getName() + " object.\nReturns the created version.");
        this.openFun("public " + doc.getName() + " create" + doc.getName() + "(Connection con, " + doc.getName() + " " + doc.getVariableName() + ")" + throwsClause);
        this.appendStatement("java.sql.SQLException throwable = null");
        this.appendString("for (int recoveryAttempt = 1; recoveryAttempt <= dbConfig.getIdRecoveryAttempts(); recoveryAttempt++) {");
        this.increaseIdent();
        this.appendStatement("PreparedStatement ps = null");
        this.openTry();
        this.appendStatement("con.setAutoCommit(false)");
        this.appendStatement("ps = con.prepareStatement(createSQL(SQL_CREATE_1, SQL_CREATE_2))");
        this.appendStatement("long nextId = getLastId(con).incrementAndGet()");
        this.appendStatement("ps.setLong(1, nextId)");
        for (i = 0; i < properties.size(); ++i) {
            this.generateDB2PropertyMapping(doc.getVariableName(), (MetaProperty)properties.get(i), i + 2);
            ii = i + 2;
        }
        this.appendCommentLine("set create timestamp");
        this.appendStatement("ps.setLong(" + (ii + 1) + ", System.currentTimeMillis())");
        this.appendStatement("int rows = ps.executeUpdate()");
        this.appendString("if (rows!=1)");
        this.appendIncreasedStatement("throw new DAOException(\"Create failed, updated rows: \"+rows)");
        copyResVarName = "new" + StringUtils.capitalize((String)doc.getVariableName());
        createCopyCall = VOGenerator.getDocumentImplName(doc) + " " + copyResVarName + " = new " + VOGenerator.getDocumentImplName(doc);
        createCopyCall = createCopyCall + "(\"\"+nextId)";
        this.appendStatement(createCopyCall);
        this.appendStatement(copyResVarName + ".copyAttributesFrom(" + doc.getVariableName() + ")");
        this.appendStatement("con.commit()");
        this.appendStatement("return " + copyResVarName);
        this.decreaseIdent();
        this.appendString("} catch (SQLException e) {");
        this.increaseIdent();
        this.appendStatement("getLastId(con).set(getMaxId(con,TABNAME))");
        this.appendStatement("log.warn(\"Failed attempt\" +recoveryAttempt+ \" from \" +dbConfig.getIdRecoveryAttempts()+ \" to create new entry in \"+TABNAME+\" table\", e)");
        this.appendStatement("throwable = e");
        this.appendStatement("continue");
        this.decreaseIdent();
        this.appendString("} finally {");
        this.increaseIdent();
        this.appendStatement("net.anotheria.db.util.JDBCUtil.release(ps)");
        this.closeBlockNEW();
        this.closeBlockNEW();
        this.appendStatement("log.error(\"All \"+ dbConfig.getIdRecoveryAttempts()+\" attempt of id rereading - Failed. \"+" + (String)callLog + ", throwable)");
        this.appendStatement("throw new DAOSQLException(throwable)");
        this.closeBlockNEW();
        PersistenceServiceDAOGenerator.emptyline();
        callLog = this.quote("create" + doc.getMultiple() + "(") + "+con+" + this.quote(", ") + "+list+" + this.quote(")");
        this.appendComment("Creates multiple new " + doc.getName() + " objects.\nReturns the created versions.");
        this.openFun("public " + listDecl + " create" + doc.getMultiple() + "(Connection con, " + listDecl + " list)" + throwsClause);
        this.appendStatement("java.sql.SQLException throwable = null");
        this.appendString("for (int recoveryAttempt = 1; recoveryAttempt <= dbConfig.getIdRecoveryAttempts(); recoveryAttempt++) {");
        this.increaseIdent();
        this.appendStatement("PreparedStatement ps = null");
        this.appendString("try{");
        this.increaseIdent();
        this.appendStatement("con.setAutoCommit(false)");
        this.appendStatement("ps = con.prepareStatement(createSQL(SQL_CREATE_1, SQL_CREATE_2))");
        this.appendStatement(listDecl + " ret = new ArrayList<" + doc.getName() + ">()");
        this.appendString("for (" + doc.getName() + " " + doc.getVariableName() + " : list){");
        this.increaseIdent();
        this.appendStatement("long nextId = getLastId(con).incrementAndGet()");
        this.appendStatement("ps.setLong(1, nextId)");
        for (i = 0; i < properties.size(); ++i) {
            this.generateDB2PropertyMapping(doc.getVariableName(), (MetaProperty)properties.get(i), i + 2);
            ii = i + 2;
        }
        this.appendCommentLine("set create timestamp");
        this.appendStatement("ps.setLong(" + (ii + 1) + ", System.currentTimeMillis())");
        this.appendStatement("int rows = ps.executeUpdate()");
        this.appendString("if (rows!=1)");
        this.appendIncreasedStatement("throw new DAOException(\"Create failed, updated rows: \"+rows)");
        copyResVarName = "new" + StringUtils.capitalize((String)doc.getVariableName());
        createCopyCall = VOGenerator.getDocumentImplName(doc) + " " + copyResVarName + " = new " + VOGenerator.getDocumentImplName(doc);
        createCopyCall = createCopyCall + "(\"\"+nextId)";
        this.appendStatement(createCopyCall);
        this.appendStatement(copyResVarName + ".copyAttributesFrom(" + doc.getVariableName() + ")");
        this.appendStatement("ret.add(" + copyResVarName + ")");
        this.closeBlockNEW();
        this.appendStatement("con.commit()");
        this.appendStatement("return ret");
        this.decreaseIdent();
        this.appendString("} catch (SQLException e) {");
        this.increaseIdent();
        this.appendStatement("getLastId(con).set(getMaxId(con,TABNAME))");
        this.appendStatement("log.warn(\"Failed attempt\" +recoveryAttempt+ \" from \" +dbConfig.getIdRecoveryAttempts()+ \" to create new entries (list) in \"+TABNAME+\" table\", e)");
        this.appendStatement("throwable = e");
        this.appendStatement("continue");
        this.decreaseIdent();
        this.appendString("} finally {");
        this.increaseIdent();
        this.appendStatement("net.anotheria.db.util.JDBCUtil.release(ps)");
        this.closeBlockNEW();
        this.closeBlockNEW();
        this.appendStatement("log.error(\"All \"+ dbConfig.getIdRecoveryAttempts()+\" attempt of id rereading - Failed. \"+" + (String)callLog + ", throwable)");
        this.appendStatement("throw new DAOSQLException(throwable)");
        this.closeBlockNEW();
        PersistenceServiceDAOGenerator.emptyline();
        callLog = this.quote("update" + doc.getName() + "(") + "+con+" + this.quote(", ") + "+" + doc.getVariableName() + "+" + this.quote(")");
        this.appendComment("Updates a " + doc.getName() + " object.\nReturns the updated version.");
        this.openFun("public " + doc.getName() + " update" + doc.getName() + "(Connection con, " + doc.getName() + " " + doc.getVariableName() + ")" + throwsClause);
        this.generateFunctionStart("SQL_UPDATE", (String)callLog, true, false);
        for (i = 0; i < properties.size(); ++i) {
            this.generateDB2PropertyMapping(doc.getVariableName(), (MetaProperty)properties.get(i), i + 1);
            ii = i + 1;
        }
        this.appendCommentLine("set update timestamp");
        this.appendStatement("ps.setLong(" + (ii + 1) + ", System.currentTimeMillis())");
        this.appendCommentLine("set id for the where clause");
        this.appendStatement("ps.setLong(" + (ii + 2) + ", Long.parseLong(" + doc.getVariableName() + ".getId()))");
        this.appendStatement("int rows = ps.executeUpdate()");
        this.appendString("if (rows!=1)");
        this.appendIncreasedStatement("throw new DAOException(\"Update failed, updated rows: \"+rows)");
        this.appendStatement("return " + doc.getVariableName());
        this.generateFunctionEnd((String)callLog, true, false);
        this.closeBlockNEW();
        PersistenceServiceDAOGenerator.emptyline();
        callLog = this.quote("update" + doc.getMultiple() + "(") + "+con+" + this.quote(", ") + "+list+" + this.quote(")");
        this.appendComment("Updates multiple new " + doc.getName() + " objects.\nReturns the updated versions.");
        this.openFun("public " + listDecl + " update" + doc.getMultiple() + "(Connection con, " + listDecl + " list)" + throwsClause);
        this.appendStatement("PreparedStatement ps = null");
        this.appendString("try{");
        this.increaseIdent();
        this.appendStatement("con.setAutoCommit(false)");
        this.appendStatement("ps = con.prepareStatement(createSQL(SQL_UPDATE_1, SQL_UPDATE_2))");
        this.appendStatement(listDecl + " ret = new ArrayList<" + doc.getName() + ">()");
        this.appendString("for (" + doc.getName() + " " + doc.getVariableName() + " : list){");
        this.increaseIdent();
        for (i = 0; i < properties.size(); ++i) {
            this.generateDB2PropertyMapping(doc.getVariableName(), (MetaProperty)properties.get(i), i + 1);
            ii = i + 1;
        }
        this.appendCommentLine("set update timestamp");
        this.appendStatement("ps.setLong(" + (ii + 1) + ", System.currentTimeMillis())");
        this.appendCommentLine("set id for the where clause");
        this.appendStatement("ps.setLong(" + (ii + 2) + ", Long.parseLong(" + doc.getVariableName() + ".getId()))");
        this.appendStatement("int rows = ps.executeUpdate()");
        this.appendString("if (rows!=1)");
        this.appendIncreasedStatement("throw new DAOException(\"Update failed, updated rows: \"+rows)");
        this.closeBlockNEW();
        this.appendStatement("con.commit()");
        this.appendStatement("return list");
        this.generateFunctionEnd((String)callLog, true, false);
        this.closeBlockNEW();
        PersistenceServiceDAOGenerator.emptyline();
        callLog = this.quote("get" + doc.getMultiple() + "ByProperty(") + "+con+" + this.quote(",") + "+ properties+" + this.quote(")");
        this.appendComment("Returns all " + doc.getMultiple() + " objects stored which matches given properties.");
        this.openFun("public List<" + doc.getName() + "> get" + doc.getMultiple() + "ByProperty(Connection con, List<QueryProperty> properties)" + throwsClause);
        this.appendStatement("PreparedStatement ps = null");
        this.appendStatement("ResultSet result = null");
        this.openTry();
        this.appendCommentLine("//enable caching of statements one day");
        this.appendStatement("String SQL = createSQL(SQL_READ_ALL_BY_PROPERTY_1, SQL_READ_ALL_BY_PROPERTY_2)");
        this.appendStatement("String whereClause = " + this.quote(""));
        this.appendString("for (QueryProperty p : properties){");
        this.increaseIdent();
        this.appendString("if (whereClause.length()>0)");
        this.appendIncreasedStatement("whereClause += " + this.quote(" AND "));
        this.appendStatement("String statement = p.unprepaireable()? (String) p.getValue(): " + this.quote("?"));
        this.appendStatement("whereClause += p.getName().toLowerCase()+p.getComparator()+statement");
        this.closeBlockNEW();
        this.appendStatement("SQL += whereClause");
        this.appendStatement("ps = con.prepareStatement(SQL)");
        this.appendStatement("int propertyPosition = 0");
        this.appendString("for (QueryProperty property: properties){");
        this.increaseIdent();
        this.appendString("if(property.unprepaireable())");
        this.appendIncreasedStatement("continue");
        this.appendStatement("setProperty(++propertyPosition, ps, property)");
        this.closeBlockNEW();
        this.appendStatement("result = ps.executeQuery()");
        this.appendStatement("ArrayList<" + doc.getName() + "> ret = new ArrayList<" + doc.getName() + ">()");
        this.appendString("while(result.next())");
        this.appendIncreasedStatement("ret.add(rowMapper.map(result))");
        this.appendStatement("return  ret");
        this.generateFunctionEnd((String)callLog, true, true);
        this.closeBlockNEW();
        PersistenceServiceDAOGenerator.emptyline();
        callLog = this.quote("get" + doc.getMultiple() + "Count(") + " + con + " + this.quote(")");
        this.appendComment("Returns " + doc.getMultiple() + " objects count.");
        this.openFun("public int get" + doc.getMultiple() + "Count(Connection con)" + throwsClause);
        this.appendStatement("PreparedStatement ps = null");
        this.appendStatement("ResultSet result = null");
        this.openTry();
        this.appendStatement("ps = con.prepareStatement(SQL_COUNT_1 + TABNAME)");
        this.appendStatement("result = ps.executeQuery()");
        this.appendStatement("int pCount = 0");
        this.appendString("if (result.next())");
        this.appendIncreasedStatement("pCount = result.getInt(1)");
        this.appendStatement("return pCount");
        this.generateFunctionEnd((String)callLog, true, true);
        this.closeBlockNEW();
        PersistenceServiceDAOGenerator.emptyline();
        callLog = this.quote("get" + doc.getMultiple() + "(") + " + con + " + this.quote(",") + "+ aSegment +" + this.quote(")");
        this.appendComment("Returns " + doc.getMultiple() + " objects segment.");
        this.openFun("public List<" + doc.getName() + "> get" + doc.getMultiple() + "(Connection con, Segment aSegment)" + throwsClause);
        this.generateFunctionStartWithLimitAndOffset("SQL_READ_ALL");
        this.appendStatement("int pLimit = aSegment.getElementsPerSlice()");
        this.appendStatement("int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice()");
        this.appendStatement("ps.setInt(1, pLimit)");
        this.appendStatement("ps.setInt(2, pOffset)");
        this.appendStatement("result = ps.executeQuery()");
        this.appendStatement("ArrayList<" + doc.getName() + "> ret = new ArrayList<" + doc.getName() + ">()");
        this.appendString("while(result.next())");
        this.appendIncreasedStatement("ret.add(rowMapper.map(result))");
        this.appendStatement("return  ret");
        this.generateFunctionEnd((String)callLog, true, true);
        this.closeBlockNEW();
        PersistenceServiceDAOGenerator.emptyline();
        callLog = this.quote("get" + doc.getMultiple() + "ByProperty(") + " + con + " + this.quote(",") + " + aSegment + " + this.quote(",") + " + properties + " + this.quote(")");
        this.appendComment("Returns " + doc.getMultiple() + " objects segment which matches given properties.");
        this.openFun("public List<" + doc.getName() + "> get" + doc.getMultiple() + "ByProperty(Connection con, Segment aSegment, List<QueryProperty> properties)" + throwsClause);
        this.appendStatement("PreparedStatement ps = null");
        this.appendStatement("ResultSet result = null");
        this.openTry();
        this.appendCommentLine("//enable caching of statements one day");
        this.appendStatement("String SQL = createSQL(SQL_READ_ALL_BY_PROPERTY_1, SQL_READ_ALL_BY_PROPERTY_2)");
        this.appendStatement("String whereClause = " + this.quote(""));
        this.appendString("for (QueryProperty p : properties){");
        this.increaseIdent();
        this.appendString("if (whereClause.length()>0)");
        this.appendIncreasedStatement("whereClause += " + this.quote(" AND "));
        this.appendStatement("String statement = p.unprepaireable()? (String) p.getValue(): " + this.quote("?"));
        this.appendStatement("whereClause += p.getName()+p.getComparator()+statement");
        this.closeBlockNEW();
        this.appendStatement("SQL += whereClause");
        this.appendStatement("SQL += SQL_READ_ALL_2 + SQL_LIMIT_1 + SQL_OFFSET_1");
        this.appendStatement("ps = con.prepareStatement(SQL)");
        this.appendStatement("int propertyPosition = 0");
        this.appendString("for (QueryProperty property: properties){");
        this.increaseIdent();
        this.appendString("if(property.unprepaireable())");
        this.appendIncreasedStatement("continue");
        this.appendStatement("setProperty(++propertyPosition, ps, property)");
        this.closeBlockNEW();
        this.appendStatement("int pLimit = aSegment.getElementsPerSlice()");
        this.appendStatement("int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice()");
        this.appendStatement("ps.setInt(++propertyPosition, pLimit)");
        this.appendStatement("ps.setInt(++propertyPosition, pOffset)");
        this.appendStatement("result = ps.executeQuery()");
        this.appendStatement("ArrayList<" + doc.getName() + "> ret = new ArrayList<" + doc.getName() + ">()");
        this.appendString("while(result.next())");
        this.appendIncreasedStatement("ret.add(rowMapper.map(result))");
        this.appendStatement("return  ret");
        this.generateFunctionEnd((String)callLog, true, true);
        this.closeBlockNEW();
        PersistenceServiceDAOGenerator.emptyline();
        this.openFun("private void setProperty(int position, PreparedStatement ps, QueryProperty property) throws SQLException");
        this.appendString("if(property.unprepaireable()){");
        this.increaseIdent();
        this.appendStatement("return");
        this.closeBlockNEW();
        for (MetaProperty p : properties) {
            this.appendString("if (" + this.getAttributeConst(p) + ".equals(property.getName().toLowerCase())){");
            this.increaseIdent();
            this.appendStatement(this.getDB2PropertyCallMapping("property.getValue()", p, "position"));
            this.appendStatement("return");
            this.closeBlockNEW();
        }
        MetaProperty rawId = new MetaProperty("id", MetaProperty.Type.LONG);
        this.appendString("if (" + this.getAttributeConst(id) + ".equals(property.getName())){");
        this.increaseIdent();
        this.appendStatement(this.getDB2PropertyCallMapping("property.getValue()", rawId, "position"));
        this.appendStatement("return");
        this.closeBlockNEW();
        this.appendString("if (" + this.quote(dao_created.getName()) + ".equals(property.getName())){");
        this.increaseIdent();
        this.appendStatement(this.getDB2PropertyCallMapping("property.getValue()", dao_created, "position"));
        this.appendStatement("return");
        this.closeBlockNEW();
        this.appendString("if (" + this.quote(dao_updated.getName()) + ".equals(property.getName())){");
        this.increaseIdent();
        this.appendStatement(this.getDB2PropertyCallMapping("property.getValue()", dao_updated, "position"));
        this.appendStatement("return");
        this.closeBlockNEW();
        this.closeBlockNEW();
        this.appendString("/* ---------- SQL --------- ");
        this.generateSQLCreate(doc, dao_created, dao_updated);
        this.appendString("   ---------- SQL --------- */");
        this.openFun("public void createStructure(Connection connection) " + throwsClause);
        this.appendCommentLine("not implemented");
        this.closeBlockNEW();
        PersistenceServiceDAOGenerator.emptyline();
        this.appendString("/* ---------- SQL --------- ");
        this.generateSQLDelete(doc);
        this.appendString("   ---------- SQL --------- */");
        this.openFun("public void deleteStructure(Connection connection) " + throwsClause);
        this.appendCommentLine("not implemented");
        this.closeBlockNEW();
        PersistenceServiceDAOGenerator.emptyline();
        this.openFun("private long getMaxId(Connection con, String tableName) " + throwsClause);
        this.appendStatement("Statement st = null");
        this.appendStatement("ResultSet result = null");
        this.openTry();
        this.appendStatement("con.setAutoCommit(true)");
        this.appendStatement("st = con.createStatement()");
        this.appendStatement("st.execute(\"SELECT MAX(\"+" + this.getAttributeConst(id) + "+\") FROM \"+tableName)");
        this.appendStatement("result = st.getResultSet()");
        this.appendStatement("long maxId = 0");
        this.appendString("if (result.next())");
        this.appendIncreasedStatement("maxId = result.getLong(1)");
        this.appendStatement("log.info(\"maxId in table \"+tableName+\" is \"+maxId)");
        this.appendStatement("return maxId");
        this.generateFunctionEnd(this.quote("getMaxId(") + "+con+" + this.quote(", ") + "+tableName+" + this.quote(")"), false, true);
        this.closeBlockNEW();
        PersistenceServiceDAOGenerator.emptyline();
        this.openFun("public void init(Connection con) " + throwsClause);
        this.appendStatement("log.debug(\"Called: init(\"+con+\")\")");
        if (!moduleDbContextSensitive) {
            this.appendStatement("long maxId = getMaxId(con, TABNAME)");
            this.appendStatement("maxId = maxId >= dbConfig.getStartId() ? maxId : dbConfig.getStartId()");
            this.appendStatement("lastId = new AtomicLong(maxId)");
        }
        this.closeBlockNEW();
        return clazz;
    }

    private void generateSQLDelete(MetaDocument doc) {
        this.appendString("DROP TABLE " + this.getSQLTableName(doc));
    }

    private void generateSQLCreate(MetaDocument doc, MetaProperty ... additionalProps) {
        int i;
        this.appendString("CREATE TABLE " + this.getSQLTableName(doc) + "(");
        this.appendString("id int8 PRIMARY KEY,");
        for (i = 0; i < doc.getProperties().size(); ++i) {
            this.appendString(this.getSQLPropertyDefinition(doc.getProperties().get(i)) + ",");
        }
        for (i = 0; i < doc.getLinks().size(); ++i) {
            this.appendString(this.getSQLPropertyDefinition(doc.getLinks().get(i)) + ",");
        }
        for (i = 0; i < additionalProps.length - 1; ++i) {
            this.appendString(this.getSQLPropertyDefinition(additionalProps[i]) + ",");
        }
        this.appendString(this.getSQLPropertyDefinition(additionalProps[additionalProps.length - 1]));
        this.appendString(")");
    }

    private String getSQLPropertyDefinition(MetaProperty p) {
        return this.getAttributeName(p) + " " + this.getSQLPropertyType(p);
    }

    private String getSQLPropertyType(MetaProperty p) {
        switch (p.getType()) {
            case STRING: {
                return "varchar";
            }
            case TEXT: {
                return "varchar";
            }
            case LONG: {
                return "int8";
            }
            case INT: {
                return "int";
            }
            case DOUBLE: {
                return "double precision";
            }
            case FLOAT: {
                return "float4";
            }
            case BOOLEAN: {
                return "boolean";
            }
        }
        return "UNKNOWN!";
    }

    private String getSQLTableName(MetaDocument doc) {
        return doc.getName().toLowerCase();
    }

    private void generateFunctionStart(String SQL_STATEMENT, String callLog, boolean usePreparedSt, boolean isNeedResultSet) {
        if (usePreparedSt) {
            this.appendStatement("PreparedStatement ps = null");
            if (isNeedResultSet) {
                this.appendStatement("ResultSet result = null");
            }
            this.openTry();
            this.appendStatement("con.setAutoCommit(true)");
            this.appendStatement("ps = con.prepareStatement(createSQL(" + SQL_STATEMENT + "_1, " + SQL_STATEMENT + "_2))");
        } else {
            this.appendStatement("Statement st = null");
            if (isNeedResultSet) {
                this.appendStatement("ResultSet result = null");
            }
            this.openTry();
            this.appendStatement("con.setAutoCommit(true)");
        }
    }

    private void generateFunctionStartWithLimitAndOffset(String SQL_STATEMENT) {
        this.appendStatement("PreparedStatement ps = null");
        this.appendStatement("ResultSet result = null");
        this.openTry();
        this.appendStatement("con.setAutoCommit(true)");
        this.appendStatement("ps = con.prepareStatement(createSQL(" + SQL_STATEMENT + "_1, " + SQL_STATEMENT + "_2) + SQL_LIMIT_1 + SQL_OFFSET_1)");
    }

    private void generateFunctionEnd(String callLog, boolean usePreparedSt, boolean isCloseResultSet) {
        this.decreaseIdent();
        this.appendString("} catch (SQLException e) {");
        this.increaseIdent();
        this.appendStatement("log.error(" + callLog + ", e)");
        this.appendStatement("throw new DAOSQLException(e)");
        this.decreaseIdent();
        this.appendString("} finally {");
        this.increaseIdent();
        if (isCloseResultSet) {
            this.appendStatement("net.anotheria.db.util.JDBCUtil.release(result)");
        }
        this.appendStatement("net.anotheria.db.util.JDBCUtil.release(" + (usePreparedSt ? "ps" : "st") + ")");
        this.closeBlockNEW();
    }

    public static final String getExceptionName(MetaDocument doc) {
        return PersistenceServiceDAOGenerator.getDAOName(doc) + "Exception";
    }

    public static final String getNoItemExceptionName(MetaDocument doc) {
        return PersistenceServiceDAOGenerator.getDAOName(doc) + "NoItemForIdFoundException";
    }

    public static String getDAOName(MetaDocument doc) {
        return doc.getName() + "DAO";
    }

    public static String getRowMapperName(MetaDocument doc) {
        return doc.getName() + "RowMapper";
    }
}

