/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.model.db;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.asg.generator.AbstractGenerator;
import net.anotheria.asg.generator.FileEntry;
import net.anotheria.asg.generator.GeneratedSQLFile;
import net.anotheria.asg.generator.GenerationJobManager;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.IGenerateable;
import net.anotheria.asg.generator.IGenerator;
import net.anotheria.asg.generator.meta.MetaDocument;
import net.anotheria.asg.generator.meta.MetaListProperty;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.asg.generator.meta.MetaProperty;
import net.anotheria.asg.generator.meta.StorageType;

public class SQLGenerator
extends AbstractGenerator
implements IGenerator {
    public List<FileEntry> generate(List<MetaModule> modules) {
        ArrayList<FileEntry> ret = new ArrayList<FileEntry>();
        ArrayList<MetaDocument> documents = new ArrayList<MetaDocument>();
        for (MetaModule m : modules) {
            if (!m.getStorageType().equals((Object)StorageType.DB)) continue;
            ret.addAll(this.generate(m));
            documents.addAll(m.getDocuments());
        }
        if (documents.size() > 0) {
            ret.addAll(this.generateAllScripts(documents));
        }
        return ret;
    }

    private List<FileEntry> generateAllScripts(List<MetaDocument> documents) {
        ArrayList<FileEntry> entries = new ArrayList<FileEntry>();
        GeneratedSQLFile allCreate = new GeneratedSQLFile("create_all");
        GeneratedSQLFile allDelete = new GeneratedSQLFile("delete_all");
        MetaProperty daoCreated = new MetaProperty("dao_created", MetaProperty.Type.LONG);
        MetaProperty daoUpdated = new MetaProperty("dao_updated", MetaProperty.Type.LONG);
        Object tableNames = "";
        for (MetaDocument doc : documents) {
            GenerationJobManager.getCurrentJob().setBuilder(allCreate.getBody());
            this.generateSQLCreate(doc, daoCreated, daoUpdated);
            SQLGenerator.emptyline();
            if (((String)tableNames).length() > 0) {
                tableNames = (String)tableNames + ",";
            }
            tableNames = (String)tableNames + this.getSQLTableName(doc);
            GenerationJobManager.getCurrentJob().setBuilder(allDelete.getBody());
            this.generateSQLDelete(doc);
            SQLGenerator.emptyline();
        }
        GenerationJobManager.getCurrentJob().setBuilder(allCreate.getBody());
        this.appendString("GRANT ALL ON " + (String)tableNames + " TO " + GeneratorDataRegistry.getInstance().getContext().getOwner() + " ; ");
        entries.add(new FileEntry(allCreate));
        entries.add(new FileEntry(allDelete));
        return entries;
    }

    @Override
    public List<FileEntry> generate(IGenerateable gmodule) {
        MetaModule mod = (MetaModule)gmodule;
        ArrayList<FileEntry> ret = new ArrayList<FileEntry>();
        List<MetaDocument> documents = mod.getDocuments();
        for (MetaDocument d : documents) {
            ret.add(new FileEntry(this.generateDocumentCreate(d)));
        }
        return ret;
    }

    public String getCreateScriptName(MetaDocument doc) {
        return "create_" + doc.getParentModule().getName().toLowerCase() + "_" + doc.getName().toLowerCase();
    }

    private GeneratedSQLFile generateDocumentCreate(MetaDocument doc) {
        GeneratedSQLFile file = new GeneratedSQLFile(this.getCreateScriptName(doc));
        this.startNewJob(file);
        MetaProperty daoCreated = new MetaProperty("dao_created", MetaProperty.Type.LONG);
        MetaProperty daoUpdated = new MetaProperty("dao_updated", MetaProperty.Type.LONG);
        this.generateSQLCreate(doc, daoCreated, daoUpdated);
        return file;
    }

    private void generateSQLDelete(MetaDocument doc) {
        this.appendString("DROP TABLE " + this.getSQLTableName(doc) + ";");
    }

    private void generateSQLCreate(MetaDocument doc, MetaProperty ... additionalProps) {
        int i;
        this.appendString("CREATE TABLE " + this.getSQLTableName(doc) + "(");
        this.increaseIdent();
        this.appendString("id int8 PRIMARY KEY,");
        for (i = 0; i < doc.getProperties().size(); ++i) {
            this.appendString(this.getSQLPropertyDefinition(doc.getProperties().get(i)) + ",");
        }
        for (i = 0; i < doc.getLinks().size(); ++i) {
            this.appendString(this.getSQLPropertyDefinition(doc.getLinks().get(i)) + ",");
        }
        for (i = 0; i < additionalProps.length - 1; ++i) {
            this.appendString(this.getSQLPropertyDefinition(additionalProps[i]) + ",");
        }
        this.appendString(this.getSQLPropertyDefinition(additionalProps[additionalProps.length - 1]));
        this.decreaseIdent();
        this.appendString(");");
    }

    private String getSQLPropertyDefinition(MetaProperty p) {
        return this.getAttributeName(p) + " " + this.getSQLPropertyType(p);
    }

    private String getSQLPropertyType(MetaProperty p) {
        switch (p.getType()) {
            case STRING: {
                return "varchar";
            }
            case TEXT: {
                return "varchar";
            }
            case LONG: {
                return "int8";
            }
            case INT: {
                return "int";
            }
            case DOUBLE: {
                return "double precision";
            }
            case FLOAT: {
                return "float4";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case LIST: {
                return this.getSQLPropertyType(((MetaListProperty)p).getContainedProperty()) + "[]";
            }
        }
        return "UNKNOWN!";
    }

    private String getSQLTableName(MetaDocument doc) {
        return doc.getName().toLowerCase();
    }

    private String getAttributeName(MetaProperty p) {
        return p.getName().toLowerCase();
    }
}

