/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.model.db;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.asg.generator.CommentGenerator;
import net.anotheria.asg.generator.Context;
import net.anotheria.asg.generator.FileEntry;
import net.anotheria.asg.generator.GeneratedClass;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.IGenerateable;
import net.anotheria.asg.generator.IGenerator;
import net.anotheria.asg.generator.meta.MetaContainerProperty;
import net.anotheria.asg.generator.meta.MetaDocument;
import net.anotheria.asg.generator.meta.MetaGenericProperty;
import net.anotheria.asg.generator.meta.MetaListProperty;
import net.anotheria.asg.generator.meta.MetaProperty;
import net.anotheria.asg.generator.meta.MetaTableProperty;
import net.anotheria.asg.generator.model.AbstractDataObjectGenerator;
import net.anotheria.util.StringUtils;

public class VOGenerator
extends AbstractDataObjectGenerator
implements IGenerator {
    public static final String DAO_CREATED = "daoCreated";
    public static final String DAO_UPDATED = "daoUpdated";
    MetaProperty id = new MetaProperty("id", MetaProperty.Type.STRING);
    MetaProperty daoCreated = new MetaProperty("daoCreated", MetaProperty.Type.LONG);
    MetaProperty daoUpdated = new MetaProperty("daoUpdated", MetaProperty.Type.LONG);

    @Override
    public List<FileEntry> generate(IGenerateable gdoc) {
        MetaDocument doc = (MetaDocument)gdoc;
        this.id.setReadonly(true);
        ArrayList<FileEntry> _ret = new ArrayList<FileEntry>();
        _ret.add(new FileEntry(this.generateDocument(doc)));
        _ret.add(new FileEntry(this.generateDocumentFactory(doc)));
        return _ret;
    }

    @Override
    public String getDataObjectImplName(MetaDocument doc) {
        return VOGenerator.getDocumentImplName(doc);
    }

    public static String getDocumentImplName(MetaDocument doc) {
        return doc.getName() + "VO";
    }

    public static String getClassImplName(MetaDocument doc) {
        return doc.getName() + "Document";
    }

    private GeneratedClass generateDocument(MetaDocument doc) {
        int i;
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        clazz.setPackageName(this.getPackageName(doc));
        clazz.setTypeComment(CommentGenerator.generateJavaTypeComment("The implementation of the " + doc.getName() + ".", this));
        for (i = 0; i < doc.getProperties().size(); ++i) {
            if (!(doc.getProperties().get(i) instanceof MetaContainerProperty)) continue;
            clazz.addImport("java.util.List");
            clazz.addImport("java.util.ArrayList");
        }
        for (i = 0; i < doc.getProperties().size(); ++i) {
            if (!(doc.getProperties().get(i) instanceof MetaTableProperty)) continue;
            clazz.addImport("java.util.List");
            clazz.addImport("java.util.ArrayList");
        }
        for (MetaProperty p : doc.getProperties()) {
            if (!p.isMultilingual() || !GeneratorDataRegistry.getInstance().getContext().areLanguagesSupported()) continue;
            clazz.addImport("net.anotheria.anodoc.util.context.ContextManager");
            break;
        }
        clazz.addImport("net.anotheria.asg.data.AbstractVO");
        clazz.addImport("net.anotheria.util.crypt.MD5Util");
        clazz.addImport("java.io.Serializable");
        clazz.addInterface(doc.getName());
        clazz.addInterface("Serializable");
        if (doc.isComparable()) {
            clazz.addImport("net.anotheria.util.sorter.IComparable");
            clazz.addImport("net.anotheria.util.BasicComparable");
            clazz.addInterface("IComparable");
            clazz.addInterface("Comparable<" + doc.getName() + ">");
        }
        this.appendMark(1);
        clazz.setName(VOGenerator.getDocumentImplName(doc));
        clazz.setParent("AbstractVO");
        this.startClassBody();
        this.appendMark(2);
        this.generatePropertyFields(doc);
        VOGenerator.emptyline();
        this.appendMark(3);
        this.generateDefaultConstructor(doc);
        VOGenerator.emptyline();
        this.appendMark(4);
        this.generateCloneConstructor(doc);
        VOGenerator.emptyline();
        this.generateBuilderConstructor(doc);
        VOGenerator.emptyline();
        this.generatePropertyAccessMethods(doc);
        VOGenerator.emptyline();
        this.generateToStringMethod(doc);
        VOGenerator.emptyline();
        this.generateCloneMethod(doc);
        VOGenerator.emptyline();
        this.generateCopyMethod(doc);
        VOGenerator.emptyline();
        this.generateGetPropertyValueMethod(doc);
        VOGenerator.emptyline();
        this.generateAdditionalMethods(doc);
        if (doc.isComparable()) {
            VOGenerator.emptyline();
            this.generateCompareMethod(doc);
        }
        VOGenerator.emptyline();
        this.generateDefNameMethod(doc);
        VOGenerator.emptyline();
        this.generateDefParentNameMethod(doc);
        VOGenerator.emptyline();
        this.generateGetFootprintMethod(doc);
        VOGenerator.emptyline();
        this.generateEqualsMethod(doc);
        return clazz;
    }

    private void generateDefaultConstructor(MetaDocument doc) {
        this.appendString("public " + VOGenerator.getDocumentImplName(doc) + "(String anId){");
        this.increaseIdent();
        this.appendStatement("id = anId");
        this.append(this.closeBlock());
    }

    private void generateCloneConstructor(MetaDocument doc) {
        this.appendString("public " + VOGenerator.getDocumentImplName(doc) + "(" + VOGenerator.getDocumentImplName(doc) + " toClone){");
        this.increaseIdent();
        this.appendStatement("this.id = toClone.id");
        this.appendStatement("copyAttributesFrom(toClone)");
        this.append(this.closeBlock());
    }

    private void generateBuilderConstructor(MetaDocument doc) {
        this.appendString(VOGenerator.getDocumentImplName(doc) + "(" + this.getDocumentBuilderName(doc) + " builder){");
        this.increaseIdent();
        this.appendStatement("id = " + this.quote(""));
        for (MetaProperty p : doc.getProperties()) {
            this.appendStatement(p.getName().toLowerCase(), " = ", "builder.", p.getName());
        }
        for (MetaProperty p : doc.getLinks()) {
            this.appendStatement(p.getName().toLowerCase(), " = ", "builder.", p.getName());
        }
        this.append(this.closeBlock());
    }

    private void generatePropertyFields(MetaDocument doc) {
        this._generatePropertyField(this.id);
        this._generatePropertyFields(doc.getProperties());
        this._generatePropertyFields(doc.getLinks());
        this._generatePropertyField(this.daoCreated);
        this._generatePropertyField(this.daoUpdated);
    }

    private MetaProperty getMetaGenericProperty(MetaListProperty p) {
        MetaGenericProperty tmp = new MetaGenericProperty(p.getName(), MetaProperty.Type.LIST, p.getContainedProperty());
        if (p.isMultilingual()) {
            tmp.setMultilingual(true);
        }
        return tmp;
    }

    private void _generatePropertyFields(List<MetaProperty> propertyList) {
        for (int i = 0; i < propertyList.size(); ++i) {
            MetaProperty p = propertyList.get(i);
            if (p instanceof MetaTableProperty) {
                List<MetaProperty> columns = ((MetaTableProperty)p).getColumns();
                for (int t = 0; t < columns.size(); ++t) {
                    this._generatePropertyField(columns.get(t));
                }
                continue;
            }
            if (p instanceof MetaListProperty) {
                this._generatePropertyField(this.getMetaGenericProperty((MetaListProperty)p));
                continue;
            }
            this._generatePropertyField(p);
        }
    }

    private void _generatePropertyField(MetaProperty p) {
        if (GeneratorDataRegistry.getInstance().getContext().areLanguagesSupported() && p.isMultilingual()) {
            throw new AssertionError((Object)"Multilingual support for VOs not yet implemented!");
        }
        this.appendStatement("private " + p.toJavaType() + " " + p.getName().toLowerCase());
    }

    private void generatePropertyAccessMethods(MetaDocument doc) {
        this.generatePropertyGetterMethod(this.id);
        this._generatePropertyAccessMethods(doc.getProperties());
        this._generatePropertyAccessMethods(doc.getLinks());
        this.generatePropertyGetterMethod(this.daoCreated);
        this.generatePropertySetterMethod(this.daoCreated);
        this.generatePropertyGetterMethod(this.daoUpdated);
        this.generatePropertySetterMethod(this.daoUpdated);
    }

    private void _generatePropertyAccessMethods(List<MetaProperty> properties) {
        for (int i = 0; i < properties.size(); ++i) {
            MetaProperty p = properties.get(i);
            this.generatePropertyGetterMethod(p);
            VOGenerator.emptyline();
            this.generatePropertySetterMethod(p);
            VOGenerator.emptyline();
        }
    }

    private void generatePropertyGetterMethod(MetaProperty p) {
        if (p instanceof MetaTableProperty) {
            this.generateTablePropertyGetterMethods((MetaTableProperty)p);
            return;
        }
        if (p instanceof MetaListProperty) {
            this.generateListPropertyGetterMethods((MetaListProperty)p);
            return;
        }
        if (GeneratorDataRegistry.getInstance().getContext().areLanguagesSupported() && p.isMultilingual()) {
            this.generatePropertyGetterMethodMultilingual(p);
            return;
        }
        this.appendString("public " + p.toJavaType() + " get" + p.getAccesserName() + "(){");
        this.increaseIdent();
        this.appendStatement("return " + p.getName().toLowerCase());
        this.append(this.closeBlock());
    }

    private void generatePropertyGetterMethodMultilingual(MetaProperty p) {
        for (String l : GeneratorDataRegistry.getInstance().getContext().getLanguages()) {
            this.appendString("public " + p.toJavaType() + " get" + p.getAccesserName(l) + "(){");
            this.increaseIdent();
            this.appendStatement("return " + p.toPropertyGetter() + "(" + p.toNameConstant(l) + ")");
            this.append(this.closeBlock());
            VOGenerator.emptyline();
        }
        this.appendString("public " + p.toJavaType() + " get" + p.getAccesserName() + "(){");
        this.increaseIdent();
        String v = "ContextManager.getCallContext().getCurrentLanguage()";
        this.appendStatement("return " + p.toPropertyGetter() + "(" + this.quote(p.getName() + "_") + "+" + v + ")");
        this.append(this.closeBlock());
        VOGenerator.emptyline();
    }

    private void generateListPropertyGetterMethods(MetaListProperty p) {
        MetaProperty tmp = this.getMetaGenericProperty(p);
        this.generatePropertyGetterMethod(tmp);
    }

    private void generateTablePropertyGetterMethods(MetaTableProperty p) {
        List<MetaProperty> columns = p.getColumns();
        for (int t = 0; t < columns.size(); ++t) {
            this.generatePropertyGetterMethod(columns.get(t));
        }
    }

    private void generatePropertySetterMethod(MetaProperty p) {
        if (p instanceof MetaTableProperty) {
            this.generateTablePropertySetterMethods((MetaTableProperty)p);
            return;
        }
        if (p instanceof MetaListProperty) {
            this.generateListPropertySetterMethods((MetaListProperty)p);
            return;
        }
        if (GeneratorDataRegistry.getInstance().getContext().areLanguagesSupported() && p.isMultilingual()) {
            this.generatePropertySetterMethodMultilingual(p);
            return;
        }
        this.appendString("public void set" + p.getAccesserName() + "(" + p.toJavaType() + " value){");
        this.increaseIdent();
        this.appendStatement("this." + p.getName().toLowerCase() + " = value");
        this.append(this.closeBlock());
    }

    private void generatePropertySetterMethodMultilingual(MetaProperty p) {
        for (String l : GeneratorDataRegistry.getInstance().getContext().getLanguages()) {
            this.appendString("public void set" + p.getAccesserName(l) + "(" + p.toJavaType() + " value){");
            this.increaseIdent();
            this.appendStatement(p.toPropertySetter() + "(" + p.toNameConstant(l) + ", value)");
            this.append(this.closeBlock());
            VOGenerator.emptyline();
        }
        this.appendString("public void set" + p.getAccesserName() + "(" + p.toJavaType() + " value){");
        this.increaseIdent();
        String v = "ContextManager.getCallContext().getCurrentLanguage()";
        this.appendStatement(p.toPropertySetter() + "((" + this.quote(p.getName() + "_") + "+" + v + "), value)");
        this.append(this.closeBlock());
        VOGenerator.emptyline();
    }

    private void generateListPropertySetterMethods(MetaListProperty p) {
        MetaProperty tmp = this.getMetaGenericProperty(p);
        this.generatePropertySetterMethod(tmp);
    }

    private void generateTablePropertySetterMethods(MetaTableProperty p) {
        List<MetaProperty> columns = p.getColumns();
        for (int t = 0; t < columns.size(); ++t) {
            this.generatePropertySetterMethod(columns.get(t));
        }
    }

    private void generateToStringMethod(MetaDocument doc) {
        this.appendString("public String toString(){");
        this.increaseIdent();
        this.appendStatement("String ret = " + this.quote(doc.getName() + " "));
        this.appendStatement("ret += \"[\"+getId()+\"] \"");
        List<MetaProperty> props = doc.getProperties();
        for (int i = 0; i < props.size(); ++i) {
            MetaProperty p = props.get(i);
            if (p instanceof MetaTableProperty) {
                List<MetaProperty> columns = ((MetaTableProperty)p).getColumns();
                for (int t = 0; t < columns.size(); ++t) {
                    MetaProperty pp = columns.get(t);
                    this.appendStatement("ret += " + this.quote(pp.getName() + ": ") + "+get" + pp.getAccesserName() + "()");
                    if (t >= columns.size() - 1) continue;
                    this.appendStatement("ret += \", \"");
                }
            } else {
                this.appendStatement("ret += " + this.quote(p.getName() + ": ") + "+get" + p.getAccesserName() + "()");
            }
            if (i >= props.size() - 1) continue;
            this.appendStatement("ret += \", \"");
        }
        this.appendStatement("return ret");
        this.append(this.closeBlock());
    }

    private void generateCloneMethod(MetaDocument doc) {
        this.appendString("public " + VOGenerator.getDocumentImplName(doc) + " clone(){");
        this.increaseIdent();
        this.appendStatement("return (" + VOGenerator.getDocumentImplName(doc) + ") super.clone()");
        this.append(this.closeBlock());
    }

    private void generateGetPropertyValueMethod(MetaDocument doc) {
        this.appendString("public Object getPropertyValue(String propertyName){");
        this.increaseIdent();
        ArrayList<MetaProperty> properties = new ArrayList<MetaProperty>(doc.getProperties());
        properties.addAll(doc.getLinks());
        this.appendString("if (" + this.id.toNameConstant() + ".equals(propertyName))");
        this.appendIncreasedStatement("return get" + this.id.getAccesserName() + "()");
        for (MetaProperty p : properties) {
            this.appendString("if (" + p.toNameConstant() + ".equals(propertyName))");
            this.appendIncreasedStatement("return get" + p.getAccesserName() + "()");
        }
        this.appendStatement("throw new RuntimeException(" + this.quote("No property getter for ") + "+propertyName)");
        this.append(this.closeBlock());
    }

    public static final String getDocumentImport(Context context, MetaDocument doc) {
        return context.getPackageName(doc) + ".data." + VOGenerator.getDocumentImplName(doc);
    }

    private void generateAdditionalMethods(MetaDocument doc) {
        List<MetaProperty> properties = doc.getProperties();
        for (MetaProperty p : properties) {
            if (p instanceof MetaContainerProperty) {
                this.generateContainerMethods((MetaContainerProperty)p);
            }
            if (p instanceof MetaTableProperty) {
                this.generateTableMethods((MetaTableProperty)p);
            }
            if (!(p instanceof MetaListProperty)) continue;
            this.generateListMethods((MetaListProperty)p);
        }
    }

    private void generateContainerMethods(MetaContainerProperty container) {
        this.appendString("public int " + VOGenerator.getContainerSizeGetterName(container) + "(){");
        this.increaseIdent();
        this.appendStatement("return get" + container.getAccesserName() + "().size()");
        this.append(this.closeBlock());
        VOGenerator.emptyline();
    }

    private void generateListMethods(MetaListProperty list) {
        MetaProperty genericList = this.getMetaGenericProperty(list);
        MetaProperty c = list.getContainedProperty();
        String decl = "public void " + VOGenerator.getContainerEntryAdderName(list) + "(";
        decl = decl + c.toJavaType() + " " + c.getName();
        decl = decl + "){";
        this.appendString(decl);
        this.increaseIdent();
        this.appendStatement(c.toJavaObjectType() + " p = new " + c.toJavaObjectType() + "(" + c.getName() + ")");
        this.appendStatement(genericList.toJavaType() + " tmp = get" + list.getAccesserName() + "()");
        this.appendStatement("tmp.add(p)");
        this.append(this.closeBlock());
        VOGenerator.emptyline();
        this.appendString("public void " + VOGenerator.getContainerEntryDeleterName(list) + "(int index){");
        this.increaseIdent();
        this.appendStatement("get" + list.getAccesserName() + "().remove(index)");
        this.append(this.closeBlock());
        VOGenerator.emptyline();
        this.appendString("public void " + VOGenerator.getContainerEntrySwapperName(list) + "(int index1, int index2){");
        this.increaseIdent();
        this.appendStatement(c.toJavaType() + " tmp1, tmp2");
        this.appendStatement(genericList.toJavaType() + " tmpList = get" + list.getAccesserName() + "()");
        this.appendStatement("tmp1 = ((" + c.toJavaObjectType() + ")tmpList.get(index1))");
        this.appendStatement("tmp2 = ((" + c.toJavaObjectType() + ")tmpList.get(index2))");
        this.appendStatement("tmpList.set(index1, tmp2)");
        this.appendStatement("tmpList.set(index2, tmp1)");
        this.append(this.closeBlock());
        VOGenerator.emptyline();
        this.appendString("public " + c.toJavaType() + " " + VOGenerator.getListElementGetterName(list) + "(int index){");
        this.increaseIdent();
        this.appendStatement(c.toJavaType() + " p = (" + c.toJavaObjectType() + ")get" + list.getAccesserName() + "().get(index)");
        this.appendStatement("return p");
        this.append(this.closeBlock());
        VOGenerator.emptyline();
    }

    private void generateTableMethods(MetaTableProperty table) {
        MetaProperty p;
        int i;
        List<MetaProperty> columns = table.getColumns();
        String decl = "public void " + VOGenerator.getContainerEntryAdderName(table) + "(";
        for (i = 0; i < columns.size(); ++i) {
            p = columns.get(i);
            decl = decl + "String " + table.extractSubName(p);
            if (i >= columns.size() - 1) continue;
            decl = decl + ", ";
        }
        decl = decl + "){";
        this.appendString(decl);
        this.increaseIdent();
        this.appendStatement("List tmp");
        for (i = 0; i < columns.size(); ++i) {
            p = columns.get(i);
            this.appendStatement("tmp = getList(" + p.toNameConstant() + ")");
            this.appendStatement("tmp.add(new StringProperty(\"\", " + table.extractSubName(p) + "))");
            this.appendStatement("setList(" + p.toNameConstant() + ", tmp)");
            VOGenerator.emptyline();
        }
        this.append(this.closeBlock());
        VOGenerator.emptyline();
        this.appendString("public void " + VOGenerator.getContainerEntryDeleterName(table) + "(int index){");
        this.increaseIdent();
        for (i = 0; i < columns.size(); ++i) {
            p = columns.get(i);
            this.appendStatement("getListProperty(" + p.toNameConstant() + ").remove(index)");
        }
        this.append(this.closeBlock());
        VOGenerator.emptyline();
        this.appendString("public List get" + StringUtils.capitalize((String)table.getName()) + "Row(int index){");
        this.increaseIdent();
        this.appendStatement("List ret = new ArrayList(1)");
        for (i = 0; i < columns.size(); ++i) {
            p = columns.get(i);
            this.appendString("try{");
            this.appendIncreasedStatement("ret.add(((StringProperty)getList(" + p.toNameConstant() + ").get(index)).getString())");
            this.appendString("}catch(IndexOutOfBoundsException e){ ");
            this.appendIncreasedStatement("ret.add(\"\")");
            this.appendString("}");
        }
        this.appendStatement("return ret");
        this.append(this.closeBlock());
        VOGenerator.emptyline();
        this.appendString("public List " + VOGenerator.getTableGetterName(table) + "(){");
        this.increaseIdent();
        this.appendStatement("int size = " + VOGenerator.getContainerSizeGetterName(table) + "();");
        this.appendStatement("List ret = new java.util.ArrayList(size)");
        this.appendString("for (int i=0; i<size; i++)");
        this.appendIncreasedStatement("ret.add(get" + StringUtils.capitalize((String)table.getName()) + "Row(i))");
        this.appendStatement("return ret");
        this.append(this.closeBlock());
        VOGenerator.emptyline();
    }

    public static String getContainerSizeGetterName(MetaContainerProperty p) {
        return "get" + StringUtils.capitalize((String)p.getName()) + "Size";
    }

    public static String getTableGetterName(MetaTableProperty p) {
        return "get" + StringUtils.capitalize((String)p.getName()) + "Table";
    }

    public static String getContainerEntryAdderName(MetaContainerProperty p) {
        return "add" + StringUtils.capitalize((String)p.getName()) + p.getContainerEntryName();
    }

    public static String getContainerEntryDeleterName(MetaContainerProperty p) {
        return "remove" + StringUtils.capitalize((String)p.getName()) + p.getContainerEntryName();
    }

    public static String getContainerEntrySwapperName(MetaContainerProperty p) {
        return "swap" + StringUtils.capitalize((String)p.getName()) + p.getContainerEntryName();
    }

    public static String getListElementGetterName(MetaListProperty list) {
        return "get" + StringUtils.capitalize((String)list.getName()) + list.getContainerEntryName();
    }

    private void generateCopyMethod(MetaDocument doc) {
        this.appendString("public void copyAttributesFrom(" + doc.getName() + " toCopy){");
        this.increaseIdent();
        for (MetaProperty p : doc.getProperties()) {
            this.appendStatement("this." + p.getName().toLowerCase() + " = toCopy." + p.toGetter() + "()");
        }
        for (MetaProperty p : doc.getLinks()) {
            this.appendStatement("this." + p.getName().toLowerCase() + " = toCopy." + p.toGetter() + "()");
        }
        this.append(this.closeBlock());
    }
}

