/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.model.docs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.anotheria.anodoc.util.mapper.ObjectMapperUtil;
import net.anotheria.asg.generator.CommentGenerator;
import net.anotheria.asg.generator.Context;
import net.anotheria.asg.generator.FileEntry;
import net.anotheria.asg.generator.GeneratedClass;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.IGenerateable;
import net.anotheria.asg.generator.IGenerator;
import net.anotheria.asg.generator.meta.MetaDocument;
import net.anotheria.asg.generator.meta.MetaLink;
import net.anotheria.asg.generator.meta.MetaListProperty;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.asg.generator.meta.MetaProperty;
import net.anotheria.asg.generator.model.AbstractServiceGenerator;
import net.anotheria.asg.generator.model.DataFacadeGenerator;
import net.anotheria.asg.generator.model.ServiceGenerator;
import net.anotheria.asg.generator.model.docs.DocumentGenerator;

public class CMSBasedServiceGenerator
extends AbstractServiceGenerator
implements IGenerator {
    @Override
    public List<FileEntry> generate(IGenerateable gmodule) {
        MetaModule mod = (MetaModule)gmodule;
        ArrayList<FileEntry> ret = new ArrayList<FileEntry>();
        ret.add(new FileEntry(this.generateFactory(mod)));
        ret.add(new FileEntry(this.generateImplementation(mod)));
        return ret;
    }

    private List<FileEntry> generateCRUDServices(MetaModule module) {
        ArrayList<FileEntry> ret = new ArrayList<FileEntry>();
        for (MetaDocument doc : module.getDocuments()) {
            ret.add(new FileEntry(this.generateCRUDService(module, doc)));
        }
        return ret;
    }

    private String getCRUDServiceName(MetaDocument doc) {
        return doc.getName() + "CRUDServiceImpl";
    }

    private GeneratedClass generateCRUDService(MetaModule module, MetaDocument doc) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        clazz.setTypeComment(CommentGenerator.generateJavaTypeComment(this.getCRUDServiceName(doc), "The implementation of the " + this.getCRUDServiceName(doc) + "."));
        clazz.setPackageName(this.getPackageName(module));
        clazz.addImport("net.anotheria.asg.service.CRUDService");
        clazz.addImport(DataFacadeGenerator.getDocumentImport(doc));
        clazz.addImport("net.anotheria.asg.exception.ASGRuntimeException");
        clazz.setName(this.getCRUDServiceName(doc));
        clazz.addInterface("CRUDService<" + doc.getName() + ">");
        this.startClassBody();
        this.appendGenerationPoint("generateCRUDService");
        this.appendStatement(CMSBasedServiceGenerator.getInterfaceName(module) + " service");
        CMSBasedServiceGenerator.emptyline();
        this.appendString("public ", this.getCRUDServiceName(doc), "(){");
        this.increaseIdent();
        this.appendStatement("this(" + this.getFactoryName(module) + ".getDefaultInstance())");
        this.closeBlockNEW();
        CMSBasedServiceGenerator.emptyline();
        this.appendString("public ", this.getCRUDServiceName(doc), "(" + CMSBasedServiceGenerator.getInterfaceName(module) + " aService){");
        this.increaseIdent();
        this.appendStatement("service = aService");
        this.closeBlockNEW();
        CMSBasedServiceGenerator.emptyline();
        this.appendString("public " + doc.getName() + " create(" + doc.getName() + " " + doc.getVariableName() + ")  throws ASGRuntimeException {");
        this.increaseIdent();
        this.appendStatement("return service.create" + doc.getName() + "(", doc.getVariableName(), ")");
        this.closeBlockNEW();
        CMSBasedServiceGenerator.emptyline();
        this.appendString("public void delete(", doc.getName(), " ", doc.getVariableName(), ") throws ASGRuntimeException {");
        this.increaseIdent();
        this.appendStatement("service.delete", doc.getName(), "(", doc.getVariableName(), ")");
        this.closeBlockNEW();
        CMSBasedServiceGenerator.emptyline();
        this.appendString("public " + doc.getName() + " get(String id) throws ASGRuntimeException {");
        this.increaseIdent();
        this.appendStatement("return service.get", doc.getName(), "(id)");
        this.closeBlockNEW();
        CMSBasedServiceGenerator.emptyline();
        this.appendString("public ", doc.getName(), " update(", doc.getName(), " ", doc.getVariableName(), ") throws ASGRuntimeException {");
        this.increaseIdent();
        this.appendStatement("return service.update", doc.getName(), "(", doc.getVariableName(), ")");
        this.closeBlockNEW();
        CMSBasedServiceGenerator.emptyline();
        return clazz;
    }

    private GeneratedClass generateImplementation(MetaModule module) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        clazz.setTypeComment(CommentGenerator.generateJavaTypeComment(this.getImplementationName(module), "The implementation of the " + CMSBasedServiceGenerator.getInterfaceName(module) + "."));
        clazz.setPackageName(this.getPackageName(module));
        clazz.addImport("java.nio.charset.Charset");
        clazz.addImport("java.util.List");
        clazz.addImport("java.util.ArrayList");
        clazz.addImport("java.util.Set");
        clazz.addImport("net.anotheria.anodoc.data.Module");
        clazz.addImport("net.anotheria.anodoc.data.Property");
        clazz.addImport("net.anotheria.anodoc.data.NoSuchPropertyException");
        clazz.addImport("net.anotheria.util.sorter.SortType");
        clazz.addImport("net.anotheria.util.sorter.StaticQuickSorter");
        clazz.addImport("net.anotheria.util.slicer.Segment");
        clazz.addImport("net.anotheria.util.slicer.Slicer");
        Context context = GeneratorDataRegistry.getInstance().getContext();
        clazz.addImport(context.getPackageName(module) + ".data." + module.getModuleClassName());
        clazz.addImport(context.getServicePackageName(MetaModule.SHARED) + ".BasicCMSService");
        clazz.addImport("net.anotheria.anodoc.query2.DocumentQuery");
        clazz.addImport("net.anotheria.anodoc.query2.QueryResult");
        clazz.addImport("net.anotheria.anodoc.query2.QueryResultEntry");
        clazz.addImport("net.anotheria.anodoc.query2.QueryProperty");
        clazz.addImport("net.anotheria.util.StringUtils");
        clazz.addImport("net.anotheria.util.xml.XMLNode");
        clazz.addImport("net.anotheria.util.xml.XMLAttribute");
        clazz.addImport("net.anotheria.asg.util.listener.IModuleListener");
        clazz.addImport("org.codehaus.jettison.json.JSONObject");
        clazz.addImport("org.codehaus.jettison.json.JSONArray");
        clazz.addImport("org.codehaus.jettison.json.JSONException");
        clazz.addImport("com.fasterxml.jackson.core.JsonProcessingException");
        clazz.addImport("java.io.IOException");
        clazz.addImport(ObjectMapperUtil.class);
        clazz.addImport("net.anotheria.anosite.gen.shared.util.DocumentName");
        clazz.setName(this.getImplementationName(module));
        clazz.setParent("BasicCMSService");
        clazz.addInterface(CMSBasedServiceGenerator.getInterfaceName(module));
        clazz.addInterface("IModuleListener");
        this.startClassBody();
        this.appendGenerationPoint("generateImplementation");
        this.appendStatement("private static " + this.getImplementationName(module) + " instance");
        CMSBasedServiceGenerator.emptyline();
        this.appendString("private " + this.getImplementationName(module) + "(){");
        this.increaseIdent();
        if (module.getListeners().size() > 0) {
            for (int i = 0; i < module.getListeners().size(); ++i) {
                String listClassName = module.getListeners().get(i);
                this.appendStatement("addServiceListener(new " + listClassName + "())");
            }
        }
        this.appendStatement("addModuleListener(" + module.getModuleClassName() + ".MODULE_ID, this)");
        this.closeBlockNEW();
        CMSBasedServiceGenerator.emptyline();
        this.appendString("static final " + this.getImplementationName(module) + " getInstance(){");
        this.increaseIdent();
        this.appendString("if (instance==null){");
        this.increaseIdent();
        this.appendStatement("instance = new " + this.getImplementationName(module) + "()");
        this.closeBlockNEW();
        this.appendStatement("return instance");
        this.closeBlockNEW();
        CMSBasedServiceGenerator.emptyline();
        this.appendString("private " + module.getModuleClassName() + " " + this.getModuleGetterCall(module) + "{");
        this.increaseIdent();
        this.appendStatement("return (" + module.getModuleClassName() + ") getModule(" + module.getModuleClassName() + ".MODULE_ID)");
        this.closeBlockNEW();
        CMSBasedServiceGenerator.emptyline();
        this.appendString("@Override");
        this.appendString("public void moduleLoaded(Module module){");
        this.increaseIdent();
        this.appendStatement("firePersistenceChangedEvent()");
        this.closeBlockNEW();
        CMSBasedServiceGenerator.emptyline();
        boolean containsAnyMultilingualDocs = false;
        List<MetaDocument> docs = module.getDocuments();
        for (int i = 0; i < docs.size(); ++i) {
            boolean attachedDocumentExists;
            MetaDocument doc = docs.get(i);
            clazz.addImport(DataFacadeGenerator.getDocumentImport(doc));
            clazz.addImport(DataFacadeGenerator.getXMLHelperImport(context, doc));
            clazz.addImport(DocumentGenerator.getDocumentImport(context, doc));
            String listDecl = "List<" + doc.getName() + ">";
            this.appendString("@Override");
            this.appendString("public " + listDecl + " get" + doc.getMultiple() + "(){");
            this.increaseIdent();
            this.appendStatement(listDecl + " " + doc.getMultiple().toLowerCase() + " = new ArrayList<>()");
            this.appendStatement(doc.getMultiple().toLowerCase() + ".addAll(" + this.getModuleGetterCall(module) + ".get" + doc.getMultiple() + "())");
            this.appendStatement("return " + doc.getMultiple().toLowerCase());
            this.closeBlockNEW();
            CMSBasedServiceGenerator.emptyline();
            this.appendString("@Override");
            this.appendString("public " + listDecl + " get" + doc.getMultiple() + "(SortType sortType){");
            this.increaseIdent();
            this.appendStatement("return StaticQuickSorter.sort(get" + doc.getMultiple() + "(), sortType)");
            this.closeBlockNEW();
            CMSBasedServiceGenerator.emptyline();
            this.appendComment("Returns the " + doc.getName() + " objects with the specified ids.");
            this.appendString("public " + listDecl + " get" + doc.getMultiple() + "(List<String> ids){");
            this.increaseIdent();
            this.appendString("if (ids==null || ids.size()==0)");
            this.appendIncreasedStatement("return new ArrayList<>(0)");
            this.appendStatement(listDecl, " all = get", doc.getMultiple(), "()");
            this.appendStatement(listDecl, " ret = new ArrayList<>", "()");
            this.appendString("for (" + doc.getName() + " " + doc.getVariableName() + " : all){");
            this.increaseIdent();
            this.appendString("if(ids.contains(" + doc.getVariableName() + ".getId())){");
            this.increaseIdent();
            this.appendStatement("ret.add(" + doc.getVariableName() + ")");
            this.closeBlockNEW();
            this.closeBlockNEW();
            this.appendStatement("return ret");
            this.closeBlockNEW();
            CMSBasedServiceGenerator.emptyline();
            this.appendComment("Returns the " + doc.getName() + " objects with the specified ids, sorted by given sorttype.");
            this.appendString("public " + listDecl + " get" + doc.getMultiple() + "(List<String> ids, SortType sortType){");
            this.increaseIdent();
            this.appendStatement("return StaticQuickSorter.sort(get" + doc.getMultiple() + "(ids), sortType)");
            this.closeBlockNEW();
            CMSBasedServiceGenerator.emptyline();
            this.appendString("@Override");
            this.appendString("public void delete" + doc.getName() + "(" + doc.getName() + " " + doc.getVariableName() + "){");
            this.increaseIdent();
            this.appendStatement("delete" + doc.getName() + "(" + doc.getVariableName() + ".getId())");
            this.appendString("if (hasServiceListeners()){");
            this.increaseIdent();
            this.appendStatement("fireObjectDeletedEvent(" + doc.getVariableName() + ")");
            this.closeBlockNEW();
            this.closeBlockNEW();
            CMSBasedServiceGenerator.emptyline();
            this.appendString("@Override");
            this.appendString("public void delete" + doc.getName() + "(String id){");
            this.increaseIdent();
            this.appendStatement(module.getModuleClassName() + " module = " + this.getModuleGetterCall(module));
            this.appendStatement(doc.getName() + " varValue = hasServiceListeners()?module.get" + doc.getName() + "(id):null");
            this.appendStatement("module.delete" + doc.getName() + "(id)");
            this.appendStatement("updateModule(module)");
            this.appendString("if(varValue!=null){");
            this.increaseIdent();
            this.appendStatement("fireObjectDeletedEvent(varValue)");
            this.closeBlockNEW();
            this.closeBlockNEW();
            CMSBasedServiceGenerator.emptyline();
            this.appendString("@Override");
            this.appendString("public void delete" + doc.getMultiple() + "(" + listDecl + " list){");
            this.increaseIdent();
            this.appendStatement(module.getModuleClassName() + " module = " + this.getModuleGetterCall(module));
            this.appendString("for (" + doc.getName() + " " + doc.getVariableName() + " : list){");
            this.increaseIdent();
            this.appendStatement("module.delete" + doc.getName() + "(" + doc.getVariableName() + ".getId())");
            this.closeBlockNEW();
            this.appendStatement("updateModule(module)");
            this.appendString("if (hasServiceListeners()){");
            this.increaseIdent();
            this.appendString("for (int t=0; t<list.size(); t++)");
            this.appendIncreasedStatement("fireObjectDeletedEvent(list.get(t))");
            this.closeBlockNEW();
            this.closeBlockNEW();
            CMSBasedServiceGenerator.emptyline();
            this.appendString("@Override");
            this.appendString("public " + doc.getName() + " get" + doc.getName() + "(String id){");
            this.increaseIdent();
            this.appendStatement("return " + this.getModuleGetterCall(module) + ".get" + doc.getName() + "(id)");
            this.closeBlockNEW();
            CMSBasedServiceGenerator.emptyline();
            this.appendString("@Override");
            this.appendString("public " + doc.getName() + " import" + doc.getName() + "(" + doc.getName() + " " + doc.getVariableName() + "){");
            this.increaseIdent();
            this.appendStatement(module.getModuleClassName() + " module = " + this.getModuleGetterCall(module));
            this.appendStatement("module.import" + doc.getName() + "((" + DocumentGenerator.getDocumentName(doc) + ")" + doc.getVariableName() + ")");
            this.appendStatement("updateModule(module)");
            this.appendString("if (hasServiceListeners()){");
            this.increaseIdent();
            this.appendStatement("fireObjectImportedEvent(" + doc.getVariableName() + ")");
            this.closeBlockNEW();
            this.appendStatement("return " + doc.getVariableName());
            this.closeBlockNEW();
            CMSBasedServiceGenerator.emptyline();
            this.appendString("@Override");
            this.appendString("public " + listDecl + " import" + doc.getMultiple() + "(" + listDecl + " list){");
            this.increaseIdent();
            this.appendStatement(module.getModuleClassName() + " module = " + this.getModuleGetterCall(module));
            this.appendStatement(listDecl + " ret = new ArrayList<>()");
            this.appendString("for (" + doc.getName() + " " + doc.getVariableName() + " : list){");
            this.increaseIdent();
            this.appendStatement(doc.getName() + " imported = module.import" + doc.getName() + "((" + DocumentGenerator.getDocumentName(doc) + ")" + doc.getVariableName() + ")");
            this.appendStatement("ret.add(imported)");
            this.closeBlockNEW();
            this.appendStatement("updateModule(module)");
            this.appendString("if (hasServiceListeners()){");
            this.increaseIdent();
            this.appendString("for (" + doc.getName() + " " + doc.getVariableName() + " : ret)");
            this.increaseIdent();
            this.appendStatement("fireObjectImportedEvent(" + doc.getVariableName() + ")");
            this.decreaseIdent();
            this.closeBlockNEW();
            this.appendStatement("return ret");
            this.closeBlockNEW();
            CMSBasedServiceGenerator.emptyline();
            this.appendString("@Override");
            this.appendString("public " + doc.getName() + " create" + doc.getName() + "(" + doc.getName() + " " + doc.getVariableName() + "){");
            this.increaseIdent();
            this.appendStatement(module.getModuleClassName() + " module = " + this.getModuleGetterCall(module));
            this.appendStatement("module.create" + doc.getName() + "((" + DocumentGenerator.getDocumentName(doc) + ")" + doc.getVariableName() + ")");
            this.appendStatement("updateModule(module)");
            this.appendStatement("fireObjectCreatedEvent(" + doc.getVariableName() + ")");
            this.appendStatement("return " + doc.getVariableName());
            this.closeBlockNEW();
            CMSBasedServiceGenerator.emptyline();
            this.appendString("@Override");
            this.appendComment("Creates multiple new " + doc.getName() + " objects.\nReturns the created versions.");
            this.appendString("public " + listDecl + " create" + doc.getMultiple() + "(" + listDecl + " list){");
            this.increaseIdent();
            this.appendStatement(module.getModuleClassName() + " module = " + this.getModuleGetterCall(module));
            this.appendStatement(listDecl + " ret = new ArrayList<>()");
            this.appendString("for (" + doc.getName() + " " + doc.getVariableName() + " : list){");
            this.increaseIdent();
            this.appendStatement(doc.getName() + " created = module.create" + doc.getName() + "((" + DocumentGenerator.getDocumentName(doc) + ")" + doc.getVariableName() + ")");
            this.appendStatement("ret.add(created)");
            this.closeBlockNEW();
            this.appendStatement("updateModule(module)");
            this.appendString("if (hasServiceListeners()){");
            this.increaseIdent();
            this.appendString("for (" + doc.getName() + " " + doc.getVariableName() + " : ret)");
            this.appendIncreasedStatement("fireObjectCreatedEvent(" + doc.getVariableName() + ")");
            this.closeBlockNEW();
            this.appendStatement("return ret");
            this.closeBlockNEW();
            CMSBasedServiceGenerator.emptyline();
            this.appendString("@Override");
            this.appendString("public ", doc.getName(), " update", doc.getName(), "(", doc.getName(), " ", doc.getVariableName(), "){");
            this.increaseIdent();
            this.appendStatement(doc.getName() + " oldVersion = null");
            this.appendStatement(module.getModuleClassName() + " module = " + this.getModuleGetterCall(module));
            this.appendString("if (hasServiceListeners())");
            this.appendIncreasedStatement("oldVersion = module.get" + doc.getName() + "(" + doc.getVariableName() + ".getId())");
            this.appendStatement("module.update" + doc.getName() + "((" + DocumentGenerator.getDocumentName(doc) + ")" + doc.getVariableName() + ")");
            this.appendStatement("updateModule(module)");
            this.appendString("if (oldVersion != null){");
            this.increaseIdent();
            this.appendStatement("fireObjectUpdatedEvent(oldVersion, " + doc.getVariableName() + ")");
            this.closeBlockNEW();
            this.appendStatement("return " + doc.getVariableName());
            this.closeBlockNEW();
            CMSBasedServiceGenerator.emptyline();
            this.appendString("@Override");
            this.appendString("public " + listDecl + " update" + doc.getMultiple() + "(" + listDecl + " list){");
            this.increaseIdent();
            this.appendStatement(listDecl + " oldList = null");
            this.appendString("if (hasServiceListeners())");
            this.appendIncreasedStatement("oldList = new ArrayList<>(list.size())");
            this.appendStatement(module.getModuleClassName() + " module = " + this.getModuleGetterCall(module));
            this.appendString("for (" + doc.getName() + " " + doc.getVariableName() + " : list){");
            this.increaseIdent();
            this.appendString("if (oldList!=null)");
            this.appendIncreasedStatement("oldList.add(module.get" + doc.getName() + "(" + doc.getVariableName() + ".getId()))");
            this.appendStatement("module.update" + doc.getName() + "((" + DocumentGenerator.getDocumentName(doc) + ")" + doc.getVariableName() + ")");
            this.closeBlockNEW();
            this.appendStatement("updateModule(module)");
            this.appendString("if (oldList!=null){");
            this.increaseIdent();
            this.appendString("for (int t=0; t<list.size(); t++)");
            this.appendIncreasedStatement("fireObjectUpdatedEvent(oldList.get(t), list.get(t))");
            this.closeBlockNEW();
            this.appendStatement("return list");
            this.closeBlockNEW();
            CMSBasedServiceGenerator.emptyline();
            this.appendString("@Override");
            this.appendString("public " + listDecl + " get" + doc.getMultiple() + "ByProperty(String propertyName, Object value){");
            this.increaseIdent();
            this.appendStatement(listDecl + " all" + doc.getMultiple() + " = get" + doc.getMultiple() + "()");
            this.appendStatement(listDecl + " ret = new ArrayList<>()");
            this.appendString("for (int i=0; i<all" + doc.getMultiple() + ".size(); i++){");
            this.increaseIdent();
            this.appendStatement(doc.getName() + " " + doc.getVariableName() + " = all" + doc.getMultiple() + ".get(i)");
            this.appendString("try{");
            this.increaseIdent();
            this.appendStatement("Property property = ((" + DocumentGenerator.getDocumentName(doc) + ")" + doc.getVariableName() + ").getProperty(propertyName)");
            this.appendString("if (property.getValue()==null && value==null){");
            this.appendIncreasedStatement("ret.add(" + doc.getVariableName() + ")");
            this.appendString("}else{");
            this.increaseIdent();
            this.appendString("if (value!=null && property.getValue().equals(value))");
            this.appendIncreasedStatement("ret.add(" + doc.getVariableName() + ")");
            this.closeBlockNEW();
            this.decreaseIdent();
            this.appendString("}catch(NoSuchPropertyException nspe){");
            this.increaseIdent();
            this.appendString("if (value==null)");
            this.appendIncreasedStatement("ret.add(" + doc.getVariableName() + ")");
            this.decreaseIdent();
            this.appendString("}catch(Exception ignored){}");
            this.closeBlockNEW();
            this.appendString("return ret;");
            this.closeBlockNEW();
            CMSBasedServiceGenerator.emptyline();
            this.appendString("public " + listDecl + " get" + doc.getMultiple() + "ByProperty(String propertyName, Object value, SortType sortType){");
            this.increaseIdent();
            this.appendStatement("return StaticQuickSorter.sort(get" + doc.getMultiple() + "ByProperty(propertyName, value), sortType)");
            this.closeBlockNEW();
            this.appendComment("Executes a query on " + doc.getMultiple());
            this.appendString("public QueryResult executeQueryOn" + doc.getMultiple() + "(DocumentQuery query){");
            this.increaseIdent();
            this.appendStatement(listDecl + " all" + doc.getMultiple() + " = get" + doc.getMultiple() + "()");
            this.appendStatement("QueryResult result = new QueryResult()");
            this.appendString("for (int i=0; i<all" + doc.getMultiple() + ".size(); i++){");
            this.increaseIdent();
            this.appendStatement("List<QueryResultEntry> partialResult = query.match(all" + doc.getMultiple() + ".get(i))");
            this.appendStatement("result.add(partialResult)");
            this.closeBlockNEW();
            this.appendStatement("return result");
            this.closeBlockNEW();
            CMSBasedServiceGenerator.emptyline();
            this.appendComment("Returns all " + doc.getName() + " objects, where property matches.");
            this.appendString("public " + listDecl + " get" + doc.getMultiple() + "ByProperty(QueryProperty... property){");
            this.increaseIdent();
            this.appendString("//first the slow version, the fast version is a todo.");
            this.appendStatement(listDecl + " ret = new ArrayList<>()");
            this.appendStatement(listDecl + " src = get" + doc.getMultiple() + "()");
            this.appendString("for ( " + doc.getName() + " " + doc.getVariableName() + " : src){");
            this.increaseIdent();
            this.appendStatement("boolean mayPass = true");
            this.appendString("for (QueryProperty qp : property){");
            this.increaseIdent();
            this.appendStatement("mayPass = mayPass && qp.doesMatch(" + doc.getVariableName() + ".getPropertyValue(qp.getName()))");
            this.closeBlockNEW();
            this.appendString("if (mayPass)");
            this.appendIncreasedStatement("ret.add(" + doc.getVariableName() + ")");
            this.closeBlockNEW();
            this.appendStatement("return ret");
            this.closeBlockNEW();
            CMSBasedServiceGenerator.emptyline();
            this.appendComment("Returns all " + doc.getName() + " objects, where property matches, sorted");
            this.appendString("public " + listDecl + " get" + doc.getMultiple() + "ByProperty(SortType sortType, QueryProperty... property){");
            this.increaseIdent();
            this.appendStatement("return StaticQuickSorter.sort(get" + doc.getMultiple() + "ByProperty(property), sortType)");
            this.closeBlockNEW();
            CMSBasedServiceGenerator.emptyline();
            this.appendComment("Returns " + doc.getName() + " objects count.");
            this.appendString("public int get" + doc.getMultiple() + "Count() {");
            this.increaseIdent();
            this.appendStatement("return " + this.getModuleGetterCall(module) + ".get" + doc.getMultiple() + "().size()");
            this.closeBlockNEW();
            CMSBasedServiceGenerator.emptyline();
            this.appendComment("Returns " + doc.getName() + " objects segment.");
            this.appendString("public " + listDecl + " get" + doc.getMultiple() + "(Segment aSegment) {");
            this.increaseIdent();
            this.appendStatement("return Slicer.slice(aSegment, get" + doc.getMultiple() + "()).getSliceData()");
            this.closeBlockNEW();
            CMSBasedServiceGenerator.emptyline();
            this.appendComment("Returns " + doc.getName() + " objects segment, where property matched.");
            this.appendString("public " + listDecl + " get" + doc.getMultiple() + "ByProperty(Segment aSegment, QueryProperty... property) {");
            this.increaseIdent();
            this.appendStatement("int pLimit = aSegment.getElementsPerSlice()");
            this.appendStatement("int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice()");
            this.appendStatement(listDecl + " ret = new ArrayList<>()");
            this.appendStatement(listDecl + " src = get" + doc.getMultiple() + "()");
            this.appendString("for (" + doc.getName() + " " + doc.getVariableName() + " : src) {");
            this.increaseIdent();
            this.appendStatement("boolean mayPass = true");
            this.appendString("for (QueryProperty qp : property) {");
            this.increaseIdent();
            this.appendStatement("mayPass = mayPass && qp.doesMatch(" + doc.getVariableName() + ".getPropertyValue(qp.getName()))");
            this.closeBlockNEW();
            this.appendString("if (mayPass)");
            this.appendIncreasedStatement("ret.add(" + doc.getVariableName() + ")");
            this.appendString("if (ret.size() > pOffset + pLimit)");
            this.appendIncreasedStatement("break");
            this.closeBlockNEW();
            this.appendStatement("return Slicer.slice(aSegment, ret).getSliceData()");
            this.closeBlockNEW();
            CMSBasedServiceGenerator.emptyline();
            this.appendComment("Returns " + doc.getName() + " objects segment, where property matched, sorted.");
            this.appendString("public " + listDecl + " get" + doc.getMultiple() + "ByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){");
            this.increaseIdent();
            this.appendStatement("return StaticQuickSorter.sort(get" + doc.getMultiple() + "ByProperty(aSegment, aProperty), aSortType)");
            this.closeBlockNEW();
            CMSBasedServiceGenerator.emptyline();
            String throwsClause = " throws " + ServiceGenerator.getExceptionName(module) + " ";
            this.appendString("@Override");
            this.appendString("public void fetch" + doc.getName() + "(final String id, Set<String> addedDocuments, JSONArray data)" + throwsClause + "{");
            this.increaseIdent();
            this.appendString("if (id.isEmpty() || addedDocuments.contains(\"" + doc.getName() + "\" + id))");
            this.increaseIdent();
            this.appendStatement("return");
            this.decreaseIdent();
            CMSBasedServiceGenerator.emptyline();
            this.openTry();
            this.appendStatement("final " + doc.getName() + "Document " + doc.getVariableName() + " = " + this.getModuleGetterCall(module) + ".get" + doc.getName() + "(id)");
            this.appendStatement("addedDocuments.add(\"" + doc.getName() + "\" + id)");
            CMSBasedServiceGenerator.emptyline();
            HashSet<MetaModule> metaModules = new HashSet<MetaModule>();
            for (MetaProperty property : doc.getLinks()) {
                MetaModule targetModule;
                if (!property.isLinked()) continue;
                MetaLink link = (MetaLink)property;
                MetaModule metaModule = targetModule = link.getLinkTarget().indexOf(46) == -1 ? doc.getParentModule() : GeneratorDataRegistry.getInstance().getModule(link.getTargetModuleName());
                if (targetModule == null) {
                    throw new RuntimeException("Can`t resolve link: " + property + " in document " + doc.getName());
                }
                metaModules.add(targetModule);
                this.appendString("if (!StringUtils.isEmpty(" + doc.getVariableName() + ".get" + link.getAccesserName() + "()))");
                this.increaseIdent();
                this.appendStatement("get" + targetModule.getName() + "Service().fetch" + link.getTargetDocumentName() + "(" + doc.getVariableName() + ".get" + link.getAccesserName() + "(), addedDocuments, data)");
                this.decreaseIdent();
            }
            CMSBasedServiceGenerator.emptyline();
            for (MetaProperty property : doc.getProperties()) {
                MetaModule targetModule;
                MetaListProperty listProperty;
                if (!(property instanceof MetaListProperty) || !(listProperty = (MetaListProperty)property).getContainedProperty().isLinked()) continue;
                MetaLink link = (MetaLink)listProperty.getContainedProperty();
                MetaModule metaModule = targetModule = link.getLinkTarget().indexOf(46) == -1 ? doc.getParentModule() : GeneratorDataRegistry.getInstance().getModule(link.getTargetModuleName());
                if (targetModule == null) {
                    throw new RuntimeException("Can`t resolve link: " + property + " in document " + doc.getName());
                }
                metaModules.add(targetModule);
                MetaDocument targetDocument = targetModule.getDocumentByName(link.getTargetDocumentName());
                this.appendString("if (!" + doc.getVariableName() + ".get" + listProperty.getAccesserName() + "().isEmpty()) {");
                this.increaseIdent();
                this.appendString("for (String a" + listProperty.getAccesserName() + "Id: " + doc.getVariableName() + ".get" + listProperty.getAccesserName() + "()) {");
                this.increaseIdent();
                this.appendStatement("get" + targetModule.getName() + "Service().fetch" + targetDocument.getName() + "(a" + listProperty.getAccesserName() + "Id, addedDocuments, data)");
                this.closeBlockNEW();
                this.closeBlockNEW();
            }
            CMSBasedServiceGenerator.emptyline();
            this.appendStatement("JSONObject dataObject = new JSONObject()");
            this.appendStatement("String jsonObject = ObjectMapperUtil.getMapperInstance().writeValueAsString(" + doc.getVariableName() + ")");
            this.appendStatement("dataObject.put(\"object\", jsonObject)");
            this.appendStatement("dataObject.put(\"service\", \"" + module.getName() + "\")");
            this.appendStatement("dataObject.put(\"document\", \"" + module.getName() + "_" + doc.getName() + "\")");
            CMSBasedServiceGenerator.emptyline();
            this.appendStatement("data.put(dataObject)");
            CMSBasedServiceGenerator.emptyline();
            for (MetaProperty p : doc.getProperties()) {
                if (p.getType() != MetaProperty.Type.IMAGE && (p.getType() != MetaProperty.Type.LIST || ((MetaListProperty)p).getContainedProperty().getType() != MetaProperty.Type.IMAGE)) continue;
                clazz.addImport("net.anotheria.webutils.filehandling.actions.FileStorage");
                clazz.addImport("java.io.File");
                clazz.addImport("java.io.FileNotFoundException");
                clazz.addImport("java.io.IOException");
                clazz.addImport("jakarta.ws.rs.client.Client");
                clazz.addImport("jakarta.ws.rs.client.Entity");
                clazz.addImport("jakarta.ws.rs.client.WebTarget");
                clazz.addImport("jakarta.ws.rs.core.MediaType");
                clazz.addImport("jakarta.ws.rs.core.Response");
                clazz.addImport("net.anotheria.anosite.util.staticutil.JerseyClientUtil");
                clazz.addImport("net.anotheria.anosite.config.DocumentTransferConfig");
                clazz.addImport("org.glassfish.jersey.media.multipart.FormDataMultiPart");
                clazz.addImport("org.glassfish.jersey.media.multipart.file.FileDataBodyPart");
                this.appendStatement("File imageFile = FileStorage.getFile(" + doc.getVariableName() + "." + p.toBeanGetter() + "())");
                this.appendStatement("Client client = JerseyClientUtil.getClientInstance()");
                this.appendString("for (String domain :DocumentTransferConfig.getInstance().getDomains()) {");
                this.increaseIdent();
                this.appendStatement("final FileDataBodyPart filePart = new FileDataBodyPart(\"file\", imageFile)");
                this.appendStatement("FormDataMultiPart formDataMultiPart = new FormDataMultiPart()");
                this.appendStatement("final FormDataMultiPart multipart = (FormDataMultiPart) formDataMultiPart.bodyPart(filePart)");
                this.appendStatement("final WebTarget target = client.target(domain + \"/api/asgimage/upload\")");
                this.appendStatement("final Response response = target.request().post(Entity.entity(multipart, multipart.getMediaType()))");
                this.appendStatement("String responseResult = response.readEntity(String.class)");
                this.appendStatement("log.info(responseResult)");
                this.appendStatement("formDataMultiPart.close()");
                this.appendStatement("multipart.close()");
                this.closeBlockNEW();
                this.appendCatch("FileNotFoundException");
                this.appendStatement("throw new " + ServiceGenerator.getExceptionName(doc.getParentModule()) + " (\"Problem with getting image file for " + doc.getName() + "\" + e.getMessage())");
            }
            boolean bl = attachedDocumentExists = metaModules.size() != 0;
            if (attachedDocumentExists) {
                for (MetaModule metaModule : metaModules) {
                    clazz.addImport(ServiceGenerator.getExceptionImport(metaModule));
                    this.appendCatch(ServiceGenerator.getExceptionName(metaModule));
                    this.appendStatement("throw new " + ServiceGenerator.getExceptionName(module) + "(\"Problem with getting document from " + metaModule.getName() + "\" + e.getMessage())");
                }
            }
            this.appendCatch("IOException");
            this.appendStatement("throw new " + ServiceGenerator.getExceptionName(doc.getParentModule()) + " (\"Problem with fetching data for this " + doc.getName() + " instance object:\" + e.getMessage())");
            this.appendCatch("JSONException");
            this.appendStatement("throw new " + ServiceGenerator.getExceptionName(doc.getParentModule()) + " (\"Problem with fetching data for this " + doc.getName() + " instance in json :\" + e.getMessage())");
            this.closeBlockNEW();
            this.closeBlockNEW();
            CMSBasedServiceGenerator.emptyline();
            this.appendString("private void saveTransferred" + doc.getName() + "(final JSONObject data)" + throwsClause + "{");
            this.increaseIdent();
            this.openTry();
            this.appendStatement("String objectData = data.getString(\"object\")");
            this.appendStatement(doc.getName() + " " + doc.getVariableName() + " = ObjectMapperUtil.getMapperInstance().readValue(objectData.getBytes(Charset.forName(\"UTF-8\")), " + doc.getName() + "Document.class)");
            CMSBasedServiceGenerator.emptyline();
            this.openTry();
            this.appendStatement("update" + doc.getName() + "(" + doc.getVariableName() + ")");
            this.appendCatch("Exception");
            this.appendStatement("import" + doc.getName() + "(" + doc.getVariableName() + ")");
            this.closeBlockNEW();
            this.appendCatch("JSONException");
            this.appendStatement("throw new " + ServiceGenerator.getExceptionName(doc.getParentModule()) + "(\"Problem with getting data from json " + doc.getName() + " instance :\" + e.getMessage())");
            this.appendCatch("IOException");
            this.appendStatement("throw new " + ServiceGenerator.getExceptionName(doc.getParentModule()) + "(\"Problem with parsing data for this " + doc.getName() + " instance :\" + e.getMessage())");
            this.closeBlockNEW();
            this.closeBlockNEW();
            CMSBasedServiceGenerator.emptyline();
            if (!GeneratorDataRegistry.hasLanguageCopyMethods(doc)) continue;
            containsAnyMultilingualDocs = true;
            this.appendCommentLine("This method is not very fast, since it makes an update (eff. save) after each doc.");
            this.appendString("public void copyMultilingualAttributesInAll" + doc.getMultiple() + "(String sourceLanguage, String targetLanguage){");
            this.increaseIdent();
            this.appendStatement("List<" + doc.getName() + "> allDocumentsSrc = get" + doc.getMultiple() + "()");
            this.appendStatement("List<" + doc.getName() + "> allDocuments = new ArrayList<>(allDocumentsSrc.size())");
            this.appendStatement("allDocuments.addAll(allDocumentsSrc)");
            this.appendString("for (" + doc.getName() + " document : allDocuments){");
            this.increaseIdent();
            this.appendStatement("document.copyLANG2LANG(sourceLanguage, targetLanguage)");
            this.closeBlockNEW();
            this.appendStatement("update" + doc.getMultiple() + "(allDocuments)");
            this.closeBlockNEW();
            CMSBasedServiceGenerator.emptyline();
        }
        this.appendString("public void executeParsingForDocument (final DocumentName documentName, final JSONObject data) throws " + ServiceGenerator.getExceptionName(module) + " {");
        this.increaseIdent();
        this.appendString("switch(documentName) {");
        this.increaseIdent();
        for (MetaDocument doc : docs) {
            this.appendString("case DOCUMENT_" + module.getName().toUpperCase() + "_" + doc.getName().toUpperCase() + ":");
            this.increaseIdent();
            this.appendStatement("saveTransferred" + doc.getName() + "(data)");
            this.appendStatement("break");
            this.decreaseIdent();
        }
        this.appendString("default:");
        this.increaseIdent();
        this.appendStatement("log.info(\"There is no correct document: \" + documentName + \"in this service\")");
        this.appendStatement("throw new " + ServiceGenerator.getExceptionName(module) + "(\"No such document\")");
        this.decreaseIdent();
        this.closeBlockNEW();
        this.closeBlockNEW();
        CMSBasedServiceGenerator.emptyline();
        if (containsAnyMultilingualDocs) {
            this.appendComment("Copies all multilingual fields from sourceLanguage to targetLanguage in all data objects (documents, vo) which are part of this module and managed by this service");
            this.appendString("public void copyMultilingualAttributesInAllObjects(String sourceLanguage, String targetLanguage){");
            this.increaseIdent();
            for (MetaDocument doc : docs) {
                if (!GeneratorDataRegistry.hasLanguageCopyMethods(doc)) continue;
                this.appendStatement("copyMultilingualAttributesInAll" + doc.getMultiple() + "(sourceLanguage, targetLanguage)");
            }
            this.closeBlockNEW();
            CMSBasedServiceGenerator.emptyline();
        }
        this.appendComment("Executes a query on all data objects (documents, vo) which are part of this module and managed by this service");
        this.appendString("public QueryResult executeQueryOnAllObjects(DocumentQuery query){");
        this.increaseIdent();
        this.appendStatement("QueryResult ret = new QueryResult()");
        for (MetaDocument doc : docs) {
            this.appendStatement("ret.add(executeQueryOn" + doc.getMultiple() + "(query).getEntries())");
        }
        this.appendStatement("return ret");
        this.closeBlock("executeQueryOnAllObjects");
        CMSBasedServiceGenerator.emptyline();
        CMSBasedServiceGenerator.emptyline();
        for (MetaDocument d : docs) {
            this.appendString("public XMLNode export" + d.getMultiple() + "ToXML(){");
            this.increaseIdent();
            this.appendStatement("XMLNode ret = new XMLNode(" + this.quote(d.getMultiple()) + ")");
            this.appendStatement("List<" + d.getName() + "> list = get" + d.getMultiple() + "()");
            this.appendStatement("ret.addAttribute(new XMLAttribute(" + this.quote("count") + ", list.size()))");
            this.appendString("for (" + d.getName() + " object : list)");
            this.appendIncreasedStatement("ret.addChildNode(" + DataFacadeGenerator.getXMLHelperName(d) + ".toXML(object))");
            this.appendStatement("return ret");
            this.closeBlockNEW();
            CMSBasedServiceGenerator.emptyline();
            this.appendString("public XMLNode export" + d.getMultiple() + "ToXML(List<" + d.getName() + "> list){");
            this.increaseIdent();
            this.appendStatement("XMLNode ret = new XMLNode(" + this.quote(d.getMultiple()) + ")");
            this.appendStatement("ret.addAttribute(new XMLAttribute(" + this.quote("count") + ", list.size()))");
            this.appendString("for (" + d.getName() + " object : list)");
            this.appendIncreasedStatement("ret.addChildNode(" + DataFacadeGenerator.getXMLHelperName(d) + ".toXML(object))");
            this.appendStatement("return ret");
            this.closeBlockNEW();
            CMSBasedServiceGenerator.emptyline();
            if (!containsAnyMultilingualDocs || !GeneratorDataRegistry.getInstance().getContext().areLanguagesSupported()) continue;
            this.appendString("public XMLNode export" + d.getMultiple() + "ToXML(String[] languages){");
            this.increaseIdent();
            this.appendStatement("XMLNode ret = new XMLNode(" + this.quote(d.getMultiple()) + ")");
            this.appendStatement("List<" + d.getName() + "> list = get" + d.getMultiple() + "()");
            this.appendStatement("ret.addAttribute(new XMLAttribute(" + this.quote("count") + ", list.size()))");
            this.appendString("for (" + d.getName() + " object : list)");
            this.appendIncreasedStatement("ret.addChildNode(" + DataFacadeGenerator.getXMLHelperName(d) + ".toXML(object, languages))");
            this.appendStatement("return ret");
            this.closeBlockNEW();
            CMSBasedServiceGenerator.emptyline();
            this.appendString("public XMLNode export" + d.getMultiple() + "ToXML(String[] languages, List<" + d.getName() + "> list){");
            this.increaseIdent();
            this.appendStatement("XMLNode ret = new XMLNode(" + this.quote(d.getMultiple()) + ")");
            this.appendStatement("ret.addAttribute(new XMLAttribute(" + this.quote("count") + ", list.size()))");
            this.appendString("for (" + d.getName() + " object : list)");
            this.appendIncreasedStatement("ret.addChildNode(" + DataFacadeGenerator.getXMLHelperName(d) + ".toXML(object, languages))");
            this.appendStatement("return ret");
            this.closeBlockNEW();
            CMSBasedServiceGenerator.emptyline();
        }
        this.appendString("public XMLNode exportToXML(){");
        this.increaseIdent();
        this.appendStatement("XMLNode ret = new XMLNode(" + this.quote(module.getName()) + ")");
        CMSBasedServiceGenerator.emptyline();
        for (MetaDocument d : docs) {
            this.appendStatement("ret.addChildNode(export" + d.getMultiple() + "ToXML())");
        }
        CMSBasedServiceGenerator.emptyline();
        this.appendStatement("return ret");
        this.closeBlockNEW();
        if (containsAnyMultilingualDocs && GeneratorDataRegistry.getInstance().getContext().areLanguagesSupported()) {
            this.appendString("public XMLNode exportToXML(String[] languages){");
            this.increaseIdent();
            this.appendStatement("XMLNode ret = new XMLNode(" + this.quote(module.getName()) + ")");
            CMSBasedServiceGenerator.emptyline();
            for (MetaDocument d : docs) {
                this.appendStatement("ret.addChildNode(export" + d.getMultiple() + "ToXML(languages))");
            }
            CMSBasedServiceGenerator.emptyline();
            this.appendStatement("return ret");
            this.closeBlockNEW();
        }
        return clazz;
    }

    private String getModuleGetterMethod(MetaModule module) {
        return "_get" + module.getModuleClassName();
    }

    private String getModuleGetterCall(MetaModule module) {
        return this.getModuleGetterMethod(module) + "()";
    }

    @Override
    protected String getMoskitoSubsystem() {
        return super.getMoskitoSubsystem() + "-cms";
    }
}

