/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.model.docs;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.asg.generator.Context;
import net.anotheria.asg.generator.FileEntry;
import net.anotheria.asg.generator.GeneratedClass;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.IGenerateable;
import net.anotheria.asg.generator.IGenerator;
import net.anotheria.asg.generator.meta.MetaContainerProperty;
import net.anotheria.asg.generator.meta.MetaDocument;
import net.anotheria.asg.generator.meta.MetaEnumerationProperty;
import net.anotheria.asg.generator.meta.MetaGenericListProperty;
import net.anotheria.asg.generator.meta.MetaGenericProperty;
import net.anotheria.asg.generator.meta.MetaListProperty;
import net.anotheria.asg.generator.meta.MetaProperty;
import net.anotheria.asg.generator.meta.MetaTableProperty;
import net.anotheria.asg.generator.model.AbstractDataObjectGenerator;
import net.anotheria.asg.generator.model.DataFacadeGenerator;
import net.anotheria.util.StringUtils;

public class DocumentGenerator
extends AbstractDataObjectGenerator
implements IGenerator {
    public static final String PROPERTY_DECLARATION = "public static final String ";
    public static final String GET_CURRENT_LANG = "ContextManager.getCallContext().getCurrentLanguage()";

    @Override
    public List<FileEntry> generate(IGenerateable gdoc) {
        MetaDocument doc = (MetaDocument)gdoc;
        ArrayList<FileEntry> _ret = new ArrayList<FileEntry>();
        _ret.add(new FileEntry(this.generateDocument(doc)));
        _ret.add(new FileEntry(this.generateDocumentFactory(doc)));
        return _ret;
    }

    public static String getDocumentName(MetaDocument doc) {
        return doc.getName() + "Document";
    }

    @Override
    public String getDataObjectImplName(MetaDocument doc) {
        return DocumentGenerator.getDocumentImplName(doc);
    }

    public static String getDocumentImplName(MetaDocument doc) {
        return doc.getName() + "Document";
    }

    public static String getClassImplName(MetaDocument doc) {
        return doc.getName() + "Document";
    }

    public static String getSortTypeName(MetaDocument doc) {
        return doc.getName() + "SortType";
    }

    private GeneratedClass generateDocument(MetaDocument doc) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        clazz.setPackageName(this.getPackageName(doc));
        clazz.addImport("net.anotheria.asg.data.AbstractASGDocument");
        for (MetaProperty p : doc.getProperties()) {
            if (!(p instanceof MetaContainerProperty)) continue;
            clazz.addImport("java.util.List");
            if (p instanceof MetaTableProperty) {
                clazz.addImport("java.util.ArrayList");
            }
            if (!(p instanceof MetaListProperty)) continue;
            clazz.addImport("net.anotheria.anodoc.data." + StringUtils.capitalize((String)((MetaListProperty)p).getContainedProperty().toJavaType()) + "Property");
        }
        if (doc.isMultilingual() && GeneratorDataRegistry.getInstance().getContext().areLanguagesSupported()) {
            clazz.addImport("net.anotheria.anodoc.util.context.ContextManager");
            clazz.addImport("net.anotheria.anodoc.data.NoSuchPropertyException");
            clazz.addImport("net.anotheria.anodoc.data.BooleanProperty");
        }
        clazz.addImport("net.anotheria.util.crypt.MD5Util");
        clazz.addInterface(doc.getName());
        if (doc.isComparable()) {
            clazz.addInterface("IComparable");
            clazz.addImport("net.anotheria.util.sorter.IComparable");
            clazz.addImport("net.anotheria.util.BasicComparable");
        }
        if (doc.isMultilingual()) {
            clazz.addImport("net.anotheria.asg.data.MultilingualObject");
            clazz.addInterface("MultilingualObject");
        }
        clazz.setName(DocumentGenerator.getDocumentName(doc));
        clazz.setParent("AbstractASGDocument");
        this.startClassBody();
        this.generateEmptyConstructor(doc);
        DocumentGenerator.emptyline();
        this.generateDefaultConstructor(doc);
        DocumentGenerator.emptyline();
        this.generateCloneConstructor(doc);
        DocumentGenerator.emptyline();
        this.generateBuilderConstructor(doc);
        DocumentGenerator.emptyline();
        this.generatePropertyAccessMethods(doc);
        DocumentGenerator.emptyline();
        this.generateToStringMethod(doc);
        DocumentGenerator.emptyline();
        this.generateAdditionalMethods(doc);
        if (doc.isComparable()) {
            DocumentGenerator.emptyline();
            this.generateCompareMethod(doc);
        }
        DocumentGenerator.emptyline();
        this.generateDefNameMethod(doc);
        DocumentGenerator.emptyline();
        this.generateDefParentNameMethod(doc);
        DocumentGenerator.emptyline();
        this.generateGetFootprintMethod(doc);
        if (DataFacadeGenerator.hasLanguageCopyMethods(doc)) {
            this.generateLanguageCopyMethods(doc);
            DocumentGenerator.emptyline();
        }
        this.generateMultilingualSwitchSupport(doc);
        DocumentGenerator.emptyline();
        this.generateEqualsMethod(doc);
        return clazz;
    }

    private void generateLanguageCopyMethods(MetaDocument doc) {
        Context context = GeneratorDataRegistry.getInstance().getContext();
        this.appendString("public void " + DataFacadeGenerator.getCopyMethodName() + "(String sourceLanguage, String destLanguage){");
        this.increaseIdent();
        for (String srclang : context.getLanguages()) {
            for (String targetlang : context.getLanguages()) {
                if (srclang.equals(targetlang)) continue;
                this.appendString("if (sourceLanguage.equals(" + this.quote(srclang) + ") && destLanguage.equals(" + this.quote(targetlang) + "))");
                this.appendIncreasedStatement(DataFacadeGenerator.getCopyMethodName(srclang, targetlang) + "()");
            }
        }
        this.closeBlockNEW();
        DocumentGenerator.emptyline();
        for (String srclang : context.getLanguages()) {
            for (String targetlang : context.getLanguages()) {
                if (srclang.equals(targetlang)) continue;
                this.appendComment("Copies all multilingual properties from language " + srclang + " to language " + targetlang);
                this.appendString("public void " + DataFacadeGenerator.getCopyMethodName(srclang, targetlang) + "(){");
                this.increaseIdent();
                for (MetaProperty p : doc.getProperties()) {
                    if (!p.isMultilingual()) continue;
                    String copyCall = p.toSetter(targetlang) + "(";
                    copyCall = copyCall + p.toGetter(srclang) + "()";
                    copyCall = copyCall + ")";
                    this.appendStatement(copyCall);
                }
                this.closeBlockNEW();
                DocumentGenerator.emptyline();
            }
        }
    }

    private void generateEmptyConstructor(MetaDocument doc) {
        this.appendString("public " + DocumentGenerator.getDocumentName(doc) + "() {");
        this.increaseIdent();
        this.appendStatement("super(\"\")");
        this.closeBlockNEW();
    }

    private String generateDefaultConstructor(MetaDocument doc) {
        String ret = "";
        this.appendString("public " + DocumentGenerator.getDocumentName(doc) + "(String id){");
        this.increaseIdent();
        this.appendStatement("super(id)");
        this.closeBlockNEW();
        return ret;
    }

    private String generateCloneConstructor(MetaDocument doc) {
        String ret = "";
        this.appendString("public " + DocumentGenerator.getDocumentName(doc) + "(" + DocumentGenerator.getDocumentName(doc) + " toClone){");
        this.increaseIdent();
        this.appendStatement("super(toClone)");
        this.closeBlockNEW();
        return ret;
    }

    private void generateBuilderConstructor(MetaDocument doc) {
        this.appendString(DocumentGenerator.getDocumentImplName(doc) + "(" + this.getDocumentBuilderName(doc) + " builder){");
        this.increaseIdent();
        this.appendStatement("super(" + this.quote("") + ")");
        for (MetaProperty p : doc.getProperties()) {
            this.appendStatement("set", p.getAccesserName(), "(builder.", p.getName(), ")");
        }
        for (MetaProperty p : doc.getLinks()) {
            this.appendStatement("set", p.getAccesserName(), "(builder.", p.getName(), ")");
        }
        this.closeBlockNEW();
    }

    private String generatePropertyAccessMethods(MetaDocument doc) {
        Object ret = "";
        ret = (String)ret + this._generatePropertyAccessMethods(doc.getProperties());
        ret = (String)ret + this._generatePropertyAccessMethods(doc.getLinks());
        return ret;
    }

    private String _generatePropertyAccessMethods(List<MetaProperty> properties) {
        Object ret = "";
        for (int i = 0; i < properties.size(); ++i) {
            MetaProperty p = properties.get(i);
            ret = (String)ret + this.generatePropertyGetterMethod(p);
            DocumentGenerator.emptyline();
            ret = (String)ret + this.generatePropertySetterMethod(p);
            DocumentGenerator.emptyline();
        }
        return ret;
    }

    private String generatePropertyGetterMethod(MetaProperty p) {
        String ret = "";
        if (p instanceof MetaTableProperty) {
            return this.generateTablePropertyGetterMethods((MetaTableProperty)p);
        }
        if (p instanceof MetaListProperty) {
            return this.generateListPropertyGetterMethods((MetaListProperty)p);
        }
        if (GeneratorDataRegistry.getInstance().getContext().areLanguagesSupported() && p.isMultilingual()) {
            return this.generatePropertyGetterMethodMultilingual(p);
        }
        this.appendString("public " + p.toJavaType() + " get" + p.getAccesserName() + "(){");
        this.increaseIdent();
        if (p instanceof MetaGenericProperty) {
            this.appendStatement("return " + ((MetaGenericProperty)p).toPropertyGetterCall());
        } else {
            this.appendStatement("return " + p.toPropertyGetter() + "(" + p.toNameConstant() + ")");
        }
        this.closeBlockNEW();
        return ret;
    }

    private String generatePropertyGetterMethodMultilingual(MetaProperty p) {
        String ret = "";
        for (String l : GeneratorDataRegistry.getInstance().getContext().getLanguages()) {
            this.appendString("public " + p.toJavaType() + " get" + p.getAccesserName(l) + "(){");
            this.increaseIdent();
            if (p instanceof MetaGenericProperty) {
                this.appendStatement("return " + ((MetaGenericProperty)p).toPropertyGetterCall(l));
            } else {
                this.appendStatement("return " + p.toPropertyGetter() + "(" + p.toNameConstant(l) + ")");
            }
            this.closeBlockNEW();
            DocumentGenerator.emptyline();
        }
        this.appendString("public " + p.toJavaType() + " get" + p.getAccesserName() + "(){");
        this.increaseIdent();
        String v = "(isMultilingualDisabledInstance() ? ContextManager.getCallContext().getDefaultLanguage() : ContextManager.getCallContext().getCurrentLanguage())";
        if (p instanceof MetaGenericProperty) {
            this.appendStatement("return " + ((MetaGenericProperty)p).toPropertyGetterCallForCurrentLanguage(v));
        } else {
            this.appendStatement("return " + p.toPropertyGetter() + "(" + this.quote(p.getName() + "_") + "+" + v + ")");
        }
        this.closeBlockNEW();
        DocumentGenerator.emptyline();
        return ret;
    }

    private String generateListPropertyGetterMethods(MetaListProperty p) {
        MetaGenericListProperty tmp = new MetaGenericListProperty(p.getName(), p.getContainedProperty());
        if (p.isMultilingual()) {
            tmp.setMultilingual(true);
        }
        return this.generatePropertyGetterMethod(tmp);
    }

    private String generateTablePropertyGetterMethods(MetaTableProperty p) {
        Object ret = "";
        List<MetaProperty> columns = p.getColumns();
        for (int t = 0; t < columns.size(); ++t) {
            ret = (String)ret + this.generatePropertyGetterMethod(columns.get(t));
        }
        return ret;
    }

    private String generatePropertySetterMethod(MetaProperty p) {
        String ret = "";
        if (p instanceof MetaTableProperty) {
            return this.generateTablePropertySetterMethods((MetaTableProperty)p);
        }
        if (p instanceof MetaListProperty) {
            return this.generateListPropertySetterMethods((MetaListProperty)p);
        }
        if (GeneratorDataRegistry.getInstance().getContext().areLanguagesSupported() && p.isMultilingual()) {
            return this.generatePropertySetterMethodMultilingual(p);
        }
        this.appendString("public void set" + p.getAccesserName() + "(" + p.toJavaType() + " value){");
        this.increaseIdent();
        if (p instanceof MetaGenericProperty) {
            this.appendStatement(((MetaGenericProperty)p).toPropertySetterCall());
        } else {
            this.appendStatement(p.toPropertySetter() + "(" + p.toNameConstant() + ", value)");
        }
        this.closeBlockNEW();
        return ret;
    }

    private String generatePropertySetterMethodMultilingual(MetaProperty p) {
        String ret = "";
        for (String l : GeneratorDataRegistry.getInstance().getContext().getLanguages()) {
            this.appendString("public void set" + p.getAccesserName(l) + "(" + p.toJavaType() + " value){");
            this.increaseIdent();
            if (p instanceof MetaGenericProperty) {
                this.appendStatement(((MetaGenericProperty)p).toPropertySetterCall(l));
            } else {
                this.appendStatement(p.toPropertySetter() + "(" + p.toNameConstant(l) + ", value)");
            }
            this.closeBlockNEW();
            DocumentGenerator.emptyline();
        }
        this.appendString("public void set" + p.getAccesserName() + "(" + p.toJavaType() + " value){");
        this.increaseIdent();
        String v = "(isMultilingualDisabledInstance() ? ContextManager.getCallContext().getDefaultLanguage() : ContextManager.getCallContext().getCurrentLanguage())";
        if (p instanceof MetaGenericProperty) {
            this.appendStatement(((MetaGenericProperty)p).toPropertySetterCallForCurrentLanguage(v));
        } else {
            this.appendStatement(p.toPropertySetter() + "((" + this.quote(p.getName() + "_") + "+" + v + "), value)");
        }
        this.closeBlockNEW();
        DocumentGenerator.emptyline();
        return ret;
    }

    private String generateListPropertySetterMethods(MetaListProperty p) {
        MetaGenericListProperty tmp = new MetaGenericListProperty(p.getName(), p.getContainedProperty());
        if (p.isMultilingual()) {
            tmp.setMultilingual(true);
        }
        return this.generatePropertySetterMethod(tmp);
    }

    private String generateTablePropertySetterMethods(MetaTableProperty p) {
        System.out.println("Generating table property " + p + ", contained: " + p.getColumns());
        Object ret = "";
        List<MetaProperty> columns = p.getColumns();
        for (int t = 0; t < columns.size(); ++t) {
            ret = (String)ret + this.generatePropertySetterMethod(columns.get(t));
        }
        return ret;
    }

    private String generateToStringMethod(MetaDocument doc) {
        String ret = "";
        this.appendString("public String toString(){");
        this.increaseIdent();
        this.appendStatement("String ret = " + this.quote(doc.getName() + " "));
        this.appendStatement("ret += \"[\"+getId()+\"] \"");
        List<MetaProperty> props = doc.getProperties();
        for (int i = 0; i < props.size(); ++i) {
            MetaProperty p = props.get(i);
            if (p instanceof MetaTableProperty) {
                List<MetaProperty> columns = ((MetaTableProperty)p).getColumns();
                for (int t = 0; t < columns.size(); ++t) {
                    MetaProperty pp = columns.get(t);
                    this.appendStatement("ret += " + this.quote(pp.getName() + ": ") + "+get" + pp.getAccesserName() + "()");
                    if (t >= columns.size() - 1) continue;
                    this.appendStatement("ret += \", \"");
                }
            } else {
                this.appendStatement("ret += " + this.quote(p.getName() + ": ") + "+get" + p.getAccesserName() + "()");
            }
            if (i >= props.size() - 1) continue;
            this.appendStatement("ret += \", \"");
        }
        this.appendStatement("return ret");
        this.closeBlockNEW();
        return ret;
    }

    public static final String getDocumentImport(Context context, MetaDocument doc) {
        return context.getDataPackageName(doc) + "." + DocumentGenerator.getDocumentImplName(doc);
    }

    private void generateAdditionalMethods(MetaDocument doc) {
        List<MetaProperty> properties = doc.getProperties();
        for (MetaProperty p : properties) {
            if (p instanceof MetaContainerProperty) {
                this.generateContainerMethods((MetaContainerProperty)p);
            }
            if (p instanceof MetaTableProperty) {
                this.generateTableMethods((MetaTableProperty)p);
            }
            if (!(p instanceof MetaListProperty)) continue;
            this.generateListMethods((MetaListProperty)p);
        }
    }

    private void generateContainerMethods(MetaContainerProperty container) {
        if (container.isMultilingual()) {
            this.generateContainerMethodsMultilingual(container);
            return;
        }
        this.appendString("public int " + DocumentGenerator.getContainerSizeGetterName(container) + "(){");
        this.increaseIdent();
        MetaContainerProperty pr = container instanceof MetaTableProperty ? ((MetaTableProperty)container).getColumns().get(0) : container;
        this.appendStatement("return getList(" + pr.toNameConstant() + ").size()");
        this.closeBlockNEW();
        DocumentGenerator.emptyline();
    }

    private void generateContainerMethodsMultilingual(MetaContainerProperty container) {
        for (String l : GeneratorDataRegistry.getInstance().getContext().getLanguages()) {
            this.appendString("public int " + DocumentGenerator.getContainerSizeGetterName(container, l) + "(){");
            this.increaseIdent();
            MetaContainerProperty pr = container instanceof MetaTableProperty ? ((MetaTableProperty)container).getColumns().get(0) : container;
            this.appendStatement("return getList(" + pr.toNameConstant(l) + ").size()");
            this.closeBlockNEW();
            DocumentGenerator.emptyline();
        }
        this.appendString("public int " + DocumentGenerator.getContainerSizeGetterName(container) + "(){");
        this.increaseIdent();
        this.appendStatement("return getList(" + this.quote(container.getName() + "_") + "+ContextManager.getCallContext().getCurrentLanguage()).size()");
        this.closeBlockNEW();
        DocumentGenerator.emptyline();
    }

    private void generateListMethods(MetaListProperty list) {
        if (list.isMultilingual()) {
            this.generateListMethodsMultilingual(list);
            return;
        }
        MetaProperty c = list.getContainedProperty();
        String accesserType = StringUtils.capitalize((String)c.toJavaType());
        String decl = "public void " + DocumentGenerator.getContainerEntryAdderName(list) + "(";
        decl = decl + c.toJavaType() + " " + c.getName();
        decl = decl + "){";
        this.appendString(decl);
        this.increaseIdent();
        if (c instanceof MetaEnumerationProperty) {
            this.openFun("if (!getListPropertyAnyCase(" + list.toNameConstant() + ").getList().contains(new " + accesserType + "Property(" + this.quote("") + " + " + c.getName() + ", " + c.getName() + ")))");
        }
        this.appendStatement("getListPropertyAnyCase(" + list.toNameConstant() + ").add(new " + accesserType + "Property(" + this.quote("") + " + " + c.getName() + ", " + c.getName() + "))");
        if (c instanceof MetaEnumerationProperty) {
            this.closeBlock("if");
        }
        this.closeBlock("method");
        DocumentGenerator.emptyline();
        this.appendString("public void " + DocumentGenerator.getContainerEntryDeleterName(list) + "(int index){");
        this.increaseIdent();
        this.appendStatement("getListProperty(" + list.toNameConstant() + ").remove(index)");
        this.closeBlock("method");
        DocumentGenerator.emptyline();
        this.appendString("public void " + DocumentGenerator.getContainerEntrySwapperName(list) + "(int index1, int index2){");
        this.increaseIdent();
        this.appendStatement(c.toJavaType() + " tmp1, tmp2");
        this.appendStatement("tmp1 = ((" + accesserType + "Property)getList(" + list.toNameConstant() + ").get(index1)).get" + accesserType + "()");
        this.appendStatement("tmp2 = ((" + accesserType + "Property)getList(" + list.toNameConstant() + ").get(index2)).get" + accesserType + "()");
        this.appendStatement("((" + accesserType + "Property)getList(" + list.toNameConstant() + ").get(index1)).set" + accesserType + "(tmp2)");
        this.appendStatement("((" + accesserType + "Property)getList(" + list.toNameConstant() + ").get(index2)).set" + accesserType + "(tmp1)");
        this.closeBlock("method");
        DocumentGenerator.emptyline();
        this.appendString("public " + c.toJavaType() + " " + DocumentGenerator.getListElementGetterName(list) + "(int index){");
        this.increaseIdent();
        this.appendStatement(accesserType + "Property p = (" + accesserType + "Property)getList(" + list.toNameConstant() + ").get(index)");
        this.appendStatement("return p.get" + accesserType + "()");
        this.closeBlock("method");
        DocumentGenerator.emptyline();
    }

    private void generateListMethodsMultilingual(MetaListProperty list) {
        MetaProperty c = list.getContainedProperty();
        String accesserType = StringUtils.capitalize((String)c.toJavaType());
        for (String l : GeneratorDataRegistry.getInstance().getContext().getLanguages()) {
            String decl = "public void " + DocumentGenerator.getContainerEntryAdderName(list, l) + "(";
            decl = decl + c.toJavaType() + " " + c.getName();
            decl = decl + "){";
            this.appendString(decl);
            this.increaseIdent();
            this.appendStatement("getListPropertyAnyCase(" + list.toNameConstant(l) + ").add(new " + accesserType + "Property(" + this.quote("") + " + " + c.getName() + ", " + c.getName() + "))");
            this.closeBlockNEW();
            DocumentGenerator.emptyline();
            this.appendString("public void " + DocumentGenerator.getContainerEntryDeleterName(list, l) + "(int index){");
            this.increaseIdent();
            this.appendStatement("getListProperty(" + list.toNameConstant(l) + ").remove(index)");
            this.closeBlockNEW();
            DocumentGenerator.emptyline();
            this.appendString("public void " + DocumentGenerator.getContainerEntrySwapperName(list, l) + "(int index1, int index2){");
            this.increaseIdent();
            this.appendStatement(c.toJavaType() + " tmp1, tmp2");
            this.appendStatement("tmp1 = ((" + accesserType + "Property)getList(" + list.toNameConstant(l) + ").get(index1)).get" + accesserType + "()");
            this.appendStatement("tmp2 = ((" + accesserType + "Property)getList(" + list.toNameConstant(l) + ").get(index2)).get" + accesserType + "()");
            this.appendStatement("((" + accesserType + "Property)getList(" + list.toNameConstant(l) + ").get(index1)).set" + accesserType + "(tmp2)");
            this.appendStatement("((" + accesserType + "Property)getList(" + list.toNameConstant(l) + ").get(index2)).set" + accesserType + "(tmp1)");
            this.closeBlockNEW();
            DocumentGenerator.emptyline();
            this.appendString("public " + c.toJavaType() + " " + DocumentGenerator.getListElementGetterName(list, l) + "(int index){");
            this.increaseIdent();
            this.appendStatement(accesserType + "Property p = (" + accesserType + "Property)getList(" + list.toNameConstant(l) + ").get(index)");
            this.appendStatement("return p.get" + accesserType + "()");
            this.closeBlockNEW();
            DocumentGenerator.emptyline();
        }
        String decl = "public void " + DocumentGenerator.getContainerEntryAdderName(list) + "(";
        decl = decl + c.toJavaType() + " " + c.getName();
        decl = decl + "){";
        this.appendString(decl);
        this.increaseIdent();
        this.appendStatement("getListPropertyAnyCase(" + this.quote(list.getName() + "_") + "+ContextManager.getCallContext().getCurrentLanguage()).add(new " + accesserType + "Property(" + this.quote("") + " + " + c.getName() + ", " + c.getName() + "))");
        this.closeBlockNEW();
        DocumentGenerator.emptyline();
        this.appendString("public void " + DocumentGenerator.getContainerEntryDeleterName(list) + "(int index){");
        this.increaseIdent();
        this.appendStatement("getListProperty(" + this.quote(list.getName() + "_") + "+ContextManager.getCallContext().getCurrentLanguage()).remove(index)");
        this.closeBlockNEW();
        DocumentGenerator.emptyline();
        this.appendString("public void " + DocumentGenerator.getContainerEntrySwapperName(list) + "(int index1, int index2){");
        this.increaseIdent();
        this.appendStatement(c.toJavaType() + " tmp1, tmp2");
        this.appendStatement("tmp1 = ((" + accesserType + "Property)getList(" + this.quote(list.getName() + "_") + "+ContextManager.getCallContext().getCurrentLanguage()).get(index1)).get" + accesserType + "()");
        this.appendStatement("tmp2 = ((" + accesserType + "Property)getList(" + this.quote(list.getName() + "_") + "+ContextManager.getCallContext().getCurrentLanguage()).get(index2)).get" + accesserType + "()");
        this.appendStatement("((" + accesserType + "Property)getList(" + this.quote(list.getName() + "_") + "+ContextManager.getCallContext().getCurrentLanguage()).get(index1)).set" + accesserType + "(tmp2)");
        this.appendStatement("((" + accesserType + "Property)getList(" + this.quote(list.getName() + "_") + "+ContextManager.getCallContext().getCurrentLanguage()).get(index2)).set" + accesserType + "(tmp1)");
        this.closeBlockNEW();
        DocumentGenerator.emptyline();
        this.appendString("public " + c.toJavaType() + " " + DocumentGenerator.getListElementGetterName(list) + "(int index){");
        this.increaseIdent();
        this.appendStatement(accesserType + "Property p = (" + accesserType + "Property)getList(" + this.quote(list.getName() + "_") + "+ContextManager.getCallContext().getCurrentLanguage()).get(index)");
        this.appendStatement("return p.get" + accesserType + "()");
        this.closeBlockNEW();
        DocumentGenerator.emptyline();
    }

    private void generateTableMethods(MetaTableProperty table) {
        MetaProperty p;
        int i;
        List<MetaProperty> columns = table.getColumns();
        String decl = "public void " + DocumentGenerator.getContainerEntryAdderName(table) + "(";
        for (i = 0; i < columns.size(); ++i) {
            p = columns.get(i);
            decl = decl + "String " + table.extractSubName(p);
            if (i >= columns.size() - 1) continue;
            decl = decl + ", ";
        }
        decl = decl + "){";
        this.appendString(decl);
        this.increaseIdent();
        this.appendStatement("List tmp");
        for (i = 0; i < columns.size(); ++i) {
            p = columns.get(i);
            this.appendStatement("tmp = getList(" + p.toNameConstant() + ")");
            this.appendStatement("tmp.add(new StringProperty(\"\", " + table.extractSubName(p) + "))");
            this.appendStatement("setList(" + p.toNameConstant() + ", tmp)");
            DocumentGenerator.emptyline();
        }
        this.closeBlockNEW();
        DocumentGenerator.emptyline();
        this.appendString("public void " + DocumentGenerator.getContainerEntryDeleterName(table) + "(int index){");
        this.increaseIdent();
        for (i = 0; i < columns.size(); ++i) {
            p = columns.get(i);
            this.appendStatement("getListProperty(" + p.toNameConstant() + ").remove(index)");
        }
        this.closeBlockNEW();
        DocumentGenerator.emptyline();
        this.appendString("public List<String> get" + StringUtils.capitalize((String)table.getName()) + "Row(int index){");
        this.increaseIdent();
        this.appendStatement("List<String> ret = new ArrayList<String>(1)");
        for (i = 0; i < columns.size(); ++i) {
            p = columns.get(i);
            this.appendString("try{");
            this.appendIncreasedStatement("ret.add(((StringProperty)getList(" + p.toNameConstant() + ").get(index)).getString())");
            this.appendString("}catch(IndexOutOfBoundsException e){ ");
            this.appendIncreasedStatement("ret.add(\"\")");
            this.appendString("}");
        }
        this.appendStatement("return ret");
        this.closeBlockNEW();
        DocumentGenerator.emptyline();
        this.appendString("public List<List<String>> " + DocumentGenerator.getTableGetterName(table) + "(){");
        this.increaseIdent();
        this.appendStatement("int size = " + DocumentGenerator.getContainerSizeGetterName(table) + "();");
        this.appendStatement("List<List<String>> ret = new java.util.ArrayList<List<String>>(size)");
        this.appendString("for (int i=0; i<size; i++)");
        this.appendIncreasedStatement("ret.add(get" + StringUtils.capitalize((String)table.getName()) + "Row(i))");
        this.appendStatement("return ret");
        this.closeBlockNEW();
        DocumentGenerator.emptyline();
    }

    public static String getContainerSizeGetterName(MetaContainerProperty p) {
        return "get" + StringUtils.capitalize((String)p.getName()) + "Size";
    }

    public static String getContainerSizeGetterName(MetaContainerProperty p, String language) {
        return "get" + StringUtils.capitalize((String)p.getName(language)) + "Size";
    }

    public static String getTableGetterName(MetaTableProperty p) {
        return "get" + StringUtils.capitalize((String)p.getName()) + "Table";
    }

    public static String getContainerEntryAdderName(MetaContainerProperty p) {
        return DataFacadeGenerator.getContainerEntryAdderName(p);
    }

    public static String getContainerEntryAdderName(MetaContainerProperty p, String language) {
        return DataFacadeGenerator.getContainerEntryAdderName(p, language);
    }

    public static String getContainerEntryDeleterName(MetaContainerProperty p) {
        return DataFacadeGenerator.getContainerEntryDeleterName(p);
    }

    public static String getContainerEntryDeleterName(MetaContainerProperty p, String language) {
        return DataFacadeGenerator.getContainerEntryDeleterName(p, language);
    }

    public static String getContainerEntrySwapperName(MetaContainerProperty p) {
        return DataFacadeGenerator.getContainerEntrySwapperName(p);
    }

    public static String getContainerEntrySwapperName(MetaContainerProperty p, String language) {
        return DataFacadeGenerator.getContainerEntrySwapperName(p, language);
    }

    public static String getListElementGetterName(MetaListProperty list) {
        return DataFacadeGenerator.getListElementGetterName(list);
    }

    public static String getListElementGetterName(MetaListProperty list, String language) {
        return DataFacadeGenerator.getListElementGetterName(list, language);
    }

    protected void generateMultilingualSwitchSupport(MetaDocument doc) {
        if (!doc.isMultilingual()) {
            return;
        }
        this.appendString("public boolean isMultilingualDisabledInstance(){");
        this.increaseIdent();
        this.appendString("try{");
        this.increaseIdent();
        this.appendStatement("return ((BooleanProperty)getInternalProperty(INT_PROPERTY_MULTILINGUAL_DISABLED)).getboolean()");
        this.decreaseIdent();
        this.appendString("}catch(NoSuchPropertyException e){");
        this.appendIncreasedString("return false;");
        this.appendString("}");
        this.closeBlockNEW();
        DocumentGenerator.emptyline();
        this.appendString("public void setMultilingualDisabledInstance(boolean value){");
        this.increaseIdent();
        this.appendStatement("setInternalProperty(new BooleanProperty(INT_PROPERTY_MULTILINGUAL_DISABLED, value))");
        this.closeBlockNEW();
    }
}

