/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.model.docs;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.asg.generator.AbstractGenerator;
import net.anotheria.asg.generator.CommentGenerator;
import net.anotheria.asg.generator.FileEntry;
import net.anotheria.asg.generator.GeneratedClass;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.IGenerateable;
import net.anotheria.asg.generator.IGenerator;
import net.anotheria.asg.generator.meta.MetaDocument;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.asg.generator.model.docs.DocumentGenerator;

public class ModuleFactoryGenerator
extends AbstractGenerator
implements IGenerator {
    @Override
    public List<FileEntry> generate(IGenerateable gmodule) {
        MetaModule mod = (MetaModule)gmodule;
        ArrayList<FileEntry> ret = new ArrayList<FileEntry>();
        ret.add(this.generateFactory(mod));
        return ret;
    }

    public static String getModuleFactoryName(MetaModule module) {
        return module.getFactoryClassName();
    }

    private FileEntry generateFactory(MetaModule module) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        clazz.setName(module.getFactoryClassName());
        clazz.setParent("AbstractModuleFactory");
        clazz.setPackageName(GeneratorDataRegistry.getInstance().getContext().getPackageName(module) + ".data");
        clazz.setTypeComment(CommentGenerator.generateJavaTypeComment(ModuleFactoryGenerator.getModuleFactoryName(module), "The Factory for the " + module.getName() + " objects."));
        clazz.addImport("net.anotheria.anodoc.data.Module");
        clazz.addImport("net.anotheria.anodoc.data.Document");
        clazz.addImport("net.anotheria.anodoc.data.DataHolder");
        clazz.addImport("net.anotheria.anodoc.service.AbstractModuleFactory");
        this.startClassBody();
        this.generateModuleCreator(module);
        ModuleFactoryGenerator.emptyline();
        this.generateSecondLevelDocumentCreator(module);
        ModuleFactoryGenerator.emptyline();
        return new FileEntry(clazz);
    }

    private void generateModuleCreator(MetaModule module) {
        this.appendString("public Module recreateModule(String ownerId, String copyId) {");
        this.increaseIdent();
        this.appendStatement("return new Module" + module.getName() + "()");
        this.closeBlockNEW();
    }

    private void generateSecondLevelDocumentCreator(MetaModule module) {
        this.appendString("public Document createDocument(String id, DataHolder context) {");
        this.increaseIdent();
        List<MetaDocument> docs = module.getDocuments();
        for (int i = 0; i < docs.size(); ++i) {
            MetaDocument doc = docs.get(i);
            this.appendString("if (context.getId().equals(" + module.getModuleClassName() + "." + doc.getListName() + "))");
            this.increaseIdent();
            this.appendStatement("return new " + DocumentGenerator.getDocumentName(doc) + "(id)");
            this.decreaseIdent();
        }
        this.appendStatement("throw new RuntimeException(\"Unexpected document in list:\"+context.getId())");
        this.closeBlockNEW();
    }
}

