/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.model.federation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.anotheria.asg.generator.CommentGenerator;
import net.anotheria.asg.generator.Context;
import net.anotheria.asg.generator.FileEntry;
import net.anotheria.asg.generator.GeneratedClass;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.IGenerateable;
import net.anotheria.asg.generator.IGenerator;
import net.anotheria.asg.generator.meta.FederatedDocumentMapping;
import net.anotheria.asg.generator.meta.FederatedModuleDef;
import net.anotheria.asg.generator.meta.MetaDocument;
import net.anotheria.asg.generator.meta.MetaFederationModule;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.asg.generator.meta.MetaProperty;
import net.anotheria.asg.generator.model.AbstractServiceGenerator;
import net.anotheria.asg.generator.model.DataFacadeGenerator;
import net.anotheria.asg.generator.model.ServiceGenerator;
import net.anotheria.asg.generator.model.federation.FederationVOGenerator;

public class FederationServiceGenerator
extends AbstractServiceGenerator
implements IGenerator {
    private final MetaProperty lastUpdate = new MetaProperty("lastUpdateTimestamp", MetaProperty.Type.LONG);
    public static final String FEDERATION_VARIABLE_PREFIX = "federated";

    @Override
    public List<FileEntry> generate(IGenerateable gmodule) {
        MetaModule mod = (MetaModule)gmodule;
        ArrayList<FileEntry> ret = new ArrayList<FileEntry>();
        ret.add(new FileEntry(this.generateFactory(mod)));
        ret.add(new FileEntry(this.generateImplementation(mod)));
        return ret;
    }

    private GeneratedClass generateImplementation(MetaModule moduleX) {
        MetaModule target;
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        this.appendGenerationPoint("generateImplementation");
        MetaFederationModule module = (MetaFederationModule)moduleX;
        Object federationcomment = "Federated modules: ";
        for (FederatedModuleDef fedDef : module.getFederatedModules()) {
            federationcomment = (String)federationcomment + fedDef.getName() + " as " + fedDef.getKey() + ", ";
        }
        clazz.setTypeComment(CommentGenerator.generateJavaTypeComment(this.getImplementationName(module), "The implementation of the " + FederationServiceGenerator.getInterfaceName(module) + "as a federated service layer: " + (String)federationcomment));
        clazz.setPackageName(this.getPackageName(module));
        clazz.addImport("java.nio.charset.Charset");
        clazz.addImport("java.util.List");
        clazz.addImport("java.util.ArrayList");
        clazz.addImport("java.util.HashMap");
        clazz.addImport("java.util.Set");
        clazz.addImport("java.io.IOException");
        clazz.addImport("net.anotheria.util.sorter.SortType");
        clazz.addImport("net.anotheria.util.sorter.StaticQuickSorter");
        clazz.addImport("net.anotheria.util.StringUtils");
        clazz.addImport("net.anotheria.util.slicer.Segment");
        FederationServiceGenerator.emptyline();
        clazz.addImport("org.codehaus.jettison.json.JSONObject");
        clazz.addImport("org.codehaus.jettison.json.JSONArray");
        clazz.addImport("org.codehaus.jettison.json.JSONException");
        clazz.addImport("net.anotheria.anosite.gen.shared.util.DocumentName");
        Context context = GeneratorDataRegistry.getInstance().getContext();
        clazz.addImport(context.getServicePackageName(MetaModule.SHARED) + ".BasicService");
        List<FederatedModuleDef> federatedModules = module.getFederatedModules();
        HashMap<String, MetaModule> targetModules = new HashMap<String, MetaModule>();
        for (FederatedModuleDef fedDef : federatedModules) {
            MetaModule target2 = GeneratorDataRegistry.getInstance().getModule(fedDef.getName());
            if (target2 == null) {
                throw new RuntimeException("No such module: " + fedDef.getName());
            }
            clazz.addImport(ServiceGenerator.getInterfaceImport(target2));
            clazz.addImport(ServiceGenerator.getExceptionImport(target2));
            clazz.addImport(ServiceGenerator.getFactoryImport(target2));
            targetModules.put(fedDef.getKey(), target2);
        }
        List<MetaDocument> docs = module.getDocuments();
        for (int i = 0; i < docs.size(); ++i) {
            MetaDocument doc = docs.get(i);
            clazz.addImport(DataFacadeGenerator.getDocumentImport(doc));
            clazz.addImport(FederationVOGenerator.getDocumentImport(context, doc));
            clazz.addImport(DataFacadeGenerator.getDocumentFactoryImport(context, doc));
            List<FederatedDocumentMapping> mappings = module.getMappingsForDocument(doc.getName());
            Iterator<FederatedDocumentMapping> iterator = mappings.iterator();
            while (iterator.hasNext()) {
                FederatedDocumentMapping mapping = iterator.next();
                MetaDocument target3 = ((MetaModule)targetModules.get(mapping.getTargetKey())).getDocumentByName(mapping.getTargetDocument());
                clazz.addImport(DataFacadeGenerator.getDocumentImport(target3));
            }
        }
        clazz.addImport("net.anotheria.anodoc.query2.DocumentQuery");
        clazz.addImport("net.anotheria.anodoc.query2.QueryResult");
        clazz.addImport("net.anotheria.anodoc.query2.QueryResultEntry");
        clazz.addImport("net.anotheria.anodoc.query2.QueryProperty");
        clazz.addImport("net.anotheria.util.xml.XMLNode");
        clazz.setName(this.getImplementationName(module));
        clazz.setParent("BasicService");
        clazz.addInterface(FederationServiceGenerator.getInterfaceName(module));
        this.startClassBody();
        this.appendStatement("private static " + this.getImplementationName(module) + " instance");
        FederationServiceGenerator.emptyline();
        String throwsClause = " throws " + ServiceGenerator.getExceptionName(module) + " ";
        String throwClause = "throw new " + ServiceGenerator.getExceptionName(module) + "(" + this.quote("Undelying service failed: ") + "+e.getMessage())";
        this.appendCommentLine("Federated services: ");
        this.appendStatement("public static final char ID_DELIMITER = '-'");
        for (FederatedModuleDef fedDef : federatedModules) {
            target = (MetaModule)targetModules.get(fedDef.getKey());
            this.appendStatement(ServiceGenerator.getInterfaceName(target) + " federated" + fedDef.getKey());
            this.appendStatement("public static final String ID_PREFIX_" + fedDef.getKey() + " = " + this.quote(fedDef.getKey()) + "+ID_DELIMITER");
            targetModules.put(fedDef.getKey(), target);
        }
        FederationServiceGenerator.emptyline();
        this.appendStatement("private HashMap<String, Object> federatedServiceMap");
        this.appendString("private " + this.getImplementationName(module) + "(){");
        this.increaseIdent();
        if (module.getListeners().size() > 0) {
            for (int i = 0; i < module.getListeners().size(); ++i) {
                String listClassName = module.getListeners().get(i);
                this.appendStatement("addServiceListener(new " + listClassName + "())");
            }
            FederationServiceGenerator.emptyline();
        }
        this.appendStatement("federatedServiceMap = new HashMap<String, Object>(" + federatedModules.size() + ")");
        for (FederatedModuleDef fedDef : federatedModules) {
            target = (MetaModule)targetModules.get(fedDef.getKey());
            this.appendStatement(FEDERATION_VARIABLE_PREFIX + fedDef.getKey() + " = " + ServiceGenerator.getFactoryName(target) + ".create" + ServiceGenerator.getServiceName(target) + "()");
            targetModules.put(fedDef.getKey(), target);
            this.appendStatement("federatedServiceMap.put(" + this.quote(fedDef.getKey()) + ", federated" + fedDef.getKey() + ")");
        }
        this.closeBlockNEW();
        FederationServiceGenerator.emptyline();
        this.appendString("static final " + this.getImplementationName(module) + " getInstance(){");
        this.increaseIdent();
        this.appendString("if (instance==null){");
        this.increaseIdent();
        this.appendStatement("instance = new " + this.getImplementationName(module) + "()");
        this.closeBlockNEW();
        this.appendStatement("return instance");
        this.closeBlockNEW();
        FederationServiceGenerator.emptyline();
        for (int i = 0; i < docs.size(); ++i) {
            MetaDocument targetDoc;
            MetaDocument target4;
            MetaDocument doc = docs.get(i);
            String listDecl = "List<" + doc.getName() + ">";
            List<FederatedDocumentMapping> mappings = module.getMappingsForDocument(doc.getName());
            for (FederatedDocumentMapping mapping : mappings) {
                target4 = ((MetaModule)targetModules.get(mapping.getTargetKey())).getDocumentByName(mapping.getTargetDocument());
                this.appendString("private " + doc.getName() + " copy(" + target4.getName() + " d){");
                this.increaseIdent();
                this.appendStatement(doc.getName() + " ret = " + DataFacadeGenerator.getDocumentFactoryName(doc) + ".create" + doc.getName() + "(ID_PREFIX_" + mapping.getTargetKey() + "+d.getId())");
                List<MetaProperty> properties = doc.getProperties();
                for (MetaProperty p : properties) {
                    this.appendStatement("ret.set" + p.getAccesserName() + "(d.get" + p.getAccesserName() + "())");
                }
                this.appendStatement("((" + FederationVOGenerator.getDocumentImplName(doc) + ")ret).set" + this.lastUpdate.getAccesserName() + "(d.get" + this.lastUpdate.getAccesserName() + "())");
                this.appendStatement("return ret");
                this.closeBlockNEW();
                FederationServiceGenerator.emptyline();
                this.appendString("private List<" + doc.getName() + "> copy" + doc.getName() + "List" + mapping.getTargetKey() + "(List<" + target4.getName() + "> list){");
                this.increaseIdent();
                this.appendStatement("List<" + doc.getName() + "> ret = new ArrayList<" + doc.getName() + ">(list.size())");
                this.appendString("for (" + target4.getName() + " d : list)");
                this.appendIncreasedStatement("ret.add(copy(d))");
                this.appendStatement("return ret");
                this.closeBlockNEW();
                FederationServiceGenerator.emptyline();
            }
            this.appendString("public " + listDecl + " get" + doc.getMultiple() + "()" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement(listDecl + " " + doc.getMultiple().toLowerCase() + " = new Array" + listDecl + "()");
            for (FederatedDocumentMapping mapping : mappings) {
                target4 = ((MetaModule)targetModules.get(mapping.getTargetKey())).getDocumentByName(mapping.getTargetDocument());
                this.appendString("try{");
                this.increaseIdent();
                this.appendStatement("List<" + target4.getName() + "> source" + mapping.getTargetKey() + " = federated" + mapping.getTargetKey() + ".get" + target4.getMultiple() + "()");
                this.appendStatement(doc.getMultiple().toLowerCase() + ".addAll(copy" + doc.getName() + "List" + mapping.getTargetKey() + "(source" + mapping.getTargetKey() + "))");
                this.decreaseIdent();
                this.appendString("}catch(" + ServiceGenerator.getExceptionName((MetaModule)targetModules.get(mapping.getTargetKey())) + " e){");
                this.appendCommentLine("TODO Add logging?");
                this.appendIncreasedStatement(throwClause);
                this.appendString("}");
            }
            this.appendStatement("return " + doc.getMultiple().toLowerCase());
            this.closeBlockNEW();
            FederationServiceGenerator.emptyline();
            this.appendString("public " + listDecl + " get" + doc.getMultiple() + "(SortType sortType)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("return StaticQuickSorter.sort(get" + doc.getMultiple() + "(), sortType)");
            this.closeBlockNEW();
            FederationServiceGenerator.emptyline();
            this.appendString("public void delete" + doc.getName() + "(" + doc.getName() + " " + doc.getVariableName() + ")" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("delete" + doc.getName() + "(" + doc.getVariableName() + ".getId())");
            this.closeBlockNEW();
            FederationServiceGenerator.emptyline();
            this.appendString("public void delete" + doc.getName() + "(String id)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("throw new RuntimeException(\"not implemented.\")");
            this.closeBlockNEW();
            FederationServiceGenerator.emptyline();
            this.appendComment("Deletes multiple " + doc.getName() + " objects.");
            this.appendString("public void delete" + doc.getMultiple() + "(" + listDecl + " list)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("throw new RuntimeException(" + this.quote("Not yet implemented") + ")");
            this.closeBlockNEW();
            FederationServiceGenerator.emptyline();
            this.appendString("public " + doc.getName() + " get" + doc.getName() + "(String id)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("String tokens[] = StringUtils.tokenize(id, ID_DELIMITER)");
            for (FederatedDocumentMapping mapping : mappings) {
                this.appendString("if (tokens[0].equals(" + this.quote(mapping.getTargetKey()) + ")){");
                this.increaseIdent();
                this.appendString("try{");
                this.appendIncreasedStatement("return copy(federated" + mapping.getTargetKey() + ".get" + mapping.getTargetDocument() + "(tokens[1]))");
                this.appendString("}catch(" + ServiceGenerator.getExceptionName((MetaModule)targetModules.get(mapping.getTargetKey())) + " e){");
                this.appendCommentLine("TODO Add logging?");
                this.appendIncreasedStatement(throwClause);
                this.appendString("}");
                this.decreaseIdent();
                this.appendString("}");
            }
            this.appendStatement("throw new RuntimeException(" + this.quote("Unknown federated key: ") + "+tokens[0]+" + this.quote(" in ") + "+id)");
            this.closeBlockNEW();
            FederationServiceGenerator.emptyline();
            this.appendString("public " + doc.getName() + " import" + doc.getName() + "(" + doc.getName() + " " + doc.getVariableName() + ")" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("throw new RuntimeException(\"no import in federated services.\")");
            this.closeBlockNEW();
            FederationServiceGenerator.emptyline();
            this.appendString("public " + listDecl + " import" + doc.getMultiple() + "(" + listDecl + " list)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("throw new RuntimeException(\"no import in federated services.\")");
            this.closeBlockNEW();
            FederationServiceGenerator.emptyline();
            this.appendString("public " + doc.getName() + " create" + doc.getName() + "(" + doc.getName() + " " + doc.getVariableName() + ")" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("throw new AssertionError(\"not implemented.\")");
            this.closeBlockNEW();
            FederationServiceGenerator.emptyline();
            this.appendComment("Creates multiple new " + doc.getName() + " objects.\nReturns the created versions.");
            this.appendString("public " + listDecl + " create" + doc.getMultiple() + "(" + listDecl + " list)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("throw new AssertionError(\"not implemented.\")");
            this.closeBlockNEW();
            FederationServiceGenerator.emptyline();
            this.appendComment("Updates multiple new " + doc.getName() + " objects.\nReturns the updated versions.");
            this.appendString("public " + listDecl + " update" + doc.getMultiple() + "(" + listDecl + " list)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("throw new RuntimeException(" + this.quote("Not yet implemented") + ")");
            this.closeBlockNEW();
            FederationServiceGenerator.emptyline();
            this.appendString("public " + doc.getName() + " update" + doc.getName() + "(" + doc.getName() + " " + doc.getVariableName() + ")" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("throw new AssertionError(\"not implemented.\")");
            this.closeBlockNEW();
            FederationServiceGenerator.emptyline();
            this.appendString("public " + listDecl + " get" + doc.getMultiple() + "ByProperty(String propertyName, Object value)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement(listDecl + " " + doc.getMultiple().toLowerCase() + " = new Array" + listDecl + "()");
            for (FederatedDocumentMapping mapping : mappings) {
                target4 = ((MetaModule)targetModules.get(mapping.getTargetKey())).getDocumentByName(mapping.getTargetDocument());
                this.appendString("try{");
                this.increaseIdent();
                this.appendStatement("List<" + target4.getName() + "> source" + mapping.getTargetKey() + " = federated" + mapping.getTargetKey() + ".get" + target4.getMultiple() + "ByProperty(propertyName, value)");
                this.appendStatement(doc.getMultiple().toLowerCase() + ".addAll(copy" + doc.getName() + "List" + mapping.getTargetKey() + "(source" + mapping.getTargetKey() + "))");
                this.decreaseIdent();
                this.appendString("}catch(" + ServiceGenerator.getExceptionName((MetaModule)targetModules.get(mapping.getTargetKey())) + " e){");
                this.appendCommentLine("TODO Add logging?");
                this.appendIncreasedStatement(throwClause);
                this.appendString("}");
            }
            this.appendStatement("return " + doc.getMultiple().toLowerCase());
            this.closeBlockNEW();
            FederationServiceGenerator.emptyline();
            this.appendString("public " + listDecl + " get" + doc.getMultiple() + "ByProperty(String propertyName, Object value, SortType sortType)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("return StaticQuickSorter.sort(get" + doc.getMultiple() + "ByProperty(propertyName, value), sortType)");
            this.closeBlockNEW();
            this.appendComment("Executes a query on " + doc.getMultiple());
            this.appendString("public QueryResult executeQueryOn" + doc.getMultiple() + "(DocumentQuery query)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement(listDecl + " all" + doc.getMultiple() + " = get" + doc.getMultiple() + "()");
            this.appendStatement("QueryResult result = new QueryResult()");
            this.appendString("for (int i=0; i<all" + doc.getMultiple() + ".size(); i++){");
            this.increaseIdent();
            this.appendStatement("List<QueryResultEntry> partialResult = query.match(all" + doc.getMultiple() + ".get(i))");
            this.appendStatement("result.add(partialResult)");
            this.closeBlockNEW();
            this.appendStatement("return result");
            this.closeBlockNEW();
            FederationServiceGenerator.emptyline();
            this.appendComment("Returns all " + doc.getName() + " objects, where property matches.");
            this.appendString("public " + listDecl + " get" + doc.getMultiple() + "ByProperty(QueryProperty... property)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("throw new RuntimeException(\"Not yet implemented\")");
            this.closeBlockNEW();
            FederationServiceGenerator.emptyline();
            this.appendComment("Returns all " + doc.getName() + " objects, where property matches, sorted");
            this.appendString("public " + listDecl + " get" + doc.getMultiple() + "ByProperty(SortType sortType, QueryProperty... property)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("throw new RuntimeException(\"Not yet implemented\")");
            this.closeBlockNEW();
            FederationServiceGenerator.emptyline();
            this.appendComment("Returns " + doc.getName() + " objects count.");
            this.appendString("public int get" + doc.getMultiple() + "Count()" + throwsClause + "{");
            this.increaseIdent();
            this.appendString("int pCount = 0;");
            for (FederatedDocumentMapping mapping : mappings) {
                target4 = ((MetaModule)targetModules.get(mapping.getTargetKey())).getDocumentByName(mapping.getTargetDocument());
                this.appendString("try {");
                this.increaseIdent();
                this.appendStatement("pCount = pCount + federated" + mapping.getTargetKey() + ".get" + target4.getMultiple() + "().size()");
                this.decreaseIdent();
                this.appendString("} catch (" + ServiceGenerator.getExceptionName((MetaModule)targetModules.get(mapping.getTargetKey())) + " e) {");
                this.appendIncreasedStatement(throwClause);
                this.appendString("}");
            }
            this.appendStatement("return pCount");
            this.closeBlockNEW();
            FederationServiceGenerator.emptyline();
            this.appendComment("Returns " + doc.getName() + " objects segment.");
            this.appendString("public " + listDecl + " get" + doc.getMultiple() + "(Segment aSegment)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("throw new RuntimeException(\"Not yet implemented\")");
            this.closeBlockNEW();
            FederationServiceGenerator.emptyline();
            this.appendComment("Returns " + doc.getName() + " objects segment, where property matched.");
            this.appendString("public " + listDecl + " get" + doc.getMultiple() + "ByProperty(Segment aSegment, QueryProperty... aProperty)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("throw new RuntimeException(\"Not yet implemented\")");
            this.closeBlockNEW();
            FederationServiceGenerator.emptyline();
            this.appendComment("Returns " + doc.getName() + " objects segment, where property matched, sorted.");
            this.appendString("public " + listDecl + " get" + doc.getMultiple() + "ByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("throw new RuntimeException(\"Not yet implemented\")");
            this.closeBlockNEW();
            FederationServiceGenerator.emptyline();
            this.appendStatement("public XMLNode export" + doc.getMultiple() + "ToXML(List<" + doc.getName() + "> list" + doc.getMultiple() + "){");
            this.increaseIdent();
            this.appendStatement("return new XMLNode(" + this.quote("unimplemented_federated_export_" + module.getName()) + ")");
            this.closeBlockNEW();
            FederationServiceGenerator.emptyline();
            FederationServiceGenerator.emptyline();
            this.appendString("public XMLNode export" + doc.getMultiple() + "ToXML(String[] languages,List<" + doc.getName() + "> list" + doc.getMultiple() + ")" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("return new XMLNode(" + this.quote("unimplemented_federated_export_" + module.getName()) + ")");
            this.closeBlockNEW();
            FederationServiceGenerator.emptyline();
            this.appendString("@Override");
            this.appendString("public void fetch" + doc.getName() + "(final String id, Set<String> addedDocuments, JSONArray data) " + throwsClause + " {");
            this.increaseIdent();
            FederationServiceGenerator.emptyline();
            this.appendString("if (id.isEmpty() || addedDocuments.contains(\"" + doc.getName() + "\" + id))");
            this.increaseIdent();
            this.appendStatement("return");
            this.decreaseIdent();
            FederationServiceGenerator.emptyline();
            this.openTry();
            this.appendStatement(doc.getName() + " a" + doc.getName() + " = get" + doc.getName() + "(id)");
            this.appendStatement("addedDocuments.add(\"" + doc.getName() + "\" + id)");
            this.appendStatement("String target" + doc.getName() + "Id = a" + doc.getName() + ".getId()");
            FederationServiceGenerator.emptyline();
            for (FederatedDocumentMapping mapping : mappings) {
                targetDoc = ((MetaModule)targetModules.get(mapping.getTargetKey())).getDocumentByName(mapping.getTargetDocument());
                this.appendString("if (target" + doc.getName() + "Id.charAt(0) == '" + mapping.getTargetKey() + "')");
                this.increaseIdent();
                this.appendStatement("get" + targetDoc.getParentModule().getName() + "Service().fetch" + targetDoc.getName() + "(target" + doc.getName() + "Id.substring(2), addedDocuments, data)");
                this.decreaseIdent();
            }
            FederationServiceGenerator.emptyline();
            for (FederatedDocumentMapping mapping : mappings) {
                targetDoc = ((MetaModule)targetModules.get(mapping.getTargetKey())).getDocumentByName(mapping.getTargetDocument());
                clazz.addImport(ServiceGenerator.getExceptionImport(targetDoc.getParentModule()));
                this.appendCatch(ServiceGenerator.getExceptionName(targetDoc.getParentModule()));
                this.appendStatement("throw new " + ServiceGenerator.getExceptionName(doc.getParentModule()) + " (\"Problem with getting " + targetDoc.getName() + " by id:\" + id + \".\" + e.getMessage())");
            }
            this.closeBlockNEW();
            this.closeBlockNEW();
            FederationServiceGenerator.emptyline();
        }
        this.appendString("public void executeParsingForDocument (final DocumentName documentName, final JSONObject data)" + throwsClause + "{");
        this.increaseIdent();
        this.appendStatement("throw new UnsupportedOperationException(\" not implemented and should not BE!\")");
        this.closeBlockNEW();
        this.appendComment("Executes a query on all data objects (documents, vo) which are part of this module and managed by this service");
        this.appendString("public QueryResult executeQueryOnAllObjects(DocumentQuery query)" + throwsClause + "{");
        this.increaseIdent();
        this.appendStatement("QueryResult ret = new QueryResult()");
        for (MetaDocument doc : docs) {
            this.appendStatement("ret.add(executeQueryOn" + doc.getMultiple() + "(query).getEntries())");
        }
        this.appendStatement("return ret");
        this.closeBlock("executeQueryOnAllObjects");
        FederationServiceGenerator.emptyline();
        FederationServiceGenerator.emptyline();
        this.appendString("public XMLNode exportToXML()" + throwsClause + "{");
        this.increaseIdent();
        this.appendStatement("return new XMLNode(" + this.quote("unimplemented_federated_export_" + module.getName()) + ")");
        this.closeBlockNEW();
        FederationServiceGenerator.emptyline();
        this.appendString("public XMLNode exportToXML(String[] languages)" + throwsClause + "{");
        this.increaseIdent();
        this.appendStatement("return new XMLNode(" + this.quote("unimplemented_federated_export_" + module.getName()) + ")");
        this.closeBlockNEW();
        return clazz;
    }

    @Override
    protected String getMoskitoSubsystem() {
        return super.getMoskitoSubsystem() + "-fed";
    }
}

