/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.model.federation;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.asg.generator.Context;
import net.anotheria.asg.generator.FileEntry;
import net.anotheria.asg.generator.GeneratedClass;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.IGenerateable;
import net.anotheria.asg.generator.IGenerator;
import net.anotheria.asg.generator.meta.MetaContainerProperty;
import net.anotheria.asg.generator.meta.MetaDocument;
import net.anotheria.asg.generator.meta.MetaListProperty;
import net.anotheria.asg.generator.meta.MetaProperty;
import net.anotheria.asg.generator.meta.MetaTableProperty;
import net.anotheria.asg.generator.model.AbstractDataObjectGenerator;
import net.anotheria.util.StringUtils;

public class FederationVOGenerator
extends AbstractDataObjectGenerator
implements IGenerator {
    private final MetaProperty id = new MetaProperty("id", MetaProperty.Type.STRING);
    private final MetaProperty lastUpdate = new MetaProperty("lastUpdateTimestamp", MetaProperty.Type.LONG);

    @Override
    public List<FileEntry> generate(IGenerateable gdoc) {
        MetaDocument doc = (MetaDocument)gdoc;
        this.id.setReadonly(true);
        ArrayList<FileEntry> ret = new ArrayList<FileEntry>();
        ret.add(new FileEntry(this.generateDocument(doc)));
        ret.add(new FileEntry(this.generateDocumentFactory(doc)));
        return ret;
    }

    @Override
    public String getDataObjectImplName(MetaDocument doc) {
        return FederationVOGenerator.getDocumentImplName(doc);
    }

    public static String getDocumentImplName(MetaDocument doc) {
        return doc.getName() + "VO";
    }

    private GeneratedClass generateDocument(MetaDocument doc) {
        int i;
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        clazz.setPackageName(this.getPackageName(doc));
        for (i = 0; i < doc.getProperties().size(); ++i) {
            if (!(doc.getProperties().get(i) instanceof MetaContainerProperty)) continue;
            clazz.addImport("java.util.List");
            clazz.addImport("java.util.ArrayList");
            break;
        }
        for (i = 0; i < doc.getProperties().size(); ++i) {
            if (!(doc.getProperties().get(i) instanceof MetaTableProperty)) continue;
            clazz.addImport("java.util.List");
            clazz.addImport("java.util.ArrayList");
            break;
        }
        for (MetaProperty p : doc.getProperties()) {
            if (!p.isMultilingual() || !GeneratorDataRegistry.getInstance().getContext().areLanguagesSupported()) continue;
            clazz.addImport("net.anotheria.anodoc.util.context.ContextManager");
            break;
        }
        clazz.addImport("net.anotheria.util.xml.XMLNode");
        clazz.addImport("net.anotheria.util.crypt.MD5Util");
        clazz.addImport("net.anotheria.asg.data.AbstractFederatedVO");
        clazz.addInterface(doc.getName());
        if (doc.isComparable()) {
            clazz.addImport("net.anotheria.util.sorter.IComparable");
            clazz.addImport("net.anotheria.util.BasicComparable");
            clazz.addInterface("IComparable");
        }
        clazz.setName(FederationVOGenerator.getDocumentImplName(doc));
        clazz.setParent("AbstractFederatedVO");
        this.startClassBody();
        this.generatePropertyFields(doc);
        FederationVOGenerator.emptyline();
        this.generateDefaultConstructor(doc);
        FederationVOGenerator.emptyline();
        this.generateCloneConstructor(doc);
        FederationVOGenerator.emptyline();
        this.generateBuilderConstructor(doc);
        FederationVOGenerator.emptyline();
        this.generatePropertyAccessMethods(doc);
        FederationVOGenerator.emptyline();
        this.generateToStringMethod(doc);
        FederationVOGenerator.emptyline();
        this.generateCloneMethod(doc);
        FederationVOGenerator.emptyline();
        this.generateCopyMethod(doc);
        FederationVOGenerator.emptyline();
        this.generateGetPropertyValueMethod(doc);
        FederationVOGenerator.emptyline();
        this.generateAdditionalMethods(doc);
        if (doc.isComparable()) {
            FederationVOGenerator.emptyline();
            this.generateCompareMethod(doc);
        }
        FederationVOGenerator.emptyline();
        this.generateDefNameMethod(doc);
        FederationVOGenerator.emptyline();
        this.generateDefParentNameMethod(doc);
        FederationVOGenerator.emptyline();
        this.generateGetFootprintMethod(doc);
        FederationVOGenerator.emptyline();
        this.generateEqualsMethod(doc);
        return clazz;
    }

    private void generateDefaultConstructor(MetaDocument doc) {
        this.appendString("public " + FederationVOGenerator.getDocumentImplName(doc) + "(String anId){");
        this.increaseIdent();
        this.appendStatement("id = anId");
        this.closeBlockNEW();
    }

    private void generateCloneConstructor(MetaDocument doc) {
        this.appendString("public " + FederationVOGenerator.getDocumentImplName(doc) + "(" + FederationVOGenerator.getDocumentImplName(doc) + " toClone){");
        this.increaseIdent();
        this.appendStatement("this.id = toClone.id");
        this.appendStatement("copyAttributesFrom(toClone)");
        this.closeBlockNEW();
    }

    private void generateBuilderConstructor(MetaDocument doc) {
        this.appendString(FederationVOGenerator.getDocumentImplName(doc) + "(" + this.getDocumentBuilderName(doc) + " builder){");
        this.increaseIdent();
        this.appendStatement("id = " + this.quote(""));
        for (MetaProperty p : doc.getProperties()) {
            this.appendStatement(p.getName().toLowerCase(), " = ", "builder.", p.getName());
        }
        for (MetaProperty p : doc.getLinks()) {
            this.appendStatement(p.getName().toLowerCase(), " = ", "builder.", p.getName());
        }
        this.closeBlockNEW();
    }

    private void generatePropertyFields(MetaDocument doc) {
        this.generatePropertyField(this.id);
        this.generatePropertyFields(doc.getProperties());
        this.generatePropertyFields(doc.getLinks());
        this.generatePropertyField(this.lastUpdate);
    }

    private void generatePropertyFields(List<MetaProperty> propertyList) {
        for (int i = 0; i < propertyList.size(); ++i) {
            MetaProperty p = propertyList.get(i);
            if (p instanceof MetaTableProperty) {
                List<MetaProperty> columns = ((MetaTableProperty)p).getColumns();
                for (int t = 0; t < columns.size(); ++t) {
                    this.generatePropertyField(columns.get(t));
                }
                continue;
            }
            this.generatePropertyField(p);
        }
    }

    private void generatePropertyField(MetaProperty p) {
        if (GeneratorDataRegistry.getInstance().getContext().areLanguagesSupported() && p.isMultilingual()) {
            System.err.println("Multilingual support for federated VOs not yet implemented!");
            return;
        }
        this.appendStatement("private " + p.toJavaType() + " " + p.getName().toLowerCase());
    }

    private void generatePropertyAccessMethods(MetaDocument doc) {
        this.generatePropertyGetterMethod(this.id);
        ArrayList<MetaProperty> lastUpdList = new ArrayList<MetaProperty>();
        lastUpdList.add(this.lastUpdate);
        this.generatePropertyAccessMethods(lastUpdList);
        this.generatePropertyAccessMethods(doc.getProperties());
        this.generatePropertyAccessMethods(doc.getLinks());
    }

    private void generatePropertyAccessMethods(List<MetaProperty> properties) {
        for (int i = 0; i < properties.size(); ++i) {
            MetaProperty p = properties.get(i);
            this.generatePropertyGetterMethod(p);
            FederationVOGenerator.emptyline();
            this.generatePropertySetterMethod(p);
            FederationVOGenerator.emptyline();
        }
    }

    private void generatePropertyGetterMethod(MetaProperty p) {
        if (p instanceof MetaTableProperty) {
            this.generateTablePropertyGetterMethods((MetaTableProperty)p);
            return;
        }
        if (p instanceof MetaListProperty) {
            this.generateListPropertyGetterMethods((MetaListProperty)p);
            return;
        }
        if (GeneratorDataRegistry.getInstance().getContext().areLanguagesSupported() && p.isMultilingual()) {
            this.generatePropertyGetterMethodMultilingual(p);
            return;
        }
        this.appendString("public " + p.toJavaType() + " get" + p.getAccesserName() + "(){");
        this.increaseIdent();
        this.appendStatement("return " + p.getName().toLowerCase());
        this.closeBlockNEW();
    }

    private void generatePropertyGetterMethodMultilingual(MetaProperty p) {
        for (String l : GeneratorDataRegistry.getInstance().getContext().getLanguages()) {
            this.appendString("public " + p.toJavaType() + " get" + p.getAccesserName(l) + "(){");
            this.increaseIdent();
            this.appendStatement("return " + p.toPropertyGetter() + "(" + p.toNameConstant(l) + ")");
            this.closeBlockNEW();
            FederationVOGenerator.emptyline();
        }
        this.appendString("public " + p.toJavaType() + " get" + p.getAccesserName() + "(){");
        this.increaseIdent();
        String v = "ContextManager.getCallContext().getCurrentLanguage()";
        this.appendStatement("return " + p.toPropertyGetter() + "(" + this.quote(p.getName() + "_") + "+" + v + ")");
        this.closeBlockNEW();
        FederationVOGenerator.emptyline();
    }

    private void generateListPropertyGetterMethods(MetaListProperty p) {
        MetaProperty tmp = new MetaProperty(p.getName(), MetaProperty.Type.LIST);
        this.generatePropertyGetterMethod(tmp);
    }

    private void generateTablePropertyGetterMethods(MetaTableProperty p) {
        List<MetaProperty> columns = p.getColumns();
        for (int t = 0; t < columns.size(); ++t) {
            this.generatePropertyGetterMethod(columns.get(t));
        }
    }

    private void generatePropertySetterMethod(MetaProperty p) {
        if (p instanceof MetaTableProperty) {
            this.generateTablePropertySetterMethods((MetaTableProperty)p);
            return;
        }
        if (p instanceof MetaListProperty) {
            this.generateListPropertySetterMethods((MetaListProperty)p);
            return;
        }
        if (GeneratorDataRegistry.getInstance().getContext().areLanguagesSupported() && p.isMultilingual()) {
            this.generatePropertySetterMethodMultilingual(p);
            return;
        }
        this.appendString("public void set" + p.getAccesserName() + "(" + p.toJavaType() + " value){");
        this.increaseIdent();
        this.appendStatement(p.getName().toLowerCase() + " = value");
        this.closeBlockNEW();
    }

    private String generatePropertySetterMethodMultilingual(MetaProperty p) {
        String ret = "";
        for (String l : GeneratorDataRegistry.getInstance().getContext().getLanguages()) {
            this.appendString("public void set" + p.getAccesserName(l) + "(" + p.toJavaType() + " value){");
            this.increaseIdent();
            this.appendStatement(p.toPropertySetter() + "(" + p.toNameConstant(l) + ", value)");
            this.closeBlockNEW();
            FederationVOGenerator.emptyline();
        }
        this.appendString("public void set" + p.getAccesserName() + "(" + p.toJavaType() + " value){");
        this.increaseIdent();
        String v = "ContextManager.getCallContext().getCurrentLanguage()";
        this.appendStatement(p.toPropertySetter() + "((" + this.quote(p.getName() + "_") + "+" + v + "), value)");
        this.closeBlockNEW();
        FederationVOGenerator.emptyline();
        return ret;
    }

    private void generateListPropertySetterMethods(MetaListProperty p) {
        MetaProperty tmp = new MetaProperty(p.getName(), MetaProperty.Type.LIST);
        this.generatePropertySetterMethod(tmp);
    }

    private void generateTablePropertySetterMethods(MetaTableProperty p) {
        List<MetaProperty> columns = p.getColumns();
        for (int t = 0; t < columns.size(); ++t) {
            this.generatePropertySetterMethod(columns.get(t));
        }
    }

    private void generateToStringMethod(MetaDocument doc) {
        this.appendString("public String toString(){");
        this.increaseIdent();
        this.appendStatement("String ret = " + this.quote(doc.getName() + " "));
        this.appendStatement("ret += \"[\"+getId()+\"] \"");
        List<MetaProperty> props = doc.getProperties();
        for (int i = 0; i < props.size(); ++i) {
            MetaProperty p = props.get(i);
            if (p instanceof MetaTableProperty) {
                List<MetaProperty> columns = ((MetaTableProperty)p).getColumns();
                for (int t = 0; t < columns.size(); ++t) {
                    MetaProperty pp = columns.get(t);
                    this.appendStatement("ret += " + this.quote(pp.getName() + ": ") + "+get" + pp.getAccesserName() + "()");
                    if (t >= columns.size() - 1) continue;
                    this.appendStatement("ret += \", \"");
                }
            } else {
                this.appendStatement("ret += " + this.quote(p.getName() + ": ") + "+get" + p.getAccesserName() + "()");
            }
            if (i >= props.size() - 1) continue;
            this.appendStatement("ret += \", \"");
        }
        this.appendStatement("return ret");
        this.closeBlockNEW();
    }

    private void generateCloneMethod(MetaDocument doc) {
        this.appendString("public " + doc.getName() + " clone(){");
        this.increaseIdent();
        this.appendStatement("return new " + FederationVOGenerator.getDocumentImplName(doc) + "(this)");
        this.closeBlockNEW();
    }

    private void generateCopyMethod(MetaDocument doc) {
        this.appendString("public void copyAttributesFrom(" + doc.getName() + " toCopy){");
        this.increaseIdent();
        for (MetaProperty p : doc.getProperties()) {
            this.appendStatement("this." + p.getName().toLowerCase() + " = toCopy." + p.toGetter() + "()");
        }
        this.closeBlockNEW();
    }

    private void generateGetPropertyValueMethod(MetaDocument doc) {
        this.appendString("public Object getPropertyValue(String propertyName){");
        this.increaseIdent();
        this.appendStatement("throw new RuntimeException(" + this.quote("Not yet implemented.") + ")");
        this.closeBlockNEW();
    }

    public static final String getDocumentImport(Context context, MetaDocument doc) {
        return context.getDataPackageName(doc) + "." + FederationVOGenerator.getDocumentImplName(doc);
    }

    private void generateAdditionalMethods(MetaDocument doc) {
        List<MetaProperty> properties = doc.getProperties();
        for (MetaProperty p : properties) {
            if (p instanceof MetaContainerProperty) {
                this.generateContainerMethods((MetaContainerProperty)p);
            }
            if (p instanceof MetaTableProperty) {
                this.generateTableMethods((MetaTableProperty)p);
            }
            if (!(p instanceof MetaListProperty)) continue;
            this.generateListMethods((MetaListProperty)p);
        }
        this.appendString("public XMLNode toXMLNode(){");
        this.increaseIdent();
        this.appendStatement("return new XMLNode(" + this.quote("not_imlpemented_fed_vo") + ")");
        this.closeBlockNEW();
    }

    private void generateContainerMethods(MetaContainerProperty container) {
        this.appendString("public int " + FederationVOGenerator.getContainerSizeGetterName(container) + "(){");
        this.increaseIdent();
        MetaContainerProperty pr = container instanceof MetaTableProperty ? ((MetaTableProperty)container).getColumns().get(0) : container;
        this.appendStatement("return getList(" + pr.toNameConstant() + ").size()");
        this.closeBlockNEW();
        FederationVOGenerator.emptyline();
    }

    private void generateListMethods(MetaListProperty list) {
        MetaProperty c = list.getContainedProperty();
        String decl = "public void " + FederationVOGenerator.getContainerEntryAdderName(list) + "(";
        decl = decl + c.toJavaType() + " " + c.getName();
        decl = decl + "){";
        this.appendString(decl);
        this.increaseIdent();
        this.appendStatement(c.toJavaType() + "Property p = new " + c.toJavaType() + "Property(" + c.getName() + ", " + c.getName() + ")");
        this.appendStatement("List tmp = get" + list.getAccesserName() + "()");
        this.appendStatement("tmp.add(p)");
        this.appendStatement("set" + list.getAccesserName() + "(tmp)");
        this.closeBlockNEW();
        FederationVOGenerator.emptyline();
        this.appendString("public void " + FederationVOGenerator.getContainerEntryDeleterName(list) + "(int index){");
        this.increaseIdent();
        this.appendStatement("getListProperty(" + list.toNameConstant() + ").remove(index)");
        this.closeBlockNEW();
        FederationVOGenerator.emptyline();
        this.appendString("public void " + FederationVOGenerator.getContainerEntrySwapperName(list) + "(int index1, int index2){");
        this.increaseIdent();
        this.appendStatement(c.toJavaType() + " tmp1, tmp2");
        this.appendStatement("tmp1 = ((" + c.toJavaType() + "Property)getList(" + list.toNameConstant() + ").get(index1)).get" + c.toJavaType() + "()");
        this.appendStatement("tmp2 = ((" + c.toJavaType() + "Property)getList(" + list.toNameConstant() + ").get(index2)).get" + c.toJavaType() + "()");
        this.appendStatement("((" + c.toJavaType() + "Property)getList(" + list.toNameConstant() + ").get(index1)).set" + c.toJavaType() + "(tmp2)");
        this.appendStatement("((" + c.toJavaType() + "Property)getList(" + list.toNameConstant() + ").get(index2)).set" + c.toJavaType() + "(tmp1)");
        this.closeBlockNEW();
        FederationVOGenerator.emptyline();
        this.appendString("public " + c.toJavaType() + " " + FederationVOGenerator.getListElementGetterName(list) + "(int index){");
        this.increaseIdent();
        this.appendStatement(c.toJavaType() + "Property p = (" + c.toJavaType() + "Property)getList(" + list.toNameConstant() + ").get(index)");
        this.appendStatement("return p.get" + c.toJavaType() + "()");
        this.closeBlockNEW();
        FederationVOGenerator.emptyline();
    }

    private void generateTableMethods(MetaTableProperty table) {
        MetaProperty p;
        int i;
        List<MetaProperty> columns = table.getColumns();
        String decl = "public void " + FederationVOGenerator.getContainerEntryAdderName(table) + "(";
        for (i = 0; i < columns.size(); ++i) {
            p = columns.get(i);
            decl = decl + "String " + table.extractSubName(p);
            if (i >= columns.size() - 1) continue;
            decl = decl + ", ";
        }
        decl = decl + "){";
        this.appendString(decl);
        this.increaseIdent();
        this.appendStatement("List tmp");
        for (i = 0; i < columns.size(); ++i) {
            p = columns.get(i);
            this.appendStatement("tmp = getList(" + p.toNameConstant() + ")");
            this.appendStatement("tmp.add(new StringProperty(\"\", " + table.extractSubName(p) + "))");
            this.appendStatement("setList(" + p.toNameConstant() + ", tmp)");
            FederationVOGenerator.emptyline();
        }
        this.closeBlockNEW();
        FederationVOGenerator.emptyline();
        this.appendString("public void " + FederationVOGenerator.getContainerEntryDeleterName(table) + "(int index){");
        this.increaseIdent();
        for (i = 0; i < columns.size(); ++i) {
            p = columns.get(i);
            this.appendStatement("getListProperty(" + p.toNameConstant() + ").remove(index)");
        }
        this.closeBlockNEW();
        FederationVOGenerator.emptyline();
        this.appendString("public List get" + StringUtils.capitalize((String)table.getName()) + "Row(int index){");
        this.increaseIdent();
        this.appendStatement("List ret = new ArrayList(1)");
        for (i = 0; i < columns.size(); ++i) {
            p = columns.get(i);
            this.appendString("try{");
            this.appendIncreasedStatement("ret.add(((StringProperty)getList(" + p.toNameConstant() + ").get(index)).getString())");
            this.appendString("}catch(IndexOutOfBoundsException e){ ");
            this.appendIncreasedStatement("ret.add(\"\")");
            this.appendString("}");
        }
        this.appendStatement("return ret");
        this.closeBlockNEW();
        FederationVOGenerator.emptyline();
        this.appendString("public List " + FederationVOGenerator.getTableGetterName(table) + "(){");
        this.increaseIdent();
        this.appendStatement("int size = " + FederationVOGenerator.getContainerSizeGetterName(table) + "();");
        this.appendStatement("List ret = new java.util.ArrayList(size)");
        this.appendString("for (int i=0; i<size; i++)");
        this.appendIncreasedStatement("ret.add(get" + StringUtils.capitalize((String)table.getName()) + "Row(i))");
        this.appendStatement("return ret");
        this.closeBlockNEW();
        FederationVOGenerator.emptyline();
    }

    public static String getContainerSizeGetterName(MetaContainerProperty p) {
        return "get" + StringUtils.capitalize((String)p.getName()) + "Size";
    }

    public static String getTableGetterName(MetaTableProperty p) {
        return "get" + StringUtils.capitalize((String)p.getName()) + "Table";
    }

    public static String getContainerEntryAdderName(MetaContainerProperty p) {
        return "add" + StringUtils.capitalize((String)p.getName()) + p.getContainerEntryName();
    }

    public static String getContainerEntryDeleterName(MetaContainerProperty p) {
        return "remove" + StringUtils.capitalize((String)p.getName()) + p.getContainerEntryName();
    }

    public static String getContainerEntrySwapperName(MetaContainerProperty p) {
        return "swap" + StringUtils.capitalize((String)p.getName()) + p.getContainerEntryName();
    }

    public static String getListElementGetterName(MetaListProperty list) {
        return "get" + StringUtils.capitalize((String)list.getName()) + list.getContainerEntryName();
    }
}

