/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.model.fixture;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.anotheria.asg.generator.CommentGenerator;
import net.anotheria.asg.generator.Context;
import net.anotheria.asg.generator.FileEntry;
import net.anotheria.asg.generator.GeneratedClass;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.IGenerateable;
import net.anotheria.asg.generator.IGenerator;
import net.anotheria.asg.generator.meta.MetaDocument;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.asg.generator.meta.StorageType;
import net.anotheria.asg.generator.model.AbstractServiceGenerator;
import net.anotheria.asg.generator.model.DataFacadeGenerator;
import net.anotheria.asg.generator.model.ServiceGenerator;
import net.anotheria.asg.generator.model.db.VOGenerator;
import net.anotheria.asg.generator.model.docs.DocumentGenerator;
import net.anotheria.asg.service.BaseFixtureService;
import net.anotheria.asg.service.IFixtureService;
import net.anotheria.util.ExecutionTimer;
import net.anotheria.util.StringUtils;

public class FixtureServiceGenerator
extends AbstractServiceGenerator
implements IGenerator {
    @Override
    public List<FileEntry> generate(IGenerateable gmodule) {
        MetaModule mod = (MetaModule)gmodule;
        if (!mod.isEnabledByOptions("fixture")) {
            return new ArrayList<FileEntry>();
        }
        ArrayList<FileEntry> ret = new ArrayList<FileEntry>();
        ExecutionTimer timer = new ExecutionTimer("Fixture Generator");
        timer.startExecution(mod.getName() + "Factory");
        ret.add(new FileEntry(this.generateFactory(mod)));
        timer.stopExecution(mod.getName() + "Factory");
        timer.startExecution(mod.getName() + "Impl");
        ret.add(new FileEntry(this.generateImplementation(mod)));
        timer.stopExecution(mod.getName() + "Impl");
        return ret;
    }

    public static String getFixtureFactoryName(MetaModule m) {
        return FixtureServiceGenerator.getServiceName(m) + "FixtureFactory";
    }

    @Override
    public String getFactoryName(MetaModule m) {
        return FixtureServiceGenerator.getFixtureFactoryName(m);
    }

    private GeneratedClass generateImplementation(MetaModule module) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        Context context = GeneratorDataRegistry.getInstance().getContext();
        clazz.setTypeComment(CommentGenerator.generateJavaTypeComment(this.getImplementationName(module), "The implementation of the " + FixtureServiceGenerator.getInterfaceName(module) + " for unit testing."));
        clazz.setPackageName(this.getPackageName(module));
        clazz.addImport("java.util.List");
        clazz.addImport("java.util.Set");
        clazz.addImport("net.anotheria.util.sorter.SortType");
        clazz.addImport("net.anotheria.util.sorter.StaticQuickSorter");
        clazz.addImport("net.anotheria.util.slicer.Segment");
        clazz.addImport("net.anotheria.util.slicer.Slicer");
        clazz.addImport("net.anotheria.anodoc.query2.DocumentQuery");
        clazz.addImport("net.anotheria.anodoc.query2.QueryResult");
        clazz.addImport("net.anotheria.anodoc.query2.QueryResultEntry");
        clazz.addImport("net.anotheria.anodoc.query2.QueryProperty");
        clazz.addImport("net.anotheria.util.xml.XMLNode");
        clazz.addImport("net.anotheria.util.xml.XMLAttribute");
        clazz.addImport("org.codehaus.jettison.json.JSONArray");
        clazz.addImport("org.codehaus.jettison.json.JSONObject");
        clazz.addImport("net.anotheria.anosite.gen.shared.util.DocumentName");
        clazz.addImport(ServiceGenerator.getInterfaceImport(module));
        clazz.addImport(ServiceGenerator.getExceptionImport(module));
        clazz.setName(this.getImplementationName(module));
        clazz.setParent(BaseFixtureService.class);
        clazz.addInterface(FixtureServiceGenerator.getInterfaceName(module));
        clazz.addInterface(IFixtureService.class);
        this.startClassBody();
        this.appendStatement("private static " + this.getImplementationName(module) + " instance");
        FixtureServiceGenerator.emptyline();
        List<MetaDocument> docs = module.getDocuments();
        clazz.addImport(ConcurrentHashMap.class);
        clazz.addImport(Map.class);
        clazz.addImport(AtomicInteger.class);
        clazz.addImport(ArrayList.class);
        for (MetaDocument doc : docs) {
            this.appendStatement("private Map<String, " + doc.getName() + "> " + this.getMapName(doc));
            this.appendStatement("private AtomicInteger " + this.getIdHolderName(doc));
            FixtureServiceGenerator.emptyline();
        }
        this.appendString("private " + this.getImplementationName(module) + "(){");
        this.increaseIdent();
        this.appendStatement("reset()");
        if (module.getListeners().size() > 0) {
            for (int i = 0; i < module.getListeners().size(); ++i) {
                String listClassName = module.getListeners().get(i);
                this.appendStatement("addServiceListener(new " + listClassName + "())");
            }
        }
        this.closeBlockNEW();
        FixtureServiceGenerator.emptyline();
        this.appendString("static final " + this.getImplementationName(module) + " getInstance(){");
        this.increaseIdent();
        this.appendString("if (instance==null){");
        this.increaseIdent();
        this.appendStatement("instance = new " + this.getImplementationName(module) + "()");
        this.closeBlockNEW();
        this.appendStatement("return instance");
        this.closeBlockNEW();
        FixtureServiceGenerator.emptyline();
        this.appendString("@Override public void reset(){");
        this.increaseIdent();
        for (MetaDocument doc : docs) {
            this.appendStatement(this.getMapName(doc) + " = new ConcurrentHashMap<String, " + doc.getName() + ">()");
            this.appendStatement(this.getIdHolderName(doc) + " = new AtomicInteger(0)");
            FixtureServiceGenerator.emptyline();
        }
        this.closeBlockNEW();
        FixtureServiceGenerator.emptyline();
        String throwsClause = " throws " + this.getExceptionName(module) + " ";
        for (int i = 0; i < docs.size(); ++i) {
            MetaDocument doc = docs.get(i);
            String listDecl = "List<" + doc.getName() + ">";
            clazz.addImport(DataFacadeGenerator.getDocumentImport(doc));
            clazz.addImport(DataFacadeGenerator.getXMLHelperImport(context, doc));
            this.appendString("@Override public " + listDecl + " get" + doc.getMultiple() + "()" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement(listDecl + " ret = new Array" + listDecl + "()");
            this.appendStatement("ret.addAll(" + this.getMapName(doc) + ".values())");
            this.appendStatement("return ret");
            this.closeBlockNEW();
            FixtureServiceGenerator.emptyline();
            this.appendString("@Override public " + listDecl + " get" + doc.getMultiple() + "(SortType sortType)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("return StaticQuickSorter.sort(get" + doc.getMultiple() + "(), sortType)");
            this.closeBlockNEW();
            FixtureServiceGenerator.emptyline();
            this.appendString("@Override public void delete" + doc.getName() + "(" + doc.getName() + " " + doc.getVariableName() + ")" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("delete" + doc.getName() + "(" + doc.getVariableName() + ".getId())");
            this.closeBlockNEW();
            FixtureServiceGenerator.emptyline();
            this.appendString("@Override public void delete" + doc.getName() + "(String id)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement(doc.getName() + " old = " + this.getMapName(doc) + ".remove(id)");
            this.appendString("if (old!=null){");
            this.increaseIdent();
            this.appendStatement("fireObjectDeletedEvent(old)");
            this.closeBlockNEW();
            this.closeBlockNEW();
            FixtureServiceGenerator.emptyline();
            this.appendComment("Deletes multiple " + doc.getName() + " objects.");
            this.appendString("@Override public void delete" + doc.getMultiple() + "(" + listDecl + " list)" + throwsClause + "{");
            this.increaseIdent();
            this.appendString("for (" + doc.getName() + " " + doc.getVariableName() + " : list){");
            this.increaseIdent();
            this.appendStatement("delete" + doc.getName() + "(" + doc.getVariableName() + ")");
            this.closeBlockNEW();
            this.closeBlockNEW();
            FixtureServiceGenerator.emptyline();
            this.appendString("@Override public " + doc.getName() + " get" + doc.getName() + "(String id)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement(doc.getName() + " " + doc.getVariableName() + " = " + this.getMapName(doc) + ".get(id)");
            this.appendString("if (" + doc.getVariableName() + "==null)");
            this.appendIncreasedStatement("throw new " + this.getExceptionName(module) + "(\"No " + doc.getName() + " with id \"+id+\" found\")");
            this.appendStatement("return " + doc.getVariableName());
            this.closeBlockNEW();
            FixtureServiceGenerator.emptyline();
            this.appendString("@Override public " + doc.getName() + " import" + doc.getName() + "(" + doc.getName() + " " + doc.getVariableName() + ")" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement(this.getMapName(doc) + ".put(" + doc.getVariableName() + ".getId(), " + doc.getVariableName() + ")");
            this.appendStatement("return " + doc.getVariableName());
            this.closeBlockNEW();
            FixtureServiceGenerator.emptyline();
            this.appendString("@Override public " + listDecl + " import" + doc.getMultiple() + "(" + listDecl + " list)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement(listDecl + " ret = new Array" + listDecl + "()");
            this.appendString("for (" + doc.getName() + " " + doc.getVariableName() + " : list)");
            this.appendIncreasedStatement("ret.add(import" + doc.getName() + "(" + doc.getVariableName() + "))");
            this.appendStatement("return ret");
            this.closeBlockNEW();
            FixtureServiceGenerator.emptyline();
            this.appendString("@Override public " + doc.getName() + " create" + doc.getName() + "(" + doc.getName() + " " + doc.getVariableName() + ")" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("String nextId = \"\"+" + this.getIdHolderName(doc) + ".incrementAndGet()");
            if (module.getStorageType() == StorageType.DB) {
                this.appendCommentLine("//DB Specific code");
                clazz.addImport(VOGenerator.getDocumentImport(GeneratorDataRegistry.getInstance().getContext(), doc));
                this.appendStatement(VOGenerator.getDocumentImplName(doc) + " new" + StringUtils.capitalize((String)doc.getVariableName()) + " = new " + VOGenerator.getDocumentImplName(doc) + "(nextId)");
                this.appendStatement("new" + StringUtils.capitalize((String)doc.getVariableName()) + ".copyAttributesFrom(" + doc.getVariableName() + ")");
            }
            if (module.getStorageType() == StorageType.CMS) {
                this.appendCommentLine("//CMS Specific code");
                clazz.addImport(DocumentGenerator.getDocumentImport(GeneratorDataRegistry.getInstance().getContext(), doc));
                this.appendStatement(DocumentGenerator.getDocumentImplName(doc) + " new" + StringUtils.capitalize((String)doc.getVariableName()) + " = (" + DocumentGenerator.getDocumentImplName(doc) + ")" + doc.getVariableName());
                this.appendStatement("new" + StringUtils.capitalize((String)doc.getVariableName()) + ".renameTo(nextId)");
            }
            this.appendStatement(this.getMapName(doc) + ".put(new" + StringUtils.capitalize((String)doc.getVariableName()) + ".getId(), new" + StringUtils.capitalize((String)doc.getVariableName()) + ")");
            this.appendStatement("fireObjectCreatedEvent(new" + StringUtils.capitalize((String)doc.getVariableName()) + ")");
            this.appendStatement("return new" + StringUtils.capitalize((String)doc.getVariableName()));
            this.closeBlockNEW();
            FixtureServiceGenerator.emptyline();
            this.appendComment("Creates multiple new " + doc.getName() + " objects.\nReturns the created versions.");
            this.appendString("@Override public " + listDecl + " create" + doc.getMultiple() + "(" + listDecl + " list)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement(listDecl + " ret = new Array" + listDecl + "()");
            this.appendString(this.getIterator(doc));
            this.appendIncreasedStatement("ret.add(create" + doc.getName() + "(" + doc.getVariableName() + "))");
            this.appendStatement("return ret");
            this.closeBlockNEW();
            FixtureServiceGenerator.emptyline();
            this.appendComment("Updates multiple new " + doc.getName() + " objects.\nReturns the updated versions.");
            this.appendString("@Override public " + listDecl + " update" + doc.getMultiple() + "(" + listDecl + " list)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement(listDecl + " ret = new Array" + listDecl + "()");
            this.appendString(this.getIterator(doc));
            this.appendIncreasedStatement("ret.add(update" + doc.getName() + "(" + doc.getVariableName() + "))");
            this.appendStatement("return ret");
            this.closeBlockNEW();
            FixtureServiceGenerator.emptyline();
            this.appendString("@Override public " + doc.getName() + " update" + doc.getName() + "(" + doc.getName() + " " + doc.getVariableName() + ")" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement(doc.getName() + " oldVersion = " + this.getMapName(doc) + ".put(" + doc.getVariableName() + ".getId(), " + doc.getVariableName() + ")");
            this.appendString("if (oldVersion!=null){");
            this.increaseIdent();
            this.appendIncreasedStatement("fireObjectUpdatedEvent(oldVersion, " + doc.getVariableName() + ")");
            this.closeBlockNEW();
            this.appendStatement("return " + doc.getVariableName());
            this.closeBlockNEW();
            FixtureServiceGenerator.emptyline();
            this.appendString("@Override public " + listDecl + " get" + doc.getMultiple() + "ByProperty(String propertyName, Object value)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement(listDecl + " list = get" + doc.getMultiple() + "()");
            this.appendStatement(listDecl + " ret = new Array" + listDecl + "()");
            this.appendString(this.getIterator(doc) + "{");
            this.increaseIdent();
            this.appendStatement("Object propertyValue = " + doc.getVariableName() + ".getPropertyValue(propertyName)");
            this.appendString("if (propertyValue!=null && propertyValue.equals(value))");
            this.appendIncreasedStatement("ret.add(" + doc.getVariableName() + ")");
            this.closeBlockNEW();
            this.appendStatement("return ret");
            this.closeBlockNEW();
            FixtureServiceGenerator.emptyline();
            this.appendString("@Override public " + listDecl + " get" + doc.getMultiple() + "ByProperty(String propertyName, Object value, SortType sortType)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("return StaticQuickSorter.sort(get" + doc.getMultiple() + "ByProperty(propertyName, value), sortType)");
            this.closeBlockNEW();
            this.appendComment("Executes a query on " + doc.getMultiple());
            this.appendString("@Override public QueryResult executeQueryOn" + doc.getMultiple() + "(DocumentQuery query)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement(listDecl + " all" + doc.getMultiple() + " = get" + doc.getMultiple() + "()");
            this.appendStatement("QueryResult result = new QueryResult()");
            this.appendString("for (int i=0; i<all" + doc.getMultiple() + ".size(); i++){");
            this.increaseIdent();
            this.appendStatement("List<QueryResultEntry> partialResult = query.match(all" + doc.getMultiple() + ".get(i))");
            this.appendStatement("result.add(partialResult)");
            this.closeBlockNEW();
            this.appendStatement("return result");
            this.closeBlockNEW();
            FixtureServiceGenerator.emptyline();
            this.appendComment("Returns all " + doc.getName() + " objects, where property matches.");
            this.appendString("@Override public " + listDecl + " get" + doc.getMultiple() + "ByProperty(QueryProperty... properties)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement(listDecl + " list = get" + doc.getMultiple() + "()");
            this.appendString("if (properties==null || properties.length==0)");
            this.appendIncreasedStatement("return list");
            this.appendStatement(listDecl + " ret = new Array" + listDecl + "()");
            this.appendString(this.getIterator(doc) + "{");
            this.increaseIdent();
            this.appendStatement("boolean mayPass = true");
            this.appendString("for (QueryProperty p : properties){");
            this.increaseIdent();
            this.appendStatement("Object propertyValue = " + doc.getVariableName() + ".getPropertyValue(p.getName())");
            this.appendString("if (mayPass && (propertyValue==null || (!(p.doesMatch(propertyValue)))))");
            this.appendIncreasedStatement("mayPass = false");
            this.closeBlockNEW();
            this.appendString("if (mayPass)");
            this.appendIncreasedStatement("ret.add(" + doc.getVariableName() + ")");
            this.closeBlockNEW();
            this.appendStatement("return ret");
            this.closeBlockNEW();
            FixtureServiceGenerator.emptyline();
            this.appendComment("Returns all " + doc.getName() + " objects, where property matches, sorted");
            this.appendString("@Override public " + listDecl + " get" + doc.getMultiple() + "ByProperty(SortType sortType, QueryProperty... property)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("return StaticQuickSorter.sort(get" + doc.getMultiple() + "ByProperty(property), sortType)");
            this.closeBlockNEW();
            FixtureServiceGenerator.emptyline();
            this.appendComment("Returns " + doc.getName() + " objects count.");
            this.appendString("@Override public int get" + doc.getMultiple() + "Count()" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("return " + this.getMapName(doc) + ".values().size()");
            this.closeBlockNEW();
            FixtureServiceGenerator.emptyline();
            this.appendComment("Returns " + doc.getName() + " objects segment.");
            this.appendString("public " + listDecl + " get" + doc.getMultiple() + "(Segment aSegment)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("return Slicer.slice(aSegment, get" + doc.getMultiple() + "()).getSliceData()");
            this.closeBlockNEW();
            FixtureServiceGenerator.emptyline();
            this.appendComment("Returns " + doc.getName() + " objects segment, where property matched.");
            this.appendString("public " + listDecl + " get" + doc.getMultiple() + "ByProperty(Segment aSegment, QueryProperty... property) {");
            this.increaseIdent();
            this.appendStatement("int pLimit = aSegment.getElementsPerSlice()");
            this.appendStatement("int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice()");
            this.appendStatement(listDecl + " ret = new ArrayList<>()");
            this.appendStatement(listDecl + " src = new ArrayList<>()");
            this.appendStatement("src.addAll(" + this.getMapName(doc) + ".values())");
            this.appendStatement("for (" + doc.getName() + " " + doc.getVariableName() + " : src) {");
            this.increaseIdent();
            this.appendStatement("boolean mayPass = true");
            this.appendStatement("for (QueryProperty qp : property) {");
            this.increaseIdent();
            this.appendStatement("mayPass = mayPass && qp.doesMatch(" + doc.getVariableName() + ".getPropertyValue(qp.getName()))");
            this.closeBlockNEW();
            this.appendString("if (mayPass)");
            this.appendIncreasedStatement("ret.add(" + doc.getVariableName() + ")");
            this.appendString("if (ret.size() > pOffset + pLimit)");
            this.appendIncreasedStatement("break");
            this.closeBlockNEW();
            this.appendStatement("return Slicer.slice(aSegment, ret).getSliceData()");
            this.closeBlockNEW();
            FixtureServiceGenerator.emptyline();
            this.appendComment("Returns " + doc.getName() + " objects segment, where property matched, sorted.");
            this.appendString("public " + listDecl + " get" + doc.getMultiple() + "ByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){");
            this.increaseIdent();
            this.appendStatement("return StaticQuickSorter.sort(get" + doc.getMultiple() + "ByProperty(aSegment, aProperty), aSortType)");
            this.closeBlockNEW();
            FixtureServiceGenerator.emptyline();
        }
        boolean containsAnyMultilingualDocs = false;
        FixtureServiceGenerator.emptyline();
        for (MetaDocument d : docs) {
            this.appendString("public XMLNode export" + d.getMultiple() + "ToXML(){");
            this.increaseIdent();
            this.appendStatement("XMLNode ret = new XMLNode(" + this.quote(d.getMultiple()) + ")");
            this.appendString("try{");
            this.increaseIdent();
            this.appendStatement("List<" + d.getName() + "> list = get" + d.getMultiple() + "()");
            this.appendStatement("ret.addAttribute(new XMLAttribute(" + this.quote("count") + ", list.size()))");
            this.appendString("for (" + d.getName() + " object : list)");
            this.appendIncreasedStatement("ret.addChildNode(" + DataFacadeGenerator.getXMLHelperName(d) + ".toXML(object))");
            this.appendStatement("return ret");
            this.closeBlockNEW();
            this.appendString("catch(" + this.getExceptionName(module) + " e){");
            this.increaseIdent();
            this.appendStatement("throw new RuntimeException(" + this.quote("export" + d.getMultiple() + "ToXML() failure: ") + " , e)");
            this.closeBlockNEW();
            this.closeBlockNEW();
            FixtureServiceGenerator.emptyline();
            this.appendString("public XMLNode export" + d.getMultiple() + "ToXML(List<" + d.getName() + "> list){");
            this.increaseIdent();
            this.appendStatement("XMLNode ret = new XMLNode(" + this.quote(d.getMultiple()) + ")");
            this.appendStatement("ret.addAttribute(new XMLAttribute(" + this.quote("count") + ", list.size()))");
            this.appendString("for (" + d.getName() + " object : list)");
            this.appendIncreasedStatement("ret.addChildNode(" + DataFacadeGenerator.getXMLHelperName(d) + ".toXML(object))");
            this.appendStatement("return ret");
            this.closeBlockNEW();
            FixtureServiceGenerator.emptyline();
            this.appendString("public XMLNode export" + d.getMultiple() + "ToXML(String languages[]){");
            this.increaseIdent();
            this.appendStatement("XMLNode ret = new XMLNode(" + this.quote(d.getMultiple()) + ")");
            this.appendString("try{");
            this.increaseIdent();
            this.appendStatement("List<" + d.getName() + "> list = get" + d.getMultiple() + "()");
            this.appendStatement("ret.addAttribute(new XMLAttribute(" + this.quote("count") + ", list.size()))");
            this.appendString("for (" + d.getName() + " object : list)");
            this.appendIncreasedStatement("ret.addChildNode(" + DataFacadeGenerator.getXMLHelperName(d) + ".toXML(object, languages))");
            this.appendStatement("return ret");
            this.closeBlockNEW();
            this.appendString("catch(" + this.getExceptionName(module) + " e){");
            this.increaseIdent();
            this.appendStatement("throw new RuntimeException(" + this.quote("export" + d.getMultiple() + "ToXML() failure: ") + " , e)");
            this.closeBlockNEW();
            this.closeBlockNEW();
            FixtureServiceGenerator.emptyline();
            this.appendString("public XMLNode export" + d.getMultiple() + "ToXML(String languages[], List<" + d.getName() + "> list){");
            this.increaseIdent();
            this.appendStatement("XMLNode ret = new XMLNode(" + this.quote(d.getMultiple()) + ")");
            this.appendStatement("ret.addAttribute(new XMLAttribute(" + this.quote("count") + ", list.size()))");
            this.appendString("for (" + d.getName() + " object : list)");
            this.appendIncreasedStatement("ret.addChildNode(" + DataFacadeGenerator.getXMLHelperName(d) + ".toXML(object, languages))");
            this.appendStatement("return ret");
            this.closeBlockNEW();
            FixtureServiceGenerator.emptyline();
            this.appendString("public void fetch" + d.getName() + " (final String id, Set<String> addedDocuments, JSONArray data)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("throw new UnsupportedOperationException(\" not implemented and should not BE!\")");
            this.closeBlockNEW();
            FixtureServiceGenerator.emptyline();
            if (!GeneratorDataRegistry.hasLanguageCopyMethods(d)) continue;
            containsAnyMultilingualDocs = true;
            this.appendCommentLine("This method is not very fast, since it makes an update (eff. save) after each doc.");
            this.appendString("public void copyMultilingualAttributesInAll" + d.getMultiple() + "(String sourceLanguage, String targetLanguage){");
            this.increaseIdent();
            this.appendStatement("throw new AssertionError(\"Not implemented\")");
            this.closeBlockNEW();
            FixtureServiceGenerator.emptyline();
        }
        this.appendString("public void executeParsingForDocument (final DocumentName documentName, final JSONObject data)" + throwsClause + "{");
        this.increaseIdent();
        this.appendStatement("throw new UnsupportedOperationException(\" not implemented and should not BE!\")");
        this.closeBlockNEW();
        FixtureServiceGenerator.emptyline();
        if (containsAnyMultilingualDocs) {
            this.appendComment("Copies all multilingual fields from sourceLanguage to targetLanguage in all data objects (documents, vo) which are part of this module and managed by this service");
            this.appendString("public void copyMultilingualAttributesInAllObjects(String sourceLanguage, String targetLanguage){");
            this.increaseIdent();
            for (MetaDocument doc : docs) {
                if (!GeneratorDataRegistry.hasLanguageCopyMethods(doc)) continue;
                this.appendStatement("copyMultilingualAttributesInAll" + doc.getMultiple() + "(sourceLanguage, targetLanguage)");
            }
            this.closeBlockNEW();
            FixtureServiceGenerator.emptyline();
        }
        this.appendComment("Executes a query on all data objects (documents, vo) which are part of this module and managed by this service");
        this.appendString("public QueryResult executeQueryOnAllObjects(DocumentQuery query)" + throwsClause + "{");
        this.increaseIdent();
        this.appendStatement("QueryResult ret = new QueryResult()");
        for (MetaDocument doc : docs) {
            this.appendStatement("ret.add(executeQueryOn" + doc.getMultiple() + "(query).getEntries())");
        }
        this.appendStatement("return ret");
        this.closeBlock("executeQueryOnAllObjects");
        FixtureServiceGenerator.emptyline();
        this.appendString("@Override public XMLNode exportToXML(){");
        this.increaseIdent();
        this.appendStatement("XMLNode ret = new XMLNode(" + this.quote(module.getName()) + ")");
        FixtureServiceGenerator.emptyline();
        for (MetaDocument d : docs) {
            this.appendStatement("ret.addChildNode(export" + d.getMultiple() + "ToXML())");
        }
        FixtureServiceGenerator.emptyline();
        this.appendStatement("return ret");
        this.closeBlockNEW();
        FixtureServiceGenerator.emptyline();
        if (containsAnyMultilingualDocs && GeneratorDataRegistry.getInstance().getContext().areLanguagesSupported()) {
            this.appendString("@Override public XMLNode exportToXML(String[] languages){");
            this.increaseIdent();
            this.appendStatement("XMLNode ret = new XMLNode(" + this.quote(module.getName()) + ")");
            FixtureServiceGenerator.emptyline();
            for (MetaDocument d : docs) {
                this.appendStatement("ret.addChildNode(export" + d.getMultiple() + "ToXML(languages))");
            }
            FixtureServiceGenerator.emptyline();
            this.appendStatement("return ret");
            this.closeBlockNEW();
        }
        return clazz;
    }

    private String getMapName(MetaDocument doc) {
        return doc.getName().toLowerCase() + "Map";
    }

    private String getIdHolderName(MetaDocument doc) {
        return doc.getName().toLowerCase() + "IdHolder";
    }

    @Override
    public String getImplementationName(MetaModule m) {
        return FixtureServiceGenerator.getServiceName(m) + "FixtureImpl";
    }

    private String getIterator(MetaDocument doc) {
        return "for (" + doc.getName() + " " + doc.getVariableName() + " : list)";
    }

    @Override
    protected String getPackageName(MetaModule module) {
        return GeneratorDataRegistry.getInstance().getContext().getPackageName(module) + ".service.fixture";
    }

    @Override
    protected void addAdditionalFactoryImports(GeneratedClass clazz, MetaModule module) {
        clazz.addImport(GeneratorDataRegistry.getInstance().getContext().getServicePackageName(module) + "." + FixtureServiceGenerator.getInterfaceName(module));
        clazz.addImport(IFixtureService.class);
    }

    @Override
    protected String getSupportedInterfacesList(MetaModule module) {
        return super.getSupportedInterfacesList(module) + ", IFixtureService.class";
    }

    @Override
    protected String getMoskitoSubsystem() {
        return super.getMoskitoSubsystem() + "-fixture";
    }
}

