/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.model.inmemory;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.asg.generator.CommentGenerator;
import net.anotheria.asg.generator.Context;
import net.anotheria.asg.generator.FileEntry;
import net.anotheria.asg.generator.GeneratedClass;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.IGenerateable;
import net.anotheria.asg.generator.IGenerator;
import net.anotheria.asg.generator.meta.MetaDocument;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.asg.generator.model.AbstractServiceGenerator;
import net.anotheria.asg.generator.model.DataFacadeGenerator;
import net.anotheria.asg.generator.model.ServiceGenerator;
import net.anotheria.asg.service.InMemoryService;
import net.anotheria.util.ExecutionTimer;

public class InMemoryServiceGenerator
extends AbstractServiceGenerator
implements IGenerator {
    @Override
    public List<FileEntry> generate(IGenerateable gmodule) {
        MetaModule mod = (MetaModule)gmodule;
        if (!mod.isEnabledByOptions("inmemory")) {
            return new ArrayList<FileEntry>();
        }
        ArrayList<FileEntry> ret = new ArrayList<FileEntry>();
        ExecutionTimer timer = new ExecutionTimer("InMemory Generator");
        timer.startExecution(mod.getName() + "Factory");
        ret.add(new FileEntry(this.generateFactory(mod)));
        timer.stopExecution(mod.getName() + "Factory");
        timer.startExecution(mod.getName() + "Impl");
        ret.add(new FileEntry(this.generateImplementation(mod)));
        timer.stopExecution(mod.getName() + "Impl");
        return ret;
    }

    @Override
    public String getImplementationName(MetaModule m) {
        return "InMemory" + InMemoryServiceGenerator.getServiceName(m) + "Impl";
    }

    public static String getInMemoryFactoryName(MetaModule m) {
        return "InMemory" + InMemoryServiceGenerator.getServiceName(m) + "Factory";
    }

    @Override
    public String getFactoryName(MetaModule m) {
        return InMemoryServiceGenerator.getInMemoryFactoryName(m);
    }

    public static String getInMemoryFactoryImport(MetaModule m) {
        return InMemoryServiceGenerator.getPackageName(GeneratorDataRegistry.getInstance().getContext(), m) + "." + InMemoryServiceGenerator.getInMemoryFactoryName(m);
    }

    @Override
    protected String getPackageName(MetaModule module) {
        return InMemoryServiceGenerator.getPackageName(GeneratorDataRegistry.getInstance().getContext(), module);
    }

    @Override
    protected void addAdditionalFactoryImports(GeneratedClass clazz, MetaModule module) {
        clazz.addImport(GeneratorDataRegistry.getInstance().getContext().getServicePackageName(module) + "." + InMemoryServiceGenerator.getInterfaceName(module));
        clazz.addImport(InMemoryService.class);
    }

    private String getCacheName(MetaDocument doc) {
        return "cache" + doc.getName();
    }

    private String getCachedListName(MetaDocument doc) {
        return "_cached" + doc.getName() + "List";
    }

    private String getWrapperDecl(MetaDocument doc) {
        return "InMemoryObjectWrapper<" + doc.getName() + ">";
    }

    private String getLastIdName(MetaDocument doc) {
        return "last" + doc.getName() + "Id";
    }

    private GeneratedClass generateImplementation(MetaModule module) {
        Context context = GeneratorDataRegistry.getInstance().getContext();
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        ExecutionTimer timer = new ExecutionTimer("InMemory-generateImplementation");
        timer.startExecution("pre");
        clazz.setTypeComment(CommentGenerator.generateJavaTypeComment(this.getImplementationName(module), "The in memory implementation of the " + InMemoryServiceGenerator.getInterfaceName(module) + "."));
        clazz.setPackageName(this.getPackageName(module));
        clazz.addImport("java.util.List");
        clazz.addImport("java.util.Map");
        clazz.addImport("java.util.ArrayList");
        clazz.addImport("java.util.HashMap");
        clazz.addImport("java.util.concurrent.atomic.AtomicLong");
        clazz.addImport("net.anotheria.util.sorter.SortType");
        clazz.addImport("net.anotheria.util.sorter.StaticQuickSorter");
        clazz.addImport(context.getServicePackageName(MetaModule.SHARED) + ".BasicService");
        List<MetaDocument> docs = module.getDocuments();
        for (int i = 0; i < docs.size(); ++i) {
            MetaDocument doc = docs.get(i);
            clazz.addImport(DataFacadeGenerator.getDocumentImport(doc));
            clazz.addImport(DataFacadeGenerator.getXMLHelperImport(context, doc));
        }
        clazz.addImport("net.anotheria.anodoc.query2.DocumentQuery");
        clazz.addImport("net.anotheria.anodoc.query2.QueryResult");
        clazz.addImport("net.anotheria.anodoc.query2.QueryResultEntry");
        clazz.addImport("net.anotheria.anodoc.query2.QueryProperty");
        clazz.addImport("net.anotheria.util.xml.XMLNode");
        clazz.addImport("net.anotheria.util.xml.XMLAttribute");
        clazz.addImport("net.anotheria.util.slicer.Segment");
        clazz.addImport("net.anotheria.util.slicer.Slicer");
        clazz.addImport("net.anotheria.asg.exception.ASGRuntimeException");
        clazz.addImport("net.anotheria.asg.service.InMemoryService");
        clazz.addImport("net.anotheria.asg.service.InMemoryObjectWrapper");
        clazz.addImport(ServiceGenerator.getInterfaceImport(module));
        clazz.addImport(ServiceGenerator.getExceptionImport(module));
        clazz.setName(this.getImplementationName(module));
        clazz.setParent("BasicService");
        clazz.addInterface(InMemoryServiceGenerator.getInterfaceName(module));
        clazz.addInterface("InMemoryService<" + InMemoryServiceGenerator.getInterfaceName(module) + ">");
        this.startClassBody();
        this.appendStatement("private static " + this.getImplementationName(module) + " instance");
        InMemoryServiceGenerator.emptyline();
        this.appendStatement("private boolean paired");
        this.appendStatement(InMemoryServiceGenerator.getInterfaceName(module), " pairedInstance = null");
        InMemoryServiceGenerator.emptyline();
        for (MetaDocument doc : docs) {
            this.appendStatement("private Map<String, InMemoryObjectWrapper<" + doc.getName() + ">> " + this.getCacheName(doc));
            this.appendStatement("private AtomicLong " + this.getLastIdName(doc) + " = new AtomicLong()");
            this.appendStatement("private List<" + doc.getName() + "> " + this.getCachedListName(doc));
            this.appendStatement("private Object " + doc.getName() + "Lock = new Object()");
        }
        InMemoryServiceGenerator.emptyline();
        this.appendString("private " + this.getImplementationName(module) + "(){");
        this.increaseIdent();
        this.appendStatement("reset()");
        this.closeBlockNEW();
        InMemoryServiceGenerator.emptyline();
        this.appendString("static final " + this.getImplementationName(module) + " getInstance(){");
        this.increaseIdent();
        this.appendString("if (instance==null){");
        this.increaseIdent();
        this.appendStatement("instance = new " + this.getImplementationName(module) + "()");
        this.closeBlockNEW();
        this.appendStatement("return instance");
        this.closeBlockNEW();
        InMemoryServiceGenerator.emptyline();
        String throwsClause = " throws " + this.getExceptionName(module) + " ";
        boolean containsAnyMultilingualDocs = false;
        timer.stopExecution("pre");
        timer.startExecution("main");
        for (int i = 0; i < docs.size(); ++i) {
            MetaDocument doc = docs.get(i);
            timer.startExecution(doc.getName() + "Document");
            String listDecl = "List<" + doc.getName() + ">";
            String wrapperDecl = this.getWrapperDecl(doc);
            this.appendString("private " + listDecl + " _getCached" + doc.getMultiple() + "()" + throwsClause + "{");
            this.increaseIdent();
            this.appendString("if (" + this.getCachedListName(doc) + " != null )");
            this.appendIncreasedStatement("return " + this.getCachedListName(doc));
            this.appendString("synchronized(" + doc.getName() + "Lock){");
            this.increaseIdent();
            this.appendString("if (" + this.getCachedListName(doc) + " != null )");
            this.appendIncreasedStatement("return " + this.getCachedListName(doc));
            this.appendStatement(listDecl + "tmp = new ArrayList<" + doc.getName() + ">(" + this.getCacheName(doc) + ".size())");
            this.appendString("for (" + wrapperDecl + " wrapper  : " + this.getCacheName(doc) + ".values()){");
            this.increaseIdent();
            this.appendString("if (wrapper.get()!=null)");
            this.appendIncreasedStatement("tmp.add(wrapper.get())");
            this.closeBlockNEW();
            this.appendStatement(this.getCachedListName(doc) + " = tmp");
            this.appendStatement("return " + this.getCachedListName(doc));
            this.closeBlockNEW();
            this.closeBlockNEW();
            InMemoryServiceGenerator.emptyline();
            this.appendString("public " + listDecl + " get" + doc.getMultiple() + "()" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("return _getCached" + doc.getMultiple() + "()");
            this.closeBlockNEW();
            InMemoryServiceGenerator.emptyline();
            this.appendString("public " + listDecl + " get" + doc.getMultiple() + "(SortType sortType)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("return StaticQuickSorter.sort(get" + doc.getMultiple() + "(), sortType)");
            this.closeBlockNEW();
            InMemoryServiceGenerator.emptyline();
            this.appendString("public void delete" + doc.getName() + "(" + doc.getName() + " " + doc.getVariableName() + ")" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("delete" + doc.getName() + "(" + doc.getVariableName() + ".getId())");
            this.appendString("if (hasServiceListeners())");
            this.appendIncreasedStatement("fireObjectDeletedEvent(" + doc.getVariableName() + ")");
            this.closeBlockNEW();
            InMemoryServiceGenerator.emptyline();
            this.appendString("public void delete" + doc.getName() + "(String id)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement(doc.getName() + " doc = null");
            this.appendString("if (paired){");
            this.increaseIdent();
            this.appendStatement(this.getWrapperDecl(doc) + " w = " + this.getCacheName(doc) + ".get(id)");
            this.appendStatement("doc = hasServiceListeners() && w!=null?w.get():null");
            this.appendString("if (w!=null)");
            this.appendIncreasedStatement("w.delete()");
            this.decreaseIdent();
            this.appendString("}else{");
            this.increaseIdent();
            this.appendStatement("doc=hasServiceListeners() && " + this.getCacheName(doc) + ".get(id)!=null?" + this.getCacheName(doc) + ".get(id).get():null");
            this.appendStatement(this.getCacheName(doc) + ".remove(id)");
            this.closeBlockNEW();
            this.appendString("if (doc!=null)");
            this.appendIncreasedStatement("fireObjectDeletedEvent(doc)");
            this.closeBlockNEW();
            InMemoryServiceGenerator.emptyline();
            this.appendComment("Deletes multiple " + doc.getName() + " objects.");
            this.appendString("public void delete" + doc.getMultiple() + "(" + listDecl + " list)" + throwsClause + "{");
            this.increaseIdent();
            this.appendString("for (" + doc.getName() + " " + doc.getVariableName() + " : list){");
            this.increaseIdent();
            this.appendStatement(wrapperDecl + " wrapper = " + this.getCacheName(doc) + ".get(" + doc.getVariableName() + ".getId())");
            this.appendString("if (wrapper==null || wrapper.get()==null)");
            this.appendIncreasedStatement("throw new " + this.getExceptionName(module) + "(\"No such " + doc.getName() + " with id: \"+" + doc.getVariableName() + ".getId())");
            this.appendStatement("wrapper.delete()");
            this.closeBlockNEW();
            this.appendString("if (hasServiceListeners()){");
            this.increaseIdent();
            this.appendString("for (int t = 0; t<list.size(); t++)");
            this.appendIncreasedStatement("fireObjectDeletedEvent(list.get(t))");
            this.closeBlockNEW();
            this.closeBlockNEW();
            InMemoryServiceGenerator.emptyline();
            this.appendString("public " + doc.getName() + " get" + doc.getName() + "(String id)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement(wrapperDecl + " w = " + this.getCacheName(doc) + ".get(id)");
            this.appendString("if (w==null || w.get()==null)");
            this.appendIncreasedStatement("throw new " + this.getExceptionName(module) + "(\"No such " + doc.getName() + " with id: \"+id)");
            this.appendStatement("return w.get()");
            this.closeBlockNEW();
            InMemoryServiceGenerator.emptyline();
            this.appendString("private " + doc.getName() + " createNewObject(String anId, " + doc.getName() + " template){");
            this.increaseIdent();
            this.appendString("if (template instanceof net.anotheria.asg.data.AbstractVO){");
            this.increaseIdent();
            this.appendStatement("throw new RuntimeException(", this.quote("Not yet implemented"), ")");
            this.closeBlockNEW();
            InMemoryServiceGenerator.emptyline();
            this.appendString("if (template instanceof net.anotheria.anodoc.data.Document){");
            this.increaseIdent();
            this.appendStatement("throw new RuntimeException(\"Document creation not yet supported\")");
            this.closeBlockNEW();
            this.appendStatement("throw new RuntimeException(\"Unknown document type: \"+template.getClass())");
            this.closeBlockNEW();
            InMemoryServiceGenerator.emptyline();
            this.appendString("public " + doc.getName() + " import" + doc.getName() + "(" + doc.getName() + " " + doc.getVariableName() + ")" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("InMemoryObjectWrapper<", doc.getName(), "> wrapper = new InMemoryObjectWrapper<", doc.getName(), ">(", doc.getVariableName(), ")");
            this.appendStatement(this.getCacheName(doc), ".put(wrapper.getId(), wrapper)");
            this.appendStatement(this.getCachedListName(doc), " = null");
            this.appendString("if (hasServiceListeners())");
            this.appendIncreasedStatement("fireObjectImportedEvent(" + doc.getVariableName() + ")");
            this.appendStatement("return " + doc.getVariableName());
            this.closeBlockNEW();
            InMemoryServiceGenerator.emptyline();
            this.appendString("public " + listDecl + " import" + doc.getMultiple() + "(" + listDecl + " list)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement(listDecl + " ret = new ArrayList<" + doc.getName() + ">(list.size())");
            this.appendString("for (" + doc.getName() + " " + doc.getVariableName() + " : list){");
            this.increaseIdent();
            this.appendStatement("ret.add(import" + doc.getName() + "(" + doc.getVariableName() + "))");
            this.closeBlockNEW();
            this.appendString("if (hasServiceListeners()){");
            this.increaseIdent();
            this.appendString("for (" + doc.getName() + " " + doc.getVariableName() + " : ret)");
            this.appendIncreasedStatement("fireObjectImportedEvent(" + doc.getVariableName() + ")");
            this.closeBlockNEW();
            this.appendStatement("return ret");
            this.closeBlockNEW();
            InMemoryServiceGenerator.emptyline();
            this.appendString("public " + doc.getName() + " create" + doc.getName() + "(" + doc.getName() + " " + doc.getVariableName() + ")" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("long nextId = " + this.getLastIdName(doc) + ".incrementAndGet()");
            this.appendStatement(doc.getVariableName() + " = createNewObject(\"\"+nextId, " + doc.getVariableName() + ")");
            this.appendStatement(wrapperDecl + " wrapper = new " + wrapperDecl + "(" + doc.getVariableName() + ", paired)");
            this.appendStatement("// should check whether an object with this id already exists... which however can only happen in case of an error ");
            this.appendStatement(this.getCacheName(doc) + ".put(wrapper.getId(), wrapper)");
            this.appendStatement(this.getCachedListName(doc), " = null");
            this.appendIncreasedStatement("fireObjectCreatedEvent(" + doc.getVariableName() + ")");
            this.appendStatement("return " + doc.getVariableName());
            this.closeBlockNEW();
            InMemoryServiceGenerator.emptyline();
            this.appendComment("Creates multiple new " + doc.getName() + " objects.\nReturns the created versions.");
            this.appendString("public " + listDecl + " create" + doc.getMultiple() + "(" + listDecl + " list)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement(listDecl + " ret = new ArrayList<" + doc.getName() + ">(list.size())");
            this.appendString("for (" + doc.getName() + " " + doc.getVariableName() + " : list){");
            this.increaseIdent();
            this.appendStatement("long nextId = " + this.getLastIdName(doc) + ".incrementAndGet()");
            this.appendStatement(doc.getVariableName() + " = createNewObject(\"\"+nextId, " + doc.getVariableName() + ")");
            this.appendStatement(wrapperDecl + " wrapper = new " + wrapperDecl + "(" + doc.getVariableName() + ", paired)");
            this.appendStatement("// should check whether an object with this id already exists... which however can only happen in case of an error ");
            this.appendStatement(this.getCacheName(doc) + ".put(wrapper.getId(), wrapper)");
            this.appendStatement("ret.add(" + doc.getVariableName() + ")");
            this.closeBlockNEW();
            this.appendString("if (hasServiceListeners()){");
            this.increaseIdent();
            this.appendString("for (" + doc.getName() + " " + doc.getVariableName() + " : ret)");
            this.appendIncreasedStatement("fireObjectCreatedEvent(" + doc.getVariableName() + ")");
            this.closeBlockNEW();
            this.appendStatement("return ret");
            this.closeBlockNEW();
            InMemoryServiceGenerator.emptyline();
            this.appendComment("Updates multiple new " + doc.getName() + " objects.\nReturns the updated versions.");
            this.appendString("public " + listDecl + " update" + doc.getMultiple() + "(" + listDecl + " list)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement(listDecl + " old = new ArrayList<" + doc.getName() + ">(list.size())");
            this.appendString("for (" + doc.getName() + " " + doc.getVariableName() + " : list){");
            this.increaseIdent();
            this.appendStatement(wrapperDecl + " wrapper = " + this.getCacheName(doc) + ".get(" + doc.getVariableName() + ".getId())");
            this.appendString("if (wrapper==null || wrapper.get()==null)");
            this.appendIncreasedStatement("throw new " + this.getExceptionName(module) + "(\"No such " + doc.getName() + " with id: \"+" + doc.getVariableName() + ".getId())");
            this.appendStatement("old.add(wrapper.get())");
            this.appendStatement("wrapper.update(" + doc.getVariableName() + ")");
            this.closeBlockNEW();
            this.appendString("if (hasServiceListeners()){");
            this.increaseIdent();
            this.appendString("for (int t = 0; t<list.size(); t++)");
            this.appendIncreasedStatement("fireObjectUpdatedEvent(old.get(t), list.get(t))");
            this.closeBlockNEW();
            this.appendStatement("return list");
            this.closeBlockNEW();
            InMemoryServiceGenerator.emptyline();
            this.appendString("public " + doc.getName() + " update" + doc.getName() + "(" + doc.getName() + " " + doc.getVariableName() + ")" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("String id = " + doc.getVariableName() + ".getId()");
            this.appendStatement(doc.getName() + " oldVersion = null");
            this.appendStatement(wrapperDecl + " w = " + this.getCacheName(doc) + ".get(id)");
            this.appendString("if (w==null || w.get()==null)");
            this.appendIncreasedStatement("throw new " + this.getExceptionName(module) + "(\"No such " + doc.getName() + " with id: \"+id)");
            this.appendString("if (hasServiceListeners())");
            this.appendIncreasedStatement("oldVersion = w.get()");
            this.appendStatement("w.update(" + doc.getVariableName() + ")");
            this.appendString("if (oldVersion!=null)");
            this.appendIncreasedStatement("fireObjectUpdatedEvent(oldVersion, " + doc.getVariableName() + ")");
            this.appendStatement("return " + doc.getVariableName());
            this.closeBlockNEW();
            InMemoryServiceGenerator.emptyline();
            this.appendString("public " + listDecl + " get" + doc.getMultiple() + "ByProperty(String propertyName, Object value)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("throw new RuntimeException(\"Not yet implemented\")");
            this.closeBlockNEW();
            InMemoryServiceGenerator.emptyline();
            this.appendString("public " + listDecl + " get" + doc.getMultiple() + "ByProperty(String propertyName, Object value, SortType sortType)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("return StaticQuickSorter.sort(get" + doc.getMultiple() + "ByProperty(propertyName, value), sortType)");
            this.closeBlockNEW();
            InMemoryServiceGenerator.emptyline();
            this.appendComment("Executes a query on " + doc.getMultiple());
            this.appendString("public QueryResult executeQueryOn" + doc.getMultiple() + "(DocumentQuery query)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement(listDecl + " all" + doc.getMultiple() + " = get" + doc.getMultiple() + "()");
            this.appendStatement("QueryResult result = new QueryResult()");
            this.appendString("for (int i=0; i<all" + doc.getMultiple() + ".size(); i++){");
            this.increaseIdent();
            this.appendStatement("List<QueryResultEntry> partialResult = query.match(all" + doc.getMultiple() + ".get(i))");
            this.appendStatement("result.add(partialResult)");
            this.closeBlockNEW();
            this.appendStatement("return result");
            this.closeBlockNEW();
            InMemoryServiceGenerator.emptyline();
            this.appendComment("Returns all " + doc.getName() + " objects, where property matches.");
            this.appendStatement("public " + listDecl + " get" + doc.getMultiple() + "ByProperty(QueryProperty... property)" + throwsClause + "{");
            this.increaseIdent();
            this.appendString("//first the slow version, the fast version is a todo.");
            this.appendStatement(listDecl + " ret = new ArrayList<" + doc.getName() + ">()");
            this.appendStatement(listDecl + " src = get" + doc.getMultiple() + "()");
            this.appendStatement("for ( " + doc.getName() + " " + doc.getVariableName() + " : src){");
            this.increaseIdent();
            this.appendStatement("boolean mayPass = true");
            this.appendStatement("for (QueryProperty qp : property){");
            this.increaseIdent();
            this.appendStatement("mayPass = mayPass && qp.doesMatch(" + doc.getVariableName() + ".getPropertyValue(qp.getName()))");
            this.closeBlockNEW();
            this.appendString("if (mayPass)");
            this.appendIncreasedStatement("ret.add(" + doc.getVariableName() + ")");
            this.closeBlockNEW();
            this.appendStatement("return ret");
            this.closeBlockNEW();
            InMemoryServiceGenerator.emptyline();
            this.appendComment("Returns all " + doc.getName() + " objects, where property matches, sorted.");
            this.appendStatement("public " + listDecl + " get" + doc.getMultiple() + "ByProperty(SortType sortType, QueryProperty... property)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("return StaticQuickSorter.sort(get" + doc.getMultiple() + "ByProperty(property), sortType)");
            this.closeBlockNEW();
            InMemoryServiceGenerator.emptyline();
            this.appendComment("Returns " + doc.getName() + " objects count.");
            this.appendString("public int get" + doc.getMultiple() + "Count()" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("return _getCached" + doc.getMultiple() + "().size()");
            this.closeBlockNEW();
            InMemoryServiceGenerator.emptyline();
            this.appendComment("Returns " + doc.getName() + " objects segment.");
            this.appendString("public " + listDecl + " get" + doc.getMultiple() + "(Segment aSegment)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("return Slicer.slice(aSegment, get" + doc.getMultiple() + "()).getSliceData()");
            this.closeBlockNEW();
            InMemoryServiceGenerator.emptyline();
            this.appendComment("Returns " + doc.getName() + " objects segment, where property matched.");
            this.appendString("public " + listDecl + " get" + doc.getMultiple() + "ByProperty(Segment aSegment, QueryProperty... property)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("int pLimit = aSegment.getElementsPerSlice()");
            this.appendStatement("int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice()");
            this.appendStatement(listDecl + " ret = new ArrayList<" + doc.getName() + ">()");
            this.appendStatement(listDecl + " src = _getCached" + doc.getMultiple() + "()");
            this.appendStatement("for (" + doc.getName() + " " + doc.getVariableName() + " : src) {");
            this.increaseIdent();
            this.appendStatement("boolean mayPass = true");
            this.appendStatement("for (QueryProperty qp : property) {");
            this.increaseIdent();
            this.appendStatement("mayPass = mayPass && qp.doesMatch(" + doc.getVariableName() + ".getPropertyValue(qp.getName()))");
            this.closeBlockNEW();
            this.appendString("if (mayPass)");
            this.appendIncreasedStatement("ret.add(" + doc.getVariableName() + ")");
            this.appendString("if (ret.size() > pOffset + pLimit)");
            this.appendIncreasedStatement("break");
            this.closeBlockNEW();
            this.appendStatement("return Slicer.slice(aSegment, ret).getSliceData()");
            this.closeBlockNEW();
            InMemoryServiceGenerator.emptyline();
            this.appendComment("Returns " + doc.getName() + " objects segment, where property matched, sorted.");
            this.appendString("public " + listDecl + " get" + doc.getMultiple() + "ByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("return StaticQuickSorter.sort(get" + doc.getMultiple() + "ByProperty(aSegment, aProperty), aSortType)");
            this.closeBlockNEW();
            InMemoryServiceGenerator.emptyline();
            if (GeneratorDataRegistry.hasLanguageCopyMethods(doc)) {
                this.appendComment("In all documents of type " + doc.getName() + " copies all multilingual fields from sourceLanguage to targetLanguage");
                this.appendStatement("public void copyMultilingualAttributesInAll" + doc.getMultiple() + "(String sourceLanguage, String targetLanguage)" + throwsClause + "{");
                this.increaseIdent();
                this.appendStatement("throw new RuntimeException(\"Not yet implemented\")");
                this.closeBlockNEW();
                InMemoryServiceGenerator.emptyline();
                containsAnyMultilingualDocs = true;
            }
            timer.stopExecution(doc.getName() + "Document");
        }
        timer.stopExecution("main");
        timer.startExecution("foot");
        if (containsAnyMultilingualDocs) {
            this.appendComment("Copies all multilingual fields from sourceLanguage to targetLanguage in all data objects (documents, vo) which are part of this module and managed by this service");
            this.appendString("public void copyMultilingualAttributesInAllObjects(String sourceLanguage, String targetLanguage)" + throwsClause + "{");
            this.increaseIdent();
            this.appendStatement("throw new RuntimeException(\"Not yet implemented\")");
            this.closeBlockNEW();
            InMemoryServiceGenerator.emptyline();
        }
        InMemoryServiceGenerator.emptyline();
        for (MetaDocument d : docs) {
            this.appendString("public XMLNode export" + d.getMultiple() + "ToXML(){");
            this.increaseIdent();
            this.appendStatement("XMLNode ret = new XMLNode(" + this.quote(d.getMultiple()) + ")");
            this.appendIncreasedString("try{");
            this.increaseIdent();
            this.appendStatement("List<" + d.getName() + "> list = get" + d.getMultiple() + "()");
            this.appendStatement("ret.addAttribute(new XMLAttribute(" + this.quote("count") + ", list.size()))");
            this.appendString("for (" + d.getName() + " object : list)");
            this.appendIncreasedStatement("ret.addChildNode(" + DataFacadeGenerator.getXMLHelperName(d) + ".toXML(object))");
            this.appendStatement("return ret");
            this.closeBlockNEW();
            this.appendString("catch(" + this.getExceptionName(module) + " e){");
            this.increaseIdent();
            this.appendStatement("throw new RuntimeException(" + this.quote("export" + d.getMultiple() + "ToXML() failure: ") + " + e.getStackTrace())");
            this.closeBlockNEW();
            this.closeBlockNEW();
            InMemoryServiceGenerator.emptyline();
            this.appendString("public XMLNode export" + d.getMultiple() + "ToXML(List<" + d.getName() + "> list){");
            this.increaseIdent();
            this.appendStatement("XMLNode ret = new XMLNode(" + this.quote(d.getMultiple()) + ")");
            this.appendStatement("ret.addAttribute(new XMLAttribute(" + this.quote("count") + ", list.size()))");
            this.appendString("for (" + d.getName() + " object : list)");
            this.appendIncreasedStatement("ret.addChildNode(" + DataFacadeGenerator.getXMLHelperName(d) + ".toXML(object))");
            this.appendStatement("return ret");
            this.closeBlockNEW();
            InMemoryServiceGenerator.emptyline();
            this.appendString("public XMLNode export" + d.getMultiple() + "ToXML(String[] languages){");
            this.increaseIdent();
            this.appendStatement("XMLNode ret = new XMLNode(" + this.quote(d.getMultiple()) + ")");
            this.appendIncreasedString("try{");
            this.increaseIdent();
            this.appendStatement("List<" + d.getName() + "> list = get" + d.getMultiple() + "()");
            this.appendStatement("ret.addAttribute(new XMLAttribute(" + this.quote("count") + ", list.size()))");
            this.appendString("for (" + d.getName() + " object : list)");
            this.appendIncreasedStatement("ret.addChildNode(" + DataFacadeGenerator.getXMLHelperName(d) + ".toXML(object, languages))");
            this.appendStatement("return ret");
            this.closeBlockNEW();
            this.appendString("catch(" + this.getExceptionName(module) + " e){");
            this.increaseIdent();
            this.appendStatement("throw new RuntimeException(" + this.quote("export" + d.getMultiple() + "ToXML() failure: ") + " + e.getStackTrace())");
            this.closeBlockNEW();
            this.closeBlockNEW();
            InMemoryServiceGenerator.emptyline();
            this.appendString("public XMLNode export" + d.getMultiple() + "ToXML(String[] languages, List<" + d.getName() + "> list){");
            this.increaseIdent();
            this.appendStatement("XMLNode ret = new XMLNode(" + this.quote(d.getMultiple()) + ")");
            this.appendStatement("ret.addAttribute(new XMLAttribute(" + this.quote("count") + ", list.size()))");
            this.appendString("for (" + d.getName() + " object : list)");
            this.appendIncreasedStatement("ret.addChildNode(" + DataFacadeGenerator.getXMLHelperName(d) + ".toXML(object, languages))");
            this.appendStatement("return ret");
            this.closeBlockNEW();
            InMemoryServiceGenerator.emptyline();
        }
        this.appendComment("Executes a query on all data objects (documents, vo) which are part of this module and managed by this service");
        this.appendString("public QueryResult executeQueryOnAllObjects(DocumentQuery query)" + throwsClause + "{");
        this.increaseIdent();
        this.appendStatement("QueryResult ret = new QueryResult()");
        for (MetaDocument doc : docs) {
            this.appendStatement("ret.add(executeQueryOn" + doc.getMultiple() + "(query).getEntries())");
        }
        this.appendStatement("return ret");
        this.closeBlock("executeQueryOnAllObjects");
        InMemoryServiceGenerator.emptyline();
        this.appendString("public XMLNode exportToXML(){");
        this.increaseIdent();
        this.appendStatement("XMLNode ret = new XMLNode(" + this.quote(module.getName()) + ")");
        InMemoryServiceGenerator.emptyline();
        for (MetaDocument d : docs) {
            this.appendStatement("ret.addChildNode(export" + d.getMultiple() + "ToXML())");
        }
        InMemoryServiceGenerator.emptyline();
        this.appendStatement("return ret");
        this.closeBlockNEW();
        InMemoryServiceGenerator.emptyline();
        this.appendString("public XMLNode exportToXML(String[] languages){");
        this.increaseIdent();
        this.appendStatement("XMLNode ret = new XMLNode(" + this.quote(module.getName()) + ")");
        InMemoryServiceGenerator.emptyline();
        for (MetaDocument d : docs) {
            this.appendStatement("ret.addChildNode(export" + d.getMultiple() + "ToXML(languages))");
        }
        InMemoryServiceGenerator.emptyline();
        this.appendStatement("return ret");
        this.closeBlockNEW();
        this.appendString("public synchronized void pairTo(" + InMemoryServiceGenerator.getInterfaceName(module) + " instance) throws ASGRuntimeException{");
        this.increaseIdent();
        this.appendString("if (paired)");
        this.appendIncreasedStatement("throw new ASGRuntimeException(", this.quote("Already paired"), ")");
        this.appendStatement("paired = true");
        this.appendStatement("pairedInstance = instance");
        this.appendStatement("reset()");
        this.closeBlockNEW();
        InMemoryServiceGenerator.emptyline();
        this.appendString("public synchronized void unpair(" + InMemoryServiceGenerator.getInterfaceName(module) + " instance){");
        this.increaseIdent();
        this.appendStatement("throw new RuntimeException(\"Not yet implemented\")");
        this.closeBlockNEW();
        InMemoryServiceGenerator.emptyline();
        this.appendString("public synchronized void synchBack()throws ASGRuntimeException{");
        this.increaseIdent();
        this.appendString("if (!paired)");
        this.appendIncreasedStatement("throw new ASGRuntimeException(", this.quote("Not paired"), ")");
        this.appendStatement("throw new RuntimeException(\"Not yet implemented\")");
        this.closeBlockNEW();
        InMemoryServiceGenerator.emptyline();
        for (MetaDocument doc : docs) {
            this.appendString("public void read" + doc.getName() + "From(" + InMemoryServiceGenerator.getInterfaceName(module) + " instance) throws ASGRuntimeException{");
            this.increaseIdent();
            this.appendStatement("List<" + doc.getName() + "> list = instance.get" + doc.getMultiple() + "()");
            this.appendStatement("long maxId = 0");
            this.appendString("for (" + doc.getName() + " " + doc.getVariableName() + " : list){ ");
            this.increaseIdent();
            this.appendStatement("long id = Long.parseLong(" + doc.getVariableName() + ".getId())");
            this.appendString("if (id>maxId)");
            this.appendIncreasedStatement("maxId = id");
            this.appendStatement(this.getCacheName(doc) + ".put(" + doc.getVariableName() + ".getId(), new InMemoryObjectWrapper<" + doc.getName() + ">(" + doc.getVariableName() + "))");
            this.closeBlockNEW();
            this.appendStatement(this.getLastIdName(doc) + " = new AtomicLong(maxId)");
            this.appendStatement(this.getCachedListName(doc) + " = null");
            this.closeBlockNEW();
            InMemoryServiceGenerator.emptyline();
        }
        this.appendString("public void readFrom(" + InMemoryServiceGenerator.getInterfaceName(module) + " instance) throws ASGRuntimeException {");
        this.increaseIdent();
        for (MetaDocument doc : docs) {
            this.appendStatement("read" + doc.getName() + "From(instance)");
        }
        this.closeBlockNEW();
        InMemoryServiceGenerator.emptyline();
        this.appendString("public void synchTo(" + InMemoryServiceGenerator.getInterfaceName(module) + " instance)throws ASGRuntimeException{");
        this.increaseIdent();
        this.appendStatement("throw new RuntimeException(\"Not yet implemented\")");
        this.closeBlockNEW();
        InMemoryServiceGenerator.emptyline();
        this.appendString("public void clear(){");
        this.increaseIdent();
        this.appendString("if (paired) ");
        this.appendIncreasedStatement("throw new RuntimeException(\"Cant reset a paired copy, unpair it first\")");
        this.appendStatement("reset()");
        this.closeBlockNEW();
        this.appendString("private void reset(){");
        this.increaseIdent();
        for (MetaDocument doc : docs) {
            this.appendStatement(this.getCacheName(doc) + " = new HashMap<String, InMemoryObjectWrapper<" + doc.getName() + ">>()");
            this.appendStatement(this.getLastIdName(doc) + " = new AtomicLong(0)");
            this.appendStatement(this.getCachedListName(doc) + " = null");
            InMemoryServiceGenerator.emptyline();
        }
        this.closeBlockNEW();
        timer.stopExecution("foot");
        return clazz;
    }

    public static String getPackageName(Context context, MetaModule module) {
        return context.getPackageName(module) + ".service.inmemory";
    }

    @Override
    protected String getSupportedInterfacesList(MetaModule module) {
        return super.getSupportedInterfacesList(module) + ", InMemoryService.class";
    }

    @Override
    protected String getMoskitoSubsystem() {
        return super.getMoskitoSubsystem() + "-inmem";
    }
}

