/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.model.rmi;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.asg.generator.CommentGenerator;
import net.anotheria.asg.generator.Context;
import net.anotheria.asg.generator.FileEntry;
import net.anotheria.asg.generator.GeneratedClass;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.IGenerateable;
import net.anotheria.asg.generator.IGenerator;
import net.anotheria.asg.generator.TypeOfClass;
import net.anotheria.asg.generator.meta.MetaDocument;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.asg.generator.model.AbstractServiceGenerator;
import net.anotheria.asg.generator.model.DataFacadeGenerator;
import net.anotheria.asg.generator.model.ServiceGenerator;
import net.anotheria.asg.generator.model.inmemory.InMemoryServiceGenerator;
import net.anotheria.util.ExecutionTimer;
import net.anotheria.util.StringUtils;

public class RMIServiceGenerator
extends AbstractServiceGenerator
implements IGenerator {
    private MetaModule module;

    @Override
    public List<FileEntry> generate(IGenerateable gmodule) {
        this.module = (MetaModule)gmodule;
        if (!this.module.isEnabledByOptions("rmi")) {
            return new ArrayList<FileEntry>();
        }
        ArrayList<FileEntry> ret = new ArrayList<FileEntry>();
        ExecutionTimer timer = new ExecutionTimer("RMI Generator");
        ret.add(new FileEntry(this.generateRemoteException(this.module)));
        ret.add(new FileEntry(this.generateLookup(this.module)));
        ret.add(new FileEntry(this.generateServer(this.module)));
        timer.startExecution(this.module.getName() + "Stub");
        ret.add(new FileEntry(this.generateStub(this.module)));
        timer.stopExecution(this.module.getName() + "Stub");
        timer.startExecution(this.module.getName() + "Skeleton");
        ret.add(new FileEntry(this.generateSkeleton(this.module)));
        timer.stopExecution(this.module.getName() + "Skeleton");
        timer.startExecution(this.module.getName() + "Interface");
        ret.add(new FileEntry(this.generateRemoteInterface(this.module)));
        timer.stopExecution(this.module.getName() + "Interface");
        timer.startExecution(this.module.getName() + "Factory");
        ret.add(new FileEntry(this.generateFactory(this.module)));
        timer.stopExecution(this.module.getName() + "Factory");
        return ret;
    }

    public String getRemoteExceptionName(MetaModule m) {
        return "RemoteExceptionWrapper";
    }

    @Override
    public String getImplementationName(MetaModule m) {
        return RMIServiceGenerator.getStubName(m);
    }

    @Override
    public String getFactoryName(MetaModule m) {
        return "RMI" + RMIServiceGenerator.getServiceName(m) + "Factory";
    }

    @Override
    protected String getPackageName(MetaModule aModule) {
        return RMIServiceGenerator.getPackageName(GeneratorDataRegistry.getInstance().getContext(), aModule);
    }

    @Override
    protected void addAdditionalFactoryImports(GeneratedClass clazz, MetaModule aModule) {
        clazz.addImport(GeneratorDataRegistry.getInstance().getContext().getServicePackageName(aModule) + "." + ServiceGenerator.getInterfaceName(aModule));
    }

    public static String getPackageName(Context context, MetaModule module) {
        return context.getPackageName(module) + ".service.rmi";
    }

    private GeneratedClass generateRemoteException(MetaModule aModule) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        this.appendGenerationPoint("generateRemoteException");
        clazz.setTypeComment(CommentGenerator.generateJavaTypeComment(this.getRemoteExceptionName(aModule), this));
        clazz.setPackageName(this.getPackageName(aModule));
        clazz.addImport("java.rmi.RemoteException");
        clazz.addImport(ServiceGenerator.getExceptionImport(aModule));
        clazz.setName("RemoteExceptionWrapper");
        clazz.setParent(ServiceGenerator.getExceptionName(aModule));
        this.startClassBody();
        this.appendString("public RemoteExceptionWrapper(RemoteException e){");
        this.increaseIdent();
        this.appendStatement("super(e)");
        this.closeBlockNEW();
        return clazz;
    }

    private GeneratedClass generateRemoteInterface(MetaModule aModule) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        this.appendGenerationPoint("generateRemoteInterface");
        clazz.setTypeComment(CommentGenerator.generateJavaTypeComment(RMIServiceGenerator.getInterfaceName(aModule), this));
        clazz.setPackageName(this.getPackageName(aModule));
        clazz.setType(TypeOfClass.INTERFACE);
        clazz.addImport("java.util.List");
        clazz.addImport("net.anotheria.util.sorter.SortType");
        clazz.addImport("net.anotheria.util.slicer.Segment");
        clazz.addImport("net.anotheria.util.xml.XMLNode");
        clazz.addImport("net.anotheria.anodoc.query2.DocumentQuery");
        clazz.addImport("net.anotheria.anodoc.query2.QueryResult");
        clazz.addImport("net.anotheria.anodoc.query2.QueryProperty");
        clazz.addImport("java.rmi.RemoteException");
        clazz.addImport(ServiceGenerator.getExceptionImport(aModule));
        clazz.addImport("net.anotheria.anodoc.util.context.CallContext");
        clazz.addImport("net.anotheria.asg.service.remote.RemoteService");
        clazz.setName(RMIServiceGenerator.getInterfaceName(aModule));
        clazz.setParent("RemoteService");
        this.startClassBody();
        boolean containsAnyMultilingualDocs = false;
        List<MetaDocument> docs = aModule.getDocuments();
        for (int i = 0; i < docs.size(); ++i) {
            MetaDocument doc = docs.get(i);
            clazz.addImport(DataFacadeGenerator.getDocumentImport(doc));
            String listDecl = "List<" + doc.getName() + ">";
            this.writeInterfaceFun("Returns all " + doc.getMultiple() + " objects stored.", listDecl, "get" + doc.getMultiple(), "");
            this.writeInterfaceFun("Returns all " + doc.getMultiple() + " objects sorted by given sortType.", listDecl, "get" + doc.getMultiple(), "SortType sortType");
            this.writeInterfaceFun("Deletes a " + doc.getName() + " object by id.", "", "delete" + doc.getName(), "String id");
            this.writeInterfaceFun("Deletes a " + doc.getName() + " object.", "", "delete" + doc.getName(), doc.getName() + " " + doc.getVariableName());
            this.writeInterfaceFun("Deltes mutiple " + doc.getName() + " objects.", "", "delete" + doc.getMultiple(), listDecl + " list");
            this.writeInterfaceFun("Returns the " + doc.getName() + " object with the specified id.", doc.getName(), "get" + doc.getName(), "String id");
            this.writeInterfaceFun("Imports multiple " + doc.getName() + " objects.\nReturns the imported versions.", listDecl, "import" + doc.getMultiple(), listDecl + " list");
            this.writeInterfaceFun("Imports a " + doc.getName() + " object.\nReturns the imported version.", doc.getName(), "import" + doc.getName(), doc.getName() + " " + doc.getVariableName());
            this.writeInterfaceFun("Creates a new " + doc.getName() + " object.\nReturns the created version.", doc.getName(), "create" + doc.getName(), doc.getName() + " " + doc.getVariableName());
            this.writeInterfaceFun("Creates multiple new " + doc.getName() + " objects.\nReturns the created versions.", listDecl, "create" + doc.getMultiple(), listDecl + " list");
            this.writeInterfaceFun("Updates a " + doc.getName() + " object.\nReturns the updated version.", doc.getName(), "update" + doc.getName(), doc.getName() + " " + doc.getVariableName());
            this.writeInterfaceFun("Updates mutiple " + doc.getName() + " objects.\nReturns the updated versions.", listDecl, "update" + doc.getMultiple(), listDecl + " list");
            this.writeInterfaceFun("Returns all " + doc.getName() + " objects, where property with given name equals object.", listDecl, "get" + doc.getMultiple() + "ByProperty", "String propertyName, Object value");
            this.writeInterfaceFun("Returns all " + doc.getName() + " objects, where property with given name equals object, sorted.", listDecl, "get" + doc.getMultiple() + "ByProperty", "String propertyName, Object value, SortType sortType");
            this.writeInterfaceFun("Executes a query", "QueryResult", "executeQueryOn" + doc.getMultiple(), "DocumentQuery query");
            this.writeInterfaceFun("Returns all " + doc.getName() + " objects, where property matches.", listDecl, "get" + doc.getMultiple() + "ByProperty", "QueryProperty... property");
            this.writeInterfaceFun("Returns all " + doc.getName() + " objects, where property matches, sorted.", listDecl, "get" + doc.getMultiple() + "ByProperty", "SortType sortType, QueryProperty... property");
            this.writeInterfaceFun("Returns " + doc.getMultiple() + "objects count.", "int", "get" + doc.getMultiple() + "Count", "");
            this.writeInterfaceFun("Returns " + doc.getName() + " objects segment.", listDecl, "get" + doc.getMultiple(), "Segment aSegment");
            this.writeInterfaceFun("Returns " + doc.getName() + " objects segment, where property matched.", listDecl, "get" + doc.getMultiple() + "ByProperty", "Segment aSegment, QueryProperty... property");
            this.writeInterfaceFun("Returns " + doc.getName() + " objects segment, where property matched, sorted.", listDecl, "get" + doc.getMultiple() + "ByProperty", "Segment aSegment, SortType sortType, QueryProperty... property");
            if (GeneratorDataRegistry.hasLanguageCopyMethods(doc)) {
                this.writeInterfaceFun("In all documents of type " + doc.getName() + " copies all multilingual fields from sourceLanguage to targetLanguage", "", "copyMultilingualAttributesInAll" + doc.getMultiple(), "String sourceLanguage, String targetLanguage");
                containsAnyMultilingualDocs = true;
            }
            this.writeInterfaceFun("Creates an xml element with selected contained data.", "XMLNode", "export" + doc.getMultiple() + "ToXML", "List<" + doc.getName() + "> list");
            if (!containsAnyMultilingualDocs || !GeneratorDataRegistry.getInstance().getContext().areLanguagesSupported()) continue;
            this.writeInterfaceFun("Creates an xml element with selected contained data.", "XMLNode", "export" + doc.getMultiple() + "ToXML", "String[] languages, List<" + doc.getName() + "> list");
        }
        if (containsAnyMultilingualDocs) {
            this.writeInterfaceFun("Copies all multilingual fields from sourceLanguage to targetLanguage in all data objects (documents, vo) which are part of this module and managed by this service", "", "copyMultilingualAttributesInAllObjects", "String sourceLanguage, String targetLanguage");
        }
        this.writeInterfaceFun("Executes a query on all data objects (documents, vo) which are part of this module and managed by this service", "QueryResult", "executeQueryOnAllObjects", "DocumentQuery query");
        this.writeInterfaceFun("creates an xml element with all contained data.", "XMLNode", "exportToXML", "");
        if (containsAnyMultilingualDocs && GeneratorDataRegistry.getInstance().getContext().areLanguagesSupported()) {
            this.writeInterfaceFun("creates an xml element with all contained data.", "XMLNode", "exportToXML", "String[] languages");
        }
        return clazz;
    }

    public static String getInterfaceName(MetaModule mod) {
        return "Remote" + RMIServiceGenerator.getServiceName(mod);
    }

    public static String getStubName(MetaModule mod) {
        return "Remote" + RMIServiceGenerator.getServiceName(mod) + "Stub";
    }

    public static String getServerName(MetaModule mod) {
        return mod.getName() + "Server";
    }

    public static String getLookupName(MetaModule mod) {
        return RMIServiceGenerator.getServiceName(mod) + "RMILookup";
    }

    public static String getSkeletonName(MetaModule mod) {
        return "Remote" + RMIServiceGenerator.getServiceName(mod) + "Skeleton";
    }

    private GeneratedClass generateLookup(MetaModule aModule) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        this.appendGenerationPoint("generateLookup");
        clazz.setTypeComment(CommentGenerator.generateJavaTypeComment(RMIServiceGenerator.getLookupName(aModule), this));
        clazz.setPackageName(this.getPackageName(aModule));
        clazz.addImport("org.slf4j.Logger");
        clazz.addImport("org.slf4j.LoggerFactory");
        clazz.addImport("org.slf4j.MarkerFactory");
        clazz.addImport("java.rmi.registry.Registry");
        clazz.addImport("java.rmi.registry.LocateRegistry");
        clazz.addImport("net.anotheria.asg.util.rmi.RMIConfig");
        clazz.addImport("net.anotheria.asg.util.rmi.RMIConfigFactory");
        clazz.setName(RMIServiceGenerator.getLookupName(aModule));
        this.startClassBody();
        this.appendStatement("private static Logger log = LoggerFactory.getLogger(", this.quote(RMIServiceGenerator.getLookupName(aModule)), ")");
        RMIServiceGenerator.emptyline();
        this.appendStatement("private static Registry rmiRegistry");
        this.appendString("static{");
        this.increaseIdent();
        this.appendCommentLine("lookup rmi registry");
        this.appendStatement("RMIConfig config = RMIConfigFactory.getRMIConfig()");
        this.appendString("try{");
        this.appendIncreasedStatement("rmiRegistry = LocateRegistry.getRegistry(config.getRegistryHost(), config.getRegistryPort())");
        this.appendString("}catch(Exception e){");
        this.appendIncreasedStatement("log.error(MarkerFactory.getMarker(\"FATAL\"), \"Coulnd't obtain rmi registry\", e)");
        this.appendString("}");
        this.closeBlockNEW();
        RMIServiceGenerator.emptyline();
        this.appendString("public static final String getServiceId(){");
        this.appendIncreasedStatement("return ", this.quote(StringUtils.replace((String)ServiceGenerator.getInterfaceImport(aModule), (char)'.', (char)'_')));
        this.appendString("}");
        this.appendString("static final " + RMIServiceGenerator.getInterfaceName(aModule) + " getRemote() throws Exception{");
        this.appendIncreasedStatement("return (" + RMIServiceGenerator.getInterfaceName(aModule) + ") rmiRegistry.lookup(getServiceId())");
        this.appendString("}");
        return clazz;
    }

    private GeneratedClass generateServer(MetaModule aModule) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        this.appendGenerationPoint("generateServer");
        clazz.setTypeComment(CommentGenerator.generateJavaTypeComment(RMIServiceGenerator.getServerName(aModule), this));
        clazz.setPackageName(this.getPackageName(aModule));
        clazz.addImport("java.rmi.registry.Registry");
        clazz.addImport("java.rmi.registry.LocateRegistry");
        clazz.addImport("java.rmi.server.UnicastRemoteObject");
        clazz.addImport("net.anotheria.asg.util.rmi.RMIConfig");
        clazz.addImport("net.anotheria.asg.util.rmi.RMIConfigFactory");
        clazz.addImport(ServiceGenerator.getInterfaceImport(aModule));
        clazz.addImport(ServiceGenerator.getFactoryImport(aModule));
        clazz.addImport("net.anotheria.asg.service.InMemoryService");
        clazz.addImport(InMemoryServiceGenerator.getInMemoryFactoryImport(aModule));
        clazz.addImport("org.slf4j.MarkerFactory");
        clazz.setName(RMIServiceGenerator.getServerName(aModule));
        clazz.setGenerateLogger(true);
        this.startClassBody();
        this.appendString("public static void main(String a[]){");
        this.increaseIdent();
        this.appendStatement("Registry rmiRegistry = null");
        this.appendCommentLine("lookup rmi registry");
        this.appendStatement("RMIConfig config = RMIConfigFactory.getRMIConfig()");
        this.appendString("try{");
        this.appendIncreasedStatement("rmiRegistry = LocateRegistry.getRegistry(config.getRegistryHost(), config.getRegistryPort())");
        this.appendString("}catch(Exception e){");
        this.appendIncreasedStatement("log.error(MarkerFactory.getMarker(\"FATAL\"), \"Coulnd't obtain rmi registry\", e)");
        this.appendIncreasedStatement("System.err.println(\"Coulnd't obtain rmi registry\")");
        this.appendIncreasedStatement("System.exit(-1)");
        this.appendString("}");
        RMIServiceGenerator.emptyline();
        this.appendString("try{");
        this.appendIncreasedStatement("startService(rmiRegistry)");
        this.appendString("}catch(Exception e){");
        this.appendIncreasedStatement("log.error(MarkerFactory.getMarker(\"FATAL\"), ", this.quote("Couldn't start service"), ", e)");
        this.appendIncreasedStatement("System.err.println(", this.quote("Couldn't start service"), ")");
        this.appendIncreasedStatement("System.exit(-2)");
        this.appendString("}");
        this.closeBlockNEW();
        this.appendString("@SuppressWarnings(", this.quote("unchecked"), ")");
        this.appendString("public static void startService(Registry registry) throws Exception{");
        this.increaseIdent();
        this.appendStatement("log.info(", this.quote("Starting " + RMIServiceGenerator.getServerName(aModule)) + ")");
        this.appendStatement(ServiceGenerator.getInterfaceName(aModule) + " myService = " + ServiceGenerator.getFactoryName(aModule) + ".create" + aModule.getName() + "Service()");
        this.appendStatement("String mode = System.getProperty(", this.quote("rmi.server.service.mode"), ")");
        this.appendString("if(mode != null && mode.equals(", this.quote("inMemory"), ")){");
        this.increaseIdent();
        this.appendStatement("log.info(", this.quote("Switch to InMemory mode"), ")");
        this.openTry();
        this.appendStatement(ServiceGenerator.getInterfaceName(aModule), " inMemoryService = ", InMemoryServiceGenerator.getInMemoryFactoryName(aModule) + ".create" + aModule.getName() + "Service()");
        this.appendStatement("log.info(", this.quote("Reading " + ServiceGenerator.getInterfaceName(aModule) + " In Memory ..."), ")");
        this.appendStatement("long startTime = System.currentTimeMillis()");
        this.appendStatement("((InMemoryService<", ServiceGenerator.getInterfaceName(aModule), ">)inMemoryService).readFrom(myService)");
        this.appendStatement("long duration = System.currentTimeMillis() - startTime");
        this.appendStatement("log.info(", this.quote("InMemory " + ServiceGenerator.getInterfaceName(aModule) + " Fillage = "), "+ duration + ", this.quote(" ms."), ")");
        this.appendStatement("myService = inMemoryService");
        this.decreaseIdent();
        this.appendString("} catch (Exception e) {");
        this.increaseIdent();
        this.appendStatement("log.error(MarkerFactory.getMarker(\"FATAL\"), ", this.quote("Could not read UserService In Memory: "), "+ e)");
        this.appendStatement("throw e");
        this.closeBlockNEW();
        this.closeBlockNEW();
        this.appendStatement(RMIServiceGenerator.getInterfaceName(aModule) + " mySkeleton = new " + RMIServiceGenerator.getSkeletonName(aModule) + "(myService)");
        this.appendStatement(RMIServiceGenerator.getInterfaceName(aModule) + " rmiServant = (" + RMIServiceGenerator.getInterfaceName(aModule) + ") UnicastRemoteObject.exportObject(mySkeleton, 0);");
        this.appendCommentLine("//register service.");
        this.appendStatement("String serviceId = " + RMIServiceGenerator.getLookupName(aModule) + ".getServiceId()");
        this.appendStatement("registry.rebind(serviceId, rmiServant)");
        this.appendStatement("log.info(", this.quote(RMIServiceGenerator.getServerName(aModule) + " for service "), " + serviceId + ", this.quote(" is up and running.") + ")");
        this.closeBlockNEW();
        return clazz;
    }

    private GeneratedClass generateStub(MetaModule aModule) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        this.appendGenerationPoint("generateStub");
        clazz.setTypeComment(CommentGenerator.generateJavaTypeComment(RMIServiceGenerator.getStubName(aModule), this));
        clazz.setPackageName(this.getPackageName(aModule));
        clazz.addImport("java.util.List");
        clazz.addImport("net.anotheria.util.sorter.SortType");
        clazz.addImport("net.anotheria.util.xml.XMLNode");
        clazz.addImport("net.anotheria.util.slicer.Segment");
        clazz.addImport("net.anotheria.anodoc.query2.DocumentQuery");
        clazz.addImport("net.anotheria.anodoc.query2.QueryResult");
        clazz.addImport("net.anotheria.anodoc.query2.QueryProperty");
        clazz.addImport("net.anotheria.asg.service.remote.BaseRemoteServiceStub");
        clazz.addImport("net.anotheria.asg.util.listener.IServiceListener");
        clazz.addImport("net.anotheria.anodoc.util.context.ContextManager");
        clazz.addImport("java.rmi.RemoteException");
        clazz.addImport(ServiceGenerator.getExceptionImport(aModule));
        clazz.addImport(ServiceGenerator.getInterfaceImport(aModule));
        clazz.setName(RMIServiceGenerator.getStubName(aModule));
        clazz.setParent("BaseRemoteServiceStub<" + RMIServiceGenerator.getInterfaceName(aModule) + ">");
        clazz.addInterface(ServiceGenerator.getInterfaceName(aModule));
        boolean containsAnyMultilingualDocs = false;
        clazz.setGenerateLogger(true);
        this.startClassBody();
        this.appendStatement("private static " + RMIServiceGenerator.getStubName(aModule) + " instance");
        RMIServiceGenerator.emptyline();
        this.appendStatement("private ", RMIServiceGenerator.getInterfaceName(aModule), " delegate");
        RMIServiceGenerator.emptyline();
        this.appendString("protected void notifyDelegateFailed(){");
        this.appendIncreasedStatement("delegate = null");
        this.appendString("}");
        RMIServiceGenerator.emptyline();
        this.appendString("private " + RMIServiceGenerator.getStubName(aModule) + "(){ }");
        RMIServiceGenerator.emptyline();
        this.appendString("public static final " + RMIServiceGenerator.getStubName(aModule) + " getInstance(){");
        this.increaseIdent();
        this.appendString("if (instance==null){");
        this.increaseIdent();
        this.appendStatement("instance = new " + RMIServiceGenerator.getStubName(aModule) + "()");
        this.closeBlockNEW();
        this.appendStatement("return instance");
        this.closeBlockNEW();
        RMIServiceGenerator.emptyline();
        this.appendString("protected " + RMIServiceGenerator.getInterfaceName(aModule) + " getDelegate() throws " + ServiceGenerator.getExceptionName(aModule) + "{");
        this.increaseIdent();
        this.appendString("if (delegate==null){");
        this.increaseIdent();
        this.appendString("synchronized(this){");
        this.increaseIdent();
        this.appendString("if (delegate==null){");
        this.increaseIdent();
        this.appendString("try{");
        this.increaseIdent();
        this.appendStatement("delegate = " + RMIServiceGenerator.getLookupName(aModule) + ".getRemote()");
        this.decreaseIdent();
        this.appendString("}catch(Exception e){");
        this.appendIncreasedStatement("throw new " + ServiceGenerator.getExceptionName(aModule) + "(e)");
        this.appendString("}");
        this.closeBlockNEW();
        this.closeBlockNEW();
        this.closeBlockNEW();
        this.appendStatement("return delegate");
        this.closeBlockNEW();
        RMIServiceGenerator.emptyline();
        List<MetaDocument> docs = aModule.getDocuments();
        for (int i = 0; i < docs.size(); ++i) {
            MetaDocument doc = docs.get(i);
            clazz.addImport(DataFacadeGenerator.getDocumentImport(doc));
            String listDecl = "List<" + doc.getName() + ">";
            this.writeStubFun("Returns all " + doc.getMultiple() + " objects stored.", listDecl, "get" + doc.getMultiple(), "", "", null);
            this.writeStubFun("Returns all " + doc.getMultiple() + " objects sorted by given sortType.", listDecl, "get" + doc.getMultiple(), "SortType sortType", "sortType", "sortType");
            this.writeStubFun("Deletes a " + doc.getName() + " object by id.", "", "delete" + doc.getName(), "String id", "id", "id");
            this.writeStubFun("Deletes a " + doc.getName() + " object.", "", "delete" + doc.getName(), doc.getName() + " " + doc.getVariableName(), doc.getVariableName(), doc.getVariableName());
            this.writeStubFun("Deletes multiple " + doc.getName() + " objects.", "", "delete" + doc.getMultiple(), listDecl + " list", "list", "list");
            this.writeStubFun("Returns the " + doc.getName() + " object with the specified id.", doc.getName(), "get" + doc.getName(), "String id", "id", "id");
            this.writeStubFun("Creates a new " + doc.getName() + " object.\nReturns the created version.", doc.getName(), "create" + doc.getName(), doc.getName() + " " + doc.getVariableName(), doc.getVariableName(), doc.getVariableName());
            this.writeStubFun("Imports a new " + doc.getName() + " object.\nReturns the imported version.", doc.getName(), "import" + doc.getName(), doc.getName() + " " + doc.getVariableName(), doc.getVariableName(), doc.getVariableName());
            this.writeStubFun("Imports multiple " + doc.getName() + " objects.\nReturns the imported versions.", listDecl, "import" + doc.getMultiple(), listDecl + " list", "list", "list");
            this.writeStubFun("Creates multiple new " + doc.getName() + " objects.\nReturns the created versions.", listDecl, "create" + doc.getMultiple(), listDecl + " list", "list", "list");
            this.writeStubFun("Updates a " + doc.getName() + " object.\nReturns the updated version.", doc.getName(), "update" + doc.getName(), doc.getName() + " " + doc.getVariableName(), doc.getVariableName(), doc.getVariableName());
            this.writeStubFun("Updates mutiple " + doc.getName() + " objects.\nReturns the updated versions.", listDecl, "update" + doc.getMultiple(), listDecl + " list", "list", "list");
            this.writeStubFun("Returns all " + doc.getName() + " objects, where property with given name equals object.", listDecl, "get" + doc.getMultiple() + "ByProperty", "String propertyName, Object value", "propertyName, value", "propertyName + " + this.quote(", ") + " + value");
            this.writeStubFun("Returns all " + doc.getName() + " objects, where property with given name equals object, sorted.", listDecl, "get" + doc.getMultiple() + "ByProperty", "String propertyName, Object value, SortType sortType", "propertyName, value, sortType", "propertyName + " + this.quote(", ") + " + value + " + this.quote(", ") + " + sortType");
            this.writeStubFun("Executes a query", "QueryResult", "executeQueryOn" + doc.getMultiple(), "DocumentQuery query", "query", "query");
            this.writeStubFun("Returns all " + doc.getName() + " objects, where property matches.", listDecl, "get" + doc.getMultiple() + "ByProperty", "QueryProperty... property", "property", "java.util.Arrays.asList(property)");
            this.writeStubFun("Returns all " + doc.getName() + " objects, where property matches, sorted.", listDecl, "get" + doc.getMultiple() + "ByProperty", "SortType sortType, QueryProperty... property", "sortType, property", "sortType + " + this.quote(", ") + " + java.util.Arrays.asList(property)");
            this.writeStubFun("Returns all " + doc.getMultiple() + " count.", "int", "get" + doc.getMultiple() + "Count", "", "", null);
            this.writeStubFun("Returns " + doc.getMultiple() + " objects segment.", listDecl, "get" + doc.getMultiple(), "Segment aSegment", "aSegment", null);
            this.writeStubFun("Returns " + doc.getName() + " objects segment, where property matched.", listDecl, "get" + doc.getMultiple() + "ByProperty", "Segment aSegment, QueryProperty... property", "aSegment, property", "java.util.Arrays.asList(property)");
            this.writeStubFun("Returns " + doc.getName() + " objects segment, where property matched, sorted.", listDecl, "get" + doc.getMultiple() + "ByProperty", "Segment aSegment, SortType sortType, QueryProperty... property", "aSegment, sortType, property", "sortType + " + this.quote(", ") + " + java.util.Arrays.asList(property)");
            if (GeneratorDataRegistry.hasLanguageCopyMethods(doc)) {
                this.writeStubFun("In all documents of type " + doc.getName() + " copies all multilingual fields from sourceLanguage to targetLanguage", "", "copyMultilingualAttributesInAll" + doc.getMultiple(), "String sourceLanguage, String targetLanguage", "sourceLanguage, targetLanguage", "sourceLanguage + " + this.quote(", ") + " + targetLanguage");
                containsAnyMultilingualDocs = true;
            }
            this.writeStubFun("Creates an xml element with all contained data.", "XMLNode", "export" + doc.getMultiple() + "ToXML", "List<" + doc.getName() + "> list" + doc.getMultiple(), "list" + doc.getMultiple(), null);
            if (!containsAnyMultilingualDocs || !GeneratorDataRegistry.getInstance().getContext().areLanguagesSupported()) continue;
            this.writeStubFun("Creates an xml element with all contained data in selected languages", "XMLNode", "export" + doc.getMultiple() + "ToXML", "String[] languages, List<" + doc.getName() + "> list" + doc.getMultiple(), "languages, list" + doc.getMultiple(), null);
        }
        if (containsAnyMultilingualDocs) {
            this.writeStubFun("Copies all multilingual fields from sourceLanguage to targetLanguage in all data objects (documents, vo) which are part of this module and managed by this service", "", "copyMultilingualAttributesInAllObjects", "String sourceLanguage, String targetLanguage", "sourceLanguage, targetLanguage", "sourceLanguage + " + this.quote(", ") + " + targetLanguage");
        }
        this.writeStubFun("Executes a query on all data objects (documents, vo) which are part of this module and managed by this service", "QueryResult", "executeQueryOnAllObjects", "DocumentQuery query", "query", "query");
        this.writeStubFun("creates an xml element with all contained data.", "XMLNode", "exportToXML", "", "", null);
        if (containsAnyMultilingualDocs && GeneratorDataRegistry.getInstance().getContext().areLanguagesSupported()) {
            this.writeStubFun("creates an xml element with all contained data in selected languages", "XMLNode", "exportToXML", "String[] languages", "languages", null);
        }
        this.appendString("public void addServiceListener(IServiceListener listener){");
        this.appendIncreasedStatement("throw new RuntimeException(", this.quote("Method not supported"), ")");
        this.appendString("}");
        RMIServiceGenerator.emptyline();
        this.appendString("public void removeServiceListener(IServiceListener listener){");
        this.appendIncreasedStatement("throw new RuntimeException(", this.quote("Method not supported"), ")");
        this.appendString("}");
        RMIServiceGenerator.emptyline();
        this.appendString("public boolean hasServiceListeners(){");
        this.appendIncreasedStatement("throw new RuntimeException(", this.quote("Method not supported"), ")");
        this.appendString("}");
        return clazz;
    }

    private GeneratedClass generateSkeleton(MetaModule aModule) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        this.appendGenerationPoint("generateSkeleton");
        clazz.setTypeComment(CommentGenerator.generateJavaTypeComment(RMIServiceGenerator.getSkeletonName(aModule), this));
        clazz.setPackageName(this.getPackageName(aModule));
        clazz.addImport("java.util.List");
        clazz.addImport("net.anotheria.util.sorter.SortType");
        clazz.addImport("net.anotheria.util.slicer.Segment");
        clazz.addImport("net.anotheria.util.xml.XMLNode");
        clazz.addImport("net.anotheria.anodoc.query2.DocumentQuery");
        clazz.addImport("net.anotheria.anodoc.query2.QueryResult");
        clazz.addImport("net.anotheria.anodoc.query2.QueryProperty");
        clazz.addImport("net.anotheria.anodoc.util.context.CallContext");
        clazz.addImport("net.anotheria.anodoc.util.context.ContextManager");
        clazz.addImport("net.anotheria.asg.service.remote.BaseRemoteServiceSkeleton");
        clazz.addImport(ServiceGenerator.getExceptionImport(aModule));
        clazz.addImport(ServiceGenerator.getInterfaceImport(aModule));
        clazz.setName(RMIServiceGenerator.getSkeletonName(aModule));
        clazz.setParent("BaseRemoteServiceSkeleton");
        clazz.addInterface(RMIServiceGenerator.getInterfaceName(aModule));
        boolean containsAnyMultilingualDocs = false;
        clazz.setGenerateLogger(true);
        this.startClassBody();
        this.appendStatement("private ", ServiceGenerator.getInterfaceName(aModule), " service");
        RMIServiceGenerator.emptyline();
        this.appendString(RMIServiceGenerator.getSkeletonName(aModule) + "(" + ServiceGenerator.getInterfaceName(aModule) + " aService){");
        this.appendIncreasedStatement("service = aService");
        this.appendString("}");
        RMIServiceGenerator.emptyline();
        List<MetaDocument> docs = aModule.getDocuments();
        for (int i = 0; i < docs.size(); ++i) {
            MetaDocument doc = docs.get(i);
            clazz.addImport(DataFacadeGenerator.getDocumentImport(doc));
            String listDecl = "List<" + doc.getName() + ">";
            this.writeSkeletonFun("Returns all " + doc.getMultiple() + " objects stored.", listDecl, "get" + doc.getMultiple(), "", "", null);
            this.writeSkeletonFun("Returns all " + doc.getMultiple() + " objects sorted by given sortType.", listDecl, "get" + doc.getMultiple(), "SortType sortType", "sortType", "sortType");
            this.writeSkeletonFun("Deletes a " + doc.getName() + " object by id.", "", "delete" + doc.getName(), "String id", "id", "id");
            this.writeSkeletonFun("Deletes a " + doc.getName() + " object.", "", "delete" + doc.getName(), doc.getName() + " " + doc.getVariableName(), doc.getVariableName(), doc.getVariableName());
            this.writeSkeletonFun("Deletes mutiple " + doc.getName() + " objects.", "", "delete" + doc.getMultiple(), listDecl + " list", "list", "list");
            this.writeSkeletonFun("Returns the " + doc.getName() + " object with the specified id.", doc.getName(), "get" + doc.getName(), "String id", "id", "id");
            this.writeSkeletonFun("Imports a new " + doc.getName() + " object.\nReturns the imported version.", doc.getName(), "import" + doc.getName(), doc.getName() + " " + doc.getVariableName(), doc.getVariableName(), doc.getVariableName());
            this.writeSkeletonFun("Imports multiple new " + doc.getName() + " objects.\nReturns the imported versions.", listDecl, "import" + doc.getMultiple(), listDecl + " list", "list", "list");
            this.writeSkeletonFun("Creates a new " + doc.getName() + " object.\nReturns the created version.", doc.getName(), "create" + doc.getName(), doc.getName() + " " + doc.getVariableName(), doc.getVariableName(), doc.getVariableName());
            this.writeSkeletonFun("Creates multiple new " + doc.getName() + " objects.\nReturns the created versions.", listDecl, "create" + doc.getMultiple(), listDecl + " list", "list", "list");
            this.writeSkeletonFun("Updates a " + doc.getName() + " object.\nReturns the updated version.", doc.getName(), "update" + doc.getName(), doc.getName() + " " + doc.getVariableName(), doc.getVariableName(), doc.getVariableName());
            this.writeSkeletonFun("Updates mutiple " + doc.getName() + " objects.\nReturns the updated versions.", listDecl, "update" + doc.getMultiple(), listDecl + " list", "list", "list");
            this.writeSkeletonFun("Returns all " + doc.getName() + " objects, where property with given name equals object.", listDecl, "get" + doc.getMultiple() + "ByProperty", "String propertyName, Object value", "propertyName, value", "propertyName + " + this.quote(", ") + " + value");
            this.writeSkeletonFun("Returns all " + doc.getName() + " objects, where property with given name equals object, sorted.", listDecl, "get" + doc.getMultiple() + "ByProperty", "String propertyName, Object value, SortType sortType", "propertyName, value, sortType", "propertyName + " + this.quote(", ") + " + value + " + this.quote(", ") + " + sortType");
            this.writeSkeletonFun("Executes a query", "QueryResult", "executeQueryOn" + doc.getMultiple(), "DocumentQuery query", "query", "query");
            this.writeSkeletonFun("Returns all " + doc.getName() + " objects, where property matches.", listDecl, "get" + doc.getMultiple() + "ByProperty", "QueryProperty... property", "property", "java.util.Arrays.asList(property)");
            this.writeSkeletonFun("Returns all " + doc.getName() + " objects, where property matches, sorted.", listDecl, "get" + doc.getMultiple() + "ByProperty", "SortType sortType, QueryProperty... property", "sortType, property", "sortType + " + this.quote(", ") + " + java.util.Arrays.asList(property)");
            this.writeSkeletonFun("Returns all " + doc.getMultiple() + " count.", "int", "get" + doc.getMultiple() + "Count", "", "", null);
            this.writeSkeletonFun("Returns " + doc.getName() + " objects segment.", listDecl, "get" + doc.getMultiple(), "Segment aSegment", "aSegment", null);
            this.writeSkeletonFun("Returns " + doc.getName() + " objects segment, where property matched.", listDecl, "get" + doc.getMultiple() + "ByProperty", "Segment aSegment, QueryProperty... property", "aSegment, property", "java.util.Arrays.asList(property)");
            this.writeSkeletonFun("Returns " + doc.getName() + " objects segment, where property matched, sorted.", listDecl, "get" + doc.getMultiple() + "ByProperty", "Segment aSegment, SortType sortType, QueryProperty... property", "aSegment, sortType, property", "sortType + " + this.quote(", ") + " + java.util.Arrays.asList(property)");
            if (GeneratorDataRegistry.hasLanguageCopyMethods(doc)) {
                this.writeSkeletonFun("In all documents of type " + doc.getName() + " copies all multilingual fields from sourceLanguage to targetLanguage", "", "copyMultilingualAttributesInAll" + doc.getMultiple(), "String sourceLanguage, String targetLanguage", "sourceLanguage, targetLanguage", "sourceLanguage + " + this.quote(", ") + " + targetLanguage");
                containsAnyMultilingualDocs = true;
            }
            this.writeExportSkeletonFun("creates an xml element with selected contained data.", "XMLNode", "export" + doc.getMultiple() + "ToXML", "List<" + doc.getName() + "> list" + doc.getMultiple(), "list" + doc.getMultiple());
            if (!containsAnyMultilingualDocs || !GeneratorDataRegistry.getInstance().getContext().areLanguagesSupported()) continue;
            this.writeExportSkeletonFun("creates an xml element with selected contained data.", "XMLNode", "export" + doc.getMultiple() + "ToXML", "String languages[] languages ,List<" + doc.getName() + ">, list" + doc.getMultiple(), "languages, list" + doc.getMultiple());
        }
        if (containsAnyMultilingualDocs) {
            this.writeSkeletonFun("Copies all multilingual fields from sourceLanguage to targetLanguage in all data objects (documents, vo) which are part of this module and managed by this service", "", "copyMultilingualAttributesInAllObjects", "String sourceLanguage, String targetLanguage", "sourceLanguage, targetLanguage", "sourceLanguage + " + this.quote(", ") + " + targetLanguage");
        }
        this.writeSkeletonFun("Executes a query on all data objects (documents, vo) which are part of this module and managed by this service", "QueryResult", "executeQueryOnAllObjects", "DocumentQuery query", "query", "query");
        this.writeSkeletonFun("creates an xml element with all contained data.", "XMLNode", "exportToXML", "", "", null);
        if (containsAnyMultilingualDocs && GeneratorDataRegistry.getInstance().getContext().areLanguagesSupported()) {
            this.writeSkeletonFun("creates an xml element with all contained data.", "XMLNode", "exportToXML", "String languages[]", "languages", null);
        }
        this.appendString("public byte[] getEcho(byte[] echoRequest){");
        this.appendIncreasedStatement("return echoRequest");
        this.appendString("}");
        return clazz;
    }

    private void writeStubFun(String comment, String returnType, String funName, String parametersFull, String parametersStripped, String parametersForLogging) {
        this.appendComment(comment);
        this.appendString(new String[]{"public ", returnType.length() > 0 ? returnType + " " : "void ", funName, "(" + parametersFull + ") throws " + this.getExceptionName(this.module) + ", RemoteExceptionWrapper{"});
        this.increaseIdent();
        this.openTry();
        this.appendStatement(returnType.length() > 0 ? "return " : "", "getDelegate().", funName, "(ContextManager.getCallContext()", parametersStripped != null && parametersStripped.length() > 0 ? ", " : "", parametersStripped, ")");
        this.decreaseIdent();
        this.appendString("} catch (RemoteException e){");
        if (parametersForLogging != null && parametersForLogging.length() > 0) {
            this.appendIncreasedStatement("log.error(", this.quote(funName + "("), " + " + parametersForLogging + " + ", this.quote(")"), ", e)");
        } else {
            this.appendIncreasedStatement("log.error(", this.quote(funName + "()"), ", e)");
        }
        this.appendIncreasedStatement("notifyDelegateFailed()");
        this.appendIncreasedStatement("throw new RemoteExceptionWrapper(e)");
        this.appendString("}");
        this.closeBlockNEW();
        RMIServiceGenerator.emptyline();
    }

    private void writeInterfaceFun(String comment, String returnType, String funName, String parametersFull) {
        this.appendComment(comment);
        this.appendStatement(new String[]{"public ", returnType.length() > 0 ? returnType + " " : "void ", funName, "(" + parametersFull + ") throws " + this.getExceptionName(this.module) + ", RemoteException"});
        RMIServiceGenerator.emptyline();
        this.appendComment(comment);
        this.appendStatement(new String[]{"public ", returnType.length() > 0 ? returnType + " " : "void ", funName, "(CallContext callContext" + (parametersFull.length() > 0 ? ", " : "") + parametersFull + ") throws " + this.getExceptionName(this.module) + ", RemoteException"});
        RMIServiceGenerator.emptyline();
    }

    private void writeSkeletonFun(String comment, String returnType, String funName, String parametersFull, String parametersStripped, String parametersForLogging) {
        this.appendComment(comment);
        this.appendString(new String[]{"public ", returnType.length() > 0 ? returnType + " " : "void ", funName, "(" + parametersFull + ") throws " + this.getExceptionName(this.module) + "{"});
        this.increaseIdent();
        this.openTry();
        this.appendStatement(returnType.length() > 0 ? "return " : "", "service.", funName, "(", parametersStripped, ")");
        this.decreaseIdent();
        this.appendString("} catch (" + ServiceGenerator.getExceptionName(this.module) + " e){");
        this.appendIncreasedStatement("throw(e)");
        this.appendString("} catch (Throwable unexpectedError){");
        if (parametersForLogging != null && parametersForLogging.length() > 0) {
            this.appendIncreasedStatement("String errorMessage = ", this.quote(funName + "("), " + " + parametersForLogging + " + ", this.quote(")"));
        } else {
            this.appendIncreasedStatement("String errorMessage = ", this.quote(funName + "()"));
        }
        this.appendIncreasedStatement("log.error(errorMessage, unexpectedError)");
        this.appendIncreasedStatement("throw new " + ServiceGenerator.getExceptionName(this.module) + "(errorMessage, unexpectedError)");
        this.appendString("}");
        this.closeBlockNEW();
        RMIServiceGenerator.emptyline();
        this.appendComment(comment);
        this.appendString(new String[]{"public ", returnType.length() > 0 ? returnType + " " : "void ", funName, "(CallContext callContext", parametersStripped != null && parametersStripped.length() > 0 ? ", " : "", parametersFull, ") throws " + this.getExceptionName(this.module) + "{"});
        this.increaseIdent();
        this.openTry();
        this.appendStatement("ContextManager.setCallContext(callContext)");
        this.appendStatement(returnType.length() > 0 ? "return " : "", "service.", funName, "(", parametersStripped, ")");
        this.decreaseIdent();
        this.appendString("} catch (" + ServiceGenerator.getExceptionName(this.module) + " e){");
        this.appendIncreasedStatement("throw(e)");
        this.appendString("} catch (Throwable unexpectedError){");
        if (parametersForLogging != null && parametersForLogging.length() > 0) {
            this.appendIncreasedStatement("String errorMessage = ", this.quote(funName + "("), " + " + parametersForLogging + " + ", this.quote(")"));
        } else {
            this.appendIncreasedStatement("String errorMessage = ", this.quote(funName + "()"));
        }
        this.appendIncreasedStatement("log.error(errorMessage, unexpectedError)");
        this.appendIncreasedStatement("throw new " + ServiceGenerator.getExceptionName(this.module) + "(errorMessage, unexpectedError)");
        this.appendString("}");
        this.closeBlockNEW();
        RMIServiceGenerator.emptyline();
    }

    private void writeExportSkeletonFun(String comment, String returnType, String funName, String parametersFull, String parametersStripped) {
        this.appendComment(comment);
        this.appendString(new String[]{"public ", returnType.length() > 0 ? returnType + " " : "void ", funName, "(" + parametersFull + ") throws " + this.getExceptionName(this.module) + "{"});
        this.increaseIdent();
        this.openTry();
        this.appendStatement(returnType.length() > 0 ? "return " : "", "service.", funName, "(", parametersStripped, ")");
        this.decreaseIdent();
        this.appendString("} catch (Throwable unexpectedError){");
        this.appendIncreasedStatement("String errorMessage = ", this.quote(funName + "()"));
        this.appendIncreasedStatement("log.error(errorMessage, unexpectedError)");
        this.appendIncreasedStatement("throw new " + ServiceGenerator.getExceptionName(this.module) + "(errorMessage, unexpectedError)");
        this.appendString("}");
        this.closeBlockNEW();
        RMIServiceGenerator.emptyline();
        this.appendComment(comment);
        this.appendString(new String[]{"public ", returnType.length() > 0 ? returnType + " " : "void ", funName, "(CallContext callContext", parametersStripped != null && parametersStripped.length() > 0 ? ", " : "", parametersFull, ") throws " + this.getExceptionName(this.module) + "{"});
        this.increaseIdent();
        this.openTry();
        this.appendStatement("ContextManager.setCallContext(callContext)");
        this.appendStatement(returnType.length() > 0 ? "return " : "", "service.", funName, "(", parametersStripped, ")");
        this.decreaseIdent();
        this.appendString("} catch (Throwable unexpectedError){");
        this.appendIncreasedStatement("String errorMessage = ", this.quote(funName + "()"));
        this.appendIncreasedStatement("log.error(errorMessage, unexpectedError)");
        this.appendIncreasedStatement("throw new " + ServiceGenerator.getExceptionName(this.module) + "(errorMessage, unexpectedError)");
        this.appendString("}");
        this.closeBlockNEW();
        RMIServiceGenerator.emptyline();
    }

    @Override
    protected String getMoskitoSubsystem() {
        return super.getMoskitoSubsystem() + "-rmi";
    }
}

