/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import net.anotheria.asg.generator.Context;
import net.anotheria.asg.generator.parser.OptionsParser;
import net.anotheria.util.StringUtils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public final class XMLContextParser {
    private XMLContextParser() {
    }

    public static Context parseContext(String content) {
        SAXBuilder reader = new SAXBuilder();
        reader.setValidation(false);
        Context ret = new Context();
        try {
            Element options;
            String cmsVersion2Value;
            Document doc = reader.build((Reader)new StringReader(content));
            Element context = doc.getRootElement();
            ret.setPackageName(context.getChildText("package"));
            ret.setOwner(context.getChildText("owner"));
            ret.setApplicationName(context.getChildText("applicationName"));
            ret.setApplicationURLPath(context.getChildText("applicationURLPath"));
            ret.setServletMapping(context.getChildText("servletMapping"));
            ret.setEncoding(context.getChildText("encoding"));
            String cmsVersion1Value = context.getChildText("cmsVersion1");
            if (!StringUtils.isEmpty((String)cmsVersion1Value)) {
                ret.setCmsVersion1(Boolean.parseBoolean(cmsVersion1Value));
            }
            if (!StringUtils.isEmpty((String)(cmsVersion2Value = context.getChildText("cmsVersion2")))) {
                ret.setCmsVersion2(Boolean.parseBoolean(cmsVersion2Value));
            }
            try {
                Element languages = context.getChild("languages");
                if (languages != null) {
                    ret = XMLContextParser.parseLanguages(ret, languages);
                }
            }
            catch (Exception languages) {
                // empty catch block
            }
            try {
                Element parameters = context.getChild("parameters");
                if (parameters != null) {
                    List params = parameters.getChildren("parameter");
                    for (Element e : params) {
                        ret.addContextParameter(e.getAttributeValue("name"), e.getAttributeValue("value"));
                    }
                }
            }
            catch (Exception parameters) {
                // empty catch block
            }
            if ((options = context.getChild("options")) != null) {
                ret.setOptions(OptionsParser.parseOptions(options));
            }
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private static Context parseLanguages(Context src, Element languages) {
        src.enableMultiLanguageSupport();
        Element supportedLanguages = languages.getChild("supported");
        List supLangs = supportedLanguages.getChildren("language");
        for (Element e : supLangs) {
            src.addLanguage(e.getText());
        }
        String defLang = languages.getChild("default").getChildText("language");
        src.setDefaultLanguage(defLang);
        return src;
    }
}

