/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import net.anotheria.asg.generator.meta.FederatedDocumentMapping;
import net.anotheria.asg.generator.meta.MetaDocument;
import net.anotheria.asg.generator.meta.MetaEnumerationProperty;
import net.anotheria.asg.generator.meta.MetaFederationModule;
import net.anotheria.asg.generator.meta.MetaLink;
import net.anotheria.asg.generator.meta.MetaListProperty;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.asg.generator.meta.MetaProperty;
import net.anotheria.asg.generator.meta.MetaTableProperty;
import net.anotheria.asg.generator.meta.ModuleParameter;
import net.anotheria.asg.generator.meta.StorageType;
import net.anotheria.asg.generator.parser.OptionsParser;
import net.anotheria.util.StringUtils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public final class XMLDataParser {
    public static final List<MetaModule> parseModules(String content) {
        SAXBuilder reader = new SAXBuilder();
        reader.setValidation(false);
        ArrayList<MetaModule> ret = new ArrayList<MetaModule>();
        try {
            Document doc = reader.build((Reader)new StringReader(content));
            Element root = doc.getRootElement();
            List modules = root.getChildren("module");
            for (int i = 0; i < modules.size(); ++i) {
                Element elem = (Element)modules.get(i);
                ret.add(XMLDataParser.parseModule(elem));
            }
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private static final MetaModule parseModule(Element m) {
        String name = m.getAttributeValue("name");
        MetaModule mod = new MetaModule();
        mod.setName(name);
        try {
            String storageKey;
            String storageType = m.getAttributeValue("storageType");
            if (storageType != null) {
                if (storageType.equalsIgnoreCase("db")) {
                    mod.setStorageType(StorageType.DB);
                }
                if (storageType.equalsIgnoreCase("federation")) {
                    mod = new MetaFederationModule(name);
                }
            }
            if ((storageKey = m.getAttributeValue("storageKey")) != null) {
                mod.setStorageKey(storageKey);
            }
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
        }
        List childs = m.getChildren("document");
        for (int i = 0; i < childs.size(); ++i) {
            mod.addDocument(XMLDataParser.parseDocument((Element)childs.get(i)));
        }
        List listeners = m.getChildren("listener");
        for (int i = 0; i < listeners.size(); ++i) {
            String listenerClass = ((Element)listeners.get(i)).getAttributeValue("class");
            mod.addListener(listenerClass);
        }
        if (mod instanceof MetaFederationModule) {
            Object e2;
            List federated = m.getChildren("federatedmodule");
            for (Object e2 : federated) {
                ((MetaFederationModule)mod).addFederatedModule(e2.getAttributeValue("key"), e2.getAttributeValue("name"));
            }
            List mappings = m.getChildren("mapping");
            e2 = mappings.iterator();
            while (e2.hasNext()) {
                Element e3 = (Element)e2.next();
                String sourceDocumentName = e3.getAttributeValue("sourceDocument");
                String targetDocument = e3.getAttributeValue("targetDocument");
                String[] t = StringUtils.tokenize((String)targetDocument, (char)'.');
                FederatedDocumentMapping mapping = new FederatedDocumentMapping();
                mapping.setSourceDocument(sourceDocumentName);
                mapping.setTargetKey(t[0]);
                mapping.setTargetDocument(t[1]);
                ((MetaFederationModule)mod).addMapping(mapping);
            }
        }
        List parameters = m.getChildren("parameter");
        for (Element p : parameters) {
            ModuleParameter param = new ModuleParameter(p.getAttributeValue("name"), p.getAttributeValue("value"));
            System.out.println("Parsed module parameter " + param + " for module " + mod.getName());
            mod.addModuleParameter(param);
        }
        Element optionsEleemnt = m.getChild("options");
        if (optionsEleemnt != null) {
            mod.setModuleOptions(OptionsParser.parseOptions(optionsEleemnt));
        }
        return mod;
    }

    private static final MetaDocument parseDocument(Element d) {
        Element p;
        int i;
        MetaDocument doc = new MetaDocument(d.getAttributeValue("name"));
        List properties = d.getChildren("property");
        List links = d.getChildren("link");
        for (i = 0; i < properties.size(); ++i) {
            p = (Element)properties.get(i);
            doc.addProperty(XMLDataParser.parseAttribute(p));
        }
        for (i = 0; i < links.size(); ++i) {
            p = (Element)links.get(i);
            doc.addLink((MetaLink)XMLDataParser.parseAttribute(p));
        }
        return doc;
    }

    private static final MetaProperty parseAttribute(Element e) {
        if (e.getName().equals("property")) {
            return XMLDataParser.parseProperty(e);
        }
        if (e.getName().equals("link")) {
            return XMLDataParser.parseLink(e);
        }
        throw new RuntimeException("Unknown attribute type:" + e.getName());
    }

    private static final MetaProperty parseProperty(Element p) {
        String name = p.getAttributeValue("name");
        String typeStr = p.getAttributeValue("type");
        if (typeStr.equals("table")) {
            return XMLDataParser.parseTable(p);
        }
        if (typeStr.equals("list")) {
            return XMLDataParser.parseList(p);
        }
        if (typeStr.equals("enumeration")) {
            return XMLDataParser.parseEnumeration(p);
        }
        MetaProperty.Type type = MetaProperty.Type.findTypeByName(typeStr);
        if (type == null) {
            throw new IllegalArgumentException("Uknown type <" + typeStr + "> for property def " + p);
        }
        MetaProperty ret = new MetaProperty(name, type);
        String multilingual = p.getAttributeValue("multilingual");
        if (multilingual != null && multilingual.length() > 0 && multilingual.equalsIgnoreCase("true")) {
            ret.setMultilingual(true);
        }
        return ret;
    }

    private static final MetaEnumerationProperty parseEnumeration(Element p) {
        String name = p.getAttributeValue("name");
        String enumeration = p.getAttributeValue("enumeration");
        MetaEnumerationProperty ret = new MetaEnumerationProperty(name, MetaProperty.Type.INT);
        ret.setEnumeration(enumeration);
        return ret;
    }

    private static final MetaProperty parseTable(Element p) {
        String name = p.getAttributeValue("name");
        MetaTableProperty ret = new MetaTableProperty(name);
        List columns = p.getChildren("column");
        for (int i = 0; i < columns.size(); ++i) {
            Element e = (Element)columns.get(i);
            ret.addColumn(e.getAttributeValue("name"));
        }
        return ret;
    }

    private static final MetaProperty parseList(Element p) {
        String name = p.getAttributeValue("name");
        MetaListProperty ret = new MetaListProperty(name);
        Element content = p.getChild("content");
        Element property = (Element)content.getChildren().get(0);
        MetaProperty containedProperty = XMLDataParser.parseAttribute(property);
        ret.setContainedProperty(containedProperty);
        String multilingual = p.getAttributeValue("multilingual");
        if (multilingual != null && multilingual.length() > 0 && multilingual.equalsIgnoreCase("true")) {
            ret.setMultilingual(true);
        }
        return ret;
    }

    private static final MetaLink parseLink(Element p) {
        List<String> decoration;
        String name = p.getAttributeValue("name");
        String linkType = p.getAttributeValue("type");
        String target = p.getAttributeValue("target");
        String decorationStr = p.getAttributeValue("decoration");
        if (StringUtils.isEmpty((String)decorationStr)) {
            decoration = new ArrayList();
            decoration.add("name");
        } else {
            decoration = StringUtils.tokenize2list((String)decorationStr, (char)',');
        }
        MetaLink l = new MetaLink(name);
        l.setLinkTarget(target);
        l.setLinkType(linkType);
        l.setLinkDecoration(decoration);
        String multilingual = p.getAttributeValue("multilingual");
        if (multilingual != null && multilingual.length() > 0 && multilingual.equalsIgnoreCase("true")) {
            l.setMultilingual(true);
        }
        return l;
    }
}

