/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.parser;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import net.anotheria.asg.generator.forms.meta.MetaForm;
import net.anotheria.asg.generator.forms.meta.MetaFormField;
import net.anotheria.asg.generator.forms.meta.MetaFormSingleField;
import net.anotheria.asg.generator.forms.meta.MetaFormTableColumn;
import net.anotheria.asg.generator.forms.meta.MetaFormTableField;
import net.anotheria.asg.generator.forms.meta.MetaFormTableHeader;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public final class XMLFormParser {
    public static final List<MetaForm> parseForms(String content) {
        SAXBuilder reader = new SAXBuilder();
        reader.setValidation(false);
        ArrayList<MetaForm> ret = new ArrayList<MetaForm>();
        try {
            Document doc = reader.build((Reader)new StringReader(content));
            Element root = doc.getRootElement();
            List forms = root.getChildren("form");
            for (int i = 0; i < forms.size(); ++i) {
                Element form = (Element)forms.get(i);
                ret.add(XMLFormParser.parseForm(form));
            }
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private static MetaForm parseForm(Element formElement) {
        String id = formElement.getAttributeValue("id");
        MetaForm form = new MetaForm(id);
        Element fields = formElement.getChild("fields");
        List<MetaFormField> formFields = XMLFormParser.parseFields(fields);
        form.setElements(formFields);
        form.setTargets(XMLFormParser.parseTargets(formElement));
        form.setAction(formElement.getAttributeValue("action"));
        return form;
    }

    private static List<String> parseTargets(Element formElement) {
        List targets = formElement.getChildren("target");
        ArrayList<String> ret = new ArrayList<String>(targets.size());
        for (int i = 0; i < targets.size(); ++i) {
            ret.add(((Element)targets.get(i)).getText());
        }
        return ret;
    }

    private static List<MetaFormField> parseFields(Element fields) {
        List fieldElements = fields.getChildren("field");
        ArrayList<MetaFormField> ret = new ArrayList<MetaFormField>(fieldElements.size());
        for (int i = 0; i < fieldElements.size(); ++i) {
            Element field = (Element)fieldElements.get(i);
            MetaFormField formField = XMLFormParser.parseField(field, i + 1);
            ret.add(formField);
        }
        return ret;
    }

    private static MetaFormField parseField(Element field, int position) {
        String type = field.getAttributeValue("type");
        if (type.equals("table")) {
            return XMLFormParser.parseTableField(field, position);
        }
        return XMLFormParser.parseSingleField(field, position);
    }

    private static MetaFormTableField parseTableField(Element field, int position) {
        Element table = field.getChild("table");
        Object name = table.getAttributeValue("name");
        if (name == null || ((String)name).length() == 0) {
            name = "element" + position;
        }
        int rows = Integer.parseInt(table.getAttributeValue("rows"));
        MetaFormTableField ret = new MetaFormTableField((String)name);
        ret.setRows(rows);
        List columns = table.getChildren("column");
        for (int i = 0; i < columns.size(); ++i) {
            MetaFormTableColumn c = XMLFormParser.parseColumn((Element)columns.get(i));
            ret.addColumn(c);
        }
        return ret;
    }

    @SuppressFBWarnings(value={"DE_MIGHT_IGNORE"})
    private static MetaFormTableColumn parseColumn(Element e) {
        MetaFormTableColumn column = new MetaFormTableColumn();
        String type = e.getAttributeValue("type");
        int size = 80;
        try {
            size = Integer.parseInt(e.getAttributeValue("size"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        MetaFormSingleField field = new MetaFormSingleField("");
        field.setType(type);
        field.setSize(size);
        column.setField(field);
        Element headerElement = e.getChild("header");
        MetaFormTableHeader header = new MetaFormTableHeader();
        header.setWidth(headerElement.getAttributeValue("width"));
        header.setKey(headerElement.getText());
        column.setHeader(header);
        return column;
    }

    private static MetaFormSingleField parseSingleField(Element field, int position) {
        String title = field.getChildText("title");
        String type = field.getAttributeValue("type");
        Object name = field.getAttributeValue("name");
        if (name == null || ((String)name).length() == 0) {
            name = "element" + position;
        }
        int size = 80;
        try {
            size = Integer.parseInt(field.getAttributeValue("size"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        MetaFormSingleField element = new MetaFormSingleField((String)name);
        element.setTitle(title);
        element.setType(type);
        element.setSize(size);
        return element;
    }

    private XMLFormParser() {
    }
}

