/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.parser;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import net.anotheria.asg.generator.util.IncludedDocuments;
import net.anotheria.util.IOUtils;
import net.anotheria.util.StringUtils;

public final class XMLPreprocessor {
    private static final String INCLUDE_COMMAND = "@include:";

    public static String loadFile(File f, IncludedDocuments includedDocuments) throws IOException {
        if (!f.exists()) {
            throw new IOException("File doesn't exists: " + f.getAbsolutePath());
        }
        int buffLineNumber = 0;
        String content = IOUtils.readFileAtOnceAsString((String)f.getAbsolutePath());
        boolean includeDocumentIsNull = true;
        if (includedDocuments != null) {
            includeDocumentIsNull = false;
            if (!includedDocuments.isListEmpty()) {
                buffLineNumber = includedDocuments.getLastInsertLine();
            }
        }
        List tags = StringUtils.extractTags((String)content, (char)'<', (char)'>');
        for (String t : tags) {
            int lineNumber;
            int indexOfIncludeCommand;
            if (!t.startsWith("<!--") || (indexOfIncludeCommand = t.indexOf(INCLUDE_COMMAND)) == -1) continue;
            int space = t.indexOf(32, indexOfIncludeCommand);
            String includeTarget = t.substring(indexOfIncludeCommand + INCLUDE_COMMAND.length(), space);
            File toInclude = new File(f.getParentFile() + File.separator + includeTarget);
            if (!toInclude.exists()) {
                throw new IOException("File to include doesn't exists: " + toInclude.getAbsolutePath() + " included from " + f.getAbsolutePath());
            }
            if (!includeDocumentIsNull && (lineNumber = XMLPreprocessor.findLineOfIncludeCommand(content, includeTarget)) >= 0) {
                includedDocuments.setNewIncludedDocument(includeTarget, lineNumber + buffLineNumber);
            }
            String includeContent = XMLPreprocessor.loadFile(toInclude, includedDocuments);
            content = StringUtils.replaceOnce((String)content, (String)t, (String)includeContent);
        }
        return content;
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
    private static int findLineOfIncludeCommand(String content, String includeTarget) throws IOException {
        File tempFile = null;
        try {
            tempFile = File.createTempFile("temp-load", ".xml");
            BufferedWriter bw = new BufferedWriter(new FileWriter(tempFile));
            bw.write(content);
            bw.close();
            BufferedReader br = new BufferedReader(new FileReader(tempFile));
            String line = null;
            int countLine = -1;
            while ((line = br.readLine()) != null) {
                ++countLine;
                if (!line.contains(includeTarget)) continue;
                br.close();
                int n = countLine;
                return n;
            }
            int n = -1;
            return n;
        }
        catch (FileNotFoundException e) {
            throw new IOException("File doesn't exist: " + e.getMessage());
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    private XMLPreprocessor() {
    }
}

