/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import net.anotheria.asg.generator.types.meta.DataType;
import net.anotheria.asg.generator.types.meta.EnumerationType;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public final class XMLTypesParser {
    public static final List<DataType> parseTypes(String content) {
        SAXBuilder reader = new SAXBuilder();
        reader.setValidation(false);
        ArrayList<DataType> ret = new ArrayList<DataType>();
        try {
            Document doc = reader.build((Reader)new StringReader(content));
            Element root = doc.getRootElement();
            List types = root.getChildren();
            for (int i = 0; i < types.size(); ++i) {
                Element elem = (Element)types.get(i);
                ret.add(XMLTypesParser.parseType(elem));
            }
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private static final DataType parseType(Element elem) {
        String name = elem.getName();
        if ("enumeration".equals(name)) {
            return XMLTypesParser.parseEnumeration(elem);
        }
        throw new RuntimeException("Unsupported data type: " + name);
    }

    private static final EnumerationType parseEnumeration(Element elem) {
        String name = elem.getAttributeValue("name");
        EnumerationType type = new EnumerationType(name);
        List children = elem.getChildren("element");
        for (int i = 0; i < children.size(); ++i) {
            Element e = (Element)children.get(i);
            type.addValue(e.getText());
        }
        return type;
    }

    private XMLTypesParser() {
    }
}

