/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.asg.generator.view.meta.MetaCustomFunctionElement;
import net.anotheria.asg.generator.view.meta.MetaCustomSection;
import net.anotheria.asg.generator.view.meta.MetaDecorator;
import net.anotheria.asg.generator.view.meta.MetaDialog;
import net.anotheria.asg.generator.view.meta.MetaEmptyElement;
import net.anotheria.asg.generator.view.meta.MetaFieldElement;
import net.anotheria.asg.generator.view.meta.MetaFunctionElement;
import net.anotheria.asg.generator.view.meta.MetaListElement;
import net.anotheria.asg.generator.view.meta.MetaModuleSection;
import net.anotheria.asg.generator.view.meta.MetaSection;
import net.anotheria.asg.generator.view.meta.MetaValidator;
import net.anotheria.asg.generator.view.meta.MetaView;
import net.anotheria.asg.generator.view.meta.MetaViewElement;
import net.anotheria.util.StringUtils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XMLViewParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLViewParser.class);

    public static final List<MetaView> parseViews(String content) {
        SAXBuilder reader = new SAXBuilder();
        reader.setValidation(false);
        ArrayList<MetaView> ret = new ArrayList<MetaView>();
        try {
            Document doc = reader.build((Reader)new StringReader(content));
            Element root = doc.getRootElement();
            List views = root.getChildren("view");
            for (Element elem : views) {
                MetaView view = XMLViewParser.parseView(elem);
                ret.add(view);
            }
        }
        catch (JDOMException e) {
            LOGGER.error("parseViews", (Throwable)e);
            throw new RuntimeException("Can't parse view because: " + e.getMessage());
        }
        catch (IOException e) {
            LOGGER.error("parseViews", (Throwable)e);
            throw new RuntimeException("Can't parse view because: " + e.getMessage());
        }
        return ret;
    }

    private static final MetaView parseView(Element m) {
        String name = m.getAttributeValue("name");
        MetaView view = new MetaView(name);
        List sections = m.getChild("sections").getChildren();
        for (int i = 0; i < sections.size(); ++i) {
            view.addSection(XMLViewParser.parseSection((Element)sections.get(i)));
        }
        view.setTitle(m.getAttributeValue("title"));
        view.setCms20("2.0".equals(m.getAttributeValue("version")));
        String roles = m.getAttributeValue("requiredroles");
        if (roles != null && roles.trim().length() != 0) {
            view.setRequiredRoles(Arrays.asList(StringUtils.tokenize((String)roles.trim(), (char)',')));
        }
        return view;
    }

    private static final MetaSection parseSection(Element section) {
        String type = section.getAttributeValue("type");
        if (type.equals("module")) {
            return XMLViewParser.parseModuleSection(section);
        }
        if (type.equals("custom")) {
            return XMLViewParser.parseCustomSection(section);
        }
        throw new RuntimeException("Unknown section type: " + type);
    }

    private static final MetaCustomSection parseCustomSection(Element section) {
        String title = section.getAttributeValue("title");
        String path = section.getChildText("path");
        MetaCustomSection ret = new MetaCustomSection(title);
        ret.setPath(path);
        return ret;
    }

    private static final MetaModuleSection parseModuleSection(Element section) {
        String title = section.getAttributeValue("title");
        MetaModuleSection s = new MetaModuleSection(title);
        String moduleName = section.getChildText("module");
        String documentName = section.getChildText("document");
        MetaModule mod = GeneratorDataRegistry.getInstance().getModule(moduleName);
        if (mod == null) {
            throw new RuntimeException("Module " + moduleName + " not found (parsing section: " + title + ")");
        }
        s.setModule(mod);
        s.setDocument(mod.getDocumentByName(documentName));
        Element elementsRoot = section.getChild("elements");
        List elements = elementsRoot.getChildren();
        for (int i = 0; i < elements.size(); ++i) {
            MetaViewElement element = XMLViewParser.parseViewElement(s, (Element)elements.get(i));
            s.addElement(element);
        }
        List dialogs = section.getChildren("dialog");
        for (int i = 0; i < dialogs.size(); ++i) {
            Element d = (Element)dialogs.get(i);
            MetaDialog dialog = new MetaDialog(d.getAttributeValue("name"));
            dialog.setTitle(d.getAttributeValue("title"));
            dialog.setJavascript(d.getAttributeValue("javascript"));
            List dialogElements = d.getChild("elements").getChildren();
            for (int e = 0; e < dialogElements.size(); ++e) {
                MetaViewElement element = XMLViewParser.parseViewElement(null, (Element)dialogElements.get(e));
                dialog.addElement(element);
            }
            s.addDialog(dialog);
        }
        List filters = section.getChildren("filter");
        for (Element f : filters) {
            s.addMetaFilter(GeneratorDataRegistry.getInstance().createFilter(f.getAttributeValue("name"), f.getAttributeValue("field")));
        }
        return s;
    }

    private static final MetaViewElement parseViewElement(MetaModuleSection section, Element elem) {
        String validatorsName;
        String description;
        String fieldCaption;
        String type = elem.getAttributeValue("type");
        MetaViewElement element = null;
        if (type.equals("field")) {
            element = XMLViewParser.parseFieldElement(elem);
        }
        if (type.equals("function")) {
            element = XMLViewParser.parseFunctionElement(elem);
        }
        if (type.equals("list")) {
            element = XMLViewParser.parseListElement(elem);
        }
        if (type.equals("empty")) {
            element = XMLViewParser.parseEmptyElement(elem);
        }
        if (type.equals("customfunction")) {
            element = XMLViewParser.parseCustomFunctionElement(elem);
        }
        if (element == null) {
            throw new RuntimeException("unknown element type " + type);
        }
        String comparable = elem.getAttributeValue("comparable");
        if (comparable != null && comparable.equals("true")) {
            element.setComparable(true);
        }
        if (section != null && comparable != null && comparable.equals("default")) {
            element.setComparable(true);
            section.setDefaultSortable(element);
        }
        if (!StringUtils.isEmpty((String)(fieldCaption = elem.getAttributeValue("caption")))) {
            element.setCaption(fieldCaption);
        }
        if (!StringUtils.isEmpty((String)(description = elem.getChildText("description")))) {
            element.setDescription(description);
        }
        if ((validatorsName = elem.getAttributeValue("validator")) != null) {
            String[] validators = validatorsName.split(",");
            ArrayList<MetaValidator> metaValidators = new ArrayList<MetaValidator>(validators.length);
            for (String validatorName : validators) {
                MetaValidator validator = GeneratorDataRegistry.getInstance().getValidator(validatorName);
                metaValidators.add(validator);
                if (validator != null) continue;
                throw new IllegalArgumentException("Uknown validator <" + validatorName + "> for view element def " + elem + ". Check that you have validators-def.xml in classpath and validator definition is present there.");
            }
            element.setValidators(metaValidators);
        }
        try {
            Element decElement = elem.getChild("decorator");
            if (decElement != null) {
                element.setDecorator(XMLViewParser.parseDecorator(decElement));
            }
        }
        catch (Exception e) {
            LOGGER.error("*********** Could not parse decorator cause: " + e.getMessage() + " ***********");
        }
        return element;
    }

    private static final MetaDecorator parseDecorator(Element e) {
        String name = e.getAttributeValue("name");
        String rule = e.getChildText("rule");
        MetaDecorator dec = GeneratorDataRegistry.getInstance().createDecorator(name, rule);
        return dec;
    }

    private static final MetaFieldElement parseFieldElement(Element elem) {
        String name = elem.getAttributeValue("name");
        String readonly = elem.getAttributeValue("readonly");
        String autocompleteOff = elem.getAttributeValue("autocompleteOff");
        String rich = elem.getAttributeValue("rich");
        String datetime = elem.getAttributeValue("datetime");
        String showLink = elem.getAttributeValue("showLink");
        MetaFieldElement field = new MetaFieldElement(name);
        if (readonly != null && readonly.equals("true")) {
            field.setReadonly(true);
        }
        if (rich != null && rich.equals("true")) {
            field.setRich(true);
        }
        if (autocompleteOff != null && autocompleteOff.equals("true")) {
            field.setAutocompleteOff(true);
        }
        if (datetime != null && datetime.equals("true")) {
            field.setDatetime(true);
        }
        if (showLink != null && showLink.equals("true")) {
            field.setShowLink(true);
        }
        return field;
    }

    private static final MetaEmptyElement parseEmptyElement(Element elem) {
        return new MetaEmptyElement();
    }

    private static final MetaFunctionElement parseFunctionElement(Element elem) {
        String name = elem.getAttributeValue("name");
        MetaFunctionElement ret = new MetaFunctionElement(name);
        if (elem.getAttribute("caption") != null) {
            ret.setCaption(elem.getAttributeValue("caption"));
        }
        return ret;
    }

    private static final MetaCustomFunctionElement parseCustomFunctionElement(Element elem) {
        String name = elem.getAttributeValue("name");
        MetaCustomFunctionElement ret = new MetaCustomFunctionElement(name);
        ret.setCaption(elem.getChildText("caption"));
        ret.setLink(elem.getChildText("link"));
        return ret;
    }

    private static final MetaListElement parseListElement(Element e) {
        MetaListElement ret = new MetaListElement();
        List elements = e.getChildren("element");
        for (int i = 0; i < elements.size(); ++i) {
            ret.addElement(XMLViewParser.parseViewElement(null, (Element)elements.get(i)));
        }
        return ret;
    }

    private XMLViewParser() {
    }
}

