/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.types;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.asg.generator.AbstractGenerator;
import net.anotheria.asg.generator.Context;
import net.anotheria.asg.generator.FileEntry;
import net.anotheria.asg.generator.GeneratedClass;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.IGenerateable;
import net.anotheria.asg.generator.IGenerator;
import net.anotheria.asg.generator.TypeOfClass;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.asg.generator.types.meta.EnumerationType;

public class EnumTypeGenerator
extends AbstractGenerator
implements IGenerator {
    @Override
    public List<FileEntry> generate(IGenerateable g) {
        EnumerationType type = (EnumerationType)g;
        ArrayList<FileEntry> ret = new ArrayList<FileEntry>();
        ret.add(new FileEntry(this.generateEnum(type)));
        return ret;
    }

    private String getPackageName() {
        return EnumTypeGenerator.getPackageName(GeneratorDataRegistry.getInstance().getContext());
    }

    private static String getPackageName(Context context) {
        return context.getPackageName(MetaModule.SHARED) + ".data";
    }

    private GeneratedClass generateEnum(EnumerationType type) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        clazz.setPackageName(this.getPackageName());
        clazz.addImport("net.anotheria.asg.exception.ConstantNotFoundException");
        clazz.setType(TypeOfClass.ENUM);
        clazz.setName(EnumTypeGenerator.getEnumClassName(type));
        this.startClassBody();
        List<String> values = type.getValues();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < values.size(); ++i) {
            String v = values.get(i).toUpperCase();
            int index = i + 1;
            stringBuilder.append(v).append('(').append(index).append(')');
            if (index == values.size()) continue;
            stringBuilder.append(",\n\t");
        }
        this.appendStatement(stringBuilder.toString());
        EnumTypeGenerator.emptyline();
        this.appendStatement("private final int value");
        EnumTypeGenerator.emptyline();
        this.appendString("private " + type.getName() + "Enum(int value) {");
        this.increaseIdent();
        this.appendStatement("this.value = value");
        this.decreaseIdent();
        this.appendString("}");
        EnumTypeGenerator.emptyline();
        this.appendString("public int getValue() {");
        this.increaseIdent();
        this.appendStatement("return value");
        this.decreaseIdent();
        this.appendString("}");
        EnumTypeGenerator.emptyline();
        this.appendString("public static " + EnumTypeGenerator.getEnumClassName(type) + " getConstantByValue(int value) throws ConstantNotFoundException {");
        this.increaseIdent();
        this.appendString("for (" + type.getName() + "Enum e : values()) {");
        this.increaseIdent();
        this.appendString("if (e.getValue() == value) {");
        this.increaseIdent();
        this.appendStatement("return e");
        this.decreaseIdent();
        this.appendString("}");
        this.decreaseIdent();
        this.appendString("}");
        this.appendStatement("throw new ConstantNotFoundException(\"Enum value not found by value \" + value)");
        this.decreaseIdent();
        this.appendString("}");
        EnumTypeGenerator.emptyline();
        return clazz;
    }

    public static String getEnumClassName(EnumerationType type) {
        return type.getName() + "Enum";
    }

    public static String getEnumImport(EnumerationType type) {
        return EnumTypeGenerator.getPackageName(GeneratorDataRegistry.getInstance().getContext()) + "." + EnumTypeGenerator.getEnumClassName(type);
    }
}

