/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.types;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.asg.generator.AbstractGenerator;
import net.anotheria.asg.generator.Context;
import net.anotheria.asg.generator.FileEntry;
import net.anotheria.asg.generator.GeneratedClass;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.IGenerateable;
import net.anotheria.asg.generator.IGenerator;
import net.anotheria.asg.generator.TypeOfClass;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.asg.generator.types.EnumTypeGenerator;
import net.anotheria.asg.generator.types.meta.EnumerationType;

public class EnumerationGenerator
extends AbstractGenerator
implements IGenerator {
    private static final EnumTypeGenerator enumTypeGenerator = new EnumTypeGenerator();

    @Override
    public List<FileEntry> generate(IGenerateable g) {
        EnumerationType type = (EnumerationType)g;
        ArrayList<FileEntry> ret = new ArrayList<FileEntry>();
        ret.add(new FileEntry(this.generateDefinition(type)));
        ret.add(new FileEntry(this.generateUtils(type)));
        ret.addAll(enumTypeGenerator.generate(type));
        return ret;
    }

    public static String getDefinitionClassName(EnumerationType type) {
        return "I" + type.getName() + "Definition";
    }

    public static String getUtilsClassName(EnumerationType type) {
        return type.getName() + "Utils";
    }

    public static String getUtilsImport(EnumerationType type) {
        return EnumerationGenerator.getPackageName(GeneratorDataRegistry.getInstance().getContext()) + "." + EnumerationGenerator.getUtilsClassName(type);
    }

    public final String getPackageName() {
        return EnumerationGenerator.getPackageName(GeneratorDataRegistry.getInstance().getContext());
    }

    public static String getPackageName(Context context) {
        return context.getPackageName(MetaModule.SHARED) + ".data";
    }

    private GeneratedClass generateDefinition(EnumerationType type) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        clazz.setPackageName(this.getPackageName());
        clazz.setType(TypeOfClass.INTERFACE);
        clazz.setName(EnumerationGenerator.getDefinitionClassName(type));
        this.startClassBody();
        List<String> values = type.getValues();
        for (int i = 0; i < values.size(); ++i) {
            String v = values.get(i);
            this.appendComment("Constant for value " + v + ".");
            this.appendStatement("int " + v + " = " + (i + 1));
        }
        EnumerationGenerator.emptyline();
        for (String v : values) {
            this.appendComment("Constant for value name " + v + ".");
            this.appendStatement("String " + v + "_NAME = " + this.quote(v));
        }
        EnumerationGenerator.emptyline();
        this.appendString("int " + type.getName().toUpperCase() + "_VALUES[] = {");
        for (String v : values) {
            this.appendIncreasedString(v + ",");
        }
        this.appendString("};");
        EnumerationGenerator.emptyline();
        this.appendString("String " + type.getName().toUpperCase() + "_NAMES[] = {");
        for (String v : values) {
            this.appendIncreasedString(v + "_NAME,");
        }
        this.appendString("};");
        return clazz;
    }

    private GeneratedClass generateUtils(EnumerationType type) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        clazz.setPackageName(this.getPackageName());
        clazz.addImport("java.util.Arrays");
        clazz.addImport("java.util.List");
        clazz.setName(EnumerationGenerator.getUtilsClassName(type));
        clazz.addInterface(EnumerationGenerator.getDefinitionClassName(type));
        this.startClassBody();
        this.appendString("public static List<String> get" + type.getName() + "List(){");
        this.increaseIdent();
        this.appendStatement("return Arrays.asList(" + type.getName().toUpperCase() + "_NAMES)");
        this.append(this.closeBlock());
        this.appendString("public static String getName(int value){");
        this.increaseIdent();
        this.appendString("switch(value){");
        this.increaseIdent();
        List<String> values = type.getValues();
        for (String v : values) {
            this.appendString("case " + v + ":");
            this.appendIncreasedStatement("return " + v + "_NAME");
        }
        this.appendString("default:");
        this.appendIncreasedStatement("return \"Unknown: \"+value");
        this.append(this.closeBlock());
        this.append(this.closeBlock());
        this.appendString("public static int getValue(String name){");
        this.increaseIdent();
        for (String v : values) {
            this.appendString("if( " + v + "_NAME.equals(name))");
            this.appendIncreasedStatement("return " + v);
        }
        this.appendIncreasedStatement("return 0");
        this.append(this.closeBlock());
        return clazz;
    }
}

