/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.view;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.anotheria.asg.generator.AbstractGenerator;
import net.anotheria.asg.generator.FileEntry;
import net.anotheria.asg.generator.GeneratedClass;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.meta.MetaModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMSFilterGenerator
extends AbstractGenerator {
    public List<FileEntry> generate() {
        ArrayList<FileEntry> ret = new ArrayList<FileEntry>();
        try {
            ret.add(new FileEntry(this.generateCMSFilter()));
        }
        catch (Exception e) {
            System.out.println("CMSFilterGenerator error: " + e.getMessage());
            e.printStackTrace();
        }
        return ret;
    }

    private GeneratedClass generateCMSFilter() {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        clazz.setPackageName(this.getPackageName());
        clazz.addImport(Arrays.class);
        clazz.addImport(List.class);
        clazz.addImport(Logger.class);
        clazz.addImport(LoggerFactory.class);
        clazz.addImport(File.class);
        clazz.addImport("jakarta.servlet.FilterConfig");
        clazz.addImport("jakarta.servlet.ServletException");
        clazz.addImport("net.anotheria.maf.MAFFilter");
        clazz.addImport("net.anotheria.maf.action.ActionMappingsConfigurator");
        clazz.addImport("net.anotheria.anosite.cms.user.CMSUserManager");
        clazz.setParent("MAFFilter");
        clazz.setName("CMSFilter");
        this.appendGenerationPoint("generateCMSFilter()");
        this.startClassBody();
        this.appendComment("Logger initialization.");
        this.appendStatement("private static final Logger log = LoggerFactory.getLogger(CMSFilter.class);");
        CMSFilterGenerator.emptyline();
        this.appendString("@Override");
        this.openFun("public void init(FilterConfig config) throws ServletException");
        this.appendStatement("log.info(\"----  Initing CMS...  ------\")");
        this.appendStatement("super.init(config)");
        CMSFilterGenerator.emptyline();
        this.appendStatement("log.info(\"----  Initing CMS user manager...  ------\")");
        this.appendStatement("CMSUserManager.init()");
        this.closeBlock("init");
        CMSFilterGenerator.emptyline();
        this.appendString("@Override");
        this.openFun("protected List<ActionMappingsConfigurator> getConfigurators()");
        this.appendStatement("return Arrays.asList(new ActionMappingsConfigurator[] { new CMSMappingsConfigurator()})");
        this.closeBlock("getConfigurators");
        return clazz;
    }

    private String getPackageName() {
        return GeneratorDataRegistry.getInstance().getContext().getPackageName(MetaModule.SHARED) + ".filter";
    }
}

