/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.anotheria.asg.generator.AbstractGenerator;
import net.anotheria.asg.generator.FileEntry;
import net.anotheria.asg.generator.GeneratedClass;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.forms.meta.MetaForm;
import net.anotheria.asg.generator.meta.MetaContainerProperty;
import net.anotheria.asg.generator.meta.MetaDocument;
import net.anotheria.asg.generator.meta.MetaListProperty;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.asg.generator.meta.MetaProperty;
import net.anotheria.asg.generator.meta.MetaTableProperty;
import net.anotheria.asg.generator.meta.StorageType;
import net.anotheria.asg.generator.view.action.IndexPageActionGenerator;
import net.anotheria.asg.generator.view.action.ModuleActionsGenerator;
import net.anotheria.asg.generator.view.jsp.IndexPageJspGenerator;
import net.anotheria.asg.generator.view.jsp.JspGenerator;
import net.anotheria.asg.generator.view.meta.MetaDialog;
import net.anotheria.asg.generator.view.meta.MetaModuleSection;
import net.anotheria.asg.generator.view.meta.MetaSection;
import net.anotheria.asg.generator.view.meta.MetaView;
import net.anotheria.maf.action.ActionMappings;
import net.anotheria.maf.action.ActionMappingsConfigurator;
import net.anotheria.maf.action.CommandForward;
import net.anotheria.util.StringUtils;
import net.anotheria.webutils.filehandling.actions.FileAjaxUpload;
import net.anotheria.webutils.filehandling.actions.GetFile;
import net.anotheria.webutils.filehandling.actions.ShowFile;
import net.anotheria.webutils.filehandling.actions.ShowTmpFile;

public class CMSMappingsConfiguratorGenerator
extends AbstractGenerator {
    public static final String ACTION_SHOW = "show";
    public static final String ACTION_NEW = "new";
    public static final String ACTION_EDIT = "edit";
    public static final String ACTION_CREATE = "create";
    public static final String ACTION_UPDATE = "update";
    public static final String ACTION_DELETE = "delete";
    public static final String ACTION_VERSIONINFO = "versioninfo";
    public static final String ACTION_DUPLICATE = "duplicate";
    public static final String ACTION_DEEPCOPY = "deepcopy";
    public static final String ACTION_ADD = "add";
    public static final String ACTION_QUICK_ADD = "quickAdd";
    public static final String ACTION_EXPORT = "export";
    public static final String ACTION_SHOW_QUERIES = "showQueries";
    public static final String ACTION_EXECUTE_QUERY = "execQuery";
    public static final String ACTION_LINKS_TO_ME = "LinksToMe";
    public static final String ACTION_MOVE = "move";
    public static final String ACTION_SEARCH = "search";
    public static final String ACTION_COPY_LANG = "copyLang";
    public static final String ACTION_SWITCH_MULTILANGUAGE_INSTANCE = "switchMultilang";
    public static final String ACTION_SHOW_USAGES = "showUsages";
    public static final String ACTION_LOCK = "lock";
    public static final String ACTION_UNLOCK = "unLock";
    public static final String ACTION_CLOSE = "close";
    public static final String ACTION_TRANSFER = "transfer";

    public List<FileEntry> generate(List<MetaView> views) {
        ArrayList<FileEntry> ret = new ArrayList<FileEntry>();
        try {
            ret.add(new FileEntry(this.generateCMSMapping(views)));
        }
        catch (Exception e) {
            System.out.println("CMSMappingsConfiguratorGenerator error: " + e.getMessage());
            e.printStackTrace();
        }
        return ret;
    }

    public static String getClassSimpleName() {
        return "CMSMappingsConfigurator";
    }

    public static String getClassName() {
        return CMSMappingsConfiguratorGenerator.getPackageName() + "." + CMSMappingsConfiguratorGenerator.getClassSimpleName();
    }

    private GeneratedClass generateCMSMapping(List<MetaView> views) {
        MetaModuleSection s;
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        clazz.setPackageName(CMSMappingsConfiguratorGenerator.getPackageName());
        clazz.addImport(Map.class);
        clazz.addImport(HashMap.class);
        clazz.addImport(CommandForward.class);
        clazz.addImport(ActionMappings.class);
        clazz.addImport(ActionMappingsConfigurator.class);
        clazz.addImport(IndexPageActionGenerator.getIndexPageFullName());
        clazz.addImport("net.anotheria.anosite.cms.action.LocalizationBundleExportMafAction");
        clazz.addImport("net.anotheria.anosite.cms.action.LocalizationBundleImportMafAction");
        clazz.addImport("net.anotheria.anosite.cms.action.LocalizationBundleExportToTxtAction");
        clazz.addImport("net.anotheria.anosite.cms.action.LocalizationBundleMakeParentsMafAction");
        clazz.addImport("net.anotheria.anosite.cms.action.LocalizationBundleTranslationMafAction");
        clazz.addImport("net.anotheria.anosite.cms.action.LocalizationBundleSpecificTranslationMafAction");
        clazz.addInterface("ActionMappingsConfigurator");
        clazz.setName(CMSMappingsConfiguratorGenerator.getClassSimpleName());
        this.startClassBody();
        CMSMappingsConfiguratorGenerator.emptyline();
        this.appendString("private static final Map<String, String> showActionsRegistry;");
        this.appendString("static{");
        this.increaseIdent();
        this.appendStatement("showActionsRegistry = new HashMap<String,String>()");
        for (MetaView view : views) {
            for (MetaSection section : view.getSections()) {
                if (!(section instanceof MetaModuleSection)) continue;
                s = (MetaModuleSection)section;
                this.generateActionsRegistry(s);
            }
        }
        this.closeBlock("close static block");
        CMSMappingsConfiguratorGenerator.emptyline();
        this.openFun("public static String getActionPath(String parentName, String documentName)");
        this.appendStatement("return showActionsRegistry.get(parentName + \".\" + documentName)");
        this.closeBlock("getActionPath");
        CMSMappingsConfiguratorGenerator.emptyline();
        this.appendString("@Override");
        this.openFun("public void configureActionMappings(ActionMappings mappings)");
        this.appendStatement("mappings.addMapping(\"index\", " + IndexPageActionGenerator.getIndexPageActionName() + ".class, new CommandForward(\"success\", " + this.quote(IndexPageJspGenerator.getIndexJspFullName()) + "))");
        this.appendStatement("mappings.addMapping(\"asgLocalizationBundleExportView\", net.anotheria.anosite.cms.action.LocalizationBundleExportMafAction.class, new CommandForward(\"success\", \"/net/anotheria/anosite/cms/jsp/LocalizationBundleExport.jsp\"))");
        this.appendStatement("mappings.addMapping(\"asgLocalizationBundleImportView\", net.anotheria.anosite.cms.action.LocalizationBundleImportMafAction.class, new CommandForward(\"success\", \"/net/anotheria/anosite/cms/jsp/LocalizationBundleImport.jsp\"))");
        this.appendStatement("mappings.addMapping(\"asgLocalizationBundleMakeParentsView\", net.anotheria.anosite.cms.action.LocalizationBundleMakeParentsMafAction.class, new CommandForward(\"success\", \"/net/anotheria/anosite/cms/jsp/LocalizationBundleMakeParents.jsp\"))");
        this.appendStatement("mappings.addMapping(\"asgLocalizationBundleTranslationView\", net.anotheria.anosite.cms.action.LocalizationBundleTranslationMafAction.class, new CommandForward(\"success\", \"/net/anotheria/anosite/cms/jsp/LocalizationBundleTranslation.jsp\"))");
        this.appendStatement("mappings.addMapping(\"asgLocalizationBundleSpecificTranslationView\", net.anotheria.anosite.cms.action.LocalizationBundleSpecificTranslationMafAction.class, new CommandForward(\"success\", \"/net/anotheria/anosite/cms/jsp/LocalizationBundleSpecificTranslation.jsp\"))");
        this.appendStatement("mappings.addMapping(\"fileShow\", " + this.quote(ShowFile.class.getName()) + ", new CommandForward(\"success\", \"/net/anotheria/webutils/jsp/UploadFile.jsp\"))");
        this.appendStatement("mappings.addMapping(\"fileUpload\", " + this.quote(FileAjaxUpload.class.getName()) + ")");
        this.appendStatement("mappings.addMapping(\"exportLocalizationBundlesToTxt\", net.anotheria.anosite.cms.action.LocalizationBundleExportToTxtAction.class)");
        this.appendStatement("mappings.addMapping(\"showTmpFile\", " + this.quote(ShowTmpFile.class.getName()) + ")");
        this.appendStatement("mappings.addMapping(\"getFile\", " + this.quote(GetFile.class.getName()) + ")");
        this.appendStatement("mappings.addMapping(\"login\", net.anotheria.anosite.cms.action.LoginAction.class, new CommandForward(\"success\", \"/net/anotheria/anosite/cms/jsp/Login.jsp\"))");
        this.appendStatement("mappings.addMapping(\"logout\", net.anotheria.anosite.cms.action.LogoutAction.class, new CommandForward(\"success\", \"/net/anotheria/anosite/cms/jsp/Login.jsp\"))");
        this.appendStatement("mappings.addMapping(\"changePass\", net.anotheria.anosite.cms.action.ChangePassAction.class, new CommandForward(\"success\", \"/net/anotheria/anosite/cms/jsp/ChangePass.jsp\"))");
        this.appendStatement("mappings.addMapping(\"showUsages\", net.anotheria.anosite.bredcrambs.action.ShowUsagesOfDocumentAction.class)");
        this.generateSharedMappings(clazz);
        for (MetaView view : views) {
            for (MetaSection section : view.getSections()) {
                if (!(section instanceof MetaModuleSection)) continue;
                s = (MetaModuleSection)section;
                this.appendStatement("configureActionMappings" + s.getDocument().getName() + "(mappings)");
            }
        }
        this.closeBlock("configureActionMappings");
        CMSMappingsConfiguratorGenerator.emptyline();
        for (MetaView view : views) {
            for (MetaSection section : view.getSections()) {
                if (!(section instanceof MetaModuleSection)) continue;
                s = (MetaModuleSection)section;
                this.openFun("private void configureActionMappings" + s.getDocument().getName() + "(ActionMappings mappings)");
                this.generateSectionMappings(clazz, s);
                CMSMappingsConfiguratorGenerator.emptyline();
                MetaDocument doc = s.getDocument();
                for (int p = 0; p < doc.getProperties().size(); ++p) {
                    MetaProperty pp = doc.getProperties().get(p);
                    if (!(pp instanceof MetaContainerProperty)) continue;
                    this.generateContainerMappings(clazz, s, (MetaContainerProperty)pp);
                }
                this.closeBlock("configure " + s.getDocument().getName());
                CMSMappingsConfiguratorGenerator.emptyline();
            }
        }
        return clazz;
    }

    private static String getPackageName() {
        return GeneratorDataRegistry.getInstance().getContext().getPackageName(MetaModule.SHARED) + ".filter";
    }

    private void generateSectionMappings(GeneratedClass clazz, MetaModuleSection section) {
        MetaModule module = section.getModule();
        String actionsPackage = ModuleActionsGenerator.getPackage(module);
        boolean validatedUpdateAction = section.isValidatedOnSave();
        for (SectionAction action : SectionAction.values()) {
            if (action.isIgnoreForSection(section)) continue;
            String actionName = actionsPackage + "." + action.getClassName(section);
            this.appendStatement("mappings.addMapping(" + this.quote(action.getMappingName(section)) + ", " + actionName + ".class, new CommandForward(\"success\"," + this.quote(action.getViewFullName(section) + ".jsp") + "))");
            if (!validatedUpdateAction || !action.equals((Object)SectionAction.UPDATE)) continue;
            this.appendStatement("mappings.addMapping(" + this.quote(action.getMappingName(section)) + ", " + actionName + ".class, new CommandForward(\"validationError\"," + this.quote(SectionAction.NEW.getViewFullName(section) + ".jsp") + "))");
        }
    }

    private void generateActionsRegistry(MetaModuleSection section) {
        if (SectionAction.SHOW.isIgnoreForSection(section)) {
            return;
        }
        this.appendStatement("showActionsRegistry.put(" + this.quote(section.getModule().getName() + "." + section.getDocument().getName()) + ", " + this.quote(SectionAction.SHOW.getMappingName(section)) + ")");
    }

    private void generateSharedMappings(GeneratedClass clazz) {
        String actionsPackage = GeneratorDataRegistry.getInstance().getContext().getPackageName(MetaModule.SHARED) + ".action";
        for (SharedAction action : SharedAction.values()) {
            String actionName = actionsPackage + "." + action.getClassName();
            this.appendStatement("mappings.addMapping(" + this.quote(action.getMappingName()) + ", " + actionName + ".class, new CommandForward(\"success\"," + this.quote(action.getViewFullName() + ".jsp") + "))");
        }
    }

    private void generateContainerMappings(GeneratedClass clazz, MetaModuleSection section, MetaContainerProperty container) {
        if (section.getDialogs().size() == 0) {
            return;
        }
        MetaDocument doc = section.getDocument();
        String actionsPackage = ModuleActionsGenerator.getPackage(doc);
        String jspPath = FileEntry.package2fullPath(JspGenerator.getPackage(doc)).substring(FileEntry.package2fullPath(JspGenerator.getPackage(doc)).indexOf(47)) + "/";
        for (ContainerAction action : ContainerAction.values()) {
            String actionName = actionsPackage + "." + action.getClassName(doc, container);
            this.appendStatement("mappings.addMapping(" + this.quote(action.getMappingName(doc, container)) + ", " + actionName + ".class, new CommandForward(\"success\"," + this.quote(jspPath + action.getViewName(doc, container) + ".jsp") + "))");
        }
    }

    public static final String getPath(MetaDocument doc, String action) {
        return doc.getParentModule().getName().toLowerCase() + StringUtils.capitalize((String)doc.getName()) + StringUtils.capitalize((String)action);
    }

    public static String getShowQueriesPath(MetaDocument doc) {
        return CMSMappingsConfiguratorGenerator.getPath(doc, ACTION_SHOW_QUERIES);
    }

    public static String getShowCMSPath(MetaDocument doc) {
        return CMSMappingsConfiguratorGenerator.getPath(doc, ACTION_SHOW);
    }

    public static final String getDialogFormName(MetaDialog dialog, MetaDocument document) {
        return dialog.getName() + document.getParentModule().getName() + document.getName() + "Form";
    }

    public static final String getContainerPath(MetaDocument doc, MetaContainerProperty container, String action) {
        return doc.getParentModule().getName().toLowerCase() + StringUtils.capitalize((String)doc.getName()) + StringUtils.capitalize((String)container.getName()) + StringUtils.capitalize((String)action);
    }

    public static String getFormName(MetaForm form) {
        return StringUtils.capitalize((String)form.getId()) + "AutoForm";
    }

    public static String getFormPath(MetaForm form) {
        return form.getId() + StringUtils.capitalize((String)form.getAction());
    }

    public static String getExecuteQueryPath(MetaDocument doc) {
        return CMSMappingsConfiguratorGenerator.getPath(doc, ACTION_EXECUTE_QUERY);
    }

    public static final String getContainerEntryFormName(MetaDocument doc, MetaContainerProperty property) {
        String nameAddy = "XXX";
        if (property instanceof MetaTableProperty) {
            nameAddy = "Row";
        }
        if (property instanceof MetaListProperty) {
            nameAddy = "Element";
        }
        return doc.getParentModule().getName().toLowerCase() + StringUtils.capitalize((String)doc.getName()) + StringUtils.capitalize((String)property.getName()) + nameAddy + "Form";
    }

    public static final String getContainerQuickAddFormName(MetaDocument doc, MetaContainerProperty property) {
        String nameAddy = "XXX";
        if (property instanceof MetaListProperty) {
            nameAddy = "QuickAdd";
        }
        return doc.getParentModule().getName().toLowerCase() + StringUtils.capitalize((String)doc.getName()) + StringUtils.capitalize((String)property.getName()) + nameAddy + "Form";
    }

    public static enum ContainerAction {
        SHOW("Show"),
        DELETE("Delete"),
        MOVE("Move"),
        ADD("Add"),
        QUICKADD("QuickAdd");

        private String action;

        private ContainerAction(String anAction) {
            this.action = anAction;
        }

        public String getClassName(MetaDocument doc, MetaContainerProperty container) {
            return ModuleActionsGenerator.getContainerMultiOpActionName(doc, container);
        }

        public String getMappingName(MetaDocument doc, MetaContainerProperty container) {
            return doc.getParentModule().getName().toLowerCase() + StringUtils.capitalize((String)doc.getName()) + StringUtils.capitalize((String)container.getName()) + this.action;
        }

        public String getViewName(MetaDocument doc, MetaContainerProperty container) {
            return JspGenerator.getContainerPageName(doc, container);
        }
    }

    public static enum SharedAction {
        SEARCH("CmsSearch", "SearchResult"){};

        private String action;
        private String view;

        private SharedAction(String anAction, String aView) {
            this.action = anAction;
            this.view = aView;
        }

        public String getClassName() {
            return this.action + "Action";
        }

        public String getMappingName() {
            return this.action.toLowerCase();
        }

        public String getViewName() {
            return this.view;
        }

        public String getViewPath() {
            return "/" + FileEntry.package2path(GeneratorDataRegistry.getInstance().getContext().getPackageName(MetaModule.SHARED) + ".jsp") + "/";
        }

        public String getViewFullName() {
            return this.getViewPath() + this.getViewName();
        }

        public static final String getPackageName() {
            return GeneratorDataRegistry.getInstance().getContext().getPackageName(MetaModule.SHARED) + ".action";
        }
    }

    public static enum SectionAction {
        SHOW("Show", "Show", OperationType.SINGLE, true),
        EDIT("Edit", "Edit", OperationType.SINGLE),
        NEW("New", "Edit", OperationType.SINGLE),
        LINKSTOME("LinksToMe", "LinksTo", OperationType.SINGLE, false){

            @Override
            public String getClassName(MetaModuleSection section) {
                return "Edit" + section.getDocument().getName() + "Action";
            }

            @Override
            public String getViewName(MetaModuleSection section) {
                MetaDocument doc = section.getDocument();
                return "LinksTo" + doc.getName();
            }
        }
        ,
        CLOSE("Close", "Show", OperationType.MULTIPLE_DIALOG),
        UPDATE("Update", "Show", OperationType.MULTIPLE_DIALOG),
        DELETE("Delete", "Show", OperationType.MULTIPLE_DIALOG),
        DUPLICATE("Duplicate", "Show", OperationType.MULTIPLE_DIALOG),
        PREVIEW("Preview", "Show", OperationType.MULTIPLE_DIALOG),
        LOCK("Lock", "EditBoxDialog", OperationType.MULTIPLE_DIALOG),
        UNLOCK("UnLock", "EditBoxDialog", OperationType.MULTIPLE_DIALOG),
        TRANSFER("Transfer", "Show", OperationType.SINGLE),
        COPYLANG("CopyLang", "EditBoxDialog", OperationType.MULTIPLE_DIALOG),
        SWITCHMULTILANG("SwitchMultilang", "EditBoxDialog", OperationType.MULTIPLE_DIALOG),
        VERSIONINFO("Versioninfo", "EditBoxDialog", OperationType.MULTIPLE_DIALOG),
        EXPORTtoCSV("Export.csv", "Show", OperationType.SINGLE, true){

            @Override
            public String getClassName(MetaModuleSection section) {
                return "Export" + section.getDocument().getName(true) + "Action";
            }

            @Override
            public String getViewName(MetaModuleSection section) {
                MetaDocument doc = section.getDocument();
                return "Show" + doc.getName(true) + "AsCSV";
            }
        }
        ,
        EXPORTtoXML("Export.xml", "Show", OperationType.SINGLE, true){

            @Override
            public String getClassName(MetaModuleSection section) {
                return "Export" + section.getDocument().getName(true) + "Action";
            }

            @Override
            public String getViewName(MetaModuleSection section) {
                MetaDocument doc = section.getDocument();
                return "Show" + doc.getName(true) + "AsXML";
            }
        };

        private String action;
        private String view;
        private OperationType type;
        private boolean multiDocument;

        private SectionAction(String anAction, String aView, OperationType aType) {
            this(anAction, aView, aType, false);
        }

        private SectionAction(String anAction, String aView, OperationType aType, boolean aListDocument) {
            this.action = anAction;
            this.view = aView;
            this.type = aType;
            this.multiDocument = aListDocument;
        }

        public String getClassName(MetaModuleSection section) {
            switch (this.type) {
                case SINGLE: {
                    return this.action + section.getDocument().getName(this.multiDocument) + "Action";
                }
                case MULTIPLE_DIALOG: {
                    return ModuleActionsGenerator.getMultiOpDialogActionName(section);
                }
            }
            throw new AssertionError((Object)"Unsuported OperationType!");
        }

        public String getMappingName(MetaModuleSection section) {
            return this.getMappingName(section.getDocument());
        }

        public String getMappingName(MetaDocument doc) {
            return doc.getParentModule().getName().toLowerCase() + StringUtils.capitalize((String)doc.getName()) + this.action;
        }

        public String getViewName(MetaModuleSection section) {
            MetaDocument doc = section.getDocument();
            return this.view + doc.getName(this.multiDocument);
        }

        public String getViewPath(MetaModuleSection section) {
            return "/" + FileEntry.package2path(JspGenerator.getPackage(section.getModule())) + "/";
        }

        public String getViewFullName(MetaModuleSection section) {
            return this.getViewPath(section) + this.getViewName(section);
        }

        public boolean isIgnoreForSection(MetaModuleSection section) {
            return !this.multiDocument && (section.getDialogs().size() == 0 || StorageType.FEDERATION == section.getModule().getStorageType());
        }
    }

    private static enum OperationType {
        SINGLE,
        MULTIPLE_DIALOG;

    }
}

