/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.view.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.anotheria.anodoc.util.context.ContextManager;
import net.anotheria.anoprise.metafactory.Extension;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.asg.generator.FileEntry;
import net.anotheria.asg.generator.GeneratedClass;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.asg.generator.model.ServiceGenerator;
import net.anotheria.asg.generator.view.CMSMappingsConfiguratorGenerator;
import net.anotheria.asg.generator.view.action.AbstractActionGenerator;
import net.anotheria.asg.generator.view.action.ModuleActionsGenerator;
import net.anotheria.asg.generator.view.meta.MetaCustomSection;
import net.anotheria.asg.generator.view.meta.MetaModuleSection;
import net.anotheria.asg.generator.view.meta.MetaSection;
import net.anotheria.asg.generator.view.meta.MetaView;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.util.StringUtils;
import net.anotheria.util.sorter.SortType;
import net.anotheria.webutils.bean.NavigationItemBean;

public class BaseActionGenerator
extends AbstractActionGenerator {
    public FileEntry generate(List<MetaView> views) {
        return new FileEntry(this.generateBaseAction(views));
    }

    public GeneratedClass generateBaseAction(List<MetaView> views) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        clazz.setPackageName(BaseActionGenerator.getSharedActionPackageName());
        Collection<MetaModule> modules = GeneratorDataRegistry.getInstance().getModules();
        this.appendCommentLine(BaseActionGenerator.class.getName());
        clazz.addImport("net.anotheria.anoplass.api.APIFinder");
        clazz.addImport("net.anotheria.anosite.api.configuration.SystemConfigurationAPI");
        clazz.addImport("net.anotheria.util.StringUtils");
        clazz.addImport(ContextManager.class);
        clazz.addImport("net.anotheria.webutils.actions.*");
        clazz.addImport("jakarta.servlet.http.HttpServletRequest");
        clazz.addImport("jakarta.servlet.http.HttpServletResponse");
        clazz.addImport(ActionCommand.class);
        clazz.addImport(ActionMapping.class);
        clazz.addImport(NavigationItemBean.class);
        clazz.addImport(SortType.class);
        clazz.setAbstractClass(true);
        clazz.setParent("BaseAction");
        clazz.setName(BaseActionGenerator.getBaseActionName());
        this.startClassBody();
        this.appendGenerationPoint("generateBaseAction");
        this.appendStatement("public static final String BEAN_MAIN_NAVIGATION = \"mainNavigation\"");
        this.appendStatement("public static final String BEAN_CURRENT_SYSTEM = \"currentSystem\"");
        this.appendStatement("public static final String BEAN_CURRENT_APPLICATION = \"currentApplication\"");
        this.appendStatement("public static final String BEAN_SEARCH_SCOPE = \"searchScope\"");
        this.appendStatement("public static final String BEAN_DOCUMENT_DEF_NAME = \"documentName\"");
        this.appendStatement("public static final String BEAN_MODULE_DEF_NAME = \"moduleName\"");
        this.appendStatement("public static final String FLAG_DISABLED_SEARCH = \"disabledSearchFlag\"");
        this.appendStatement("public static final String PARAM_SORT_TYPE = " + this.quote("pSortType"));
        this.appendStatement("public static final String PARAM_SORT_TYPE_NAME = " + this.quote("pSortName"));
        this.appendStatement("public static final String PARAM_SORT_ORDER = " + this.quote("pSortOrder"));
        BaseActionGenerator.emptyline();
        this.appendCommentLine("prefixes for session attributes.");
        this.appendStatement("public static final String SA_PREFIX = " + this.quote("asg.sa."));
        this.appendStatement("public static final String SA_SORT_TYPE_PREFIX = SA_PREFIX+" + this.quote("sorttype."));
        this.appendStatement("public static final String SA_FILTER_PREFIX = SA_PREFIX+" + this.quote("filter."));
        BaseActionGenerator.emptyline();
        this.appendStatement("public static final String BEAN_VIEW_SELECTOR = " + this.quote("views"));
        BaseActionGenerator.emptyline();
        this.appendStatement("public static final String BEAN_USER_DEF_ID = " + this.quote("currentUserDefId"));
        BaseActionGenerator.emptyline();
        this.appendStatement("private static Object serviceInstantiationLock = new Object()");
        for (MetaModule m : modules) {
            this.appendStatement("private static volatile " + ServiceGenerator.getInterfaceName(m) + " " + ModuleActionsGenerator.getServiceInstanceName(m));
        }
        this.appendStatement("private static SystemConfigurationAPI systemConfigurationAPI = APIFinder.findAPI(SystemConfigurationAPI.class)");
        this.appendStatement("private static CMSUserManager userManager");
        clazz.addImport("net.anotheria.anosite.cms.user.CMSUserManager");
        clazz.addImport("net.anotheria.asg.util.locking.config.LockingConfig");
        this.appendStatement("private static LockingConfig lockConfig;");
        this.appendStatement("private static Logger log = LoggerFactory.getLogger(" + BaseActionGenerator.getBaseActionName() + ".class)");
        clazz.addImport("org.slf4j.Logger");
        clazz.addImport("org.slf4j.LoggerFactory");
        clazz.addImport("org.slf4j.MarkerFactory");
        this.appendString("static{");
        this.increaseIdent();
        clazz.addImport(MetaFactory.class);
        clazz.addImport(Extension.class);
        clazz.addImport(MetaFactoryException.class);
        for (MetaModule m : modules) {
            clazz.addImport(ServiceGenerator.getInterfaceImport(m));
        }
        BaseActionGenerator.emptyline();
        this.appendComment("//initializing user manager");
        this.appendString("try{");
        this.appendIncreasedStatement("userManager = CMSUserManager.getInstance()");
        this.appendString("}catch(Exception e){");
        this.appendIncreasedStatement("log.error(MarkerFactory.getMarker(\"FATAL\"), " + this.quote("Can't init user manager") + ", e)");
        this.appendString("}");
        BaseActionGenerator.emptyline();
        this.appendComment("initializing lockConfig");
        this.appendString("try{");
        this.appendIncreasedStatement("lockConfig = LockingConfig.getInstance()");
        this.appendString("}catch(Exception e){");
        this.appendIncreasedStatement("log.error(MarkerFactory.getMarker(\"FATAL\"), " + this.quote("Can't init lockConfig") + ", e)");
        this.appendString("}");
        this.closeBlock("");
        BaseActionGenerator.emptyline();
        this.appendString("public void preProcess(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception {");
        this.increaseIdent();
        this.appendString("super.preProcess(mapping, req, res);");
        BaseActionGenerator.emptyline();
        this.appendStatement("String userId = (String)getBeanFromSession(req, BEAN_USER_DEF_ID)");
        this.appendString("if (userId != null) {");
        this.increaseIdent();
        this.appendStatement("String login = CMSUserManager.getLoginById(userId)");
        this.appendStatement("addBeanToSession(req, BEAN_USER_ID, login)");
        this.closeBlock("if");
        BaseActionGenerator.emptyline();
        this.appendString("prepareMenu(req);");
        this.appendStatement("addBeanToSession(req, BEAN_CURRENT_SYSTEM, systemConfigurationAPI.getCurrentSystemExpanded())");
        this.appendStatement("addBeanToSession(req, BEAN_CURRENT_APPLICATION, systemConfigurationAPI.getCurrentApplication())");
        this.closeBlock("preProcess");
        BaseActionGenerator.emptyline();
        this.appendString("public abstract ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception;");
        BaseActionGenerator.emptyline();
        this.appendGenerationPoint("generateBaseAction");
        this.appendString("@Override");
        this.appendString("public ActionCommand execute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception {");
        this.increaseIdent();
        this.appendString("if (isAuthorizationRequired()){");
        this.increaseIdent();
        this.appendStatement("boolean authorized = checkAuthorization(req)");
        this.appendString("if (!authorized){");
        this.increaseIdent();
        this.appendStatement("String url = req.getRequestURI()");
        this.appendStatement("String qs = req.getQueryString()");
        this.appendString("if (!StringUtils.isEmpty(qs))");
        this.appendIncreasedStatement("url += \"?\"+qs;");
        this.appendStatement("addBeanToSession(req, BEAN_TARGET_ACTION, url)");
        this.appendStatement("String redUrl = " + this.quote(GeneratorDataRegistry.getInstance().getContext().getApplicationURLPath() + "/" + GeneratorDataRegistry.getInstance().getContext().getServletMapping() + "/login"));
        this.appendStatement("res.sendRedirect(redUrl)");
        this.appendStatement("return null");
        this.closeBlock("if");
        this.closeBlock("if");
        BaseActionGenerator.emptyline();
        this.appendStatement("checkAccessPermissions(req)");
        BaseActionGenerator.emptyline();
        this.appendStatement("addBeanToRequest(req, BEAN_DOCUMENT_DEF_NAME, getCurrentDocumentDefName())");
        this.appendStatement("addBeanToRequest(req, BEAN_MODULE_DEF_NAME, getActiveMainNavi())");
        BaseActionGenerator.emptyline();
        this.appendString("return anoDocExecute(mapping, req, res);");
        this.closeBlock("execute");
        BaseActionGenerator.emptyline();
        for (MetaModule m : modules) {
            this.appendString("protected " + ServiceGenerator.getInterfaceName(m) + " " + ModuleActionsGenerator.getServiceGetterCall(m) + "{");
            this.increaseIdent();
            this.appendString("if (" + ModuleActionsGenerator.getServiceInstanceName(m) + "==null){");
            this.increaseIdent();
            this.appendString("synchronized(serviceInstantiationLock){");
            this.increaseIdent();
            this.appendString("if (" + ModuleActionsGenerator.getServiceInstanceName(m) + "==null){");
            this.increaseIdent();
            this.appendString("try{");
            this.appendIncreasedStatement(ModuleActionsGenerator.getServiceInstanceName(m) + " = MetaFactory.get(" + ServiceGenerator.getInterfaceName(m) + ".class, Extension.EDITORINTERFACE)");
            this.appendString("}catch(MetaFactoryException e){");
            this.appendIncreasedStatement("log.error(MarkerFactory.getMarker(\"FATAL\"), " + this.quote("Can't load editor instance of module service " + m.getName()) + ", e)");
            this.appendString("}");
            this.closeBlock("... if null");
            this.closeBlock("... synch");
            this.closeBlock("... if");
            this.appendStatement("return " + ModuleActionsGenerator.getServiceInstanceName(m));
            this.closeBlock("end  " + ModuleActionsGenerator.getServiceGetterCall(m));
            BaseActionGenerator.emptyline();
        }
        this.appendString("protected boolean isAuthorizationRequired(){");
        this.increaseIdent();
        this.appendStatement("return false");
        this.closeBlockNEW();
        BaseActionGenerator.emptyline();
        clazz.addImport(List.class);
        clazz.addImport(ArrayList.class);
        this.appendStatement("private static final List<String> EMPTY_ROLE_LIST = new ArrayList<String>()");
        this.appendString("protected List<String> getRequiredRoles(){");
        this.increaseIdent();
        this.appendStatement("return EMPTY_ROLE_LIST");
        this.closeBlockNEW();
        BaseActionGenerator.emptyline();
        this.appendString("protected boolean checkAuthorization(HttpServletRequest req){");
        this.increaseIdent();
        this.appendStatement("String userId = (String )getBeanFromSession(req, BEAN_USER_ID)");
        this.appendString("if(userId == null)");
        this.appendIncreasedStatement("return false");
        this.appendStatement("ContextManager.getCallContext().setCurrentAuthor(userId)");
        this.appendStatement("return true");
        this.closeBlock("checkAuthorization");
        BaseActionGenerator.emptyline();
        this.appendString("public String getSubsystem() {");
        this.increaseIdent();
        this.appendStatement("return " + this.quote("asg"));
        this.closeBlockNEW();
        BaseActionGenerator.emptyline();
        this.appendString("protected String stripPath(String path){");
        this.increaseIdent();
        this.appendString("if (path==null || path.length()==0)");
        this.appendIncreasedStatement("throw new IllegalArgumentException(" + this.quote("path null or empty") + ")");
        this.appendStatement("return path.startsWith(" + this.quote("/") + ") ? path.substring(1) : path");
        this.closeBlockNEW();
        BaseActionGenerator.emptyline();
        this.appendString("protected boolean getSortOder(HttpServletRequest req){");
        this.increaseIdent();
        this.appendString("try{");
        this.increaseIdent();
        this.appendStatement("return getStringParameter(req, PARAM_SORT_ORDER).equals(\"ASC\") ? SortType.ASC : SortType.DESC");
        this.appendCatch("Exception");
        this.appendStatement("return SortType.ASC");
        this.closeBlockNEW();
        this.closeBlockNEW();
        BaseActionGenerator.emptyline();
        this.appendString("protected long getLockingTimeout(){");
        this.increaseIdent();
        this.appendStatement("return lockConfig.getTimeout()");
        this.closeBlockNEW();
        BaseActionGenerator.emptyline();
        this.appendString("protected boolean isAutoLockingEnabled(){");
        this.increaseIdent();
        this.appendStatement("return lockConfig.isAutolocking()");
        this.closeBlockNEW();
        BaseActionGenerator.emptyline();
        this.appendString("private void checkAccessPermissions(HttpServletRequest req){");
        this.increaseIdent();
        this.appendStatement("List<String> requiredRoles = getRequiredRoles()");
        this.appendString("if (requiredRoles==null || requiredRoles.size()==0)");
        this.appendIncreasedStatement("return");
        this.appendStatement("String userId = getUserId(req)");
        this.appendString("if (userId==null || userId.length()==0)");
        this.appendIncreasedStatement("throw new RuntimeException(" + this.quote("Permission denied, uid not found!") + ")");
        this.appendString("for (String role : requiredRoles){");
        this.increaseIdent();
        this.appendString("if (userManager.userInRole(userId, role))");
        this.appendIncreasedStatement("return");
        this.closeBlockNEW();
        this.appendStatement("throw new RuntimeException(" + this.quote("Permission denied, expected one of those: ") + "+requiredRoles)");
        this.closeBlockNEW();
        BaseActionGenerator.emptyline();
        this.appendString("protected boolean isUserInRole(HttpServletRequest req, String ... roles){");
        this.increaseIdent();
        this.appendStatement("String userId = getUserId(req)");
        this.appendString("if (userId==null)");
        this.appendIncreasedStatement("return false");
        this.appendString("for (String role : roles){");
        this.increaseIdent();
        this.appendString("if (userManager.userInRole(userId, role))");
        this.appendIncreasedStatement("return true");
        this.closeBlockNEW();
        this.appendStatement("return false");
        this.closeBlockNEW();
        this.appendString("protected void prepareMenu(HttpServletRequest req) {");
        this.increaseIdent();
        this.appendString("List<NavigationItemBean> navigation = getMainNavigation(req);");
        this.appendString("for (NavigationItemBean naviItem : navigation)");
        this.appendString("if (naviItem.isActive())");
        this.appendString("naviItem.setSubNavi(getSubNavigation());");
        this.appendString("addBeanToRequest(req, BEAN_MAIN_NAVIGATION, navigation);");
        this.closeBlockNEW();
        BaseActionGenerator.emptyline();
        this.appendString("protected abstract List<NavigationItemBean> getSubNavigation();");
        BaseActionGenerator.emptyline();
        this.appendString("protected List<NavigationItemBean> getMainNavigation(HttpServletRequest req) {");
        this.increaseIdent();
        this.appendString("List<NavigationItemBean> menu = new ArrayList<NavigationItemBean>();");
        MetaView toolsView = new MetaView("Tools");
        toolsView.setTitle("Tools");
        toolsView.setRequiredRoles(Arrays.asList("admin", "developer", "editor"));
        MetaCustomSection localizationBundleExport = new MetaCustomSection("LocalizationBundleExport");
        localizationBundleExport.setPath("asgLocalizationBundleExportView");
        MetaCustomSection localizationBundleImport = new MetaCustomSection("LocalizationBundleImport");
        localizationBundleImport.setPath("asgLocalizationBundleImportView");
        MetaCustomSection localizationBundleMakeParents = new MetaCustomSection("LocalizationBundleMakeParents");
        localizationBundleMakeParents.setPath("asgLocalizationBundleMakeParentsView");
        MetaCustomSection localizationBundleTranslation = new MetaCustomSection("LocalizationBundleTranslation");
        localizationBundleTranslation.setPath("asgLocalizationBundleTranslationView");
        MetaCustomSection localizationBundleSpecificTranslation = new MetaCustomSection("LocalizationBundleSpecificTranslation");
        localizationBundleSpecificTranslation.setPath("asgLocalizationBundleSpecificTranslationView");
        toolsView.addSection(localizationBundleExport);
        toolsView.addSection(localizationBundleImport);
        toolsView.addSection(localizationBundleMakeParents);
        toolsView.addSection(localizationBundleTranslation);
        toolsView.addSection(localizationBundleSpecificTranslation);
        views.add(toolsView);
        for (int i = 0; i < views.size(); ++i) {
            MetaView view = views.get(i);
            MetaSection first = view.getSections().get(0);
            String firstPath = null;
            if (first instanceof MetaModuleSection) {
                firstPath = CMSMappingsConfiguratorGenerator.getPath(((MetaModuleSection)first).getDocument(), "show");
            } else if (first instanceof MetaCustomSection) {
                firstPath = ((MetaCustomSection)first).getPath();
            } else {
                throw new RuntimeException("MetaSection extension Class: " + first.getClass());
            }
            String statement = "menu.add(makeMenuItemBean(" + this.quote(view.getTitle()) + ", " + this.quote(firstPath) + "))";
            if (view.getRequiredRoles() != null && view.getRequiredRoles().size() > 0) {
                Object roles = "";
                for (String r : view.getRequiredRoles()) {
                    if (((String)roles).length() > 0) {
                        roles = (String)roles + ", ";
                    }
                    roles = (String)roles + this.quote(r);
                }
                this.appendString("if (isUserInRole(req, new String[]{" + (String)roles + "})){");
                this.appendIncreasedStatement(statement);
                this.appendString("}");
                continue;
            }
            this.appendStatement(statement);
        }
        this.appendString("return menu;");
        this.closeBlockNEW();
        BaseActionGenerator.emptyline();
        this.appendString("protected abstract String getActiveMainNavi();");
        BaseActionGenerator.emptyline();
        this.appendString("protected abstract String getCurrentModuleDefName();");
        this.appendString("protected abstract String getCurrentDocumentDefName();");
        BaseActionGenerator.emptyline();
        this.appendComment("Get current application supported languages wrapper method.");
        this.appendString("public static List<String> getSupportedLanguages() {");
        this.increaseIdent();
        if (GeneratorDataRegistry.getInstance().getContext().areLanguagesSupported()) {
            clazz.addImport(GeneratorDataRegistry.getInstance().getContext().getServicePackageName(MetaModule.SHARED) + "." + StringUtils.capitalize((String)GeneratorDataRegistry.getInstance().getContext().getApplicationName()) + "LanguageUtils");
            this.appendStatement("return " + StringUtils.capitalize((String)GeneratorDataRegistry.getInstance().getContext().getApplicationName()) + "LanguageUtils.getSupportedLanguages()");
        } else {
            this.appendStatement("return new ArrayList<String>()");
        }
        this.closeBlockNEW();
        BaseActionGenerator.emptyline();
        this.appendString("private NavigationItemBean makeMenuItemBean(String title, String link){");
        this.increaseIdent();
        this.appendString("NavigationItemBean bean = new NavigationItemBean();");
        this.appendString("bean.setCaption(title);");
        this.appendString("bean.setLink(link);");
        this.appendString("bean.setActive(title.equals(getActiveMainNavi()));");
        this.appendString("return bean;");
        this.closeBlockNEW();
        BaseActionGenerator.emptyline();
        BaseActionGenerator.emptyline();
        BaseActionGenerator.emptyline();
        this.appendComment("Actually Session Attribute name for holding collection of locked objects....");
        this.appendStatement("private static final String LOCKED_OBJECTS_COLLECTION_SESSION_ATTRIBUTE_NAME = \"lokedDocumentsCollection\"");
        clazz.addImport("java.util.Collection");
        clazz.addImport("java.util.List");
        clazz.addImport("java.util.ArrayList");
        clazz.addImport("net.anotheria.asg.data.AbstractASGDocument");
        clazz.addImport("java.io.Serializable");
        BaseActionGenerator.emptyline();
        BaseActionGenerator.emptyline();
        this.appendComment("Adding attribute to the session list as LockedDocumentAttribute. for Locking and Unlocking functionality");
        this.appendString("protected void addLockedAttribute(HttpServletRequest req, AbstractASGDocument doc) {");
        this.increaseIdent();
        this.appendStatement("List<LockedDocumentAttribute> attributes = getLockedAttributesList(req)");
        this.appendStatement("LockedDocumentAttribute docAtt = new LockedDocumentAttribute(doc)");
        this.appendString("if (!attributes.contains(docAtt)) {");
        this.appendIncreasedStatement("attributes.add(docAtt)");
        this.appendIncreasedStatement("refreshSessionLockedAtribute(req, attributes)");
        this.appendString("}");
        this.closeBlockNEW();
        BaseActionGenerator.emptyline();
        this.appendComment("Putting attribute to the HttpSession.");
        this.appendString("private void refreshSessionLockedAtribute(HttpServletRequest req, List<LockedDocumentAttribute> attributes) {");
        this.increaseIdent();
        this.appendStatement("req.getSession().setAttribute(LOCKED_OBJECTS_COLLECTION_SESSION_ATTRIBUTE_NAME, attributes)");
        this.closeBlockNEW();
        BaseActionGenerator.emptyline();
        this.appendComment("Removing attributes List from session.");
        this.appendString("protected void removeLockedAttribute(HttpServletRequest req, AbstractASGDocument doc) {");
        this.increaseIdent();
        this.appendStatement("List<LockedDocumentAttribute> attributes = getLockedAttributesList(req)");
        this.appendStatement("LockedDocumentAttribute docAtt = new LockedDocumentAttribute(doc)");
        this.appendString("if (attributes.contains(docAtt)) {");
        this.appendIncreasedStatement("attributes.remove(docAtt)");
        this.appendIncreasedStatement("refreshSessionLockedAtribute(req, attributes)");
        this.appendString("}");
        this.closeBlockNEW();
        BaseActionGenerator.emptyline();
        this.appendComment("Return true if current document represented as  <a>LockedDocumentAttribute</a>. in session attributes list.");
        this.appendString("protected boolean containsLockedAttribute(HttpServletRequest req, AbstractASGDocument doc) {");
        this.increaseIdent();
        this.appendStatement("List<LockedDocumentAttribute> attributes = getLockedAttributesList(req)");
        this.appendStatement("LockedDocumentAttribute docAtt = new LockedDocumentAttribute(doc)");
        this.appendStatement("return attributes.contains(docAtt)");
        this.closeBlockNEW();
        BaseActionGenerator.emptyline();
        this.appendComment("Getting attributes List<LockedDocumentAttribute> - from session.");
        this.appendString("@SuppressWarnings(\"unchecked\")");
        this.appendString("private List<LockedDocumentAttribute> getLockedAttributesList(HttpServletRequest req) {");
        this.increaseIdent();
        this.appendStatement("List<LockedDocumentAttribute> attributes = null");
        this.appendStatement("Object sessionBean = req.getSession().getAttribute(LOCKED_OBJECTS_COLLECTION_SESSION_ATTRIBUTE_NAME)");
        this.appendString("if (sessionBean != null && sessionBean instanceof Collection<?>){ ");
        this.appendIncreasedStatement("attributes = (List<LockedDocumentAttribute>) sessionBean");
        this.appendString("}");
        this.appendStatement("return attributes == null ? new ArrayList<LockedDocumentAttribute>() : attributes");
        this.closeBlockNEW();
        BaseActionGenerator.emptyline();
        BaseActionGenerator.emptyline();
        this.appendComment("Actually simplest been - which should hold information  about document ID and Clazz.");
        this.appendString("public static class LockedDocumentAttribute implements Serializable{");
        BaseActionGenerator.emptyline();
        this.increaseIdent();
        this.appendComment("SerialVersionUID UID.");
        this.appendStatement("private static final long serialVersionUID = 1L");
        this.appendComment("LockedDocumentAttribute \"docId\".");
        this.appendStatement("private String docId");
        BaseActionGenerator.emptyline();
        this.appendComment("LockedDocumentAttribute \"documentClazz\".");
        this.appendStatement("private Class<? extends AbstractASGDocument> documentClazz");
        BaseActionGenerator.emptyline();
        this.appendComment("Public constructor.");
        this.appendString("public LockedDocumentAttribute(AbstractASGDocument doc) {");
        this.increaseIdent();
        this.appendStatement("this.docId = doc.getId()");
        this.appendStatement("this.documentClazz = doc.getClass()");
        this.closeBlockNEW();
        BaseActionGenerator.emptyline();
        this.appendString("public String getDocId() {");
        this.increaseIdent();
        this.appendStatement("return docId");
        this.closeBlockNEW();
        BaseActionGenerator.emptyline();
        this.appendString("public Class<? extends AbstractASGDocument> getDocumentClazz() {");
        this.increaseIdent();
        this.appendStatement("return documentClazz");
        this.closeBlockNEW();
        BaseActionGenerator.emptyline();
        this.appendString("public void setDocId(String aDocId) {");
        this.increaseIdent();
        this.appendStatement("this.docId = aDocId");
        this.closeBlockNEW();
        BaseActionGenerator.emptyline();
        this.appendString("public void setDocumentClazz(Class<? extends AbstractASGDocument> aDocumentClazz) {");
        this.increaseIdent();
        this.appendStatement("this.documentClazz = aDocumentClazz");
        this.closeBlockNEW();
        BaseActionGenerator.emptyline();
        this.appendString("public boolean equals(Object o) {");
        this.increaseIdent();
        this.appendStatement("return o!=null && (this == o || o instanceof LockedDocumentAttribute && ((LockedDocumentAttribute) o).getDocId().equals(getDocId()) && \n \t\t\t\t ((LockedDocumentAttribute) o).getDocumentClazz().equals(getDocumentClazz()))");
        this.closeBlockNEW();
        BaseActionGenerator.emptyline();
        this.appendString("public int hashCode() {");
        this.increaseIdent();
        this.appendStatement("int result = docId != null ? docId.hashCode() : 0");
        this.appendStatement("final int mult = 31");
        this.appendStatement("result = mult * result + (documentClazz != null ? documentClazz.hashCode() : 0)");
        this.appendStatement("return result");
        this.closeBlockNEW();
        BaseActionGenerator.emptyline();
        this.appendString("public String toString() {");
        this.increaseIdent();
        this.appendStatement("final StringBuilder sb = new StringBuilder()");
        this.appendStatement("sb.append(\"LockedDocumentAttribute\")");
        this.appendStatement("sb.append(\"{docId='\").append(docId).append('\\'')");
        this.appendStatement("sb.append(\", documentClazz=\").append(documentClazz)");
        this.appendStatement("sb.append('}')");
        this.appendStatement("return sb.toString()");
        this.closeBlockNEW();
        BaseActionGenerator.emptyline();
        BaseActionGenerator.emptyline();
        this.closeBlockNEW();
        return clazz;
    }
}

