/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.view.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.anotheria.asg.generator.AbstractGenerator;
import net.anotheria.asg.generator.FileEntry;
import net.anotheria.asg.generator.GeneratedClass;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.IGenerateable;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.asg.generator.view.CMSMappingsConfiguratorGenerator;
import net.anotheria.asg.generator.view.action.BaseActionGenerator;
import net.anotheria.asg.generator.view.meta.MetaCustomSection;
import net.anotheria.asg.generator.view.meta.MetaModuleSection;
import net.anotheria.asg.generator.view.meta.MetaSection;
import net.anotheria.asg.generator.view.meta.MetaView;
import net.anotheria.util.StringUtils;

public class BaseViewActionGenerator
extends AbstractGenerator {
    public FileEntry generate(IGenerateable g) {
        MetaView view = (MetaView)g;
        return new FileEntry(this.generateViewAction(view));
    }

    public static String getViewActionName(MetaView view) {
        return "Base" + StringUtils.capitalize((String)view.getName()) + "Action";
    }

    public GeneratedClass generateViewAction(MetaView view) {
        Object section;
        int i;
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        clazz.setPackageName(GeneratorDataRegistry.getInstance().getContext().getPackageName(MetaModule.SHARED) + ".action");
        List<MetaSection> sections = view.getSections();
        ArrayList<MetaModule> modules = new ArrayList<MetaModule>();
        for (i = 0; i < sections.size(); ++i) {
            section = sections.get(i);
            if (!(section instanceof MetaModuleSection) || modules.indexOf(((MetaModuleSection)section).getModule()) != -1) continue;
            modules.add(((MetaModuleSection)section).getModule());
        }
        clazz.addImport("java.util.List");
        clazz.addImport("java.util.ArrayList");
        clazz.addImport("net.anotheria.webutils.bean.NavigationItemBean");
        clazz.setAbstractClass(true);
        clazz.setParent(BaseActionGenerator.getBaseActionName());
        clazz.setName(BaseViewActionGenerator.getViewActionName(view));
        this.startClassBody();
        this.appendString("protected abstract String getTitle();");
        BaseViewActionGenerator.emptyline();
        this.appendString("@Override");
        this.appendString("protected String getActiveMainNavi(){");
        this.increaseIdent();
        this.appendStatement("return \"" + StringUtils.capitalize((String)view.getTitle()) + "\"");
        this.append(this.closeBlock());
        BaseViewActionGenerator.emptyline();
        if (view.getRequiredRoles() != null && view.getRequiredRoles().size() > 0) {
            clazz.addImport(Arrays.class);
            Object roles = "";
            for (String r : view.getRequiredRoles()) {
                if (((String)roles).length() > 0) {
                    roles = (String)roles + ", ";
                }
                roles = (String)roles + this.quote(r);
            }
            this.appendStatement("private static final List<String> MY_ROLES = Arrays.asList(new String[]{" + (String)roles + "})");
            this.appendString("protected List<String> getRequiredRoles(){");
            this.appendIncreasedStatement("return MY_ROLES");
            this.appendString("}");
        }
        BaseViewActionGenerator.emptyline();
        this.appendString("protected List<NavigationItemBean> getSubNavigation(){");
        this.appendStatement("List<NavigationItemBean> subNavi = new ArrayList<NavigationItemBean>()");
        this.increaseIdent();
        for (i = 0; i < sections.size(); ++i) {
            section = sections.get(i);
            if (section instanceof MetaModuleSection) {
                this.appendStatement("subNavi.add(makeMenuItemBean(" + this.quote(((MetaSection)section).getTitle()) + ", " + this.quote(CMSMappingsConfiguratorGenerator.getPath(((MetaModuleSection)section).getDocument(), "show")) + "))");
            }
            if (!(section instanceof MetaCustomSection)) continue;
            this.appendStatement("subNavi.add(makeMenuItemBean(" + this.quote(((MetaSection)section).getTitle()) + ", " + this.quote(((MetaCustomSection)section).getPath()) + "))");
        }
        this.appendStatement("return subNavi");
        this.append(this.closeBlock());
        BaseViewActionGenerator.emptyline();
        this.appendString("private NavigationItemBean makeMenuItemBean(String title, String link){");
        this.increaseIdent();
        this.appendString("NavigationItemBean bean = new NavigationItemBean();");
        this.appendString("bean.setCaption(title);");
        this.appendString("bean.setLink(link);");
        this.appendString("bean.setActive(title.equals(getTitle()));");
        this.appendString("return bean;");
        this.append(this.closeBlock());
        BaseViewActionGenerator.emptyline();
        this.appendString("protected boolean isAuthorizationRequired(){");
        this.increaseIdent();
        this.appendStatement("return true");
        this.closeBlockNEW();
        BaseViewActionGenerator.emptyline();
        return clazz;
    }
}

