/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.view.action;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.asg.generator.AbstractGenerator;
import net.anotheria.asg.generator.FileEntry;
import net.anotheria.asg.generator.GeneratedClass;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.asg.generator.view.CMSMappingsConfiguratorGenerator;
import net.anotheria.asg.generator.view.action.BaseActionGenerator;
import net.anotheria.asg.generator.view.meta.MetaModuleSection;
import net.anotheria.asg.generator.view.meta.MetaSection;
import net.anotheria.asg.generator.view.meta.MetaView;

public class CMSSearchActionsGenerator
extends AbstractGenerator {
    public List<FileEntry> generate(List<MetaView> views) {
        ArrayList<FileEntry> files = new ArrayList<FileEntry>();
        files.add(new FileEntry(this.generateSearchAction(views)));
        files.add(new FileEntry(this.generateSearchFB()));
        return files;
    }

    public static String getSearchPackageName() {
        return CMSMappingsConfiguratorGenerator.SharedAction.getPackageName();
    }

    public static String getCmsSearchActionName() {
        return CMSMappingsConfiguratorGenerator.SharedAction.SEARCH.getClassName();
    }

    public static String getSearchPageFullName() {
        return CMSSearchActionsGenerator.getSearchPackageName() + "." + CMSSearchActionsGenerator.getCmsSearchActionName();
    }

    private GeneratedClass generateSearchAction(List<MetaView> views) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        this.appendGenerationPoint("generateSearchAction");
        clazz.setPackageName(CMSSearchActionsGenerator.getSearchPackageName());
        clazz.addImport("java.util.ArrayList");
        clazz.addImport("java.util.List");
        clazz.addImport("java.util.Collections");
        clazz.addImport("jakarta.servlet.http.HttpServletRequest");
        clazz.addImport("jakarta.servlet.http.HttpServletResponse");
        clazz.addImport("net.anotheria.anodoc.query2.DocumentQuery");
        clazz.addImport("net.anotheria.anodoc.query2.QueryResult");
        clazz.addImport("net.anotheria.anodoc.query2.QueryResultEntry");
        clazz.addImport("net.anotheria.anodoc.query2.ResultEntryBean");
        clazz.addImport("net.anotheria.anodoc.query2.string.ContainsStringQuery");
        clazz.addImport("net.anotheria.asg.exception.ASGRuntimeException");
        clazz.addImport("net.anotheria.maf.action.ActionCommand");
        clazz.addImport("net.anotheria.maf.action.ActionMapping");
        clazz.addImport("net.anotheria.maf.bean.FormBean");
        clazz.addImport("net.anotheria.webutils.bean.NavigationItemBean");
        clazz.addImport("net.anotheria.util.StringUtils");
        clazz.addImport("net.anotheria.asg.data.DataObject");
        clazz.setParent(BaseActionGenerator.getBaseActionName());
        clazz.setName(CMSSearchActionsGenerator.getCmsSearchActionName());
        this.startClassBody();
        this.appendString("public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{");
        this.increaseIdent();
        this.appendStatement("String pCriteria = getStringParameter(req, " + this.quote("criteria") + ")");
        this.appendStatement("String pModule = getStringParameter(req, " + this.quote("module") + ")");
        this.appendStatement("String pDocument = getStringParameter(req, " + this.quote("document") + ")");
        this.appendStatement("String pSearchArea = req.getParameter(" + this.quote("searchArea") + ")");
        this.appendStatement("if (StringUtils.isEmpty(pSearchArea)) { pSearchArea = " + this.quote("cms") + ";}");
        this.appendString("DocumentQuery query = new ContainsStringQuery(\"*\" + pCriteria + \"*(\\r\\n)?\");");
        this.appendString("QueryResult result = executeQuery(pModule, pDocument, query, pSearchArea);");
        this.appendStatement("addBeanToRequest(req, BEAN_DOCUMENT_DEF_NAME, pDocument)");
        this.appendStatement("addBeanToRequest(req, BEAN_MODULE_DEF_NAME, pModule)");
        this.appendStatement("req.getSession().setAttribute(BEAN_SEARCH_SCOPE, pSearchArea)");
        this.appendString("if (result.getEntries().size()==0){");
        this.increaseIdent();
        this.appendString("req.setAttribute(\"srMessage\", \"Nothing found.\");");
        this.decreaseIdent();
        this.appendString("}else{");
        this.increaseIdent();
        this.appendString("List<ResultEntryBean> beans = new ArrayList<ResultEntryBean>(result.getEntries().size());");
        this.appendString("for (QueryResultEntry entry: result.getEntries()){");
        this.increaseIdent();
        this.appendStatement("DataObject doc = (DataObject)entry.getMatchedDocument()");
        this.appendString("ResultEntryBean bean = new ResultEntryBean();");
        this.appendString("bean.setEditLink(doc.getDefinedParentName().toLowerCase() + StringUtils.capitalize(doc.getDefinedName()) + \"Edit?pId=\" + doc.getId() + \"&ts=\" + System.currentTimeMillis());");
        this.appendString("bean.setDocumentId(entry.getMatchedDocument().getId());");
        this.appendString("bean.setDocumentName(doc.getDefinedName());");
        this.appendString("bean.setPropertyName(entry.getMatchedProperty().getId());");
        this.appendString("bean.setInfo(entry.getInfo().toHtml());");
        this.appendString("beans.add(bean);");
        this.closeBlock("");
        this.appendString("req.setAttribute(\"result\", beans);");
        this.closeBlock("");
        this.appendString("req.setAttribute(\"criteria\", pCriteria);");
        this.appendString("return mapping.success();");
        this.closeBlock("");
        CMSSearchActionsGenerator.emptyline();
        this.appendString("private QueryResult executeQuery(String sectionName, String documentName, DocumentQuery query, String searchArea) throws ASGRuntimeException{");
        this.increaseIdent();
        this.appendStatement("QueryResult ret = new QueryResult()");
        this.appendStatement("boolean wholeCms = \"cms\".equals(searchArea)");
        this.appendStatement("boolean wholeSection = wholeCms || \"section\".equals(searchArea)");
        for (MetaView view : views) {
            CMSSearchActionsGenerator.emptyline();
            this.appendString("if(wholeCms || sectionName.equals(\"" + view.getTitle() + "\")){");
            this.increaseIdent();
            for (MetaSection section : view.getSections()) {
                if (!(section instanceof MetaModuleSection)) continue;
                MetaModuleSection s = (MetaModuleSection)section;
                this.increaseIdent();
                this.appendString("if(wholeSection || documentName.equals(\"" + s.getDocument().getName() + "\"))");
                this.appendIncreasedString("ret.add(get" + s.getModule().getName() + "Service().executeQueryOn" + s.getDocument().getName(true) + "(query).getEntries());");
                this.decreaseIdent();
            }
            this.closeBlock("if");
        }
        CMSSearchActionsGenerator.emptyline();
        this.appendStatement("return ret");
        this.closeBlock("executeQuery");
        CMSSearchActionsGenerator.emptyline();
        this.appendString("@Override");
        this.appendString("protected String getActiveMainNavi() {");
        this.increaseIdent();
        this.appendStatement("return null");
        this.closeBlock("");
        CMSSearchActionsGenerator.emptyline();
        this.appendString("@Override");
        this.appendString("protected List<NavigationItemBean> getSubNavigation(){");
        this.increaseIdent();
        this.appendStatement("return Collections.emptyList()");
        this.closeBlock("");
        this.appendString("@Override");
        this.appendString("protected String getCurrentDocumentDefName() {");
        this.increaseIdent();
        this.appendStatement("return null");
        this.closeBlock("getCurrentDocumentDefName");
        CMSSearchActionsGenerator.emptyline();
        this.appendString("@Override");
        this.appendString("protected String getCurrentModuleDefName() {");
        this.increaseIdent();
        this.appendStatement("return null");
        this.closeBlock("getCurrentModuleDefName");
        CMSSearchActionsGenerator.emptyline();
        return clazz;
    }

    public static String getSearchFBPackageName() {
        return GeneratorDataRegistry.getInstance().getContext().getPackageName(MetaModule.SHARED) + ".bean";
    }

    public static String getSearchFBName() {
        return "SearchFB";
    }

    public static String getSearchFBFullName() {
        return CMSSearchActionsGenerator.getSearchFBPackageName() + "." + CMSSearchActionsGenerator.getSearchFBName();
    }

    private GeneratedClass generateSearchFB() {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        this.appendGenerationPoint("generateSearchFB");
        clazz.setPackageName(CMSSearchActionsGenerator.getSearchFBPackageName());
        clazz.setName(CMSSearchActionsGenerator.getSearchFBName());
        this.startClassBody();
        this.appendStatement("private String criteria");
        this.appendStatement("private String module");
        this.appendStatement("private String document");
        this.appendStatement("private String searchArea");
        CMSSearchActionsGenerator.emptyline();
        this.appendString("public String getCriteria() {");
        this.increaseIdent();
        this.appendStatement("return criteria");
        this.closeBlockNEW();
        CMSSearchActionsGenerator.emptyline();
        this.appendString("public void setCriteria(String criteria) {");
        this.increaseIdent();
        this.appendStatement("this.criteria = criteria");
        this.closeBlockNEW();
        CMSSearchActionsGenerator.emptyline();
        this.appendString("public String getModule() {");
        this.increaseIdent();
        this.appendStatement("return module");
        this.closeBlock("");
        CMSSearchActionsGenerator.emptyline();
        this.appendString("public void setModule(String module) {");
        this.increaseIdent();
        this.appendStatement("this.module = module");
        this.closeBlock("");
        CMSSearchActionsGenerator.emptyline();
        this.appendString("public String getDocument() {");
        this.increaseIdent();
        this.appendStatement("return document");
        this.closeBlock("");
        CMSSearchActionsGenerator.emptyline();
        this.appendString("public void setDocument(String document) {");
        this.increaseIdent();
        this.appendStatement("this.document = document");
        this.closeBlockNEW();
        CMSSearchActionsGenerator.emptyline();
        this.appendString("public String getSearchArea() {");
        this.increaseIdent();
        this.appendStatement("return searchArea");
        this.closeBlockNEW();
        CMSSearchActionsGenerator.emptyline();
        this.appendString("public void setSearchArea(String searchArea) {");
        this.increaseIdent();
        this.appendStatement("this.searchArea = searchArea");
        this.closeBlockNEW();
        CMSSearchActionsGenerator.emptyline();
        CMSSearchActionsGenerator.emptyline();
        return clazz;
    }
}

