/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.view.action;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.asg.generator.AbstractGenerator;
import net.anotheria.asg.generator.FileEntry;
import net.anotheria.asg.generator.GeneratedClass;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.asg.generator.view.CMSMappingsConfiguratorGenerator;
import net.anotheria.asg.generator.view.action.BaseActionGenerator;
import net.anotheria.asg.generator.view.meta.MetaView;
import net.anotheria.util.Date;

public class IndexPageActionGenerator
extends AbstractGenerator {
    public List<FileEntry> generate(List<MetaView> views) {
        ArrayList<FileEntry> files = new ArrayList<FileEntry>();
        files.add(new FileEntry(this.generateBaseAction(views)));
        files.add(new FileEntry(this.generateDocumentChangeFBviews(views)));
        return files;
    }

    public static String getIndexPagePackageName() {
        return GeneratorDataRegistry.getInstance().getContext().getPackageName(MetaModule.SHARED) + ".action";
    }

    public static String getDocumentChangeFBPackageName() {
        return GeneratorDataRegistry.getInstance().getContext().getPackageName(MetaModule.SHARED) + ".bean";
    }

    public static String getIndexPageActionName() {
        return "WelcomePageMafAction";
    }

    public static String getDocumentChangeFBName() {
        return "DocumentChangeFB";
    }

    public static String getIndexPageFullName() {
        return IndexPageActionGenerator.getIndexPagePackageName() + "." + IndexPageActionGenerator.getIndexPageActionName();
    }

    public static String getDocumentChangeFBFullName() {
        return IndexPageActionGenerator.getDocumentChangeFBPackageName() + "." + IndexPageActionGenerator.getDocumentChangeFBName();
    }

    public GeneratedClass generateBaseAction(List<MetaView> views) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        this.appendGenerationPoint("generateBaseAction");
        clazz.setPackageName(IndexPageActionGenerator.getIndexPagePackageName());
        clazz.addImport("jakarta.servlet.http.HttpServletRequest");
        clazz.addImport("jakarta.servlet.http.HttpServletResponse");
        IndexPageActionGenerator.emptyline();
        clazz.addImport("net.anotheria.maf.action.ActionCommand");
        clazz.addImport("net.anotheria.maf.action.ActionMapping");
        clazz.addImport("net.anotheria.maf.bean.FormBean");
        clazz.addImport("net.anotheria.webutils.bean.NavigationItemBean");
        clazz.addImport("net.anotheria.asg.util.DocumentChange");
        clazz.addImport("net.anotheria.asg.util.CmsChangesTracker");
        clazz.addImport(CMSMappingsConfiguratorGenerator.getClassName());
        clazz.addImport(IndexPageActionGenerator.getDocumentChangeFBPackageName() + ".DocumentChangeFB");
        clazz.addImport("java.util.Collections");
        clazz.addImport("java.util.Collection");
        clazz.addImport("java.util.List");
        clazz.addImport("java.util.ArrayList");
        clazz.addImport(Date.class);
        clazz.setParent(BaseActionGenerator.getBaseActionName());
        clazz.setName(IndexPageActionGenerator.getIndexPageActionName());
        this.startClassBody();
        this.appendString("protected boolean isAuthorizationRequired() {");
        this.increaseIdent();
        this.appendStatement("return true");
        this.append(this.closeBlock());
        IndexPageActionGenerator.emptyline();
        this.appendString("public ActionCommand anoDocExecute(ActionMapping aMapping, HttpServletRequest aReq, HttpServletResponse aRes) throws Exception {");
        this.increaseIdent();
        this.appendStatement("addBeanToRequest(aReq, FLAG_DISABLED_SEARCH, true)");
        this.appendString("Collection<DocumentChange> changes = CmsChangesTracker.getChanges();");
        this.appendString("List<DocumentChangeFB> myList = new ArrayList<DocumentChangeFB>();");
        this.appendString("for (net.anotheria.asg.util.DocumentChange el:changes){");
        this.appendString("DocumentChangeFB dcFB = new DocumentChangeFB();");
        this.appendString("dcFB.setUserName(el.getUserName());");
        this.appendString("dcFB.setDocumentName(el.getDocumentName());");
        this.appendString("dcFB.setParentName(el.getParentName());");
        this.appendString("dcFB.setDate(new Date(el.getTimestamp()));");
        this.appendString("dcFB.setAction(el.getAction().toString());");
        this.appendString("dcFB.setId(el.getId());");
        this.appendString("dcFB.setDocumentLink(CMSMappingsConfigurator.getActionPath(el.getParentName(), el.getDocumentName()));");
        this.appendString("myList.add(dcFB);");
        this.closeBlock("closed for");
        this.appendString("aReq.setAttribute(\"changes\", myList);");
        this.appendStatement("return aMapping.success()");
        this.append(this.closeBlock());
        IndexPageActionGenerator.emptyline();
        this.appendString("@Override");
        this.increaseIdent();
        this.appendStatement("protected String getActiveMainNavi() {");
        this.appendStatement("return null");
        this.append(this.closeBlock());
        IndexPageActionGenerator.emptyline();
        this.appendString("@Override");
        this.appendString("protected List<NavigationItemBean> getSubNavigation() {");
        this.increaseIdent();
        this.appendStatement("return Collections.emptyList()");
        this.append(this.closeBlock());
        IndexPageActionGenerator.emptyline();
        this.appendString("@Override");
        this.appendString("protected String getCurrentDocumentDefName() {");
        this.increaseIdent();
        this.appendStatement("return null");
        this.closeBlock("getCurrentDocumentDefName");
        IndexPageActionGenerator.emptyline();
        this.appendString("@Override");
        this.appendString("protected String getCurrentModuleDefName() {");
        this.increaseIdent();
        this.appendStatement("return null");
        this.closeBlock("getCurrentModuleDefName");
        IndexPageActionGenerator.emptyline();
        return clazz;
    }

    public GeneratedClass generateDocumentChangeFBviews(List<MetaView> views) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        this.appendGenerationPoint("generateDocumentChangeFBviews");
        clazz.setPackageName(IndexPageActionGenerator.getDocumentChangeFBPackageName());
        clazz.addImport("net.anotheria.maf.bean.FormBean");
        clazz.addImport("net.anotheria.util.Date");
        clazz.addInterface("FormBean");
        clazz.setName(IndexPageActionGenerator.getDocumentChangeFBName());
        this.startClassBody();
        this.appendString("private String userName;");
        this.appendString("private String documentName;");
        this.appendString("private String parentName;");
        this.appendString("private String documentLink;");
        this.appendString("private String action;");
        this.appendString("private Date date;");
        this.appendString("private String id;");
        IndexPageActionGenerator.emptyline();
        this.increaseIdent();
        this.appendString("public String getAction() {");
        this.appendIncreasedString("return action;");
        this.closeBlock("");
        IndexPageActionGenerator.emptyline();
        this.increaseIdent();
        this.appendString("public void setAction(String action) {");
        this.appendIncreasedString("this.action = action;");
        this.closeBlock("");
        IndexPageActionGenerator.emptyline();
        this.increaseIdent();
        this.appendString("public String getUserName() {");
        this.appendIncreasedString("return userName;");
        this.closeBlock("");
        IndexPageActionGenerator.emptyline();
        this.increaseIdent();
        this.appendString("public void setUserName(String userName) {");
        this.appendIncreasedString("this.userName = userName;");
        this.closeBlock("");
        IndexPageActionGenerator.emptyline();
        this.appendString("public String getId() {");
        this.appendIncreasedString("return id;");
        this.closeBlock("");
        IndexPageActionGenerator.emptyline();
        this.increaseIdent();
        this.appendString("public void setId(String id) {");
        this.appendIncreasedString("this.id = id;");
        this.closeBlock("");
        IndexPageActionGenerator.emptyline();
        this.increaseIdent();
        this.appendString("public String getDocumentName() {");
        this.appendIncreasedString("return documentName;");
        this.closeBlock("");
        IndexPageActionGenerator.emptyline();
        this.increaseIdent();
        this.appendString("public void setDocumentName(String documentName) {");
        this.appendIncreasedString("this.documentName = documentName;");
        this.closeBlock("");
        IndexPageActionGenerator.emptyline();
        this.increaseIdent();
        this.appendString("public String getParentName() {");
        this.appendIncreasedString("return parentName;");
        this.closeBlock("");
        IndexPageActionGenerator.emptyline();
        this.increaseIdent();
        this.appendString("public void setParentName(String parentName) {");
        this.appendIncreasedString("this.parentName = parentName;");
        this.closeBlock("");
        IndexPageActionGenerator.emptyline();
        this.increaseIdent();
        this.appendString("public String getDocumentLink() {");
        this.appendIncreasedString("return documentLink;");
        this.closeBlock("");
        IndexPageActionGenerator.emptyline();
        this.increaseIdent();
        this.appendString("public void setDocumentLink(String documentLink) {");
        this.appendIncreasedString("this.documentLink = documentLink;");
        this.closeBlock("");
        IndexPageActionGenerator.emptyline();
        this.increaseIdent();
        this.appendString("public Date getDate() {");
        this.appendIncreasedString("return date;");
        this.closeBlock("");
        IndexPageActionGenerator.emptyline();
        this.increaseIdent();
        this.appendString("public void setDate(Date date) {");
        this.appendIncreasedString("this.date = date;");
        this.closeBlock("");
        IndexPageActionGenerator.emptyline();
        IndexPageActionGenerator.emptyline();
        return clazz;
    }
}

