/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.view.action;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.anotheria.asg.exception.ConstantNotFoundException;
import net.anotheria.asg.generator.AbstractGenerator;
import net.anotheria.asg.generator.Context;
import net.anotheria.asg.generator.FileEntry;
import net.anotheria.asg.generator.GeneratedArtefact;
import net.anotheria.asg.generator.GeneratedClass;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.IGenerateable;
import net.anotheria.asg.generator.IGenerator;
import net.anotheria.asg.generator.forms.meta.MetaForm;
import net.anotheria.asg.generator.forms.meta.MetaFormField;
import net.anotheria.asg.generator.forms.meta.MetaFormSingleField;
import net.anotheria.asg.generator.forms.meta.MetaFormTableColumn;
import net.anotheria.asg.generator.forms.meta.MetaFormTableField;
import net.anotheria.asg.generator.forms.meta.MetaFormTableHeader;
import net.anotheria.asg.generator.meta.MetaContainerProperty;
import net.anotheria.asg.generator.meta.MetaDocument;
import net.anotheria.asg.generator.meta.MetaEnumerationProperty;
import net.anotheria.asg.generator.meta.MetaGenericListProperty;
import net.anotheria.asg.generator.meta.MetaLink;
import net.anotheria.asg.generator.meta.MetaListProperty;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.asg.generator.meta.MetaProperty;
import net.anotheria.asg.generator.meta.MetaTableProperty;
import net.anotheria.asg.generator.meta.StorageType;
import net.anotheria.asg.generator.model.AbstractDataObjectGenerator;
import net.anotheria.asg.generator.model.DataFacadeGenerator;
import net.anotheria.asg.generator.model.ServiceGenerator;
import net.anotheria.asg.generator.types.EnumTypeGenerator;
import net.anotheria.asg.generator.types.meta.EnumerationType;
import net.anotheria.asg.generator.util.DirectLink;
import net.anotheria.asg.generator.view.CMSMappingsConfiguratorGenerator;
import net.anotheria.asg.generator.view.action.BaseActionGenerator;
import net.anotheria.asg.generator.view.action.BaseViewActionGenerator;
import net.anotheria.asg.generator.view.action.ModuleBeanGenerator;
import net.anotheria.asg.generator.view.meta.MetaDecorator;
import net.anotheria.asg.generator.view.meta.MetaDialog;
import net.anotheria.asg.generator.view.meta.MetaFieldElement;
import net.anotheria.asg.generator.view.meta.MetaFilter;
import net.anotheria.asg.generator.view.meta.MetaListElement;
import net.anotheria.asg.generator.view.meta.MetaModuleSection;
import net.anotheria.asg.generator.view.meta.MetaView;
import net.anotheria.asg.generator.view.meta.MetaViewElement;
import net.anotheria.asg.generator.view.meta.MultilingualFieldElement;
import net.anotheria.asg.util.action.ActionUtils;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.util.ExecutionTimer;
import net.anotheria.util.StringUtils;

public class ModuleActionsGenerator
extends AbstractGenerator
implements IGenerator {
    private MetaView view;
    static final boolean USE_MULTIOP_ACTIONS = true;
    public static final String exportXMLSufix = "XML";
    public static final String exportCSVSufix = "CSV";

    public ModuleActionsGenerator(MetaView aView) {
        this.view = aView;
    }

    @Override
    public List<FileEntry> generate(IGenerateable g) {
        ArrayList<FileEntry> files = new ArrayList<FileEntry>();
        MetaModuleSection section = (MetaModuleSection)g;
        ExecutionTimer timer = new ExecutionTimer(section.getTitle() + " Actions");
        timer.startExecution(section.getModule().getName() + "-" + section.getTitle() + "-All");
        timer.startExecution(section.getModule().getName() + "-view");
        files.add(new FileEntry(this.generateBaseAction(section)));
        files.add(new FileEntry(this.generateShowAction(section)));
        files.add(new FileEntry(this.generateMultiOpAction(section)));
        files.add(new FileEntry(this.generateSearchAction(section)));
        files.add(new FileEntry(this.generateDeleteAction(section)));
        files.add(new FileEntry(this.generateDuplicateAction(section)));
        files.add(new FileEntry(this.generateVersionInfoAction(section)));
        files.add(new FileEntry(this.generateExportAction(section)));
        files.add(new FileEntry(this.generateTransferAction(section)));
        if (section.getModule().getStorageType() == StorageType.CMS) {
            files.add(new FileEntry(this.generateTransferAction(section)));
            files.add(new FileEntry(this.generateRestAction(section)));
        }
        timer.stopExecution(section.getModule().getName() + "-view");
        try {
            if (section.getDialogs().size() > 0) {
                timer.startExecution(section.getModule().getName() + "-dialog-base");
                files.add(new FileEntry(this.generateMultiOpDialogAction(section)));
                files.add(new FileEntry(this.generateUpdateAction(section)));
                files.add(new FileEntry(this.generateEditAction(section)));
                files.add(new FileEntry(this.generateNewAction(section)));
                timer.stopExecution(section.getModule().getName() + "-dialog-base");
                MetaDocument doc = section.getDocument();
                timer.startExecution(section.getModule().getName() + "-dialog-copylang");
                if (GeneratorDataRegistry.hasLanguageCopyMethods(doc)) {
                    files.add(new FileEntry(this.generateLanguageCopyAction(section)));
                    files.add(new FileEntry(this.generateSwitchMultilingualityAction(section)));
                }
                timer.stopExecution(section.getModule().getName() + "-dialog-copylang");
                timer.startExecution(section.getModule().getName() + "-dialog-container");
                for (int p = 0; p < doc.getProperties().size(); ++p) {
                    MetaProperty pp = doc.getProperties().get(p);
                    if (!(pp instanceof MetaContainerProperty)) continue;
                    MetaContainerProperty mcp = (MetaContainerProperty)pp;
                    files.add(new FileEntry(this.generateContainerMultiOpAction(section, mcp)));
                    files.add(new FileEntry(this.generateContainerShowAction(section, mcp)));
                    files.add(new FileEntry(this.generateContainerAddRowAction(section, mcp)));
                    files.add(new FileEntry(this.generateContainerQuickAddAction(section, mcp)));
                    files.add(new FileEntry(this.generateContainerDeleteEntryAction(section, mcp)));
                    files.add(new FileEntry(this.generateContainerMoveEntryAction(section, mcp)));
                }
                timer.stopExecution(section.getModule().getName() + "-dialog-container");
            }
        }
        catch (Exception ignored) {
            System.out.println("Exception occured in generation of section " + section);
            ignored.printStackTrace();
        }
        timer.startExecution(section.getModule().getName() + "-additional");
        MetaDocument targetDocument = section.getDocument();
        List<MetaProperty> links = targetDocument.getLinks();
        if (links.size() > 0) {
            files.add(new FileEntry(this.generateShowQueryAction(section)));
            files.add(new FileEntry(this.generateExecuteQueryAction(section)));
        }
        timer.stopExecution(section.getModule().getName() + "-additional");
        timer.stopExecution(section.getModule().getName() + "-" + section.getTitle() + "-All");
        return files;
    }

    private GeneratedArtefact generateExportAction(MetaModuleSection section) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        MetaDocument doc = section.getDocument();
        List<MetaViewElement> elements = section.getElements();
        boolean containsComparable = section.containsComparable();
        clazz.setPackageName(ModuleActionsGenerator.getPackage(section.getModule()));
        clazz.addImport("java.util.List");
        clazz.addImport("java.util.ArrayList");
        clazz.addImport("net.anotheria.asg.util.filter.DocumentFilter");
        clazz.addImport("net.anotheria.util.xml.XMLNode");
        this.addStandardActionImports(clazz);
        clazz.addImport(DataFacadeGenerator.getDocumentImport(doc));
        clazz.addImport(DataFacadeGenerator.getSortTypeImport(doc));
        clazz.addImport("org.slf4j.Logger");
        clazz.addImport("org.slf4j.LoggerFactory");
        clazz.addImport("org.slf4j.MarkerFactory");
        for (MetaViewElement element : elements) {
            MetaFieldElement field;
            MetaProperty p;
            if (!(element instanceof MetaFieldElement) || !((p = doc.getField((field = (MetaFieldElement)element).getName())) instanceof MetaEnumerationProperty)) continue;
            MetaEnumerationProperty enumeration = (MetaEnumerationProperty)p;
            EnumerationType type = (EnumerationType)GeneratorDataRegistry.getInstance().getType(enumeration.getEnumeration());
            clazz.addImport(EnumTypeGenerator.getEnumImport(type));
        }
        clazz.setName(ModuleActionsGenerator.getExportActionName(section));
        clazz.setParent(ModuleActionsGenerator.getBaseActionName(section));
        this.startClassBody();
        this.appendStatement("public static final String SA_SORT_TYPE = SA_SORT_TYPE_PREFIX+", this.quote(doc.getName()));
        this.appendStatement("public static final String SA_FILTER = SA_FILTER_PREFIX+", this.quote(doc.getName()));
        this.appendStatement("private static final List<String> ITEMS_ON_PAGE_SELECTOR = java.util.Arrays.asList(new String[]{\"5\",\"10\",\"20\",\"25\",\"50\",\"100\",\"500\",\"1000\"})");
        this.appendStatement("private static final Logger log = LoggerFactory.getLogger(" + ModuleActionsGenerator.getExportActionName(section) + ".class)");
        if (containsComparable) {
            clazz.addImport("net.anotheria.util.sorter.Sorter");
            clazz.addImport("net.anotheria.util.sorter.QuickSorter");
            clazz.addImport(ModuleBeanGenerator.getListItemBeanSortTypeImport(GeneratorDataRegistry.getInstance().getContext(), doc));
            this.appendStatement("private Sorter<" + doc.getName() + "> sorter");
            ModuleActionsGenerator.emptyline();
        }
        if (section.getFilters().size() > 0) {
            for (MetaFilter f : section.getFilters()) {
                this.appendStatement("private DocumentFilter " + ModuleActionsGenerator.getFilterVariableName(f));
            }
            ModuleActionsGenerator.emptyline();
        }
        this.appendString("public " + ModuleActionsGenerator.getExportActionName(section) + "(){");
        this.increaseIdent();
        this.appendStatement("super()");
        if (containsComparable) {
            this.appendStatement("sorter = new QuickSorter<" + doc.getName() + ">()");
        }
        if (section.getFilters().size() > 0) {
            this.appendString("try{ ");
            this.increaseIdent();
            for (MetaFilter f : section.getFilters()) {
                this.appendStatement(ModuleActionsGenerator.getFilterVariableName(f), " = (DocumentFilter) Class.forName(", this.quote(f.getClassName()), ").newInstance()");
            }
            this.decreaseIdent();
            this.appendString("} catch(Exception e){");
            this.appendIncreasedStatement("log.error(MarkerFactory.getMarker(\"FATAL\"), \"Couldn't instantiate filter:\", e)");
            this.appendString("}");
        }
        this.closeBlockNEW();
        this.appendString(this.getExecuteDeclaration());
        this.increaseIdent();
        if (section.getFilters().size() > 0) {
            for (int i = 0; i < section.getFilters().size(); ++i) {
                String filterParameterName = "filterParameter" + i;
                this.appendStatement("String filterParameter" + i + " = " + this.quote(""));
                this.appendString("try{ ");
                this.appendIncreasedStatement(filterParameterName + " = getStringParameter(req, " + this.quote("pFilter" + i) + ")");
                this.appendIncreasedStatement("addBeanToSession(req, SA_FILTER+" + this.quote(i) + ", " + filterParameterName + ")");
                this.appendString("}catch(Exception ignored){");
                this.increaseIdent();
                this.appendCommentLine("no filter parameter given, tring to check in the session.");
                this.appendStatement(filterParameterName + " = (String)getBeanFromSession(req, SA_FILTER+" + this.quote(i) + ")");
                this.appendString("if (" + filterParameterName + "==null)");
                this.appendIncreasedStatement(filterParameterName + " = " + this.quote(""));
                this.closeBlockNEW();
                this.appendStatement("req.setAttribute(" + this.quote("currentFilterParameter" + i) + ", " + filterParameterName + ")");
                ModuleActionsGenerator.emptyline();
            }
        }
        if (containsComparable) {
            String sortType = ModuleBeanGenerator.getListItemBeanSortTypeName(doc);
            this.appendStatement("int sortMethod = " + sortType + ".SORT_BY_DEFAULT");
            this.appendStatement("boolean sortOrder = " + sortType + ".ASC");
            this.appendStatement("boolean sortParamSet = false");
            ModuleActionsGenerator.emptyline();
            this.appendString("try{");
            this.appendIncreasedStatement("sortMethod = getIntParameter(req, PARAM_SORT_TYPE)");
            this.appendIncreasedStatement("sortParamSet = true");
            this.appendString("}catch(Exception ignored){}");
            ModuleActionsGenerator.emptyline();
            this.appendString("try{");
            this.appendIncreasedStatement("String sortMethodName = getStringParameter(req, PARAM_SORT_TYPE_NAME)");
            this.appendIncreasedStatement("sortMethod = " + sortType + ".name2method(sortMethodName)");
            this.appendIncreasedStatement("sortParamSet = true");
            this.appendString("}catch(Exception ignored){}");
            ModuleActionsGenerator.emptyline();
            this.appendString("try{");
            this.increaseIdent();
            this.appendString("sortOrder = getStringParameter(req, PARAM_SORT_ORDER).equals(" + this.quote("ASC") + ") ? ");
            this.appendIncreasedStatement(sortType + ".ASC : " + sortType + ".DESC");
            this.decreaseIdent();
            this.appendString("}catch(Exception ignored){}");
            ModuleActionsGenerator.emptyline();
            String docSortType = doc.getName() + "SortType";
            this.appendStatement(sortType + " sessionSortType  = null");
            this.appendStatement(docSortType + " sortType = null");
            this.appendString("if (sortParamSet){");
            this.increaseIdent();
            this.appendStatement("sessionSortType = new " + sortType + "(sortMethod, sortOrder)");
            this.appendStatement("sortType = new " + docSortType + "(sortMethod, sortOrder)");
            this.appendStatement("addBeanToSession(req, SA_SORT_TYPE, sessionSortType)");
            this.decreaseIdent();
            this.appendString("}else{");
            this.increaseIdent();
            this.appendStatement("sessionSortType = (" + sortType + ")getBeanFromSession(req, SA_SORT_TYPE)");
            this.appendStatement("sortType = sessionSortType == null ? new " + docSortType + "(sortMethod, sortOrder) : new " + docSortType + "(sessionSortType.getSortBy(), sessionSortType.getSortOrder())");
            this.appendStatement("sessionSortType = sessionSortType == null ? new " + sortType + "(sortMethod, sortOrder) : sessionSortType");
            this.closeBlockNEW();
            this.appendStatement("req.setAttribute(" + this.quote("currentSortCode") + ", sessionSortType.getMethodAndOrderCode())");
            ModuleActionsGenerator.emptyline();
        }
        String listName = doc.getMultiple().toLowerCase();
        if (section.getFilters().size() > 0) {
            String unfilteredListName = "_unfiltered_" + listName;
            this.appendStatement("List<" + doc.getName() + "> " + unfilteredListName + " = " + ModuleActionsGenerator.getServiceGetterCall(section.getModule()) + ".get" + doc.getMultiple() + "()");
            this.appendStatement("List<" + doc.getName() + "> " + listName + " = new ArrayList<" + doc.getName() + ">()");
            this.appendString("for (" + doc.getName() + " element : " + unfilteredListName + " ){");
            this.increaseIdent();
            this.appendStatement("boolean mayPass = true");
            for (int i = 0; i < section.getFilters().size(); ++i) {
                MetaFilter activeFilter = section.getFilters().get(i);
                String filterVarName = ModuleActionsGenerator.getFilterVariableName(activeFilter);
                this.appendStatement("mayPass = mayPass && (" + filterVarName + ".mayPass( element, " + this.quote(activeFilter.getFieldName()) + ", filterParameter" + i + "))");
            }
            this.appendString("if (mayPass)");
            this.append(this.writeIncreasedStatement(listName + ".add(element)"));
            this.closeBlockNEW();
        } else {
            this.appendStatement("List<" + doc.getName() + "> " + listName + " = " + ModuleActionsGenerator.getServiceGetterCall(section.getModule()) + ".get" + doc.getMultiple() + "()");
        }
        if (containsComparable) {
            this.appendStatement(listName + " = sorter.sort(" + listName + ", sortType)");
        }
        ModuleActionsGenerator.emptyline();
        this.appendStatement("addBeanToRequest(req, " + this.quote(listName) + ", " + listName + ")");
        ModuleActionsGenerator.emptyline();
        this.appendStatement("XMLNode beans = " + ModuleActionsGenerator.getServiceGetterCall(section.getModule()) + ".export" + doc.getMultiple() + "ToXML(" + listName + ")");
        ModuleActionsGenerator.emptyline();
        ModuleActionsGenerator.emptyline();
        this.appendComment("for XML node - page");
        this.appendStatement("addBeanToRequest(req, " + this.quote(listName + exportXMLSufix) + ", beans)");
        this.appendComment("for CSV - page");
        this.appendStatement("addBeanToRequest(req, " + this.quote(listName + exportCSVSufix) + ", " + listName + ")");
        for (MetaFilter f : section.getFilters()) {
            this.appendStatement("addBeanToRequest(req, ", this.quote(ModuleActionsGenerator.getFilterVariableName(f)), ", ", ModuleActionsGenerator.getFilterVariableName(f), ".getTriggerer(\"\"))");
        }
        this.appendStatement("return mapping.success()");
        this.closeBlockNEW();
        ModuleActionsGenerator.emptyline();
        return clazz;
    }

    public static String getBaseActionName(MetaModuleSection section) {
        return "Base" + ModuleActionsGenerator.getActionSuffix(section);
    }

    public static String getActionSuffix(MetaModuleSection section) {
        return section.getDocument().getName() + "Action";
    }

    public static String getMultiOpActionName(MetaModuleSection section) {
        return "MultiOp" + section.getDocument().getMultiple() + "Action";
    }

    public static String getMultiOpDialogActionName(MetaModuleSection section) {
        return "MultiOpDialog" + section.getDocument().getMultiple() + "Action";
    }

    public static String getShowActionName(MetaModuleSection section) {
        return "Show" + section.getDocument().getMultiple() + "Action";
    }

    public static String getExportActionName(MetaModuleSection section) {
        return "Export" + section.getDocument().getMultiple() + "Action";
    }

    public static String getSearchActionName(MetaModuleSection section) {
        return "Search" + section.getDocument().getMultiple() + "Action";
    }

    public static String getShowQueryActionName(MetaModuleSection section) {
        return "Show" + section.getDocument().getMultiple() + "QueriesAction";
    }

    public static String getExecuteQueryActionName(MetaModuleSection section) {
        return "Execute" + section.getDocument().getMultiple() + "QueriesAction";
    }

    public static String getEditActionName(MetaModuleSection section) {
        return "Edit" + ModuleActionsGenerator.getActionSuffix(section);
    }

    public static String getUpdateActionName(MetaModuleSection section) {
        return "Update" + ModuleActionsGenerator.getActionSuffix(section);
    }

    public static String getLanguageCopyActionName(MetaModuleSection section) {
        return "CopyLang" + ModuleActionsGenerator.getActionSuffix(section);
    }

    public static String getSwitchMultilingualityActionName(MetaModuleSection section) {
        return "SwitchMultilang" + ModuleActionsGenerator.getActionSuffix(section);
    }

    public static String getVersionInfoActionName(MetaModuleSection section) {
        return "VersionInfo" + ModuleActionsGenerator.getActionSuffix(section);
    }

    public static String getNewActionName(MetaModuleSection section) {
        return "New" + ModuleActionsGenerator.getActionSuffix(section);
    }

    public static String getCreateActionName(MetaModuleSection section) {
        return "Create" + ModuleActionsGenerator.getActionSuffix(section);
    }

    public static String getDeleteActionName(MetaModuleSection section) {
        return "Delete" + ModuleActionsGenerator.getActionSuffix(section);
    }

    public static String getDuplicateActionName(MetaModuleSection section) {
        return "Duplicate" + ModuleActionsGenerator.getActionSuffix(section);
    }

    public static String getLockActionName(MetaModuleSection section) {
        return "Lock" + ModuleActionsGenerator.getActionSuffix(section);
    }

    public static String getUnLockActionName(MetaModuleSection section) {
        return "UnLock" + ModuleActionsGenerator.getActionSuffix(section);
    }

    public static String getTransferActionName(MetaModuleSection section) {
        return "Transfer" + ModuleActionsGenerator.getActionSuffix(section);
    }

    public static String getResourceActionName(MetaModuleSection section) {
        return section.getDocument().getName() + "RestResource";
    }

    private GeneratedClass generateMultiOpAction(MetaModuleSection section) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        MetaDocument doc = section.getDocument();
        clazz.setPackageName(ModuleActionsGenerator.getPackage(section.getModule()));
        clazz.addImport("net.anotheria.util.NumberUtils");
        this.addStandardActionImports(clazz);
        clazz.addImport(DataFacadeGenerator.getDocumentFactoryImport(GeneratorDataRegistry.getInstance().getContext(), doc));
        clazz.addImport(DataFacadeGenerator.getDocumentImport(doc));
        clazz.setName(ModuleActionsGenerator.getMultiOpActionName(section));
        clazz.setParent(ModuleActionsGenerator.getBaseActionName(section));
        this.startClassBody();
        this.appendString(this.getExecuteDeclaration(null));
        this.increaseIdent();
        this.appendStatement("String path = stripPath(mapping.getPath())");
        this.writePathResolveForMultiOpAction(doc, "versioninfo");
        this.appendStatement("throw new IllegalArgumentException(" + this.quote("Unknown path: ") + "+path)");
        this.closeBlockNEW();
        ModuleActionsGenerator.emptyline();
        this.generateVersionInfoActionMethod(section, CMSMappingsConfiguratorGenerator.getPath(doc, "versioninfo"));
        return clazz;
    }

    private GeneratedClass generateMultiOpDialogAction(MetaModuleSection section) {
        MetaProperty p;
        MetaFieldElement field;
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        this.appendGenerationPoint("generateMultiOpDialogAction");
        MetaDocument doc = section.getDocument();
        MetaDialog dialog = section.getDialogs().get(0);
        boolean cMSStorageType = StorageType.CMS.equals((Object)doc.getParentModule().getStorageType());
        clazz.setName(ModuleActionsGenerator.getMultiOpDialogActionName(section));
        clazz.setParent(ModuleActionsGenerator.getBaseActionName(section));
        clazz.setPackageName(ModuleActionsGenerator.getPackage(section.getModule()));
        Context context = GeneratorDataRegistry.getInstance().getContext();
        clazz.addImport("net.anotheria.util.NumberUtils");
        this.addStandardActionImports(clazz);
        clazz.addImport(DataFacadeGenerator.getDocumentFactoryImport(context, doc));
        clazz.addImport(DataFacadeGenerator.getDocumentImport(doc));
        clazz.addImport(ModuleBeanGenerator.getDialogBeanImport(dialog, doc));
        clazz.addImport(PopulateUtility.class);
        if (cMSStorageType) {
            clazz.addImport("net.anotheria.asg.data.LockableObject");
            clazz.addImport("net.anotheria.asg.util.locking.helper.DocumentLockingHelper");
        }
        if (GeneratorDataRegistry.getInstance().getContext().areLanguagesSupported() && doc.isMultilingual()) {
            clazz.addImport("net.anotheria.asg.data.MultilingualObject");
        }
        boolean validationAwareAction = false;
        List<MetaViewElement> elements = ModuleActionsGenerator.createMultilingualList(dialog.getElements(), doc);
        for (MetaViewElement elem : elements) {
            if (!(elem instanceof MetaFieldElement)) continue;
            field = (MetaFieldElement)elem;
            p = doc.getField(field.getName());
            if (p.getType() == MetaProperty.Type.IMAGE || p.getType() == MetaProperty.Type.LIST && ((MetaListProperty)p).getContainedProperty().getType() == MetaProperty.Type.IMAGE) {
                clazz.addImport("net.anotheria.webutils.filehandling.actions.FileStorage");
                clazz.addImport("net.anotheria.webutils.filehandling.beans.TemporaryFileHolder");
                clazz.addImport("java.lang.reflect.Method");
                clazz.addImport("java.lang.reflect.InvocationTargetException");
                clazz.addImport("net.anotheria.util.StringUtils");
                clazz.addImport("org.apache.commons.text.WordUtils");
                break;
            }
            if (!elem.isValidated()) continue;
            validationAwareAction = true;
            clazz.addInterface("net.anotheria.maf.validation.ValidationAware");
            clazz.addImport("net.anotheria.maf.validation.ValidationError");
            clazz.addImport(List.class);
        }
        ModuleActionsGenerator.emptyline();
        this.startClassBody();
        this.generateExecuteMethod(clazz, dialog, doc);
        this.appendString(this.getExecuteDeclaration(null));
        this.increaseIdent();
        this.appendStatement("String path = stripPath(mapping.getPath())");
        this.writePathResolveForMultiOpAction(doc, "delete");
        this.writePathResolveForMultiOpAction(doc, "duplicate");
        this.writePathResolveForMultiOpAction(doc, "update");
        this.writePathResolveForMultiOpAction(doc, "close");
        if (GeneratorDataRegistry.getInstance().getContext().areLanguagesSupported() && doc.isMultilingual()) {
            this.writePathResolveForMultiOpAction(doc, "copyLang");
            this.writePathResolveForMultiOpAction(doc, "switchMultilang");
        }
        if (cMSStorageType) {
            this.writePathResolveForMultiOpAction(doc, "lock");
            this.writePathResolveForMultiOpAction(doc, "unLock");
        }
        this.appendStatement("throw new IllegalArgumentException(" + this.quote("Unknown path: ") + "+path)");
        this.closeBlockNEW();
        ModuleActionsGenerator.emptyline();
        this.generateDeleteActionMethod(section, CMSMappingsConfiguratorGenerator.getPath(doc, "delete"));
        ModuleActionsGenerator.emptyline();
        this.generateDuplicateActionMethod(section, CMSMappingsConfiguratorGenerator.getPath(doc, "duplicate"));
        ModuleActionsGenerator.emptyline();
        this.generateUpdateActionMethod(section, CMSMappingsConfiguratorGenerator.getPath(doc, "update"));
        ModuleActionsGenerator.emptyline();
        if (GeneratorDataRegistry.getInstance().getContext().areLanguagesSupported() && doc.isMultilingual()) {
            this.generateLanguageCopyActionMethod(section, CMSMappingsConfiguratorGenerator.getPath(doc, "copyLang"));
            ModuleActionsGenerator.emptyline();
            this.generateSwitchMultilingualityActionMethod(section, CMSMappingsConfiguratorGenerator.getPath(doc, "switchMultilang"));
            ModuleActionsGenerator.emptyline();
        }
        if (cMSStorageType) {
            this.generateLockManagementActionMethod(section, CMSMappingsConfiguratorGenerator.getPath(doc, "lock"), true);
            ModuleActionsGenerator.emptyline();
            this.generateLockManagementActionMethod(section, CMSMappingsConfiguratorGenerator.getPath(doc, "unLock"), false);
            ModuleActionsGenerator.emptyline();
            this.generateRedirectPathMethod(section);
            ModuleActionsGenerator.emptyline();
        }
        this.generateCloseAction(section, CMSMappingsConfiguratorGenerator.getPath(doc, "close"));
        ModuleActionsGenerator.emptyline();
        if (validationAwareAction) {
            clazz.addImport("net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil");
            clazz.addImport("net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry");
            clazz.addImport("java.util.Map");
            clazz.addImport("java.util.HashMap");
            clazz.addImport("net.anotheria.maf.validation.ValidationError");
            for (MetaViewElement element : elements) {
                if (!(element instanceof MetaFieldElement)) continue;
                field = (MetaFieldElement)element;
                p = doc.getField(field.getName());
                if (p.isLinked() || p instanceof MetaEnumerationProperty) {
                    clazz.addImport("java.util.List");
                    clazz.addImport("java.util.ArrayList");
                    clazz.addImport("net.anotheria.webutils.bean.LabelValueBean");
                }
                if (!(p instanceof MetaEnumerationProperty)) continue;
                MetaEnumerationProperty mep = (MetaEnumerationProperty)p;
                EnumerationType type = (EnumerationType)GeneratorDataRegistry.getInstance().getType(mep.getEnumeration());
                clazz.addImport(EnumTypeGenerator.getEnumImport(type));
            }
            this.generateExecuteOnValidationErrorMethod(section, doc, dialog, elements);
            ModuleActionsGenerator.emptyline();
        }
        return clazz;
    }

    private void generateExecuteOnValidationErrorMethod(MetaModuleSection section, MetaDocument doc, MetaDialog dialog, List<MetaViewElement> elements) {
        boolean isCMS;
        this.appendString("public ActionCommand executeOnValidationError(ActionMapping mapping, FormBean formBean, List<ValidationError> errors, HttpServletRequest req, HttpServletResponse res) throws Exception {");
        this.increaseIdent();
        this.appendString("Map<String, ValidationError> errorsMap = new HashMap<String,ValidationError>();");
        this.appendString("for (ValidationError error : errors) {");
        this.increaseIdent();
        this.appendString("errorsMap.put(error.getField(), error);");
        this.closeBlock("errorsMap ready");
        String formClassName = ModuleBeanGenerator.getDialogBeanName(dialog, doc);
        this.appendString(formClassName + " form = (" + formClassName + ")formBean;");
        this.appendPrepareFormForEditView(elements, doc, false);
        this.appendString("if (form.getId() == null || form.getId().isEmpty()) {");
        this.increaseIdent();
        this.decreaseIdent();
        this.appendString("} else {");
        this.increaseIdent();
        this.appendStatement("String id = form.getId()");
        this.appendStatement(doc.getName(), " ", doc.getVariableName(), " = ", ModuleActionsGenerator.getServiceGetterCall(section.getModule()), ".get", doc.getName(), "(id)");
        if (doc.isMultilingual()) {
            MetaProperty p = doc.getField("multilingualInstanceDisabled");
            String propertyCopy = "form." + p.toBeanSetter() + "(((MultilingualObject)" + doc.getVariableName() + ").isMultilingualDisabledInstance())";
            this.appendStatement(propertyCopy);
        }
        if (isCMS = StorageType.CMS.equals((Object)doc.getParentModule().getStorageType())) {
            MetaProperty prop = new MetaProperty("locked", MetaProperty.Type.BOOLEAN);
            String propertyCopy = "form." + prop.toBeanSetter() + "(((LockableObject)" + doc.getVariableName() + ").isLocked())";
            this.appendStatement(propertyCopy);
            prop = new MetaProperty("lockerId", MetaProperty.Type.STRING);
            propertyCopy = "form." + prop.toBeanSetter() + "(((LockableObject)" + doc.getVariableName() + ").getLockerId())";
            this.appendStatement(propertyCopy);
            prop = new MetaProperty("lockingTime", MetaProperty.Type.STRING);
            propertyCopy = "form." + prop.toBeanSetter() + "(net.anotheria.util.NumberUtils.makeISO8601TimestampString(((LockableObject)" + doc.getVariableName() + ").getLockingTime()) + \" automatic unlock expected AT : \" + net.anotheria.util.NumberUtils.makeISO8601TimestampString(((LockableObject)" + doc.getVariableName() + ").getLockingTime() + getLockingTimeout()))";
            this.appendStatement(propertyCopy);
        }
        for (MetaViewElement element : elements) {
            MetaFieldElement field;
            MetaProperty p;
            if (!(element instanceof MetaFieldElement) || !((p = doc.getField((field = (MetaFieldElement)element).getName())) instanceof MetaContainerProperty)) continue;
            this.appendString("// " + p.getName() + " is a table, storing size only");
            String lang = this.getElementLanguage(element);
            this.appendStatement("form." + p.toBeanSetter(lang) + "(" + doc.getVariableName() + "." + DataFacadeGenerator.getContainerSizeGetterName((MetaContainerProperty)p, lang) + "())");
        }
        this.closeBlock("form prepared");
        this.appendString("addBeanToRequest(req, \"validationErrors\" , errorsMap);");
        this.appendString("addBeanToRequest(req, " + this.quote(CMSMappingsConfiguratorGenerator.getDialogFormName(dialog, doc)) + " , formBean);");
        this.appendString("addBeanToRequest(req, \"save.label.prefix\", \"Save\");");
        this.appendString("addBeanToRequest(req, \"apply.label.prefix\" , \"Apply\");");
        this.appendString("addBeanToRequest(req, \"objectInfoString\" , \"none\");");
        ModuleActionsGenerator.emptyline();
        this.appendStatement("addFieldExplanations(req, null)");
        ModuleActionsGenerator.emptyline();
        this.appendString("return mapping.findForward(\"validationError\");");
        this.closeBlock("executeOnValidationError");
        ModuleActionsGenerator.emptyline();
    }

    private void generateExecuteMethod(GeneratedClass clazz, MetaDialog dialog, MetaDocument document) {
        String formBeanName = ModuleBeanGenerator.getDialogBeanName(dialog, document);
        this.appendString("@Override");
        this.appendString("public ActionCommand execute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{");
        this.increaseIdent();
        this.appendStatement("return super.execute(mapping, req, res)");
        this.closeBlock("execute");
        ModuleActionsGenerator.emptyline();
    }

    private void generateCloseAction(MetaModuleSection section, String methodName) {
        MetaDocument doc = section.getDocument();
        this.appendString(this.getExecuteDeclaration(methodName));
        this.increaseIdent();
        if (StorageType.CMS.equals((Object)doc.getParentModule().getStorageType())) {
            this.appendStatement("String id = getStringParameter(req, PARAM_ID)");
            this.appendStatement(doc.getName() + " " + doc.getVariableName() + "Curr = id != null && !id.equals(\"\") ? " + ModuleActionsGenerator.getServiceGetterCall(section.getModule()) + ".get" + doc.getName() + "(id) : null");
            this.appendString("if(" + doc.getVariableName() + "Curr != null && " + doc.getVariableName() + "Curr instanceof LockableObject && ((LockableObject)" + doc.getVariableName() + "Curr).isLocked()) ");
            this.appendIncreasedStatement("unLock" + doc.getMultiple() + "(" + doc.getVariableName() + "Curr, req, false)");
        }
        this.appendStatement("res.sendRedirect(" + this.getShowActionRedirect(doc) + ")");
        this.appendStatement("return null");
        this.closeBlockNEW();
    }

    private void generateRedirectPathMethod(MetaModuleSection section) {
        MetaDocument doc = section.getDocument();
        this.appendComment("Simplest method for redirect url creation. nextAction == showEdit - going to 'editView', to 'listView' otherwise. ");
        this.appendString("private String getRedirectUrl(HttpServletRequest req, " + doc.getName() + " item){");
        this.increaseIdent();
        this.appendStatement("String nextAction = req.getParameter(" + this.quote("nextAction") + ")");
        this.appendString("if (item==null || nextAction == null || nextAction.length() == 0)");
        this.appendIncreasedStatement("return " + this.getShowActionRedirect(doc));
        this.appendString("else");
        this.appendIncreasedString("return nextAction.equals(\"showEdit\") ? " + this.getEditActionRedirect(doc) + "+" + this.quote("&pId=") + "+item.getId()");
        this.appendIncreasedString("       : " + this.getShowActionRedirect(doc) + ";");
        this.closeBlockNEW();
    }

    private void generateLockManagementActionMethod(MetaModuleSection section, String methodName, boolean isLock) {
        MetaDocument doc = section.getDocument();
        this.appendString(this.getExecuteDeclaration(methodName));
        this.increaseIdent();
        this.appendStatement("String id = getStringParameter(req, PARAM_ID)");
        this.appendStatement(doc.getName() + " " + doc.getVariableName() + "Curr = id != null && !id.equals(\"\") ? " + ModuleActionsGenerator.getServiceGetterCall(section.getModule()) + ".get" + doc.getName() + "(id) : null");
        this.appendString("if(" + doc.getVariableName() + "Curr != null && " + doc.getVariableName() + "Curr instanceof LockableObject){ ");
        this.appendIncreasedStatement("LockableObject lockable = (LockableObject)" + doc.getVariableName() + "Curr");
        if (isLock) {
            this.appendIncreasedStatement("DocumentLockingHelper.lock.checkExecutionPermission(lockable,false,getUserId(req))");
            this.appendIncreasedStatement("lock" + doc.getMultiple() + "(" + doc.getVariableName() + "Curr, req)");
        } else {
            this.appendIncreasedStatement("DocumentLockingHelper.unLock.checkExecutionPermission(lockable,isUserInRole(req, \"admin\"),getUserId(req))");
            this.appendIncreasedStatement("unLock" + doc.getMultiple() + "(" + doc.getVariableName() + "Curr, req, false)");
        }
        this.appendString("}");
        this.appendStatement("res.sendRedirect(getRedirectUrl(req, " + doc.getVariableName() + "Curr))");
        this.appendStatement("return null");
        this.closeBlockNEW();
    }

    private void writePathResolveForMultiOpAction(MetaDocument doc, String action) {
        String path = CMSMappingsConfiguratorGenerator.getPath(doc, action);
        this.appendString("if (path.equals(" + this.quote(path) + "))");
        this.appendIncreasedStatement("return " + path + "(mapping, req, res)");
    }

    private void writePathResolveForContainerMultiOpAction(MetaDocument doc, MetaContainerProperty container, String action) {
        String path = CMSMappingsConfiguratorGenerator.getContainerPath(doc, container, action);
        this.appendString("if (path.equals(" + this.quote(path) + "))");
        this.appendIncreasedStatement("return " + path + "(mapping, req, res)");
    }

    private GeneratedClass generateShowAction(MetaModuleSection section) {
        MetaViewElement element;
        boolean containsDecorators;
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        this.appendGenerationPoint("generateShowAction");
        MetaDocument doc = section.getDocument();
        List<MetaViewElement> elements = section.getElements();
        boolean containsComparable = section.containsComparable();
        clazz.setPackageName(ModuleActionsGenerator.getPackage(section.getModule()));
        clazz.addImport("java.util.List");
        clazz.addImport("java.util.ArrayList");
        clazz.addImport("net.anotheria.asg.util.decorators.IAttributeDecorator");
        clazz.addImport("net.anotheria.asg.util.filter.DocumentFilter");
        clazz.addImport("net.anotheria.util.NumberUtils");
        clazz.addImport(ActionUtils.class);
        this.addStandardActionImports(clazz);
        clazz.addImport(DataFacadeGenerator.getDocumentImport(doc));
        clazz.addImport(ModuleBeanGenerator.getListItemBeanImport(GeneratorDataRegistry.getInstance().getContext(), doc));
        if (StorageType.CMS.equals((Object)doc.getParentModule().getStorageType())) {
            clazz.addImport("net.anotheria.asg.data.LockableObject");
        }
        clazz.addImport("org.slf4j.Logger");
        clazz.addImport("org.slf4j.LoggerFactory");
        clazz.addImport("org.slf4j.MarkerFactory");
        ArrayList<MetaDecorator> neededDecorators = new ArrayList<MetaDecorator>();
        for (int i = 0; i < elements.size(); ++i) {
            MetaDecorator d;
            MetaViewElement element2 = elements.get(i);
            if (!(element2 instanceof MetaFieldElement)) continue;
            MetaFieldElement field = (MetaFieldElement)element2;
            MetaProperty p = doc.getField(field.getName());
            if (p instanceof MetaEnumerationProperty) {
                MetaEnumerationProperty enumeration = (MetaEnumerationProperty)p;
                EnumerationType type = (EnumerationType)GeneratorDataRegistry.getInstance().getType(enumeration.getEnumeration());
                clazz.addImport(EnumTypeGenerator.getEnumImport(type));
            }
            if ((d = field.getDecorator()) == null || neededDecorators.indexOf(d) != -1) continue;
            neededDecorators.add(d);
        }
        clazz.setName(ModuleActionsGenerator.getShowActionName(section));
        clazz.setParent(ModuleActionsGenerator.getBaseActionName(section));
        this.startClassBody();
        this.appendStatement("public static final String SA_SORT_TYPE = SA_SORT_TYPE_PREFIX+", this.quote(doc.getName()));
        this.appendStatement("public static final String SA_FILTER = SA_FILTER_PREFIX+", this.quote(doc.getName()));
        this.appendStatement("private static Logger log = LoggerFactory.getLogger(" + ModuleActionsGenerator.getShowActionName(section) + ".class)");
        boolean bl = containsDecorators = neededDecorators.size() > 0;
        if (containsComparable) {
            clazz.addImport(ModuleBeanGenerator.getListItemBeanSortTypeImport(GeneratorDataRegistry.getInstance().getContext(), doc));
            clazz.addImport("net.anotheria.util.sorter.Sorter");
            clazz.addImport("net.anotheria.util.sorter.QuickSorter");
            this.appendStatement("private Sorter<", ModuleBeanGenerator.getListItemBeanName(doc), "> sorter");
            ModuleActionsGenerator.emptyline();
        }
        if (containsDecorators) {
            for (int i = 0; i < elements.size(); ++i) {
                element = elements.get(i);
                if (element.getDecorator() == null) continue;
                this.appendStatement("private IAttributeDecorator " + this.getDecoratorVariableName(element));
            }
            ModuleActionsGenerator.emptyline();
        }
        if (section.getFilters().size() > 0) {
            for (MetaFilter f : section.getFilters()) {
                this.appendStatement("private DocumentFilter " + ModuleActionsGenerator.getFilterVariableName(f));
            }
            ModuleActionsGenerator.emptyline();
        }
        this.appendString("public " + ModuleActionsGenerator.getShowActionName(section) + "(){");
        this.increaseIdent();
        if (containsComparable) {
            this.appendStatement("sorter = new QuickSorter<" + ModuleBeanGenerator.getListItemBeanName(doc) + ">()");
        }
        if (containsDecorators) {
            this.appendString("try{ ");
            this.increaseIdent();
            for (int i = 0; i < elements.size(); ++i) {
                element = elements.get(i);
                if (element.getDecorator() == null) continue;
                this.appendStatement(this.getDecoratorVariableName(element) + " = (IAttributeDecorator)Class.forName(" + this.quote(element.getDecorator().getClassName()) + ").newInstance()");
            }
            this.decreaseIdent();
            this.appendString("} catch(Exception e){");
            this.appendIncreasedStatement("log.error(MarkerFactory.getMarker(\"FATAL\"), \"Couldn't instantiate decorator:\", e)");
            this.appendString("}");
        }
        if (section.getFilters().size() > 0) {
            this.appendString("try{ ");
            this.increaseIdent();
            for (MetaFilter f : section.getFilters()) {
                this.appendStatement(ModuleActionsGenerator.getFilterVariableName(f), " = (DocumentFilter) Class.forName(", this.quote(f.getClassName()), ").newInstance()");
            }
            this.decreaseIdent();
            this.appendString("} catch(Exception e){");
            this.appendIncreasedStatement("log.error(MarkerFactory.getMarker(\"FATAL\"), \"Couldn't instantiate filter:\", e)");
            this.appendString("}");
        }
        this.closeBlockNEW();
        this.appendString(this.getExecuteDeclaration());
        this.increaseIdent();
        if (section.getFilters().size() > 0) {
            for (int i = 0; i < section.getFilters().size(); ++i) {
                String filterParameterName = "filterParameter" + i;
                this.appendStatement("String filterParameter" + i + " = " + this.quote(""));
                this.appendString("try{ ");
                this.appendIncreasedStatement(filterParameterName + " = getStringParameter(req, " + this.quote("pFilter" + i) + ")");
                this.appendIncreasedStatement("addBeanToSession(req, SA_FILTER+" + this.quote(i) + ", " + filterParameterName + ")");
                this.appendString("}catch(Exception ignored){");
                this.increaseIdent();
                this.appendCommentLine("no filter parameter given, tring to check in the session.");
                this.appendStatement(filterParameterName + " = (String)getBeanFromSession(req, SA_FILTER+" + this.quote(i) + ")");
                this.appendString("if (" + filterParameterName + "==null)");
                this.appendIncreasedStatement(filterParameterName + " = " + this.quote(""));
                this.closeBlockNEW();
                this.appendStatement("req.setAttribute(" + this.quote("currentFilterParameter" + i) + ", " + filterParameterName + ")");
                ModuleActionsGenerator.emptyline();
            }
        }
        if (containsComparable) {
            String sortType = ModuleBeanGenerator.getListItemBeanSortTypeName(doc);
            this.appendStatement("int sortMethod = " + sortType + ".SORT_BY_DEFAULT");
            this.appendStatement("boolean sortOrder = getSortOder(req)");
            this.appendStatement("boolean sortParamSet = false");
            ModuleActionsGenerator.emptyline();
            this.appendString("try{");
            this.appendIncreasedStatement("sortMethod = getIntParameter(req, PARAM_SORT_TYPE)");
            this.appendIncreasedStatement("sortParamSet = true");
            this.appendString("}catch(Exception ignored){}");
            ModuleActionsGenerator.emptyline();
            this.appendString("try{");
            this.appendIncreasedStatement("String sortMethodName = getStringParameter(req, PARAM_SORT_TYPE_NAME)");
            this.appendIncreasedStatement("sortMethod = " + sortType + ".name2method(sortMethodName)");
            this.appendIncreasedStatement("sortParamSet = true");
            this.appendString("}catch(Exception ignored){}");
            ModuleActionsGenerator.emptyline();
            this.appendStatement(ModuleBeanGenerator.getListItemBeanSortTypeName(doc) + " sortType = null");
            this.appendString("if (sortParamSet){");
            this.increaseIdent();
            this.appendStatement("sortType = new " + ModuleBeanGenerator.getListItemBeanSortTypeName(doc) + "(sortMethod, sortOrder)");
            this.appendStatement("addBeanToSession(req, SA_SORT_TYPE, sortType)");
            this.decreaseIdent();
            this.appendString("}else{");
            this.increaseIdent();
            this.appendStatement("sortType = (" + ModuleBeanGenerator.getListItemBeanSortTypeName(doc) + ")getBeanFromSession(req, SA_SORT_TYPE)");
            this.appendString("if (sortType==null)");
            this.appendIncreasedStatement("sortType = new " + ModuleBeanGenerator.getListItemBeanSortTypeName(doc) + "(sortMethod, sortOrder)");
            this.closeBlockNEW();
            this.appendStatement("req.setAttribute(" + this.quote("currentSortCode") + ", sortType.getMethodAndOrderCode())");
            ModuleActionsGenerator.emptyline();
        }
        String listName = doc.getMultiple().toLowerCase();
        if (section.getFilters().size() > 0) {
            String unfilteredListName = "_unfiltered_" + listName;
            this.appendStatement("List<" + doc.getName() + "> " + (String)unfilteredListName + " = " + ModuleActionsGenerator.getServiceGetterCall(section.getModule()) + ".get" + doc.getMultiple() + "()");
            this.appendStatement("List<" + doc.getName() + "> " + listName + " = new ArrayList<" + doc.getName() + ">()");
            this.appendString("for (int i=0; i<" + (String)unfilteredListName + ".size(); i++){");
            this.increaseIdent();
            this.appendStatement("boolean mayPass = true");
            for (int i = 0; i < section.getFilters().size(); ++i) {
                MetaFilter activeFilter = section.getFilters().get(i);
                String filterVarName = ModuleActionsGenerator.getFilterVariableName(activeFilter);
                this.appendStatement("mayPass = mayPass && (" + filterVarName + ".mayPass(" + (String)unfilteredListName + ".get(i), " + this.quote(activeFilter.getFieldName()) + ", filterParameter" + i + "))");
            }
            this.appendString("if (mayPass)");
            this.append(this.writeIncreasedStatement(listName + ".add(" + (String)unfilteredListName + ".get(i))"));
            this.closeBlockNEW();
        } else {
            this.appendStatement("List<" + doc.getName() + "> " + listName + " = " + ModuleActionsGenerator.getServiceGetterCall(section.getModule()) + ".get" + doc.getMultiple() + "()");
        }
        this.appendStatement("List<" + ModuleBeanGenerator.getListItemBeanName(doc) + "> beans = new ArrayList<" + ModuleBeanGenerator.getListItemBeanName(doc) + ">(" + listName + ".size())");
        this.appendString("for (" + doc.getName() + " " + doc.getVariableName() + " : " + listName + "){");
        this.increaseIdent();
        if (StorageType.CMS.equals((Object)doc.getParentModule().getStorageType())) {
            this.appendStatement("check" + doc.getMultiple() + "(" + doc.getVariableName() + ", req)");
        }
        this.appendStatement(ModuleBeanGenerator.getListItemBeanName(doc) + " bean = " + this.getMakeBeanFunctionName(ModuleBeanGenerator.getListItemBeanName(doc)) + "(" + doc.getVariableName() + ")");
        this.appendStatement("beans.add(bean)");
        this.closeBlockNEW();
        ModuleActionsGenerator.emptyline();
        if (containsComparable) {
            this.appendStatement("beans = sorter.sort(beans, sortType)");
        }
        this.appendStatement("beans = ActionUtils.sliceDataAndSavePagingInformation(req, beans)");
        this.appendStatement("addBeanToRequest(req, " + this.quote(listName) + ", beans)");
        for (MetaFilter f : section.getFilters()) {
            this.appendStatement("addBeanToRequest(req, ", this.quote(ModuleActionsGenerator.getFilterVariableName(f)), ", ", ModuleActionsGenerator.getFilterVariableName(f), ".getTriggerer(\"" + f.getFieldName() + "\"))");
        }
        this.appendStatement("return mapping.success()");
        this.closeBlockNEW();
        ModuleActionsGenerator.emptyline();
        this.appendString("protected " + ModuleBeanGenerator.getListItemBeanName(doc) + " " + this.getMakeBeanFunctionName(ModuleBeanGenerator.getListItemBeanName(doc)) + "(" + doc.getName() + " " + doc.getVariableName() + ") {");
        this.increaseIdent();
        this.appendStatement(ModuleBeanGenerator.getListItemBeanName(doc) + " bean = new " + ModuleBeanGenerator.getListItemBeanName(doc) + "()");
        this.appendStatement("bean.setPlainId(" + doc.getVariableName() + ".getId())");
        elements = ModuleActionsGenerator.createMultilingualList(elements, doc);
        for (int i = 0; i < elements.size(); ++i) {
            MetaProperty p;
            MetaViewElement element3 = elements.get(i);
            if (!(element3 instanceof MetaFieldElement)) continue;
            MetaFieldElement field = (MetaFieldElement)element3;
            String lang = null;
            if (field instanceof MultilingualFieldElement) {
                lang = ((MultilingualFieldElement)field).getLanguage();
            }
            if ((p = doc.getField(field.getName())) instanceof MetaEnumerationProperty) {
                MetaEnumerationProperty mep = (MetaEnumerationProperty)p;
                EnumerationType type = (EnumerationType)GeneratorDataRegistry.getInstance().getType(mep.getEnumeration());
                this.openTry();
                this.appendStatement("bean." + p.toBeanSetter(lang) + "(" + EnumTypeGenerator.getEnumClassName(type) + ".getConstantByValue(" + doc.getVariableName() + ".get" + p.getAccesserName() + "()).name())");
                this.appendCatch(ConstantNotFoundException.class);
                this.appendStatement("bean." + p.toBeanSetter(lang) + "(" + this.quote("-----") + ")");
                this.closeBlock("try");
                continue;
            }
            Object value = "";
            value = doc.getVariableName() + ".get" + p.getAccesserName(lang) + "()";
            if (element3.getDecorator() != null) {
                MetaProperty tmp = null;
                tmp = lang != null ? new MetaProperty(p.getName("ForSorting", lang), p.getType()) : new MetaProperty(p.getName() + "ForSorting", p.getType());
                this.appendStatement("bean." + tmp.toBeanSetter() + "(" + (String)value + ")");
                MetaDecorator d = element3.getDecorator();
                value = this.getDecoratorVariableName(element3) + ".decorate(" + doc.getVariableName() + ", " + this.quote(p.getName() + (String)(lang == null ? "" : "_" + lang)) + ", " + this.quote(d.getRule()) + ")";
            }
            this.appendStatement("bean." + p.toBeanSetter(lang) + "(" + (String)value + ")");
        }
        if (StorageType.CMS.equals((Object)doc.getParentModule().getStorageType())) {
            MetaProperty prop = new MetaProperty("locked", MetaProperty.Type.BOOLEAN);
            String propertyCopy = "bean." + prop.toBeanSetter() + "(((LockableObject)" + doc.getVariableName() + ").isLocked())";
            this.appendStatement(propertyCopy);
            prop = new MetaProperty("lockerId", MetaProperty.Type.STRING);
            propertyCopy = "bean." + prop.toBeanSetter() + "(((LockableObject)" + doc.getVariableName() + ").getLockerId())";
            this.appendStatement(propertyCopy);
            prop = new MetaProperty("lockingTime", MetaProperty.Type.STRING);
            propertyCopy = "bean." + prop.toBeanSetter() + "(NumberUtils.makeISO8601TimestampString(((LockableObject)" + doc.getVariableName() + ").getLockingTime()) + \" till: \" + NumberUtils.makeISO8601TimestampString(((LockableObject)" + doc.getVariableName() + ").getLockingTime() + getLockingTimeout()))";
            this.appendStatement(propertyCopy);
        }
        this.appendStatement("bean.setDocumentLastUpdateTimestamp(NumberUtils.makeISO8601TimestampString(" + doc.getVariableName() + ".getLastUpdateTimestamp()))");
        this.appendStatement("return bean");
        this.closeBlockNEW();
        return clazz;
    }

    private GeneratedClass generateSearchAction(MetaModuleSection section) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        MetaDocument doc = section.getDocument();
        List<MetaViewElement> elements = section.getElements();
        clazz.setPackageName(ModuleActionsGenerator.getPackage(section.getModule()));
        clazz.addImport("java.util.List");
        clazz.addImport("java.util.ArrayList");
        this.addStandardActionImports(clazz);
        clazz.addImport("net.anotheria.anodoc.query2.DocumentQuery");
        clazz.addImport("net.anotheria.anodoc.query2.string.ContainsStringQuery");
        clazz.addImport("net.anotheria.anodoc.query2.QueryResult");
        clazz.addImport("net.anotheria.anodoc.query2.QueryResultEntry");
        clazz.addImport("net.anotheria.anodoc.query2.ResultEntryBean");
        for (int i = 0; i < elements.size(); ++i) {
            MetaFieldElement field;
            MetaProperty p;
            MetaViewElement element = elements.get(i);
            if (!(element instanceof MetaFieldElement) || !((p = doc.getField((field = (MetaFieldElement)element).getName())) instanceof MetaEnumerationProperty)) continue;
            MetaEnumerationProperty enumeration = (MetaEnumerationProperty)p;
            EnumerationType type = (EnumerationType)GeneratorDataRegistry.getInstance().getType(enumeration.getEnumeration());
            clazz.addImport(EnumTypeGenerator.getEnumImport(type));
        }
        clazz.setName(ModuleActionsGenerator.getSearchActionName(section));
        clazz.setParent(ModuleActionsGenerator.getBaseActionName(section));
        this.startClassBody();
        this.appendString(this.getExecuteDeclaration());
        this.increaseIdent();
        this.appendStatement("String criteria = req.getParameter(" + this.quote("criteria") + ")");
        this.appendStatement("DocumentQuery query = new ContainsStringQuery(criteria)");
        this.appendStatement("QueryResult result = " + ModuleActionsGenerator.getServiceGetterCall(section.getModule()) + ".executeQueryOn" + doc.getMultiple() + "(query)");
        this.appendString("if (result.getEntries().size()==0){");
        this.appendIncreasedStatement("req.setAttribute(" + this.quote("srMessage") + ", " + this.quote("Nothing found.") + ")");
        this.appendString("}else{");
        this.increaseIdent();
        this.appendStatement("List<ResultEntryBean> beans = new ArrayList<ResultEntryBean>(result.getEntries().size())");
        this.appendString("for (int i=0; i<result.getEntries().size(); i++){");
        this.increaseIdent();
        this.appendStatement("QueryResultEntry entry = result.getEntries().get(i)");
        this.appendStatement("ResultEntryBean bean = new ResultEntryBean()");
        this.appendStatement("bean.setEditLink(" + this.quote(CMSMappingsConfiguratorGenerator.getPath(doc, "edit") + "?pId=") + "+entry.getMatchedDocument().getId()+" + this.quote("&ts=") + "+System.currentTimeMillis())");
        this.appendStatement("bean.setDocumentId(entry.getMatchedDocument().getId())");
        this.appendStatement("bean.setPropertyName(entry.getMatchedProperty().getId())");
        this.appendStatement("bean.setInfo(entry.getInfo().toHtml())");
        this.appendStatement("beans.add(bean)");
        this.closeBlockNEW();
        this.appendStatement("req.setAttribute(" + this.quote("result") + ", beans)");
        this.closeBlockNEW();
        this.appendStatement("return mapping.success()");
        this.closeBlockNEW();
        return clazz;
    }

    private GeneratedClass generateShowQueryAction(MetaModuleSection section) {
        MetaDocument targetDocument;
        MetaModule mod;
        String targetDocumentName;
        String targetModuleName;
        int dotIndex;
        String lt;
        MetaLink link;
        int i;
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        MetaDocument doc = section.getDocument();
        clazz.setPackageName(ModuleActionsGenerator.getPackage(section.getModule()));
        this.addStandardActionImports(clazz);
        clazz.addImport("net.anotheria.webutils.bean.LabelValueBean");
        clazz.addImport("java.util.List");
        clazz.addImport("java.util.ArrayList");
        clazz.addImport("java.util.Iterator");
        List<MetaProperty> links = doc.getLinks();
        HashSet<String> linkTargets = new HashSet<String>();
        for (i = 0; i < links.size(); ++i) {
            link = (MetaLink)links.get(i);
            lt = link.getLinkTarget();
            if (linkTargets.contains(lt) || (dotIndex = lt.indexOf(46)) <= 0) continue;
            targetModuleName = lt.substring(0, dotIndex);
            targetDocumentName = lt.substring(dotIndex + 1);
            mod = GeneratorDataRegistry.getInstance().getModule(targetModuleName);
            targetDocument = mod.getDocumentByName(targetDocumentName);
            clazz.addImport(DataFacadeGenerator.getDocumentImport(targetDocument));
            linkTargets.add(lt);
        }
        clazz.setName(ModuleActionsGenerator.getShowQueryActionName(section));
        clazz.setParent(ModuleActionsGenerator.getBaseActionName(section));
        this.startClassBody();
        this.appendString(this.getExecuteDeclaration());
        this.increaseIdent();
        ModuleActionsGenerator.emptyline();
        linkTargets = new HashSet();
        for (i = 0; i < links.size(); ++i) {
            link = (MetaLink)links.get(i);
            lt = link.getLinkTarget();
            if (linkTargets.contains(lt) || (dotIndex = lt.indexOf(46)) <= 0) continue;
            targetModuleName = lt.substring(0, dotIndex);
            targetDocumentName = lt.substring(dotIndex + 1);
            mod = GeneratorDataRegistry.getInstance().getModule(targetModuleName);
            targetDocument = mod.getDocumentByName(targetDocumentName);
            this.appendStatement("List<" + targetDocument.getName() + "> " + targetDocument.getMultiple().toLowerCase() + " = " + ModuleActionsGenerator.getServiceGetterCall(mod) + ".get" + targetDocument.getMultiple() + "()");
            this.appendStatement("List<LabelValueBean> " + targetDocument.getMultiple().toLowerCase() + "Beans = new ArrayList<>(" + targetDocument.getMultiple().toLowerCase() + ".size())");
            this.appendString("for(Iterator<" + targetDocument.getName() + "> it=" + targetDocument.getMultiple().toLowerCase() + ".iterator(); it.hasNext(); ){");
            this.increaseIdent();
            this.appendStatement(targetDocument.getName() + " " + targetDocument.getVariableName() + " =  it.next()");
            String beanCreationCall = targetDocument.getMultiple().toLowerCase() + "Beans";
            beanCreationCall = beanCreationCall + ".add(";
            beanCreationCall = beanCreationCall + "new LabelValueBean(";
            beanCreationCall = beanCreationCall + targetDocument.getVariableName() + ".getId(), ";
            beanCreationCall = beanCreationCall + targetDocument.getVariableName() + ".getName()))";
            this.appendStatement(beanCreationCall);
            this.closeBlockNEW();
            this.appendStatement("addBeanToRequest(req, " + this.quote(targetDocument.getMultiple().toLowerCase()) + ", " + targetDocument.getMultiple().toLowerCase() + "Beans)");
            ModuleActionsGenerator.emptyline();
            linkTargets.add(lt);
        }
        this.appendStatement("return mapping.success()");
        this.closeBlockNEW();
        return clazz;
    }

    private GeneratedClass generateExecuteQueryAction(MetaModuleSection section) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        this.appendGenerationPoint("generateExecuteQueryAction");
        MetaDocument doc = section.getDocument();
        clazz.setPackageName(ModuleActionsGenerator.getPackage(section.getModule()));
        this.addStandardActionImports(clazz);
        clazz.addImport("java.util.List");
        clazz.addImport("java.util.ArrayList");
        clazz.addImport(DataFacadeGenerator.getDocumentImport(doc));
        clazz.addImport(ModuleBeanGenerator.getListItemBeanImport(GeneratorDataRegistry.getInstance().getContext(), doc));
        clazz.setName(ModuleActionsGenerator.getExecuteQueryActionName(section));
        clazz.setParent(ModuleActionsGenerator.getShowActionName(section));
        this.startClassBody();
        this.appendString(this.getExecuteDeclaration());
        this.increaseIdent();
        ModuleActionsGenerator.emptyline();
        this.appendStatement("String property = req.getParameter(" + this.quote("property") + ")");
        this.appendStatement("String criteria = req.getParameter(" + this.quote("criteria") + ")");
        this.appendString("if( criteria!=null && criteria.length()==0)");
        this.appendIncreasedStatement("criteria = null;");
        String listName = doc.getMultiple().toLowerCase();
        this.appendStatement("List<" + doc.getName() + "> " + listName + " = " + ModuleActionsGenerator.getServiceGetterCall(section.getModule()) + ".get" + doc.getMultiple() + "ByProperty(property, criteria)");
        this.appendStatement("List<" + ModuleBeanGenerator.getListItemBeanName(doc) + "> beans = new ArrayList<" + ModuleBeanGenerator.getListItemBeanName(doc) + ">(" + listName + ".size())");
        this.appendString("for (int i=0; i<" + listName + ".size(); i++){");
        this.increaseIdent();
        this.appendStatement("beans.add(" + this.getMakeBeanFunctionName(ModuleBeanGenerator.getListItemBeanName(doc)) + "((" + doc.getName() + ")" + listName + ".get(i)))");
        this.closeBlockNEW();
        ModuleActionsGenerator.emptyline();
        this.appendStatement("return mapping.success()");
        this.closeBlockNEW();
        return clazz;
    }

    private String getDecoratorVariableName(MetaViewElement element) {
        return element.getName() + "Decorator";
    }

    public static String getFilterVariableName(MetaFilter filter) {
        return filter.getFieldName() + "Filter" + StringUtils.capitalize((String)filter.getName());
    }

    private String getMakeBeanFunctionName(String beanName) {
        return "make" + StringUtils.capitalize((String)beanName);
    }

    private GeneratedClass generateVersionInfoAction(MetaModuleSection section) {
        return null;
    }

    private void generateVersionInfoActionMethod(MetaModuleSection section, String methodName) {
        MetaDocument doc = section.getDocument();
        this.appendString(this.getExecuteDeclaration(methodName));
        this.increaseIdent();
        this.appendStatement("String id = getStringParameter(req, PARAM_ID)");
        this.appendStatement(doc.getName() + " " + doc.getVariableName() + " = " + ModuleActionsGenerator.getServiceGetterCall(section.getModule()) + ".get" + doc.getName() + "(id);");
        if (StorageType.CMS.equals((Object)doc.getParentModule().getStorageType())) {
            this.appendStatement("check" + doc.getMultiple() + "(" + doc.getVariableName() + ", req)");
        }
        this.appendStatement("long timestamp = " + doc.getVariableName() + ".getLastUpdateTimestamp()");
        this.appendStatement("String lastUpdateDate = NumberUtils.makeDigitalDateStringLong(timestamp)");
        this.appendStatement("lastUpdateDate += \" \"+NumberUtils.makeTimeString(timestamp)");
        try {
            doc.getField("name");
            this.appendStatement("req.setAttribute(" + this.quote("documentName") + ", " + doc.getVariableName() + ".getName())");
        }
        catch (Exception ignored) {
            this.appendStatement("req.setAttribute(" + this.quote("documentName") + ", \"Id:\"+" + doc.getVariableName() + ".getId())");
        }
        this.appendStatement("req.setAttribute(", this.quote("documentType"), ", ", doc.getVariableName(), ".getClass())");
        this.appendStatement("req.setAttribute(", this.quote("lastUpdate"), ", lastUpdateDate)");
        this.appendStatement("return mapping.success()");
        this.closeBlockNEW();
    }

    private GeneratedClass generateUpdateAction(MetaModuleSection section) {
        return null;
    }

    private void generateUpdateActionMethod(MetaModuleSection section, String methodName) {
        MetaProperty p;
        this.appendGenerationPoint("generateUpdateActionMethod");
        MetaDocument doc = section.getDocument();
        MetaDialog dialog = section.getDialogs().get(0);
        List<MetaViewElement> elements = ModuleActionsGenerator.createMultilingualList(dialog.getElements(), doc);
        this.appendString(this.getExecuteDeclaration(methodName));
        this.increaseIdent();
        this.appendStatement(ModuleBeanGenerator.getDialogBeanName(dialog, doc) + " form = new " + ModuleBeanGenerator.getDialogBeanName(dialog, doc) + "()");
        this.appendStatement("PopulateUtility.populate(form, req)");
        this.appendStatement("boolean create = false");
        this.appendStatement(doc.getName() + " " + doc.getVariableName() + " = null");
        this.appendString("if (form.getId()==null) {");
        this.appendString("res.sendRedirect(\"asresourcedataLocalizationBundleShow?ts=\"+System.currentTimeMillis());");
        this.appendString("return null;");
        this.closeBlockNEW();
        this.appendString("if (form.getId().length()>0){");
        this.appendIncreasedString(doc.getVariableName() + " = (" + doc.getName() + ")" + ModuleActionsGenerator.getServiceGetterCall(section.getModule()) + ".get" + doc.getName() + "(form.getId()).clone();");
        this.appendString("}else{");
        this.increaseIdent();
        this.appendString(doc.getVariableName() + " = " + DataFacadeGenerator.getDocumentFactoryName(doc) + ".create" + doc.getName() + "();");
        this.appendString("create = true;");
        this.closeBlockNEW();
        ModuleActionsGenerator.emptyline();
        this.appendStatement("String nextAction = req.getParameter(" + this.quote("nextAction") + ")");
        this.appendString("if (nextAction == null || nextAction.length() == 0)");
        this.appendIncreasedStatement("nextAction = \"close\"");
        ModuleActionsGenerator.emptyline();
        for (int i = 0; i < elements.size(); ++i) {
            MetaViewElement elem = elements.get(i);
            if (!(elem instanceof MetaFieldElement)) continue;
            MetaFieldElement field = (MetaFieldElement)elem;
            String lang = this.getElementLanguage(field);
            if (field.isReadonly()) {
                this.appendString("//skipped " + field.getName() + " because it's readonly.");
                continue;
            }
            p = doc.getField(field.getName());
            if (p.getType() == MetaProperty.Type.IMAGE) {
                String varName = p.getName();
                String holderName = "holder_" + varName;
                this.appendString("//handle image");
                this.appendStatement("TemporaryFileHolder " + holderName + " = FileStorage.getTemporaryFile(req,\"" + varName + "\")");
                this.appendString("if (" + holderName + "!=null && " + holderName + ".getData()!=null){");
                this.increaseIdent();
                this.appendStatement("FileStorage.removeFilePermanently( " + doc.getVariableName() + "." + p.toGetter() + "() )");
                this.appendStatement("FileStorage.storeFilePermanently(req, " + holderName + ".getFileName(),\"" + varName + "\")");
                this.appendStatement(doc.getVariableName() + "." + p.toSetter() + "(" + holderName + ".getFileName())");
                this.appendStatement("FileStorage.removeTemporaryFile(req,\"" + varName + "\")");
                this.closeBlockNEW();
                continue;
            }
            if (!(p instanceof MetaContainerProperty)) {
                Object propertyCopy = "";
                propertyCopy = (String)propertyCopy + doc.getVariableName() + "." + p.toSetter(lang) + "(";
                propertyCopy = (String)propertyCopy + "form." + p.toBeanGetter(lang) + "())";
                this.appendStatement(new String[]{propertyCopy});
                continue;
            }
            this.appendString("// skipped container " + p.getName());
        }
        boolean hasImageField = false;
        for (int i = 0; i < elements.size(); ++i) {
            MetaFieldElement field;
            MetaViewElement elem = elements.get(i);
            if (!(elem instanceof MetaFieldElement) || (p = doc.getField((field = (MetaFieldElement)elem).getName())).getType() != MetaProperty.Type.IMAGE) continue;
            hasImageField = true;
            break;
        }
        if (hasImageField) {
            ModuleActionsGenerator.emptyline();
            this.appendString("// delete image method start");
            this.appendStatement("String fieldName = req.getParameter(\"fieldName\")");
            this.appendStatement("String fileName = req.getParameter(\"fileName\")");
            ModuleActionsGenerator.emptyline();
            this.appendString("if (!StringUtils.isEmpty(fieldName) && !StringUtils.isEmpty(fileName)) {");
            this.increaseIdent();
            this.appendStatement("String setMethodName = \"set\"+WordUtils.capitalize(fieldName)");
            this.appendStatement("Class<?> c = " + doc.getVariableName() + ".getClass()");
            this.appendString("try{");
            this.increaseIdent();
            this.appendStatement("Method m = c.getDeclaredMethod(setMethodName, new Class[]{String.class})");
            this.appendStatement("m.invoke(" + doc.getVariableName() + ", new Object[]{\"\"})");
            this.appendStatement("FileStorage.removeFilePermanently(fileName)");
            this.decreaseIdent();
            this.appendString("}catch (NoSuchMethodException e){");
            this.increaseIdent();
            this.appendStatement("e.printStackTrace()");
            this.decreaseIdent();
            this.appendString("}catch (InvocationTargetException ignored) {");
            this.increaseIdent();
            this.appendStatement("ignored.printStackTrace()");
            this.decreaseIdent();
            this.appendString("}");
            this.decreaseIdent();
            this.appendString("}");
            this.appendString("// delete image method end");
            ModuleActionsGenerator.emptyline();
        }
        ModuleActionsGenerator.emptyline();
        this.appendStatement(doc.getName(), " updatedCopy = null");
        this.appendString("if (create){");
        this.appendIncreasedStatement("updatedCopy = " + ModuleActionsGenerator.getServiceGetterCall(section.getModule()) + ".create" + doc.getName() + "(" + doc.getVariableName() + ")");
        this.appendString("}else{");
        if (StorageType.CMS.equals((Object)section.getDocument().getParentModule().getStorageType())) {
            this.appendIncreasedStatement("canUpdate" + doc.getMultiple() + "(" + doc.getVariableName() + ", req)");
            this.appendIncreasedStatement("check" + doc.getMultiple() + "(" + doc.getVariableName() + ", req)");
        }
        this.appendIncreasedStatement("updatedCopy = " + ModuleActionsGenerator.getServiceGetterCall(section.getModule()) + ".update" + doc.getName() + "(" + doc.getVariableName() + ")");
        this.appendString("}");
        this.appendString("if (nextAction.equalsIgnoreCase(" + this.quote("stay") + ")){");
        this.appendIncreasedStatement("res.sendRedirect(" + this.getEditActionRedirect(doc) + "+" + this.quote("&pId=") + "+updatedCopy.getId())");
        this.appendString("}else{");
        if (StorageType.CMS.equals((Object)section.getDocument().getParentModule().getStorageType())) {
            this.appendIncreasedStatement("unlockAfterUpdate(" + doc.getVariableName() + ", req)");
        }
        this.appendIncreasedStatement("res.sendRedirect(" + this.getShowActionRedirect(doc) + ")");
        this.appendString("}");
        this.appendStatement("return null");
        this.closeBlockNEW();
        if (StorageType.CMS.equals((Object)section.getDocument().getParentModule().getStorageType())) {
            this.appendComment("Simply unlocks document after updation.");
            this.appendString("private void unlockAfterUpdate(" + doc.getName() + " " + doc.getVariableName() + ", HttpServletRequest req) throws Exception{");
            this.increaseIdent();
            this.appendString("if(((LockableObject)" + doc.getVariableName() + ").isLocked())");
            this.appendIncreasedStatement("unLock" + doc.getMultiple() + "(" + doc.getVariableName() + ", req, false)");
            this.closeBlockNEW();
        }
    }

    private GeneratedClass generateSwitchMultilingualityAction(MetaModuleSection section) {
        return null;
    }

    private void generateSwitchMultilingualityActionMethod(MetaModuleSection section, String methodName) {
        MetaDocument doc = section.getDocument();
        this.appendString(this.getExecuteDeclaration(methodName));
        this.increaseIdent();
        this.appendStatement("String id = getStringParameter(req, PARAM_ID)");
        this.appendStatement("String value = getStringParameter(req, " + this.quote("value") + ")");
        this.appendStatement(doc.getName() + " " + doc.getVariableName() + " = " + ModuleActionsGenerator.getServiceGetterCall(section.getModule()) + ".get" + doc.getName() + "(id)");
        if (StorageType.CMS.equals((Object)section.getDocument().getParentModule().getStorageType())) {
            this.appendStatement("canUpdate" + doc.getMultiple() + "(" + doc.getVariableName() + ", req)");
            this.appendStatement("check" + doc.getMultiple() + "(" + doc.getVariableName() + ", req)");
        }
        this.appendStatement("((MultilingualObject)" + doc.getVariableName() + ").setMultilingualDisabledInstance(Boolean.valueOf(value))");
        this.appendStatement(ModuleActionsGenerator.getServiceGetterCall(section.getModule()) + ".update" + doc.getName() + "(" + doc.getVariableName() + ")");
        this.appendStatement("res.sendRedirect(" + this.getEditActionRedirect(doc) + "+" + this.quote("&pId=") + "+id)");
        this.appendStatement("return null");
        this.closeBlockNEW();
    }

    private GeneratedClass generateLanguageCopyAction(MetaModuleSection section) {
        return null;
    }

    private void generateLanguageCopyActionMethod(MetaModuleSection section, String methodName) {
        MetaDocument doc = section.getDocument();
        this.appendString(this.getExecuteDeclaration(methodName));
        this.increaseIdent();
        this.appendStatement("String sourceLanguage = req.getParameter(" + this.quote("pSrcLang") + ")");
        this.appendString("if (sourceLanguage==null || sourceLanguage.length()==0)");
        this.appendIncreasedStatement("throw new RuntimeException(" + this.quote("No source language") + ")");
        ModuleActionsGenerator.emptyline();
        this.appendStatement("String destLanguage = req.getParameter(" + this.quote("pDestLang") + ")");
        this.appendString("if (destLanguage==null || destLanguage.length()==0)");
        this.appendIncreasedStatement("throw new RuntimeException(" + this.quote("No destination language") + ")");
        ModuleActionsGenerator.emptyline();
        this.appendStatement("String id = getStringParameter(req, PARAM_ID)");
        this.appendStatement(doc.getName() + " " + doc.getVariableName() + " = " + ModuleActionsGenerator.getServiceGetterCall(section.getModule()) + ".get" + doc.getName() + "(id)");
        if (StorageType.CMS.equals((Object)section.getDocument().getParentModule().getStorageType())) {
            this.appendStatement("canUpdate" + doc.getMultiple() + "(" + doc.getVariableName() + ", req)");
            this.appendStatement("check" + doc.getMultiple() + "(" + doc.getVariableName() + ", req)");
        }
        this.appendStatement(doc.getVariableName() + "." + DataFacadeGenerator.getCopyMethodName() + "(sourceLanguage, destLanguage)");
        this.appendStatement(ModuleActionsGenerator.getServiceGetterCall(section.getModule()) + ".update" + doc.getName() + "(" + doc.getVariableName() + ")");
        this.appendStatement("res.sendRedirect(" + this.getEditActionRedirect(doc) + "+" + this.quote("&pId=") + "+id)");
        this.appendStatement("return null");
        this.closeBlockNEW();
    }

    private GeneratedClass generateRestAction(MetaModuleSection section) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        MetaDocument doc = section.getDocument();
        clazz.setPackageName(ModuleActionsGenerator.getPackageRest(section.getModule()));
        String moduleName = section.getModule().getName();
        clazz.addImport("java.util.List");
        clazz.addImport("net.anotheria.anoprise.metafactory.MetaFactory");
        clazz.addImport("net.anotheria.anoprise.metafactory.MetaFactoryException");
        clazz.addImport("jakarta.ws.rs.Consumes");
        clazz.addImport("jakarta.ws.rs.Produces");
        clazz.addImport("jakarta.ws.rs.POST");
        clazz.addImport("jakarta.ws.rs.GET");
        clazz.addImport("jakarta.ws.rs.Path");
        clazz.addImport("jakarta.ws.rs.PathParam");
        clazz.addImport("jakarta.ws.rs.core.Response");
        clazz.addImport("com.google.gson.Gson");
        clazz.addImport("com.google.gson.GsonBuilder");
        clazz.addImport("org.codehaus.jettison.json.JSONArray");
        clazz.addImport("net.anotheria.anosite.gen.shared.util.ParserUtilService");
        clazz.addImport("net.anotheria.anosite.gen." + moduleName.toLowerCase() + ".data." + doc.getName());
        clazz.addImport("net.anotheria.anosite.gen." + moduleName.toLowerCase() + ".service.I" + moduleName + "Service");
        clazz.addImport("net.anotheria.anosite.gen." + moduleName.toLowerCase() + ".service." + moduleName + "ServiceException");
        clazz.addImport("org.slf4j.Logger");
        clazz.addImport("org.slf4j.LoggerFactory");
        clazz.addAnnotation("@Path(\"/" + doc.getName().toLowerCase() + "\")");
        clazz.setName(ModuleActionsGenerator.getResourceActionName(section));
        this.startClassBody();
        this.appendStatement("private static final Logger LOGGER = LoggerFactory.getLogger(" + ModuleActionsGenerator.getResourceActionName(section) + ".class)");
        this.appendStatement("private I" + moduleName + "Service " + moduleName.toLowerCase() + "Service");
        this.appendStatement("private Gson gson");
        this.appendStatement("private GsonBuilder builder");
        ModuleActionsGenerator.emptyline();
        this.append("\tpublic " + ModuleActionsGenerator.getResourceActionName(section) + "() {");
        ModuleActionsGenerator.emptyline();
        this.increaseIdent();
        this.appendStatement("builder = new GsonBuilder()");
        this.appendStatement("builder.setPrettyPrinting()");
        this.appendStatement("gson = builder.create()");
        ModuleActionsGenerator.emptyline();
        this.openTry();
        this.appendStatement(moduleName.toLowerCase() + "Service = MetaFactory.get(I" + moduleName + "Service.class)");
        this.appendCatch("MetaFactoryException");
        this.appendStatement("LOGGER.error(\"Unable to create service: I " + moduleName + "Service\", e)");
        this.appendStatement("throw new RuntimeException(\"Unable to create service\", e)");
        this.closeBlockNEW();
        this.closeBlockNEW();
        ModuleActionsGenerator.emptyline();
        this.append("\t@GET");
        ModuleActionsGenerator.emptyline();
        this.append("\t@Produces(\"application/json;charset=utf-8\")");
        ModuleActionsGenerator.emptyline();
        this.append("\tpublic Response getObjects() {");
        ModuleActionsGenerator.emptyline();
        this.increaseIdent();
        ModuleActionsGenerator.emptyline();
        this.appendStatement("List<" + doc.getName() + "> result = null");
        this.openTry();
        this.appendStatement("result = " + moduleName.toLowerCase() + "Service.get" + doc.getName() + "s()");
        this.appendCatch(moduleName + "ServiceException");
        this.appendStatement("LOGGER.error(\"Unable to get" + doc.getName() + "s\", e)");
        this.appendStatement("return Response.status(500).build()");
        this.closeBlockNEW();
        ModuleActionsGenerator.emptyline();
        this.appendStatement("return Response.status(201).entity(gson.toJson(result)).build()");
        this.closeBlockNEW();
        ModuleActionsGenerator.emptyline();
        this.append("\t@GET");
        ModuleActionsGenerator.emptyline();
        this.append("\t@Path(\"/{id}\")");
        ModuleActionsGenerator.emptyline();
        this.append("\t@Produces(\"application/json;charset=utf-8\")");
        ModuleActionsGenerator.emptyline();
        this.append("\tpublic Response getObject(@PathParam(\"id\") String id) {");
        ModuleActionsGenerator.emptyline();
        this.increaseIdent();
        ModuleActionsGenerator.emptyline();
        this.appendStatement(doc.getName() + " result = null");
        this.openTry();
        this.appendStatement("result = " + moduleName.toLowerCase() + "Service.get" + doc.getName() + "(id)");
        this.appendCatch(moduleName + "ServiceException");
        this.appendStatement("LOGGER.error(\"Unable to get" + doc.getName() + " by id\", e)");
        this.appendStatement("return Response.status(500).build()");
        this.closeBlockNEW();
        ModuleActionsGenerator.emptyline();
        this.appendStatement("return Response.status(201).entity(gson.toJson(result)).build()");
        this.closeBlockNEW();
        ModuleActionsGenerator.emptyline();
        this.appendString("@POST");
        this.appendString("@Consumes(\"application/json;charset=utf-8\")");
        this.appendString("public Response createTransferredObject(String input) {");
        ModuleActionsGenerator.emptyline();
        this.increaseIdent();
        this.openTry();
        this.appendStatement("JSONArray array = new JSONArray(input)");
        this.appendStatement("ParserUtilService.getInstance().addToQueueParsingDocuments(array)");
        this.appendCatch("Exception");
        this.appendStatement("LOGGER.error(\"Unable to parsing transferred objects\", e)");
        this.appendStatement("return Response.status(500).build()");
        this.closeBlockNEW();
        this.appendStatement("return Response.status(201).build()");
        this.closeBlockNEW();
        return clazz;
    }

    private GeneratedClass generateTransferAction(MetaModuleSection section) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        MetaDocument doc = section.getDocument();
        clazz.setPackageName(ModuleActionsGenerator.getPackage(section.getModule()));
        this.addStandardActionImports(clazz);
        clazz.addImport("java.util.HashSet");
        clazz.addImport("java.io.IOException");
        clazz.addImport("java.io.PrintWriter");
        clazz.addImport(ServiceGenerator.getExceptionImport(section.getModule()));
        clazz.addImport("net.anotheria.anosite.config.DocumentTransferConfig");
        clazz.addImport("org.configureme.ConfigurationManager");
        clazz.addImport("org.json.JSONException");
        clazz.addImport("net.anotheria.maf.json.JSONResponse");
        clazz.addImport("org.codehaus.jettison.json.JSONArray");
        clazz.addImport("jakarta.ws.rs.client.Client");
        clazz.addImport("jakarta.ws.rs.client.Entity");
        clazz.addImport("jakarta.ws.rs.core.MediaType");
        clazz.addImport("jakarta.ws.rs.core.Response");
        clazz.addImport("net.anotheria.anosite.util.staticutil.JerseyClientUtil");
        clazz.setName(ModuleActionsGenerator.getTransferActionName(section));
        clazz.setParent(ModuleActionsGenerator.getBaseActionName(section));
        this.startClassBody();
        ModuleActionsGenerator.emptyline();
        this.appendStatement("private static final int STATUS_OK = 201");
        this.appendStatement("private static final String ERROR = \"error\"");
        ModuleActionsGenerator.emptyline();
        this.appendStatement("private DocumentTransferConfig config = DocumentTransferConfig.getInstance()");
        ModuleActionsGenerator.emptyline();
        this.generateTransferActionMethod(clazz, section, "anoDocExecute");
        return clazz;
    }

    private void generateTransferActionMethod(GeneratedClass clazz, MetaModuleSection section, String methodName) {
        this.appendGenerationPoint("generateTransferActionMethod");
        MetaDocument doc = section.getDocument();
        this.appendString(this.getExecuteDeclaration(methodName));
        this.increaseIdent();
        ModuleActionsGenerator.emptyline();
        this.appendStatement("JSONResponse response = new JSONResponse()");
        this.append("\t\tif (ConfigurationManager.INSTANCE.getDefaultEnvironment().expandedStringForm().equals(\"prod\")) {");
        this.increaseIdent();
        ModuleActionsGenerator.emptyline();
        this.appendStatement("response.addError(ERROR, \"Environment is prod\")");
        this.appendStatement("writeTextToResponse(res, response)");
        this.appendStatement("return null");
        this.closeBlockNEW();
        ModuleActionsGenerator.emptyline();
        this.appendStatement("String id = getStringParameter(req, PARAM_ID)");
        this.appendStatement("JSONArray data = new JSONArray()");
        this.openTry();
        this.appendStatement(ModuleActionsGenerator.getServiceGetterCall(section.getModule()) + ".fetch" + doc.getName() + "(id, new HashSet<String>(), data)");
        this.appendCatch(ServiceGenerator.getExceptionName(section.getModule()));
        this.appendStatement("response.addError(ERROR, \"Problem occurred when fetching info about documents -\" + e.getMessage())");
        this.appendStatement("writeTextToResponse(res, response)");
        this.appendStatement("return null");
        this.closeBlockNEW();
        ModuleActionsGenerator.emptyline();
        this.appendStatement("Client client = JerseyClientUtil.getClientInstance()");
        this.appendString("for (String domain :config.getDomains()) {");
        this.increaseIdent();
        this.appendString("Response clientResponse = client.target(domain + \"/api/" + doc.getName().toLowerCase() + "\")");
        this.appendString(" \t\t.request(MediaType.APPLICATION_JSON)");
        this.appendString(" \t\t.post(Entity.entity(data.toString(), MediaType.APPLICATION_JSON));");
        ModuleActionsGenerator.emptyline();
        this.appendString("if (clientResponse.getStatus() != STATUS_OK) {");
        this.increaseIdent();
        this.appendStatement("clientResponse.close()");
        this.appendStatement("response.addError(ERROR, \"Couldn't save transferred objects, status expected 201, got status - \" + clientResponse.getStatus())");
        this.appendStatement("writeTextToResponse(res, response)");
        this.closeBlockNEW();
        ModuleActionsGenerator.emptyline();
        this.appendStatement("clientResponse.close()");
        this.closeBlockNEW();
        this.appendStatement("return null");
        this.closeBlockNEW();
        ModuleActionsGenerator.emptyline();
        this.append("\tprivate void writeTextToResponse(final HttpServletResponse res, final JSONResponse jsonResponse) throws IOException, JSONException {\n\t\tres.setCharacterEncoding(\"UTF-8\");\n\t\tres.setContentType(\"application/json\");\n\t\tPrintWriter writer = res.getWriter();\n\t\twriter.write(jsonResponse.toString());\n\t\twriter.flush();\n\t}\n");
    }

    private GeneratedClass generateEditAction(MetaModuleSection section) {
        MetaFieldElement field;
        MetaProperty p;
        MetaViewElement element;
        int i;
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        this.appendGenerationPoint("generateEditAction");
        MetaDocument doc = section.getDocument();
        MetaDialog dialog = section.getDialogs().get(0);
        List<MetaViewElement> elements = ModuleActionsGenerator.createMultilingualList(dialog.getElements(), doc);
        clazz.setPackageName(ModuleActionsGenerator.getPackage(section.getModule()));
        this.addStandardActionImports(clazz);
        clazz.addImport(ModuleBeanGenerator.getDialogBeanImport(dialog, doc));
        clazz.addImport(DataFacadeGenerator.getDocumentImport(doc));
        if (doc.isMultilingual()) {
            clazz.addImport("net.anotheria.asg.data.MultilingualObject");
        }
        for (i = 0; i < elements.size(); ++i) {
            element = elements.get(i);
            if (!(element instanceof MetaFieldElement) || !(p = doc.getField((field = (MetaFieldElement)element).getName())).isLinked() && !(p instanceof MetaEnumerationProperty)) continue;
            clazz.addImport("java.util.List");
            clazz.addImport("java.util.ArrayList");
            clazz.addImport("net.anotheria.webutils.bean.LabelValueBean");
            break;
        }
        for (i = 0; i < elements.size(); ++i) {
            element = elements.get(i);
            if (!(element instanceof MetaFieldElement) || !((p = doc.getField((field = (MetaFieldElement)element).getName())) instanceof MetaEnumerationProperty)) continue;
            MetaEnumerationProperty mep = (MetaEnumerationProperty)p;
            EnumerationType type = (EnumerationType)GeneratorDataRegistry.getInstance().getType(mep.getEnumeration());
            clazz.addImport(EnumTypeGenerator.getEnumImport(type));
        }
        List<DirectLink> backlinks = GeneratorDataRegistry.getInstance().findLinksToDocument(doc);
        if (backlinks.size() > 0) {
            clazz.addImport("net.anotheria.anodoc.query2.QueryProperty");
            clazz.addImport("net.anotheria.asg.util.bean.LinkToMeBean");
            clazz.addImport("java.util.List");
            clazz.addImport("java.util.ArrayList");
            for (DirectLink l : backlinks) {
                clazz.addImport(DataFacadeGenerator.getDocumentImport(l.getDocument()));
            }
        }
        if (StorageType.CMS.equals((Object)doc.getParentModule().getStorageType())) {
            clazz.addImport("net.anotheria.asg.data.LockableObject");
        }
        this.startClassBody();
        clazz.setName(ModuleActionsGenerator.getEditActionName(section));
        clazz.setParent(ModuleActionsGenerator.getShowActionName(section));
        this.startClassBody();
        this.generateEditActionMethod(clazz, section, "anoDocExecute");
        return clazz;
    }

    private void generateEditActionMethod(GeneratedClass clazz, MetaModuleSection section, String methodname) {
        String propertyCopy;
        this.appendGenerationPoint("generateEditActionMethod");
        MetaDocument doc = section.getDocument();
        MetaDialog dialog = section.getDialogs().get(0);
        List<MetaViewElement> elements = ModuleActionsGenerator.createMultilingualList(dialog.getElements(), doc);
        EnumerationPropertyGenerator enumProGenerator = new EnumerationPropertyGenerator(doc);
        List<DirectLink> backlinks = GeneratorDataRegistry.getInstance().findLinksToDocument(doc);
        this.appendString(this.getExecuteDeclaration(methodname));
        this.increaseIdent();
        this.appendStatement("String id = getStringParameter(req, PARAM_ID)");
        this.appendStatement(ModuleBeanGenerator.getDialogBeanName(dialog, doc), " form = new ", ModuleBeanGenerator.getDialogBeanName(dialog, doc), "() ");
        this.appendStatement(doc.getName(), " ", doc.getVariableName(), " = ", ModuleActionsGenerator.getServiceGetterCall(section.getModule()), ".get", doc.getName(), "(id)");
        boolean isCMS = StorageType.CMS.equals((Object)doc.getParentModule().getStorageType());
        if (isCMS) {
            this.appendStatement("check" + doc.getMultiple() + "(" + doc.getVariableName() + ", req)");
            this.appendString("if(" + doc.getVariableName() + " instanceof LockableObject && !((LockableObject)" + doc.getVariableName() + ").isLocked() && isAutoLockingEnabled())");
            this.appendIncreasedStatement("lock" + doc.getMultiple() + "(" + doc.getVariableName() + ", req)");
        }
        for (int i = 0; i < elements.size(); ++i) {
            MetaModule targetModule;
            String lang;
            MetaViewElement elem = elements.get(i);
            if (!(elem instanceof MetaFieldElement)) continue;
            MetaFieldElement field = (MetaFieldElement)elem;
            MetaProperty p = doc.getField(field.getName());
            if (p instanceof MetaContainerProperty) {
                this.appendString("// " + p.getName() + " is a table, storing size only");
                lang = this.getElementLanguage(elem);
                this.appendStatement("form." + p.toBeanSetter(lang) + "(" + doc.getVariableName() + "." + DataFacadeGenerator.getContainerSizeGetterName((MetaContainerProperty)p, lang) + "())");
            } else {
                lang = this.getElementLanguage(elem);
                Object propertyCopy2 = "";
                propertyCopy2 = (String)propertyCopy2 + "form." + p.toBeanSetter(lang) + "(";
                propertyCopy2 = (String)propertyCopy2 + doc.getVariableName() + "." + p.toGetter(lang) + "())";
                this.appendStatement(new String[]{propertyCopy2});
            }
            if (!p.isLinked() || !elem.isShowLink() || elem instanceof MetaListElement) continue;
            MetaLink link = (MetaLink)p;
            MetaModule metaModule = targetModule = link.getLinkTarget().indexOf(46) == -1 ? doc.getParentModule() : GeneratorDataRegistry.getInstance().getModule(link.getTargetModuleName());
            if (targetModule == null) {
                throw new RuntimeException("Can`t resolve link: " + p + " in document " + doc.getName());
            }
            this.appendStatement("form." + p.toBeanSetter() + "link(\"" + targetModule.getName().toLowerCase() + link.getTargetDocumentName() + "Edit?pId=\"+" + section.getDocument().getName().toLowerCase() + "." + p.toBeanGetter() + "())");
        }
        if (doc.isMultilingual()) {
            MetaProperty p = doc.getField("multilingualInstanceDisabled");
            propertyCopy = "form." + p.toBeanSetter() + "(((MultilingualObject)" + doc.getVariableName() + ").isMultilingualDisabledInstance())";
            this.appendStatement(propertyCopy);
        }
        if (isCMS) {
            MetaProperty prop = new MetaProperty("locked", MetaProperty.Type.BOOLEAN);
            propertyCopy = "form." + prop.toBeanSetter() + "(((LockableObject)" + doc.getVariableName() + ").isLocked())";
            this.appendStatement(propertyCopy);
            prop = new MetaProperty("lockerId", MetaProperty.Type.STRING);
            propertyCopy = "form." + prop.toBeanSetter() + "(((LockableObject)" + doc.getVariableName() + ").getLockerId())";
            this.appendStatement(propertyCopy);
            prop = new MetaProperty("lockingTime", MetaProperty.Type.STRING);
            propertyCopy = "form." + prop.toBeanSetter() + "(net.anotheria.util.NumberUtils.makeISO8601TimestampString(((LockableObject)" + doc.getVariableName() + ").getLockingTime()) + \" automatic unlock expected AT : \" + net.anotheria.util.NumberUtils.makeISO8601TimestampString(((LockableObject)" + doc.getVariableName() + ").getLockingTime() + getLockingTimeout()))";
            this.appendStatement(propertyCopy);
        }
        ModuleActionsGenerator.emptyline();
        HashSet<String> linkTargets = new HashSet<String>();
        for (int i = 0; i < elements.size(); ++i) {
            MetaViewElement element = elements.get(i);
            if (!(element instanceof MetaFieldElement)) continue;
            MetaFieldElement field = (MetaFieldElement)element;
            MetaProperty p = doc.getField(field.getName());
            if (p.isLinked()) {
                MetaModule targetModule;
                MetaLink link = (MetaLink)p;
                MetaModule metaModule = targetModule = link.getLinkTarget().indexOf(46) == -1 ? doc.getParentModule() : GeneratorDataRegistry.getInstance().getModule(link.getTargetModuleName());
                if (targetModule == null) {
                    throw new RuntimeException("Can't resolve link: " + p + " in document " + doc.getName() + " and dialog " + dialog.getName());
                }
                String tDocName = link.getTargetDocumentName();
                MetaDocument targetDocument = targetModule.getDocumentByName(tDocName);
                String listName = targetDocument.getMultiple().toLowerCase();
                ModuleActionsGenerator.emptyline();
                if (linkTargets.contains(link.getLinkTarget())) {
                    this.appendString("//reusing collection for " + link.getName() + " to " + link.getLinkTarget() + ".");
                } else {
                    this.appendString("//link " + link.getName() + " to " + link.getLinkTarget());
                    clazz.addImport(DataFacadeGenerator.getDocumentImport(targetDocument));
                    this.appendStatement("List<" + targetDocument.getName() + "> " + listName + " = " + ModuleActionsGenerator.getServiceGetterCall(targetModule) + ".get" + targetDocument.getMultiple() + "()");
                    this.appendStatement("List<LabelValueBean> " + listName + "Values = new ArrayList<LabelValueBean>(" + listName + ".size()+1)");
                    this.appendStatement(listName + "Values.add(new LabelValueBean(" + this.quote("") + ", \"-----\"))");
                    this.appendString("for (" + DataFacadeGenerator.getDocumentImport(targetDocument) + " " + targetDocument.getVariableName() + "Temp : " + listName + "){");
                    this.increaseIdent();
                    String linkDecorationStr = this.generateLinkDecoration(targetDocument, link);
                    this.appendStatement("LabelValueBean bean = new LabelValueBean(" + targetDocument.getVariableName() + "Temp.getId(), " + linkDecorationStr + " )");
                    this.appendStatement(listName, "Values.add(bean)");
                    this.closeBlockNEW();
                }
                String lang = this.getElementLanguage(element);
                this.appendStatement("form." + p.toBeanSetter() + "Collection" + (lang == null ? "" : lang) + "(" + listName + "Values)");
                this.appendString("try{");
                this.increaseIdent();
                String getter = ModuleActionsGenerator.getServiceGetterCall(targetModule) + ".get" + targetDocument.getName() + "(" + doc.getVariableName() + "." + p.toGetter(lang) + "()).getName()";
                String getterUnknown = ModuleActionsGenerator.getServiceGetterCall(targetModule) + ".get" + targetDocument.getName() + "(" + doc.getVariableName() + "." + p.toGetter() + "())";
                if (doc.getName().equalsIgnoreCase("box")) {
                    if (element.getName().equalsIgnoreCase("handler")) {
                        this.appendString("if ( " + getterUnknown + " instanceof BoxHandlerDef ) {");
                        this.appendIncreasedStatement("String " + p.getName() + "Id = (String)" + getterUnknown + ".getId()");
                        this.appendIncreasedStatement("int index = " + p.getName() + "Id.indexOf(\"C-\")");
                        this.appendIncreasedString("if ( index != -1 ) {");
                        this.increaseIdent();
                        this.appendIncreasedStatement("form." + p.toBeanSetter() + "IdOfCurrentValue" + (lang == null ? "" : lang) + "( " + p.getName() + "Id.substring(index+2) )");
                        this.decreaseIdent();
                        this.appendIncreasedString("} else {");
                        this.increaseIdent();
                        this.appendIncreasedStatement("form." + p.toBeanSetter() + "IdOfCurrentValue" + (lang == null ? "" : lang) + "( \"none\" )");
                        this.decreaseIdent();
                        this.appendIncreasedString("}");
                        this.appendString("}");
                    }
                    if (element.getName().equalsIgnoreCase("type")) {
                        this.appendString("if ( " + getterUnknown + " instanceof BoxType ) {");
                        this.appendIncreasedStatement("String " + p.getName() + "Id = (String)" + getterUnknown + ".getId()");
                        this.appendIncreasedStatement("int index = " + p.getName() + "Id.indexOf(\"C-\")");
                        this.appendIncreasedString("if ( index != -1 ) {");
                        this.increaseIdent();
                        this.appendIncreasedStatement("form." + p.toBeanSetter() + "IdOfCurrentValue" + (lang == null ? "" : lang) + "( " + p.getName() + "Id.substring(index+2) )");
                        this.decreaseIdent();
                        this.appendIncreasedString("} else {");
                        this.increaseIdent();
                        this.appendIncreasedStatement("form." + p.toBeanSetter() + "IdOfCurrentValue" + (lang == null ? "" : lang) + "( \"none\" )");
                        this.decreaseIdent();
                        this.appendIncreasedString("}");
                        this.appendString("}");
                    }
                }
                this.appendStatement("form." + p.toBeanSetter() + "CurrentValue" + (lang == null ? "" : lang) + "(" + getter + ")");
                this.decreaseIdent();
                this.appendString("}catch(Exception e){");
                this.appendIncreasedStatement("form." + p.toBeanSetter() + "CurrentValue" + (lang == null ? "" : lang) + "(" + this.quote("none") + ")");
                this.appendIncreasedStatement("form." + p.toBeanSetter() + "IdOfCurrentValue" + (lang == null ? "" : lang) + "(" + this.quote("none") + ")");
                this.appendString("}");
                linkTargets.add(link.getLinkTarget());
            }
            if (!(p instanceof MetaEnumerationProperty)) continue;
            enumProGenerator.generateEnumerationPropertyHandling((MetaEnumerationProperty)p, true);
        }
        this.appendStatement("addBeanToRequest(req, " + this.quote("objectId") + " , " + doc.getVariableName() + ".getId())");
        this.appendStatement("addBeanToRequest(req, " + this.quote(CMSMappingsConfiguratorGenerator.getDialogFormName(dialog, doc)) + " , form)");
        this.appendStatement("addBeanToRequest(req, " + this.quote("objectInfoString") + " , " + doc.getVariableName() + ".getObjectInfo().toString())");
        this.appendStatement("addBeanToRequest(req, " + this.quote("apply.label.prefix") + ", " + this.quote("Apply") + ")");
        this.appendStatement("addBeanToRequest(req, " + this.quote("save.label.prefix") + ", " + this.quote("Save") + ")");
        this.appendStatement("addBeanToRequest(req, " + this.quote("transfer.label.prefix") + ", " + this.quote("Transfer") + ")");
        ModuleActionsGenerator.emptyline();
        this.appendStatement("addFieldExplanations(req, " + doc.getVariableName() + ")");
        ModuleActionsGenerator.emptyline();
        if (backlinks.size() > 0) {
            ModuleActionsGenerator.emptyline();
            this.appendCommentLine("Generating back link handling...");
            this.appendStatement("List<LinkToMeBean> linksToMe = findLinksToCurrentDocument(" + doc.getVariableName() + ".getId())");
            this.appendString("if (linksToMe.size()>0)");
            this.appendIncreasedStatement("req.setAttribute(" + this.quote("linksToMe") + ", linksToMe)");
        }
        this.appendStatement("return mapping.success()");
        this.closeBlockNEW();
        ModuleActionsGenerator.emptyline();
        Context context = GeneratorDataRegistry.getInstance().getContext();
        if (backlinks.size() > 0) {
            this.appendString("private List<LinkToMeBean> findLinksToCurrentDocument(String documentId){");
            this.increaseIdent();
            this.appendStatement("List<LinkToMeBean> ret = new ArrayList<LinkToMeBean>()");
            for (DirectLink l : backlinks) {
                this.appendString("try{");
                Object methodName = "";
                if (l.getProperty().isMultilingual()) {
                    for (String lang : context.getLanguages()) {
                        methodName = "findLinkToCurrentDocumentIn" + l.getModule().getName() + l.getDocument().getName() + StringUtils.capitalize((String)l.getProperty().getName(lang));
                        this.appendIncreasedStatement("ret.addAll(" + (String)methodName + "(documentId))");
                    }
                } else {
                    methodName = "findLinkToCurrentDocumentIn" + l.getModule().getName() + l.getDocument().getName() + StringUtils.capitalize((String)l.getProperty().getName());
                    this.appendIncreasedStatement("ret.addAll(" + (String)methodName + "(documentId))");
                }
                this.appendString("}catch(Exception ignored){");
                this.appendString("}");
            }
            this.appendStatement("return ret");
            this.closeBlockNEW();
            for (DirectLink l : backlinks) {
                if (l.getProperty().isMultilingual()) {
                    for (String lang : context.getLanguages()) {
                        this.appendString("private List<LinkToMeBean> findLinkToCurrentDocumentIn" + l.getModule().getName() + l.getDocument().getName() + StringUtils.capitalize((String)l.getProperty().getName(lang)) + "(String documentId) throws " + ServiceGenerator.getExceptionImport(l.getModule()) + "{");
                        this.increaseIdent();
                        this.appendStatement("List<LinkToMeBean> ret = new ArrayList<LinkToMeBean>()");
                        this.appendStatement("QueryProperty p = new QueryProperty(" + l.getDocument().getName() + "." + l.getProperty().toNameConstant(lang) + ", documentId)");
                        this.appendCommentLine("temporarly - replacy with query property");
                        this.appendStatement("List<" + l.getDocument().getName() + "> list = " + ModuleActionsGenerator.getServiceGetterCall(l.getModule()) + ".get" + l.getDocument().getMultiple() + "ByProperty(p.getName(), p.getValue())");
                        this.appendString("for (" + l.getDocument().getName() + " doc : list ){");
                        this.increaseIdent();
                        this.appendStatement("ret.add(new LinkToMeBean(doc, " + this.quote(l.getProperty().getName()) + "))");
                        this.closeBlockNEW();
                        this.appendStatement("return ret");
                        this.closeBlockNEW();
                    }
                    continue;
                }
                this.appendString("private List<LinkToMeBean> findLinkToCurrentDocumentIn" + l.getModule().getName() + l.getDocument().getName() + StringUtils.capitalize((String)l.getProperty().getName()) + "(String documentId) throws " + ServiceGenerator.getExceptionImport(l.getModule()) + "{");
                this.increaseIdent();
                this.appendStatement("List<LinkToMeBean> ret = new ArrayList<LinkToMeBean>()");
                this.appendStatement("QueryProperty p = new QueryProperty(" + l.getDocument().getName() + "." + l.getProperty().toNameConstant() + ", documentId)");
                this.appendCommentLine("temporarly - replacy with query property");
                this.appendStatement("List<" + l.getDocument().getName() + "> list = " + ModuleActionsGenerator.getServiceGetterCall(l.getModule()) + ".get" + l.getDocument().getMultiple() + "ByProperty(p.getName(), p.getValue())");
                this.appendString("for (" + l.getDocument().getName() + " doc : list ){");
                this.increaseIdent();
                this.appendStatement("ret.add(new LinkToMeBean(doc, " + this.quote(l.getProperty().getName()) + "))");
                this.closeBlockNEW();
                this.appendStatement("return ret");
                this.closeBlockNEW();
            }
        }
    }

    private String generateLinkDecoration(MetaDocument doc, MetaLink link) {
        String tDocName = link.getTargetDocumentName();
        MetaModule targetModule = link.getLinkTarget().indexOf(46) == -1 ? doc.getParentModule() : GeneratorDataRegistry.getInstance().getModule(link.getTargetModuleName());
        MetaDocument targetDocument = targetModule.getDocumentByName(tDocName);
        Object linkDecorationStr = "";
        boolean first = true;
        for (String decoration : link.getLinkDecoration()) {
            if (!first) {
                linkDecorationStr = (String)linkDecorationStr + " + \" - \" + ";
            }
            first = false;
            linkDecorationStr = (String)linkDecorationStr + targetDocument.getVariableName() + "Temp.get" + StringUtils.capitalize((String)decoration) + "()";
        }
        linkDecorationStr = (String)linkDecorationStr + " + \" [\" + " + targetDocument.getVariableName() + "Temp.getId() + \"]\"";
        return linkDecorationStr;
    }

    private GeneratedClass generateDeleteAction(MetaModuleSection section) {
        return null;
    }

    private void generateDeleteActionMethod(MetaModuleSection section, String methodName) {
        MetaDocument doc = section.getDocument();
        this.appendString(this.getExecuteDeclaration(methodName));
        this.increaseIdent();
        this.appendStatement("String[] iDs = req.getParameterValues(PARAM_ID)");
        this.appendString("if (iDs == null){");
        this.increaseIdent();
        this.appendStatement("throw new RuntimeException(\"Parameter \" + PARAM_ID + \" is not set.\")");
        this.closeBlockNEW();
        this.appendString("for (String id : iDs){");
        this.increaseIdent();
        this.appendStatement(doc.getName() + " " + doc.getVariableName() + "Curr = " + ModuleActionsGenerator.getServiceGetterCall(section.getModule()) + ".get" + doc.getName() + "(id)");
        if (StorageType.CMS.equals((Object)section.getDocument().getParentModule().getStorageType())) {
            this.appendString("if (" + doc.getVariableName() + "Curr instanceof LockableObject){ ");
            this.increaseIdent();
            this.appendStatement("LockableObject lockable = (LockableObject)" + doc.getVariableName() + "Curr");
            this.appendStatement("DocumentLockingHelper.delete.checkExecutionPermission(lockable, false, getUserId(req))");
            this.closeBlockNEW();
        }
        this.appendStatement(ModuleActionsGenerator.getServiceGetterCall(section.getModule()) + ".delete" + doc.getName() + "(id)");
        for (MetaProperty property : section.getDocument().getProperties()) {
            MetaListProperty mlp;
            MetaProperty containerProperty;
            if (property.getType() == MetaProperty.Type.IMAGE) {
                this.appendStatement("FileStorage.removeFilePermanently( " + doc.getVariableName() + "Curr." + property.toGetter() + "() )");
            }
            if (!(property instanceof MetaListProperty) || (containerProperty = (mlp = (MetaListProperty)property).getContainedProperty()).getType() != MetaProperty.Type.IMAGE) continue;
            this.appendString("for ( String image : " + doc.getVariableName() + "Curr." + property.toGetter() + "() )");
            this.appendStatement("FileStorage.removeFilePermanently(image)");
        }
        this.closeBlockNEW();
        this.appendStatement("res.sendRedirect(" + this.getShowActionRedirect(doc) + ")");
        this.appendStatement("return null");
        this.closeBlockNEW();
    }

    private GeneratedClass generateDuplicateAction(MetaModuleSection section) {
        return null;
    }

    private void generateDuplicateActionMethod(MetaModuleSection section, String methodName) {
        MetaDocument doc = section.getDocument();
        this.appendString(this.getExecuteDeclaration(methodName));
        this.increaseIdent();
        this.appendStatement("String id = getStringParameter(req, PARAM_ID)");
        this.appendStatement(doc.getName() + " " + doc.getVariableName() + "Src = " + ModuleActionsGenerator.getServiceGetterCall(section.getModule()) + ".get" + doc.getName() + "(id)");
        this.appendStatement(doc.getName() + " " + doc.getVariableName() + "Dest = " + DataFacadeGenerator.getDocumentFactoryName(doc) + ".create" + doc.getName() + "(" + doc.getVariableName() + "Src)");
        ModuleActionsGenerator.emptyline();
        for (MetaProperty property : section.getDocument().getProperties()) {
            if (property.getType() == MetaProperty.Type.IMAGE) {
                this.appendStatement(doc.getVariableName() + "Dest." + property.toSetter() + "(FileStorage.cloneFilePermanently( " + doc.getVariableName() + "Dest." + property.toGetter() + "() ))");
            }
            if (!(property instanceof MetaListProperty)) continue;
            ModuleActionsGenerator.emptyline();
            MetaListProperty mlp = (MetaListProperty)property;
            MetaProperty containerProperty = mlp.getContainedProperty();
            if (containerProperty.getType() != MetaProperty.Type.IMAGE) continue;
            String listName = "newImages" + property.getName();
            this.appendStatement("List<String> " + listName + " = new ArrayList<String>()");
            this.appendString("for ( String image : " + doc.getVariableName() + "Dest." + property.toGetter() + "() )");
            this.appendStatement(listName + ".add(FileStorage.cloneFilePermanently(image))");
            this.appendStatement(doc.getVariableName() + "Dest." + property.toSetter() + "(" + listName + ")");
        }
        ModuleActionsGenerator.emptyline();
        this.appendStatement(doc.getName() + " " + doc.getVariableName() + "Created = " + ModuleActionsGenerator.getServiceGetterCall(section.getModule()) + ".create" + doc.getName() + "(" + doc.getVariableName() + "Dest)");
        this.appendStatement("res.sendRedirect(" + this.getEditActionRedirect(doc) + "+" + this.quote("&") + "+PARAM_ID+" + this.quote("=") + "+" + doc.getVariableName() + "Created.getId())");
        ModuleActionsGenerator.emptyline();
        this.appendStatement("return null");
        this.closeBlockNEW();
    }

    private GeneratedClass generateNewAction(MetaModuleSection section) {
        MetaFieldElement field;
        MetaProperty p;
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        MetaDocument doc = section.getDocument();
        MetaDialog dialog = section.getDialogs().get(0);
        List<MetaViewElement> elements = ModuleActionsGenerator.createMultilingualList(dialog.getElements(), doc);
        clazz.setPackageName(ModuleActionsGenerator.getPackage(section.getModule()));
        this.addStandardActionImports(clazz);
        clazz.addImport(ModuleBeanGenerator.getDialogBeanImport(dialog, doc));
        clazz.addImport("net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil");
        clazz.addImport("net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry");
        for (MetaViewElement element : elements) {
            if (!(element instanceof MetaFieldElement) || !(p = doc.getField((field = (MetaFieldElement)element).getName())).isLinked() && !(p instanceof MetaEnumerationProperty)) continue;
            clazz.addImport("java.util.List");
            clazz.addImport("java.util.ArrayList");
            clazz.addImport("net.anotheria.webutils.bean.LabelValueBean");
        }
        for (MetaViewElement element : elements) {
            if (!(element instanceof MetaFieldElement) || !((p = doc.getField((field = (MetaFieldElement)element).getName())) instanceof MetaEnumerationProperty)) continue;
            MetaEnumerationProperty mep = (MetaEnumerationProperty)p;
            EnumerationType type = (EnumerationType)GeneratorDataRegistry.getInstance().getType(mep.getEnumeration());
            clazz.addImport(EnumTypeGenerator.getEnumImport(type));
        }
        clazz.setName(ModuleActionsGenerator.getNewActionName(section));
        clazz.setParent(ModuleActionsGenerator.getShowActionName(section));
        this.startClassBody();
        this.appendString(this.getExecuteDeclaration());
        this.increaseIdent();
        this.appendStatement(ModuleBeanGenerator.getDialogBeanName(dialog, doc) + " form = new " + ModuleBeanGenerator.getDialogBeanName(dialog, doc) + "() ");
        this.appendStatement("form.setId(" + this.quote("") + ")");
        this.appendPrepareFormForEditView(elements, doc, true);
        ModuleActionsGenerator.emptyline();
        this.appendStatement("addBeanToRequest(req, " + this.quote(CMSMappingsConfiguratorGenerator.getDialogFormName(dialog, doc)) + " , form)");
        this.appendStatement("addBeanToRequest(req, " + this.quote("save.label.prefix") + ", " + this.quote("Save") + ")");
        this.appendStatement("addBeanToRequest(req, " + this.quote("apply.label.prefix") + " , " + this.quote("Apply") + ")");
        this.appendStatement("addBeanToRequest(req, " + this.quote("transfer.label.prefix") + ", " + this.quote("Transfer") + ")");
        this.appendStatement("addBeanToRequest(req, " + this.quote("objectInfoString") + " , " + this.quote("none") + ")");
        ModuleActionsGenerator.emptyline();
        this.appendStatement("addFieldExplanations(req, null)");
        ModuleActionsGenerator.emptyline();
        this.appendStatement("return mapping.success()");
        this.closeBlock("");
        return clazz;
    }

    private void appendPrepareFormForEditView(List<MetaViewElement> elements, MetaDocument doc, boolean newDocument) {
        HashSet<String> linkTargets = new HashSet<String>();
        EnumerationPropertyGenerator enumPropGen = new EnumerationPropertyGenerator(doc);
        for (MetaViewElement element : elements) {
            if (!(element instanceof MetaFieldElement)) continue;
            MetaFieldElement field = (MetaFieldElement)element;
            MetaProperty p = doc.getField(field.getName());
            if (p.isLinked()) {
                MetaLink link = (MetaLink)p;
                MetaModule targetModule = link.isRelative() ? doc.getParentModule() : GeneratorDataRegistry.getInstance().getModule(link.getTargetModuleName());
                String tDocName = link.getTargetDocumentName();
                MetaDocument targetDocument = targetModule.getDocumentByName(tDocName);
                String listName = targetDocument.getMultiple().toLowerCase();
                ModuleActionsGenerator.emptyline();
                if (linkTargets.contains(link.getLinkTarget())) {
                    this.appendString("//link " + link.getName() + " to " + link.getLinkTarget() + " reuses collection.");
                } else {
                    this.appendString("//link " + link.getName() + " to " + link.getLinkTarget());
                    this.appendStatement("List<" + DataFacadeGenerator.getDocumentImport(targetDocument) + "> " + listName + " = " + ModuleActionsGenerator.getServiceGetterCall(targetModule) + ".get" + targetDocument.getMultiple() + "()");
                    this.appendStatement("List<LabelValueBean> " + listName + "Values = new ArrayList<LabelValueBean>(" + listName + ".size()+1)");
                    this.appendStatement(listName + "Values.add(new LabelValueBean(" + this.quote("") + ", \"-----\"))");
                    this.appendString("for (" + DataFacadeGenerator.getDocumentImport(targetDocument) + " " + targetDocument.getVariableName() + " : " + listName + "){");
                    this.increaseIdent();
                    this.appendStatement("LabelValueBean bean = new LabelValueBean(" + targetDocument.getVariableName() + ".getId(), " + targetDocument.getVariableName() + ".getName() )");
                    this.appendStatement(listName + "Values.add(bean)");
                    this.closeBlockNEW();
                }
                String lang = this.getElementLanguage(element);
                this.appendStatement("form." + p.toBeanSetter() + "Collection" + (lang == null ? "" : lang) + "(" + listName + "Values)");
                if (!newDocument) {
                    this.appendString("try{");
                    this.increaseIdent();
                    String getter = ModuleActionsGenerator.getServiceGetterCall(targetModule) + ".get" + targetDocument.getName() + "(form." + p.toBeanGetter(lang) + "()).getName()";
                    this.appendStatement("form." + p.toBeanSetter() + "CurrentValue" + (lang == null ? "" : lang) + "(" + getter + ")");
                    this.decreaseIdent();
                    this.appendString("}catch(Exception e){");
                    this.appendIncreasedStatement("form." + p.toBeanSetter() + "CurrentValue" + (lang == null ? "" : lang) + "(" + this.quote("none") + ")");
                    this.appendString("}");
                }
                linkTargets.add(link.getLinkTarget());
            }
            if (!(p instanceof MetaEnumerationProperty)) continue;
            enumPropGen.generateEnumerationPropertyHandling((MetaEnumerationProperty)p, false);
            if (newDocument) continue;
            MetaEnumerationProperty mep = (MetaEnumerationProperty)p;
            EnumerationType type = (EnumerationType)GeneratorDataRegistry.getInstance().getType(mep.getEnumeration());
            this.openTry();
            this.appendStatement("form." + mep.toBeanSetter() + "CurrentValue(" + EnumTypeGenerator.getEnumClassName(type) + ".getConstantByValue(form." + mep.toBeanGetter() + "()).name())");
            this.appendCatch(ConstantNotFoundException.class);
            this.closeBlock("try");
        }
    }

    private void appendAddFieldExplanationsMethod(MetaDocument doc) {
        this.appendString("protected void addFieldExplanations(HttpServletRequest req, " + doc.getName() + " " + doc.getVariableName() + ") {");
        this.increaseIdent();
        this.appendString("if (!CMSViewHelperRegistry.getCMSViewHelpers(" + this.quote(doc.getParentModule().getName() + "." + doc.getName()) + ").isEmpty()) {");
        this.increaseIdent();
        this.appendStatement("String fieldDescription = null");
        for (MetaProperty p : doc.getProperties()) {
            this.appendStatement("fieldDescription = CMSViewHelperUtil.getFieldExplanation(" + this.quote(doc.getParentModule().getName() + "." + doc.getName()) + ", " + doc.getVariableName() + ", " + this.quote(p.getName()) + ")");
            this.appendString("if (fieldDescription!=null && fieldDescription.length()>0)");
            this.appendIncreasedStatement("req.setAttribute(" + this.quote("description." + p.getName()) + ", fieldDescription)");
        }
        this.closeBlock("");
        this.closeBlock("addFieldExplanations END");
        ModuleActionsGenerator.emptyline();
    }

    private GeneratedClass generateBaseAction(MetaModuleSection section) {
        MetaDocument doc = section.getDocument();
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        this.appendGenerationPoint("generateBaseAction");
        clazz.setPackageName(ModuleActionsGenerator.getPackage(section.getModule()));
        clazz.setAbstractClass(true);
        boolean isCMS = StorageType.CMS.equals((Object)section.getModule().getStorageType());
        ModuleActionsGenerator.emptyline();
        clazz.addImport(GeneratorDataRegistry.getInstance().getContext().getPackageName(MetaModule.SHARED) + ".action." + BaseViewActionGenerator.getViewActionName(this.view));
        if (isCMS) {
            clazz.addImport("jakarta.servlet.http.HttpServletRequest");
            clazz.addImport(DataFacadeGenerator.getDocumentImport(doc));
            clazz.addImport("net.anotheria.asg.data.AbstractASGDocument");
            clazz.addImport("net.anotheria.asg.data.LockableObject");
            clazz.addImport("net.anotheria.asg.util.locking.exeption.LockingException");
            clazz.addImport("net.anotheria.asg.util.locking.helper.DocumentLockingHelper");
            clazz.addImport("org.slf4j.Logger");
            clazz.addImport("org.slf4j.LoggerFactory");
            clazz.addImport(CMSViewHelperRegistry.class);
            clazz.addImport(CMSViewHelperUtil.class);
        }
        clazz.setName(ModuleActionsGenerator.getBaseActionName(section));
        clazz.setParent(BaseViewActionGenerator.getViewActionName(this.view));
        this.startClassBody();
        if (isCMS) {
            this.appendStatement("private final Logger logger = LoggerFactory.getLogger(\"cms-lock-log\")");
        }
        this.appendString("protected String getTitle(){");
        this.increaseIdent();
        this.appendStatement("return " + this.quote(section.getTitle()));
        this.closeBlock("getTitle");
        ModuleActionsGenerator.emptyline();
        this.appendString("protected String getCurrentModuleDefName(){");
        this.increaseIdent();
        this.appendStatement("return " + this.quote(section.getModule().getName()));
        this.closeBlock("getCurrentModuleDefName");
        ModuleActionsGenerator.emptyline();
        this.appendString("protected String getCurrentDocumentDefName(){");
        this.increaseIdent();
        this.appendStatement("return " + this.quote(section.getDocument().getName()));
        this.closeBlock("getCurrentDocumentDefName");
        ModuleActionsGenerator.emptyline();
        if (isCMS) {
            this.appendAddFieldExplanationsMethod(doc);
            ModuleActionsGenerator.emptyline();
        }
        if (isCMS) {
            this.appendComment("Executing locking. Actually.");
            this.appendString("protected void lock" + doc.getMultiple() + "(" + doc.getName() + " " + doc.getVariableName() + ", HttpServletRequest req) throws Exception{");
            this.increaseIdent();
            this.appendString("if(" + doc.getVariableName() + " instanceof AbstractASGDocument){");
            this.appendIncreasedStatement("AbstractASGDocument lock = (AbstractASGDocument)" + doc.getVariableName());
            this.appendIncreasedStatement("lock.setLocked(true)");
            this.appendIncreasedStatement("lock.setLockerId(getUserId(req))");
            this.appendIncreasedStatement("lock.setLockingTime(System.currentTimeMillis())");
            this.appendIncreasedStatement(ModuleActionsGenerator.getServiceGetterCall(section.getModule()) + ".update" + doc.getName() + "( " + doc.getVariableName() + ")");
            this.appendIncreasedStatement("logger.info(" + this.quote("Lock-OPERATION, document with id : [") + "+" + doc.getVariableName() + ".getId()+" + this.quote("] was locked by: ") + " + getUserId(req))");
            this.appendIncreasedStatement("addLockedAttribute(req, lock)");
            this.appendString("}");
            this.closeBlockNEW();
            this.appendComment("Executing unlocking. Actually.");
            this.appendString("protected void unLock" + doc.getMultiple() + "(" + doc.getName() + " " + doc.getVariableName() + ", HttpServletRequest req, boolean unlockByTimeoout) throws Exception{");
            this.increaseIdent();
            this.appendString("if(" + doc.getVariableName() + " instanceof AbstractASGDocument){");
            this.appendIncreasedStatement("AbstractASGDocument lock = (AbstractASGDocument)" + doc.getVariableName());
            this.appendIncreasedStatement("lock.setLocked(false)");
            this.appendIncreasedStatement("lock.setLockerId(\"\")");
            this.appendIncreasedStatement("lock.setLockingTime(0)");
            this.appendIncreasedStatement(ModuleActionsGenerator.getServiceGetterCall(section.getModule()) + ".update" + doc.getName() + "( " + doc.getVariableName() + ")");
            this.appendIncreasedString("if (!unlockByTimeoout){");
            this.appendIncreasedStatement("   logger.info(" + this.quote("UnLock-OPERATION, document with id : [") + "+" + doc.getVariableName() + ".getId()+" + this.quote("] was unlocked by: ") + " + getUserId(req) +" + this.quote("  with 'admin' role :") + " + isUserInRole(req, \"admin\") )");
            this.appendIncreasedString(" } else { ");
            this.appendIncreasedStatement("   logger.info(" + this.quote("UnLock-OPERATION, document with id : [") + "+" + doc.getVariableName() + ".getId()+" + this.quote("] was unlocked by: timeOut") + ")");
            this.appendIncreasedString("}");
            this.appendIncreasedStatement("removeLockedAttribute(req, lock)");
            this.appendString("}");
            this.closeBlockNEW();
            this.appendComment("Executing auto-unlocking check....");
            this.appendString("protected void check" + doc.getMultiple() + "(" + doc.getName() + " " + doc.getVariableName() + ", HttpServletRequest req) throws Exception{");
            this.increaseIdent();
            this.appendStatement("boolean shouldUnlock = " + doc.getVariableName() + " instanceof AbstractASGDocument && \n \t \t \t \t ((AbstractASGDocument)" + doc.getVariableName() + ").isLocked() && \n \t \t \t \t ( System.currentTimeMillis() >= ((AbstractASGDocument)" + doc.getVariableName() + ").getLockingTime() + getLockingTimeout())");
            this.appendString("if(shouldUnlock)");
            this.appendIncreasedStatement("unLock" + doc.getMultiple() + "(" + doc.getVariableName() + ", req, true)");
            this.closeBlockNEW();
            this.appendComment("Checking UpdateCapability rights");
            this.appendString("protected void canUpdate" + doc.getMultiple() + "(" + doc.getName() + " " + doc.getVariableName() + ", HttpServletRequest req) throws Exception{");
            this.increaseIdent();
            this.appendString("if(" + doc.getVariableName() + " instanceof LockableObject ){");
            this.appendString("//Actually - simplest Check! --  exception - if anything happens!!!!");
            this.appendIncreasedStatement("DocumentLockingHelper.update.checkExecutionPermission((LockableObject)" + doc.getVariableName() + ", false, getUserId(req))");
            this.appendString("}");
            this.appendString("if (isTimeoutReached(" + doc.getVariableName() + ")) {");
            this.appendIncreasedStatement("check" + doc.getMultiple() + "(" + doc.getVariableName() + ", req)");
            this.appendIncreasedStatement("throw new LockingException(getUserId(req)+\" . Document can't be updated! Due to lock - timeout!!!\")");
            this.appendString("}");
            this.appendString("if (wasUnlockedByAdmin(" + doc.getVariableName() + ", req)) {");
            this.appendIncreasedStatement("throw new LockingException(getUserId(req)+\" . Document can't be updated! It was unlocked by user in 'admin' role!!!\")");
            this.appendString("}");
            this.closeBlockNEW();
            this.appendComment("");
            this.appendString("private boolean isTimeoutReached(" + doc.getName() + " " + doc.getVariableName() + "){");
            this.increaseIdent();
            this.appendString("if (" + doc.getVariableName() + " instanceof LockableObject) {");
            this.appendIncreasedStatement("LockableObject lock = (LockableObject)" + doc.getVariableName());
            this.appendIncreasedStatement("return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis()");
            this.appendString("}");
            this.appendStatement("return false");
            this.closeBlockNEW();
            this.appendComment("");
            this.appendString("private boolean wasUnlockedByAdmin(" + doc.getName() + " " + doc.getVariableName() + ", HttpServletRequest req){");
            this.increaseIdent();
            this.appendString("if (" + doc.getVariableName() + " instanceof AbstractASGDocument) {");
            this.appendIncreasedStatement("AbstractASGDocument lock = (AbstractASGDocument)" + doc.getVariableName());
            this.appendIncreasedStatement("return !lock.isLocked() && containsLockedAttribute(req, lock)");
            this.appendString("}");
            this.appendStatement("return false");
            this.closeBlockNEW();
        }
        return clazz;
    }

    public static String getPackage() {
        return ModuleActionsGenerator.getPackage(GeneratorDataRegistry.getInstance().getContext());
    }

    public static String getPackage(MetaModule module) {
        return ModuleActionsGenerator.getPackage(GeneratorDataRegistry.getInstance().getContext(), module);
    }

    public static String getPackageRest(MetaModule module) {
        return GeneratorDataRegistry.getInstance().getContext().getPackageName(module) + ".rest";
    }

    public static String getPackage(Context context) {
        return context.getPackageName() + ".action";
    }

    public static String getPackage(Context context, MetaModule module) {
        return context.getPackageName(module) + ".action";
    }

    public static String getPackage(MetaDocument doc) {
        return GeneratorDataRegistry.getInstance().getContext().getPackageName(doc) + ".action";
    }

    public static String getServiceInstanceName(MetaModule module) {
        return module.getName().toLowerCase() + "Service";
    }

    public static String getServiceGetterName(MetaModule module) {
        return "get" + module.getName() + "Service";
    }

    public static String getServiceGetterCall(MetaModule module) {
        return ModuleActionsGenerator.getServiceGetterName(module) + "()";
    }

    private String getExecuteDeclaration() {
        return this.getExecuteDeclaration(null);
    }

    private String getExecuteDeclaration(String methodName) {
        Object ret = "";
        ret = (String)ret + "public ActionCommand " + (methodName == null ? "anoDocExecute" : methodName) + "(";
        ret = (String)ret + "ActionMapping mapping, ";
        ret = (String)ret + "HttpServletRequest req, ";
        ret = (String)ret + "HttpServletResponse res) ";
        ret = (String)ret + "throws Exception{";
        return ret;
    }

    private String getSuperCall() {
        Object ret = "";
        ret = (String)ret + "super.anoDocExecute(";
        ret = (String)ret + "mapping, ";
        ret = (String)ret + "req, ";
        ret = (String)ret + "res) ";
        return ret;
    }

    private void addStandardActionImports(GeneratedClass clazz) {
        clazz.addImport("jakarta.servlet.http.HttpServletRequest");
        clazz.addImport("jakarta.servlet.http.HttpServletResponse");
        clazz.addImport(ActionCommand.class);
        clazz.addImport(ActionMapping.class);
        clazz.addImport("java.util.List");
        clazz.addImport("java.util.ArrayList");
    }

    public static String getContainerMultiOpActionName(MetaDocument doc, MetaContainerProperty property) {
        return "MultiOp" + doc.getMultiple() + StringUtils.capitalize((String)property.getName()) + "Action";
    }

    public static String getContainerShowActionName(MetaDocument doc, MetaContainerProperty property) {
        return "Show" + doc.getMultiple() + StringUtils.capitalize((String)property.getName()) + "Action";
    }

    public static String getContainerAddEntryActionName(MetaDocument doc, MetaContainerProperty property) {
        return "Add" + doc.getMultiple() + StringUtils.capitalize((String)property.getName()) + ModuleActionsGenerator.getContainerNameAddy(property) + "Action";
    }

    public static String getContainerQuickAddActionName(MetaDocument doc, MetaContainerProperty property) {
        return "QuickAdd" + doc.getMultiple() + StringUtils.capitalize((String)property.getName()) + ModuleActionsGenerator.getContainerNameAddy(property) + "Action";
    }

    public static String getContainerDeleteEntryActionName(MetaDocument doc, MetaContainerProperty property) {
        return "Delete" + doc.getMultiple() + StringUtils.capitalize((String)property.getName()) + ModuleActionsGenerator.getContainerNameAddy(property) + "Action";
    }

    public static String getContainerMoveEntryActionName(MetaDocument doc, MetaContainerProperty property) {
        return "Move" + doc.getMultiple() + StringUtils.capitalize((String)property.getName()) + ModuleActionsGenerator.getContainerNameAddy(property) + "Action";
    }

    private static String getContainerNameAddy(MetaContainerProperty p) {
        return p.getContainerEntryName();
    }

    private GeneratedClass generateContainerMultiOpAction(MetaModuleSection section, MetaContainerProperty containerProperty) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        this.appendGenerationPoint("generateContainerMultiOpAction");
        MetaDocument doc = section.getDocument();
        clazz.setPackageName(ModuleActionsGenerator.getPackage(section.getModule()));
        clazz.addImport("java.util.List");
        clazz.addImport("java.util.ArrayList");
        this.addStandardActionImports(clazz);
        clazz.addImport(DataFacadeGenerator.getDocumentFactoryImport(GeneratorDataRegistry.getInstance().getContext(), doc));
        clazz.addImport(DataFacadeGenerator.getDocumentImport(doc));
        clazz.addImport(ModuleBeanGenerator.getContainerEntryFormImport(doc, containerProperty));
        clazz.addImport(PopulateUtility.class);
        if (containerProperty instanceof MetaListProperty) {
            MetaProperty containedProperty = ((MetaListProperty)containerProperty).getContainedProperty();
            if (containedProperty.isLinked()) {
                MetaListProperty list = (MetaListProperty)containerProperty;
                clazz.addImport(ModuleBeanGenerator.getContainerQuickAddFormImport(doc, containerProperty));
                MetaLink link = (MetaLink)list.getContainedProperty();
                String tDocName = link.getTargetDocumentName();
                MetaModule targetModule = link.getLinkTarget().indexOf(46) == -1 ? doc.getParentModule() : GeneratorDataRegistry.getInstance().getModule(link.getTargetModuleName());
                MetaDocument targetDocument = targetModule.getDocumentByName(tDocName);
                clazz.addImport(DataFacadeGenerator.getDocumentImport(targetDocument));
                clazz.addImport(AbstractDataObjectGenerator.getSortTypeImport(targetDocument));
                clazz.addImport("net.anotheria.webutils.bean.LabelValueBean");
                clazz.addImport("net.anotheria.anodoc.data.NoSuchDocumentException");
                clazz.addImport("net.anotheria.util.StringUtils");
            }
            if (containedProperty instanceof MetaEnumerationProperty) {
                clazz.addImport("net.anotheria.webutils.bean.LabelValueBean");
                EnumerationType type = (EnumerationType)GeneratorDataRegistry.getInstance().getType(((MetaEnumerationProperty)containedProperty).getEnumeration());
                clazz.addImport(EnumTypeGenerator.getEnumImport(type));
            }
            if (containedProperty.getType() == MetaProperty.Type.IMAGE) {
                clazz.addImport("net.anotheria.webutils.filehandling.actions.FileStorage");
                clazz.addImport("net.anotheria.webutils.filehandling.beans.TemporaryFileHolder");
            }
        }
        clazz.addImport("net.anotheria.asg.exception.ASGRuntimeException");
        clazz.setName(ModuleActionsGenerator.getContainerMultiOpActionName(doc, containerProperty));
        clazz.setParent(ModuleActionsGenerator.getBaseActionName(section));
        this.startClassBody();
        this.appendString(this.getExecuteDeclaration(null));
        this.increaseIdent();
        this.appendStatement("String path = stripPath(mapping.getPath())");
        if (containerProperty instanceof MetaListProperty) {
            this.writePathResolveForContainerMultiOpAction(doc, containerProperty, "show");
            this.writePathResolveForContainerMultiOpAction(doc, containerProperty, "add");
            this.writePathResolveForContainerMultiOpAction(doc, containerProperty, "delete");
            this.writePathResolveForContainerMultiOpAction(doc, containerProperty, "move");
            if (((MetaListProperty)containerProperty).getContainedProperty().isLinked()) {
                this.writePathResolveForContainerMultiOpAction(doc, containerProperty, "quickAdd");
            }
        }
        this.appendStatement("throw new IllegalArgumentException(" + this.quote("Unknown path: ") + "+path)");
        this.closeBlockNEW();
        ModuleActionsGenerator.emptyline();
        if (containerProperty instanceof MetaListProperty) {
            MetaListProperty list = (MetaListProperty)containerProperty;
            this.generateListShowActionMethod(section, list, CMSMappingsConfiguratorGenerator.getContainerPath(doc, containerProperty, "show"));
            ModuleActionsGenerator.emptyline();
            this.generateContainerDeleteEntryActionMethod(section, list, CMSMappingsConfiguratorGenerator.getContainerPath(doc, containerProperty, "delete"));
            ModuleActionsGenerator.emptyline();
            this.generateContainerMoveEntryActionMethod(section, list, CMSMappingsConfiguratorGenerator.getContainerPath(doc, containerProperty, "move"));
            ModuleActionsGenerator.emptyline();
            this.generateListAddRowActionMethod(section, list, CMSMappingsConfiguratorGenerator.getContainerPath(doc, containerProperty, "add"));
            ModuleActionsGenerator.emptyline();
            if (list.getContainedProperty().isLinked()) {
                this.generateListQuickAddActionMethod(section, list, CMSMappingsConfiguratorGenerator.getContainerPath(doc, containerProperty, "quickAdd"));
                ModuleActionsGenerator.emptyline();
            }
        }
        return clazz;
    }

    private GeneratedClass generateContainerAddRowAction(MetaModuleSection section, MetaContainerProperty container) {
        if (container instanceof MetaTableProperty) {
            return this.generateTableAddRowAction(section, (MetaTableProperty)container);
        }
        if (container instanceof MetaListProperty) {
            return this.generateListAddRowAction(section, (MetaListProperty)container);
        }
        throw new RuntimeException("Unsupported container type: " + container.getClass().getName());
    }

    private GeneratedClass generateContainerQuickAddAction(MetaModuleSection section, MetaContainerProperty container) {
        if (container instanceof MetaListProperty && ((MetaListProperty)container).getContainedProperty().isLinked()) {
            return this.generateListQuickAddAction(section, (MetaListProperty)container);
        }
        return null;
    }

    private GeneratedClass generateListAddRowAction(MetaModuleSection section, MetaListProperty list) {
        return null;
    }

    private void generateListAddRowActionMethod(MetaModuleSection section, MetaListProperty list, String methodName) {
        MetaProperty p;
        this.appendGenerationPoint("generateListAddRowActionMethod");
        MetaDocument doc = section.getDocument();
        this.appendString(this.getExecuteDeclaration(methodName));
        this.increaseIdent();
        this.appendStatement(ModuleBeanGenerator.getContainerEntryFormName(list) + " form = new " + ModuleBeanGenerator.getContainerEntryFormName(list) + "()");
        this.appendStatement("PopulateUtility.populate(form, req)");
        this.appendStatement("String id = form.getOwnerId()");
        this.appendStatement(doc.getName() + " " + doc.getVariableName());
        this.appendStatement(doc.getVariableName(), " = ", ModuleActionsGenerator.getServiceGetterCall(section.getModule()), ".get", doc.getName(), "(id)");
        if (StorageType.CMS.equals((Object)section.getDocument().getParentModule().getStorageType())) {
            this.appendStatement("canUpdate" + doc.getMultiple() + "(" + doc.getVariableName() + ", req)");
            this.appendStatement("check" + doc.getMultiple() + "(" + doc.getVariableName() + ", req)");
        }
        if ((p = list.getContainedProperty()).getType() == MetaProperty.Type.IMAGE) {
            String varName = p.getName();
            this.appendString("//handle image");
            this.appendStatement("TemporaryFileHolder holder = FileStorage.getTemporaryFile(req, \"" + varName + "\")");
            this.appendString("if (holder!=null && holder.getData()!=null){");
            this.increaseIdent();
            this.appendStatement("FileStorage.storeFilePermanently(req, holder.getFileName(), \"" + varName + "\")");
            this.appendStatement(doc.getVariableName() + "." + DataFacadeGenerator.getContainerEntryAdderName(list) + "(holder.getFileName())");
            this.appendStatement("FileStorage.removeTemporaryFile(req, \"" + varName + "\")");
            this.closeBlockNEW();
        } else {
            String getter = "form." + p.toBeanGetter() + "()";
            this.appendStatement(doc.getVariableName() + "." + DataFacadeGenerator.getContainerEntryAdderName(list) + "(" + getter + ")");
        }
        this.appendStatement(ModuleActionsGenerator.getServiceGetterCall(section.getModule()) + ".update" + doc.getName() + "(" + doc.getVariableName() + ")");
        if (methodName == null) {
            this.appendStatement("return " + this.getSuperCall());
        } else {
            this.appendStatement("return " + CMSMappingsConfiguratorGenerator.getContainerPath(doc, list, "show") + "(mapping, req, res)");
        }
        this.closeBlockNEW();
    }

    private GeneratedClass generateListQuickAddAction(MetaModuleSection section, MetaListProperty list) {
        return null;
    }

    private void generateListQuickAddActionMethod(MetaModuleSection section, MetaListProperty list, String methodName) {
        this.appendGenerationPoint("generateListQuickAddActionMethod");
        MetaDocument doc = section.getDocument();
        this.appendString(this.getExecuteDeclaration(methodName));
        this.increaseIdent();
        this.appendStatement(ModuleBeanGenerator.getContainerQuickAddFormName(list) + " form = new " + ModuleBeanGenerator.getContainerQuickAddFormName(list) + "()");
        this.appendStatement("PopulateUtility.populate(form, req)");
        this.appendStatement("String id = form.getOwnerId()");
        this.appendStatement(doc.getName() + " " + doc.getVariableName());
        this.appendStatement(doc.getVariableName() + " = " + ModuleActionsGenerator.getServiceGetterCall(section.getModule()) + ".get" + doc.getName() + "(id)");
        if (StorageType.CMS.equals((Object)section.getDocument().getParentModule().getStorageType())) {
            this.appendStatement("canUpdate" + doc.getMultiple() + "(" + doc.getVariableName() + ", req)");
            this.appendStatement("check" + doc.getMultiple() + "(" + doc.getVariableName() + ", req)");
        }
        this.appendStatement("String paramIdsToAdd = form.getQuickAddIds()");
        ModuleActionsGenerator.emptyline();
        this.appendStatement("String idParameters[] = StringUtils.tokenize(paramIdsToAdd, ',')");
        this.appendString("for (String anIdParam : idParameters){");
        this.increaseIdent();
        this.appendString("String ids[] = StringUtils.tokenize(anIdParam, '-');");
        this.appendString("for (int i=Integer.parseInt(ids[0]); i<=Integer.parseInt(ids[ids.length-1]); i++){");
        this.increaseIdent();
        this.appendStatement(doc.getVariableName() + "." + DataFacadeGenerator.getContainerEntryAdderName(list) + "(" + this.quote("") + "+i)");
        this.closeBlockNEW();
        this.closeBlockNEW();
        Object call = "";
        MetaProperty p = list.getContainedProperty();
        String getter = "form." + p.toBeanGetter() + "()";
        call = (String)call + getter;
        this.appendStatement(ModuleActionsGenerator.getServiceGetterCall(section.getModule()) + ".update" + doc.getName() + "(" + doc.getVariableName() + ")");
        if (methodName == null) {
            this.appendStatement("return " + this.getSuperCall());
        } else {
            this.appendStatement("return " + CMSMappingsConfiguratorGenerator.getContainerPath(doc, list, "show") + "(mapping, req, res)");
        }
        this.closeBlockNEW();
    }

    private GeneratedClass generateTableAddRowAction(MetaModuleSection section, MetaTableProperty table) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        MetaDocument doc = section.getDocument();
        clazz.setPackageName(ModuleActionsGenerator.getPackage(section.getModule()));
        this.addStandardActionImports(clazz);
        clazz.addImport(DataFacadeGenerator.getDocumentImport(doc));
        clazz.addImport(ModuleBeanGenerator.getContainerEntryFormImport(doc, table));
        if (StorageType.CMS.equals((Object)section.getModule().getStorageType())) {
            clazz.addImport("net.anotheria.asg.data.LockableObject");
            clazz.addImport("net.anotheria.asg.util.locking.helper.DocumentLockingHelper");
        }
        clazz.setName(ModuleActionsGenerator.getContainerAddEntryActionName(doc, table));
        clazz.setParent(ModuleActionsGenerator.getContainerShowActionName(doc, table));
        this.startClassBody();
        this.appendString(this.getExecuteDeclaration());
        this.increaseIdent();
        this.appendStatement(ModuleBeanGenerator.getContainerEntryFormName(table) + " form = new " + ModuleBeanGenerator.getContainerEntryFormName(table) + "()");
        this.appendStatement("PopulateUtility.populate(form, req)");
        this.appendStatement("String id = form.getOwnerId()");
        this.appendStatement(doc.getName() + " " + doc.getVariableName());
        this.appendStatement(doc.getVariableName() + " = " + ModuleActionsGenerator.getServiceGetterCall(section.getModule()) + ".get" + doc.getName() + "(id)");
        if (StorageType.CMS.equals((Object)section.getDocument().getParentModule().getStorageType())) {
            this.appendStatement("canUpdate" + doc.getMultiple() + "(" + doc.getVariableName() + ", req)");
            this.appendStatement("check" + doc.getMultiple() + "(" + doc.getVariableName() + ", req)");
        }
        Object call = "";
        List<MetaProperty> columns = table.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            MetaProperty p = columns.get(i);
            String getter = "form.get" + StringUtils.capitalize((String)table.extractSubName(p)) + "()";
            call = (String)call + getter;
            if (i >= columns.size() - 1) continue;
            call = (String)call + ", ";
        }
        this.appendStatement(doc.getVariableName() + "." + DataFacadeGenerator.getContainerEntryAdderName(table) + "(" + (String)call + ")");
        this.appendStatement(ModuleActionsGenerator.getServiceGetterCall(section.getModule()) + ".update" + doc.getName() + "(" + doc.getVariableName() + ")");
        this.appendStatement("return " + this.getSuperCall());
        this.closeBlockNEW();
        return clazz;
    }

    private GeneratedClass generateContainerDeleteEntryAction(MetaModuleSection section, MetaContainerProperty container) {
        return null;
    }

    private void generateContainerDeleteEntryActionMethod(MetaModuleSection section, MetaContainerProperty container, String methodName) {
        MetaListProperty mlp;
        MetaProperty containerProperty;
        MetaDocument doc = section.getDocument();
        this.appendString(this.getExecuteDeclaration(methodName));
        this.increaseIdent();
        this.appendStatement("String id = getStringParameter(req, \"ownerId\")");
        if (StorageType.CMS.equals((Object)section.getDocument().getParentModule().getStorageType())) {
            this.appendStatement(doc.getName() + " " + doc.getVariableName() + "Curr = " + ModuleActionsGenerator.getServiceGetterCall(section.getModule()) + ".get" + doc.getName() + "(id)");
            this.appendStatement("canUpdate" + doc.getMultiple() + "(" + doc.getVariableName() + "Curr, req)");
            this.appendStatement("check" + doc.getMultiple() + "(" + doc.getVariableName() + "Curr, req)");
        }
        this.appendStatement("int position = getIntParameter(req, " + this.quote("pPosition") + ")");
        this.appendStatement(doc.getName() + " " + doc.getVariableName() + " = " + ModuleActionsGenerator.getServiceGetterCall(section.getModule()) + ".get" + doc.getName() + "(id)");
        if (container instanceof MetaListProperty && (containerProperty = (mlp = (MetaListProperty)container).getContainedProperty()).getType() == MetaProperty.Type.IMAGE) {
            this.appendStatement("FileStorage.removeFilePermanently( " + doc.getVariableName() + "." + DataFacadeGenerator.getListElementGetterName(mlp) + "(position) )");
        }
        this.appendStatement(doc.getVariableName() + "." + DataFacadeGenerator.getContainerEntryDeleterName(container) + "(position)");
        this.appendStatement(ModuleActionsGenerator.getServiceGetterCall(section.getModule()) + ".update" + doc.getName() + "(" + doc.getVariableName() + ")");
        if (methodName == null) {
            this.appendStatement("return " + this.getSuperCall());
        } else {
            this.appendStatement("return " + CMSMappingsConfiguratorGenerator.getContainerPath(doc, container, "show") + "(mapping, req, res)");
        }
        this.closeBlockNEW();
    }

    private GeneratedClass generateContainerMoveEntryAction(MetaModuleSection section, MetaContainerProperty container) {
        if (!(container instanceof MetaListProperty)) {
            return null;
        }
        return null;
    }

    private void generateContainerMoveEntryActionMethod(MetaModuleSection section, MetaContainerProperty container, String methodName) {
        MetaDocument doc = section.getDocument();
        MetaListProperty sourceProperty = (MetaListProperty)container;
        MetaGenericListProperty generic = new MetaGenericListProperty(sourceProperty.getName(), sourceProperty.getContainedProperty());
        this.appendString(this.getExecuteDeclaration(methodName));
        this.increaseIdent();
        this.appendStatement("String id = getStringParameter(req, \"ownerId\")");
        this.appendStatement("int position = getIntParameter(req, " + this.quote("pPosition") + ")");
        this.appendStatement("String direction = getStringParameter(req, " + this.quote("dir") + ")");
        this.appendStatement(doc.getName() + " " + doc.getVariableName() + " = " + ModuleActionsGenerator.getServiceGetterCall(section.getModule()) + ".get" + doc.getName() + "(id)");
        if (StorageType.CMS.equals((Object)section.getDocument().getParentModule().getStorageType())) {
            this.appendStatement("canUpdate" + doc.getMultiple() + "(" + doc.getVariableName() + ", req)");
            this.appendStatement("check" + doc.getMultiple() + "(" + doc.getVariableName() + ", req)");
        }
        this.appendString("if (" + this.quote("top") + ".equalsIgnoreCase(direction))");
        this.appendIncreasedStatement("moveTop(" + doc.getVariableName() + ", position)");
        this.appendString("if (" + this.quote("up") + ".equalsIgnoreCase(direction))");
        this.appendIncreasedStatement("moveUp(" + doc.getVariableName() + ", position)");
        this.appendString("if (" + this.quote("down") + ".equalsIgnoreCase(direction))");
        this.appendIncreasedStatement("moveDown(" + doc.getVariableName() + ", position)");
        this.appendString("if (" + this.quote("bottom") + ".equalsIgnoreCase(direction))");
        this.appendIncreasedStatement("moveBottom(" + doc.getVariableName() + ", position)");
        if (methodName == null) {
            this.appendStatement("return " + this.getSuperCall());
        } else {
            this.appendStatement("return " + CMSMappingsConfiguratorGenerator.getContainerPath(doc, container, "show") + "(mapping, req, res)");
        }
        this.closeBlockNEW();
        ModuleActionsGenerator.emptyline();
        String moveMethodParameter = doc.getName() + " " + doc.getVariableName() + ", int position";
        this.appendString("private void moveUp(" + moveMethodParameter + ") throws ASGRuntimeException {");
        this.increaseIdent();
        this.appendString("if (position==0) ");
        this.appendIncreasedStatement("return");
        this.appendStatement(doc.getVariableName() + "." + DataFacadeGenerator.getContainerEntrySwapperName(container) + "(position, position-1)");
        this.appendStatement(ModuleActionsGenerator.getServiceGetterCall(section.getModule()) + ".update" + doc.getName() + "(" + doc.getVariableName() + ")");
        this.closeBlockNEW();
        ModuleActionsGenerator.emptyline();
        this.appendString("private void moveTop(" + moveMethodParameter + ") throws ASGRuntimeException {");
        this.increaseIdent();
        this.appendStatement(generic.toJavaType() + " targetList = " + doc.getVariableName() + ".get" + container.getAccesserName() + "()");
        this.appendStatement(sourceProperty.getContainedProperty().toJavaType() + " toSwap = targetList.remove(position)");
        this.appendStatement("targetList.add(0, toSwap)");
        this.appendStatement(doc.getVariableName() + ".set" + container.getAccesserName() + "(targetList)");
        this.appendStatement(ModuleActionsGenerator.getServiceGetterCall(section.getModule()) + ".update" + doc.getName() + "(" + doc.getVariableName() + ")");
        this.closeBlockNEW();
        ModuleActionsGenerator.emptyline();
        this.appendString("private void moveDown(" + moveMethodParameter + ") throws ASGRuntimeException {");
        this.increaseIdent();
        this.appendString("if (position<" + doc.getVariableName() + "." + DataFacadeGenerator.getContainerSizeGetterName(container) + "()-1){");
        this.increaseIdent();
        this.appendStatement(doc.getVariableName() + "." + DataFacadeGenerator.getContainerEntrySwapperName(container) + "(position, position+1)");
        this.appendStatement(ModuleActionsGenerator.getServiceGetterCall(section.getModule()) + ".update" + doc.getName() + "(" + doc.getVariableName() + ")");
        this.closeBlockNEW();
        this.closeBlockNEW();
        ModuleActionsGenerator.emptyline();
        this.appendString("private void moveBottom(" + moveMethodParameter + ") throws ASGRuntimeException {");
        this.increaseIdent();
        this.appendStatement(generic.toJavaType() + " targetList = " + doc.getVariableName() + ".get" + container.getAccesserName() + "()");
        this.appendStatement(sourceProperty.getContainedProperty().toJavaType() + " toSwap = targetList.remove(position)");
        this.appendStatement("targetList.add(toSwap)");
        this.appendStatement(doc.getVariableName() + ".set" + container.getAccesserName() + "(targetList)");
        this.appendStatement(ModuleActionsGenerator.getServiceGetterCall(section.getModule()) + ".update" + doc.getName() + "(" + doc.getVariableName() + ")");
        this.closeBlockNEW();
    }

    private GeneratedClass generateContainerShowAction(MetaModuleSection section, MetaContainerProperty container) {
        if (container instanceof MetaTableProperty) {
            return this.generateTableShowAction(section, (MetaTableProperty)container);
        }
        if (container instanceof MetaListProperty) {
            return this.generateListShowAction(section, (MetaListProperty)container);
        }
        throw new RuntimeException("Unsupported container type: " + container.getClass().getName());
    }

    private GeneratedClass generateListShowAction(MetaModuleSection section, MetaListProperty list) {
        return null;
    }

    private void generateListShowActionMethod(MetaModuleSection section, MetaListProperty list, String methodName) {
        Object listName;
        this.appendGenerationPoint("generateListShowActionMethod");
        MetaDocument doc = section.getDocument();
        this.appendString(this.getExecuteDeclaration(methodName));
        this.increaseIdent();
        this.appendStatement("String id = getStringParameter(req, \"ownerId\")");
        this.appendStatement(doc.getName() + " " + doc.getVariableName() + " = " + ModuleActionsGenerator.getServiceGetterCall(section.getModule()) + ".get" + doc.getName() + "(id)");
        this.appendStatement("addBeanToRequest(req, \"ownerId\", id)");
        if (StorageType.CMS.equals((Object)doc.getParentModule().getStorageType())) {
            this.appendStatement("check" + doc.getMultiple() + "(" + doc.getVariableName() + ", req)");
        }
        ModuleActionsGenerator.emptyline();
        this.appendStatement(ModuleBeanGenerator.getContainerEntryFormName(list) + " form = new " + ModuleBeanGenerator.getContainerEntryFormName(list) + "() ");
        this.appendStatement("form.setPosition(-1)");
        this.appendStatement("form.setOwnerId(" + doc.getVariableName() + ".getId())");
        this.appendStatement("addBeanToRequest(req, " + this.quote(CMSMappingsConfiguratorGenerator.getContainerEntryFormName(doc, list)) + ", form)");
        ModuleActionsGenerator.emptyline();
        if (list.getContainedProperty().isLinked()) {
            this.appendStatement(ModuleBeanGenerator.getContainerQuickAddFormName(list) + " quickAddForm = new " + ModuleBeanGenerator.getContainerQuickAddFormName(list) + "() ");
            this.appendStatement("quickAddForm.setOwnerId(" + doc.getVariableName() + ".getId())");
            this.appendStatement("addBeanToRequest(req, " + this.quote(CMSMappingsConfiguratorGenerator.getContainerQuickAddFormName(doc, list)) + ", quickAddForm)");
            ModuleActionsGenerator.emptyline();
        }
        if (list.getContainedProperty().isLinked()) {
            MetaLink link = (MetaLink)list.getContainedProperty();
            ModuleActionsGenerator.emptyline();
            this.appendString("//link " + link.getName() + " to " + link.getLinkTarget());
            MetaModule targetModule = link.getLinkTarget().indexOf(46) == -1 ? doc.getParentModule() : GeneratorDataRegistry.getInstance().getModule(link.getTargetModuleName());
            MetaDocument targetDocument = targetModule.getDocumentByName(link.getTargetDocumentName());
            listName = targetDocument.getMultiple().toLowerCase();
            String sortType = "new " + DataFacadeGenerator.getSortTypeName(targetDocument);
            sortType = sortType + "(" + DataFacadeGenerator.getSortTypeName(targetDocument) + ".SORT_BY_NAME)";
            this.appendStatement("List<" + targetDocument.getName() + "> " + (String)listName + " = " + ModuleActionsGenerator.getServiceGetterCall(targetModule) + ".get" + targetDocument.getMultiple() + "(" + sortType + ")");
            this.appendStatement("List<LabelValueBean> " + (String)listName + "Values = new ArrayList<LabelValueBean>(" + (String)listName + ".size())");
            this.appendString("for (int i=0; i<" + (String)listName + ".size(); i++){");
            this.increaseIdent();
            this.appendStatement(DataFacadeGenerator.getDocumentImport(targetDocument) + " " + targetDocument.getTemporaryVariableName() + " = (" + DataFacadeGenerator.getDocumentImport(targetDocument) + ") " + (String)listName + ".get(i)");
            this.appendStatement("LabelValueBean bean = new LabelValueBean(" + targetDocument.getTemporaryVariableName() + ".getId(), " + targetDocument.getTemporaryVariableName() + ".getName()+\" [\"+" + targetDocument.getTemporaryVariableName() + ".getId()+\"]\" )");
            this.appendStatement((String)listName + "Values.add(bean)");
            this.closeBlockNEW();
            this.appendStatement("addBeanToRequest(req, " + this.quote(link.getName().toLowerCase() + "ValuesCollection") + ", " + (String)listName + "Values)");
        }
        if (list.getContainedProperty() instanceof MetaEnumerationProperty) {
            MetaEnumerationProperty enumeration = (MetaEnumerationProperty)list.getContainedProperty();
            EnumerationType type = (EnumerationType)GeneratorDataRegistry.getInstance().getType(((MetaEnumerationProperty)list.getContainedProperty()).getEnumeration());
            ModuleActionsGenerator.emptyline();
            String arrName = type.getName() + "_values";
            listName = enumeration.getName().toLowerCase() + "ValuesCollection";
            this.appendString("//enumeration " + type.getName());
            this.appendStatement(EnumTypeGenerator.getEnumClassName(type) + "[] " + arrName + " = " + EnumTypeGenerator.getEnumClassName(type) + ".values()");
            this.appendStatement("List<LabelValueBean> " + (String)listName + " = new ArrayList<LabelValueBean>(" + arrName + ".length)");
            this.appendString("for (" + EnumTypeGenerator.getEnumClassName(type) + " element : " + arrName + ") {");
            this.increaseIdent();
            this.appendStatement("LabelValueBean bean = new LabelValueBean(\"\"+element.getValue(), element.name())");
            this.appendStatement((String)listName + ".add(bean)");
            this.closeBlockNEW();
            this.appendStatement("addBeanToRequest(req, " + this.quote((String)listName) + ", " + (String)listName + ")");
        }
        this.appendString("// generate list ...");
        MetaModule targetModule = null;
        MetaDocument targetDocument = null;
        if (list.getContainedProperty().isLinked()) {
            MetaLink link = (MetaLink)list.getContainedProperty();
            targetModule = link.getLinkTarget().indexOf(46) == -1 ? doc.getParentModule() : GeneratorDataRegistry.getInstance().getModule(link.getTargetModuleName());
            targetDocument = targetModule.getDocumentByName(link.getTargetDocumentName());
        }
        this.appendStatement("int size = " + doc.getVariableName() + "." + DataFacadeGenerator.getContainerSizeGetterName(list) + "()");
        this.appendStatement("List<" + ModuleBeanGenerator.getContainerEntryFormName(list) + "> beans = new ArrayList<" + ModuleBeanGenerator.getContainerEntryFormName(list) + ">(size)");
        this.appendString("for (int i=0; i<size; i++){");
        this.increaseIdent();
        this.appendStatement(list.getContainedProperty().toJavaType() + " value = " + doc.getVariableName() + "." + DataFacadeGenerator.getListElementGetterName(list) + "(i)");
        this.appendStatement(ModuleBeanGenerator.getContainerEntryFormName(list) + " bean = new " + ModuleBeanGenerator.getContainerEntryFormName(list) + "()");
        this.appendStatement("bean.setOwnerId(" + doc.getVariableName() + ".getId())");
        this.appendStatement("bean.setPosition(i)");
        this.appendStatement("bean." + list.getContainedProperty().toSetter() + "(value)");
        if (list.getContainedProperty().isLinked()) {
            this.appendString("try{");
            this.increaseIdent();
            this.appendStatement(targetDocument.getName() + " " + targetDocument.getTemporaryVariableName() + " = " + ModuleActionsGenerator.getServiceGetterCall(targetModule) + ".get" + targetDocument.getName() + "(value)");
            this.appendStatement("bean.setDescription(" + targetDocument.getTemporaryVariableName() + ".getName())");
            this.decreaseIdent();
            this.appendString("}catch(NoSuchDocumentException e){");
            this.appendIncreasedStatement("bean.setDescription(\"*** DELETED ***\")");
            this.appendString("}");
        }
        if (list.getContainedProperty() instanceof MetaEnumerationProperty) {
            EnumerationType type = (EnumerationType)GeneratorDataRegistry.getInstance().getType(((MetaEnumerationProperty)list.getContainedProperty()).getEnumeration());
            this.appendStatement("bean.setDescription(" + EnumTypeGenerator.getEnumClassName(type) + ".getConstantByValue(value).name())");
        }
        this.appendStatement("beans.add(bean)");
        this.closeBlockNEW();
        this.appendStatement("addBeanToRequest(req, " + this.quote("elements") + ", beans)");
        this.appendStatement("return mapping.success()");
        this.closeBlockNEW();
    }

    private GeneratedClass generateTableShowAction(MetaModuleSection section, MetaTableProperty table) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        MetaDocument doc = section.getDocument();
        clazz.setPackageName(ModuleActionsGenerator.getPackage(section.getModule()));
        clazz.addImport("java.util.List");
        clazz.addImport("java.util.ArrayList");
        this.addStandardActionImports(clazz);
        clazz.addImport(DataFacadeGenerator.getDocumentImport(doc));
        clazz.addImport(ModuleBeanGenerator.getContainerEntryFormImport(doc, table));
        clazz.setName(ModuleActionsGenerator.getContainerShowActionName(doc, table));
        clazz.setParent(ModuleActionsGenerator.getBaseActionName(section));
        this.startClassBody();
        this.appendString(this.getExecuteDeclaration());
        this.increaseIdent();
        this.appendStatement("String id = getStringParameter(req, PARAM_ID)");
        this.appendStatement(doc.getName() + " " + doc.getVariableName() + " = " + ModuleActionsGenerator.getServiceGetterCall(section.getModule()) + ".get" + doc.getName() + "(id);");
        if (StorageType.CMS.equals((Object)doc.getParentModule().getStorageType())) {
            this.appendStatement("check" + doc.getMultiple() + "(" + doc.getVariableName() + ", req)");
        }
        ModuleActionsGenerator.emptyline();
        this.appendStatement(ModuleBeanGenerator.getContainerEntryFormName(table) + " form = new " + ModuleBeanGenerator.getContainerEntryFormName(table) + "() ");
        this.appendStatement("form.setPosition(\"-1\")");
        this.appendStatement("form.setOwnerId(" + doc.getVariableName() + ".getId())");
        this.appendStatement("addBeanToRequest(req, " + this.quote(CMSMappingsConfiguratorGenerator.getContainerEntryFormName(doc, table)) + ", form)");
        ModuleActionsGenerator.emptyline();
        this.appendString("// generate table...");
        this.appendStatement("List beans = new ArrayList()");
        this.appendStatement("List rows  = " + doc.getVariableName() + "." + DataFacadeGenerator.getTableGetterName(table) + "()");
        this.appendString("for (int i=0; i<rows.size(); i++){");
        this.increaseIdent();
        this.appendStatement("List row = (List) rows.get(i)");
        this.appendStatement(ModuleBeanGenerator.getContainerEntryFormName(table) + " bean = new " + ModuleBeanGenerator.getContainerEntryFormName(table) + "()");
        this.appendStatement("bean.setOwnerId(" + doc.getVariableName() + ".getId())");
        this.appendStatement("bean.setPosition(\"\"+i)");
        List<MetaProperty> columns = table.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            MetaProperty p = columns.get(i);
            String setter = "bean.set" + StringUtils.capitalize((String)table.extractSubName(p));
            setter = setter + "((String)row.get(" + i + "))";
            this.appendStatement(setter);
        }
        this.appendStatement("beans.add(bean)");
        this.closeBlockNEW();
        this.appendStatement("addBeanToRequest(req, " + this.quote("rows") + ", beans)");
        this.appendStatement("return mapping.success()");
        this.closeBlockNEW();
        return clazz;
    }

    public String getFormActionName(MetaForm form) {
        if (form.getAction().equals("sendMail")) {
            return this.getSendMailFormActionName(form);
        }
        throw new RuntimeException("Unsupported action type: " + form.getAction());
    }

    private String getSendMailFormActionName(MetaForm form) {
        return "Send" + StringUtils.capitalize((String)form.getId()) + "FormAction";
    }

    public GeneratedClass generateFormAction(MetaForm form) {
        if (form.getAction().equals("sendMail")) {
            return this.generateSendMailFormAction(form);
        }
        throw new RuntimeException("Unsupported action type: " + form.getAction());
    }

    private GeneratedClass generateSendMailFormAction(MetaForm form) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        clazz.setPackageName(ModuleActionsGenerator.getPackage());
        this.addStandardActionImports(clazz);
        clazz.addImport(ModuleBeanGenerator.getFormBeanImport(form));
        clazz.addImport("net.anotheria.communication.data.HtmlMailMessage");
        clazz.addImport("net.anotheria.communication.service.IMessagingService");
        clazz.addImport("net.anotheria.communication.service.MessagingServiceFactory");
        clazz.setName(this.getFormActionName(form));
        clazz.setParent(BaseActionGenerator.getBaseActionName());
        this.startClassBody();
        this.appendStatement("private IMessagingService service = MessagingServiceFactory.getMessagingService()");
        ModuleActionsGenerator.emptyline();
        List<String> targets = form.getTargets();
        this.appendString("public static String[] MAIL_TARGETS = {");
        for (int i = 0; i < targets.size(); ++i) {
            this.appendIncreasedString(this.quote(targets.get(i)) + ",");
        }
        this.appendStatement("}");
        ModuleActionsGenerator.emptyline();
        this.appendString(this.getExecuteDeclaration());
        this.increaseIdent();
        this.appendStatement(ModuleBeanGenerator.getFormBeanName(form) + " form = (" + ModuleBeanGenerator.getFormBeanName(form) + ") af");
        this.appendString("//create message");
        this.appendStatement("String message = " + this.quote(""));
        this.appendStatement("String htmlMessage = " + this.quote(""));
        ModuleActionsGenerator.emptyline();
        this.appendStatement("String emptyHtmlLine = " + this.quote(""));
        this.appendStatement("emptyHtmlLine += " + this.quote("<tr>"));
        this.appendStatement("emptyHtmlLine += " + this.quote("\\t<td colspan=\\\"2\\\">"));
        this.appendStatement("emptyHtmlLine += " + this.quote("\\t\\t&nbsp;"));
        this.appendStatement("emptyHtmlLine  += " + this.quote("\\t</td>"));
        this.appendStatement("emptyHtmlLine  += " + this.quote("</tr>"));
        ModuleActionsGenerator.emptyline();
        this.appendStatement("htmlMessage += " + this.quote("<table border=\\\"0\\\">"));
        List<MetaFormField> elements = form.getElements();
        for (int i = 0; i < elements.size(); ++i) {
            this.appendStatement("htmlMessage += " + this.quote("\\n"));
            MetaFormField element = elements.get(i);
            if (element.isSingle()) {
                MetaFormSingleField field = (MetaFormSingleField)element;
                this.appendStatement("htmlMessage += " + this.quote("<tr>"));
                this.appendStatement("htmlMessage += " + this.quote("\\t<td width=\\\"1\\\">"));
                this.appendStatement("htmlMessage += " + this.quote("\\t\\t" + (String)(field.isSpacer() ? "&nbsp;" : "" + (i + 1))));
                this.appendStatement("htmlMessage += " + this.quote("\\t</td>"));
                this.appendStatement("htmlMessage += " + this.quote("\\t<td>"));
                this.appendStatement("htmlMessage += \"\\t\\t\"+getDefaultResources().getMessage(" + this.quote(field.getTitle()) + ")");
                this.appendStatement("htmlMessage += " + this.quote("\\t</td>"));
                this.appendStatement("htmlMessage += " + this.quote("</tr>"));
                ModuleActionsGenerator.emptyline();
                if (field.isSpacer()) continue;
                this.appendStatement("htmlMessage += " + this.quote("<tr>"));
                this.appendStatement("htmlMessage += " + this.quote("\\t<td colspan=\\\"2\\\">"));
                String value = "String value" + i + " = ";
                value = field.getType().equals("boolean") ? value + "form.get" + StringUtils.capitalize((String)element.getName()) + "() ? " + this.quote("Yes") + " : " + this.quote("No") : value + "form.get" + StringUtils.capitalize((String)element.getName()) + "()";
                this.appendStatement(value);
                this.appendStatement("htmlMessage += \"\\t\\t\"+value" + i + "+" + this.quote("&nbsp;"));
                this.appendStatement("htmlMessage += " + this.quote("\\t</td>"));
                this.appendStatement("htmlMessage += " + this.quote("</tr>"));
                ModuleActionsGenerator.emptyline();
                this.appendStatement("htmlMessage += emptyHtmlLine");
                ModuleActionsGenerator.emptyline();
                this.appendStatement("message += " + this.quote(element.getName() + " - "));
                this.appendStatement("message += getDefaultResources().getMessage(" + this.quote(field.getTitle()) + ")+" + this.quote(":\\n"));
                this.appendStatement("message += value" + i + "+" + this.quote("\\n"));
                ModuleActionsGenerator.emptyline();
            }
            if (!element.isComplex()) continue;
            MetaFormTableField table = (MetaFormTableField)element;
            this.appendStatement("htmlMessage += " + this.quote("<!-- including table element " + table.getName() + " -->\\n"));
            this.appendStatement("htmlMessage += " + this.quote("<tr>"));
            this.appendStatement("htmlMessage += " + this.quote("\\t<td colspan=\\\"3\\\">"));
            ModuleActionsGenerator.emptyline();
            this.appendStatement("htmlMessage += " + this.quote("\\n"));
            this.appendString("//Writing inner table: " + table.getName());
            this.appendStatement("htmlMessage += " + this.quote("<table width=\\\"100%\\\">"));
            List<MetaFormTableColumn> columns = table.getColumns();
            this.appendStatement("htmlMessage += " + this.quote("\\n"));
            this.appendStatement("htmlMessage += " + this.quote("<tr>"));
            for (int c = 0; c < columns.size(); ++c) {
                MetaFormTableColumn col = columns.get(c);
                MetaFormTableHeader header = col.getHeader();
                this.appendStatement("htmlMessage += " + this.quote("\\n"));
                this.appendStatement("htmlMessage += " + this.quote("\\t<th width=\\\"" + header.getWidth() + "\\\">"));
                this.appendStatement("htmlMessage += getDefaultResources().getMessage(" + this.quote(header.getKey()) + ")");
                this.appendStatement("htmlMessage += " + this.quote("\\t</th>"));
            }
            this.appendStatement("htmlMessage += " + this.quote("</tr>"));
            this.appendStatement("htmlMessage += " + this.quote("\\n"));
            for (int r = 0; r < table.getRows(); ++r) {
                this.appendStatement("htmlMessage += " + this.quote("<tr>"));
                this.appendStatement("htmlMessage += " + this.quote("\\n"));
                for (int c = 0; c < columns.size(); ++c) {
                    MetaFormTableColumn col = columns.get(c);
                    MetaFormTableHeader header = col.getHeader();
                    this.appendStatement("htmlMessage += " + this.quote("\\t<td width=\\\"" + header.getWidth() + "\\\">"));
                    this.appendStatement("htmlMessage += form.get" + StringUtils.capitalize((String)table.getVariableName(r, c)) + "()");
                    this.appendStatement("htmlMessage += " + this.quote("\\t</td>"));
                }
                this.appendStatement("htmlMessage += " + this.quote("</tr>\\n"));
            }
            this.appendStatement("htmlMessage += " + this.quote("</table>"));
            this.appendStatement("htmlMessage += " + this.quote("\\t</td>"));
            this.appendStatement("htmlMessage += " + this.quote("</tr>"));
        }
        this.appendStatement("htmlMessage += " + this.quote("</table>"));
        ModuleActionsGenerator.emptyline();
        this.appendStatement("HtmlMailMessage mail = new HtmlMailMessage()");
        this.appendStatement("mail.setMessage(message)");
        this.appendStatement("mail.setHtmlContent(htmlMessage)");
        this.appendStatement("mail.setPlainTextContent(message)");
        this.appendStatement("mail.setSubject(" + this.quote("WebSiteForm Submit: " + StringUtils.capitalize((String)form.getId())) + ")");
        this.appendStatement("mail.setSender(\"\\\"WebForm\\\"<support@anotheria.net>\")");
        ModuleActionsGenerator.emptyline();
        this.appendString("//sending mail to " + targets.size() + " target(s)");
        this.appendString("for (int i=0; i<MAIL_TARGETS.length; i++){");
        this.increaseIdent();
        this.appendString("try{");
        this.increaseIdent();
        this.appendStatement("mail.setRecipient(MAIL_TARGETS[i])");
        this.appendStatement("service.sendMessage(mail)");
        this.decreaseIdent();
        this.appendString("}catch(Exception e){");
        this.increaseIdent();
        this.appendStatement("e.printStackTrace()");
        this.closeBlockNEW();
        this.closeBlockNEW();
        ModuleActionsGenerator.emptyline();
        this.appendStatement("return mapping.success()");
        this.closeBlockNEW();
        ModuleActionsGenerator.emptyline();
        return clazz;
    }

    private String getShowActionRedirect(MetaDocument doc) {
        return this.quote(CMSMappingsConfiguratorGenerator.getPath(doc, "show") + "?ts=") + "+System.currentTimeMillis()";
    }

    private String getEditActionRedirect(MetaDocument doc) {
        return this.quote(CMSMappingsConfiguratorGenerator.getPath(doc, "edit") + "?ts=") + "+System.currentTimeMillis()";
    }

    class EnumerationPropertyGenerator {
        private List<String> generatedProperties = new ArrayList<String>();
        private MetaDocument doc;

        EnumerationPropertyGenerator(MetaDocument aDoc) {
            this.doc = aDoc;
        }

        public void generateEnumerationPropertyHandling(MetaEnumerationProperty mep, boolean editMode) {
            ModuleActionsGenerator.this.appendGenerationPoint("generateEnumerationPropertyHandling");
            EnumerationType type = (EnumerationType)GeneratorDataRegistry.getInstance().getType(mep.getEnumeration());
            AbstractGenerator.emptyline();
            String arrName = type.getName() + "_values";
            String listName = arrName + "List";
            if (this.generatedProperties.indexOf(arrName) == -1) {
                ModuleActionsGenerator.this.appendString(new String[]{"//enumeration " + type.getName()});
                ModuleActionsGenerator.this.appendStatement(new String[]{EnumTypeGenerator.getEnumClassName(type) + "[] " + arrName + " = " + EnumTypeGenerator.getEnumClassName(type) + ".values()"});
                ModuleActionsGenerator.this.appendStatement(new String[]{"List<LabelValueBean> " + listName + "Values = new ArrayList<LabelValueBean>(" + arrName + ".length)"});
                ModuleActionsGenerator.this.appendString(new String[]{"for (" + EnumTypeGenerator.getEnumClassName(type) + " element : " + arrName + ") {"});
                ModuleActionsGenerator.this.increaseIdent();
                ModuleActionsGenerator.this.appendStatement(new String[]{"LabelValueBean bean = new LabelValueBean(\"\"+element.getValue(), element.name())"});
                ModuleActionsGenerator.this.appendStatement(new String[]{listName + "Values.add(bean)"});
                ModuleActionsGenerator.this.closeBlockNEW();
                this.generatedProperties.add(arrName);
            } else {
                ModuleActionsGenerator.this.appendString(new String[]{"//enumeration " + type.getName() + " already prepared."});
            }
            ModuleActionsGenerator.this.appendStatement(new String[]{"form." + mep.toBeanSetter() + "Collection(" + listName + "Values)"});
            if (editMode) {
                ModuleActionsGenerator.this.openTry();
                ModuleActionsGenerator.this.appendStatement(new String[]{"form." + mep.toBeanSetter() + "CurrentValue(" + EnumTypeGenerator.getEnumClassName(type) + ".getConstantByValue(" + this.doc.getVariableName() + "." + mep.toGetter() + "()).name())"});
                ModuleActionsGenerator.this.appendCatch(ConstantNotFoundException.class);
                ModuleActionsGenerator.this.closeBlock("try");
            }
        }
    }
}

