/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.view.action;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.asg.generator.AbstractGenerator;
import net.anotheria.asg.generator.Context;
import net.anotheria.asg.generator.FileEntry;
import net.anotheria.asg.generator.GeneratedClass;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.IGenerateable;
import net.anotheria.asg.generator.IGenerator;
import net.anotheria.asg.generator.forms.meta.MetaForm;
import net.anotheria.asg.generator.meta.MetaContainerProperty;
import net.anotheria.asg.generator.meta.MetaDocument;
import net.anotheria.asg.generator.meta.MetaEnumerationProperty;
import net.anotheria.asg.generator.meta.MetaListProperty;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.asg.generator.meta.MetaProperty;
import net.anotheria.asg.generator.meta.MetaTableProperty;
import net.anotheria.asg.generator.meta.ObjectType;
import net.anotheria.asg.generator.meta.StorageType;
import net.anotheria.asg.generator.view.meta.MetaDialog;
import net.anotheria.asg.generator.view.meta.MetaFieldElement;
import net.anotheria.asg.generator.view.meta.MetaFunctionElement;
import net.anotheria.asg.generator.view.meta.MetaModuleSection;
import net.anotheria.asg.generator.view.meta.MetaValidator;
import net.anotheria.asg.generator.view.meta.MetaViewElement;
import net.anotheria.asg.generator.view.meta.MultilingualFieldElement;
import net.anotheria.asg.generator.view.meta.SortingType;
import net.anotheria.util.ExecutionTimer;
import net.anotheria.util.StringUtils;

public class ModuleBeanGenerator
extends AbstractGenerator
implements IGenerator {
    public static final String FLAG_FORM_SUBMITTED = "formSubmittedFlag";
    public static final String FIELD_ML_DISABLED = "multilingualInstanceDisabled";
    private boolean debugTest = false;

    @Override
    public List<FileEntry> generate(IGenerateable g) {
        ArrayList<FileEntry> files = new ArrayList<FileEntry>();
        MetaModuleSection section = (MetaModuleSection)g;
        ExecutionTimer timer = new ExecutionTimer("MafBeanGenerator");
        timer.startExecution("All");
        timer.startExecution(section.getModule().getName() + "-" + section.getTitle() + "-ListItem");
        files.add(new FileEntry(this.generateListItemBean(section)));
        timer.stopExecution(section.getModule().getName() + "-" + section.getTitle() + "-ListItem");
        files.add(new FileEntry(this.generateListItemSortType(section)));
        List<MetaDialog> dialogs = section.getDialogs();
        for (int i = 0; i < dialogs.size(); ++i) {
            MetaDialog dlg = dialogs.get(i);
            files.add(new FileEntry(this.generateDialogForm(dlg, section.getDocument())));
            MetaDocument doc = section.getDocument();
            for (int p = 0; p < doc.getProperties().size(); ++p) {
                MetaProperty pp = doc.getProperties().get(p);
                if (!(pp instanceof MetaContainerProperty)) continue;
                files.add(new FileEntry(this.generateContainerEntryForm(doc, (MetaContainerProperty)pp)));
                files.add(new FileEntry(this.generateContainerQuickAddForm(doc, (MetaContainerProperty)pp)));
            }
        }
        timer.stopExecution("All");
        return files;
    }

    private GeneratedClass generateContainerEntryForm(MetaDocument doc, MetaContainerProperty p) {
        if (p instanceof MetaTableProperty) {
            return this.generateTableRowForm(doc, (MetaTableProperty)p);
        }
        if (p instanceof MetaListProperty) {
            return this.generateListElementForm(doc, (MetaListProperty)p);
        }
        throw new RuntimeException("Unsupported container type: " + p);
    }

    private GeneratedClass generateContainerQuickAddForm(MetaDocument doc, MetaContainerProperty p) {
        if (p instanceof MetaListProperty) {
            return this.generateListQuickAddForm(doc, (MetaListProperty)p);
        }
        System.out.println("WARN Unsupported container type: " + p);
        return null;
    }

    private GeneratedClass generateListQuickAddForm(MetaDocument doc, MetaListProperty list) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        clazz.setPackageName(ModuleBeanGenerator.getPackage(doc));
        clazz.addImport("net.anotheria.maf.bean.FormBean");
        clazz.setName(ModuleBeanGenerator.getContainerQuickAddFormName(list));
        clazz.addInterface("FormBean");
        this.startClassBody();
        this.appendGenerationPoint("generateListQuickAddForm");
        this.appendStatement("private String quickAddIds");
        this.appendStatement("private String ownerId");
        ModuleBeanGenerator.emptyline();
        this.appendString("public void setQuickAddIds(String someIds){");
        this.appendIncreasedStatement("quickAddIds = someIds");
        this.appendString("}");
        ModuleBeanGenerator.emptyline();
        this.appendString("public String getQuickAddIds(){");
        this.appendIncreasedStatement("return quickAddIds");
        this.appendString("}");
        ModuleBeanGenerator.emptyline();
        ModuleBeanGenerator.emptyline();
        this.appendString("public void setOwnerId(String anId){");
        this.appendIncreasedStatement("ownerId = anId");
        this.appendString("}");
        ModuleBeanGenerator.emptyline();
        this.appendString("public String getOwnerId(){");
        this.appendIncreasedStatement("return ownerId");
        this.appendString("}");
        ModuleBeanGenerator.emptyline();
        return clazz;
    }

    private GeneratedClass generateListElementForm(MetaDocument doc, MetaListProperty list) {
        MetaProperty p;
        int i;
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        clazz.setPackageName(ModuleBeanGenerator.getPackage(doc));
        clazz.addImport("net.anotheria.maf.bean.FormBean");
        if (list.getContainedProperty().isLinked() || list.getContainedProperty() instanceof MetaEnumerationProperty) {
            clazz.addImport("java.util.List");
        }
        ArrayList<MetaProperty> elements = new ArrayList<MetaProperty>();
        elements.add(new MetaProperty("ownerId", MetaProperty.Type.STRING));
        elements.add(new MetaProperty("position", MetaProperty.Type.INT));
        elements.add(list.getContainedProperty());
        elements.add(new MetaProperty("description", MetaProperty.Type.STRING));
        clazz.setName(ModuleBeanGenerator.getContainerEntryFormName(list));
        clazz.addInterface("FormBean");
        this.startClassBody();
        this.appendGenerationPoint("generateListElementForm");
        for (i = 0; i < elements.size(); ++i) {
            p = (MetaProperty)elements.get(i);
            this.appendStatement("private " + p.toJavaType() + " " + p.getName());
            if (!p.isLinked() && !(p instanceof MetaEnumerationProperty)) continue;
            MetaProperty collection = new MetaProperty(p.getName() + "Collection", MetaProperty.Type.LIST);
            this.appendString("@SuppressWarnings(\"unchecked\")");
            this.appendStatement("private " + collection.toJavaType() + " " + collection.getName());
        }
        ModuleBeanGenerator.emptyline();
        for (i = 0; i < elements.size(); ++i) {
            p = (MetaProperty)elements.get(i);
            this.generateMethods(null, p);
            if (!p.isLinked() && !(p instanceof MetaEnumerationProperty)) continue;
            String propName = p.getName() + "Collection";
            this.appendString("@SuppressWarnings(\"unchecked\")");
            this.appendStatement("public void set" + StringUtils.capitalize((String)propName) + "(List l){");
            this.increaseIdent();
            this.appendStatement(propName + " = l");
            this.closeBlockNEW();
            ModuleBeanGenerator.emptyline();
            this.appendString("@SuppressWarnings(\"unchecked\")");
            this.appendStatement("public List get" + StringUtils.capitalize((String)propName) + "(){");
            this.increaseIdent();
            this.appendStatement("return " + propName);
            this.closeBlockNEW();
            ModuleBeanGenerator.emptyline();
        }
        ModuleBeanGenerator.emptyline();
        return clazz;
    }

    private GeneratedClass generateTableRowForm(MetaDocument doc, MetaTableProperty p) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        clazz.setPackageName(ModuleBeanGenerator.getPackage(doc));
        clazz.addImport("net.anotheria.webutils.bean.BaseActionForm");
        clazz.addImport("jakarta.servlet.http.HttpServletRequest");
        clazz.addImport("org.apache.struts.action.ActionMapping");
        clazz.setName(ModuleBeanGenerator.getContainerEntryFormName(p));
        clazz.setParent("BaseActionForm");
        this.startClassBody();
        this.appendGenerationPoint("generateTableRowForm");
        List columns = (List)((ArrayList)p.getColumns()).clone();
        columns.add(0, new MetaProperty(p.getName() + "_ownerId", MetaProperty.Type.STRING));
        columns.add(0, new MetaProperty(p.getName() + "_position", MetaProperty.Type.INT));
        for (MetaProperty pr : columns) {
            this.appendStatement("private String " + p.extractSubName(pr));
        }
        ModuleBeanGenerator.emptyline();
        for (int i = 0; i < columns.size(); ++i) {
            MetaProperty pr;
            pr = (MetaProperty)columns.get(i);
            this.appendString("public void set" + StringUtils.capitalize((String)p.extractSubName(pr)) + "(String a" + StringUtils.capitalize((String)p.extractSubName(pr)) + " ){");
            this.increaseIdent();
            this.appendStatement("this." + p.extractSubName(pr) + " = a" + StringUtils.capitalize((String)p.extractSubName(pr)));
            this.closeBlockNEW();
            this.appendString("public String get" + StringUtils.capitalize((String)p.extractSubName(pr)) + "(){");
            this.increaseIdent();
            this.appendStatement("return " + p.extractSubName(pr));
            this.closeBlockNEW();
            ModuleBeanGenerator.emptyline();
        }
        this.appendString("public void reset( ActionMapping mapping, HttpServletRequest request ){");
        this.increaseIdent();
        this.appendString("try {");
        this.increaseIdent();
        this.appendStatement("request.setCharacterEncoding( " + this.quote(GeneratorDataRegistry.getInstance().getContext().getEncoding()) + ")");
        this.closeBlockNEW();
        this.appendString("catch ( java.io.UnsupportedEncodingException e ) {}");
        this.closeBlockNEW();
        return clazz;
    }

    public GeneratedClass generateDialogForm(MetaDialog dialog, MetaDocument doc) {
        MetaFieldElement field;
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        clazz.setPackageName(ModuleBeanGenerator.getPackage(doc));
        clazz.addImport("net.anotheria.maf.bean.FormBean");
        this.startClassBody();
        this.appendGenerationPoint("generateDialogForm");
        MetaFieldElement multilingualInstanceDisabledElement = new MetaFieldElement(FIELD_ML_DISABLED);
        List<MetaViewElement> elements = ModuleBeanGenerator.createMultilingualList(dialog.getElements(), doc);
        for (MetaViewElement element : elements) {
            MetaProperty p;
            if (!(element instanceof MetaFieldElement) || !(p = doc.getField((field = (MetaFieldElement)element).getName())).isLinked() && !(p instanceof MetaEnumerationProperty)) continue;
            clazz.addImport("java.util.List");
            clazz.addImport("net.anotheria.webutils.bean.LabelValueBean");
            break;
        }
        clazz.setName(ModuleBeanGenerator.getDialogBeanName(dialog, doc));
        clazz.addInterface("FormBean");
        this.startClassBody();
        this.appendGenerationPoint("generateDialogForm");
        for (MetaViewElement element : elements) {
            MetaProperty collection;
            MetaProperty tmp;
            if (!(element instanceof MetaFieldElement)) continue;
            field = (MetaFieldElement)element;
            String lang = this.getElementLanguage(field);
            MetaProperty p = doc.getField(field.getName());
            MetaProperty metaProperty = tmp = p instanceof MetaListProperty ? new MetaProperty(p.getName(), MetaProperty.Type.INT) : p;
            if (element.isValidated()) {
                for (MetaValidator validator : element.getValidators()) {
                    String message;
                    clazz.addImport(validator.getClassName());
                    String key = StringUtils.isEmpty((String)validator.getKey()) ? "" : validator.getKey();
                    String string = message = StringUtils.isEmpty((String)validator.getDefaultError()) ? "" : validator.getDefaultError();
                    if (validator.isCustomValidator()) {
                        clazz.addImport("net.anotheria.maf.validation.annotations.ValidateCustom");
                        this.appendString("@ValidateCustom(validator=" + validator.getClassNameOnly() + ".class, key=\"" + key + "\", message=\"" + message + "\")");
                        continue;
                    }
                    if (validator.isNumericValidator()) {
                        boolean fractional = p.getType() == MetaProperty.Type.FLOAT || p.getType() == MetaProperty.Type.DOUBLE;
                        this.appendString("@" + validator.getClassNameOnly() + "(key=\"" + key + "\", message=\"" + message + "\", fractional=" + fractional + ")");
                        continue;
                    }
                    this.appendString("@" + validator.getClassNameOnly() + "(key=\"" + key + "\", message=\"" + message + "\")");
                }
            }
            this.appendStatement("private " + tmp.toJavaType() + " " + tmp.getName(lang));
            if (p.isLinked()) {
                collection = new MetaProperty(p.getName() + "Collection" + (lang == null ? "" : lang), MetaProperty.Type.LIST);
                this.appendStatement("private " + collection.toJavaType() + "<LabelValueBean> " + collection.getName());
                this.appendStatement("private String " + p.getName() + "CurrentValue" + (lang == null ? "" : lang));
                this.appendStatement("private String " + p.getName() + "IdOfCurrentValue" + (lang == null ? "" : lang));
            }
            if (!(p instanceof MetaEnumerationProperty)) continue;
            collection = new MetaProperty(p.getName() + "Collection", MetaProperty.Type.LIST);
            this.appendStatement("private " + collection.toJavaType() + "<LabelValueBean> " + collection.getName());
            this.appendStatement("private String " + p.getName() + "CurrentValue");
            this.appendStatement("private String " + p.getName() + "IdOfCurrentValue");
        }
        ModuleBeanGenerator.emptyline();
        for (MetaViewElement element : elements) {
            if (!(element instanceof MetaFieldElement)) continue;
            this.generateFieldMethodsInDialog((MetaFieldElement)element, doc);
        }
        if (doc.isMultilingual()) {
            MetaProperty mlDisProp = doc.getField(multilingualInstanceDisabledElement.getName());
            this.appendStatement("private " + mlDisProp.toJavaType() + " " + mlDisProp.getName());
            ModuleBeanGenerator.emptyline();
            this.generateFieldMethodsInDialog(multilingualInstanceDisabledElement, doc);
        }
        this.generateAdditionalFields(doc, "locked", MetaProperty.Type.BOOLEAN, "LockableObject \"locked\" property. For object Locking.");
        this.generateAdditionalFields(doc, "lockerId", MetaProperty.Type.STRING, "LockableObject \"lockerId\" property. For userName containing.");
        this.generateAdditionalFields(doc, "lockingTime", MetaProperty.Type.STRING, "LockableObject \"lockingTime\" property.");
        for (MetaViewElement element : elements) {
            if (!element.isShowLink()) continue;
            this.generateAdditionalFields(doc, element.getName() + "link", MetaProperty.Type.STRING, "Link to " + element.getName());
        }
        ModuleBeanGenerator.emptyline();
        return clazz;
    }

    public static String getPackage(MetaDocument doc) {
        return ModuleBeanGenerator.getPackage(GeneratorDataRegistry.getInstance().getContext(), doc);
    }

    public static String getPackage(MetaModule module) {
        return ModuleBeanGenerator.getPackage(GeneratorDataRegistry.getInstance().getContext(), module);
    }

    public static String getPackage(Context context, MetaModule module) {
        return context.getPackageName(module) + ".bean";
    }

    public static String getPackage(Context context, MetaDocument doc) {
        return context.getPackageName(doc) + ".bean";
    }

    public static String getDialogBeanName(MetaDialog dialog, MetaDocument document) {
        return StringUtils.capitalize((String)dialog.getName()) + StringUtils.capitalize((String)document.getName()) + "FB";
    }

    private void generateFieldMethodsInDialog(MetaFieldElement element, MetaDocument doc) {
        MetaProperty p = null;
        p = doc.getField(element.getName());
        if (p.isLinked() || p instanceof MetaEnumerationProperty) {
            MetaFieldElement pColl = new MetaFieldElement(element.getName() + "Collection");
            MetaFieldElement pCurr = new MetaFieldElement(element.getName() + "CurrentValue");
            MetaFieldElement pIdOfCurr = new MetaFieldElement(element.getName() + "IdOfCurrentValue");
            if (p.isMultilingual()) {
                String l = this.getElementLanguage(element);
                MetaListProperty pCollProperty = new MetaListProperty(element.getName() + "Collection", new MetaProperty("temp", new ObjectType("LabelValueBean")));
                pCollProperty.setMultilingual(true);
                this.generateMethods(new MultilingualFieldElement(l, pColl), pCollProperty);
                this.generateMethods(new MultilingualFieldElement(l, pCurr), new MetaProperty(element.getName() + "CurrentValue", MetaProperty.Type.STRING, true));
                this.generateMethods(new MultilingualFieldElement(l, pIdOfCurr), new MetaProperty(element.getName() + "IdOfCurrentValue", MetaProperty.Type.STRING, true));
            } else {
                this.generateMethods(pColl, new MetaListProperty(element.getName() + "Collection", new MetaProperty("temp", new ObjectType("LabelValueBean"))));
                this.generateMethods(pCurr, new MetaProperty(element.getName() + "CurrentValue", MetaProperty.Type.STRING));
                this.generateMethods(pIdOfCurr, new MetaProperty(element.getName() + "IdOfCurrentValue", MetaProperty.Type.STRING));
            }
        }
        MetaProperty tmp = p instanceof MetaListProperty ? new MetaProperty(p.getName(), MetaProperty.Type.INT) : p;
        this.generateMethods(element, tmp);
    }

    private void generateAdditionalFields(MetaDocument doc, String fieldName, MetaProperty.Type fieldType, String comment) {
        if (doc.getParentModule().getStorageType().equals((Object)StorageType.CMS)) {
            MetaFieldElement fieldElement = new MetaFieldElement(fieldName);
            MetaProperty maField = new MetaProperty(fieldElement.getName(), fieldType);
            this.appendComment(comment);
            this.appendStatement("private " + maField.toJavaType() + " " + maField.getName());
            ModuleBeanGenerator.emptyline();
            this.generateMethods(fieldElement, maField);
        }
    }

    private GeneratedClass generateListItemSortType(MetaModuleSection section) {
        String lang;
        MetaProperty p;
        MetaViewElement element;
        int i;
        List<MetaViewElement> elements = section.getElements();
        boolean containsComparable = false;
        for (MetaViewElement element2 : elements) {
            if (!element2.isComparable()) continue;
            containsComparable = true;
            break;
        }
        if (!containsComparable) {
            return null;
        }
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        clazz.setPackageName(ModuleBeanGenerator.getPackage(section.getDocument()));
        clazz.addImport("net.anotheria.util.sorter.SortType");
        clazz.setName(ModuleBeanGenerator.getListItemBeanSortTypeName(section.getDocument()));
        clazz.setParent("SortType");
        this.startClassBody();
        this.appendGenerationPoint("generateListItemSortType");
        MetaViewElement defaultElem = section.getDefaultSortable();
        String defaultElemName = null;
        int lastIndex = 1;
        elements = ModuleBeanGenerator.createMultilingualList(elements, section.getDocument());
        for (i = 0; i < elements.size(); ++i) {
            element = elements.get(i);
            if (!element.isComparable()) continue;
            if (element.equals(defaultElem)) {
                defaultElemName = element instanceof MultilingualFieldElement ? "SORT_BY_" + section.getDocument().getField(element.getName()).getName(GeneratorDataRegistry.getInstance().getContext().getDefaultLanguage()).toUpperCase() : "SORT_BY_" + element.getName().toUpperCase();
            }
            if (element instanceof MultilingualFieldElement) {
                p = section.getDocument().getField(element.getName());
                this.appendStatement("public static final int SORT_BY_" + p.getName(((MultilingualFieldElement)element).getLanguage()).toUpperCase() + " = " + lastIndex++);
                continue;
            }
            this.appendStatement("public static final int SORT_BY_" + element.getName().toUpperCase() + " = " + lastIndex++);
        }
        this.appendStatement("public static final int SORT_BY_DEFAULT = " + defaultElemName);
        ModuleBeanGenerator.emptyline();
        this.appendString("public " + ModuleBeanGenerator.getListItemBeanSortTypeName(section.getDocument()) + "(){");
        this.increaseIdent();
        this.appendString("super(SORT_BY_DEFAULT);");
        this.closeBlockNEW();
        ModuleBeanGenerator.emptyline();
        this.appendString("public " + ModuleBeanGenerator.getListItemBeanSortTypeName(section.getDocument()) + "(int method){");
        this.increaseIdent();
        this.appendString("super(method);");
        this.closeBlockNEW();
        ModuleBeanGenerator.emptyline();
        this.appendString("public " + ModuleBeanGenerator.getListItemBeanSortTypeName(section.getDocument()) + "(int method, boolean order){");
        this.increaseIdent();
        this.appendString("super(method, order);");
        this.closeBlockNEW();
        ModuleBeanGenerator.emptyline();
        this.appendString("public static int name2method(String name){");
        this.increaseIdent();
        for (i = 0; i < elements.size(); ++i) {
            element = elements.get(i);
            if (!element.isComparable()) continue;
            p = section.getDocument().getField(element.getName());
            if (element instanceof MultilingualFieldElement) {
                lang = ((MultilingualFieldElement)element).getLanguage();
                this.appendString("if (" + this.quote(p.getName(lang)) + ".equals(name))");
                this.appendIncreasedStatement("return SORT_BY_" + p.getName(lang).toUpperCase());
                continue;
            }
            this.appendString("if (" + this.quote(p.getName()) + ".equals(name))");
            this.appendIncreasedStatement("return SORT_BY_" + p.getName().toUpperCase());
        }
        this.appendStatement("throw new RuntimeException(" + this.quote("Unknown sort type name: ") + "+name)");
        this.closeBlockNEW();
        ModuleBeanGenerator.emptyline();
        this.appendString("public static String method2name(int method){");
        this.increaseIdent();
        this.appendString("switch (method){");
        this.increaseIdent();
        for (i = 0; i < elements.size(); ++i) {
            element = elements.get(i);
            if (!element.isComparable()) continue;
            p = section.getDocument().getField(element.getName());
            if (element instanceof MultilingualFieldElement) {
                lang = ((MultilingualFieldElement)element).getLanguage();
                this.appendString("case SORT_BY_" + p.getName(lang).toUpperCase() + ":");
                this.appendIncreasedStatement("return " + this.quote(p.getName(lang)));
                continue;
            }
            this.appendString("case SORT_BY_" + p.getName().toUpperCase() + ":");
            this.appendIncreasedStatement("return " + this.quote(p.getName()));
        }
        this.closeBlockNEW();
        this.appendStatement("throw new RuntimeException(" + this.quote("Unknown sort type method: ") + "+method)");
        this.closeBlockNEW();
        ModuleBeanGenerator.emptyline();
        this.appendString("public String getMethodAndOrderCode(){");
        this.increaseIdent();
        this.appendStatement("return method2name(getSortBy())+" + this.quote("_") + "+(getSortOrder() ? " + this.quote("ASC") + ":" + this.quote("DESC") + ")");
        this.closeBlockNEW();
        return clazz;
    }

    private GeneratedClass generateListItemBean(MetaModuleSection section) {
        int i;
        MetaFieldElement field;
        MetaProperty p;
        MetaViewElement element2;
        System.out.println("generate list item bean " + section.getDocument().getName());
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        clazz.setClazzComment("Generated by " + ModuleBeanGenerator.class);
        MetaDocument doc = section.getDocument();
        List<MetaViewElement> origElements = section.getElements();
        if (doc.getName().equals("BoxType")) {
            this.debugTest = true;
        }
        if (doc.getName().equals("Pagex")) {
            this.debugTest = true;
        }
        if (this.debugTest) {
            System.out.println("%%% DEBUG ON %%%");
        }
        List<MetaViewElement> elements = ModuleBeanGenerator.createMultilingualList(origElements, doc);
        MetaFieldElement plainId = new MetaFieldElement("plainId");
        plainId.setComparable(false);
        plainId.setReadonly(true);
        plainId.setDecorator(null);
        elements.add(plainId);
        MetaFieldElement versionInfo = new MetaFieldElement("documentLastUpdateTimestamp");
        plainId.setComparable(false);
        plainId.setReadonly(true);
        plainId.setDecorator(null);
        elements.add(versionInfo);
        clazz.setPackageName(ModuleBeanGenerator.getPackage(section.getDocument()));
        boolean containsComparable = false;
        for (MetaViewElement element2 : elements) {
            if (!element2.isComparable()) continue;
            containsComparable = true;
            break;
        }
        for (MetaViewElement element2 : elements) {
            if (!(element2 instanceof MetaFieldElement) || !((p = doc.getField((field = (MetaFieldElement)element2).getName())) instanceof MetaListProperty)) continue;
            clazz.addImport("java.util.List");
            break;
        }
        clazz.setName(ModuleBeanGenerator.getListItemBeanName(section.getDocument()));
        this.startClassBody();
        this.appendGenerationPoint("generateListItemBean");
        for (i = 0; i < elements.size(); ++i) {
            element2 = elements.get(i);
            if (element2 instanceof MetaFieldElement) {
                field = (MetaFieldElement)element2;
                p = doc.getField(field.getName());
                if (p instanceof MetaEnumerationProperty) {
                    this.appendStatement("private String " + p.getName());
                } else {
                    MetaProperty tmp = p;
                    if (field instanceof MultilingualFieldElement) {
                        if (field.getDecorator() != null) {
                            this.appendStatement("private String " + tmp.getName(((MultilingualFieldElement)field).getLanguage()));
                            this.appendStatement("private " + tmp.toJavaType() + " " + tmp.getName("ForSorting", ((MultilingualFieldElement)field).getLanguage()));
                        } else {
                            this.appendStatement("private " + tmp.toJavaType() + " " + tmp.getName(((MultilingualFieldElement)field).getLanguage()));
                        }
                    } else if (field.getDecorator() != null) {
                        this.appendStatement("private String " + tmp.getName());
                        if (tmp instanceof MetaListProperty) {
                            element2.setSortingType(SortingType.CONTAINERS);
                        }
                        this.appendCommentLine("Elements sort type is " + element2.getSortingType());
                        if (element2.getName().equals("id")) {
                            this.appendStatement("private " + element2.getSortingType().getJavaType() + " " + tmp.getName() + "ForSorting");
                        } else {
                            this.appendStatement("private " + tmp.toJavaType() + " " + tmp.getName() + "ForSorting");
                        }
                    } else {
                        this.appendStatement("private " + tmp.toJavaType() + " " + tmp.getName());
                    }
                }
            }
            if (!(element2 instanceof MetaFunctionElement)) continue;
            MetaFunctionElement function = (MetaFunctionElement)element2;
            this.appendStatement("private String " + function.getPropertyName());
        }
        ModuleBeanGenerator.emptyline();
        for (i = 0; i < elements.size(); ++i) {
            element2 = elements.get(i);
            if (this.debugTest) {
                System.out.println("checking " + element2.getName() + " " + element2.getClass().getSimpleName());
            }
            if (element2 instanceof MetaFieldElement) {
                this.generateFieldMethods((MetaFieldElement)element2, doc);
            }
            if (!(element2 instanceof MetaFunctionElement)) continue;
            this.generateFunctionMethods((MetaFunctionElement)element2);
        }
        this.generateAdditionalFields(doc, "locked", MetaProperty.Type.BOOLEAN, "LockableObject \"locked\" property. For object Locking.");
        this.generateAdditionalFields(doc, "lockerId", MetaProperty.Type.STRING, "LockableObject \"lockerId\" property. For userName containing.");
        this.generateAdditionalFields(doc, "lockingTime", MetaProperty.Type.STRING, "LockableObject \"lockingTime\" property.");
        if (containsComparable) {
            clazz.addImport("net.anotheria.util.sorter.IComparable");
            clazz.addImport("net.anotheria.util.BasicComparable");
            clazz.addInterface("IComparable");
            ModuleBeanGenerator.emptyline();
            this.generateCompareMethod(doc, elements);
        }
        if (this.debugTest) {
            System.out.println("%%% DEBUG OFF %%%");
        }
        return clazz;
    }

    private void generateFunctionMethods(MetaFunctionElement function) {
        this.generateMethods(function, new MetaProperty(function.getPropertyName(), MetaProperty.Type.STRING));
    }

    private void generateCompareMethod(MetaDocument doc, List<MetaViewElement> elements) {
        this.appendString("public int compareTo(IComparable anotherComparable, int method){");
        this.increaseIdent();
        this.appendStatement(ModuleBeanGenerator.getListItemBeanName(doc) + " anotherBean = (" + ModuleBeanGenerator.getListItemBeanName(doc) + ") anotherComparable");
        this.appendString("switch(method){");
        this.increaseIdent();
        for (MetaViewElement element : elements) {
            if (!element.isComparable()) continue;
            MetaFieldElement field = (MetaFieldElement)element;
            MetaProperty p = doc.getField(field.getName());
            String lang = this.getElementLanguage(element);
            String caseDecl = lang != null ? ModuleBeanGenerator.getListItemBeanSortTypeName(doc) + ".SORT_BY_" + p.getName(lang).toUpperCase() : ModuleBeanGenerator.getListItemBeanSortTypeName(doc) + ".SORT_BY_" + p.getName().toUpperCase();
            this.appendString("case " + caseDecl + ":");
            String type2compare = p instanceof MetaEnumerationProperty ? "String" : StringUtils.capitalize((String)p.toJavaErasedType());
            String retDecl = "return BasicComparable.compare" + type2compare;
            if (element.getName().equals("id")) {
                retDecl = "return BasicComparable." + element.getSortingType().getCompareCall();
            }
            retDecl = retDecl + (field.getDecorator() != null ? "(" + p.getName("ForSorting", lang) + ", anotherBean." + p.getName("ForSorting", lang) + ")" : "(" + p.getName(lang) + ", anotherBean." + p.getName(lang) + ")");
            this.appendIncreasedStatement(retDecl);
        }
        this.appendString("default:");
        this.appendIncreasedStatement("throw new RuntimeException(\"Sort method \"+method+\" is not supported.\")");
        this.closeBlockNEW();
        this.closeBlockNEW();
    }

    private void generateFieldMethods(MetaFieldElement element, MetaDocument doc) {
        MetaProperty p = doc.getField(element.getName());
        if (p instanceof MetaEnumerationProperty) {
            MetaProperty tmp = new MetaProperty(p.getName(), MetaProperty.Type.STRING);
            this.generateMethods(element, tmp);
            return;
        }
        if (this.debugTest) {
            System.out.println(element.getName() + " - " + element.getDecorator());
        }
        if (element.getDecorator() != null) {
            MetaProperty tmpForSorting = (MetaProperty)p.clone();
            tmpForSorting.setName(tmpForSorting.getName() + "ForSorting");
            this.generateMethodsForSorting(element, tmpForSorting);
            p = new MetaProperty(p.getName(), MetaProperty.Type.STRING, p.isMultilingual());
        }
        this.generateMethods(element, p);
    }

    private void generateMethods(MetaViewElement element, MetaProperty p) {
        if (this.debugTest) {
            System.out.println("  GenerateMethods for " + element + " ... " + p);
        }
        if (element instanceof MultilingualFieldElement) {
            this.generateMethodsMultilinguage((MultilingualFieldElement)element, p);
            return;
        }
        this.appendString("public void " + p.toBeanSetter() + "(" + p.toJavaType() + " " + p.getName() + " ){");
        this.increaseIdent();
        this.appendStatement("this." + p.getName() + " = " + p.getName());
        this.closeBlockNEW();
        ModuleBeanGenerator.emptyline();
        this.appendString("public " + p.toJavaType() + " " + p.toBeanGetter() + "(){");
        this.increaseIdent();
        this.appendStatement("return " + p.getName());
        this.closeBlockNEW();
        ModuleBeanGenerator.emptyline();
    }

    private void generateMethodsForSorting(MetaViewElement element, MetaProperty p) {
        if (element instanceof MultilingualFieldElement) {
            this.generateMethodsMultilinguage((MultilingualFieldElement)element, p);
            return;
        }
        this.appendString("public void " + p.toBeanSetter() + "(" + p.toJavaType() + " " + p.getName() + " ){");
        this.increaseIdent();
        this.appendStatement("this." + p.getName() + " = " + element.getSortingType().convertValue(p.getName()));
        this.closeBlockNEW();
        ModuleBeanGenerator.emptyline();
        if (element.getName().equals("id")) {
            this.appendString("public " + element.getSortingType().getJavaType() + " " + p.toBeanGetter() + "(){");
        } else {
            this.appendString("public " + p.toJavaType() + " " + p.toBeanGetter() + "(){");
        }
        this.increaseIdent();
        this.appendStatement("return " + p.getName());
        this.closeBlockNEW();
        ModuleBeanGenerator.emptyline();
    }

    private void generateMethodsMultilinguage(MultilingualFieldElement element, MetaProperty p) {
        if (p.getType() == MetaProperty.Type.LIST) {
            this.appendString("@SuppressWarnings(\"unchecked\")");
        }
        this.appendString("public void " + p.toBeanSetter(element.getLanguage()) + "(" + p.toJavaType() + " " + p.getName() + " ){");
        this.increaseIdent();
        this.appendStatement("this." + p.getName(element.getLanguage()) + " = " + p.getName());
        this.closeBlockNEW();
        ModuleBeanGenerator.emptyline();
        if (p.getType() == MetaProperty.Type.LIST) {
            this.appendString("@SuppressWarnings(\"unchecked\")");
        }
        this.appendString("public " + p.toJavaType() + " " + p.toBeanGetter(element.getLanguage()) + "(){");
        this.increaseIdent();
        this.appendStatement("return " + p.getName(element.getLanguage()));
        this.closeBlockNEW();
        ModuleBeanGenerator.emptyline();
    }

    public static String getListItemBeanSortTypeImport(Context context, MetaDocument doc) {
        return ModuleBeanGenerator.getPackage(context, doc) + "." + ModuleBeanGenerator.getListItemBeanSortTypeName(doc);
    }

    public static String getListItemBeanSortTypeName(MetaDocument doc) {
        return ModuleBeanGenerator.getListItemBeanName(doc) + "SortType";
    }

    public static String getListItemBeanName(MetaDocument doc) {
        return doc.getName() + "ListItemBean";
    }

    public static String getDialogBeanImport(MetaDialog dialog, MetaDocument doc) {
        return ModuleBeanGenerator.getPackage(GeneratorDataRegistry.getInstance().getContext(), doc) + "." + ModuleBeanGenerator.getDialogBeanName(dialog, doc);
    }

    public static String getListItemBeanImport(Context context, MetaDocument doc) {
        return ModuleBeanGenerator.getPackage(context, doc) + "." + ModuleBeanGenerator.getListItemBeanName(doc);
    }

    public static String getContainerEntryFormImport(MetaDocument doc, MetaContainerProperty p) {
        return GeneratorDataRegistry.getInstance().getContext().getPackageName(doc) + ".bean." + ModuleBeanGenerator.getContainerEntryFormName(p);
    }

    public static String getContainerEntryFormName(MetaContainerProperty p) {
        return StringUtils.capitalize((String)p.getName()) + p.getContainerEntryName() + "FB";
    }

    public static String getContainerQuickAddFormImport(MetaDocument doc, MetaContainerProperty p) {
        return GeneratorDataRegistry.getInstance().getContext().getPackageName(doc) + ".bean." + ModuleBeanGenerator.getContainerQuickAddFormName(p);
    }

    public static String getContainerQuickAddFormName(MetaContainerProperty p) {
        return StringUtils.capitalize((String)p.getName()) + "QuickAddFB";
    }

    public static String getFormBeanImport(MetaForm form) {
        return ModuleBeanGenerator.getPackage() + "." + ModuleBeanGenerator.getFormBeanName(form);
    }

    @Deprecated
    public static String getPackage() {
        return GeneratorDataRegistry.getInstance().getContext().getPackageName() + ".bean";
    }

    public static String getFormBeanName(MetaForm form) {
        return StringUtils.capitalize((String)form.getId()) + "AutoForm";
    }
}

