/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.view.jsp;

import java.util.List;
import net.anotheria.asg.generator.AbstractGenerator;
import net.anotheria.asg.generator.Context;
import net.anotheria.asg.generator.GeneratedJSPFile;
import net.anotheria.asg.generator.Generator;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.meta.MetaContainerProperty;
import net.anotheria.asg.generator.meta.MetaDocument;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.asg.generator.view.CMSMappingsConfiguratorGenerator;
import net.anotheria.asg.generator.view.jsp.MenuJspGenerator;
import net.anotheria.asg.generator.view.jsp.SharedFooterJspGenerator;
import net.anotheria.asg.generator.view.meta.MetaDialog;
import net.anotheria.asg.generator.view.meta.MetaModuleSection;
import net.anotheria.asg.generator.view.meta.MetaSection;
import net.anotheria.asg.generator.view.meta.MetaView;
import net.anotheria.util.ArrayUtils;
import net.anotheria.util.StringUtils;

public abstract class AbstractJSPGenerator
extends AbstractGenerator {
    public static final String FOOTER_SELECTION_QUERIES = "Queries";
    public static final String FOOTER_SELECTION_CMS = "CMS";

    @Override
    protected void appendCommentLine(String commentLine) {
        this.appendString("<%-- " + commentLine + " --%>");
    }

    protected String getBaseJSPHeader() {
        Object ret = "";
        ret = (String)ret + "<%-- generated by AbstractJSPGenerator.getBaseJSPHeader --%>\n";
        ret = (String)ret + "<%@ page\n";
        ret = (String)ret + "\tcontentType=\"text/html;charset=" + GeneratorDataRegistry.getInstance().getContext().getEncoding() + "\" session=\"true\"\n";
        ret = (String)ret + "%><%@ taglib uri=\"http://www.anotheria.net/ano-tags\" prefix=\"ano\"\n";
        ret = (String)ret + "%><%@ taglib uri=\"/WEB-INF/tlds/anosite.tld\" prefix=\"as\"\n";
        ret = (String)ret + "%><%@ page isELIgnored =\"false\" %>\n";
        ret = (String)ret + "<%-- / generated by AbstractJSPGenerator.getBaseJSPHeader --%>\n";
        return ret;
    }

    protected String getBaseXMLHeader() {
        Object ret = "";
        ret = (String)ret + "<%@ page\n";
        ret = (String)ret + "\tcontentType=\"text/xml;charset=" + GeneratorDataRegistry.getInstance().getContext().getEncoding() + "\" session=\"true\"\n";
        ret = (String)ret + "%><%@ taglib uri=\"http://www.anotheria.net/ano-tags\" prefix=\"ano\"\n";
        ret = (String)ret + "%><%@ taglib uri=\"/WEB-INF/tld/ano-tags-xml.tld\" prefix=\"ano-xml\"\n";
        ret = (String)ret + "%>";
        return ret;
    }

    protected String getBaseCSVHeader() {
        Object ret = "";
        ret = (String)ret + "<%@ page\n";
        ret = (String)ret + "\tcontentType=\"application/msexcel;charset=" + GeneratorDataRegistry.getInstance().getContext().getEncoding() + "\" session=\"true\"\n";
        ret = (String)ret + "%><%@ taglib uri=\"http://www.anotheria.net/ano-tags\" prefix=\"ano\"\n";
        ret = (String)ret + "%>";
        return ret;
    }

    private String getFooterLink(String selection, String link, String linkCaption) {
        if (selection != null && selection.equals(linkCaption)) {
            return "<strong>" + linkCaption + "</strong>";
        }
        return "&nbsp;<a href=\"<ano:tslink>" + link + "</ano:tslink>\">" + linkCaption + "</a>";
    }

    protected GeneratedJSPFile generateFooter(MetaView view, String selection, String name) {
        GeneratedJSPFile jsp = new GeneratedJSPFile();
        this.startNewJob(jsp);
        jsp.setPackage(GeneratorDataRegistry.getInstance().getContext().getPackageName(MetaModule.SHARED) + ".jsp");
        jsp.setName(name);
        this.append(this.getBaseJSPHeader());
        this.appendString("<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">");
        this.increaseIdent();
        this.appendString("<tr>");
        this.increaseIdent();
        this.appendString("<td>");
        this.increaseIdent();
        this.appendString(this.getFooterLink(selection, this.defineLinkToViewCms(view), FOOTER_SELECTION_CMS));
        this.appendString("&nbsp;|&nbsp;");
        this.appendString(this.getFooterLink(selection, this.defineLinkToViewQueries(view), FOOTER_SELECTION_QUERIES));
        this.decreaseIdent();
        this.appendString("</td>");
        this.appendString("<td>");
        this.appendIncreasedString("<jsp:include page=" + this.quote(SharedFooterJspGenerator.getSharedJspFooterPageName()) + " flush=" + this.quote("false") + "/>");
        this.appendString("</td>");
        this.appendString("<td align=" + this.quote("right") + ">");
        this.increaseIdent();
        this.appendString("Generated by " + Generator.getProductString() + " V " + Generator.getVersionString());
        String timestamp = "Timestamp unset";
        this.appendString(" on " + timestamp + "&nbsp;|&nbsp;");
        this.appendString("<a href=\"<ano:tslink>logout</ano:tslink>\">Logout</a>&nbsp;");
        this.decreaseIdent();
        this.appendString("</td>");
        this.decreaseIdent();
        this.appendString("</tr>");
        this.decreaseIdent();
        this.appendString("</table>");
        this.append(this.getBaseJSPFooter());
        return jsp;
    }

    private String defineLinkToViewQueries(MetaView view) {
        String ret = "#";
        List<MetaSection> sections = view.getSections();
        for (int i = 0; i < sections.size(); ++i) {
            MetaModuleSection ms;
            MetaDocument targetDoc;
            MetaSection s = sections.get(i);
            if (!(s instanceof MetaModuleSection) || (targetDoc = (ms = (MetaModuleSection)s).getDocument()).getLinks().size() <= 0) continue;
            return CMSMappingsConfiguratorGenerator.getShowQueriesPath(targetDoc);
        }
        return ret;
    }

    protected String getDuplicateImage() {
        return this.getDuplicateImage("duplicate");
    }

    private String defineLinkToViewCms(MetaView view) {
        String ret = "#";
        List<MetaSection> sections = view.getSections();
        for (int i = 0; i < sections.size(); ++i) {
            MetaSection s = sections.get(i);
            if (!(s instanceof MetaModuleSection)) continue;
            MetaDocument targetDoc = ((MetaModuleSection)s).getDocument();
            return CMSMappingsConfiguratorGenerator.getShowCMSPath(targetDoc);
        }
        return ret;
    }

    protected String getBaseJSPFooter() {
        String ret = "<!-- generated by " + Generator.getProductString() + " V " + Generator.getVersionString() + ", visit www.anotheria.net for details -->";
        return ret;
    }

    public static String getShowPageName(MetaDocument doc) {
        return "Show" + doc.getMultiple();
    }

    public static String getSearchResultPageName() {
        return "SearchResult";
    }

    public static String getVersionInfoPageName() {
        return "VersionInfo";
    }

    public static String getVersionInfoPageName(MetaDocument doc) {
        return AbstractJSPGenerator.getVersionInfoPageName();
    }

    public static String getShowQueriesPageName(MetaDocument doc) {
        return "Show" + doc.getMultiple() + FOOTER_SELECTION_QUERIES;
    }

    public static String getExportAsCSVPageName(MetaDocument doc) {
        return "Show" + doc.getMultiple() + "AsCSV";
    }

    public static String getExportAsXMLPageName(MetaDocument doc) {
        return "Show" + doc.getMultiple() + "AsXML";
    }

    public static String getEditPageName(MetaDocument doc) {
        return "Edit" + doc.getName();
    }

    public static String getDialogName(MetaDialog dialog, MetaDocument doc) {
        return dialog.getName() + doc.getName();
    }

    public static String getLinksToMePageName(MetaDocument doc) {
        return "LinksTo" + doc.getName();
    }

    public static String getContainerPageName(MetaDocument doc, MetaContainerProperty table) {
        return "Show" + doc.getName() + StringUtils.capitalize((String)table.getName());
    }

    protected static String generateTimestampedLinkPath(String path) {
        return "<ano:tslink>" + path + "</ano:tslink>";
    }

    protected String getCurrentImagePath(String imageName) {
        return AbstractJSPGenerator.getImagePath(imageName, GeneratorDataRegistry.getInstance().getContext());
    }

    public static String getImagePath(String imageName, Context context) {
        return context.getApplicationURLPath() + "/img/" + imageName;
    }

    protected String getCurrentCSSPath(String stylesheetName) {
        return AbstractJSPGenerator.getCSSPath(stylesheetName, GeneratorDataRegistry.getInstance().getContext());
    }

    protected String getCurrentJSPath(String jsName) {
        return AbstractJSPGenerator.getJSPath(jsName, GeneratorDataRegistry.getInstance().getContext());
    }

    protected String getCurrentYUIPath(String yuiName) {
        return AbstractJSPGenerator.getYUIPath(yuiName, GeneratorDataRegistry.getInstance().getContext());
    }

    protected String getCurrentJavaScriptPath(String javaScript) {
        return AbstractJSPGenerator.getJavaScriptPath(javaScript, GeneratorDataRegistry.getInstance().getContext());
    }

    public static String getCSSPath(String stylesheetName, Context context) {
        return context.getApplicationURLPath() + "/cms_static/css/" + stylesheetName;
    }

    public static String getJSPath(String jsName, Context context) {
        return context.getApplicationURLPath() + "/cms_static/js/" + jsName;
    }

    public static String getJavaScriptPath(String javaScript, Context context) {
        return context.getApplicationURLPath() + "/cms_static/js/" + javaScript;
    }

    public static String getYUIPath(String yuiName, Context context) {
        return context.getApplicationURLPath() + "/cms_static/yui/" + yuiName;
    }

    public static String getPackage(MetaModule mod) {
        return GeneratorDataRegistry.getInstance().getContext().getJspPackageName(mod);
    }

    public static String getPackage(MetaDocument doc) {
        return GeneratorDataRegistry.getInstance().getContext().getJspPackageName(doc);
    }

    protected String getDeleteImage() {
        return this.getDeleteImage("delete");
    }

    protected String getPreviewImage() {
        return this.getPreviewImage("preview");
    }

    protected String getVersionImage() {
        return this.getVersionImage("version");
    }

    protected String getEditImage() {
        return this.getEditImage("edit");
    }

    protected String getVersionImage(String alt) {
        return this.getImage("version", alt);
    }

    protected String getDeleteImage(String alt) {
        return this.getImage("delete", alt);
    }

    protected String getPreviewImage(String alt) {
        return this.getImage("preview", alt);
    }

    protected String getLockImage() {
        return this.getLockImage("lock");
    }

    protected String getUnLockImage() {
        return this.getUnLockImage("unlock");
    }

    protected String getLockImage(String alt) {
        return this.getImage("lock", alt);
    }

    protected String getUnLockImage(String alt) {
        return this.getImage("unlock", alt);
    }

    protected String getTopImage(String alt) {
        return this.getImage("top", alt);
    }

    protected String getBottomImage(String alt) {
        return this.getImage("bottom", alt);
    }

    protected String getUpImage(String alt) {
        return this.getImage("up", alt);
    }

    protected String getDownImage(String alt) {
        return this.getImage("down", alt);
    }

    protected String getDuplicateImage(String alt) {
        return this.getImage("clone", alt);
    }

    protected String getEditImage(String alt) {
        return this.getImage("edit_icon", alt);
    }

    protected String getImage(String name, String alt) {
        return "<img src=\"" + GeneratorDataRegistry.getInstance().getContext().getApplicationURLPath() + "/cms_static/img/" + name + ".gif\" alt=" + this.quote(alt) + " title=" + this.quote(alt) + ">";
    }

    public Context getContext() {
        return GeneratorDataRegistry.getInstance().getContext();
    }

    protected void generatePragmas(MetaView view) {
        this.generatePragmas();
    }

    protected void generatePragmas() {
        this.appendString("<meta http-equiv=\"pragma\" content=\"no-cache\"/>");
        this.appendString("<meta http-equiv=\"Cache-Control\" content=\"no-cache, must-revalidate\"/>");
        this.appendString("<meta name=\"Expires\" content=\"0\"/>");
        this.appendString("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + GeneratorDataRegistry.getInstance().getContext().getEncoding() + "\"/>");
    }

    protected void openTag(String tag, String params) {
        this.appendString("<" + tag + (params.length() > 0 ? " " : "") + params + ">");
    }

    protected void closeTag(String tag, String params) {
        this.appendString("</" + tag + (params.length() > 0 ? " " : "") + params + ">");
    }

    protected void openTR(String additionalParams) {
        this.openTag("tr", additionalParams);
        this.increaseIdent();
    }

    protected void closeTR(String additionalParams) {
        this.decreaseIdent();
        this.closeTag("tr", additionalParams);
    }

    protected void openTR() {
        this.openTR("");
    }

    protected void closeTR() {
        this.closeTR("");
    }

    protected void openTD() {
        this.openTD("");
    }

    protected void closeTD() {
        this.closeTD("");
    }

    protected void openTD(String additionalParams) {
        this.openTag("td", additionalParams);
    }

    protected void closeTD(String additionalParams) {
        this.closeTag("td", additionalParams);
    }

    protected void tag(String tag, String id, String clazz, TagAttribute ... attrs) {
        attrs = (TagAttribute[])ArrayUtils.mergeArrays((Object[])new TagAttribute[]{new TagAttribute("id", id), new TagAttribute("class", clazz)}, (Object[])attrs);
        this.tag(tag, attrs);
    }

    protected void tag(String tag, String clazz, TagAttribute ... attrs) {
        attrs = (TagAttribute[])ArrayUtils.mergeArrays((Object[])new TagAttribute[]{new TagAttribute("class", clazz)}, (Object[])attrs);
        this.tag(tag, attrs);
    }

    protected void tag(String tag, TagAttribute ... attrs) {
        StringBuilder attrsStr = new StringBuilder();
        for (TagAttribute attr : attrs) {
            attrsStr.append(" " + attr.toString());
        }
        this.appendString("<" + tag, attrsStr.toString(), "/>");
    }

    protected void tagOpen(String tag, String id, String clazz, TagAttribute ... attrs) {
        attrs = (TagAttribute[])ArrayUtils.mergeArrays((Object[])new TagAttribute[]{new TagAttribute("id", id), new TagAttribute("class", clazz)}, (Object[])attrs);
        this.tagOpen(tag, attrs);
    }

    protected void tagOpen(String tag, String clazz, TagAttribute ... attrs) {
        attrs = (TagAttribute[])ArrayUtils.mergeArrays((Object[])new TagAttribute[]{new TagAttribute("class", clazz)}, (Object[])attrs);
        this.tagOpen(tag, attrs);
    }

    protected void tagOpen(String tag, TagAttribute ... attrs) {
        StringBuilder attrsStr = new StringBuilder();
        for (TagAttribute attr : attrs) {
            attrsStr.append(" " + attr.toString());
        }
        this.appendString("<" + tag, attrsStr.toString(), ">");
        this.increaseIdent();
    }

    protected void tagClose(String tag) {
        this.decreaseIdent();
        this.appendString("</" + tag + ">");
    }

    protected void openJavaScript() {
        this.tagOpen("script", new TagAttribute("type", "text/javascript"));
    }

    protected void closeJavaScript() {
        this.tagClose("script");
    }

    protected String getTopMenuPage() {
        return "../../shared/jsp/" + MenuJspGenerator.getMenuPageName();
    }

    protected String getMenuName(MetaView view) {
        return "../../shared/jsp/" + StringUtils.capitalize((String)view.getName()) + "Menu";
    }

    protected String getFooterName(MetaView view) {
        return "../../shared/jsp/" + StringUtils.capitalize((String)view.getName()) + "Footer";
    }

    protected static class TagAttribute {
        private String name;
        private String value;

        public TagAttribute(String aName, String aValue) {
            this.name = aName;
            this.value = aValue;
        }

        public String toString() {
            return StringUtils.isEmpty((String)this.value) ? this.name : this.name + "=\"" + this.value + "\"";
        }
    }
}

