/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.view.jsp;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.asg.generator.FileEntry;
import net.anotheria.asg.generator.GeneratedJSPFile;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.IGenerateable;
import net.anotheria.asg.generator.IGenerator;
import net.anotheria.asg.generator.forms.meta.MetaForm;
import net.anotheria.asg.generator.forms.meta.MetaFormField;
import net.anotheria.asg.generator.forms.meta.MetaFormSingleField;
import net.anotheria.asg.generator.forms.meta.MetaFormTableColumn;
import net.anotheria.asg.generator.forms.meta.MetaFormTableField;
import net.anotheria.asg.generator.forms.meta.MetaFormTableHeader;
import net.anotheria.asg.generator.meta.MetaContainerProperty;
import net.anotheria.asg.generator.meta.MetaDocument;
import net.anotheria.asg.generator.meta.MetaListProperty;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.asg.generator.meta.MetaProperty;
import net.anotheria.asg.generator.meta.MetaTableProperty;
import net.anotheria.asg.generator.view.CMSMappingsConfiguratorGenerator;
import net.anotheria.asg.generator.view.jsp.AbstractJSPGenerator;
import net.anotheria.asg.generator.view.jsp.DialogPageJspGenerator;
import net.anotheria.asg.generator.view.jsp.LinksToMePageJspGenerator;
import net.anotheria.asg.generator.view.jsp.ListPageJspGenerator;
import net.anotheria.asg.generator.view.jsp.ShowPageJspGenerator;
import net.anotheria.asg.generator.view.jsp.TablePageJspGenerator;
import net.anotheria.asg.generator.view.meta.MetaDialog;
import net.anotheria.asg.generator.view.meta.MetaFieldElement;
import net.anotheria.asg.generator.view.meta.MetaModuleSection;
import net.anotheria.asg.generator.view.meta.MetaSection;
import net.anotheria.asg.generator.view.meta.MetaView;
import net.anotheria.asg.generator.view.meta.MetaViewElement;
import net.anotheria.asg.generator.view.meta.MultilingualFieldElement;
import net.anotheria.util.StringUtils;

public class JspGenerator
extends AbstractJSPGenerator
implements IGenerator {
    private MetaSection currentSection;

    @Override
    public List<FileEntry> generate(IGenerateable g) {
        try {
            ArrayList<FileEntry> files = new ArrayList<FileEntry>();
            MetaView view = (MetaView)g;
            files.add(new FileEntry(this.generateMenu(view)));
            files.add(new FileEntry(this.generateFooter(view, "CMS", this.getFooterName(view))));
            files.add(new FileEntry(this.generateSearchPage()));
            FileEntry versionInfoPage = new FileEntry(this.generateVersionInfoPage());
            versionInfoPage.setType(".jsp");
            files.add(versionInfoPage);
            for (int i = 0; i < view.getSections().size(); ++i) {
                MetaSection s = view.getSections().get(i);
                if (!(s instanceof MetaModuleSection)) continue;
                MetaModuleSection section = (MetaModuleSection)s;
                files.add(new FileEntry(new ShowPageJspGenerator().generate(section, view)));
                files.add(new FileEntry(this.generateCSVExport(section, view)));
                files.add(new FileEntry(this.generateXMLExport(section, view)));
                FileEntry linksToThisFile = new FileEntry(new LinksToMePageJspGenerator().generate(section, view));
                linksToThisFile.setType(".jsp");
                files.add(linksToThisFile);
                List<MetaDialog> dialogs = section.getDialogs();
                for (int d = 0; d < dialogs.size(); ++d) {
                    MetaDialog dialog = dialogs.get(d);
                    files.add(new FileEntry(new DialogPageJspGenerator().generate(this.currentSection, dialog, section, view)));
                }
                MetaDocument doc = section.getDocument();
                for (int p = 0; p < doc.getProperties().size(); ++p) {
                    MetaProperty pp = doc.getProperties().get(p);
                    if (!(pp instanceof MetaContainerProperty)) continue;
                    FileEntry entry = new FileEntry(this.generateContainerPage(section, doc, (MetaContainerProperty)pp));
                    files.add(entry);
                }
            }
            return files;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private GeneratedJSPFile generateMenu(MetaView view) {
        GeneratedJSPFile jsp = new GeneratedJSPFile();
        this.startNewJob(jsp);
        jsp.setPackage(GeneratorDataRegistry.getInstance().getContext().getPackageName(MetaModule.SHARED) + ".jsp");
        jsp.setName(this.getMenuName(view));
        this.append(this.getBaseJSPHeader());
        this.appendString("<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">");
        this.increaseIdent();
        this.openTR();
        this.appendString("<ano:iterate name=\"menu\" type=\"net.anotheria.webutils.bean.MenuItemBean\" id=\"entry\">");
        this.appendString("<td>");
        this.increaseIdent();
        this.appendString("<ano:equal name=\"entry\" property=\"active\" value=\"true\">");
        this.appendIncreasedString("<td class=\"menuTitleSelected\"><ano:write name=\"entry\" property=\"caption\"/></td>");
        this.appendString("</ano:equal>");
        this.appendString("<ano:notEqual name=\"entry\" property=\"active\" value=\"true\">");
        this.appendIncreasedString("<td class=\"menuTitle\"><a href=\"<ano:tslink><ano:write name=\"entry\" property=\"link\"/></ano:tslink>\"><ano:write name=\"entry\" property=\"caption\"/></a></td>");
        this.appendString("</ano:notEqual>");
        this.decreaseIdent();
        this.appendString("</td>");
        this.decreaseIdent();
        this.appendString("</ano:iterate>");
        this.closeTR();
        this.decreaseIdent();
        this.appendString("</table>");
        this.append(this.getBaseJSPFooter());
        return jsp;
    }

    private GeneratedJSPFile generateContainerPage(MetaModuleSection section, MetaDocument doc, MetaContainerProperty p) {
        if (p instanceof MetaListProperty) {
            return new ListPageJspGenerator().generate(section, doc, (MetaListProperty)p);
        }
        if (p instanceof MetaTableProperty) {
            return new TablePageJspGenerator().generate(section, doc, (MetaTableProperty)p);
        }
        throw new RuntimeException("Unsupported container: " + p);
    }

    private GeneratedJSPFile generateCSVExport(MetaModuleSection section, MetaView view) {
        GeneratedJSPFile jsp = new GeneratedJSPFile();
        this.startNewJob(jsp);
        jsp.setName(JspGenerator.getExportAsCSVPageName(section.getDocument()));
        jsp.setPackage(this.getContext().getJspPackageName(section.getModule()));
        this.ident = 0;
        this.append(this.getBaseCSVHeader());
        this.currentSection = section;
        MetaDocument doc = section.getDocument();
        String entryName = doc.getName().toLowerCase();
        List<MetaViewElement> elements = JspGenerator.createMultilingualList(section.getElements(), doc);
        Object headerLine = "";
        for (MetaViewElement element : elements) {
            String tag;
            String lang = this.getElementLanguage(element);
            boolean multilangEl = element instanceof MultilingualFieldElement;
            String string = tag = multilangEl && lang != null ? doc.getField(element.getName()).getName(lang) : this.generateTag(element);
            if (tag == null) continue;
            headerLine = (String)headerLine + tag + ";";
        }
        this.appendString(new String[]{headerLine});
        this.appendString("<ano:iterate name=" + this.quote(doc.getMultiple().toLowerCase() + "CSV") + " type=" + this.quote(GeneratorDataRegistry.getInstance().getContext().getDataPackageName(doc) + "." + doc.getName()) + " id=" + this.quote(entryName) + "><%--");
        Object bodyLine = "--%>";
        for (MetaViewElement element : elements) {
            String tag;
            String lang = this.getElementLanguage(element);
            boolean multilangEl = element instanceof MultilingualFieldElement;
            String string = tag = multilangEl && lang != null ? doc.getField(element.getName()).getName(lang) : this.generateTag(element);
            if (tag == null) continue;
            bodyLine = (String)bodyLine + "<ano:write filter=\"false\" name=" + this.quote(entryName) + " property=\"" + tag + "\"/>;";
        }
        this.appendString(new String[]{bodyLine});
        this.appendString("</ano:iterate>");
        return jsp;
    }

    private String generateTag(MetaViewElement elem) {
        if (!(elem instanceof MetaFieldElement)) {
            return null;
        }
        return ((MetaFieldElement)elem).getName();
    }

    private GeneratedJSPFile generateXMLExport(MetaModuleSection section, MetaView view) {
        GeneratedJSPFile jsp = new GeneratedJSPFile();
        this.startNewJob(jsp);
        jsp.setName(JspGenerator.getExportAsXMLPageName(section.getDocument()));
        jsp.setPackage(this.getContext().getJspPackageName(section.getModule()));
        this.ident = 0;
        this.append(this.getBaseXMLHeader());
        this.currentSection = section;
        MetaDocument doc = section.getDocument();
        this.appendString("<?xml version=\"1.0\" encoding=" + this.quote(this.getContext().getEncoding()) + "?>");
        this.appendString("<ano-xml:xml_write name=" + this.quote(doc.getMultiple().toLowerCase() + "XML") + "/>");
        return jsp;
    }

    private GeneratedJSPFile generateSearchPage() {
        GeneratedJSPFile jsp = new GeneratedJSPFile();
        this.startNewJob(jsp);
        jsp.setName(JspGenerator.getSearchResultPageName());
        jsp.setPackage(GeneratorDataRegistry.getInstance().getContext().getPackageName(MetaModule.SHARED) + ".jsp");
        this.ident = 0;
        this.append(this.getBaseJSPHeader());
        this.appendString("<!--  generated by JspMafViewGenerator.generateSearchPage -->");
        this.appendString("<html xmlns=\"http://www.w3.org/1999/xhtml\">");
        this.increaseIdent();
        this.appendString("<head>");
        this.increaseIdent();
        this.appendString("<title>Search result</title>");
        this.generatePragmas();
        this.appendString("<link href=\"" + this.getCurrentCSSPath("newadmin.css") + "\" rel=\"stylesheet\" type=\"text/css\">");
        this.appendString("<script type=\"text/javascript\" src=\"" + this.getCurrentJSPath("jquery-1.4.min.js") + "\"></script>");
        this.appendString("<script type=\"text/javascript\" src=\"" + this.getCurrentJSPath("anofunctions.js") + "\"></script>");
        this.decreaseIdent();
        this.appendString("</head>");
        this.appendString("<body>");
        this.appendString("<jsp:include page=\"" + this.getTopMenuPage() + "\" flush=\"true\"/>");
        this.appendString("<div class=\"right\">");
        this.increaseIdent();
        this.appendString("<div class=\"r_w\">");
        this.increaseIdent();
        this.appendString("<div class=\"top_nav\">");
        this.increaseIdent();
        this.appendString("<div class=\"r_b_l\"><!-- --></div>");
        this.appendString("<div class=\"r_b_r\"><!-- --></div>");
        this.appendString("<div class=\"left_p\">");
        this.increaseIdent();
        this.appendString("<div class=\"clear\"><!-- --></div>");
        this.decreaseIdent();
        this.appendString("</div>");
        this.decreaseIdent();
        this.appendString("</div>");
        this.appendString("<div class=\"main_area\">");
        this.appendString("<div class=\"c_l\"><!-- --></div>");
        this.appendString("<div class=\"c_r\"><!-- --></div>");
        this.appendString("<div class=\"c_b_l\"><!-- --></div>");
        this.appendString("<div class=\"c_b_r\"><!-- --></div>");
        this.appendString("<h2>Search result: <ano:write name=\"criteria\"/></h2>");
        this.appendString("<div class=\"clear\"><!-- --></div>");
        this.appendString("<div class=\"clear\"><!-- --></div>");
        this.appendString("<table cellspacing=\"1\" cellpadding=\"1\" border=\"0\" width=\"100%\" class=\"pages_table\">");
        this.appendString("<thead>");
        this.increaseIdent();
        this.appendString("<tr class=\"linecaptions\">");
        this.increaseIdent();
        this.appendString("<td style=\"width: 50px;\">Id</td>");
        this.appendString("<td style=\"width: 200px;\">Document</td>");
        this.appendString("<td style=\"width: 200px;\">Property</td>");
        this.appendString("<td>Match</td>");
        this.decreaseIdent();
        this.appendString("</tr>");
        this.appendString("</thead>");
        this.appendString("<ano:present name=" + this.quote("result") + " >");
        this.appendString("<tbody>");
        this.appendString("<ano:iterate name=" + this.quote("result") + " type=" + this.quote("net.anotheria.anodoc.query2.ResultEntryBean") + " id=" + this.quote("entry") + " indexId=\"ind\">");
        this.increaseIdent();
        this.appendString("<tr class=\"<%=ind.intValue()%2==0 ? \"lineLight\" : \"lineDark\"%>\">");
        this.appendString("<td style=\"width: 50px;\"><a href=" + this.quote("<ano:write name=" + this.quote("entry") + " property=" + this.quote("editLink") + "/>") + " target=" + this.quote("_blank") + "><ano:write name=" + this.quote("entry") + " property=" + this.quote("documentId") + "/></td>");
        this.appendString("<td style=\"width: 200px;\"><ano:write name=" + this.quote("entry") + " property=" + this.quote("documentName") + "/></td>");
        this.appendString("<td style=\"width: 200px;\"><ano:write name=" + this.quote("entry") + " property=" + this.quote("propertyName") + "/></td>");
        this.appendString("<td><ano:write name=" + this.quote("entry") + " property=" + this.quote("info") + " filter=" + this.quote("false") + "/></td>");
        this.appendString("</tr>");
        this.decreaseIdent();
        this.appendString("</ano:iterate>");
        this.appendString("</tbody>");
        this.appendString("</ano:present>");
        this.decreaseIdent();
        this.appendString("</table>");
        this.appendString("<div class=\"clear\"><!-- --></div>");
        this.decreaseIdent();
        this.appendString("</div>");
        this.appendString("</div>");
        this.appendString("</div>");
        this.appendString("</body>");
        this.decreaseIdent();
        this.appendString("</html>");
        this.appendString("<!-- / generated by JspMafViewGenerator.generateSearchPage -->");
        this.append(this.getBaseJSPFooter());
        return jsp;
    }

    private GeneratedJSPFile generateVersionInfoPage() {
        GeneratedJSPFile jsp = new GeneratedJSPFile();
        this.startNewJob(jsp);
        jsp.setName(JspGenerator.getVersionInfoPageName());
        jsp.setPackage(GeneratorDataRegistry.getInstance().getContext().getPackageName(MetaModule.SHARED) + ".jsp");
        this.ident = 0;
        this.append(this.getBaseJSPHeader());
        this.appendString("<!--  generated by JspMafViewGenerator.generateVersionInfoPage -->");
        this.appendString("<html xmlns=\"http://www.w3.org/1999/xhtml\">");
        this.increaseIdent();
        this.appendString("<head>");
        this.increaseIdent();
        this.appendString("<title>VersionInfo for <ano:write name=\"documentName\"/></title>");
        this.generatePragmas();
        this.appendString("<link href=\"" + this.getCurrentCSSPath("newadmin.css") + "\" rel=\"stylesheet\" type=\"text/css\">");
        this.decreaseIdent();
        this.appendString("</head>");
        this.appendString("<body>");
        this.increaseIdent();
        int colspan = 2;
        this.appendString("<table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"1\">");
        this.increaseIdent();
        this.appendString("<tr>");
        this.increaseIdent();
        this.appendString("<td colspan=\"" + colspan + "\"><img src=" + this.quote(this.getCurrentImagePath("s.gif")) + " width=\"1\" height=\"1\"></td>");
        this.decreaseIdent();
        this.appendString("</tr>");
        this.appendString("<tr class=\"lineCaptions\">");
        this.increaseIdent();
        this.appendString("<td colspan=\"2\">VersionInfo for document</td>");
        this.decreaseIdent();
        this.appendString("</tr>");
        this.appendString("<tr class=\"lineLight\">");
        this.appendIncreasedString("<td width=\"20%\">Document name: </td>");
        this.appendIncreasedString("<td width=\"80%\"><ano:write name=" + this.quote("documentName") + "/></td>");
        this.appendString("</tr>");
        this.appendString("<tr class=\"lineDark\">");
        this.appendIncreasedString("<td width=\"20%\">Document type: </td>");
        this.appendIncreasedString("<td width=\"80%\"><ano:write name=" + this.quote("documentType") + "/></td>");
        this.appendString("</tr>");
        this.appendString("<tr class=\"lineLight\">");
        this.appendIncreasedString("<td width=\"20%\">Last update: </td>");
        this.appendIncreasedString("<td width=\"80%\"><ano:write name=" + this.quote("lastUpdate") + "/></td>");
        this.appendString("</tr>");
        this.appendString("<tr class=\"lineDark\">");
        this.increaseIdent();
        this.appendString("<td colspan=\"2\">&nbsp;</td>");
        this.decreaseIdent();
        this.appendString("</tr>");
        this.appendString("<tr class=\"lineLight\">");
        this.appendIncreasedString("<td width=\"20%\">&nbsp;</td>");
        this.appendIncreasedString("<td width=\"80%\"><a href=\"javascript:history.back();\">Back</a></td>");
        this.appendString("</tr>");
        this.decreaseIdent();
        this.appendString("</table>");
        this.decreaseIdent();
        this.appendString("</body>");
        this.decreaseIdent();
        this.appendString("</html>");
        this.appendString("<!-- / generated by JspMafViewGenerator.generateVersionInfoPage -->");
        this.append(this.getBaseJSPFooter());
        return jsp;
    }

    public String getFormIncludePageName(MetaForm form) {
        return StringUtils.capitalize((String)form.getId()) + "AutoForm";
    }

    private String generateFormField(MetaFormSingleField field, String className) {
        return this.generateFormField(field.getName(), field, className);
    }

    private String generateFormField(String name, MetaFormSingleField field, String className) {
        if (field.getType().equals("boolean")) {
            return "<input type=" + this.quote("checkbox") + " name=" + this.quote(name) + " class=" + this.quote(className) + "/>";
        }
        if (field.getType().equals("text")) {
            return "<textarea id=" + this.quote(name) + "  name=" + this.quote(name) + " class=" + this.quote(className) + " rows=" + this.quote(3) + " cols=" + this.quote(this.quote(field.getSize())) + "></textarea>";
        }
        if (field.getType().equals("string")) {
            return "<input type=\"text\" size=" + this.quote(field.getSize()) + " name=" + this.quote(name) + " class=" + this.quote(className) + "/>";
        }
        if (field.getType().equals("password")) {
            return "<input type=\"password\" size=" + this.quote(field.getSize()) + " name=" + this.quote(name) + " class=" + this.quote(className) + "/>";
        }
        if (field.getType().equals("spacer")) {
            return "";
        }
        throw new RuntimeException("Unsupported field type: " + field.getType());
    }

    public String generateFormInclude(MetaForm form) {
        System.out.println("generating form " + form);
        Object ret = "";
        this.resetIdent();
        String formName = CMSMappingsConfiguratorGenerator.getFormName(form);
        ret = (String)ret + this.getBaseJSPHeader();
        this.appendString("<!-- form: " + formName + " -->");
        this.appendString("<table width=" + this.quote("100%") + " cellspacing=" + this.quote("1") + " cellpadding=" + this.quote("1") + " border=" + this.quote("0") + ">");
        this.increaseIdent();
        this.appendString("<form action=" + this.quote(CMSMappingsConfiguratorGenerator.getFormPath(form)) + ">");
        List<MetaFormField> elements = form.getElements();
        for (int i = 0; i < elements.size(); ++i) {
            MetaFormField element = elements.get(i);
            if (element.isSingle()) {
                MetaFormSingleField field = (MetaFormSingleField)element;
                this.appendString("<tr class=" + this.quote("qs_info") + ">");
                this.increaseIdent();
                this.appendString("<td width=10%><img src=" + this.quote("<ano:message key=" + this.quote("emptyimage") + "/>") + " width=" + this.quote(10) + " height=" + this.quote(1) + "/></td>");
                this.appendString("<td class=" + this.quote("qs_info") + " align=" + this.quote("left") + ">");
                String htmlFieldDeclaration = this.generateFormField(field, field.getType().equals("boolean") ? "qs_input" : "qs_info");
                if (field.getType().equals("boolean")) {
                    this.appendString(htmlFieldDeclaration);
                    this.appendString("&nbsp;<ano:message key=" + this.quote(field.getTitle()) + "/>");
                } else {
                    this.appendString("<ano:message key=" + this.quote(field.getTitle()) + "/>" + (!field.isSpacer() ? ":&nbsp;<br><br>" : ""));
                    if (htmlFieldDeclaration.length() > 0) {
                        this.appendString(htmlFieldDeclaration);
                    }
                }
                if (!field.isSpacer()) {
                    this.appendString("<br><br>");
                }
                this.appendString("</td>");
                this.appendString("<td width=10%><img src=" + this.quote("<ano:message key=" + this.quote("emptyimage") + "/>") + " width=" + this.quote(10) + " height=" + this.quote(1) + "/></td>");
                this.decreaseIdent();
                this.appendString("</tr>");
            }
            if (!element.isComplex()) continue;
            MetaFormTableField table = (MetaFormTableField)element;
            this.appendString("<tr class=" + this.quote("qs_info") + ">");
            this.increaseIdent();
            this.appendString("<td width=10%><img src=" + this.quote("<ano:message key=" + this.quote("emptyimage") + "/>") + " width=" + this.quote(10) + " height=" + this.quote(1) + "/></td>");
            this.appendString("<td class=" + this.quote("qs_info") + " >");
            this.increaseIdent();
            this.appendString("<table width=" + this.quote("100%") + " cellpadding=" + this.quote(0) + " cellspacing=" + this.quote(0) + " border=" + this.quote(0) + ">");
            this.increaseIdent();
            this.appendString("<tr>");
            List<MetaFormTableColumn> columns = table.getColumns();
            for (MetaFormTableColumn col : columns) {
                MetaFormTableHeader header = col.getHeader();
                this.appendIncreasedString("<td><strong><ano:message key=" + this.quote(header.getKey()) + "/></strong></td>");
            }
            this.appendString("</tr>");
            for (int r = 0; r < table.getRows(); ++r) {
                this.appendString("<tr>");
                this.increaseIdent();
                for (int c = 0; c < columns.size(); ++c) {
                    MetaFormTableColumn col = columns.get(c);
                    this.appendString("<td width=" + this.quote(col.getHeader().getWidth()) + ">");
                    this.appendIncreasedString(this.generateFormField(table.getVariableName(r, c), col.getField(), ""));
                    this.appendString("</td>");
                }
                this.decreaseIdent();
                this.appendString("</tr>");
            }
            this.decreaseIdent();
            this.appendString("</table>");
            this.decreaseIdent();
            this.appendString("</td>");
            this.appendString("<td width=10%><img src=" + this.quote("<ano:message key=" + this.quote("emptyimage") + "/>") + " width=" + this.quote(10) + " height=" + this.quote(1) + "/></td>");
            this.appendString("</tr>");
        }
        this.decreaseIdent();
        this.appendString("</form>");
        this.decreaseIdent();
        this.appendString("</table>");
        ret = (String)ret + this.getBaseJSPFooter();
        return ret;
    }
}

