/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.view.jsp;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.asg.generator.FileEntry;
import net.anotheria.asg.generator.GeneratedJSPFile;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.IGenerateable;
import net.anotheria.asg.generator.IGenerator;
import net.anotheria.asg.generator.meta.MetaDocument;
import net.anotheria.asg.generator.meta.MetaLink;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.asg.generator.meta.MetaProperty;
import net.anotheria.asg.generator.view.CMSMappingsConfiguratorGenerator;
import net.anotheria.asg.generator.view.jsp.AbstractJSPGenerator;
import net.anotheria.asg.generator.view.meta.MetaModuleSection;
import net.anotheria.asg.generator.view.meta.MetaSection;
import net.anotheria.asg.generator.view.meta.MetaView;
import net.anotheria.util.StringUtils;

public class QueriesPageJspGenerator
extends AbstractJSPGenerator
implements IGenerator {
    @Override
    public List<FileEntry> generate(IGenerateable g) {
        ArrayList<FileEntry> files = new ArrayList<FileEntry>();
        MetaView view = (MetaView)g;
        FileEntry menu = new FileEntry(this.generateMenu(view));
        menu.setType(".jsp");
        files.add(menu);
        FileEntry footer = new FileEntry(this.generateFooter(view, "Queries", this.getFooterName(view)));
        footer.setType(".jsp");
        files.add(footer);
        for (int i = 0; i < view.getSections().size(); ++i) {
            MetaModuleSection section;
            MetaDocument doc;
            MetaSection s = view.getSections().get(i);
            if (!(s instanceof MetaModuleSection) || (doc = (section = (MetaModuleSection)s).getDocument()).getLinks().size() <= 0) continue;
            FileEntry showQueryFile = new FileEntry(this.generateShowQueriesPage(section, view));
            showQueryFile.setType(".jsp");
            files.add(showQueryFile);
        }
        return files;
    }

    private GeneratedJSPFile generateShowQueriesPage(MetaModuleSection section, MetaView view) {
        this.ident = 0;
        GeneratedJSPFile jsp = new GeneratedJSPFile();
        jsp.setPackage(this.getContext().getPackageName(section.getDocument()) + ".jsp");
        this.startNewJob(jsp);
        jsp.setName(QueriesPageJspGenerator.getShowQueriesPageName(section.getDocument()));
        this.append(this.getBaseJSPHeader());
        MetaDocument doc = section.getDocument();
        this.appendString("<!--  generated by JspMafQueriesGenerator.generateShowQueriesPage -->");
        this.appendString("<html xmlns=\"http://www.w3.org/1999/xhtml\">");
        this.increaseIdent();
        this.appendString("<head>");
        this.increaseIdent();
        this.appendString("<title>" + view.getTitle() + "</title>");
        this.generatePragmas(view);
        this.appendString("<link href=\"" + this.getCurrentCSSPath("newadmin.css") + "\" rel=\"stylesheet\" type=\"text/css\">");
        this.decreaseIdent();
        this.appendString("</head>");
        this.appendString("<body>");
        this.increaseIdent();
        int colspan = 1;
        this.appendString("<table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"1\">");
        this.increaseIdent();
        this.openTR();
        this.appendString("<td colspan=\"" + colspan + "\"><img src=" + this.quote(this.getCurrentImagePath("s.gif")) + " width=\"1\" height=\"1\"></td>");
        this.closeTR();
        this.openTR();
        this.appendString("<td>&nbsp;</td>");
        this.closeTR();
        this.openTR("class=" + this.quote("lineCaptions"));
        this.appendString("<td>&nbsp;Available queries:</td>");
        this.closeTR();
        List<MetaProperty> links = doc.getLinks();
        for (int i = 0; i < links.size(); ++i) {
            MetaLink link = (MetaLink)links.get(i);
            if (link.isRelative()) continue;
            MetaModule mod = GeneratorDataRegistry.getInstance().getModule(link.getTargetModuleName());
            MetaDocument targetDocument = mod.getDocumentByName(link.getTargetDocumentName());
            this.openTR("class=" + this.quote(i % 2 == 0 ? "lineLight" : "lineDark"));
            this.appendString("<form name=" + this.quote(targetDocument.getName()) + " action=" + this.quote(CMSMappingsConfiguratorGenerator.getExecuteQueryPath(doc)) + " method=" + this.quote("GET") + "><input type=" + this.quote("hidden") + " name=" + this.quote("property") + " value=" + this.quote(link.getName()));
            this.openTD();
            this.increaseIdent();
            this.appendString("&nbsp;Show all " + section.getTitle() + " where " + link.getName() + " is:&nbsp;");
            this.openTag("select", "name=" + this.quote("criteria"));
            this.increaseIdent();
            this.appendString("<option value=\"\">none</option>");
            this.appendString("<ano:iterate name=" + this.quote(targetDocument.getMultiple().toLowerCase()) + " type=" + this.quote("net.anotheria.webutils.bean.LabelValueBean") + " id=" + this.quote("entry") + ">");
            this.appendIncreasedString("<option value=" + this.quote("<ano:write name=" + this.quote("entry") + " property=" + this.quote("value") + "/>") + "><ano:write name=" + this.quote("entry") + " property=" + this.quote("label") + " filter=" + this.quote("false") + "/></option>");
            this.appendString("</ano:iterate>");
            this.decreaseIdent();
            this.appendString("</select>&nbsp;<a href=" + this.quote("#") + " onClick=" + this.quote("document.forms." + targetDocument.getName() + ".submit(); return false") + ">GO</a>");
            this.decreaseIdent();
            this.closeTD();
            this.appendString("</form>");
            this.closeTR();
        }
        this.decreaseIdent();
        this.appendString("</table>");
        this.decreaseIdent();
        this.appendString("<jsp:include page=\"" + this.getFooterName(view) + ".jsp\" flush=\"true\"/>");
        this.appendString("</body>");
        this.decreaseIdent();
        this.appendString("</html>");
        this.appendString("<!-- / generated by JspMafQueriesGenerator.generateShowQueriesPage -->");
        this.append(this.getBaseJSPFooter());
        return jsp;
    }

    @Override
    protected String getMenuName(MetaView view) {
        return "../../shared/jsp/" + StringUtils.capitalize((String)view.getName()) + "QueriesMenu";
    }

    private GeneratedJSPFile generateMenu(MetaView view) {
        GeneratedJSPFile jsp = new GeneratedJSPFile();
        jsp.setPackage(this.getContext().getJspPackageName(MetaModule.SHARED));
        jsp.setName(this.getMenuName(view));
        this.append(this.getBaseJSPHeader());
        this.appendString("<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">");
        this.increaseIdent();
        this.appendString("<tr>");
        this.increaseIdent();
        this.appendString("<ano:iterate name=\"queriesMenu\" type=\"net.anotheria.webutils.bean.MenuItemBean\" id=\"entry\">");
        this.increaseIdent();
        this.appendString("<td>");
        this.increaseIdent();
        this.appendString("<ano:equal name=\"entry\" property=\"active\" value=\"true\">");
        this.appendIncreasedString("<td class=\"menuTitleSelected\"><ano:write name=\"entry\" property=\"caption\"/></td>");
        this.appendString("</ano:equal>");
        this.appendString("<ano:notEqual name=\"entry\" property=\"active\" value=\"true\">");
        this.appendIncreasedString("<td class=\"menuTitle\"><a href=\"<ano:tslink><ano:write name=\"entry\" property=\"link\"/></ano:tslink>\"><ano:write name=\"entry\" property=\"caption\"/></a></td>");
        this.appendString("</ano:notEqual>");
        this.decreaseIdent();
        this.appendString("</td>");
        this.decreaseIdent();
        this.appendString("</ano:iterate>");
        this.decreaseIdent();
        this.appendString("</tr>");
        this.decreaseIdent();
        this.appendString("</table>");
        this.append(this.getBaseJSPFooter());
        return jsp;
    }

    @Override
    protected String getFooterName(MetaView view) {
        return "../../shared/jsp/" + StringUtils.capitalize((String)view.getName()) + "QueryFooter";
    }
}

