/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.view.meta;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.asg.generator.meta.MetaDocument;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.asg.generator.view.meta.MetaDialog;
import net.anotheria.asg.generator.view.meta.MetaFilter;
import net.anotheria.asg.generator.view.meta.MetaSection;
import net.anotheria.asg.generator.view.meta.MetaViewElement;

public class MetaModuleSection
extends MetaSection {
    private MetaModule module;
    private MetaDocument document;
    private List<MetaViewElement> elements = new ArrayList<MetaViewElement>();
    private List<MetaDialog> dialogs = new ArrayList<MetaDialog>();
    private MetaViewElement defaultSortable = null;
    private List<MetaFilter> filters = new ArrayList<MetaFilter>();

    public MetaModuleSection(String title) {
        super(title);
    }

    public void addDialog(MetaDialog d) {
        this.dialogs.add(d);
    }

    public MetaModule getModule() {
        return this.module;
    }

    public void setModule(MetaModule module) {
        this.module = module;
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.module + " elements: " + this.elements + " D: " + this.dialogs;
    }

    public MetaDocument getDocument() {
        return this.document;
    }

    public void setDocument(MetaDocument document) {
        this.document = document;
    }

    public List<MetaViewElement> getElements() {
        return this.elements;
    }

    public void setElements(List<MetaViewElement> list) {
        this.elements = list;
    }

    public void addElement(MetaViewElement element) {
        this.elements.add(element);
    }

    public List<MetaDialog> getDialogs() {
        return this.dialogs;
    }

    public void setDialogs(List<MetaDialog> list) {
        this.dialogs = list;
    }

    public MetaViewElement getDefaultSortable() {
        return this.defaultSortable;
    }

    public void setDefaultSortable(MetaViewElement element) {
        this.defaultSortable = element;
    }

    public boolean containsComparable() {
        for (MetaViewElement element : this.elements) {
            if (!element.isComparable()) continue;
            return true;
        }
        return false;
    }

    public void addMetaFilter(MetaFilter aFilter) {
        this.filters.add(aFilter);
    }

    public List<MetaFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<MetaFilter> filters) {
        this.filters = filters;
    }

    public boolean isValidatedOnSave() {
        List<MetaViewElement> dialogElements;
        if (this.dialogs != null && this.dialogs.size() > 0 && (dialogElements = this.dialogs.get(0).getElements()) != null) {
            for (MetaViewElement element : dialogElements) {
                if (!element.isValidated()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }
}

