/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.view.meta;

import java.util.List;
import net.anotheria.asg.generator.view.meta.MetaDecorator;
import net.anotheria.asg.generator.view.meta.MetaValidator;
import net.anotheria.asg.generator.view.meta.SortingType;
import net.anotheria.util.StringUtils;

public class MetaViewElement {
    private boolean readonly;
    private boolean autocompleteOff;
    private String name;
    private String caption;
    private String description;
    private boolean comparable;
    private boolean rich;
    private boolean datetime;
    private boolean showLink;
    private MetaDecorator decorator;
    private List<MetaValidator> validators;
    private SortingType sortingType = SortingType.ALPHABETHICAL;

    public MetaViewElement(String aName) {
        this.name = aName;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean b) {
        this.readonly = b;
    }

    public boolean isAutocompleteOff() {
        return this.autocompleteOff;
    }

    public void setAutocompleteOff(boolean b) {
        this.autocompleteOff = b;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isComparable() {
        return this.comparable;
    }

    public void setComparable(boolean b) {
        this.comparable = b;
    }

    public MetaDecorator getDecorator() {
        return this.decorator;
    }

    public void setDecorator(MetaDecorator decorator) {
        this.decorator = decorator;
        if (decorator != null && this.name != null && this.name.equals("id")) {
            this.sortingType = SortingType.NUMERICAL;
        }
    }

    public boolean equals(Object o) {
        return o instanceof MetaViewElement && ((MetaViewElement)o).getName().equals(this.getName());
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    public boolean isRich() {
        return this.rich;
    }

    public void setRich(boolean rich) {
        this.rich = rich;
    }

    public boolean isDatetime() {
        return this.datetime;
    }

    public void setDatetime(boolean datetime) {
        this.datetime = datetime;
    }

    public boolean isShowLink() {
        return this.showLink;
    }

    public void setShowLink(boolean showLink) {
        this.showLink = showLink;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setValidators(List<MetaValidator> validator) {
        this.validators = validator;
    }

    public List<MetaValidator> getValidators() {
        return this.validators;
    }

    public boolean isValidated() {
        return this.validators != null && !this.validators.isEmpty();
    }

    public boolean isJSValidated() {
        if (this.isValidated()) {
            for (MetaValidator validator : this.validators) {
                if (StringUtils.isEmpty((String)validator.getJsValidation())) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "MetaViewElement{readonly=" + this.readonly + ", autocompleteOff=" + this.autocompleteOff + ", name='" + this.name + "', caption='" + this.caption + "', description='" + this.description + "', comparable=" + this.comparable + ", rich=" + this.rich + ", datetime=" + this.datetime + ", decorator=" + this.decorator + ", validators=" + this.validators + ", showLink=" + this.showLink + "}";
    }

    public SortingType getSortingType() {
        return this.sortingType;
    }

    public void setSortingType(SortingType sortingType) {
        this.sortingType = sortingType;
    }
}

