/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.service;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.anotheria.asg.data.DataObject;
import net.anotheria.asg.service.ASGService;
import net.anotheria.asg.util.listener.IServiceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractASGService
implements ASGService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractASGService.class);
    private List<IServiceListener> listeners = new CopyOnWriteArrayList<IServiceListener>();

    protected void fireObjectCreatedEvent(DataObject created) {
        for (IServiceListener listener : this.listeners) {
            try {
                listener.documentCreated(created);
            }
            catch (Exception e) {
                LOGGER.warn("Caught uncaught exception by the listener " + listener + ", fireObjectCreatedEvent(" + created + ")", (Throwable)e);
            }
        }
    }

    protected void fireObjectUpdatedEvent(DataObject oldVersion, DataObject newVersion) {
        for (IServiceListener listener : this.listeners) {
            try {
                listener.documentUpdated(oldVersion, newVersion);
            }
            catch (Exception e) {
                LOGGER.warn("Caught uncaught exception by the listener " + listener + ", fireObjectUpdatedEvent(" + oldVersion + ", " + newVersion + ")", (Throwable)e);
            }
        }
    }

    protected void fireObjectDeletedEvent(DataObject deleted) {
        for (IServiceListener listener : this.listeners) {
            try {
                listener.documentDeleted(deleted);
            }
            catch (Exception e) {
                LOGGER.warn("Caught uncaught exception by the listener " + listener + ", fireObjectDeletedEvent(" + deleted + ")", (Throwable)e);
            }
        }
    }

    protected void fireObjectImportedEvent(DataObject imported) {
        for (IServiceListener listener : this.listeners) {
            try {
                listener.documentImported(imported);
            }
            catch (Exception e) {
                LOGGER.warn("Caught uncaught exception by the listener " + listener + ", fireObjectImportedEvent(" + imported + ")", (Throwable)e);
            }
        }
    }

    protected void firePersistenceChangedEvent() {
        for (IServiceListener listener : this.listeners) {
            try {
                listener.persistenceChanged();
            }
            catch (Exception e) {
                LOGGER.warn("Caught uncaught exception by the listener " + listener + ", firePersistenceChangedEvent()", (Throwable)e);
            }
        }
    }

    @Override
    public void addServiceListener(IServiceListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeServiceListener(IServiceListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean hasServiceListeners() {
        return this.listeners.size() > 0;
    }
}

