/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.service;

import net.anotheria.asg.data.DataObject;

public class InMemoryObjectWrapper<T extends DataObject> {
    private T t;
    private boolean created;
    private boolean updated;
    private boolean deleted;
    private long createdTimestamp;
    private long updatedTimestamp;
    private long deletedTimestamp;

    public InMemoryObjectWrapper(T aT) {
        this(aT, false);
    }

    public InMemoryObjectWrapper(T aT, boolean created) {
        this.t = aT;
        this.created = created;
        this.createdTimestamp = System.currentTimeMillis();
    }

    public String getId() {
        return this.t.getId();
    }

    public T get() {
        return this.t;
    }

    public void update(T aT) {
        this.t = aT;
        this.updated = true;
        this.updatedTimestamp = System.currentTimeMillis();
    }

    public void delete() {
        this.t = null;
        this.deleted = true;
        this.deletedTimestamp = System.currentTimeMillis();
    }

    public String toString() {
        return "" + this.t;
    }

    public boolean isCreated() {
        return this.created;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public long getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    public long getUpdatedTimestamp() {
        return this.updatedTimestamp;
    }

    public long getDeletedTimestamp() {
        return this.deletedTimestamp;
    }
}

