/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.service.remote;

import java.rmi.RemoteException;
import net.anotheria.asg.exception.ASGRuntimeException;
import net.anotheria.asg.service.remote.EchoRequest;
import net.anotheria.asg.service.remote.EchoResponse;
import net.anotheria.asg.service.remote.RemoteService;

public abstract class BaseRemoteServiceStub<T extends RemoteService> {
    protected abstract void notifyDelegateFailed();

    protected abstract T getDelegate() throws ASGRuntimeException;

    public long ping() throws RemoteException {
        return this.ping(0);
    }

    public long ping(int packetSize) throws RemoteException {
        try {
            EchoRequest req = new EchoRequest();
            req.setEchoDataSize(packetSize);
            req.setRequestTime(System.currentTimeMillis());
            EchoResponse res = this.getDelegate().getEcho(req);
            long duration = System.currentTimeMillis() - res.getResponseTime();
            return duration;
        }
        catch (RemoteException e) {
            this.notifyDelegateFailed();
            throw e;
        }
        catch (ASGRuntimeException e) {
            throw new RemoteException("Server is unreachable: ", e);
        }
    }
}

