/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.util.action;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;
import net.anotheria.anoplass.api.util.paging.PagingControl;
import net.anotheria.util.slicer.Segment;
import net.anotheria.util.slicer.Slice;
import net.anotheria.util.slicer.Slicer;

public class ActionUtils {
    private static final List<String> ITEMS_ON_PAGE_SELECTOR = Arrays.asList("5", "10", "20", "25", "50", "100", "500", "1000", "2000");

    public static final <T> List<T> sliceDataAndSavePagingInformation(HttpServletRequest req, List<T> incomingData) {
        int pageNumber = 1;
        try {
            pageNumber = Integer.parseInt(req.getParameter("pageNumber"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Integer lastItemsOnPage = (Integer)req.getSession().getAttribute("currentItemsOnPage");
        int itemsOnPage = lastItemsOnPage == null ? 20 : lastItemsOnPage;
        try {
            itemsOnPage = Integer.parseInt(req.getParameter("itemsOnPage"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Slice slice = Slicer.slice((Segment)new Segment(pageNumber, itemsOnPage), incomingData);
        PagingControl pagingControl = new PagingControl(slice.getCurrentSlice(), slice.getElementsPerSlice(), slice.getTotalNumberOfItems());
        req.setAttribute("pagingControl", (Object)pagingControl);
        req.setAttribute("currentpage", (Object)pageNumber);
        req.setAttribute("currentItemsOnPage", (Object)itemsOnPage);
        req.getSession().setAttribute("currentItemsOnPage", (Object)itemsOnPage);
        req.setAttribute("PagingSelector", ITEMS_ON_PAGE_SELECTOR);
        return slice.getSliceData();
    }
}

