/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.util.bean;

import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateUtility {
    private static Logger log = LoggerFactory.getLogger(PopulateUtility.class);

    public static void populate(Object bean, HttpServletRequest from) {
        Field[] fields;
        Class<?> c = bean.getClass();
        for (Field f : fields = c.getDeclaredFields()) {
            log.debug("populating field " + f);
            String value = from.getParameter(f.getName());
            log.debug("  with value " + value);
            if (value == null) continue;
            try {
                f.setAccessible(true);
                if (f.getType().equals(List.class)) {
                    log.debug("list " + f.getName() + ", skipped");
                    continue;
                }
                if (f.getType().equals(String.class)) {
                    f.set(bean, value);
                    continue;
                }
                if (f.getType().equals(Boolean.TYPE)) {
                    if (value != null && value.equals("on")) {
                        f.setBoolean(bean, true);
                        continue;
                    }
                    f.setBoolean(bean, Boolean.parseBoolean(value));
                    continue;
                }
                if (f.getType().equals(Integer.TYPE)) {
                    f.setInt(bean, Integer.parseInt(value));
                    continue;
                }
                if (f.getType().equals(Float.TYPE)) {
                    f.setFloat(bean, Float.parseFloat(value));
                    continue;
                }
                if (f.getType().equals(Double.TYPE)) {
                    f.setDouble(bean, Double.parseDouble(value));
                    continue;
                }
                if (f.getType().equals(Long.TYPE)) {
                    f.setLong(bean, Long.parseLong(value));
                    continue;
                }
                if (f.getType().equals(Date.class)) {
                    f.set(bean, value);
                    continue;
                }
                throw new RuntimeException("Unsupported type " + f.getType());
            }
            catch (Exception e) {
                log.error("Can't populate " + bean + " with " + from, (Throwable)e);
            }
        }
    }
}

