/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.util.data;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.anotheria.asg.data.DataObject;
import net.anotheria.util.ArrayUtils;

public class DataObjectUtils {
    private DataObjectUtils() {
    }

    public static <T extends DataObject> List<String> getIds(List<T> dataObjects) {
        ArrayList<String> ret = new ArrayList<String>(dataObjects.size());
        for (DataObject d : dataObjects) {
            ret.add(d.getId());
        }
        return ret;
    }

    public static <T extends DataObject, P> List<P> getProperties(String propertyName, Class<P> propertyClass, List<T> dataObjects) {
        ArrayList<P> ret = new ArrayList<P>(dataObjects.size());
        for (DataObject d : dataObjects) {
            ret.add(propertyClass.cast(d.getPropertyValue(propertyName)));
        }
        return ret;
    }

    public static <T extends DataObject> Map<String, T> createMapById(List<T> dataObjects) {
        HashMap<String, DataObject> ret = new HashMap<String, DataObject>();
        for (DataObject d : dataObjects) {
            ret.put(d.getId(), d);
        }
        return ret;
    }

    public static <T extends DataObject, P> Map<P, T> createMapByKeyProperty(String propertyName, Class<P> propertyClass, List<T> dataObjects) {
        HashMap<P, DataObject> ret = new HashMap<P, DataObject>();
        for (DataObject d : dataObjects) {
            ret.put(propertyClass.cast(d.getPropertyValue(propertyName)), d);
        }
        return ret;
    }

    public static <T extends DataObject, P> Map<P, T[]> createMapByProperty(String propertyName, Class<P> propertyClass, List<T> dataObjects) {
        HashMap<P, DataObject[]> ret = new HashMap<P, DataObject[]>();
        for (DataObject d : dataObjects) {
            P propertyValue = propertyClass.cast(d.getPropertyValue(propertyName));
            Object[] data = (DataObject[])ret.get(propertyValue);
            if (data == null) {
                data = (DataObject[])Array.newInstance(d.getClass(), 0);
            }
            ret.put(propertyValue, (DataObject[])ArrayUtils.addToArray((Object[])data, (Object)d));
        }
        return ret;
    }
}

