/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.util.filter;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.anodoc.data.NoSuchPropertyException;
import net.anotheria.asg.data.DataObject;
import net.anotheria.asg.util.filter.DocumentFilter;
import net.anotheria.asg.util.filter.FilterTrigger;

public class AZDocumentFilter
implements DocumentFilter {
    private static List<FilterTrigger> triggerer = new ArrayList<FilterTrigger>();

    @Override
    public List<FilterTrigger> getTriggerer(String storedFilterParameter) {
        return triggerer;
    }

    @Override
    public boolean mayPass(DataObject document, String attributeName, String filterParameter) {
        if (filterParameter == null || filterParameter.length() == 0) {
            return true;
        }
        String propertyValue = null;
        try {
            propertyValue = "" + document.getPropertyValue(attributeName);
            return propertyValue.startsWith(filterParameter) || propertyValue.startsWith(filterParameter.toLowerCase());
        }
        catch (NoSuchPropertyException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        triggerer.add(new FilterTrigger("All", ""));
        for (int i = 65; i <= 90; ++i) {
            triggerer.add(new FilterTrigger("" + (char)i, "" + (char)i));
        }
    }
}

