/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.util.filter;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.anodoc.data.Document;
import net.anotheria.anodoc.data.NoSuchPropertyException;
import net.anotheria.anodoc.data.Property;
import net.anotheria.anodoc.util.context.ContextManager;
import net.anotheria.asg.data.DataObject;
import net.anotheria.asg.util.filter.DocumentFilter;
import net.anotheria.asg.util.filter.FilterTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MissingAnyTranslationFilter
implements DocumentFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MissingAnyTranslationFilter.class);
    private List<FilterTrigger> triggerer;
    private List<String> supportedLanguages;
    private String defaultLanguage;

    public MissingAnyTranslationFilter() {
        try {
            this.defaultLanguage = ContextManager.getCallContext().getDefaultLanguage();
            this.setSupportedLanguages(ContextManager.getCallContext().getSupportedLanguages());
        }
        catch (Exception e) {
            LOGGER.warn("CallContext can not be getted by ContextManager. Setting default language and supported languages to EN", (Throwable)e);
            this.setDefaultLanguage("EN");
            ArrayList<String> defaultSupportedLanguages = new ArrayList<String>();
            defaultSupportedLanguages.add("EN");
            this.setSupportedLanguages(defaultSupportedLanguages);
        }
    }

    public MissingAnyTranslationFilter(List<String> supportedLanguages, String defaultLanguage) {
        this.setDefaultLanguage(defaultLanguage);
        this.setSupportedLanguages(supportedLanguages);
    }

    @Override
    public List<FilterTrigger> getTriggerer(String storedFilterParameter) {
        return this.triggerer;
    }

    @Override
    public boolean mayPass(DataObject document, String attributeName, String filterParameter) {
        if (filterParameter == null || filterParameter.length() == 0) {
            return true;
        }
        if (!(document instanceof Document)) {
            return false;
        }
        boolean mayPass = false;
        try {
            List<Property> propertys = ((Document)((Object)document)).getProperties();
            boolean languageIsDefault = filterParameter.equals(this.defaultLanguage);
            for (Property property : propertys) {
                String propertyName = property.getId();
                int charIdx = propertyName.indexOf(95);
                if (charIdx == -1 || !propertyName.equals(propertyName.substring(0, charIdx + 1) + filterParameter) || property.getValue() != null && !property.getValue().toString().isEmpty()) continue;
                if (languageIsDefault) {
                    mayPass = true;
                } else {
                    String defaultLanguagePropertyValue = document.getPropertyValue(property.getId().replace("_" + filterParameter, "_" + this.defaultLanguage)).toString();
                    if (defaultLanguagePropertyValue.equals("null") || defaultLanguagePropertyValue.isEmpty()) continue;
                    mayPass = true;
                }
                break;
            }
        }
        catch (NoSuchPropertyException e) {
            mayPass = false;
        }
        catch (Exception e) {
            mayPass = false;
        }
        return mayPass;
    }

    public void setSupportedLanguages(List<String> supportedLanguages) {
        this.supportedLanguages = supportedLanguages;
        this.triggerer = new ArrayList<FilterTrigger>();
        this.triggerer.add(new FilterTrigger("All", ""));
        for (String language : supportedLanguages) {
            if (language.equals(this.defaultLanguage)) continue;
            this.triggerer.add(new FilterTrigger(language, language));
        }
    }

    public List<String> getSupportedLanguages() {
        return this.supportedLanguages;
    }

    public void setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }
}

